/*							dviout for Windows
 *
 *						  main part of previewer
 *						1996, written by SHIMA & Otobe
 */

#include <windows.h>   // Win32APIgp
#include <ddeml.h>	   // DDEMLCugp
#include <commctrl.h>  // Common Controls gp
#include <assert.h>	   // Using Assertion
#include <shellapi.h>  // Drag-Drop
#include <io.h>
#include <math.h>
// #include <shlwapi.h>	  // DllGetVersion() ...  VC 6.0 or later
#include <sys\stat.h>
#include <HtmlHelp.h>
#include "resource.h"  // ؿ`̧قǂݍ
#include "root.h"	   // ع݌ŗL̒萔
#include "stdio.h"
#include "dd.h"
#include "inter.h"
#include "err.h"
#include "dviadd.h"
#include "dviout0.inc"
#include "floatwnd.h"
#include "version.h"

// #define	USE_ETF		1
#define HYPER_2VERT	1

#define	DEF_COVER	0
#define	DEF_COVER2	1

#define	MAX_MACROSIZE 0x800

/* VC 6.0 <shlwapi.h> */
#define WSB_PROP_VSTYLE		0x00000100L
#define WSB_PROP_HSTYLE		0x00000200L

/* VC 6.0 <commctrl.h> */
#define FSB_ENCARTA_MODE		1

#define CUR_MOV		30		// cursor moves
#define CUR_STOP	10		// cursor does't move

#ifdef MSVC
#undef MAXINT
#define	MAXINT		0x7ffffff
#endif

#define	DEB_SRCSER	0		// debug source special with string search

/* loadpk.c */
FILE *fopenf(char *, char *);

/* pret.c */
extern char base_href[];
char *IsExec(char *);
int GetPause(int *, int *, int);
int CountDvioutInitialize(void);
int GetShiftInt(unsigned char *);
int GetPickString(int);

/* wmain.c */
void DisplayMessage(char *);
void ChangeLinkToReal(char *);
extern int draw_style;
extern int draw_color;
extern int PrevPage;

/* getfont.c */
void SetPropw(int);

/* epsbox.c */
BOOL bmp2bmc(char *, unsigned char *, int);

/* plug_in.c */
int open_xplugin(char *type, int depth);
int SavePicture(char *path, unsigned char *info, unsigned char *data, 
	int width, int height, int depth, char *msg);

/* misc.c */
char *marea(unsigned int);
char *Language(int);
char *FindFirstW32(char *);
char *FindNextW32(void);


/* ttfont.c */
BOOL MakeETF(void);
BOOL DeleteETF(int);
BOOL DisplayETF(void);

/* printbmp.c */
int VERdvipdfmx(void);

extern DVIWIN	 g_winData;
extern char		 g_szFileName[MAX_PATH];	  // dvi-file
extern char		 g_szFileName2[MAX_PATH];	  // 2nd dvi-file
extern char      g_szPrevFileName[MAX_PATH];  // Odvi-file
extern OPENFILENAME g_OpenFileName;			   // OPENFILENAME\
extern DDESTRUCT	g_ddeData;
extern short	  g_nxIndent;				// x̗]
extern short	  g_nyIndent;			   // y̗]

extern int g_cyToolBar;	 // the height of toolbar
extern int g_cyStatusBar; // the height of status bar
extern int g_cxSlider;	  // the width of slider
extern int g_cyShowMessage; // the height of showing message window

extern char ptex_mode;
extern int	f_init;
extern int	f_scr_skip;
extern int	gray_number;
extern UINT f_error;

extern char *log_file;
extern BOOL f_log;
extern int	f_prop;

extern BOOL f_HandMouse;
extern BOOL f_HandMoving;
extern BOOL f_Capturing;
extern BOOL f_ShowCursor;
extern int  f_CoverMoving;	// 1: Horizontal 2: Vertical
extern LOUPE g_loupe;
extern BOOL f_Loupe;
extern BOOL f_nploupe;
extern VIEWCTRL g_view;
extern int multi_dviout;
extern unsigned int ctr_loupe;
extern int CYSHOWMESSAGE;
extern int f_lcursor;
extern f_chkcolor;
extern BOOL f_startdviprt;

BOOL f_lcur_off;
int f_comctlversion;
int f_shellversion;
static POINT cur_pt;
#define	INIT_CUR_PT -0x1000

extern int f_GS;
extern BOOL f_gbox;
static int f_graphics;

extern int count_macro;
extern int count_src_special;
extern int count_hyper_special;
extern char *exec_gsrc_sp;

extern int OX;
extern int OY;

#define	WM_USR_HDIALOG	(WM_USER + 0x101)
#define	PAGE_MARK	MAX_H_HIST

FINDREPLACE fr;

static char szFind[MAX_FIND_LEN+1];
static char szFindOld[MAX_FIND_LEN+1];
static UINT FindDvi;
static UINT FindPage;
static int	FindPt;
static DWORD FindFlags;
static int f_hist_msg;
static int id_hist;
static int f_searching;
static int f_rpold = -1;
static int f_rpold2 = -1;

static unsigned int f_circle0;
static unsigned int l_diam0;
static int l_div0;

static BOOL f_seamless;
static BOOL f_CheckCover; // Check for f_coverP (On for Pause)
BOOL f_StopPaint;
BOOL f_coverP;			// On for Pause?
BOOL f_coverM;			// Move to Pause
int f_cover;			// Use cover sheet?
int f_coverH;			// 1:bottom 2:right 4:left
int f_coverB;			// 1:Left Button 2:Right Button
int cover_xpos;			// position measured by TEXT in PIXEL
int cover_ypos;
int f_FIT;				// use FIT/FULL in presentation mode
BOOL f_presenmenu;
int	f_pmenu;			// style of PresenMenu
static RECT pmenu;
static POINT pmenupt;
static BOOL f_pmshow;

BOOL f_flatscroll = FALSE;
int	 f_background; // 0: white 1: black 2: color 3: black back 4: white back
BOOL b_presentation_mode = FALSE;
BOOL f_dvioutspecial = TRUE;
BOOL f_srcspecial = TRUE;
BOOL f_hypertex = TRUE;
BOOL f_rev_movebutton; // 1: reverse move button.
BOOL f_DrawAnimationPointer = FALSE;
extern BOOL f_use_etf;
BOOL f_animecursor;
BOOL f_directsrc;
BOOL f_timer;
BOOL f_gedit;
int  f_secure;
BOOL f_Din;

BOOL f_rectcut;
RECT rectcut;

char *rectcut_org;
static RECT *inval;	/* region to be redraw, NULL means all the client region */
static BOOL f_cutedge;
static BOOL f_kill=FALSE;

char sz_autosave_template[MAX_PATH] = "^f.^3d";
static struct tagAUTOSAVEBMP
{
	BOOL f_autosavebmp;
	WORD f_bmp; // 0:BMP, 1:EMF. 2: BMC, (3:PNG  4:JPG ... for future??)
	char* sz_template;
} autosavebmp = {FALSE, 0, sz_autosave_template};

char waiting_macro[MAX_MACROSIZE];	// buffer to be executed for 'timer 'wait ;
int	waiting_macro_mode;
	// 0: key  1: dviout special  2: HyperTeX dviout special  3: DDE

extern BOOL f_pagebutton;
// add a menu item to switch the style.

BOOL f_m_down = 0;
BOOL f_l_down = 0;
BOOL f_Wshow;

#ifdef	DOUBLE_PAGE
int f_2page;
int last_bmp;
static int f_2top;
BYTE *pDib2;
BYTE *p2Page;
#define	IsSecondPage(x)	(((x)-f_2page)&F_ODD2EVEN)
#endif

FARPROC g_FlatSB_SetScrollRange = NULL;
FARPROC g_FlatSB_SetScrollPos = NULL;
FARPROC g_FlatSB_SetScrollProp = NULL;
FARPROC g_InitializeFlatSB = NULL;

char *browser;
char *exec_para;
int h_hist_n;
int h_hist_pt;
struct HyperHistory h_hist[MAX_H_HIST+2];

char *texhelp;

/* option.c */
void set_config(char *);

/* pret.c */
void do_special(char *);
extern BOOL f_grid;
extern BOOL f_gridO;
extern int w_grid;
extern RECT StopG0Rec; 
extern RECT StopG1Rec;

BOOL f_inch = TRUE;

/* inter.c */
void CoverChange(int);
void KeepCover(void);
void KeepCoverPos(void);
void RenewCover(void);
BOOL CoverSuspend(void);
int CoverReturn(void);
void KeepParaSpecial(char *);
void RestoreParaSpecial(void);
int GetS_Count(int);
int GetH_NamePos(POINT *, char *);
void MarkPoint(unsigned char*, int, int, int, int, unsigned char);
void JoinBoundigBox(RECT *, RECT *);
int CompBMP(unsigned char *, unsigned char *, RECT *);


/* prtinit.c */
int GetAddTotal(void);
int GetAddMemory(char *, char *, int);

/* wmain.c */
HFONT SetFont( float pt, HWND hwnd, const char* fontname, BOOL twobytes );
void ShowHyperLink( const char* href );
void SetMargin(HWND);

void Clear2Page(void);

/* tabctrl.c */
void AdjustPropPage( HWND hwnd );
BOOL CALLBACK DlgChgFontProc(HWND hwnd, UINT message, UINT wParam, LONG lParam);
char *print10mm(int);
extern char *para_paper[];

/* printbmp.c */
void CutEdge(int);

/* vfont.c */
void fttInfo(void);

static int IsMouseInDVIWindow( struct DVIINFO, POINT* );
static void SetPageMoveButtons( struct DVIINFO* w );
void InitMenuItems( void );
void InitCoverWindow( void );
static void AutoSaveBmp( void );
void AnimationPointer( struct DVIINFO *w, HWND hWndParent, HINSTANCE hInst, 
	int x, int y, BOOL fDraw );


struct SCALE {
	short int x;
	short int y;
	short int gamma;
};

#define	MAX_SCALE 4

struct SCALE scale[MAX_SCALE] =
{
	{4,4,800},
	{2,2,800},
	{6,6,800},
	{1,1,800}
};

/*
 * Called by  -sacle:  PROCEDURE
 */
void DefineScale(char *s)
{
	short num[3];
	int i, j;

	for(i = 0; i < MAX_SCALE && *s != 0; i++){
		for(j = 0; j < 3; j++){
			num[j] = (short)atoi(s);
			while(*s && *s++ != ':');
		}
		if(j < 3 || num[0] > 32 || num[1] > 32 || num[2] == 0)
			break;
		scale[i].x = num[0];
		scale[i].y = num[1];
		scale[i].gamma = num[2];
	}
}

/*
!0	ID_STOPOFF
!1	ID_STOPON
!2	ID_DINOFF
!3	ID_DINON
!A  ID_PAINTOFF
!B  ID_PAINTON
!C  ID_COVERRETURN
!D  ID_SCRDW
!E  ID_PAGEFOOT
!F  ID_DEFIT
!G  ID_BACKGROUND
!H  ID_PAGEHEAD
!I  ID_INITIALIZE
!J  ID_RELATEDVI
!K  ID_SETSTARTMENU
!L  ID_SCRLF
!M  ID_WINMAX
!N  ID_PRESENTOFF
!P  ID_PRESENTON
!Q  ID_ONEPAGE
!R  ID_SCRRT
!S  ID_COVERSUSPEND
!T	ID_RESCUTEDGE
!U  ID_SCRUP
!V  ID_TOREVERSE
!W  ID_TONORMAL
!X  ID_LEFTHOME
!Y  ID_RIGHTHOME
!Z  ID_CUTEDGE1
D1	ID_SCALE1
D2	ID_SCALE2
D3	ID_SCALE3 
D4	ID_SCALE4
D6  ID_16PAGE
DA	ID_LLITTLE
DB	ID_BLACKER
DC  ID_COLOR
DD	ID_LREDUCE
DE	ID_LBIG
DF	ID_FIT
DG	ID_LMAGNIFY
DH	ID_MHAND
DI  ID_GRAPHIC
DL	ID_FULL
DM	ID_MAGNIFY
DN	ID_RECTON
DO  ID_RDOUBLE
DP  ID_REPCOLOR
DR	ID_REDUCE
DS  ID_CROSS
DT  ID_DOUBLE
DU	ID_LMEASURE
DV	ID_REVERSE
DW	ID_WHITER
DX	ID_RECTREC 
DY	ID_VDOUBLE
F1  ID_FMENU1
FD  ID_DVIPRT
FH	ID_F_HISTORY
FN	ID_REOPEN
FO	ID_FILEOPEN
FP	ID_PRINT
FQ	ID_QUIT
FS	ID_SAVEIMG
FX	ID_APPEXIT
HA  ID_ABOUT
HB	ID_INFO_BUFFER
HF	ID_INFO_FONT
HH  ID_HELP_CONTENTS
HI	ID_INFO
HK	ID_INFO_KEY
HP	ID_INFO_PARA
HS  ID_INFO_SYS
J0	ID_50PAGE
J1	ID_m50PAGE
J2	ID_m20PAGE
J3	ID_m10PAGE
J4	ID_m5PAGE
J5	ID_m2PAGE
J6	ID_2PAGE
J7	ID_5PAGE
J8	ID_10PAGE
J9	ID_20PAGE
JB	ID_LASTPAGE
JD  ID_FOOTHEAD
JE	ID_DOWNPAG
JF	ID_FORMERHIST
JG	ID_GOMARK
JH	ID_P_HISTORY
JI	ID_EDITPAGE
JJ	ID_HYPERTEX
JL	ID_NEXTHIST
JM	ID_MARKPAGE
JN	ID_NEXTPAGE
JP	ID_PREVPAGE
JQ	ID_QUITHIST
JR	ID_MARKRANGE
JS  ID_LASTFILE
JT	ID_TOPPAGE
JU  ID_HEADFOOT
JV	ID_UPPAGE
JX	ID_EXMARK
N0	ID_DEFDEF
N1	ID_WHITEDEF 
N2	ID_BLACKDEF
N3	ID_WHITEBACK
N4	ID_BLACKBACK 
N5	ID_COVERB
N6	ID_COVERR
N7	ID_COVERL
N8	ID_COVERBR
N9	ID_COVERBL
NB	ID_DRBLUE
NC	ID_DRERACE
ND	ID_DRRED
NE  ID_CUTEDGE
NF	ID_COVEROFF
NG	ID_DRGREEN
NI	ID_DRLINE
NK	ID_DRBLACK
NL	ID_USELBUTTON
NN  ID_PRESENTATION
NO	ID_COVERON
NP	ID_COVERSHEET
NR	ID_USERBUTTON
NS  ID_SAVEPRESENT
NT	ID_DTHICK
NX	ID_DRBOX
O1	ID_MACRO1
O2	ID_MACRO2
O3	ID_MACRO3
O4	ID_MACRO4
O5	ID_MACRO5
OC  ID_SRCSPECIAL
OD  ID_DIFOPTION
OP  ID_PREPARA
OS	ID_OPTION	
OV  ID_DVIOUTSPECIAL
PL  ID_LANDSCAPE
SD  ID_NEXTCAND
SF  ID_SEARCH
SU  ID_PRECAND
V0  ID_FRAME0
VA	ID_INF_SMALL
VC  ID_TOOLBAR_CHANGE 
VE  ID_EDITOR_VIEW
VL	ID_INF_LARGE
VP  ID_SLIDER_VIEW
VR  ID_SCROLLBAR_VIEW 
VS  ID_STATUS_VIEW
VT  ID_TOOLBAR_VIEW
VU	ID_INF_MEDIUM
VV  ID_REVERSE_MOVEBUTTON
VW  ID_WARNING_VIEW
*/

enum {
	K_NULL,								// 0

	K_FO, K_FN, K_FH, K_FP, K_FX, K_FQ,

	K_JN, K_JE, K_JP, K_JV, K_JT, K_JB, K_JI,

	K_JH, K_JF, K_JL, K_JQ,
	K_JJ, K_JM, K_JG, K_JX, K_JR, 

	K_J1, K_J2, K_J3, K_J4, K_J5, 
	K_J6, K_J7, K_J8, K_J9, K_J0,		// 32

	K_SF, K_SU, K_SD,

	K_DM, K_DR, K_DF, K_DL, K_DB, K_DW, K_DV, 
	K_D1, K_D2, K_D3, K_D4, 
	K_DG, K_DD, K_DE, K_DA, K_DH,		// 51

	K_VT, K_VS, K_VP, K_VR, K_VC,

	K_HI, K_HF, K_HB, K_HK, K_HP, K_HA,

	K__H, K__E,							// 64
	
	K_VW, K_DC, K_DP, K_HH, K_FS, K_DI, K_F1, K_VE, 
	K_DT, K_DO, K_DS, K_D6,	 // 76

	K__U, K__D, K__L, K__R, // 80

	K_DU, K_JS, K_PL, K_O1, K_O2, K_O3, K_O4, K_O5,	// 88
	K_VL, K_VU, K_VA,	// 91

	K_NN, K__P, K__N, K_OV, K_NP, K_NO, // 97
    K_N0, K_N1, K_N2, K_N3, K_N4, K_N5, K_N6, K_N7, K_N8, K_N9,	// 107

	K_NF, K__S, K__C, K__I, 		// 111

	K__V, K__W, K_NS, K_NL, K_NR, K_VV, K_JU, K_JD,
	K__X, K__Y,	K__A, K__B, 	// 123

	K__G, K_OC, K_NE, K__Z, K__F, K_HS, K_DN, K_DY,
	K_NI, K_NX, K_NC, K_ND, K_NK, K_NB, K_NG, K__Q,		// 141

	K_OD, K_OS, K__T, K_D_, K_NT, K_OP, K__M, K_FD,		//149
	K__J, K__K, K_V0, K__0, K__1, K__2, K__3
};

struct KEY_TRANS {
//	char key[2];
	char key[3];
	char key2;
	unsigned int id;
};

// ! ABCDEFGHILMNOPRSUVWXY
static struct KEY_TRANS key_trans[] =
{
	{"^^", 0, 0},

	{"FO", 0, ID_FILEOPEN},  {"FN", 0, ID_REOPEN},     {"FH", 0, ID_F_HISTORY},
	{"FP", 0, ID_PRINT},	 {"FX", 0, ID_APPEXIT},    {"FQ", 0, ID_QUIT},

	{"JN", 0, ID_NEXTPAGE},  {"JE", 0, ID_DOWNPAGE}, 
	{"JP", 0, ID_PREVPAGE},  {"JV", 0, ID_UPPAGE},
	{"JT", 0, ID_TOPPAGE},	 {"JB", 0, ID_LASTPAGE},   {"JI", 0, ID_EDITPAGE},

	{"JH", 0, ID_P_HISTORY}, {"JF", 0, ID_FORMERHIST}, {"JL", 0, ID_NEXTHIST},
	{"JQ", 0, ID_QUITHIST},  {"JJ", 0, ID_HYPERTEX},      {"JM", 0, ID_MARKPAGE}, 
	{"JG", 0, ID_GOMARK},    {"JX", 0, ID_EXMARK},     {"JR", 0, ID_MARKRANGE},

	{"J1", 'O', ID_m50PAGE}, {"J2", 'O', ID_m20PAGE},  {"J3", 'O', ID_m10PAGE},
	{"J4", 'O', ID_m5PAGE},	 {"J5", 'O', ID_m2PAGE},
	{"J6", 'O', ID_2PAGE},	 {"J7", 'O', ID_5PAGE},	   {"J8", 'O', ID_10PAGE},
	{"J9", 'O', ID_20PAGE},	 {"J0", 'O', ID_50PAGE},

	{"SF", 0, ID_SEARCH},    {"SU", 0, ID_PRECAND},    {"SD", 0, ID_NEXTCAND},

	{"DM", 'S', ID_MAGNIFY}, {"DR", 'S', ID_REDUCE},   {"DF",'S', ID_FIT},
	{"DL", 'S', ID_FULL},
	{"DB", 'T', ID_BLACKER}, {"DW", 'T', ID_WHITER},   {"DV", 'T', ID_REVERSE},
	{"D1", 'R', ID_SCALE1},	 {"D2", 'R', ID_SCALE2},   {"D3", 'R', ID_SCALE3}, 
	{"D4", 'R', ID_SCALE4},	 {"DG", 'L', ID_LMAGNIFY}, {"DD", 'L', ID_LREDUCE},
	{"DE", 'L', ID_LBIG},	 {"DA", 'L', ID_LLITTLE},  {"DH", 0, ID_MHAND},

	{"VT", 0, ID_TOOLBAR_VIEW},	  {"VS", 0, ID_STATUS_VIEW}, 
	{"VP", 0, ID_SLIDER_VIEW },   {"VR", 0, ID_SCROLLBAR_VIEW}, 
	{"VC", 0, ID_TOOLBAR_CHANGE}, 

	{"HI", 'I', ID_INFO},	    {"HF", 'I', ID_INFO_FONT}, {"HB", 'I', ID_INFO_BUFFER},
	{"HK", 'I', ID_INFO_KEY}, {"HP", 'I', ID_INFO_PARA}, {"HA", 0, ID_ABOUT},

	{"!H", 0, ID_PAGEHEAD}, {"!E", 0, ID_PAGEFOOT},

	{"VW", 0, ID_WARNING_VIEW}, {"DC", 0, ID_COLOR},  {"DP", 0, ID_REPCOLOR},
	{"HH", 0, ID_HELP_CONTENTS},{"FS", 0, ID_SAVEIMG},{"DI", 0, ID_GRAPHIC},
	{"F1", 0, ID_FMENU1},   {"VE", 0, ID_EDITOR_VIEW},{"DT", 0, ID_DOUBLE},
	{"DO", 0, ID_RDOUBLE},    {"DS", 0, ID_CROSS},    {"D6", 0, ID_16PAGE}, 

	{"!U", 0, ID_SCRUP},      {"!D", 0, ID_SCRDW},    {"!L", 0, ID_SCRLF}, 
	{"!R", 0, ID_SCRRT},

	{"DU", 'L', ID_LMEASURE}, {"JS", 0, ID_LASTFILE}, {"PL", 0, ID_LANDSCAPE},
	{"O1", 'C', ID_MACRO1},	  {"O2", 'C', ID_MACRO2},   {"O3", 'C', ID_MACRO3},
	{"O4", 'C', ID_MACRO4},	  {"O5", 'C', ID_MACRO5},

	{"VL", 'I', ID_INF_LARGE}, {"VU", 'I', ID_INF_MEDIUM}, 
	{"VA", 'I', ID_INF_SMALL}, 

    {"NN", 0, ID_PRESENTATION}, 
    {"!P", 0, ID_PRESENTON},     {"!N", 0, ID_PRESENTOFF},
	{"OV", 0, ID_DVIOUTSPECIAL}, {"NP", 'C', ID_COVERSHEET},
	{"NO", 'C', ID_COVERON},
	
	{"N0", 'Y', ID_DEFDEF}, 	{"N1", 'Y', ID_WHITEDEF}, 
    {"N2", 'Y', ID_BLACKDEF},   {"N3", 'Y', ID_WHITEBACK},
    {"N4", 'Y', ID_BLACKBACK}, 

    {"N5", 'V', ID_COVERB},    {"N6", 'V', ID_COVERR},
    {"N7", 'V', ID_COVERL},    {"N8", 'V', ID_COVERBR},
    {"N9", 'V', ID_COVERBL},

	{"NF", 'C', ID_COVEROFF},  {"!S", 0, ID_COVERSUSPEND},
	{"!C", 0, ID_COVERRETURN}, {"!I", 0, ID_INITIALIZE},

	{"!V", 0, ID_TOREVERSE},   {"!W", 0, ID_TONORMAL},
	{"NG", 0, ID_SAVEPRESENT}, {"NL", 'B', ID_USELBUTTON},
	{"NR", 'B', ID_USERBUTTON}, {"VV", 0, ID_REVERSE_MOVEBUTTON},
	{"JU", 0, ID_HEADFOOT},	   {"JD", 0, ID_FOOTHEAD},

	{"!X", 0, ID_LEFTHOME},		{"!Y", 0, ID_RIGHTHOME},
	{"!A", 0, ID_PAINTOFF},		{"!B", 0, ID_PAINTON},
	{"!G", 0, ID_BACKGROUND},	{"OC", 0, ID_SRCSPECIAL},
	{"NE", 0, ID_CUTEDGE},		{"!Z", 0, ID_CUTEDGE1},
	{"!F", 0, ID_DEFIT},		{"HS", 0, ID_INFO_SYS},
	{"DN", 'G', ID_RECTON},		{"DY", 0, ID_VDOUBLE},

	{"NI",'D',ID_DRLINE},		{"NX",'D',ID_DRBOX},
	{"NC",'D',ID_DRERACE}, 		{"ND",'D',ID_DRRED},
	{"NK",'D',ID_DRBLACK},		{"NB",'D',ID_DRBLUE},
	{"NG",'D',ID_DRGREEN},		{"!Q", 0, ID_ONEPAGE},

	{"OD", 0, ID_DIFOPTION},	{"OS",0, ID_OPTION},	
	{"!T", 0, ID_RESCUTEDGE},	{"DX",'G',ID_RECTREC}, 
	{"NT",'D',ID_DTHICK},		{"OP", 0, ID_PREPARA},
	{"!M", 0, ID_WINMAX},		{"FD", 0, ID_DVIPRT},

	{"!J", 0, ID_RELATEDVI},	{"!K", 0, ID_SETSTARTMENU},
	{"V0", 0, ID_FRAME0},		{"!0", 0, ID_STOPOFF},
	{"!1", 0, ID_STOPON},		{"!2", 0, ID_DINOFF},
	{"!3", 0, ID_DINON},

	{"$$", 0, 1}, {"&&", 0, 1}
};

struct KEY_INFO {
	unsigned short int id;
	char *msg;
};


static struct KEY_INFO key_info[] =
{
	{K_JN, "Next Page\t\t: PgDn,"},
	{K_J6, "\t+2\t\t:"},
	{K_J7, "\t+5\t\t: SHIFT+SP, SHIFT+PgDn,"},
	{K_J8, "\t+10\t\t: CTRL+SP, CTRL+PgDn,"},
	{K_J9, "\t+20\t\t:"},
	{K_J0, "\t+50\t\t: CTRL+SHIFT+SP, CTRL+SHIFT+PgDn,"},

	{K_JP, "Previous Page\t\t: PgUp,"},
	{K_J5, "\t-2\t\t:"},
	{K_J4, "\t-5\t\t: SHIFT+BS, SHIFT+PgUp,"},
	{K_J3, "\t-10\t\t: CTRL+BS, CTRL+PgUp,"},
	{K_J2, "\t-20\t\t:"},
	{K_J1, "\t-50\t\t: CTRL+SHIFT+BS, CTRL+SHIFT+PgUp,"},

	{0x1000, "\n"},
	{K_JE, "Head of next page\t: SP, SHIFT+DownArrow,"},
	{K_JV, "Foot of previous page\t: BS, SHIFT+UpArrow,"},
	{K_JT, "Top Page\t\t: CTRL+Home,"},
	{K_JB, "Bottom Page\t\t: CTRL+End,"},
	{K_JD, "Down to next page\t:"},
	{K_JU, "Up to previous page\t:"},

	{0x1000, "\n"},
	{0x1000,"Scroll\t\t\t: Arrow Keys, Left Mouse Botton\n"},
	{K__U, " Scroll up\t\t: Up    Arrow"},
	{K__D, " Scroll down\t\t: Down  Arrow"},
	{K__L, " Scroll left\t\t: Left  Arrow"},
	{K__R, " Scroll right\t\t: Right Arrow"},
	{K__H, "Head of a Page\t\t: Home"},
	{K__E, "Foot of a Page\t\t: End"},
	{K__X, "Left of a Page\t\t:"},
	{K__Y, "Right of a page\t\t:"},

	{0x1000, "\n"},
	{K_JI, "Input Page Number\t:"},
	{0x1000, "  absolute\t\t:    <number>\n"},
	{0x1000, "  relative\t\t:    +<number>, -<number>\n"},
	{0x1000, "  from the bottom\t:    .[<number>]\n"},
	{0x1000, "    by page number\t:        Enter\n"},
	{0x1000, "    by nombre\t\t:        CTRL+Enter, SHIFT+Enter\n"},

	{0x1000, "\n"},
	{K_JH, "Page History list\t:"},
	{K_JF, "Former History\t\t:"},
	{K_JL, "Latter History\t\t:"},
	{K_JQ, "Quit History\t\t:"},
	{K_JM, "Mark page\t\t:"},
	{K_JG, "Goto Mark\t\t:"},
	{K_JX, "Exchange Mark\t\t:"},
	{K_JR, "Mark range\t\t:"},
	{K_FH, "File History list\t: ALT+I,"},
	{K_JS, "Last file\t\t:"},

	{0x1000, "\n"},
	{K_SF, "Dialog for Search\t:"},
	{K_SU, "Upward Search\t\t:"},
	{K_SD, "Downward Search\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Size\n"},
	{K_DM, " Magnify\t\t:"},
	{K_DR, " Reduce\t\t\t:"},
	{K_DF, " Fit\t\t\t:"},
	{K_DL, " Full\t\t\t:"},
	{K__M, "Maximize Window\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Preset\n"},
	{K_D1, " View 1\t\t\t:"},
	{K_D2, " View 2\t\t\t:"},
	{K_D3, " View 3\t\t\t:"},
	{K_D4, " View 4\t\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Contrast\n"},
	{K_DB, " Blacker\t\t:"},
	{K_DW, " Whiter\t\t\t:"},
	{K_DV, " Reverse\t\t:"},
	{K__V, "  To Reverse\t\t:"},
	{K__W, "  To Normal\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Loupe\t\t\t: Right Mouse Botton\n"},
	{K_DG, " Magnify\t\t:"},
	{K_DD, " Reduce\t\t\t:"},
	{K_DE, " Bigger\t\t\t:"},
	{K_DA, " Smaller\t\t:"},
	{K_DU, " Measure\t\t:"},

	{0x1000, "\n"},
	{K_DT, "two pages\t\t:"},
	{K_DO, "rev-two pages\t\t:"},
	{K_DY, "Y-two pages\t\t:"},
	{K_DS, "cross pages\t\t:"},
	{K_D6, "16 pages\t\t:"},
	{K__Q, "one page\t\t:"},

	{0x1000, "\n"},
	{K_PL, "Landscape\t\t:"},
	{K_DN, "Region\t\t\t:"},
	{K_D_, "Recover:\t\t:"},
	{K_DH, "Change Mouse\t\t: ALT+\\,"},
	{K_DI, "Graphics\t\t:"},
	{K_DC, "Color special\t\t:"},
	{K_DP, "Color replace\t\t:"},
	{K__0, "Stop off\t\t:"},
	{K__1, "Stop on\t\t\t:"},

	{0x1000, "\n"},
	{K_JJ, "HyperJump ON/OFF\t:"},
	{0x1000,"HyperJump\t\t: Left Mouse Botton\n"
			"     with inquiry\t:     + CTRL\n\n"},

	{K_FO, "Open File\t\t:"},
	{K_F1, "Open last file\t\t:"},
	{K_FN, "reNew File\t\t:"},
	{K__I, "reNew if necessary\t:"},
	{K_FP, "Print\t\t\t:"},
	{K_FD, "Dviprt\t\t\t:"},
	{K_FS, "Save as Image\t\t:"},
	{K_FX, "Exit & Save\t\t: ALT+X, ALT+F4,"},
	{K_FQ, "Quit\t\t\t:"},

	{0x1000, "\n"},
	{0x1000, "View\n"},
	{K_VT, " Tool bar\t\t:"},
	{K_VS, " Status bar\t\t:"},
	{K_VP, " Page slider\t\t:"},
	{K_VR, " Scroll bar\t\t:"},
	{0x1000, " Erace bars\t\t: [V0]"},
	{K_VV, " Reverse Move Button\t:"},
	{K_VW, " Show Warning\t\t:"},
	{K_VC, " Change Tool Buttons\t:"},
	{K_VE, " Small Editor\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Presentation\n"},
	{K_NN, "On/Off switch\t\t:"},
	{K__P, " Presentation On\t:"},
	{K__N, " Presentation Off\t:"},
	{K_NS, "Save settings\t\t:"},
	{K__A, " Stop Draw\t\t:"},
	{K__B, " Recover Draw\t\t:"},
	{K_NE, "Cut edge On/Off\t\t:"},
	{K__Z, "Cut edge On\t\t:"},
	{K__T, "Cut edge Off\t\t:"},
	{K__F, "Quit Fit/Full\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Mouse Button to proceed\n"},
	{K_NL, " Use left button\t:"},
	{K_NR, " Use right button\t:"},

    {0x1000, "\n"},
	{0x1000, "Presentation type\n"},
    {K_N0, " general screen\t\t:"},
    {K_N1, " white screen\t\t:"},
    {K_N2, " black screen\t\t:"},
    {K_N3, " white back\t\t:"},
    {K_N4, " black back\t\t:"},
    {K__G, " renew background\t:"},
	{K_NI, " Draw line\t\t:"},
	{K_NX, "   box\t\t\t:"},
    {K_NC, "   erace\t\t:"},
    {K_ND, "   red\t\t\t:"},
    {K_NK, "   black\t\t:"},
    {K_NB, "   blue\t\t\t:"},
	{K_NG, "   green\t\t:"},
	{K_NT, "   thick\t\t:"},

	{0x1000, "\n"},
	{0x1000, "Cover sheet\n"},
	{K_NO, " On\t\t\t: Fn5(Presentation)"},
	{K_NF, " Off\t\t\t: Fn6(Presentation)"},
	{K_NP, " On for Pause\t\t: Fn9(Presentation)"},
	{K__S, " Supspend Cover sheet\t: Fn7(Rresentation)"},
	{K__C, " Return to Cover sheet\t: Fn8(Presentation)"},

    {0x1000, "\n"},
	{0x1000, "Cover type\n"},
	{K_N5, "  bottom\t\t:"},
	{K_N6, "  right\t\t\t:"},
	{K_N7, "  left\t\t\t:"},
    {K_N8, "  bottom + right\t:"},
    {K_N9, "  bottom + left\t\t:"},

	{0x1000, "\n"},
	{K_O1, "Macro 1\t\t\t:"},
	{K_O2, "Macro 2\t\t\t:"},
	{K_O3, "Macro 3\t\t\t:"},
	{K_O4, "Macro 4\t\t\t:"},
	{K_O5, "Macro 5\t\t\t:"},

	{0x1000, "\n"},
	{K_OV, "dviout special ON/OFF\t:"},
	{K_OC, "source special ON/OFF\t:"},
	{K__2, "Copy to Editor with CTRL\t:"},
	{K__3, "Copy to Editor without CTRL\t:"},

	{0x1000, "\n"},
	{K_HH, "Online Help\t\t:"},
	{K_HI, "Screen/File Info\t:"},
	{K_HF, "Font Info\t\t:"},
	{K_HB, "Buffer Info\t\t:"},
    {K_HS, "System Info\t\t:"},
	{K_HP, "Parameter Info\t\t:"},
	{K_OD, "Non-default Parameters\t:"},
	{K_OS, "Setup Parameters\t:"},
	{K_OP, "Choose Parameters\t:"},
	{K_HK, "Key table\t\t:"},
	{K_HA, "About dviout\t\t:"},
	{K_NULL, ""}
};

#define	USER_KEY		6
#define	MAX_KEYDEF		(0x80+12+12+USER_KEY)

char *key_macro;
unsigned char org_key_table[MAX_KEYDEF];

static unsigned char key_table[MAX_KEYDEF] =
{
//	   @,	A,	 B,	  C,   D,	E,	 F,	  G		+CTRL
	   0,	0,K_JB,K_DC,K_FD,	0,K_SF,K_JG,

//	   H,	I,	 J,	  K,   L,	M,	 N,	  O		+CTRL
	   0,	0,K_JH,   0,K_OP,	0,K_FN,K_FO,

//	   P,	Q,	 R,	  S,   T,	U,	 V,	  W		+CTRL
	K_FP,K_HS,K_SU,K_SD,K_JT,K__0,K__1,	  0,

//	   X,	Y,	 Z,	  [,   \,	],	 ^,	  _		+CTRL
	K_JX,	0,	 0,K_DN,K_OS,	0,	 0,   0,

//	  SP,	!,	 ",   #,   %,   $,   &,   '
	   0,	0,	 0,	  0,   0,	0,	 0,	  0,

//	   (,	),	 *,	  +,	,	-,	 .,	  /
	   0,	0,	 0,	  0,   0,	0,	 0,K_JI,

//	   0,	1,	 2,	  3,   4,	5,	 6,	  7
	   K_DY,K_D1,K_D2,K_D3,K_D4,K_DF,K_DL,K_DT,

//	   8,	9,	 *,	  ;,   <,	=,	 >,	  ?
	   K_DS,K_D6,0,	  0,K_JF,	0,K_JL,	  0,

//	   @,	A,	 B,	  C,   D,	E,	 F,	  G
	   0,	0,	 0,	  0,K_JD,	0,K_JF,	  0,

//	   H,	I,	 J,	  K,   L,	M,	 N,	  O
	   0,	0,	 0,	  0,K_JL,K_JM,K_JN,	  0,

//	   P,	Q,	 R,	  S,   T,	U,	 V,	  W
	K_JP,K_JQ,K_JR,	  0,   0,K_JU,	 0,	  0,

//	   X,	Y,	 Z,	  [,   \,	],	 ^,	  _
	   0,	0,	 0,	  0,   0,	0,	 0,	  0,

//	   `,	a,	 b,	  c,   d,	e,	 f,	  g
	   0,	0,	 0,	  0,K_JD,	0,K_JF,	  0,

//	   h,	i,	 j,	  k,   l,	m,	 n,	  o
	   0,	0,	 0,	  0,K_JL,K_JM,K_JN,	  0,

//	   p,	q,	 r,	  s,   t,	u,	 v,	  w
	K_JP,K_JQ,K_JR,	  0,   0,K_JU,	 0,	  0,

//	   x,	y,	 z,	  {,   |,	},	 ~,
	   0,	0,	 0,	  0,   0,	0,	 0,	  0,

//	  F1,  F2,	F3,	 F4,  F5,  F6,	F7,	 F8,
	  K_HH, 0,K_SD,	  0,   0,	0,	 0,	  0,

//	  F9, F10,	F11, F12
	   0,	0,	 0,	  0,

//	 SF1, SF2, SF3, SF4, SF5, SF6, SF7, SF8,
	 K_O1,K_O2,K_SU,  0,K_O3,K_O4,K_O5,	  0,

//	 SF9, SF10,SF11,SF12,Button,U1, U2,	 U3,
	   0,	0,	 0,	  0,   0,	0,	 0,	  0,

//	  U4,  U5
	   0,	0
};

static void ModifyMenuString(int ch, int mode)
{
	char msg[0x80], *pt;
	int code, id;

	if(key_table[ch] != org_key_table[ch] && (!mode || key_table[ch])){
		code = mode?key_table[ch]:org_key_table[ch];
		id = key_trans[code].id;
		if(mode && !isalpha(key_trans[code].key[0]))
			return;
		GetMenuString(g_winData.hMenu, id, msg, 0x80, MF_BYCOMMAND);
		for(pt = msg; *pt && *pt != '\t'; pt++);
		if(mode){
			if(*pt == '\t')
				return;
			if(ch < 0x20){
				sprintf(pt, "\tCtrl+%c", ch+0x40);
				goto set;
			}else if(ch >= 0x21 && ch < 0x7f){
				sprintf(pt, "\t%c", ch);
				goto set;
			}else if(ch >= 0x80 && ch < (0x80+12)){
				sprintf(pt, "\tF%d", ch-0x7f);
				goto set;
			}else if(ch >= (0x80+12) && ch < (0x80+24)){
				sprintf(pt, "\tShift+F%d", ch-(0x80+11));
				goto set;
			}
		}else if(*pt == '\t'){
			*pt = 0;
set:		ModifyMenu(g_winData.hMenu, id, MF_BYCOMMAND|MFT_STRING, id, msg);
		}
	}
}

void ArrangeMenuString(void)
{
	int i;

	const short int menu_key[] = {			// pre-defined default
		0x03, 0x04, 0x06, 0x07, 0x0a, 0x0c, 0x0e, 0x0f, 
		0x10, 0x11, 0x18, 0x1b, 0x1c, 
		'1', '2', '3', '4', '5', '6',
		'<', '>', '/', 
		'd', 'u', 'q', 'm', 'r', 
		0x80, 0x82, 0x8c, 0x8d, 0x8e, 0x90, 0x91, 0x92,
		0
	};

	for(i = 0; menu_key[i]; )
		ModifyMenuString(menu_key[i++], 0);
	for(i = 1; i < (0x80+24); i++)
		ModifyMenuString(i, 1);
}

void ReserveKeyTable(void)
{
	memmove(org_key_table, key_table, MAX_KEYDEF);
}


void PrintKeyTable(char *tmp, int mode)
{
	int pos, len, len0, id;

	if(mode > 0){
		strcpy(tmp, "key=$$");
		len = 6;
	}else
		len = 0;
	for(pos = len0 = 0; pos < MAX_KEYDEF; pos++){
		if((id = key_table[pos]) != 0 || !mode){
			if(!mode && id == org_key_table[pos])
				continue;
			if(len && len - len0 < 80){
				sprintf(tmp+len, ":%c%c=", 
					key_trans[id].key[0], key_trans[id].key[1]);
				len += 4;
			}else if(mode >= 0){
				len0 = len;
				sprintf(tmp+len, (len)?"\nkey=%c%c=":"key=%c%c=", 
					key_trans[id].key[0], key_trans[id].key[1]);
				len += 8;
				if(len == 8)
					len--;
			}else{
				sprintf(tmp+len, "%c%c=", 
					key_trans[id].key[0], key_trans[id].key[1]);
				len += 3;
			}
			if(pos > 0x20 && pos < 0x7f && pos != 0x5c && pos != 0x5e){
				tmp[len++] = pos;
			}else if(pos < 0x20){
				tmp[len++] = '^';
				tmp[len++] = pos + 0x40;
			}else{
				sprintf(tmp+len, "\x5c%2x", pos);
				len += 3;
			}
		}
	}
	tmp[len] = 0;
}

static char NullKey[] =
{
	0x00, 0x20, 'H' - 0x40, 'I' - 0x40, 'M' - 0x40, 0x1f
};

void DefineKeyTable(unsigned char *s)
{
	unsigned char *data;
	int	i, ch, k;
	struct KEY_TRANS *trans;

	data = s;
	while(data[0] && data[1]){
		trans = &(key_trans[0]);
		k = 0;
		do{
			if(trans->key[0] == data[0] && trans->key[1] == data[1]){
				if(*data == '$'){
					for(i = 0; i < MAX_KEYDEF; i++)
						key_table[i] = 0;
					data += 3;
					if(!*(data-1))
						goto end;
					goto nxt;
				}
				data += 2;
				while(1){
					if(!*data || !*++data) goto end;
					if(*data == '\\'){
						if(!*++data) goto err;
						if(*data == '\\' || *data == '^')
							goto dk;
						if(*data == '&' && data[1] ){
							data++;
							i = 0x80 + 12 + 12;
							goto fkey;
						}
						if(*data == '$'){
							i = 0x80+12;
							goto fkey;
						}
						if(*data == '#'){
							i = 0x80;
fkey:						if((ch = *++data) <= 9){
								ch -= '0';
							}else
								ch = (ch | 0x20) - ('a') - 10;
							if(ch <= 0 || ch > 12)
								goto err;
							ch += i;
							goto c_key;
						}
						if((ch = *data++) <= '9')
							ch -= '0';
						else
							ch = (ch | 0x20) - ('a' - 10);
						ch = ch * 16 + *data;
						if(*data <= '9')
							ch -= '0';
						else
							ch = (ch | 0x20) - ('a' - 10);
						if(!*data || ch < 0 || ch >= MAX_KEYDEF)
							goto err;
c_key:					for(i = 0; i < sizeof(NullKey); i++){
							if(NullKey[i] == ch)
								break;
						}
						if(i == sizeof(NullKey))
							key_table[ch] = (unsigned char)k;
					}else if(*data == '^'){
						if(isalpha(data[1]) || (data[1] >= 0x40 && data[1] < 0x60)){
							ch = toupper(*++data) - 0x40;
							goto c_key;
						}
						key_table['^'] = (unsigned char)k;
					}else if(*data < 0x80)
dk:						key_table[*data] = (unsigned char)k;
					if(data[1] == ':'){
						data += 2;
						goto nxt;
					}
				}
			}
			trans++;
			k++;
		}while(trans->key[0] != '&');
err:
	error(ILLEGAL_ARGS, "-key=%s\n", s);
	goto end;
nxt:;
	}
end:;
}

void CheckMenu(UINT id, BOOL f)
{
	CheckMenuItem( g_winData.hMenu, id, 
		(f)?(MF_BYCOMMAND|MF_CHECKED):(MF_BYCOMMAND|MF_UNCHECKED));
}

void CheckMenuSet(UINT id, UINT ida, UINT idb)
{
//	unsigned int i;

	CheckMenuRadioItem( g_winData.hMenu, ida, idb, id, MF_BYCOMMAND);
/*
	for(i = ida; i <= idb; i++){
		CheckMenuItem( g_winData.hMenu, i, 
			(id==i)?(MF_BYCOMMAND|MF_CHECKED):(MF_BYCOMMAND|MF_UNCHECKED));
	}
*/
}

void CheckReverse(int gray)
{
	CheckMenu(ID_REVERSE, gray<0);
}

void CheckPropw(BOOL mode)
{
	CheckMenu(ID_INFO_PROPW, mode);
}

static char *hist_msg[] =
{
	"",
	"-> History",
	"-> Search",
	"-> HyperJump",
	"-> Mark",
};

enum {
	F_HM_NULL = 0,
	F_HM_HISTORY,
	F_HM_SEARCH,
	F_HM_HYPERJUMP,
	F_HM_MARK,
};

UINT	f_s_color = F_B_REDC;	/* red character */
//UINT	f_h_color = F_B_SKY;	/* light blue box */
UINT	f_h_color = 0x18060; /* change the default to blue char with ul.
 1999/11/3 by Y.OTOBE, see GetDColor() func. in tabctrl.c for detail. */

#define FreeBmp(x)	free_bmp(x - sizeof(BITMAPFILEHEADER))

void ShowBox(BYTE *pDib, struct S_BOX *box, int total, int mode)
{
	while(total-- > 0)
		ColorS_Box(pDib, box++, mode);
}

unsigned int KeyId(char *key)
{
	int	code;

	for(code = 0; key_trans[code].key[0] != '&'; code++){
		if(	 key_trans[code].key[0] == key[0]
		  && key_trans[code].key[1] == key[1] )
		return key_trans[code].id;
	}
	return 0;
}

static void ShowKey(int code, char *msg)
{
	int	j;

	if(key_trans[code].key[0] == '!')
		error(C_MSG, "%s [%c%c]", 
			msg, key_trans[code].key[0], key_trans[code].key[1]);
	else{
		error(C_MSG, "%s ALT+%c%c%c [%c%c]", msg, key_trans[code].key[0],
			(key_trans[code].key2)?key_trans[code].key2:' ',
			key_trans[code].key[1],
			key_trans[code].key[0], key_trans[code].key[1]);
	}
	for(j = 0; j < MAX_KEYDEF; j++){
		if(key_table[j] == code){
			if(j < 0x20)
				error(C_MSG, ",  CTRL+%c", j|0x40);
			else if(j == 0x7f)
				error(C_MSG, ",  \\%02x", j);
			else if(j == MAX_KEYDEF - USER_KEY)
				error(C_MSG, ", Button");
			else if(j > MAX_KEYDEF - USER_KEY)
				error(C_MSG, ",  User%c", j	 +	('0' - MAX_KEYDEF + USER_KEY));
			else if(j >= 0x80+12)
				error(C_MSG, ",  SFn%d", j - (0x7f+12));
			else if(j >= 0x80)
				error(C_MSG, ",  Fn%d", j - 0x7f);
			else
				error(C_MSG, ",  %c", j);
		}
	}
	error(C_MSG, "\n");
}

static void DisplayKeyInfo(void)
{
	struct KEY_INFO *key;

	for(key = key_info; key->id != K_NULL; key++){
		if(key->id & 0x1000)
			error(C_MSG, "%s", key->msg);
		else
			ShowKey(key->id, key->msg);
	}
	error(DATATITLE, "Key table");
}

static void PrintChar(char *sz_Key, int code)
{
	if(code < 0x20)
		sprintf(sz_Key, "CTRL+%c ",code + 0x40);
	else if(code == 0x20)
		strcpy(sz_Key,	"Space  ");
	else if(code == 0x7f)
		strcpy(sz_Key,	"DEL    ");
	else if(code == MAX_KEYDEF - USER_KEY)
		strcpy(sz_Key,	"Button ");
	else if(code > MAX_KEYDEF - USER_KEY)
		sprintf(sz_Key, "User%1d ", code - (MAX_KEYDEF - USER_KEY)); 
	else if(code >= 0x80+12)
		sprintf(sz_Key, "SFn%2d  ", code - (0x7f+12));
	else if(code >= 0x80)
		sprintf(sz_Key, "Fn%2d   ", code - 0x7f);
	else
		sprintf(sz_Key,"%c      ", code);
}

static void DeTab(char *sz_Key, char *s, int len)
{
	int pos;

	len -= 9;
	for(pos = 0; pos < len; ){
		if(!(sz_Key[pos] = *s++) || sz_Key[pos] == '\n')
			break;
		if(sz_Key[pos++] == '\t'){
			sz_Key[pos-1] = ' ';
			while(pos & 7)
				sz_Key[pos++] = ' ';
		}
	}
	sz_Key[pos] = 0;
}

static void ModifyKeyTable( HWND hDlg, int code, int idx)
{
	int pos;
	char sz_Key[256];

	PrintChar(sz_Key, code);
	if(idx == 0){
		if(key_table[code] == 0)
			return;
		idx = key_table[code];
		key_table[code] = 0;
	}else{
		ModifyKeyTable(hDlg, code, 0);		/* Clear definition */
		key_table[code] = idx;
		sprintf(sz_Key+7, "[%c%c]", 
			key_trans[idx].key[0],key_trans[idx].key[1]);
	}

	SendDlgItemMessage(hDlg, IDC_COMBOBOX1, CB_DELETESTRING, code, 0);
	SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
		CB_INSERTSTRING, code, (LPARAM)sz_Key);
	SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
		CB_SETCURSEL, code, 0);

	for(pos = 0; key_info[pos].id != K_NULL; pos++){
		if(key_info[pos].id == idx){
			ShowKey(idx, key_info[pos].msg );
			SendDlgItemMessage(hDlg, IDC_LISTBOX1, LB_DELETESTRING, pos, 0);
			DeTab(sz_Key, GetMessagePtr(), 256);
			ResetMessagePtr();
			SendDlgItemMessage(hDlg, IDC_LISTBOX1, 
				LB_INSERTSTRING, pos, (LPARAM)sz_Key);
			SendDlgItemMessage(hDlg, IDC_LISTBOX1, LB_SETCURSEL, pos, 0);
			break;
		}
	}
}

void LoadKeyTable(void)
{
	int i;

	RestoreBinary( key_table, MAX_KEYDEF, "KeyTable", "Key", 0 );
	for(i = 0; i < sizeof(NullKey); i++)
		key_table[NullKey[i]] = 0;
}

unsigned int GetUserKey(int num)
{
	if(num < 0)
		return USER_KEY;
	if(num >= USER_KEY)
		return 0;
	return key_trans[key_table[MAX_KEYDEF-USER_KEY+num]].id;
}

char *GetUserInfo(int idx)
{
	int pos, posd;
	static char toolmsg[32];
	int pt = 0;

	while(key_info[pt].id != K_NULL){
		if(key_trans[key_info[pt].id].id != idx){
			pt++;
			continue;
		}
		pos = (key_info[pt].msg[0] == '\t')?1:0;
		if(key_info[pt].msg[pos] <= ' ')
			return NULL;
		for(posd = 0; posd < 31; ){
			if( (toolmsg[posd++] = key_info[pt].msg[pos++]) < ' '){
				break;
			}
		}
		toolmsg[posd-1] = 0;
		return toolmsg;
	}
	return NULL;
}

// *******  New Draw Line ******
unsigned char *pDibPen;
int PenWidth = 0;
int PenType = 0x0f; 
BOOL f_Pen = FALSE;
BOOL f_KeepDraw = FALSE;
 // 0x0f Black
 // 0x9f(blue), 0xaf(green),  0xbf(cyan), 0xcf(red), 0xdf(magenta), 0xef(yellow)
static unsigned char LineColor[16] =
{0xcf, 0x0f, 0x9f, 0xaf, 0xc4, 0x00, 0x94, 0xa4,
 0xb0, 0x00, 0xe0, 0xd0, 0xb9, 0xff, 0xe9, 0xd9};

static int PenTdata[5] = {0x0f, 0x0b, 0x08, 0x04, 0x02};

static void CheckPenBuf()
{
	if(pDibPen && !f_KeepDraw){
		FreeBmp(pDibPen);
		pDibPen = NULL;
	}
	f_KeepDraw = FALSE;
}

static BOOL DrawLine(unsigned char *pDib, int x, int y, int xx, int yy, int count, unsigned char attr)
{
	unsigned char *pt;
	WORD cxDib, cyDib;
	int px, py, pxx, pyy, wx, wy, ct, count1, count2;

	if(  pDib == NULL
	  || ((BITMAPINFOHEADER*)pDib)->biBitCount != 8			/* 256 color? */
	  || ((BITMAPINFOHEADER*)pDib)->biCompression != BI_RGB	/* compressed? */
	)
		return FALSE;
	cxDib = (WORD)((BITMAPINFOHEADER*)pDib)->biWidth;
	wx = (cxDib+3)&~3;
	cyDib = (WORD)((BITMAPINFOHEADER*)pDib)->biHeight;
	wy = cyDib-1;
	pDib += sizeof(BITMAPINFOHEADER) + 4*256;
	ct = 0;
	if(abs(xx) >= wx || abs(yy) >= wy)
		return FALSE;
#if 0
	pt = pDib + wx*(wy - y)+x;
	*pt |= 0xf;
#else
	count1 = count/2;
	count2 = (count+1)/2;
	if(abs(xx) >= abs(yy)){
		while(xx){
			pxx = x + ct;
			pyy = y + (yy*ct/xx);
			for(py = pyy - count2; py <= pyy + count1; py++){
				pt = pDib+wx*(wy-py);
				for(px = pxx-count1; px <= pxx+count2; px++){
					if(px >= 0 && px < cxDib && py >=0 && py < cyDib)
						pt[px] = attr;
				}
			}
			if(ct == xx)
				break;
			if(xx > 0)
				ct++;
			else
				ct--;
		}
	}else{
		while(1){
			pyy = y + ct;
			pxx = x + (xx*ct/yy);
			for(py = pyy - count2; py <= pyy + count1; py++){
				pt = pDib+wx*(wy-py);
				for(px = pxx-count1; px <= pxx+count2; px++){
					if(px >= 0 && px < cxDib && py >=0 && py < cyDib)
						pt[px] = attr;
				}
			}
			if(ct == yy)
				break;
			if(yy > 0)
				ct++;
			else
				ct--;
		}
	}
#endif
	return TRUE;
}


static BOOL CALLBACK AutoSaveDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	HWND hTemplateWnd = (HWND)GetDlgItem( hdwnd, IDC_EDIT_AUTOSAVE_TEMPLATE );
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam))
			{
				case IDOK:
					GetWindowText( hTemplateWnd, autosavebmp.sz_template, MAX_PATH );
					if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_BMP) == BST_CHECKED )
						autosavebmp.f_bmp = 0;
					else if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_EMF) == BST_CHECKED )
						autosavebmp.f_bmp = 1;
					else if( IsDlgButtonChecked(hdwnd,IDC_RADIO_SAVE_AS_BMC) == BST_CHECKED )
						autosavebmp.f_bmp = 2;
				case IDCANCEL:
					EndDialog(hdwnd, LOWORD(wParam));
					return TRUE;
				case ID_MYHELP:
					ShowWinHelp(IDH_AUTOSAVE);
					return TRUE;
			}
			break;

		case WM_INITDIALOG:
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_EDIT_AUTOSAVE_TEMPLATE));
			CheckRadioButton( hdwnd, IDC_RADIO_SAVE_AS_BMP, IDC_RADIO_SAVE_AS_EMF,
				IDC_RADIO_SAVE_AS_BMP + autosavebmp.f_bmp );
			SetWindowText( hTemplateWnd, autosavebmp.sz_template );
			return TRUE;
		
		case WM_DESTROY:
			break;
		
	}
	return FALSE;
}

LRESULT CALLBACK KeyTabProc( HWND hDlg, UINT message, 
									WPARAM wParam, LPARAM lParam )
{
	void InitTabString(HWND hwnd, char *key, int id);
	void SetTabString(HWND hwnd, char *key, int id);
	void RestoreTabString(HWND hwnd, char *key, int id);
	void ReserveTabString(HWND hwnd, char *key, int id);
#define	INIT_APPLY	0x1000

	int code, idx, pos, ret_val;
	struct KEY_INFO *key;
	char *s;
	char sz_Key[256];
	static char *sz_Org;
	static UINT f_change;
	static DWORD help[] ={
		IDC_KDEF, IDH_KEYDEFINE,
		IDC_KCLEAR, IDH_KEYCLEAR,
		IDC_KSEARCH, IDH_KEYSEARCH,
		ID_ALLCLEAR, IDH_KEYALLCLEAR,
		IDC_LISTBOX1, IDH_KEYFUNCTION,
		IDC_COMBOBOX1,IDH_KEYKEY,
		IDC_DEFAULT, IDH_DEFAULT,
		IDC_MACRO,	IDH_MACRO,
		0, 0
	};
	static HWND hedit;
	extern int f_DlgQuery;

	switch( message )
	{
		case WM_INITDIALOG:
			f_change = INIT_APPLY;
			if(sz_Org)
				GlobalFree(sz_Org);
			InitTabString(hDlg, "macro", IDC_MACRO);
			sz_Org = GlobalAlloc( GPTR, MAX_KEYDEF );
			memcpy( sz_Org, key_table, MAX_KEYDEF);
start:		ret_val = TRUE;
cancel:		for(code = 0; code < MAX_KEYDEF; code++){
				PrintChar(sz_Key, code);
				if((idx = key_table[code]) != 0)
					sprintf(sz_Key+7, "[%c%c]",
						key_trans[idx].key[0],key_trans[idx].key[1]);
				SendDlgItemMessage(hDlg, IDC_COMBOBOX1, CB_ADDSTRING, 0,
						(LPARAM)sz_Key);
			}

			for(key = key_info; key->id != K_NULL; key++){
				if(key->id & 0x1000)
					error(C_MSG, "%s", key->msg);
				else
					ShowKey(key->id, key->msg );
				s = GetMessagePtr();
				DeTab(sz_Key, s, 256);
				ResetMessagePtr();
				SendDlgItemMessage(hDlg, IDC_LISTBOX1, LB_ADDSTRING, 0,
						(LPARAM)sz_Key);
			}
			SendDlgItemMessage(hDlg, IDC_LISTBOX1, LB_SETHORIZONTALEXTENT,
				1024, 0);
			if(f_change & INIT_APPLY)
				f_change = 0;
			return ret_val;

		case WM_COMMAND:
			switch( wParam )
			{
				case IDC_DEFAULT:
					memmove(key_table, org_key_table, MAX_KEYDEF);
					s = GetParaStringDefault("macro");
					if(s)
						SetDlgItemText(hDlg, IDC_MACRO, s);
					goto reset;

				case ID_RESTORE:
					RestoreBinary( key_table, MAX_KEYDEF, "KeyTable", 
						"Key", 0 );
					RestoreTabString(hDlg, "macro", IDC_MACRO);

reset:				SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
						CB_RESETCONTENT, 0, 0L);
					SendDlgItemMessage(hDlg, IDC_LISTBOX1, 
						LB_RESETCONTENT, 0, 0L);
					PropSheet_Changed( GetParent(hDlg), hDlg );
					ApplyOn( hDlg, &f_change );
					f_change |= 1;
					goto start;

				case ID_SAVE:
					ReserveBinary( "KeyTable", "Key", key_table, MAX_KEYDEF );
					ReserveTabString(hDlg, "macro", IDC_MACRO);
					MessageSaved(hDlg);
					break;

				case IDC_KCLEAR:		/* clear def  */
					code = SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
						CB_GETCURSEL, 0, 0L);
					if(code == CB_ERR){
cb_err:					ShowMessage("No key is selected",NULL,
							SM_OKCONT);
						break;
					}
					ModifyKeyTable(hDlg, code, 0);
change:				PropSheet_Changed( GetParent(hDlg), hDlg );
					ApplyOn( hDlg, &f_change );
					f_change |= 1;
					break;

				case ID_ALLCLEAR:
					for(pos = 0; pos < MAX_KEYDEF; pos++)
						key_table[pos] = 0;
					ret_val = TRUE;
clear:				SendDlgItemMessage(hDlg, IDC_COMBOBOX1,CB_RESETCONTENT,
						0, 0);	
					SendDlgItemMessage(hDlg, IDC_LISTBOX1, LB_RESETCONTENT,
						0, 0);
					ApplyOn( hDlg, &f_change );
					f_change |= 1;
					goto cancel;

				case IDC_KDEF:		/* define def */
					code = SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
						CB_GETCURSEL, 0, 0L);
					if(code == CB_ERR)
						goto cb_err;
					for(pos = 0; pos < sizeof(NullKey); pos++){
						if(NullKey[pos] == code){
							ShowMessage("This Key: cannot be selected",NULL,
								SM_OKCONT);
							return FALSE;
						}
					}
					pos = SendDlgItemMessage(hDlg, IDC_LISTBOX1, 
						LB_GETCURSEL, 0, 0L);
					if(pos == LB_ERR){
						ShowMessage("No function is selected", NULL,
							SM_OKCONT);
						break;
					}
					if((idx = key_info[pos].id) & 0x1000){
						ShowMessage("This function cannot be selected",NULL,
							SM_OKCONT);
						break;
					}
					ModifyKeyTable(hDlg, code, idx);
					goto change;

				case IDC_KSEARCH:			// Search
					code = SendDlgItemMessage(hDlg, IDC_COMBOBOX1, 
						CB_GETCURSEL, 0, 0L);
					if(code == CB_ERR)
						goto cb_err;
					if((idx = key_table[code]) != 0){
						for(pos = 0; key_info[pos].id != K_NULL; pos++){
							if(key_info[pos].id == idx){
								SendDlgItemMessage(hDlg, IDC_LISTBOX1, 
									LB_SETCURSEL, pos, 0);
								return FALSE;
							}
						}
					}
					ShowMessage("No function attached to this key",
						NULL, SM_OKCONT);	
					break;
			}
			if(HIWORD(wParam) == EN_CHANGE && LOWORD(wParam) == IDC_MACRO){
				ApplyOn( hDlg, &f_change );
				f_change |= 1;
			}
			break;

		case WM_HELP:
			ShowCHelp(lParam, help);
			break;

		case WM_NOTIFY:
			switch( ((NMHDR*)lParam)->code ){
				case PSN_HELP:				// HELP
					ShowWinHelp(IDH_PKEY);
					break;

				case PSN_KILLACTIVE:		// lose active
					ReSetFont(hedit);
					break;

//				case PSN_RESET:				// End Prperty Sheet

				case PSN_QUERYCANCEL:		// Cancel
					if(f_change){
skip:					memcpy(key_table, sz_Org, MAX_KEYDEF);
						ApplyOff(hDlg);
						ret_val = f_change = FALSE;
						goto clear;
					}
					break;

				case PSN_APPLY:				// Apply or OK
					if(!f_change)
						break;
					switch(QueryApply(hDlg,IDD_TAB_KEY)){
						case IDYES:			// change the current parameters
							memcpy(sz_Org, key_table, MAX_KEYDEF);
							SetTabString(hDlg, "macro", IDC_MACRO);
							SetButton();
							f_change = FALSE;
							f_prop = 0;
							break;

						case IDCANCEL:		// cancel to apply
							return TRUE;

						case IDNO:			// skip to apply
							goto skip;
					}
					break;

				case PSN_SETACTIVE:
					AdjustPropPage(hDlg);
					hedit = GetDlgItem( hDlg, IDC_MACRO );
					SetFontJE(hedit);
					SetMargin(hedit);
					break;
		}
		break;

		case WM_DESTROY:
			break;
	}
	return FALSE;
}


static void MessageNoFile(void)
{
	MessageBox( g_winData.hMainWnd, "No file loaded!", "Warning", 
		MB_OK|MB_ICONEXCLAMATION );
}

static void SystemInfo(int count)
{
#define	i_printer	(common_work + 0x100)
#define	i_tmp		(common_work + 0x400)

	BOOL IsPC98(void);
	int s_pos, os_main, os_minor, i;
	char *msg, *pt, *pt2;
	char *cmd[] = 
		{"tex -version",
		 "ptex -version",
		 "dvipsk -version",
		 "dvipdfmx",
		 NULL
		};

	error(C_MSG, "dviout\t\t:%s (%s)\n", VERSION_NO, VERSION_DATE);
	os_main = f_osversion & 0xff;
	os_minor = (f_osversion>>8) & 0xff;
	if(f_osversion >= 0){
		if(os_main >= 5)
			msg =  (os_minor)?"XP":"2000";
		else
			msg = "NT";
	}else{
		if( os_main >= 4 && os_minor >= 10){
			msg = (os_minor>=90)?"Me":"98";
		}else
			msg = "95";
	}
	error(C_MSG, "OS\t\t: Windows%s  Version %d.%d (%d %s%s)\n", 
		msg, os_main, os_minor,
		GetVersionLevel(), Language(1), IsPC98()?":PC98":"");
	error(C_MSG, "comctl32.dll\t: Version %d.%d\n", 
		(f_comctlversion & 0xFF00)>>8, f_comctlversion & 0xFF );
	error(C_MSG, "shell32.dll\t: Version %d.%d\n", 
		(f_shellversion & 0xFF00)>>8, f_shellversion & 0xFF );

	s_pos = GetLPTName((char *)i_printer, -1);
	if(s_pos > 0 && i_printer[0] == 0){
		s_pos = 0;
		goto no_prt;
	}
	sprintf(common_work, "LPT%d", s_pos);
	DeviceCapabilities(i_printer, common_work, DC_ENUMRESOLUTIONS,
		i_tmp, NULL);
	s_pos = DeviceCapabilities(i_printer, common_work, DC_ENUMRESOLUTIONS,
		NULL, NULL);
	DeviceCapabilities(i_printer, common_work, DC_ENUMRESOLUTIONS,
		i_tmp, NULL);
no_prt:
	error(C_MSG, s_pos>0?"printer\t\t: %s(%ddpi)\n":"printer\t\t: %s\n", 
		i_printer, *((int *)i_tmp));
	if(!count)
		return;
	for(i = 0; cmd[i] && i < count; i++){
		msg = GetCommandResult(cmd[i], (i==3)?1:0);
		if(msg){
			switch(i){
				case 0:
					if(!strstr(msg, "TeX"))
						goto skp;
					break;
				case 1:
					if(!strstr(msg, "pTeX"))
						goto skp;
					break;
				case 2:
					if((pt = strstr(msg, "dvips")) != NULL && 
					   (pt2 = strstr(msg, "Copy")) != NULL){
						*pt2 = 0;
						error(C_MSG, "%s\n", pt);
					}
					goto skp;
				case 3:
					if((pt = strstr(msg, "dvipdfmx")) != NULL && 
					   (pt2 = strstr(msg, "by")) != NULL){
						*pt2 = 0;
						error(C_MSG, "%s\n", pt);
					}
					goto skp;
			}
			error(C_MSG, "%s", msg);
skp:		Free(msg);
		}
	}
	if(count > 2){
		msg = GetParaString("gsx");
		if(msg){
			strcpy(common_work, msg);
			msg = strstr(common_work, "\\gswin32c.exe");
			if(msg){
				strcpy(msg, "\\gswin32c.exe -v");
				msg = GetCommandResult(common_work, 0);
				if(msg){
					error(C_MSG, "%s%s", strstr(msg, "Ghostscript")?
						"":"gswin32c ",msg);
					Free(msg);
				}
			}
		}
	} 
}

static PrintEnv(char *env)
{
	char *s;

	s = getenv(env);
	error(C_MSG, "%s=\"%s\"\n", env, s?s:"");
}

void EnvironInfo(void)
{
	char *s, *t;
	int i, j;

	error(C_MSG, " --- Environment ---\n");
	GetModuleName(i_tmp);
	error(C_MSG, "%s\n", i_tmp);
	SystemInfo(5);
	if(getenv("TEXMF") != NULL || getenv("TEXMFMAIN") == NULL)
		PrintEnv("TEXMF");
	PrintEnv("TEXMFMAIN");
	PrintEnv("TEXMFCNF");
	PrintEnv("GS_LIB");
	PrintEnv("PATH");
	s = getenv("TMP");
	t = getenv("TEMP");
	if(!s || !t || strcmp(s,t)){
		PrintEnv("TMP");
		PrintEnv("TEMP");
	}else{
		while(*s){
			if(*s <= ' ' || (*s++ & 0x80)){
				PrintEnv("TEMP");
				break;
			}
		}
	}
	error(C_MSG, " --- parameters ---\n");
	error(C_MSG, "%s", PrintAllPara(0));
	i = SetParaSection(-1);
	j = RestoreIntPara("pmode", i);
	if(i != j)
		error(C_MSG, "\n#pmode=%d", j);
	error(C_MSG, "\n --- End ---\n");
}

static void DisplayInfo(BYTE *pDib)
{
	int page, page2, pos, sc, scc;
	double len, len1;
	char msg[0x100];

	msg[0] = 0;
	pos = GetAddTotal();
	if((scc = CountDvioutInitialize()) != 0 ||
	  ptex_mode || count_hyper_special || count_src_special || pos > 0 ){
		sc = 0;
		if(ptex_mode){
			sc = 1;
			strcpy(msg, " (pTeX");
		}
		if(pos > 0){
			if(Current_DVI)
 				strcat(msg, sc++?", tar":" (tar");
			else
 				strcat(msg, sc++?", Embedding":" (Embedding");
			if(LoadETF(NULL))
				strcat(msg, "-Fonts");
		}
		if(count_hyper_special)
			strcat(msg, sc++?", HyperTeX":" (HyperTeX");
		if(count_src_special)
			strcat(msg, sc++?", scource special":" (source special");
		if(count_macro)
			strcat(msg, sc++?", dviout special":" (dviout special");
		if(scc)
			strcat(msg, sc++?", `initialize":" (`initialize");
		if(sc)
			strcat(msg,")");
	}
	page = GetCurrentPage();
	page2 = GetTotalPage();
	sc = GetXGray()*100/g_loupe.div;
	scc = GetXGray()*100/(ctr_loupe>>16);
	error(C_MSG,"time stamp\t: %s%s\n"
		"Current Page\t: %d(%d)\n"
		"Last Page\t: %d(%d)\n"
		"Page Size\t: %.2f x %.2f cm (%d x %d pixel)\n"
		"1000 pixel\t: %.3f x %.3f cm\n"
		"dpi\t\t: %d/%d x %d/%d\n"
		"Text Color\t: %d\n"
		"magnification\t: %d\n"
		"Loupe\t\t: size %d, scale %d.%02d, %s (+CTRL: %d, %d.%02d)\n"
		"Gamma\t\t: %d/1000\n",
		GetFTime(), msg,
		page, TransPage(page),
		page2, TransPage(page2),
		(double)GetTextXSize()/GetXDpi()*2.54,
		(double)GetTextYSize()/GetYDpi()*2.54,
		GetTextXSize(), GetTextYSize(),
		(double)2540/GetXDpi(),
		(double)2540/GetYDpi(),
		GetXDpi(), GetXGray(), GetYDpi(), GetYGray(),
		1<<((BITMAPINFOHEADER*)pDib)->biBitCount,
		GetMagnification(),
		g_loupe.diam, sc/100, sc%100,
		(g_loupe.f_circle & F_LCIRCLE)?"circle":"square",
		ctr_loupe & 0xffff, scc/100, scc%100,
		gray_number
		);
	if( (sc = GetParaInt("e")) != 0)
		error(C_MSG, "Scaled size %s\t: %d.%d%%\n", 
			(GetParaFlag("varf"))?"& font":"", 
			sc/10, sc%10);
	if(f_rectcut){
		len = (rectcut.right - rectcut.left + 1)/GetXDpi()*2.54;
		len1 = rectcut.bottom - rectcut.top;
		if(len1 < 0)
			len1 = -len1;
		len1 = (len1 + 1)/GetXDpi()*2.54;
		len = sqrt(len*len + len1+len1);
		error(C_MSG,"Region\t\t: "
			"(%.3fcm,%.3fcm)-(%.3fcm,%.3fcm) diag:%.3fcm"
			" : (%d,%d)-(%d,%d) pixel\n",
			(double)rectcut.top/GetXDpi()*2.54,
			(double)rectcut.left/GetXDpi()*2.54,
			(double)rectcut.right/GetXDpi()*2.54,
			(double)rectcut.bottom/GetXDpi()*2.54, len, 
			rectcut.top, rectcut.left, rectcut.right, rectcut.bottom);
	}
	if(h_hist[PAGE_MARK].id == id_dvi){
		error(C_MSG, "Marked page\t: %d(%d)", 
			h_hist[PAGE_MARK].page, TransPage(h_hist[PAGE_MARK].page));
		if(h_hist[RANGE_MARK].id == id_dvi)
			error(C_MSG, " -> %d(%d)", 
				h_hist[RANGE_MARK].page, TransPage(h_hist[RANGE_MARK].page));
		error(C_MSG, "\n");
	}
	for(sc = 0; sc < MAX_SCALE; sc++)
		error(C_MSG, "View %c\t\t: reduced %2d x %2d, gamma %d/1000\n",
		sc + '1', scale[sc].x, scale[sc].y, scale[sc].gamma);
	if(pos > 0)
		error(C_MSG, "%s\t: include %d files\n", 
			(Current_DVI)?"tar file":"Extended DVI", pos);
	if((pos = IsHyperTag()) > 0){
		sc = GetS_Count(0);
		if(count_hyper_special)
			error(C_MSG, "HyperTeX\t: href %d, name %d in this page\n",
				h_box[pos].y0, h_box[pos].y1 - sc);
		if(count_src_special)
			error(C_MSG, "source special\t: %d in this page\n", sc);
	}
	if(count_macro)
		error(C_MSG, "dviout specials\t: %d in this page\n", count_macro);
	pos = GetPause(&sc, &scc, 2);
	if(pos)
		error(C_MSG, "pause\t\t: %d in this page\n", pos);
	SystemInfo(0);
	error(DATATITLE, current_name);
}


static void DisplayURL(void)
{
	int pos, total;
	char *tmp;

	tmp = NULL;
	pos = IsHyperTag();

	if(pos <= 0 || (total = h_box[pos].y0) <= 0){
		MessageCBox(g_winData.hMainWnd, 
			"No URL of HyperTeX in this page",
			"Warning", MB_OK);
		return;
	}
	while(total-- > 0){
		if(tmp != h_box[++pos].sub.href){
			tmp = h_box[pos].sub.href;
			error(C_MSG, "%s\n", tmp);
		}
	}
	error(DATATITLE, "URL of HyperTeX in page %d", GetCurrentPage());
}

static void DisplayAnchor(unsigned char *pDib)
{
	int pos, sc, total;

	pos = IsHyperTag();

	if(pos <= 0){
quit:	MessageCBox(g_winData.hMainWnd, 
			"No anchor of HyperTeX in this page",
			"Warning", MB_OK);
		return;
	}

	sc = GetS_Count(0);
	total = h_box[pos].y1;
	pos   = h_box[pos].x1;

	if(sc == total)
		goto quit;

	while(total-- > 0){
		if(IsSRCspecial(h_name[pos]))
			continue;
		error(C_MSG, "%s\t(%d,%d)\n", h_name[pos].name, 
			h_name[pos].x, h_name[pos].y);
		MarkPoint(pDib, h_name[pos].x, h_name[pos].y, 
			5*GetXGray(), 5*GetYGray(), 0x51);
		pos++;
	}
	error(DATATITLE, "Anchors of HyperTeX in page %d", GetCurrentPage());
}

static void DisplaySRC(unsigned char *pDib)
{
	int pos, sc, total;
	unsigned char *tmp;

	pos = IsHyperTag();

	if(pos <= 0 || !(sc = GetS_Count(0))){
		MessageCBox(g_winData.hMainWnd, 
			"No source special in this page.",
			"Warning", MB_OK);
		return;
	}

	total = h_box[pos].y1;
	pos   = h_box[pos].x1;

	for(;total-- > 0;pos++){
		if(!IsSRCspecial(h_name[pos]))
			continue;
		tmp = h_name[pos].name;
		error(C_MSG, "%s\t%5d\t(%d,%d)\n", 
			tmp+8,
			(tmp[1]*255 + tmp[2] - 256)*255 + tmp[3] -1,
			h_name[pos].x, h_name[pos].y);
		MarkPoint(pDib, h_name[pos].x, h_name[pos].y, 
			5*GetXGray(), 5*GetYGray(), 0x31);
	}
	error(DATATITLE, "source specials in page %d", GetCurrentPage());
}

void ChangeWaitCursor(int mode)
{
	static int cond;
//	static HCURSOR	hWait;

	if( f_Loupe ) return;

	if(!cond && mode){
/*
		if(hWait == NULL)
			hWait = LoadCursor( NULL, IDC_WAIT );
		g_winData.hPrevCursor = SetCursor( g_winData.hCursor = hWait );
*/
		SetCursor( g_winData.hWaitCursor );
		cond = mode;
	}else if(cond && !mode){
/*
		g_winData.hPrevCursor = SetCursor( g_winData.hCursor 
			= g_winData.hPrevCursor );
*/
		SetCursor( g_winData.hNormalCursor );
		cond = mode;
	}
}

/*
static int FirstPage(void)
{
	int page;

	page = GetCurrentPage();
	if(!f_2page || page <= 0)
		return page;
	if(((f_2page  - page) & 1) && page > 1)
		return page -1;
	return page;
}
*/

static void CheckError(void)
{
	char *msg;
	
	msg = "Cannot open DVI file";
	switch(f_error & 0xff){
		case FE_DVI:
			msg = "Input correct DVI file";
			break;
		case FE_NOFONT:
			ShowWinHelp(IDH_QE10);
			error(ERRPAUSE, "Cannot resolve Fonts");
		case FE_NOMSG:
			goto nomsg;
	}
	ShowMessage(msg, "Error", SM_OKCONT);
nomsg:
	strcpy( g_szFileName, g_szPrevFileName );
	g_szPrevFileName[0] = '\0';
	if(f_error & 0x80000000)
		exit(1);
	if(f_error & 0x40000000){
		f_error &= ~0x40000001;
		g_szFileName[0] = current_name[0] = 0;
	}
	touch();
	f_error = 0;
}

//	Arrange scroll position within the correct range
static int ArrangeScroll(struct DVIINFO *w, int mode)
{
	if(!mode){
		if( w->pDib != NULL )
		{
			w->cyDib = GetDibHeight( w->pDib );
			w->cxDib = GetDibWidth( w->pDib );
#ifdef	DOUBLE_PAGE
			w->nHscrollMax = max( 0, ((IS_2HORI)?(2*w->cxDib):w->cxDib)
				- w->cxClient );
			w->nVscrollMax = max( 0, ((IS_2VERT)?(2*w->cyDib):w->cyDib)
				- w->cyClient );
#else
			w->nHscrollMax = max( 0, w->cxDib - w->cxClient );
			w->nVscrollMax = max( 0, w->cyDib - w->cyClient );
#endif
			
			/* Eɏ㉺20dots̗]Ƃ */
			if( w->nHscrollMax > 0 && !b_presentation_mode)
				w->nHscrollMax += 2*20;
			if( w->nVscrollMax > 0 && !b_presentation_mode)
				w->nVscrollMax += 2*20;
			
			/* DVI\̌_𒲐 */
#ifdef	DOUBLE_PAGE
			g_nxIndent = max( 0, 
			(IS_2HORI)?(w->cxClient/2 - w->cxDib):(w->cxClient - w->cxDib)/2)
							+ 20*(w->nHscrollMax > 0 && !b_presentation_mode);
			g_nyIndent = max( 0, 
			(IS_2VERT)?(w->cyClient/2 - w->cyDib):(w->cyClient - w->cyDib)/2 )
							+ 20*(w->nVscrollMax > 0 && !b_presentation_mode);

#else
			g_nxIndent = max( 0, (w->cxClient - w->cxDib)/2 )
							+ 20*(w->nHscrollMax > 0 && !b_presentation_mode);
			g_nyIndent = max( 0, (w->cyClient - w->cyDib)/2 )
							+ 20*(w->nVscrollMax > 0 && !b_presentation_mode);
#endif
		}
		else
		{
			w->nVscrollMax = 0;
			w->nHscrollMax = 0;
		}
		if(g_winData.hWnd != NULL){
			if(g_view.f_ScrollBar){
				if( f_flatscroll && GetVersionLevel() > 0 )
				{
					g_FlatSB_SetScrollRange( g_winData.hWnd, SB_VERT, 0, 
						w->nVscrollMax, FALSE );
					g_FlatSB_SetScrollPos( g_winData.hWnd, SB_VERT, 
						w->nVscrollPos, TRUE );
					g_FlatSB_SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 
						w->nHscrollMax, FALSE );
					g_FlatSB_SetScrollPos( g_winData.hWnd, SB_HORZ, 
						w->nHscrollPos, TRUE );
				}
				else
				{
					SetScrollRange( g_winData.hWnd, SB_VERT, 0, 
						w->nVscrollMax, FALSE );
					SetScrollPos( g_winData.hWnd, SB_VERT, 
						w->nVscrollPos, TRUE );
					SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 
						w->nHscrollMax, FALSE );
					SetScrollPos( g_winData.hWnd, SB_HORZ, 
						w->nHscrollPos, TRUE );
				}
			}else{
				if( f_flatscroll && GetVersionLevel() > 0 )
				{
					g_FlatSB_SetScrollRange( g_winData.hWnd, SB_VERT, 0, 0, FALSE );
					g_FlatSB_SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 0, FALSE );
				}
				else
				{
					SetScrollRange( g_winData.hWnd, SB_VERT, 0, 0, FALSE );
					SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 0, FALSE );
				}
			}
		}
	}
	if(w->nVscrollMax == 0 || (w->nVscrollPos & 0x8000))
		w->nVscrollPos = 0;
	else if(w->nVscrollPos > w->nVscrollMax)
		w->nVscrollPos = w->nVscrollMax;
	if(w->nHscrollMax == 0 || (w->nHscrollPos & 0x8000))
		w->nHscrollPos = 0;
	else if(w->nHscrollPos > w->nHscrollMax)
		w->nHscrollPos = w->nHscrollMax;
	return w->nVscrollMax + w->nHscrollMax;
}

//	Transform coordinates in Windows to those in Buffer
void Win2BufPoint(struct DVIINFO *w, POINT *pt, int x, int y)
{
	pt->x = (x + w->nHscrollPos - g_nxIndent)*GetXGray();
	pt->y = (y + w->nVscrollPos - g_nyIndent)*GetYGray();
}

//	Transfrom coordinates in Buffer to those in Window
static void Buf2WinPoint(struct DVIINFO *w, POINT *pt, int x, int y)
{
	pt->x = x/GetXGray() - w->nHscrollPos + g_nxIndent;
	pt->y = y/GetYGray() - w->nVscrollPos + g_nyIndent;
}

//	Move the point in Buffer to the center of Window
static void BufPoint2Center(struct DVIINFO *w, int x, int y)
{
	w->nHscrollPos = x/GetXGray() - w->cxClient/2 + g_nxIndent;
	w->nVscrollPos = y/GetYGray() - w->cyClient/2 + g_nyIndent;
}

//	Move mouse cursor to the point in Buffer
static void Cursor2BufPoint(struct DVIINFO *w, int x, int y)
{
	POINT pt;

	Buf2WinPoint(w, &pt, x, y);
	ClientToScreen(g_winData.hWnd, &pt);
	SetCursorPos(pt.x, pt.y);
}

// Move the point in Buffer to the center of Window,
//	arrange the scroll position within the correct range
//	 and move the cursor to the point
static void Cursor2BufPoint2Center(struct DVIINFO *w, int x, int y)
{
	BufPoint2Center(w,x,y);
	ArrangeScroll(w, 1);
	Cursor2BufPoint(w,x,y);
}

//  mode = 1: bottom	2: right	4: left
static void Move2Pause(struct DVIINFO *w, int x, int y, int mode)
{
	POINT pt;
	int xx;

	Buf2WinPoint(w, &pt, x, y);
	if(mode&1){							// bottom
		if(pt.y > w->cyClient)
			SendMessage( g_winData.hWnd, WM_USER_VSCROLL, 
				pt.y - w->cyClient, 0 );
	}else if(mode&2){					// right
		if(pt.x > w->cxClient)
			SendMessage( g_winData.hWnd, WM_USER_HSCROLL,
				pt.x - w->cxClient, 0 );
	}else if(mode&4){					// left
		xx = GetTextXSize()/GetXGray();
		if(xx > w->cxClient){
			if(pt.x < w->cxClient)
				pt.x = w->cxClient;
			SendMessage( g_winData.hWnd, WM_USER_HSCROLL, xx - pt.x, 0 );
		}
	}
}

static void ShowFound(struct DVIINFO *w, struct S_BOX *box, 
	int total, int mode, int pos)
{
	int poss;

	if(mode & 0x100)
		ShowBox(w->pDib, box, total, mode);
	else{
		poss = pos;
		do{
			ColorS_Box(w->pDib, box + poss, mode);
		}while(++poss < total && box[poss].sub.found == box[poss-1].sub.found);
	}
	if(mode & 0x200)
		Cursor2BufPoint2Center(w, box[pos].x1, box[pos].y1);
	else
		BufPoint2Center(w, box[pos].x1, box[pos].y1);
	return;
}

// Get History of page and Window data and set history pointer
void GetH_Hist(POINT *pt, int *page, int mode)
{
	int org = h_hist_pt;

	*page = 0;
	if(mode > 0){
		if(h_hist_pt != h_hist_n){
			if(++h_hist_pt == MAX_H_HIST)
				h_hist_pt = 0;
set:		if(h_hist[h_hist_pt].id == id_dvi){
				pt->x = h_hist[h_hist_pt].x;
				pt->y = h_hist[h_hist_pt].y;
				*page = h_hist[h_hist_pt].page;
			 }
		}
	}
	else if(mode < 0){
		if(	  h_hist_pt - 1 != h_hist_n
		  &&  h_hist_pt + (MAX_H_HIST) != h_hist_n){
			if(--h_hist_pt < 0)
				h_hist_pt = MAX_H_HIST - 1;
			goto set;
		}
	}else{
		h_hist_pt = h_hist_n;
		goto set;
	}
	if(!*page)
		h_hist_pt = org;
}

//	Save current page and Window position
void SaveH_Hist(struct DVIINFO *w, int mode)
{
	POINT pt;
	int i;

	if(w->pDib == NULL)
		return;
	if(!mode){
		for(i = 0; i < MAX_H_HIST; i++)
			h_hist[i].page = 0;
		h_hist_n = h_hist_pt = 0;
	}else{
		Win2BufPoint(w, &pt, w->cxClient/2, w->cyClient/2);
		if(mode == 1){
			if(	 h_hist[h_hist_n].page == GetCurrentPage()
			&& h_hist[h_hist_n].y == pt.y)
			return;
			if(++h_hist_n >= MAX_H_HIST)
				h_hist_n = 0;
			i = h_hist_pt = h_hist_n;
		}else
			i = mode + (MAX_H_HIST-2);
		h_hist[i].x = pt.x;
		h_hist[i].y = pt.y;
		h_hist[i].id = id_dvi;
		h_hist[i].page = GetCurrentPage();
		h_hist[i].flag = f_hist_msg;
		f_hist_msg = 0;
	}
}

//	return	>= 0 : position in Boxes
//			= -1 : not found
//
//	mode & 6 = 0 : forward	search containing (x,y)
//			   2 : forward	search after	  (x,y)
//			   4 : backward search before	  (x,y)
//
//	skip		 : number of the matched boxes to be skipped
//	total		 : total number of box[];
static int SearchS_Box(struct DVIINFO *w, struct S_BOX box[], int total,
	int x, int y, int mode, int skip)
{
	int i, val;
	POINT pt;

	if(mode & 1){
		pt.x = x;
		pt.y = y;
	}else
		Win2BufPoint(w, &pt, x, y);
	if(b_presentation_mode && f_cover == 1 && !IS_2VERT){	// In cover sheet?
		if(pt.y >= cover_ypos){								// IS_2VERT not supported
			if(f_coverH & 2){
				if(pt.x + cover_xpos <= GetTextXSize())
					return -1;
			}else
				if(pt.x >= cover_xpos)
				return -1;
		}
	}
	i = (mode & 4)?total-1:0;
	while(i >= 0 && i < total){
		val = CheckS_Box(&(box[i]), pt.x, pt.y);
		if(!(mode & 6)){
			if(val == 0)
				skip--;
		}
		else if(mode & 2){
			if(val > 0)
				skip--;
		}
		else if(val < 0)
			skip--;
		if(skip < 0)
			return i;
		else if(mode & 4)
			i--;
		else i++;
	}
	return -1;
}

//	Get hypertex reference at (x,y) in Window
//	return : pointer to href
//			 NULL -> not exist
static char *GetHref(struct DVIINFO *w, int x, int y)
{
	int	  pos, found;
#if	HYPER_2VERT
	int	  page;
#endif

	if(f_2page){
		if(f_2page&(F_2PAGE|F_MPAGE|F_16PAGE) || !b_presentation_mode)
			return NULL;
#if	HYPER_2VERT
		if(IS_2VERT && pDib2){
			page = GetCurrentPage();
			if(!IsSecondPage(page))
//			if(!IS_2DIB2)
				ChgPage(page+1);
			pos = IsHyperTag();
			found = (pos>0)?SearchS_Box(w, h_box + pos + 1, h_box[pos].y0, 
				x, y-GetDibHeight(pDib2), 0, 0):-1;
			ChgPage(!IsSecondPage(page)?(page):(page-1));
//			ChgPage(!IS_2DIB2?(page):(page-1));
			if(found < 0){
				pos = IsHyperTag();
				if(pos > 0)
					found = SearchS_Box(w, h_box + pos + 1, h_box[pos].y0, 
						x, y, 0, 0);
			}
			ChgPage(page);
		}
#endif
	}else
	{
		if((pos = IsHyperTag()) <= 0)
			return NULL;
		found = SearchS_Box(w, h_box + pos + 1, h_box[pos].y0, 
			x, y, 0, 0);
	}
	return (found >= 0)?h_box[pos + found + 1].sub.href:NULL;
}

static BOOL ReplaceBmp(struct DVIINFO *w, BYTE *pDibNew)
{
	if(pDibNew == NULL)
		return FALSE;
	if(w->pDib != pDibNew + sizeof(BITMAPFILEHEADER)){
		if(w->pDib)
			FreeBmp(w->pDib);
		CheckPenBuf();
		w->pDib = pDibNew + sizeof(BITMAPFILEHEADER);
	}
	return TRUE;
}


LRESULT CALLBACK AbortSearchJob( HWND hwndDlg, UINT msg, WPARAM wParam, 
	LPARAM lParam )
{
	switch( msg )
	{
		case WM_INITDIALOG:
			return TRUE;
		case WM_COMMAND:
			f_searching = -1;
			return TRUE;
	}
	return FALSE;
}


static BOOL SetAbortSearch(int page)
{
	char szPage[16];

	if(page <= 0 || f_searching < 0){
		if(g_winData.hWndFindAbort != NULL){
/*			EnableWindow( g_winData.hMainWnd, TRUE ); */
			DestroyWindow( g_winData.hWndFindAbort );
		}
		f_searching = 0;
		g_winData.hWndFindAbort = NULL;
		return FALSE;
	}
	if(g_winData.hWndFindAbort == NULL){
		/* _CAO{bNX쐬 */
		f_searching = 1;
		g_winData.hWndFindAbort = CreateDialog( g_winData.hInstance, 
								MAKEINTRESOURCE(IDD_SEARCHABORTDIALOG),
							   g_winData.hMainWnd, (DLGPROC)AbortSearchJob );
	}
	wsprintf(szPage, "%3d(%3d) page", page, TransPage(page));
	SetDlgItemText( g_winData.hWndFindAbort, IDC_SEARCHINGPAGE, szPage );
	return TRUE;
}

static BOOL SearchStr(struct DVIINFO *w, LPFINDREPLACE lpfr, int mode)
{
	int temp_page, pos;
	int flag = 0;

	if(	 s_box_pt > 0									// Searched?
	  && FindDvi == id_dvi								// DVI?
	  && FindPage == GetCurrentPage()					// page?
	  && strcmp(szFindOld, lpfr->lpstrFindWhat) == 0	// String?
	  && (FindFlags & (FR_MATCHCASE|FR_WHOLEWORD))
		== (lpfr->Flags & (FR_MATCHCASE|FR_WHOLEWORD))){ // Flags?
find_c: if(FindPt < 0){								// Check Position
			flag = 1;
			if(lpfr->Flags & FR_DOWN)
				FindPt = 0;
			else{
				FindPt = s_box_pt;
				while(!IsTopSearchBox(--FindPt));
			}
		}
		else{
			if(!(f_s_color & 0x100)){
				pos = FindPt;
				do{
					ColorS_Box(w->pDib, s_box + pos, f_s_color & ~0xfd);
				}while(++pos < s_box_pt && !IsTopSearchBox(pos));
			}
			if(lpfr->Flags & FR_DOWN){
				do{
					if(++FindPt >= s_box_pt){
						s_box_pt = 0;
						goto find_n;
					}
				}while(!IsTopSearchBox(FindPt));
			}else{
				 do{
					if(--FindPt < 0){
						s_box_pt = 0;
						goto find_n;
					}
				}while(!IsTopSearchBox(FindPt));
			}
		}
		if(flag){
			SetColor(8);
			if(ReplaceBmp(w, MakeBMP()) == FALSE)
				goto find_not;
		}
		if(mode)
			ShowFound(w, s_box, s_box_pt, f_s_color, FindPt);
		SetAbortSearch(0);
		return TRUE;
	}else{
		f_s_search = 1;
		f_s_flags = (lpfr->Flags & FR_MATCHCASE)?0:F_S_NOCASE;
		if(lpfr->Flags & FR_WHOLEWORD)
			f_s_flags |= F_S_WORD;
		FindDvi = id_dvi;
		strcpy(szFindOld, lpfr->lpstrFindWhat);
		FindFlags = lpfr->Flags;
		SetSearchStr(szFindOld);
		SetAbortSearch(GetCurrentPage());
		ExpandPage();
find_n: FindPage = temp_page = GetCurrentPage();
		FindPt = -1;
		if(s_box_pt)
			goto find_c;
		while(mode){
			if(lpfr->Flags & FR_DOWN){
				if(FindPage == CheckPage(FindPage+1))
					break;
				FindPage++;
			}
			else{
				if(FindPage == CheckPage(FindPage-1))
					break;
				FindPage--;
			}
			f_s_search = 1;
			if(SetAbortSearch(FindPage) == FALSE)
				goto find_not;
			MessagePage(FindPage);
			ChgPage(FindPage);
			ExpandPage();
			if(s_box_pt){			/* found */
				MessagePage(0);
				goto find_c;
			}
		}
find_not:
		MessagePage(0);
		f_s_search = 0;				/* not found */
		if(temp_page != GetCurrentPage())
			ChgPage(temp_page);
		SetColor(4);
		SetAbortSearch(0);
		return FALSE;
	}
}


static void EraceHistory(int his)
{
	char name[MAX_PATH], tmp[MAX_PATH+0x10], fig[4];
	int pos, count;

	strcpy(name, f_hist[his & (MAX_F_HIST - 1)].name);
	for(pos = f_hist0; pos <= his; pos++){
		if(!strcmp(f_hist[pos & (MAX_F_HIST - 1)].name, name))
			*f_hist[pos & (MAX_F_HIST-1)].name = 0;
	}
	for(pos = his-1;  pos >= f_hist0; pos--){
		if(*f_hist[pos & (MAX_F_HIST-1)].name){
			strcpy(f_hist[his & (MAX_F_HIST-1)].name,
				f_hist[pos & (MAX_F_HIST-1)].name);
			f_hist[his & (MAX_F_HIST-1)].id
				= f_hist[pos & (MAX_F_HIST-1)].id;
			f_hist[his & (MAX_F_HIST-1)].page
				= f_hist[pos & (MAX_F_HIST-1)].page;
			his--;
		}
	}
	f_hist0 = his+1;
	for(count = his = 0; count < MAX_F_KEEP; count++){
		sprintf(fig, "%d", count);
		RestoreString(tmp, MAX_PATH+0x0f, "FILE", fig, "");
		if(!*tmp)
			break;
		pos = 0;
		while(tmp[pos] == name[pos] && name[pos])
			pos++;
		if(tmp[pos] != '\t' || name[pos]){
			if(count != his){
				sprintf(fig, "%d", his);
				ReserveString("FILE", fig, tmp);
			}
			his++;				/* keep it */
		}
	}
	if(his < MAX_F_KEEP){
		sprintf(fig, "%d", his);
		ReserveString("FILE", fig, "");
	}
}

#ifdef	USE_ETF
extern BOOL f_make_etf;
extern BOOL f_make_pketf;
extern BOOL f_make_vfetf;
extern BOOL f_make_mapetf;
extern BOOL f_make_jttetf;
extern BOOL f_make_wjtetf;
extern BOOL f_make_imgetf;
extern char *f_make_dpi;

BOOL CALLBACK DlgInitETF( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_ETFPK:
					EnableWindow(GetDlgItem(hdwnd, IDC_DPI), 
						IsDlgButtonChecked(hdwnd, IDC_ETFPK));
					break;
				case IDOK:
					f_make_etf    = IsDlgButtonChecked(hdwnd, IDC_ETFCMTT);
					f_make_pketf  = IsDlgButtonChecked(hdwnd, IDC_ETFPK);
					f_make_vfetf  = IsDlgButtonChecked(hdwnd, IDC_ETFVF);
					f_make_wjtetf = 
					f_make_mapetf = IsDlgButtonChecked(hdwnd, IDC_ETFMAP);
					f_make_jttetf = IsDlgButtonChecked(hdwnd, IDC_ETFJTT);
					f_make_imgetf = IsDlgButtonChecked(hdwnd, IDC_ETFIMG);
					GetDlgItemText(hdwnd, IDC_DPI, common_work, 0x1000);
					Free0(f_make_dpi);
					f_make_dpi = dup_string(common_work);
				case IDC_ETFSTRIP:
				case IDC_ETFDEL:
				case IDCANCEL:
					EndDialog(hdwnd, LOWORD(wParam));
					return TRUE;
				case IDC_PHELP:
					ShowWinHelp(IDH_ETF);
					break;
			}
			break;

		case WM_INITDIALOG:
			sprintf(common_work, "%d", GetXDpi());
			SetDlgItemText(hdwnd, IDC_DPI, common_work);
			EnableWindow(GetDlgItem(hdwnd, IDC_DPI), 0);
			if(GetAddMemory("dviout.etf", NULL, 0) < 1)
				EnableWindow(GetDlgItem(hdwnd, IDC_ETFDEL), 0);
			if(!GetAddTotal())
				EnableWindow(GetDlgItem(hdwnd, IDC_ETFSTRIP), 0);
			return TRUE;
		
		case WM_DESTROY:
			break;
	}
	return FALSE;
}
#endif


// CallBack from File/Page History Dialog
BOOL CALLBACK DlgHFunct( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int his, pos;
	static int mrk;
	POINT	pt;
	char tmp[MAX_PATH + 32];
	static HWND hedit;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case ID_HIS_JUMP:
						goto jmp;

				case ID_HIS_LIST:
					if(HIWORD(wParam) == LBN_DBLCLK){
jmp:					pos = SendDlgItemMessage(hdwnd, ID_HIS_LIST, 
							LB_GETCURSEL, 0, 0L);
						if(pos >= 0){
							EndDialog(hdwnd, 0);
							if(id_hist == ID_P_HISTORY){
								if(mrk != 0 && pos-- == 0)
									pos = MAX_H_HIST;
								else if((pos = h_hist_n - pos) < 0)
									pos += MAX_H_HIST;
							}else
								pos = (f_hist_pt - pos - 1)|0x1000;
							SendMessage(g_winData.hWnd, WM_USR_HDIALOG, 
								pos, 0L);
						}
					}
					return TRUE;

				case IDC_ERACE:
					pos = SendDlgItemMessage(hdwnd, ID_HIS_LIST, 
						LB_GETCURSEL, 0, 0L);
					if(pos < 0)
						return TRUE;
					EraceHistory(f_hist_pt - pos - 1);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST,
						LB_RESETCONTENT, 0, 0L);
					if(f_hist_pt > f_hist0)
						goto reset;

				case ID_HIS_CANCEL:
				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_INITDIALOG:
			hedit = GetDlgItem( hdwnd, ID_HIS_LIST );
			SetFont( 10, hedit, IsJapanese()?"lr SVbN":"Courier New", IsJapanese() );
			if(id_hist == ID_P_HISTORY){
				SetWindowText(hdwnd, "Page Jump History");
				pt.x = GetTextXSize();
				pt.y = GetTextYSize();
				if(	 h_hist[PAGE_MARK].id == id_dvi
				  && h_hist[PAGE_MARK].page > 0){
					mrk = 1;
					wsprintf(tmp, "page %3d(%3d) :(0.%d,0.%d) %s", 
						h_hist[PAGE_MARK].page, 
						TransPage(h_hist[PAGE_MARK].page),
						h_hist[PAGE_MARK].x*100/pt.x, 
						h_hist[PAGE_MARK].y*100/pt.y, "<- Marked");
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}else
					mrk = 0;
				for(his = h_hist_n; his > h_hist_n - MAX_H_HIST; his--){
					pos = (his >= 0)?his:his + MAX_H_HIST;
					if(h_hist[pos].id != id_dvi)
						break;
					wsprintf(tmp, "page %3d(%3d) :(0.%d,0.%d) %s", 
						h_hist[pos].page, TransPage(h_hist[pos].page),
						h_hist[pos].x*100/pt.x, h_hist[pos].y*100/pt.y,
						hist_msg[h_hist[pos].flag]);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}
				SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETCURSEL, mrk+1, 0);
				EnableWindow(GetDlgItem(hdwnd, IDC_ERACE), 0);
			}else{
				SetWindowText(hdwnd, "File History");
reset:			for(his = f_hist_pt; 
					--his >= f_hist0 && his >= f_hist_pt - MAX_F_HIST; ){
					wsprintf(tmp, "%s (%d page)",
						f_hist[his & (MAX_F_HIST - 1)].name,
						f_hist[his & (MAX_F_HIST - 1)].page);
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_ADDSTRING, 0,
						(LPARAM)&tmp[0]);
				}
				if(f_hist_pt > f_hist0)
					SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETCURSEL, 0, 0);
				SendDlgItemMessage(hdwnd, ID_HIS_LIST, LB_SETHORIZONTALEXTENT,
					1536, 0);
			}
			return TRUE;
		
		case WM_DESTROY:
			ReSetFont(hedit);
			break;
	}
	return FALSE;
}

BOOL CALLBACK ModeDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	char tmp[32], key[8];
	int pos, mode;
	static HWND hcombo, hstatic;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					mode = SendDlgItemMessage(hdwnd, IDC_MODE_NEW, 
						CB_GETCURSEL, 0, 0);
					SetParaSection(mode);
					RestoreRegistry();

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return 1;

				case IDC_HMODE:
					ShowWinHelp(IDH_PCMODE);
					break;
			}
			break;

		case WM_INITDIALOG:
			hcombo = GetDlgItem( hdwnd, IDC_MODE_NEW );
			hstatic = GetDlgItem( hdwnd, IDC_MODE_NNAME );
			SetFontJE(hcombo);
			SetFontJE(hstatic);
			mode = SetParaSection(-1);
			for(pos=0; pos < 10; pos++){
				wsprintf(key, "para%d", pos);
				wsprintf(tmp, "%d:", pos);
				tmp[31] = 0;
				RestoreString(tmp+2, 28, key, "mode", "");
				SendDlgItemMessage(hdwnd, IDC_MODE_NEW, CB_ADDSTRING,
					0, (LPARAM)tmp);
				if(pos == mode)
					SetDlgItemText(hdwnd, IDC_MODE_NNAME, tmp);
			}
			SendDlgItemMessage(hdwnd, IDC_REG_DEF, CB_SETCURSEL, mode, 0); // ???
			SendDlgItemMessage(hdwnd, IDC_MODE_NEW, CB_SETCURSEL, mode, 0);
			return TRUE;

		case WM_DESTROY:
			ReSetFont(hcombo);
			ReSetFont(hstatic);
			break;
	}
	return FALSE;
}

BOOL CALLBACK NoMoreDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	char tmp[32];
	static int pos, this, c_multi;
	static HWND hstatic;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					if( IsDlgButtonChecked(hdwnd, IDC_NOMORE) == FALSE )
						this = 0;
					if(pos != this)
						ReserveInt("Settings", "multi", this);

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_NOMORE:
					if(IsDlgButtonChecked(hdwnd, IDC_NOMORE)){
						if( c_multi != this )
							CheckDlgButton(hdwnd, IDC_MULTI, FALSE);
					}else
						CheckDlgButton(hdwnd, IDC_MULTI, TRUE);
					break;

				case IDC_MULTI:
					if(IsDlgButtonChecked(hdwnd, IDC_MULTI)){
					   if( c_multi != this )
							CheckDlgButton(hdwnd, IDC_NOMORE, FALSE);
					}else
						CheckDlgButton(hdwnd, IDC_NOMORE, TRUE);
					break;

				case IDC_HNOMORE:
					ShowWinHelp(IDH_NOMORE);
			}
			break;

		case WM_INITDIALOG:
			hstatic = GetDlgItem( hdwnd, IDC_NOMORE_STATE );
			SetFont( 0, hstatic, "Times New Roman", FALSE );
			pos = RestoreInt("Settings", "multi", 0);
			if(pos != 0)
				wsprintf(tmp, "'No more dviout' is set at %d.", pos);
			else
				wsprintf(tmp, "'No more dviout' is not set.");
			SetDlgItemText(hdwnd, IDC_NOMORE_STATE, tmp);
			this = g_winData.szAppName[6] - '0';
			if(this < 0) this = 1;
			wsprintf(tmp, "%d", this);
			SetDlgItemText(hdwnd, IDC_NOMORE_AT, tmp);
			if( !(c_multi = RestoreInt( "Settings", "cmulti", 0)) )
				c_multi = multi_dviout;
			wsprintf(tmp, "%d", c_multi);
			SetDlgItemText(hdwnd, IDC_MULTI_UPTO, tmp);
			if(!pos)
				CheckDlgButton(hdwnd, IDC_MULTI, TRUE);
			if(pos == this)
				CheckDlgButton(hdwnd, IDC_NOMORE, TRUE);
			return TRUE;
		
		case WM_DESTROY:
			ReSetFont(hstatic);
			break;
		
	}
	return FALSE;
}

static BOOL CALLBACK GlidScaleDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int val;
	static int ww;
	static BOOL f_change;
	static HWND hdWnd;

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					if(f_change){	
						val = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
						if(IsDlgButtonChecked( hdwnd, IDC_INCH ))
							ww = (IN_TO_SP( ((double)val)/1000 ));
						else
							ww = (MM_TO_SP( ((double)val)/100 ));
					}
					f_gridO = !IsDlgButtonChecked( hdwnd, IDC_PH );
					if(ww < 200000)
						ww = 200000;
					if(ww > 100000000)
						ww = 100000000;
					w_grid = ww;

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_INCH:
					val = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						if(!f_inch){
							f_inch = 1;
							if(f_change){
								f_change = 0;
								ww = (MM_TO_SP( ((double)val)/100 ));
							}
							SetDlgItemText( hdwnd, IDC_HS, "/1000 inch");
							SendMessage( hdWnd, UDM_SETPOS, 0, 
								(int)(SP_TO_IN(ww*1000)+0.5));
						}
					}else{
						if(f_inch){
							f_inch = 0;
							if(f_change){
								ww = (IN_TO_SP( ((double)val)/1000 ));
							}
							SetDlgItemText( hdwnd, IDC_HS, "/1000 cm");
							SendMessage( hdWnd, UDM_SETPOS, 0, 
								(int)(SP_TO_MM(ww*100)+0.5));
						}
					}
					f_change = 0;
			}
			if( HIWORD(wParam) == EN_CHANGE )
			  f_change = 1;
			break;

		case WM_INITDIALOG:
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PW));
			ww = w_grid;
			hdWnd = CreateUpDownControl(
				WS_CHILD | WS_VISIBLE | WS_BORDER | UDS_ARROWKEYS
				| UDS_SETBUDDYINT | UDS_ALIGNRIGHT | UDS_NOTHOUSANDS,
				50, 22, 20, 20, 
				hdwnd,
				ID_UPDOWN,
				g_winData.hInstance,
				(HWND)GetDlgItem( hdwnd, IDC_PW),
				50, 20000, 
				f_inch?(int)(SP_TO_IN(ww*1000)+0.5):(int)(SP_TO_MM(ww*100)+0.5));
			f_change = 0;
			CheckDlgButton(hdwnd, IDC_PH, !f_gridO);
			CheckDlgButton(hdwnd, IDC_INCH, f_inch);
			if(!f_inch)
				SetDlgItemText( hdwnd, IDC_HS, "/1000 cm");
			return TRUE;

		case WM_DESTROY:
			break;
	}
	return FALSE;
}

static BOOL CALLBACK PaperSizeDlgProc( HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int i, val, val0, val1;
	static HWND hdWnd[2];

	switch(message){
		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDOK:
					val0 = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					val1 = GetDlgItemInt( hdwnd, IDC_PH, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						val0 = (val0*254+50)/100;
						val1 = (val1*254+50)/100;
					}
					if(val0 < 20)
						val0 = 20;
					if(val0 > 20000)
						val0 = 20000;
					if(val1 < 20)
						val1 = 20;
					if(val1 > 20000)
						val1 = 20000;
					common_work[0] = 'F';
					sprintf(common_work+1,"%s:",  print10mm(val0));
					sprintf(common_work + strlen(common_work), 
						print10mm(val1));

				case IDCANCEL:
					EndDialog(hdwnd, 0);
					return TRUE;

				case IDC_INCH:
					val0 = GetDlgItemInt( hdwnd, IDC_PW, &val, TRUE);
					val1 = GetDlgItemInt( hdwnd, IDC_PH, &val, TRUE);
					if(IsDlgButtonChecked( hdwnd, IDC_INCH )){
						SetDlgItemText( hdwnd, IDC_HS, "/100 inch");
						SetDlgItemText( hdwnd, IDC_VS, "/100 inch");
						SendMessage( hdWnd[0], UDM_SETPOS, 0, 
							(val0*100 + 127)/254 );
						SendMessage( hdWnd[1], UDM_SETPOS, 0, 
							(val1*100 + 127)/254 );
					}else{
						SetDlgItemText( hdwnd, IDC_HS, "/100 cm");
						SetDlgItemText( hdwnd, IDC_VS, "/100 cm");
						SendMessage( hdWnd[0], UDM_SETPOS, 0, 
							(val0*254+50)/100 );
						SendMessage( hdWnd[1], UDM_SETPOS, 0, 
							(val1*254+50)/100 );
					}
			}
			break;

		case WM_INITDIALOG:
			common_work[0] = 0;
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PW));
			SetMargin((HWND)GetDlgItem(hdwnd, IDC_PH));
			for(i = 0; i < 2; i++){
				if(!i){
					val = (double)GetTextXSize()/GetXDpi()*254 + 0.5;
					if(!val)
						val = 2100;
				}else{
					val = GetYDpi();
					if(val == 0)
						val = GetXDpi();
					val = (double)GetTextYSize()/val*254 + 0.5;
					if(!val)
						val = 2970;
				}
				hdWnd[i] = CreateUpDownControl(
					WS_CHILD | WS_VISIBLE | WS_BORDER | UDS_ARROWKEYS
					| UDS_SETBUDDYINT | UDS_ALIGNRIGHT | UDS_NOTHOUSANDS,
					50, 22, 20, 20, 
					hdwnd,
					ID_UPDOWN,
					g_winData.hInstance,
					(HWND)GetDlgItem( hdwnd, (!i)?IDC_PW:IDC_PH),
					20, 20000, val );
			}
			return TRUE;
		
		case WM_DESTROY:
			break;
		
	}
	return FALSE;
}

static int CheckParaFile(char *fname, char *ask)
{
	FILE *fp;
	int line = 0;
	int flag = 0;
	char buf[0x100];

	*common_work = 0;
	fp = fopenf(fname, "rt");
	if(fp == NULL)
		goto end;
	while(fgets(buf, 0x100, fp)){
		if(buf[0] != ';')
			break;
		if(buf[1] == '`'){
			flag |= 0x1000;
msg:		strcat(common_work, (buf[2]==' ')?(buf+3):(buf+2));
			if(line++ >= 20)
				break;
		}else if(buf[1] == ';')
			goto msg;
	}
	fclose(fp);
end:
	strcat(common_work, ask?ask:(flag?
		"\nWrite the parameters from the file to Registry?":
		"\nRead this parameter?"));
	return (line|flag);
}


// CallBack
static BOOL CALLBACK DlgPresenProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	int id;
	static int mode;

	switch(message){
		case WM_INITDIALOG:
			mode = f_cover?(f_coverP?0:1):2;
			CheckRadioButton(hdwnd, IDC_NLINE,IDC_NBOX, IDC_NLINE+draw_style);
			CheckRadioButton(hdwnd, IDC_NRED, IDC_NGREEN, IDC_NRED+(draw_color&7));
			CheckRadioButton(hdwnd, IDC_NCONP, IDC_NCOFF, IDC_NCONP+mode);
			CheckDlgButton(hdwnd, IDC_NCSEAM, f_seamless);
			CheckDlgButton(hdwnd, IDC_NCSCRP, f_coverM);
			CheckDlgButton(hdwnd, IDC_NOFF, f_rectcut);
			CheckDlgButton(hdwnd, ID_DTHICK, draw_color&F_DTHICK);
			CheckDlgButton(hdwnd, IDC_KSTOP, !f_kill);
resume:		for(id = IDC_NLINE; id <= IDC_NGREEN; id++)
				EnableWindow(GetDlgItem(hdwnd, id), f_rectcut);
			EnableWindow(GetDlgItem(hdwnd, ID_DTHICK), f_rectcut);
//			SetFocus(g_winData.hWnd);		<- No effect
			break;

		case WM_COMMAND:
			switch(id = LOWORD(wParam)){
				case ID_PMLOC:
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
				case ID_SHAPE:
post:				PostMessage(g_winData.hWnd, WM_COMMAND, id, 0);
					return TRUE;
				case ID_UPPAGE:
					if(f_rev_movebutton)
						id = ID_DOWNPAGE;
					goto post;
				case ID_DOWNPAGE:
					if(f_rev_movebutton)
						id = ID_UPPAGE;
					goto post;
				case IDC_NOFF:
					f_Pen = f_rectcut = IsDlgButtonChecked(hdwnd, IDC_NOFF);
					goto resume;
				case IDC_NLINE:
				case IDC_NBOX:
					draw_style = id - IDC_NLINE;
					return TRUE;
				case IDC_NRED:
				case IDC_NBLACK:
				case IDC_NBLUE:
				case IDC_NGREEN:
					draw_color = (id - IDC_NRED)|(draw_color&F_DTHICK);
					CheckMenuSet(ID_DRRED+(draw_color&7), ID_DRRED, ID_DRGREEN);
					return TRUE;
				case ID_DTHICK:
					draw_color ^= F_DTHICK;
					CheckMenu(ID_DTHICK, draw_color&F_DTHICK);
					return TRUE;
				case IDC_NCONP:
				case IDC_NCON:
				case IDC_NCOFF:
					id += (ID_COVERON - IDC_NCON);
					CheckMenuSet(id, ID_COVERSHEET, ID_COVEROFF);
					PostMessage( g_winData.hWnd, WM_COMMAND, id, 0);
					return TRUE;
				case IDC_NCSCRP:
					f_coverM = IsDlgButtonChecked(hdwnd, IDC_NCSCRP);
					CheckMenu(ID_SCROL2PAUSE, f_coverM);
					return TRUE;
				case IDC_KSTOP:
					f_kill = !IsDlgButtonChecked(hdwnd, IDC_KSTOP);
					CheckMenu(ID_KSTOP, f_kill);
					if(*g_szFileName)
						PostMessage( g_winData.hWnd, WM_COMMAND, ID_REOPEN, 0);
					return TRUE;
				case IDC_NCSEAM:
					f_seamless = IsDlgButtonChecked(hdwnd, IDC_NCSEAM);
					CheckMenu(ID_SEAMLESS, f_seamless);
					return TRUE;
				case IDCANCEL:
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
					g_winData.hWndPresenMenu = NULL;
					f_pmshow = FALSE;
					DestroyWindow(hdwnd);
					return TRUE;
			}
			break;
		}
	return 0;
}

// CallBack
static BOOL CALLBACK DlgSaveParaProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
	static HWND hedit1, hedit2, hedit3;
	unsigned char ch;
	FILE *fp;
	unsigned char *msg, *pt, *pt2;
	BOOL flg;
#define	buf0	common_work
#define	buf1	(common_work+0x400)
#define	buf2	(common_work+0x500)
#define	buf3	(common_work+0x600)
#define    issjis1(x)      ((x)>=0x81&&(x)<=0xfc&&((x)<=0x9f||(x)>=0xe0))

	switch(message){
		case WM_INITDIALOG:
			hedit1 = GetDlgItem( hdwnd, IDC_EDIT1 );
			hedit2 = GetDlgItem( hdwnd, IDC_EDIT2 );
			hedit3 = GetDlgItem( hdwnd, IDC_EDIT3 );
			msg = (flg = IsJapanese())?"lr SVbN":"Courier New";
			SetFont( 10, hedit1, msg, flg );
			SetFont( 10, hedit2, msg, flg );
			SetFont( 10, hedit3, msg, flg );
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_PHELP:
					ShowWinHelp(IDH_PREPARA);
					break;
				case IDC_NOFF:
					CheckDlgButton(hdwnd, IDC_ALLSET, FALSE);
					break;
				case IDC_ALLSET:
					CheckDlgButton(hdwnd, IDC_NOFF, FALSE);
					break;
				case IDOK:
					strcpy(buf1, "^x\\par\\$");
					GetDlgItemText(hdwnd, IDC_EDIT1, buf1+8, 0x10);	// filename
					GetDlgItemText(hdwnd, IDC_EDIT2, buf2, 0x100);	// title
					GetDlgItemText(hdwnd, IDC_EDIT3, buf3, 0x400);	// massage
					if(!strlen(buf2)){
						error(ERRPAUSE, "No Title!");
						break;
					}
					ch = IsDlgButtonChecked(hdwnd, IDC_NOFF)?'`':';';
					SetPath(buf0, buf1);
					strcat(buf0, ".par");
					if(!access(buf0, 0) && 
					  !AskYes("The file exists!\nOverwite it?", buf0))
						goto quit;
					if((fp = fopenf(buf0,"wt")) == NULL){
						error(ERRPAUSE, "Cannot make %s", buf0);
						break;
					}
					msg = "";
					if(IsJapanese()){
						for(pt = buf2; *pt; pt++){
							if(issjis1(*pt)){
								msg = "j";
								break;
							}
						}
					}
					fprintf(fp, ";#%s %s\n", msg, buf2);
					for(msg = pt = buf3; *msg; ){
						while(*pt && *pt != 0x0a && *pt != 0x0d)
							pt++;
						if(!*pt)
							pt2 = pt;
						else if(!pt[1] || pt[0] == pt[1])
							pt2 = pt + 1;
						else
							pt2 = pt+2;
						*pt = 0;
						fprintf(fp, ";%c %s\n", ch, msg);
						pt = msg = pt2;
					}
					fprintf(fp, "%s", msg = 
					  PrintAllPara(IsDlgButtonChecked(hdwnd, IDC_ALLSET)?1:0));
					fclose(fp);
					error(C_MSG, "%s", msg);
					error(DATATITLE, "Saved:%s", buf2);

				case IDCANCEL:
quit:				EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_DESTROY:
			ReSetFont(hedit1);
			ReSetFont(hedit2);
			ReSetFont(hedit3);
			break;
	}
	return 0;
}


void EditFile(char *name)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	char cmd_buf[0x400];

	if(!AskYes("Do you really want to edit the above file?", name))
		return;
	sprintf(cmd_buf, "notepad.exe %s", name);
	memset( &si, 0, sizeof(STARTUPINFO) );
	memset( &pi, 0, sizeof(PROCESS_INFORMATION) );
	si.cb = sizeof(STARTUPINFO);
	si.dwFlags = STARTF_USESHOWWINDOW;
	si.wShowWindow = SW_NORMAL;
	CreateProcess(NULL, cmd_buf, NULL, NULL, FALSE,
		HIGH_PRIORITY_CLASS, NULL, NULL, &si, &pi);	
}

// CallBack
static BOOL CALLBACK DlgReadParaProc(HWND hdwnd, UINT message, UINT wParam, LONG lParam)
{
#define	MAX_MACRO	256
#define	MAX_MSG		256
	int i, j;
	char msg[MAX_MSG];
	char *s;
	FILE *fp;
	static int max_macro;
	static char path[MAX_PATH];
	static char *mac;
	static HWND hcombo;
	static int mode;

	switch(message){
		case WM_INITDIALOG:
			mode = 0;
			hcombo = GetDlgItem( hdwnd, IDC_LISTBOX1 );
			SetFont( 10, hcombo, IsJapanese()?"lr SVbN":"Courier New", IsJapanese() );
			// SetFontJE(hcombo);
renew:		SetPath(path, mode?"^x\\par\\*.pas":"^x\\par\\*.par");
			max_macro = 0;
			common_work[0]=0;
			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_RESETCONTENT, 0, 0); 
			for(s = FindFirstW32(path); s != NULL && max_macro < MAX_MACRO;
			  s = FindNextW32()){
				sprintf(path, "^x\\par\\%s", s);
				if((fp = fopenf(path, "r")) != NULL){
					*msg = i = 0;
					while(!i && fgets(msg, MAX_PATH, fp) && *msg==';'){
						if(msg[1]=='#'){
							switch(msg[2]){
								case 'j':
									i = f_English?0:3;
									break;
								case 'e':
									i = f_English?3:0;
									break;
								default:
									i = 2;
							}
						}
					}
					fclose(fp);
					if(i){
						if(msg[i] == ' ')
							i++;
						strcat(common_work, s);
						strcat(common_work, "\n");
						j = strlen(msg);
						while(j > 0 && msg[--j] <= ' ' && msg[j] > 0)
							msg[j] = 0;
						SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_ADDSTRING, 0,
						  (LPARAM)msg+i); 
						max_macro++;
					}
				}
			}
			if(max_macro >= MAX_MACRO)
				error(WARNING, "Too many (> %d) %s parameter files\nSome of them are ignored", 
					MAX_MACRO, mode?"Hidden":"");
			FindFirstW32(NULL);
			if(mac)
				Free0(mac);
			mac = dup_string(common_work);
			SendDlgItemMessage(hdwnd, IDC_LISTBOX1, LB_SETCURSEL, 0, 0);
			SetFocus(GetDlgItem(hdwnd, IDC_LISTBOX1));
			break;

		case WM_COMMAND:
			switch(LOWORD(wParam)){
				case IDC_PHELP:
					ShowWinHelp(IDH_PREPARA);
					break;

				case IDC_HIDDEN:	// <-> Current
					mode = 1-mode;
					SetDlgItemText(hdwnd, IDC_HIDDEN, mode? "->Curr&ent":"->Hidd&en");
					SetDlgItemText(hdwnd, IDC_ERACE, mode? "&Appear":"Hi&de");
					SetDlgItemText(hdwnd, ID_SAVE, mode? "Ki&ll":"&Save");
					goto renew;

				case ID_SAVE:		// <-> Kill
					if(!mode){
						DialogBox(g_winData.hInstance,
							MAKEINTRESOURCE(IDD_SAVEPARA),
							hdwnd, DlgSaveParaProc);
						goto renew;
					}
				case IDC_EDIT10:
				case IDC_ERACE:		// <-> Appear
				case IDOK:
					i = SendDlgItemMessage(hdwnd, IDC_LISTBOX1,
						LB_GETCURSEL, 0, 0L);
					if(!max_macro)
						return TRUE;
					if(i<0 && i >= max_macro)
						break;
					s = mac;
					while(i--){
						while(*s && *s++ != '\n');
					}
					i = 0;
					while(s[i] && s[i] != '\n')
						i++;
					s[i] = 0;
					j = (s[0] == '$' && s[1] == '_')?0x1000:0;
					sprintf(common_work, "^x\\par\\%s", s);
					s[i] = '\n';
					strncpy(common_work+0x800, common_work, MAX_PATH);
					SetPath(common_work+0x1000, common_work+0x800);
					if(LOWORD(wParam) == IDC_ERACE){			// Hide/Appear
						strcpy(common_work, common_work+0x1000);
						common_work[strlen(common_work)-1] =
							mode?'r':'s';
						if(rename(common_work+0x1000, common_work)){
							if(!access(common_work, 0) && MessageBox( g_winData.hMainWnd, 
							  common_work, 
							  "Duplicate file exists!\nErace the above?", 
							  MB_OKCANCEL) == IDOK ){
								unlink(common_work);
								if(!rename(common_work+0x1000, common_work))
									goto renew;
							}
							error(WARNING, "Cannot rename %s", common_work+0x1000);
							break;
						}
						goto renew;
					}else if(LOWORD(wParam) == ID_SAVE){		// Kill
						CheckParaFile(common_work+0x1000, "\nErace the above parameter file?");
						j = MessageBox( g_winData.hMainWnd, 
						    common_work, common_work+0x1000, MB_OKCANCEL);
						if(j == IDOK){
							unlink(common_work+0x1000);
							goto renew;
						}
					}else if(LOWORD(wParam) == IDC_EDIT10){		// Edit0
						EditFile(common_work+0x1000);
						break;
					}else{										// Ok
						j |= CheckParaFile(common_work+0x800, NULL);
						if(!mode & !(j&0x1f)){
							if(j & 0x1000)
								goto instreg;
							goto readpara;
						}
						j = MessageBox( g_winData.hMainWnd, 
							    common_work, common_work+0x1000, (j&0x1000)?
						    	MB_YESNOCANCEL:MB_OKCANCEL);
						if(j == IDYES){
instreg:					Install2Reg(common_work+0x1000);
							goto quit;
						}else if(j == IDNO || j == IDOK){
readpara:					set_config(common_work+0x1000);
							goto quit;
						}
					}
					break;

				case IDCANCEL:
quit:				Free0(mac);
					mac=NULL;
					EndDialog(hdwnd, 0);
					return TRUE;
			}
			break;

		case WM_DESTROY:
			ReSetFont(hcombo);
			break;

	}
	return 0;
}


HINSTANCE	ExecHref(HWND hwnd, char *href)
{
	HINSTANCE result;
	if(exec_para){
		result = 
		ShellExecute(hwnd, NULL, href, exec_para, NULL, SW_SHOWNORMAL);
		exec_para = NULL;
		return result;
	}
	return
		(browser==NULL || !*browser)?
		ShellExecute(hwnd, NULL, href, NULL, NULL, SW_SHOWNORMAL):
		ShellExecute(hwnd, NULL, browser, href, NULL, SW_SHOWNORMAL);
}

void CheckView(int size)
{
	int	pos;

	for(pos = 0; pos < 4; pos++)
		CheckMenu(ID_SCALE1+pos, pos==size);
}


#ifdef	DOUBLE_PAGE
extern int bmp_pt;

static BOOL DisplayPages(int ii)
{
	int xx, yy, pos, size;
	int old_GS, old_gbox, old_cmode, old_color;
	BYTE *pDibNew;

	if(IS_2PAGE){
		Clear2Page();
		CheckMenu(ID_DOUBLE, 0);
		CheckMenu(ID_RDOUBLE, 0);
		CheckMenu(ID_VDOUBLE, 0);
	}

	old_GS = f_GS;
	old_gbox = f_gbox;
	old_color = f_spcolor;
	old_cmode = f_rpcolor;
	f_GS = f_spcolor = f_rpcolor = 0;
	f_gbox = TRUE;

	xx = GetXGray()*ii;
	yy = GetYGray()*ii;
	f_2top = pos = GetCurrentPage();
	ExpandPage0();					// to validitate f_gbox etc..
	AddKeepBMP(0);
	ClearKeepBMP();
	for(size = 0; ;){
		pDibNew = GetWindowBMP(0, 0, GetTextXSize(), GetTextYSize(),
			xx, yy, NULL);
		if(pDibNew == NULL)
			return FALSE;
		f_GS = 1;
		DisplayBMP(pDibNew, 
			(size%ii)*GetTextXSize()/ii, (size/ii)*GetTextYSize()/ii,
			(GetTextXSize()+ii-1)/ii, (GetTextYSize()+ii-1)/ii, 1);
		f_GS = 0;
		pos = GetCurrentPage();
		AddKeepBMP(1);
		if(++size >= ii*ii || pos == ChgPage(pos + 1))
			break;
		ExpandPage0();
	}
	f_GS = old_GS;
	f_gbox = old_gbox;
	f_spcolor = old_color;
	f_rpcolor = old_cmode;
	ClearKeepBMP();
	return TRUE;
}

BYTE *Get2Bmp(void)
{
	int c_page, temp_page;
	BOOL old_dvioutspecial;

	old_dvioutspecial = f_dvioutspecial;
	f_dvioutspecial = FALSE;
	Clear2Page();
	temp_page = IsSecondPage(c_page=GetCurrentPage())?-1:1;
	if(temp_page < 0)
		f_2page |= F_2DIB2;
	else
		f_2page &= ~F_2DIB2;
	p2Page = PageDup();
	last_bmp = AddKeepBMP(1);
	pDib2 = GotoPage(GetCurrentPage() + temp_page);
	if(pDib2 == NULL){
		Free0(p2Page);
		p2Page = NULL;
	}else
		pDib2 += sizeof(BITMAPFILEHEADER);
	AddKeepBMP(0);
	f_dvioutspecial = old_dvioutspecial;
	return(pDib2);
}

static int GetShiftPage(int page)
{
	int pos;

	if(IS_2PAGE){
		pos = GetCurrentPage();
#ifdef	DOUBLE_PAGE
		if(b_presentation_mode && IS_2VERT){
			if(page == 1){
				if(pos < GetTotalPage() - 1)
					SetPoint(0,-GetTextYSize(),-3);
				ChgPage(pos-1);
				pos--;
			}else if(page == -1 && pos > 0){
				SetPoint(0,GetTextYSize(),-3);
				page = -2;
			}
			if(pos + page >= GetTotalPage() - 1)
				page = GetTotalPage() - 2;
			if(pos + page <= 0)
				page = -pos + 1;
			f_2page &= ~F_ODD2EVEN;
			if((page + pos) & 1)
				f_2page |= F_ODD2EVEN;
		}
		else 
#endif
		if(page == -1 &&
		  (pos != 2 || (IS_ODD2EVEN) != 0) )
			page = -2;
		else if(page == 1 &&
		  (pos != GetTotalPage() - 1 || !IsSecondPage(pos)) )
			page = 2;
	}
	return page;
}
#else
#define GetShiftPage(x)	(x)
#endif

void Clear2Page(void)
{
#ifdef	DOUBLE_PAGE
	if(pDib2)
		FreeBmp(pDib2);
	Free0(p2Page);
	p2Page=pDib2=NULL;
#endif
}

static BOOL f_macro;
static struct DVIINFO w;   // Windows ̏
static int timer_id;

static void CALLBACK Timer9Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	if(CheckRenew(0) == 1){
		id_dvi++;
		PostMessage( g_winData.hWnd, WM_COMMAND, MAKEWPARAM(ID_REOPEN,0), 0L );
	}
}

static void CALLBACK Timer7Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	KillTimer(g_winData.hMainWnd, 7);
	PostMessage( g_winData.hWnd, WM_USER_EXECMACRO, 0, 0 );
}

static void CALLBACK Timer10Proc(HWND hWnd, UINT uMsg, UINT idEvent, DWORD dwTime)
{
	KillTimer(g_winData.hMainWnd, 10);
	DisplayMessage(NULL);
}

static char *TransMessage(char *buf, char **msg, char **title)
{
	char *top, *end, *med;
	int pos;

	top = buf;
	while(*top == ' ')
		top++;
	if(top[0] != '`'  || top[1] != '\''){
no_blk:	*msg = buf;
		*title = NULL;
		return NULL;
	}
	end = strstr(top, "'` ");
	pos = strlen(top);
	if(end == NULL && top[pos-2] == '\'' && top[pos-1] == '`')
		end = top + pos - 2;
	if(end == NULL)
		goto no_blk;
	*end = 0;
	end += 2;
	while(*end == ' ')
		end++;
	top += 2;
	med = strstr(top, "`'");
	if(med == NULL){
		*title = NULL;
		*msg = top;
		return (*end)?NULL:end;
	}
	*title = top;
	*med = 0;
	*msg = med += 2;
	while( (med = strstr(med, "`'")) != NULL){
		*med++ = ' ';
		*med = '\n';
	}
	return (*end)?end:NULL;
}

void TempMessage(char *msg, int num)
{
	DisplayMessage(msg);
	SetTimer(g_winData.hMainWnd, 10, num, (TIMERPROC)Timer10Proc);
}


static void TransDot(char *msg)
{
	char *s;
#define is_hex(c)   ((c>='0'&&c<='9')||(c>='a'&&c<='f')||(c>='A'&&c<='F'))
#define hex_to_dig(c)   ((c>='0'&&c<='9')?(c-'0'):(toupper(c)-('A'-10)))

	s = msg;
	if(*msg == '.'){
		if(is_hex(msg[1]) && is_hex(msg[2]))
			*msg = ' ';
		else if(msg[1] == '.')
			msg++;
	}
	while(*msg){
		if(*msg == ' '){
			if(is_hex(msg[1]) && is_hex(msg[2])){
				*s++ = hex_to_dig(msg[1])*16+hex_to_dig(msg[2]);
				msg += 3;
				continue;
			}
			if(msg[1] == ' ')
				msg++;
		}
		*s++ = *msg++;
	}
	*s=0;
}

/*
 * mode 0: key, parameter
 *      1: dviout special
 *      2: HyperTeX dviout special
 *      3: DDE
 */
int DoMacro(char *para, int mode)
{
	int		key_id, num, i;
	char	*tmp, *msg, *title, *buf, sep, tmp2[2];

	if(f_macro){
		error(WARNING, "Nesting of dviout special: %s", para);
		return 1;
	}
	f_macro = TRUE;
	if( (para = buf = dup_string(para)) == NULL )
		return 1;
nxt:
	while(*para == ' ')
		para++;
	if(*para == '`'){
nxt_sp:	if(!strncmp(++para, "timer ", 6)){			// [timer]
			if( mode == 1 ){						// dviout specials
				para += 6;
				while(*para == ' ')
					para++;
				num = atoi(para);
				while(*para > ' ')
					para++;
				while(*para == ' ')
					para++;
				if(*para)
					goto to_wait;
wait:			if(timer_id){						// timer remains
					KillTimer(g_winData.hMainWnd, 7);
					timer_id = 0;
				}
				if( num > 0 )
					SetTimer(g_winData.hMainWnd, 7, num, (TIMERPROC)Timer7Proc);
				else
					PostMessage( g_winData.hWnd, WM_USER_EXECMACRO, 0, 0 );
				timer_id = id_page;
				Free(buf);
				return f_macro = FALSE;
			}else
				error(WARNING, 
					"`timer is not allowed in key macro nor in HyperTeX\n");
		}else if(!strncmp(para, "wait", 4) && para[4] <= ' '){
			para += 4;								// [wait] = timer 0
			goto to_wait0;
		}else if(!strncmp(para, "href ", 5)){		// [href]
			para += 5;
			while(*para <= ' ' && *para)
				para++;
			if(*para)
				PostMessage(g_winData.hWnd,WM_USER_EXECHYPER,0,
					(LONG)(dup_string(para)));
		}else if(!strncmp(para, "keep ", 5)){		// [keep]
			para += 5;
			while(*para <= ' ' && *para)
				para++;
			KeepParaSpecial(para);
		}else if(!strncmp(para, "restore", 7) && para[7] <= ' ')
			RestoreParaSpecial();					// [restore]
		else if(!strncmp(para, "in ", num=3)){		// [in]
toclip:		strcpy(common_work, "Clipboard < ");
			if(strlen(para)<0x100){
				strcat(common_work, para+num);
				tmp = common_work + 12;
			}else
				tmp = para+num;
			if(num < 6)
				TransDot(tmp);
			i = HIBYTE(GetKeyState(VK_CONTROL));
			if((i && !f_Din) || (!i && f_Din))
				Copy2Editor(g_winData.hWnd, tmp, HIBYTE(GetKeyState(VK_MENU)));
			else{
				if(num != 4)
					TempMessage(common_work, 1000);
				if(HIBYTE(GetKeyState(VK_MENU)) != 0)
					Add2Clipboad(g_winData.hWnd, tmp);
				else
					Copy2Clipboad(g_winData.hWnd, tmp);
			}
		}else if(!strncmp(para, "in* ", num=4))		// [in*]
			goto toclip;
		else if(!strncmp(para, "input ", num=6))	// [input]
			goto toclip;
		else if(!strncmp(para, "message ", 8)){		// [message]
			para = TransMessage(para+8, &msg, &title);
			error(C_MSG, msg);
			error(DATATITLE, title?title:"message");
			if(para != NULL)
				goto nxt;
		}else if(!strncmp(para, "ask ", 4)){		// [ask]
			para = TransMessage(para+4, &msg, &title);
			if(para != NULL && msg != NULL){
				para = strstr(para, 
					AskYes(msg, title?title:"Question")?"`yes ":"`no ");
				if(para){
					para += 4;
					goto nxt;
				}
			}
		}else if(!strncmp(para, "yes ", 4) || !strncmp(para, "no ", 3))
			goto end;								// [yes] [no]
		else if(!strncmp(para, "sp ", 3))			// [sp]
			do_special(para+3);
		else if(*para == '"'			// `"....."`  multi-statement
			  && (tmp = strstr(para+1, "\"`")) != NULL
			  && tmp[2] <= ' '){
				*tmp = 0;
				f_macro = FALSE;
				DoMacro(para+1,mode);
				f_macro = TRUE;
				*tmp = '"';
				para = tmp + 2;
				goto to_wait0;
		}else
			error(WARNING, "Unknown dviout special: %s", para-1);
		goto end;
	}
	while(*para){
		if(*para <= ' '){
			para++;
			continue;
		}
		if(*para== '-'){
			for(tmp = para; *tmp != '=' && *tmp != ':'; tmp++){
				if(!*tmp)
					goto end;
			}
			tmp++;
			if(!*tmp)
				goto end;
			if(*tmp == '"')
				sep = '"';
			else if(*tmp == '\'')
				sep = '\'';
			else sep = 0;
			while(*++tmp){
				if(sep){
					if(*tmp == sep){
						tmp++;
						break;
					}
				}else if(*tmp <= ' ')
					break;
			}
			sep = *tmp;
			*tmp = 0;
			if(!f_seamless && (mode == 1 || mode == 2))
				f_secure = mode;
			SetPara(para, SET_OPTION);
			f_secure = 0;
			*(para = tmp) = sep;
		}else if(*para == ';'){
			if(*++para){
to_wait0:		num = 0;
to_wait:		while(*para == ' ')
					para++;
				if(strlen(para) >= MAX_MACROSIZE-1)
					error(WARNING, "Wait too long key macro %s", para);
				else if(*para){
					waiting_macro_mode = mode;
					for(i = 0; (waiting_macro[i] = para[i]) != 0; i++);
					goto wait;
				}else
					waiting_macro[0] = 0;
			}
		}else{
			if(!para[1])
				goto end;
			if(para[0] == '`')
				goto nxt_sp;
			tmp2[0] = toupper(para[0]);
			tmp2[1] = toupper(para[1]);
			key_id = KeyId(tmp2);
			if(key_id <= 1){
				error(WARNING, "KEY ID %c%c is not defined",para[0], para[1]);
				break;
			}
			if(key_id == ID_REOPEN && mode == 1)
				key_id = ID_REOPENMACRO;
			if(tmp2[0] == para[0] && tmp2[1] == para[1])
				 SendMessage( g_winData.hMainWnd, WM_COMMAND, 
					MAKEWPARAM( key_id, 0 ), 0 );
			else
				 PostMessage( g_winData.hMainWnd, WM_COMMAND, 
					MAKEWPARAM( key_id, 0 ), 0 );
			para += 2;
		}
	}
end:
	f_macro = FALSE;
	Free(buf);
	return 1;
}

void key_in(unsigned char *s)
{
	DoMacro(s, 0);
}

void PostClearMacro(void)
{
	PostMessage(g_winData.hMainWnd, WM_USER_CLEARMACRO, 0, 0 );
}

int SetStatusWindow(void)
{
	int curpage, lastpage, nombrepage;
	char szText[64];

	if(w.pDib == NULL){
		SetStatusBar( 0, "Not Opened DVI." );
		SetStatusBar( 1, "dpi:" );
		SetStatusBar( 2, "Gamma:" );
		SetStatusBar( 3, "Size:" );
		return -1;
	}
	curpage = GetCurrentPage();
	lastpage = GetTotalPage();
	nombrepage = GetMaxNombrePage();
	wsprintf( szText, "Page: %d/%d, number %d/%d",
		curpage, lastpage, TransPage(curpage), nombrepage);
	SetStatusBar( 0, szText );
	wsprintf( szText, "dpi: x=%d/%d, y=%d/%d",
		GetXDpi(), GetXGray(), GetYDpi(), GetYGray() );
	SetStatusBar( 1, szText );
	wsprintf( szText, "Gamma = %d/1000", gray_number );
	SetStatusBar( 2, szText );
	sprintf( szText, "Size: x = %.2fcm, y = %.2fcm",
		(double)GetTextXSize()/GetXDpi()*2.54,
		(double)GetTextYSize()/GetYDpi()*2.54 );
	SetStatusBar( 3, szText );
	return curpage;
}

/*
 *  mode 0: relative under coordinate in screen
 */
void MoveCover(int x, int y, int mode)
{
	RECT rc;
	int xx, xxx, xs, xg, yy, yyy, ys, yg;

	xg = GetXGray();
	yg = GetYGray();
	xs = GetTextXSize();
	ys = GetTextYSize();

	if(!y || !(f_coverH&1))
		goto movex;
	yy = cover_ypos;
	if(!mode)
		cover_ypos += y*yg;
	else
		cover_ypos = y;
	if(cover_ypos < 0)
		cover_ypos = 0;
	else if(cover_ypos > ys)
		cover_ypos = ys;
	if(cover_ypos > yy)
		yyy = cover_ypos;
	else if(cover_ypos < yy){
		yyy = yy;
		yy = cover_ypos;
	}else
		goto movex;
	if(f_coverH & 2){
		rc.left = g_nxIndent - w.nHscrollPos + cover_xpos/xg;
		rc.right = g_nxIndent - w.nHscrollPos + xs/xg + 1;
	}else{
		rc.left = g_nxIndent - w.nHscrollPos;
		rc.right = rc.left + (xs - cover_xpos)/xg + 1;
	}
	rc.top = g_nyIndent - w.nVscrollPos + yy/yg;
	rc.bottom = rc.top + (yyy - yy)/yg + 1;
	InvalidateRect( g_winData.hWnd, &rc, FALSE );
movex:
	if(!x || !(f_coverH&6))
		return;
	xx = cover_xpos;
	if(!mode){
		if(f_coverH & 2)
			cover_xpos += x*xg;
		else
			cover_xpos -= x*xg;
	}else{
		if(f_coverH & 2)
			cover_xpos = x;
		else
			cover_xpos = xs - x;
	}
	if(cover_xpos < 0)
		cover_xpos = 0;
	else if(cover_xpos > xs)
		cover_xpos = xs;
	if(cover_xpos > xx)
		xxx = cover_xpos;
	else if(cover_xpos < xx){
		xxx = xx;
		xx = cover_xpos;
	}else
		return;
	rc.bottom = g_nyIndent - w.nVscrollPos + ys/yg + 1;
	rc.top = g_nyIndent - w.nVscrollPos + cover_ypos/yg - 1;
	if(f_coverH & 2)
		rc.left = g_nxIndent - w.nHscrollPos + xx/xg;
	else
		rc.left = g_nxIndent - w.nHscrollPos + (xs - xxx)/xg;
	rc.right = rc.left + (xxx - xx)/xg + 1;
	InvalidateRect( g_winData.hWnd, &rc, FALSE );
}

static BOOL f_timer8;

void KillTimer8(void)
{
	if(f_timer8){
		KillTimer(g_winData.hMainWnd, 8);
		f_timer8 = FALSE;
	}
}

static void KillCursor(void)
{
	KillTimer8();
	if(f_ShowCursor){
		ShowCursor(FALSE);
		f_ShowCursor = FALSE;
		cur_pt.x = INIT_CUR_PT;
	}
}

static void ActivateCursor(void)
{
	if(!f_ShowCursor){
		ShowCursor(TRUE);
		f_ShowCursor = TRUE;
	}
}

static void CALLBACK Timer8Proc(HWND hWnd, UINT uMsg, UINT idEvent, 
	DWORD dwTime)
{
	POINT pt;

	GetCursorPos(&pt);
	if(g_winData.hWndPresenMenu){
		GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
		if(  pt.x >= pmenu.left && pt.x <= pmenu.right
		  && pt.y >= pmenu.top  && pt.y <= pmenu.bottom)
			return;
//		if(f_pmshow && (pmenu.left || pmenu.top) ){
//			ShowWindow(g_winData.hWndPresenMenu, SW_HIDE);
//			f_pmshow = FALSE;
//		}
	}
	if(  pt.x < cur_pt.x + CUR_STOP && cur_pt.x < pt.x + CUR_STOP
	  && pt.y < cur_pt.y + CUR_STOP && cur_pt.y < pt.y + CUR_STOP ){
		KillCursor();
	}else{
		cur_pt.x = pt.x;
		cur_pt.y = pt.y;
	}
}

static void CheckCursor(void)
{
	KillTimer8();
	SetTimer(g_winData.hMainWnd, 8, 2000, (TIMERPROC)Timer8Proc);
	f_timer8 = TRUE;
	GetCursorPos(&cur_pt);
}

/*
   MessageBox with showing cursor (presentation mode)
 */
unsigned int MessageCBox(HWND hwnd, char *title, char *msg, unsigned int id)
{
	unsigned int val;

	if(b_presentation_mode){
		KillTimer8();
		ActivateCursor();
	}
	val = MessageBox(hwnd, title, msg, id);
	if(b_presentation_mode)
		KillCursor();
	return val;
}


static VOID SaveImage(int mode, char *name)
{
	int top, bottom;
	double fx, fy, fw, fh;

	if(!f_rectcut || !mode){
		rectcut.top = 0;
		rectcut.left = 0;
		rectcut.right = GetTextXSize();
		rectcut.bottom = GetTextYSize();
	}
	if(rectcut.top > rectcut.bottom){
		top = rectcut.bottom;
		bottom = rectcut.top;
	}else{
		top = rectcut.top;
		bottom = rectcut.bottom;
	}
	fx = ((double)GetParaInt("OX")/0x10000/72.27
		- (double)rectcut.left/GetXDpi())*2.54;
	fy = ((double)GetParaInt("OY")/0x10000/72.27
		-(double)top/GetYDpi())*2.54;
	fw = (((double)(rectcut.right - rectcut.left + 1))/GetXDpi())*2.54;
	fh = (((double)(bottom - top + 1))/GetYDpi())*2.54;
	common_work[0x800] = 0;
	SetPath(common_work+0x800, common_work);
	GSPN(common_work+0x800, common_work+0x1000);
	sprintf(common_work, 
		"%s %.3fcm %.3fcm %.3fcm %.3fcm %d \"%s\" \"%s\" %d %d",
		common_work+0x1000, 
		fx+2.54, fy+2.54, fw, fh, GetCurrentPage(), 
		name, current_name,
		fx, fy);
	system(common_work);
}

/*
 mode 0: Inquire cutting
      1: Execute cutting
*/
static BOOL RectCut(int mode)
{
	double fx, fy;
	int top, bottom;
	char para[0x100];

	if(!f_rectcut)
		return FALSE;
	if(  rectcut.top == 0
	  && rectcut.left == 0
	  && rectcut.right == GetTextXSize()
	  && rectcut.bottom == GetTextYSize() )
		return FALSE;
	if(!mode)
		return TRUE;

	if(rectcut.top > rectcut.bottom){
		top = rectcut.bottom;
		bottom = rectcut.top;
	}else{
		top = rectcut.top;
		bottom = rectcut.bottom;
	}
	fx = ((double)GetParaInt("OX")/0x10000/72.27
		- (double)rectcut.left/GetXDpi())*2.54;
	fy = ((double)GetParaInt("OY")/0x10000/72.27
		-(double)top/GetYDpi())*2.54;
	sprintf(para, 
		"OX=%.3fcm OY=%.3fcm y=F%ddot/%ddpi:%ddot/%ddpi",
		fx, fy,
		rectcut.right - rectcut.left + 1, GetXDpi(),
		bottom - top + 1, GetYDpi());
	SetPara(para, SET_OPTION);
	ExpandPage();
	return TRUE;
}


/*
  Set string href in common_work from search string
*/
static char *Search2Href(char *s)
{
	if(*s != ' ')
		return NULL;
	if(s[1] >= '0' && s[1] <= '9'){		// page or line number (src special)
		sprintf(common_work+0x800, "#%s", s);
		return common_work+0x800;
	}
	if(s[1] == '#'){					// HyperTeX
		strcpy(common_work+0x800, s+1);
		return common_work+0x800;
	}
	if(s[1] == '='){					// http:
		strcpy(common_work+0x800, s+2);
		return common_work+0x800;
	}
	return NULL;
}

static int CheckStop(int mode)
{
	char *s, *t, *u;
	int page;
	static char sfname[0x82];	// keep filename
	static int spage = 1;		// keep the last page
	static int slevel;			// keep the stop_level

	if(mode == 1){
		spage = 0;
		slevel = 0;
		return 0;
	}
	if(!mode){
//		it doesn't seem that stop_level may be minus.
//      stop_max ??? (if the previous page has no stop special...)
//		if((f_killstop = f_kill) == TRUE || stop_max <= 0 || stop_level < 0)
		if((f_killstop = f_kill) == TRUE )
			return 0;
	}
	s = strstr(g_szFileName, ".dvi");
	if(s == NULL)
		s = g_szFileName+strlen(g_szFileName);
	page = GetCurrentPage();
	if( (t = s - 0x80) < g_szFileName)
		t = g_szFileName;
	if(*sfname && !strncmp(t, sfname, strlen(sfname))){
											/* same dvi file */
		if(mode){
			if(page == spage && (f_killstop = f_kill) == FALSE)
				stop_level = slevel;
			return 0;
		}
		if(page < spage ){					/* the former page */
			if(page == spage - 1){
				f_killstop = FALSE;
				stop_level = slevel;
			} else
				f_killstop = TRUE;
			return 0;
		} else {								/* the same or latter page */
cnt:		if(stop_level < stop_max){
				spage = page;
				slevel = ++stop_level;
				return 1;
			}else{
				if(page < GetTotalPage()){
					spage = page+1;
					slevel = stop_level = 0;
				} else{
					/* If you press space bar at the last page... */
					spage = 1;
					slevel = stop_level = 0;
					f_killstop = FALSE;
					return 0;
				}
				return 0;
			}
		}
	}else{
		if(mode)
			return 0;
		for(u = sfname; t < s; )			/* copy filename */
			*u++ = *t++;
		*u = 0;
		spage = GetCurrentPage();
		goto cnt;
	}
}

// Window R[obN̖{
static BYTE *pDibKeep=NULL;
BOOL f_pDibKeep=TRUE;

LRESULT CALLBACK WndProc( HWND hwnd, UINT message, UINT wParam, LONG lParam )
{
	static UINT uFindMessage;
	short nVscrollInc;	// ۰ق̑
	short nHscrollInc;	// ۰ق̑
	static int mpty, mptx;		// Client Coordinate
	static int mptyy, mptxx;	// Client Coordinate
	HINSTANCE hShell;
	BYTE* pDibNew = NULL; 		 // DIB߲ 
	char* href = NULL;
	char* tmpname;
	BOOL *toggle;
	FILE *fp;
//	HDC	  hdc;			// ޲÷ -- gp
	POINT pt;
	int	 temp_page;
	int	 size;
	int	 pos;
	int	 xx, yy;
	UINT id_value;
	char  fname[MAX_PATH];
	static RECT rc;
	RECT rcStop;
	int inf_size;
	static BOOL bShowingHref = FALSE;
	static LONG wl = 0;
	static COLORREF wbk_color, pr_color;
	static LONG wlc = 0;
	BOOL f_h_renew = FALSE;
	static bOnHref = FALSE;
	static bOnHrefPress = FALSE;

	/* BITMAPFILEHEADERDIB̊i[郁AhX */

	if(message == uFindMessage){		/* Call back from FindText() */
		LPFINDREPLACE lpfr = (LPFINDREPLACE)lParam;
		if(lpfr->Flags & FR_FINDNEXT){
			char szText[MAX_FIND_LEN+1];
			f_hist_msg = F_HM_SEARCH;
			SaveH_Hist(&w, 1);
			if( w.pDib != NULL
				&& lpfr->lpstrFindWhat[0] == ' '){	/* hyperjump */
				sprintf(href = common_work, "#%s", lpfr->lpstrFindWhat);
				goto do_href;
			}
			AddStringToCombo( lpfr->lpstrFindWhat );
			SetStringToCombo( lpfr->lpstrFindWhat );
			if(SearchStr(&w, lpfr, 1))
				goto show;
notfound:	// pDibNew = MakeBMP();
			wsprintf( szText, "Target string = \"%s\"", szFindOld );
			ShowMessage(szText, "Not found", SM_OKCONT);
			goto re_open;
		}
		if(lpfr->Flags & FR_DIALOGTERM)
			g_winData.hWndFind = NULL;
	}

	switch( message )
	{
//		unsigned char szTemp[MAX_KEYDEF];
		case WM_CREATE: /* ޳쐬悤ƂĂ
				(LPCREATESTRUCT)lParam:structure with creation data */
			g_winData.hInstance = ((LPCREATESTRUCT)lParam)->hInstance;
			memset(&fr, 0, sizeof(FINDREPLACE));
			uFindMessage = RegisterWindowMessage(FINDMSGSTRING);
			fr.lStructSize = sizeof(FINDREPLACE);
			f_HandMouse = FALSE;
			f_HandMoving = FALSE;
//			f_Pen = FALSE;
			f_CoverMoving = 0;
			f_Capturing = FALSE;
			f_Loupe = FALSE;
			DragAcceptFiles( hwnd, 1);
			return 0;

		case WM_SIZE:  /*		wPraram:resizing flag
						 LOWORD(lParam):width of client area
						 HIWORD(lParam):height of client area */
			/* ޳̻ނݒ肷 */
			w.cxClient = LOWORD(lParam);
			w.cyClient = HIWORD(lParam);
			ArrangeScroll(&w, 0);
			return 0;

		case WM_USER_INITIATE:
			NotifyDviinfo(&w);
			GetClientRect( g_winData.hWnd, &rc );
			/* Modify scrollbar style */
			w.cxClient = rc.right - rc.left;
			w.cyClient = rc.bottom - rc.top;
			if( f_flatscroll && GetVersionLevel() > 0 )
			{
				g_InitializeFlatSB( g_winData.hWnd );
				g_FlatSB_SetScrollProp( g_winData.hWnd, WSB_PROP_VSTYLE,
					FSB_ENCARTA_MODE,
					 TRUE );
				g_FlatSB_SetScrollProp( g_winData.hWnd, WSB_PROP_HSTYLE,
					FSB_ENCARTA_MODE,
					 TRUE );
				g_FlatSB_SetScrollRange( g_winData.hWnd, SB_VERT, 0, 0, TRUE );
				g_FlatSB_SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 0, TRUE );
			}
			else
			{
				SetScrollRange( g_winData.hWnd, SB_VERT, 0, 0, TRUE );
				SetScrollRange( g_winData.hWnd, SB_HORZ, 0, 0, TRUE );
			}

			pos = !(f_hyper & F_H_IGNORE)?TRUE:FALSE;
			SendMessage( g_winData.hWndToolBar, TB_CHECKBUTTON, ID_HYPER, MAKELONG(pos,0));
			EnableMenuItem( g_winData.hMenu, ID_HYPERTEX, pos?MF_ENABLED:MF_GRAYED );
			EnableMenuItem( g_winData.hMenu, ID_SRCSPECIAL, pos?MF_ENABLED:MF_GRAYED );
			if(log_file != NULL && *log_file != '-')
				f_log = TRUE;
			CheckMenu(ID_LOGOPEN, f_log);
			fr.Flags = RestoreInt( "FIND", "flag", FR_MATCHCASE|FR_WHOLEWORD)
			 |FR_DOWN;
			fr.wFindWhatLen = MAX_FIND_LEN;
			fr.hwndOwner = g_winData.hWnd;	
				/* R[h̍\Ȃíj߂
				eEBhEDVIEBhEɂĂ */
			fr.lpstrFindWhat = szFind;
#if 0
			RestoreBinary( szTemp, MAX_KEYDEF, "KeyTable", "Key", 0xff );
			while(i = 0; i < MAX_KEYDEF; i++)
				if(szTemp[i] == 0xff)	return 0;
			if(i < MAX_KEYDEF)
				memcpy( key_table, szTemp, MAX_KEYDEF );
#endif
			InitMenuItems();
			return 0;

		case WM_LBUTTONDBLCLK:
			if(w.pDib == NULL)
				break;
			if(IS_MPAGE)
				goto lbutton16;
			if (b_presentation_mode && (f_coverB & 1))
				break;
			Win2BufPoint(&w, &pt, LOWORD(lParam), HIWORD(lParam));
			pos = IsHyperTag();
			if((pos = IsHyperTag()) <= 0 || !GetS_Count(0))
				goto gedit;			// No source special
			PickUpString(pt.x, pt.y, 2);
			ExpandPage();
gedit:		if(exec_gsrc_sp && exec_gsrc_sp[0] && f_gedit){
				tmpname = GetFigurePath(pt.x, pt.y, 1);
				if(tmpname)
					ToGSource(tmpname);
			}
			break;

		case WM_LBUTTONDOWN:
			f_l_down = 1;
			/* We check whether mouse cursor is "hand" mode.
			   if "hand" mode, it means that users want to scroll. */
			if( f_Loupe == TRUE || !(IsMouseInDVIWindow( w, &pt )&2) )
				break;
			SetFocus( g_winData.hWnd );
			if(b_presentation_mode && (f_coverB & 1))
				goto downpage;
			if(HIBYTE(GetKeyState(VK_SHIFT)) != 0){
				if(w.pDib != NULL){
					Win2BufPoint(&w, &pt, LOWORD(lParam), HIWORD(lParam));
					if(f_rectcut){
						if(b_presentation_mode){
							if(HIBYTE(GetKeyState(VK_CONTROL)))
								SetPoint(pt.x, pt.y, 0x80);
							else{
								SetPoint(pt.x, pt.y, 0);
								rc.left = LOWORD(lParam) - 4;
								rc.right = LOWORD(lParam) + 4;
								rc.top = HIWORD(lParam) - 4;
								rc.bottom =HIWORD(lParam) + 4;
								inval = &rc;
							}
						}
					  	else if(pt.x <= rectcut.right){
							rectcut.left = pt.x;
							rectcut.top = pt.y;
						}
					  	goto show;
					}
					PickUpString(pt.x, pt.y, 
						HIBYTE(GetKeyState(VK_CONTROL))?1:(f_directsrc?2:0));
					ExpandPage();
				}
				break;
			}
/*
			exec_para = NULL;
			if( f_hypertex && (href = GetHref(&w, LOWORD(lParam), HIWORD(lParam))) != NULL)
				goto hpjp;
*/
			if( f_hypertex && (href = GetHref(&w, LOWORD(lParam), HIWORD(lParam))) != NULL)
			{
				HANDLE h = GetCursor();
				bOnHrefPress = TRUE;
				if( GetCursor() != g_winData.hPointPushCursor ){
					SetCursor( g_winData.hPointPushCursor );
				}
			}

			if( f_HandMouse || f_Pen )
			{
				HCURSOR hcur2;
				mptx = pt.x, mpty = pt.y;

				if( b_presentation_mode && (f_cover == 1) && !f_2page &&
					w.nVscrollMax == 0 && w.nHscrollMax == 0 ){
cover_on:			f_CoverMoving = f_coverH & 1;
					if(f_coverH & 6)
						f_CoverMoving |= 2;
				}

				switch(f_CoverMoving){
					case 1:
						hcur2 = g_winData.hNSCursor;
						break;
					case 2:
						hcur2 = g_winData.hWECursor;
						break;
					case 3:
						hcur2 = g_winData.hALLCursor;
						break;
					default:
						if( b_presentation_mode )
							hcur2 = (f_Pen)?
								g_winData.hLaserPointer:g_winData.hLaserHand;
						else
							hcur2 = (f_Pen)?
								g_winData.hNormalCursor:g_winData.hMoveHandCursor;
						break;
				}
				if( !f_Capturing )
				{
					SetCapture( g_winData.hWnd );
					f_Capturing = TRUE;
				}
				if( !GetCursor() && GetCursor() != hcur2 )
				{
					SetCursor( hcur2 );
					if(f_CoverMoving){
						if(f_CoverMoving & 1)
							pt.y = cover_ypos/GetYGray() - w.nVscrollPos
								+ g_nyIndent;
						if(f_CoverMoving & 2){
							if(f_coverH & 2)
								pt.x = cover_xpos/GetXGray() - w.nHscrollPos
									+ g_nxIndent;
							else if(f_coverH & 4)
								pt.x = (GetTextXSize() - cover_xpos)/GetXGray()
									- w.nHscrollPos + g_nxIndent;
						}
						mptxx = mptx;
						mptyy = mpty;
						if( pt.x >= 0 && pt.x <= w.cxClient
						 && pt.y >= 0 && pt.y <= w.cyClient
						 && ( mptx != pt.x || mpty != pt.y) ){
							mptx = pt.x;
							mpty = pt.y;
							ClientToScreen(g_winData.hWnd, &pt);
							SetCursorPos(pt.x, pt.y);
						}
					}
				}
				f_HandMoving = TRUE;
			}else if(IS_MPAGE)
				goto lbutton16;
			break;

		case WM_USER_CLEARMACRO:
			id_current_macro = 0;
			if(timer_id)
				KillTimer(g_winData.hMainWnd, 7);
			timer_id = 0;
			break;

		case WM_USER_EXECHYPER:
			strcpy(href = common_work + 0x2000, (char *)lParam);
			Free0((char *)lParam);
			goto hpjp0;

hpjp:											// Get Hyper Reference
			xx = HIBYTE(GetKeyState(VK_CONTROL));
			if((xx && !f_Din) || (!xx && f_Din)){
				if(!strncmp(href, "dviout:", 7) ){
					for(pos = 7; href[pos] == ' ' ; pos++);
					if( !strncmp(href+pos, "`in", 3) )
						goto hpjp0;
				}
			}
			if(xx && !f_Din && MessageCBox(g_winData.hMainWnd, 
					"Execute the above Hyper Jump", 
					href, MB_YESNO|MB_ICONQUESTION) != IDYES ){
						exec_para = NULL;
						break;
			}
hpjp0:		if(*href != '#'){
				if( (pos = CheckHrefDvi(href, &g_szFileName[0])) >= 4){
					if(pos == 5){
						CoverSuspend();
						goto opendvi1;
					}else if(pos == 4)
						hShell = ExecHref(hwnd, common_work);
					else if(pos == 0x10){
						DoMacro(common_work, 2);
						return 0;
					}
				}else{
					if(pos > 1 || exec_para != NULL)
						href = common_work;
					else if(base_href[0] != 0 && !strchr(href, ':')){
						strcpy(common_work, base_href);
						temp_page = strlen(common_work);
						while(--temp_page >= 0){
							if(  common_work[temp_page] == '/'
							  || common_work[temp_page] == ':')
								break;
						}
						if(href[0] == '/' || href[0] == '\\'){
							if(href[1] == '/'){
								if((tmpname = strchr(common_work, ':')) != NULL)
									strcpy(tmpname+1, href);
								else
									strcpy(common_work+temp_page, href);
							}else{
								if((tmpname = strstr(common_work, "//")) != NULL
									&& (tmpname = strchr(tmpname+2, '/')) != NULL)
									strcpy(tmpname, href);
								else
									strcpy(common_work+temp_page, href);
							}
						}else{
							if(href[0] == '.'){
								if(href[1] == '/')
									strcpy(common_work+ temp_page + 1, href+2);
								else if(href[1] == 0)
									common_work[temp_page+1] = 0;
								else if(href[1] == '.' && href[2] == 0)
									strcpy(common_work+ temp_page + 1, "../");
								else
									goto hhref;
							}else
hhref:							strcpy(common_work+ temp_page + 1, href);
						}
						href = common_work;
					}
					strcpy(common_work + 0x1000, 
						"Execute the above Hyper Jump");
					if(exec_para)
						sprintf(common_work + (0x1000 + 28), 
							" with the parameter:\n%s", exec_para);
					if( (!(f_hyper & F_H_DIRECT) || pos ) && !f_seamless &&
						MessageCBox(g_winData.hMainWnd, 
						 common_work + 0x1000, href,
						  MB_YESNO|MB_ICONQUESTION) != IDYES){
						exec_para = NULL;
						break;
					}
					hShell = ExecHref(hwnd, href);
				}
				if((UINT)hShell < 32){
					xx = 0;
					goto href_er;
				}
				return 0;
			}
		case WM_USER_DO_HREF:
do_href:
			if( href == NULL && (f_hyper & F_H_DVIOPEN) )
				href = hypertag;
			if( href == NULL ){
//				error( WARNING, "Hyper Jumping routine is called without "
//					"correct reference,\nwhich shall be ignored." );
				break;
			}
			if(w.pDib == NULL)
				break;
			CoverSuspend();
			tmpname = NULL;
			if(CheckRenew(1))
				ExpandPage();
			if(href[1] == ' ' && (pos = atoi(href+2)) > 0){	// "# <number>..."
				for(tmpname = href+2; *tmpname >= '0' && *tmpname <= '9';
					tmpname++);						// skip digits
				if(*tmpname != '/'){				// "# <number>/...
					while(*tmpname == ' ')
						tmpname++;
					if(!*tmpname){					// "# <page>"
						PostMessage(g_winData.hWnd, WM_USER_NEW_PAGE,
							(WPARAM)pos, 0);		// jump to the given page
						break;
					}
					tmpname = NULL;
				}
			}
			if(GetH_NamePos(&pt, href+1) == 1){		// search the current page
#if	HYPER_2VERT
				if(IS_2VERT && pDib2 && IsSecondPage(GetCurrentPage()))
					pt.y += GetTextYSize();
#endif
				f_hyper |= F_H_CURRENTPAGE;
				Cursor2BufPoint2Center(&w, pt.x, pt.y);
				AnimationPointer( &w, g_winData.hWnd, g_winData.hInstance, pt.x, pt.y,
FALSE );
				f_hyper &= ~F_H_DVIOPEN;
				goto show;
			}
			f_hist_msg = F_HM_HYPERJUMP;
			SaveH_Hist(&w, 1);
			xx = GetCurrentPage();
			{
				char *tmpstr;

				tmpstr = dup_string(href);
				temp_page = SearchH_Name(tmpstr+1);		// search all pages
				strcpy(href, tmpstr);					// common_work may not be kept
				Free0(tmpstr);
			}
			if(temp_page < 0){
href_er:		error(WARNING, 
					(href[1] == ' ')?
					"Cannot find '%s'":
					"Cannot resolve href %s", href);
				if(xx > 0){
					ChgPage(xx);
					ExpandPage();
				}
				if(f_hyper & F_H_DVIOPEN){				// <- ???
					f_hyper &= ~F_H_DVIOPEN;
					goto show;
				}
				break;				// <-  ???
			}
			ChgPage(temp_page);
			ExpandPage();						// Expand in Buf
			pos = GetH_NamePos(&pt, href+1);	// get the position in Buffer
			if(!pos){
				error(C_MSG, "System error\n");
				goto href_er;
			}
			if(pos == -1){
				pt.x = ptex_d?(GetTextXSize()-1):0;
				pt.y = 0;
			}
			pDibNew = MakeBMP();						// get BMP
			f_hyper &= ~F_H_DVIOPEN;
			// Cursor2BufPoint2Center(&w, pt.x, pt.y);	// Move cursor
#if	HYPER_2VERT
			if(IS_2VERT && IsSecondPage(temp_page))
				f_2page ^= 1;
#endif
			f_h_renew = TRUE;
href_search:
			if(!tmpname)
				goto renew;
			tmpname++;
			pos = strlen(tmpname);
			xx = tmpname[pos-1];
fs:			while(--pos >= 0 && tmpname[pos] != ' ');  
			if(pos >= 0 && xx == '\'' && tmpname[pos+1] != '\'')
				goto fs;									// 'file_name'
			while(--pos >= 0 && tmpname[pos] == ' ');		// cut source filename
			if(pos >= MAX_FIND_LEN-1 || pos < 0)
				goto renew;
			for(xx = 0; xx <= pos; xx++)
				szFind[xx] = tmpname[xx];		// get string to be searched
			szFind[xx] = 0;
//			SetSearchStr(szFind);
#if	DEB_SRCSER
			error(11, "sZfind[%s]\n", szFind);
#endif
			tmpname[pos] = xx;
			fr.Flags |= FR_DOWN;
			xx = yy = MAXINT;
			tmpname = GetNextSource(0, &pos);
			if(tmpname)
				xx = GetShiftInt(tmpname-4);
#if	DEB_SRCSER
			error(11, "[%p:%d ", tmpname-8, pos);
#endif
			tmpname = GetNextSource(1, &pos);
			if(tmpname)
				yy = GetShiftInt(tmpname-4);
#if	DEB_SRCSER
			error(11, ",%p:%d]\n(%d-%d", tmpname-8, pos, xx, yy);
#endif
			FindPt = -1;
 			SearchStr(&w, &fr, 0);		// search in the current page
 			for(FindPt = 0; (pos = GetSearchLoc(FindPt*2)) != 0 && xx >= pos; FindPt++)
#if	DEB_SRCSER
			error(11, ":%d", pos)
#endif
			;
#if	DEB_SRCSER
			error(11, ":%d)\n", pos);
#endif
			if(pos > 0){
				if(pos <= yy){					// find it
#if	DEB_SRCSER
			error(11, "Exists in this page!\n");
#endif
					FindPt--;
					goto sstr0;
				}
			}
			if(FindPt){
#if	DEB_SRCSER
				error(11, "Check former!\n");
#endif
				GetNextSource(-1,&xx);
				if(( tmpname = GetNextSource(-1,&xx)) == NULL
				  || GetShiftInt(tmpname-4) < GetSearchLoc((FindPt-1)*2) ){
					FindPt -= 2;
					goto sstr0;
				}
			}
			if(pos && yy != MAXINT)
				goto renew;
			ChgPage(FindPage+1);
			if(FindPage == GetCurrentPage())	// the next page doesn't exist
				goto renew;
			ExpandPage();
#if	DEB_SRCSER
			error(11, "Search in the next page!\n");
#endif
			if(!SearchStr(&w, &fr, 0))		// search in the next page
				goto not_hs;			 		// not exist
			tmpname = GetNextSource(2, &pos);
			xx = (tmpname)?GetShiftInt(tmpname - 4):MAXINT;
			if(GetSearchLoc(0) <= xx){			// find it
				ChgPage(FindPage-1);
sstr0:			f_DrawAnimationPointer = f_h_renew = FALSE;
				if(pDibNew)
					Free0(pDibNew + sizeof(BITMAPFILEHEADER));
				pDibNew = NULL;
#if	DEB_SRCSER
			error(11, "Find in the next page!\n");
#endif
				goto sstr;
			}
not_hs:		if(pDibNew)
				Free0(pDibNew + sizeof(BITMAPFILEHEADER));
			pDibNew = GotoPage(FindPage-1);
			goto renew;

		case WM_LBUTTONUP:
lbup:		f_l_down = 0;
			if( (f_HandMouse || f_Pen) && f_HandMoving == TRUE)
			{
				f_HandMoving = FALSE;
				if(f_CoverMoving){
					pt.x = mptxx;
					pt.y = mptyy;
					ClientToScreen(g_winData.hWnd, &pt);
					SetCursorPos(pt.x, pt.y);
					f_CoverMoving = 0;
				}
				if(b_presentation_mode){
					if( GetCursor() != g_winData.hNormalCursor )
						SetCursor( g_winData.hNormalCursor );
				}else if( GetCursor() != g_winData.hHandCursor )
					SetCursor( g_winData.hHandCursor );
			}
			if( bOnHrefPress ){
				bOnHrefPress = FALSE;
				href = GetHref(&w, LOWORD(lParam), HIWORD(lParam));
				exec_para = NULL;
				SetCursor( g_winData.hPointCursor );
				if( href ) goto hpjp;
			}
			break;

		case WM_RBUTTONDOWN:
			if( f_l_down && count_src_special && !f_2page
			  && HIBYTE(GetKeyState(VK_CONTROL)) ){
				if(w.pDib != NULL){
					Win2BufPoint(&w, &pt, LOWORD(lParam), HIWORD(lParam));
					tmpname = GetWPos2Source(&pt, &pos);
					if(tmpname != NULL && !ToSource(&tmpname, pos)){
							error(C_MSG, "%s : %d", tmpname, pos);
							error(DATATITLE, "source special");
					}
				}
				goto lbup;
			}
			if( f_HandMoving == TRUE ){
				if(b_presentation_mode && (f_cover == 1) && !f_2page
				  && !f_CoverMoving){
					if(IsMouseInDVIWindow( w, &pt ) & 2){
						mptx = pt.x, mpty = pt.y;
						goto cover_on;
					}
				}
				break;
			}
			if( IsMouseInDVIWindow( w, &pt ) & 2 )
			{
			    RECT deskrc;
				int lptx, lpty;

				if(b_presentation_mode && (f_coverB & 2))
					goto downpage;
				if(f_rectcut && w.pDib && HIBYTE(GetKeyState(VK_SHIFT)) != 0){
					Win2BufPoint(&w, &pt, LOWORD(lParam), HIWORD(lParam));
					if(b_presentation_mode){
						if(HIBYTE(GetKeyState(VK_CONTROL))){
							SetPoint(pt.x, pt.y, 0x81);
						}else{
							GetLastPoint(&lptx, &lpty);
							SetPoint(pt.x, pt.y, 1);
							Buf2WinPoint(&w, &pt, lptx, lpty);
							rc.left = pt.x;
							rc.right = LOWORD(lParam);
							if(rc.left > rc.right){
								lptx = rc.left;
								rc.left = rc.right;
								rc.right = lptx;
							}
							if(rc.left > 3)
								rc.left -=4;
							else
								rc.left = 0;
							rc.right+=4;
							rc.top = pt.y;
							rc.bottom = HIWORD(lParam);
							if(rc.top > rc.bottom){
								lpty = rc.top;
								rc.top = rc.bottom;
								rc.bottom = lpty;
							}
							if(rc.top > 3)
								rc.top -= 4;
							else
								rc.top = 0;
							rc.bottom += 4;
							inval = &rc;
						}
					}else if(pt.x >= rectcut.left){
						rectcut.right = pt.x;
						rectcut.bottom = pt.y;
					}
					goto show;
				}
				if( !f_Capturing )
				{
					SetCapture( g_winData.hWnd );
					f_Capturing = TRUE;
				}
				if(IS_MPAGE){
lbutton16:			Win2BufPoint(&w, &pt, pt.x, pt.y);
					if(	 w.pDib == NULL
					  || pt.x < 0 || pt.x >= GetTextXSize()
					  || pt.y < 0 || pt.y >= GetTextYSize())
						return 0;
					size = (IS_16PAGE)?4:2;
					pos =  pt.y*size/GetTextYSize();
					pos =  f_2top + pos*size + pt.x*size/GetTextXSize();
					if(pos > GetTotalPage())
						return 0;
					f_2page = 0;
					f_CheckCover = TRUE;
					AddKeepBMP(0);
					ClearKeepBMP();
					if(pos == GetCurrentPage())
						goto re_open;
					SaveH_Hist(&w, 1);
					pDibNew = GotoPage(pos);
					goto renew;
				}
				if(f_rpcolor == 5){
					ShowMessage("Loupe is not supported in patch2 mode.",
						"Error", SM_OKCONT);
					break;
				}
				if(HIBYTE(GetKeyState(VK_CONTROL)) != 0)
				{
					f_circle0 = g_loupe.f_circle;
					g_loupe.f_circle &= ~1;
					l_diam0 = g_loupe.diam;
					g_loupe.diam = ctr_loupe & 0xffff;
					l_div0 = g_loupe.div;
					g_loupe.div = (ctr_loupe >> 16);
				}
				InitLoupeWindow();
				ClientToScreen( g_winData.hWnd, &pt );
				mpty = pt.y;
				mptx = pt.x;
				if( g_loupe.f_circle & F_LCIRCLE )
				{
					SetLoupeCircle();
				}
				else
				{
					SetLoupeRect();
				}
				if(g_loupe.f_circle & F_LEDGE){
					GetWindowRect(GetDesktopWindow(), (LPRECT)&deskrc);
					if (pt.x - (signed int)g_loupe.diam/2 < deskrc.left)
					  lptx = deskrc.left;
					else if (pt.x + g_loupe.diam/2 > deskrc.right)
					  lptx = deskrc.right - g_loupe.diam;
					else
					  lptx = pt.x - g_loupe.diam/2;
					if (pt.y - (signed int)g_loupe.diam/2 < deskrc.top)
					  lpty = deskrc.top;
					else if (pt.y + g_loupe.diam/2 > deskrc.bottom)
					  lpty = deskrc.bottom - g_loupe.diam;
					else
					  lpty = pt.y - g_loupe.diam/2;
 				}else{
					lptx = pt.x - g_loupe.diam/2;
					lpty = pt.y - g_loupe.diam/2;
				}
				SetWindowPos( g_winData.hWndLoupe,
					HWND_TOPMOST,
					lptx, lpty,
					g_loupe.diam, g_loupe.diam, SWP_NOACTIVATE );
				ShowWindow( g_winData.hWndLoupe, SW_SHOWNOACTIVATE );
				if(f_lcursor && !f_lcur_off){
					ShowCursor(FALSE);
					f_lcur_off = TRUE;
				}
				f_Loupe = TRUE;
			}
			break;

		case WM_RBUTTONUP:
			if( f_CoverMoving )
				break;
			if( f_Loupe || f_Capturing )
			{
				ShowWindow( g_winData.hWndLoupe, SW_HIDE );
				if(f_lcur_off){
					f_lcur_off = TRUE;
					ShowCursor(TRUE);
					f_lcur_off = FALSE;
				}
				f_Loupe = FALSE;
				if(l_diam0){
					g_loupe.f_circle = f_circle0;
					g_loupe.diam = l_diam0;
					g_loupe.div = l_div0;
					l_diam0 = 0;
					InitLoupeWindow();
				}
			}
			if( f_Capturing )
			{
				ReleaseCapture();
				f_Capturing = FALSE;
			}
			break;

		case WM_MOUSEMOVE:
			bOnHref = (href = GetHref(&w,LOWORD(lParam),HIWORD(lParam)))?TRUE:FALSE;
			if( bOnHref == FALSE ) bOnHrefPress = FALSE;
			if(!f_ShowCursor){
				if(cur_pt.x == INIT_CUR_PT){
					cur_pt.x = LOWORD(lParam);
					cur_pt.y = HIWORD(lParam);
					break;
				}
				if( cur_pt.x - LOWORD(lParam) < CUR_MOV && LOWORD(lParam) - cur_pt.x < CUR_MOV
				 && cur_pt.y - HIWORD(lParam) < CUR_MOV && HIWORD(lParam) - cur_pt.y < CUR_MOV)
					break;
				ActivateCursor();
				CheckCursor();
			}
			if(g_winData.hWndPresenMenu){
				GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
				if(LOWORD(lParam)+CUR_MOV >= pmenu.left  && LOWORD(lParam) <= pmenu.right+CUR_MOV && 
				   HIWORD(lParam)+CUR_MOV >= pmenu.top   && HIWORD(lParam) <= pmenu.bottom+CUR_MOV ){
					if(!f_pmshow){
						ShowWindow(g_winData.hWndPresenMenu, SW_SHOW);
						f_pmshow = TRUE;
					}
				}else if(f_pmshow && (pmenu.left || pmenu.top) ){
					ShowWindow(g_winData.hWndPresenMenu, SW_HIDE);
					f_pmshow = FALSE;
				}
			}
			/* anyway, we will check the mouse is on the hyper point. */
			if( bOnHref && f_Loupe == FALSE && f_hypertex )
			{
				static int loc_cur;
				static char *loc_href;

				if( GetCursor() != g_winData.hPointCursor && GetCursor() != g_winData.hPointPushCursor ){
					SetCursor( bOnHrefPress?g_winData.hPointPushCursor:g_winData.hPointCursor );
				}
				if(loc_cur != lParam || bShowingHref != TRUE){
					if(!bShowingHref || loc_href != href){
						ShowHyperLink( href );
						bShowingHref = TRUE;
						loc_href = href;
					}
					loc_cur = lParam;
				}
				break;
			}
			else
			{
				if( bShowingHref != FALSE )
					ShowHyperLink( NULL );
				bShowingHref = FALSE;
			}
			if( GetForegroundWindow() != g_winData.hMainWnd )
				break;
			if( (f_HandMouse || f_Pen) && f_Loupe == FALSE )
			{
				/* In this block we have to do only about hand mode. */
				HCURSOR hcur = GetCursor();
				HCURSOR hcur2;

				if( (IsMouseInDVIWindow( w, &pt ) & 3) == 3)
				{	/* if mouse cursor is in DVI window */
					if( !f_Capturing )
					{
						SetCapture( g_winData.hWnd );
						f_Capturing = TRUE;
					}
					if( f_HandMoving == TRUE )
					{
						switch(f_CoverMoving){	/* cover sheet in presentation mode */
							case 1:
								hcur2 = g_winData.hNSCursor;
								break;
							case 2:
								hcur2 = g_winData.hWECursor;
								break;
							case 3:
								hcur2 = g_winData.hALLCursor;
								break;
							default:
								if( f_Pen ){
									if( bOnHref ){
										hcur2 = bOnHrefPress?g_winData.hPointPushCursor:g_winData.hPointCursor;
									} else{
										hcur2 = g_winData.hNormalCursor;
									}
								} else{
									hcur2 = g_winData.hMoveHandCursor;
								}
								break;
						}
						if( hcur != hcur2 )
						{
							SetCursor( hcur2 );
						}
						if(f_CoverMoving){
							MoveCover(pt.x - mptx, pt.y - mpty, 0);
							mptx = pt.x;
							mpty = pt.y;
							break;
						}
						if( !f_HandMouse ){
							if(w.pDib &&(mptx != pt.x || mpty != pt.y)){
								unsigned char *pD;
								RECT rcc;

								if(pDibPen == NULL){
#if 1
									pD = w.pDib-sizeof(BITMAPFILEHEADER);
									if((((BITMAPINFOHEADER*)w.pDib)->biBitCount) != 8){
										SetColor(8);
										ReplaceBmp(&w, MakeBMP());
										if(w.pDib==NULL)
											break;
										pD = w.pDib-sizeof(BITMAPFILEHEADER);
									}
									pDibPen = (unsigned char *)marea(((BITMAPFILEHEADER*)pD)->bfSize);
									if(pDibPen){
										memset(pDibPen, (SetGamma(0)>0)?0:0xf, ((BITMAPFILEHEADER*)pD)->bfSize);
										memcpy(pDibPen, pD, ((BITMAPFILEHEADER*)pD)->bfOffBits);
										pDibPen += sizeof(BITMAPFILEHEADER);
									}
#else
									pDibPen = Get8BMPBuf(w.pDib-sizeof(BITMAPFILEHEADER));
#endif
								}

//	DrawLine(w.pDib, mptx + w.nHscrollPos - g_nxIndent, mpty+ w.nVscrollPos - g_nyIndent, 
//		pt.x-mptx, pt.y-mpty, xxx, 0x0f);
								else if((WORD)((BITMAPINFOHEADER*)w.pDib)->biWidth
									!= (WORD)((BITMAPINFOHEADER*)pDibPen)->biWidth
								 || IS_MPAGE
								 || GetKeyState(VK_SHIFT) < 0)
										goto skipdraw;
								if(!b_presentation_mode){
									xx = PenWidth;
									yy = PenType;
									if((yy & 0xf) < 8)
										xx = xx*2+1;
								}else{
									xx = draw_color & 3;
									if(draw_style)
										xx |= 4;
									if(SetGamma(0) > 0)
										yy = LineColor[xx];
									else
										yy = LineColor[xx|8];
									xx = (draw_color & F_DTHICK)?1:0;
									if(draw_style){
										xx = xx?9:5;
//										if((draw_color & 3) == 1)
//											xx += 3;
									}
								}
								DrawLine(pDibPen, mptx + w.nHscrollPos - g_nxIndent, mpty+ w.nVscrollPos - g_nyIndent, 
									pt.x-mptx, pt.y-mpty, xx, yy);
								if(pt.x > mptx){
									rcc.left = mptx-xx/2;
									rcc.right = pt.x+(xx+3)/2;
								}else{
									rcc.left = pt.x-xx/2;
									rcc.right = mptx+(xx+3)/2;
								}
								if(pt.y > mpty){
									rcc.top = mpty-(xx+1)/2;
									rcc.bottom = pt.y+xx/2+1;
								}else{
									rcc.top = pt.y-(xx+1)/2;
									rcc.bottom = mpty+xx/2+1;
								}
								InvalidateRect( g_winData.hWnd, &rcc, FALSE );
skipdraw:						mptx = pt.x;
								mpty = pt.y;
							}
							break;
						}
						if( mpty != pt.y )
						{
							nVscrollInc = (short)(mpty - pt.y);
							mpty = pt.y;
							/* it is important that flow returns here after
							   finishing scroll. */
							SendMessage( g_winData.hWnd, WM_USER_VSCROLL,
								nVscrollInc, 0 );
						}
						if( mptx != pt.x )
						{
							nHscrollInc = (short)mptx - pt.x;
							mptx = pt.x;
							SendMessage( g_winData.hWnd, WM_USER_HSCROLL,
										nHscrollInc, 0 );
						}
					}
					else /* In hand mode but not in moving mode */
					{
						if( bOnHref ){
							if( hcur != g_winData.hPointPushCursor && hcur != g_winData.hPointCursor )
								SetCursor( bOnHrefPress?g_winData.hPointPushCursor:g_winData.hPointCursor );
						}else {
							if(b_presentation_mode){
								if( hcur != g_winData.hNormalCursor )
									SetCursor( g_winData.hNormalCursor );
							}else if( hcur != g_winData.hHandCursor )
								SetCursor( g_winData.hHandCursor );
						}
					}
				}
				else // mouse is hand mode but not in DVI window.
				{
					if( f_HandMoving == TRUE )
					{
						if( hcur != g_winData.hMoveHandCursor )
						{
							SetCursor( g_winData.hMoveHandCursor );
						}
						if(f_CoverMoving){
							MoveCover(pt.x - mptx, pt.y - mpty, 0);
							mptx = pt.x;
							mpty = pt.y;
							break;
						}
						if( mpty != pt.y )
						{
							nVscrollInc = (short)(mpty - pt.y);
							mpty = pt.y;
							SendMessage( g_winData.hWnd, WM_USER_VSCROLL,
								nVscrollInc, 0 );
						}
						if( mptx != pt.x )
						{
							nHscrollInc = (short)(mptx - pt.x);
							mptx = pt.x;
							SendMessage( g_winData.hWnd, WM_USER_HSCROLL,
										nHscrollInc, 0 );
						}
					}
					else /* in hand mode, not moving and not in DVI window */
					{
						if( f_Capturing )
						{
							ReleaseCapture();
							f_Capturing = FALSE;
						}
						if( hcur != g_winData.hNormalCursor )
						{
							SetCursor( g_winData.hNormalCursor );
						}
						SendMessage( g_winData.hWnd, WM_LBUTTONUP, 0, 0 );
					}
				}
			} // if f_HandMouse == TRUE and f_Loupe != TRUE
			else if( f_Loupe == TRUE )
			{
				#define	SKIP	4
				/* we have to do about Loupe mode. */
				GetCursorPos( &pt );
				if( (IsMouseInDVIWindow( w, &pt )&2) )
				{
					ClientToScreen( g_winData.hWnd, &pt );
#if	0
					if( mptx != pt.x || mpty != pt.y )
#else
					if( mptx - pt.x >= g_loupe.skip
					 || pt.x - mptx >= g_loupe.skip
					 || mpty - pt.y >= g_loupe.skip
					 || pt.y - mpty >= g_loupe.skip )
#endif
					{
					    RECT deskrc;
						int lptx, lpty;
						f_nploupe = TRUE;
						mptx = pt.x, mpty = pt.y;
						if(g_loupe.f_circle & F_LEDGE){
							GetWindowRect(GetDesktopWindow(), (LPRECT)&deskrc);
							if (pt.x - (signed int)g_loupe.diam/2 < deskrc.left)
							  lptx = deskrc.left;
							else if (pt.x + g_loupe.diam/2 > deskrc.right)
							  lptx = deskrc.right - g_loupe.diam;
							else
							  lptx = pt.x - g_loupe.diam/2;
							if (pt.y - (signed int)g_loupe.diam/2 < deskrc.top)
						 	 lpty = deskrc.top;
							else if (pt.y + g_loupe.diam/2 > deskrc.bottom)
							  lpty = deskrc.bottom - g_loupe.diam;
							else
							  lpty = pt.y - g_loupe.diam/2;
						}else{
							lptx = pt.x - g_loupe.diam/2;
							lpty = pt.y - g_loupe.diam/2;
						}
						SetWindowPos( g_winData.hWndLoupe,
							HWND_TOPMOST,
							lptx, lpty, 
							g_loupe.diam, g_loupe.diam,
							SWP_NOSIZE | SWP_NOACTIVATE | SWP_NOCOPYBITS );
						f_nploupe = FALSE;
						InvalidateRect( g_winData.hWndLoupe, NULL, FALSE );
					}
				}
				else /* loupe is shown but mouse is not in DVI window. */
				{
					if( f_Capturing )
					{
						ReleaseCapture();
						f_Capturing = FALSE;
					}
					ShowWindow( g_winData.hWndLoupe, SW_HIDE );
					if(f_lcur_off){
						f_lcur_off = TRUE;
						ShowCursor(TRUE);
						f_lcur_off = FALSE;
					}
					f_Loupe = FALSE;
				}
			}
			break;

		case WM_USER_NEW_PAGE: // wParam == new page
			temp_page = (int)wParam;
			if(w.pDib != NULL){
				SaveH_Hist(&w, 1);
				pDibNew = GotoPage(temp_page);
				goto renew;
			}
			break;

		case WM_MBUTTONUP:
			f_m_down = 0;
			break;

		case WM_MBUTTONDOWN:
			f_m_down = 1;
			break;

		case WM_SYSKEYDOWN:
		case WM_SYSKEYUP:
			if((unsigned char)wParam >= VK_F1 && (unsigned char)wParam <= VK_F12)
				PostMessage( g_winData.hMainWnd, WM_KEYDOWN, wParam, lParam );
			break;	// SHOULD BREAK (NOT return 0). If NOT, Alt F4 will be IGNORED!!

		case WM_KEYDOWN:
			switch( (char)wParam ){
				case VK_BACK:
				case VK_PRIOR:
					temp_page = -1;
					goto vk_next;
				case VK_SPACE:
				case VK_NEXT:
					temp_page = 1;
vk_next:			if( GetKeyState( VK_SHIFT ) < 0 )
						temp_page *= 5;
					if( GetKeyState( VK_CONTROL ) < 0 )
						temp_page *= 10;
					if( temp_page == 1 && ((char)wParam == VK_SPACE || (char)wParam == VK_RIGHT || (char)wParam == VK_DOWN
						|| ((char)wParam == VK_NEXT && b_presentation_mode)) )
						goto downpage;
					if( temp_page == -1 && ((char)wParam == VK_BACK || (char)wParam == VK_LEFT || (char)wParam == VK_UP))
						goto uppage;
					goto new_page;
				case VK_HOME:
					if( GetKeyState( VK_CONTROL ) < 0 )
						goto top_page;
					else
						goto page_head;
				case VK_END:
					if( GetKeyState( VK_CONTROL ) < 0 )
						goto bottom_page;
					else
						goto page_foot;
				case VK_LEFT:
					if( GetKeyState( VK_CONTROL ) < 0 && GetKeyState( VK_SHIFT ) < 0){
						OX -= 0x8000;
						ReSetMetric();
						goto chk_re_open;
					}
					if( w.nHscrollMax == 0 ){
						temp_page = -1;
						goto vk_next;
					}
					goto scr_left;
				case VK_UP:
					if( GetKeyState( VK_SHIFT ) < 0 ){
						if( GetKeyState( VK_CONTROL ) < 0){
							OY -= 0x8000;
							ReSetMetric();
							goto chk_re_open;
						}
						goto uppage;
					}
					if( w.nVscrollMax == 0 ){
						temp_page = -1;
						goto vk_next;
					}
					goto scr_up;
				case VK_RIGHT:
					if( GetKeyState( VK_CONTROL ) < 0 && GetKeyState( VK_SHIFT ) < 0){
						OX += 0x8000;
						ReSetMetric();
						goto chk_re_open;
					}
					if( w.nHscrollMax == 0 ){
						temp_page = 1;
						goto vk_next;
					}
					goto scr_right;
				case VK_DOWN:
					if( GetKeyState( VK_SHIFT ) < 0 ){
						if( GetKeyState( VK_CONTROL ) < 0){
							OY += 0x8000;
							ReSetMetric();
							goto chk_re_open;
						}
						goto downpage;
					}
					if( w.nVscrollMax == 0 ){
						temp_page = 1;
						goto vk_next;
					}
					goto scr_down;
				case VK_TAB:
					if( g_winData.hWndShow )
						SetFocus( g_winData.hWndShow );
					if( g_winData.hWndPick )
						SetFocus( g_winData.hWndPick );
					return 0;
				case VK_DELETE:
					if(b_presentation_mode){
						id_value = ID_DRERACE;
						goto wmcmd;
					}
					break;
				case VK_RETURN:
					if( g_winData.hWndShow )
						SendMessage( g_winData.hWndShow, WM_COMMAND, ID_HIS_CANCEL, 0 );
					if( g_winData.hWndPick )
						SendMessage( g_winData.hWndPick, WM_COMMAND, ID_HIS_CANCEL, 0 );
					// pass to default
				default:
					if((unsigned char)wParam >= VK_F1
					&& (unsigned char)wParam <= VK_F12){
						if(b_presentation_mode){
							pos = GetKeyState(VK_SHIFT);
							switch((unsigned char)wParam){
								case VK_F1:
									if(pos >= 0)
										goto fn_key;
//									KillTimer8();
//									ActivateCursor();
									ShowWinHelp(IDH_PRESENKEY);
//									KillCursor();
									return 0;
//								case VK_F4:
//									id_value = ID_RECTON;
//									break;
								case VK_F5:
									id_value = (pos<0)?ID_DRRED:ID_COVERON;
									break;
								case VK_F6:
									id_value = (pos<0)?ID_DRBLACK:ID_COVEROFF;
									break;
								case VK_F7:
									id_value = (pos<0)?ID_DRBLUE:ID_COVERSUSPEND;
									break;
								case VK_F8:
									id_value = (pos<0)?ID_DRGREEN:ID_COVERRETURN;
									break;
								case VK_F9:
									id_value = (pos<0)?ID_DTHICK:ID_COVERSHEET;
									break;
//								case VK_F10:			// this doesn't work??
//									id_value = ID_DRLINE;
//									break;
								case VK_F11:
									id_value = (pos<0)?ID_DRBOX:ID_DRLINE;
									break;
								case VK_F12:
									id_value = (pos<0)?ID_SHAPE:ID_RECTON;
									break;
								default:
									goto fn_key;
							}
							goto wmcmd;
						}
fn_key:					if((id_value = 
							key_trans[key_table[wParam + 
								((GetKeyState( VK_SHIFT ) < 0)?
								(0x80 + 12 - VK_F1):(0x80 - VK_F1))]].id)
								!= 0 )
							goto wmcmd;
					}
					break;
			}
			break;

		case WM_CHAR:
			if(	 wParam < 0x80
			  && (id_value = key_trans[key_table[wParam]].id) != 0 )
				goto wmcmd;
			return 0;

		case WM_VSCROLL: /* LOWORD(wParam):scroll bar value
							HIWORD(wParam):scroll box position
							  (HWND)lParam:handle of scroll bar */
			switch( LOWORD(wParam) )
			{
				case SB_TOP:
					nVscrollInc = -w.nVscrollPos;
					break;
				case SB_BOTTOM:
					nVscrollInc = w.nVscrollMax - w.nVscrollPos;
					break;
				case SB_LINEUP:
scr_up:				nVscrollInc = -f_scr_skip;
					break;
				case SB_LINEDOWN:
scr_down:			nVscrollInc = f_scr_skip;
					break;
				case SB_PAGEUP:
					nVscrollInc = -w.cyClient*9/10;
					break;
				case SB_PAGEDOWN:
					nVscrollInc = w.cyClient*9/10;
					break;
				case SB_THUMBPOSITION:
				case SB_THUMBTRACK:
					nVscrollInc = HIWORD(wParam) - w.nVscrollPos;
					break;
				default:
					nVscrollInc = 0;
					break;
			}
vscroll:	temp_page = 0;
/*
	IsSecondPage()      (w.pDib, pDib2)     (pDib2, w.pDib)
	(ODD, EVEN)  1                 1          0
	(EVEN, ODD)  0                 1          0
*/
#ifdef	DOUBLE_PAGE
			if(IS_2VERT && b_presentation_mode && w.pDib){
				if(w.nVscrollMax == w.nVscrollPos && nVscrollInc > 0){
					pos = GetCurrentPage();
					if(!IsSecondPage(pos))
//					if(IS_2DIB2)
						pos++;					// (pDib2, w.pDib)
					if(pos >= GetTotalPage())
						goto vskip;
					nVscrollInc = -GetTextYSize();
vcscrl:				ChgPage(pos);
					f_2page ^= F_ODD2EVEN;
					CoverSuspend();
					SaveH_Hist(&w, 1);
					SetPageMoveButtons( &w );
//					ClearKeepBMP();
//					Clear2Page();
					ExpandPage();
					ReplaceBmp(&w, MakeBMP());	// w.pDib
					Get2Bmp();						// pDib2
					SetPoint(0, nVscrollInc, -3);
					nVscrollInc /= GetYGray();
					temp_page = 1;
				}else if(w.nVscrollPos == 0 && nVscrollInc < 0){
					pos = GetCurrentPage() - 1;
					if(!IsSecondPage(pos))
//					if(!IS_2DIB2)
						pos--;				// (pDib2, w.pDib)
					if(pos <= 0)
						goto vskip;
					nVscrollInc = GetTextYSize();
					goto vcscrl;
				}
			}
vskip:
#endif
			nVscrollInc = max( -w.nVscrollPos,
							   min( nVscrollInc, w.nVscrollMax - w.nVscrollPos ) );
			if( nVscrollInc != 0 || message == WM_USER_VSCROLL)
			{
				w.nVscrollPos += nVscrollInc;
				ScrollWindow( g_winData.hWnd, 0, -nVscrollInc, NULL, NULL );
				if( f_flatscroll && GetVersionLevel() > 0 )
				{
					g_FlatSB_SetScrollPos( g_winData.hWnd, SB_VERT, w.nVscrollPos, TRUE );
				}
				else
				{
					SetScrollPos( g_winData.hWnd, SB_VERT, w.nVscrollPos, TRUE );
				}
				if(temp_page)
					goto show;
				UpdateWindow( g_winData.hWnd );
			}
			return 0;

		case WM_HSCROLL: /* LOWORD(wParam):scroll bar value
							HIWORD(wParam):scroll box position
							  (HWND)lParam:handle of scroll bar */
			switch( LOWORD(wParam) )
			{
				case SB_LINEUP:
scr_left:			nHscrollInc = -f_scr_skip;
					break;
				case SB_LINEDOWN:
scr_right:			nHscrollInc = f_scr_skip;
					break;
				case SB_PAGEUP:
					nHscrollInc = -w.cxClient*9/10;
					break;
				case SB_PAGEDOWN:
					nHscrollInc = w.cxClient*9/10;
					break;
				case SB_THUMBPOSITION:
					nHscrollInc = HIWORD(wParam) - w.nHscrollPos;
					break;
				case SB_THUMBTRACK:
					nHscrollInc = HIWORD(wParam) - w.nHscrollPos;
					break;
				default:
					nHscrollInc = 0;
					break;
			}
hscroll:	nHscrollInc = max( -w.nHscrollPos,
							   min( nHscrollInc, w.nHscrollMax - w.nHscrollPos ) );
			if( nHscrollInc != 0 )
			{
				w.nHscrollPos += nHscrollInc;
				ScrollWindow( g_winData.hWnd, -nHscrollInc, 0, NULL, NULL );
				if( f_flatscroll && GetVersionLevel() > 0 )
				{
					g_FlatSB_SetScrollPos( g_winData.hWnd, SB_HORZ, w.nHscrollPos, TRUE );
				}
				else
				{
					SetScrollPos( g_winData.hWnd, SB_HORZ, w.nHscrollPos, TRUE );
				}
				UpdateWindow( g_winData.hWnd );
			}
			return 0;

		case WM_USER_VSCROLL:
			nVscrollInc = (signed)wParam;
//			if( nVscrollInc + w.nVscrollPos > w.nVscrollMax )
//				nVscrollInc = w.nVscrollMax - w.nVscrollPos;
//			if( nVscrollInc + w.nVscrollPos < 0 )
//				nVscrollInc = 0 - w.nVscrollPos;
			goto vscroll;
		
		case WM_USER_HSCROLL:
			nHscrollInc = (short)wParam;
			goto hscroll;

		case WM_CLOSE:
			if( b_presentation_mode ){
				SendMessage( g_winData.hWnd, WM_COMMAND, 
					MAKEWPARAM(ID_PRESENTOFF,0), 0L );
			}
			return 0;

		case WM_DESTROY: /* ޳悤ƂĂ */
			if( w.pDib != NULL )
			{
				FreeBmp( w.pDib );
				w.pDib = NULL;
				if(!f_quit){
#if	0
					WriteHistory(GetOutPath(F_HIST_EXT));
#else
					WriteHistory("FILE");
#endif
					if(f_fkeep)
						keep_font_path();
				}
			}
			if(pDibPen)
				FreeBmp(pDibPen);
			pDibPen = NULL;
			return 0;

		case WM_USR_HDIALOG: /* */
			if((temp_page = LOWORD(wParam)) & 0x1000){
				temp_page &= (MAX_F_HIST - 1);
				if( 	HIBYTE(GetKeyState(VK_SHIFT))
					&& !HIBYTE(GetKeyState(VK_CONTROL)) ){
					strncpy(fname, f_hist[temp_page].name, MAX_PATH);
					size = strlen(fname);
					while(size && fname[size] != '\\' && 
					  fname[size] != ':')
						size--;		// cut the file name
					if(size){
						fname[size+1] = 0;
						size = GetFileAttributes(fname);
						if(size != 0xffffffff
						  && (size & FILE_ATTRIBUTE_DIRECTORY)
						  && QueryFileName(fname))
							goto opendvi0;
						return 0;
					}
				}
				if(strcmp(current_name, f_hist[temp_page].name)){
					if(access(f_hist[temp_page].name, 0)){
					  	if(MessageCBox(g_winData.hMainWnd, 
							"Cannot find the above file!\n"
							"Erace from History?",
							f_hist[temp_page].name, MB_YESNO|MB_ICONQUESTION)
								== IDYES)
									EraceHistory(temp_page);
							return 0;
					}
					SetColor(4);
					DefineDVIFileName( f_hist[temp_page].name );
					if(!HIBYTE(GetKeyState(VK_CONTROL)))
						SetStartPage(f_hist[temp_page].page);
					else if(HIBYTE(GetKeyState(VK_SHIFT)))
						SetStartPage(30000);
					goto opendvi1;
				}
				if(!(temp_page = f_hist[temp_page].page - GetCurrentPage()))
					return 0;
				f_hist_msg = F_HM_HYPERJUMP;
				goto nxtpg;
			}else{
				if(temp_page < MAX_H_HIST)
					h_hist_pt = temp_page;
				pt.x = h_hist[temp_page].x;
				pt.y = h_hist[temp_page].y;
				temp_page = h_hist[temp_page].page;
				goto go_hist;
			}

		case WM_USER_FINDNEXT:
			if( fr.Flags & FR_DOWN )
				goto nextcand;
			else
				goto precand;

		case WM_SYSCOMMAND:
			switch( wParam ){
				case SC_CLOSE:
					SendMessage( g_winData.hMainWnd, WM_CLOSE, 0, 0 );
					break;
				}
			break;

		case WM_COMMAND: /* HIWORD(wParam):notification code, menu=0, accel=1
							LOWORD(wParam):item, control, or accelarator identifier
						 (HWND)lParam  :handle of control */
			id_value = LOWORD(wParam);
wmcmd:		switch( id_value )
			{
				static int old_XGray, old_YGray;
				static int old_e;
				static BOOL old_varf;
				static char old_y[0x20];
				HMENU  hsubmenu;
				RECT   subrect;

				case ID_ALTF:
				case ID_ALTJ:
				case ID_ALTS:
				case ID_ALTD:
				case ID_ALTV:
				case ID_ALTN:
				case ID_ALTP:
				case ID_ALTO:
				case ID_ALTH:
					pos = id_value - ID_ALTF;
					hsubmenu = GetMenu(g_winData.hMainWnd);
					if(GetMenuState(hsubmenu, pos, MF_BYPOSITION) & MFS_GRAYED)
						break;
					if(!GetMenuItemRect(g_winData.hMainWnd, hsubmenu, pos, &subrect))
						GetWindowRect(g_winData.hMainWnd, &subrect);
					hsubmenu = GetSubMenu(hsubmenu, pos);
					HiliteMenuItem(g_winData.hMainWnd, g_winData.hMenu, 
						pos, MF_BYPOSITION|MFS_HILITE);
//					SetMenuDefaultItem(hsubmenu, 0, FALSE);
					TrackPopupMenuEx(hsubmenu, 
						TPM_HORIZONTAL|TPM_LEFTALIGN|TPM_LEFTBUTTON, 
						subrect.left, subrect.bottom, g_winData.hMainWnd, NULL);
					HiliteMenuItem(g_winData.hMainWnd, g_winData.hMenu, 
						pos, MF_BYPOSITION|MFS_UNHILITE);
					break;

				case ID_WINMAX:
					ShowWindow(g_winData.hMainWnd, SW_SHOWMAXIMIZED);
					break;

				case ID_DEFIT:
					if(!f_FIT)
						return 0;
					SetParaInt("e", old_e);
					SetParaFlag("varf", old_varf);
					SetXYGray(old_XGray, old_YGray);
					SetParaString("y", old_y);
					f_FIT = 0;
					goto chk_re_open;

				case ID_FIT:
				case ID_FULL:
					if( w.pDib == NULL || !w.cxClient || !w.cyClient
					  || (b_presentation_mode && f_FIT == id_value) )
						return 0;
#if 1
					if(f_init){
						SetStartPage(GetCurrentPage());
						ExpandPage();
					}
#else
					InitializeParameter();	// -> application error
#endif
					size = 
#ifdef	DOUBLE_PAGE
						((IS_2HORI)?2:1)*
#endif
							GetTextXSize()*0x1000/w.cxClient;
					pos = 
#ifdef	DOUBLE_PAGE
						((IS_2VERT)?2:1)*
#endif
							GetTextYSize()*0x1000/w.cyClient;
					if(id_value == ID_FIT){
						if(size < pos)
							size = pos;
					}else if(size > pos)
						size = pos;
					if(b_presentation_mode){
						double dxx, dyy;

						if((inf_size = GetParaInt("e")) == 0)
							inf_size = 1000;
						xx = size * 1000/inf_size;	// xx: size*0x1000 if -e=0
						if(xx < 0x800 || xx > 0x80000)
							return 0;
						else if(xx < 0x1400)
							pos = 1;
						else if(xx < 0x2400)
							pos = 2;
						else
							pos = (xx+0x800)/0x1000;	// pos: gray scale
						size = pos*(0x1000*1000)/size;	// scale par current
						SetXYGray(pos, pos);
						if(size > 990 && size < 1010)
							size = 1000;
						dxx = (4736286.72+OX)*1000/inf_size - 4736286.72; // = original OX
						dyy = (4736286.72+OY)*1000/inf_size - 4736286.72; // = original OY
						inf_size = inf_size*size/1000;	// real scale
						OX = dxx*inf_size/1000 + 4736286.72*(inf_size-1000)/1000;
						OY = dyy*inf_size/1000 + 4736286.72*(inf_size-1000)/1000;
						SetParaInt("e", (inf_size == 1000)? 0:inf_size);
						SetParaFlag("varf", TRUE);
						xx = GetTextXSize()*size/1000;
#ifdef	DOUBLE_PAGE
						if(IS_2HORI)
							xx *= 2;
#endif
						yy = GetTextYSize()*size/1000;
#ifdef	DOUBLE_PAGE
						if(IS_2VERT)
							yy *= 2;
#endif
						CoverChange(size);

						size = w.cxClient*pos;
						pos *= w.cyClient;
						if(id_value == ID_FULL){
							while(xx > size && yy > pos){
								xx--;
								yy--;
							}
							if(xx < size)
								xx = size;
							if(yy < pos)
								yy = pos;
						}else{
							if(xx > size)
								xx = size;
							if(yy > pos)
								yy = pos;
							while(xx < size && yy < pos){
								xx++;
								yy++;
							}
							if(xx < size && xx*100 > size*99)
								xx = size;
							if(yy < pos && pos*100 > size*99)
								yy = pos;
						}
						sprintf(common_work, "-y=F%ddot/%ddpi:%ddot/%ddpiP",
							IS_2HORI?(xx/2):xx, GetXDpi(), 
							IS_2VERT?(yy/2):yy, GetYDpi());
						f_FIT = 0;
						SetPara(common_work, SET_OPTION);
						f_FIT = id_value;
						f_CheckCover = TRUE;
						goto chk_re_open;
					}else{
						pos = size/0x1000;
						if(pos > 127)
							return 0;
						SetXYGray(pos + 1, pos + 1);
					}
					CheckView(-1);
					goto newbmp;

				case ID_REDUCE:
					size = 1;
					goto resize;

				case ID_MAGNIFY:
					size = -1;
resize:				if(w.pDib == NULL)
						return 0;
					if(ChgGray(size, 64) == 0)
						break;
					if(pDibPen)
						f_KeepDraw = TRUE;
					CheckView(-1);
newbmp:				Win2BufPoint(&w, &pt, w.cxClient/2, w.cyClient/2);
chgbmp:				if(FindPt >= 0 && FindDvi == id_dvi 
					  && FindPage == GetCurrentPage())
						SetColor(8);
					else
						FindPt = -1;
					if(IS_MPAGE){
						pos = f_2top;
						goto f2sp0;
					}
					if(f_ucolor & 14){		/* Use anti-Areasing, fit BMP */
						ChangeWaitCursor(1);
						SetStartPage(GetCurrentPage());
						if(w.pDib)
							FreeBmp(w.pDib);
						CheckPenBuf();
						w.pDib = ReadDIB( g_szFileName );
						ChangeWaitCursor(0);
						if(w.pDib == NULL)
							break;
					}else if(ReplaceBmp(&w, MakeBMP()) == FALSE)
						break;
					if(FindPt >= 0)
						ShowFound(&w, s_box, s_box_pt, f_s_color, FindPt);
					BufPoint2Center(&w, pt.x, pt.y);
show0:
#ifdef	DOUBLE_PAGE
					if(IS_2PAGE){
						pDibNew = w.pDib - sizeof(BITMAPFILEHEADER);
						goto renew;
					}
#endif
					goto show;

				case ID_SCALE1:
				case ID_SCALE2:
				case ID_SCALE3:
				case ID_SCALE4:
					size = id_value - ID_SCALE1;
					 if(w.pDib == NULL)
						return 0;
					Win2BufPoint(&w, &pt, w.cxClient/2, w.cyClient/2);
					SetGamma(scale[size].gamma);
					SetXYGray(scale[size].x, scale[size].y);
					CheckView(size);
					goto chgbmp;

				case ID_RESCUTEDGE:
					if(!w.pDib)
						return 0;
					CutEdge(-1);
					f_cutedge = 0;
					goto re_open;

				case ID_CUTEDGE1:
					if(!w.pDib || f_cutedge)
						return 0;
					f_cutedge = 1;
					CutEdge(1);
					goto re_open;

				case ID_CUTEDGE:
					if(!w.pDib)
						return 0;
					CutEdge(0);
					f_cutedge = 0;
					goto re_open;

#ifdef	DOUBLE_PAGE
/* The followings are codes for 4, 16-page mode.
   However, there is a bug that selecting twice
   make the page go ahead 3 or 15 pages.
   Why?? */
				case ID_16PAGE:
id_16page:			if(!w.pDib)
						return 0;
					if( IS_MPAGE && IS_16PAGE ){
						pos = GetCurrentPage();
						goto page16;
					}
					if((pos = GetTotalPage()) - GetCurrentPage() < 15){
page16:					pos -= 15;
						xx = f_dvioutspecial;
						f_dvioutspecial = FALSE;
						ReplaceBmp(&w, GotoPage(pos));
						f_dvioutspecial = xx;
					}
					if(!DisplayPages(4))
						return 0;
					f_2page = F_MPAGE|F_16PAGE;
					goto show;

				case ID_CROSS:
id_cross:			if(!w.pDib)
						return 0;
					if( IS_MPAGE && !IS_16PAGE ){
						pos = GetCurrentPage();
						goto page4;
					}
					if((pos = GetTotalPage()) - GetCurrentPage() < 3){
page4:					pos -= 3;
						xx = f_dvioutspecial;
						f_dvioutspecial = FALSE;
						ReplaceBmp(&w, GotoPage(pos));
						f_dvioutspecial = xx;
					}
					if(!DisplayPages(2))
						return 0;
					f_2page = F_MPAGE;
					goto show;

				case ID_ONEPAGE:
					if(!f_2page)
						break;
					pos = 0;
				case ID_DOUBLE:
				case ID_RDOUBLE:
				case ID_VDOUBLE:
					if(w.pDib==NULL)
						break;
					CheckMenu(ID_DOUBLE, 0);
					CheckMenu(ID_RDOUBLE, 0);
					CheckMenu(ID_VDOUBLE, 0);
					if(GetTotalPage() < 2)
						goto onepage;
					if(IS_2PAGE){
						if(id_value == ID_ONEPAGE)
							goto onepage;
						pos = 0;
						if(IS_2REV){
							if(id_value == ID_DOUBLE){			// 2 Rev -> 2 Norm
									f_2page &= ~F_2REV;
								goto f2chg;
							}else if(id_value == ID_VDOUBLE)	// 2 Rev -> 2 Vert
								pos = 1;
						}else if(!IS_2VERT){
							if(id_value == ID_RDOUBLE){			// 2 Norm -> 2 Rev
								f_2page = 0;
								goto f2chg;
							}else if(id_value == ID_VDOUBLE)	// 2 Norm -> 2 Vert
								pos = 1;
						}else if(id_value != ID_VDOUBLE)		// 2 Vert -> 2 Norm, 2 Rev
							pos = 1;
						else if(f_FIT)							// 2 Vert -> 2 Vert
							return 0;
onepage:				if(IsSecondPage(GetCurrentPage()))		// 2 -> Norm
							ChgPage(GetCurrentPage()-1);
						f_2page = 0;
						Clear2Page();
						ExpandPage();
						f_CheckCover = TRUE;
						if(ReplaceBmp(&w, MakeBMP())){
							if(pos)
								goto f2chg;
							goto show;
						}
						break;
					}else{
						if(f_rpcolor == 5)
							goto f2renew;
						if(IS_MPAGE){
							ChgPage(f_2top);
f2renew:					f_2page = 0;
							ClearKeepBMP();
							ExpandPage();
							f_CheckCover = TRUE;
							ReplaceBmp(&w, MakeBMP());
							if(w.pDib == NULL)
								return 0;
						}
f2chg:					CheckMenu(id_value, 1);
						if(IS_2PAGE)
							goto show;
						f_2page = ((id_value==ID_VDOUBLE)?F_2VERT:F_2PAGE)|(GetCurrentPage()&1)
							|((id_value==ID_RDOUBLE)?F_2REV:0);
					}
					if((pDibNew = w.pDib) != NULL)
						pDibNew -= sizeof(BITMAPFILEHEADER);
					goto renew;
#endif
				case ID_BLACKER:
					if(w.pDib == NULL)
						return 0;
					pDibNew = Blacker();
					goto renew;

				case ID_WHITER:
					if(w.pDib == NULL)
						return 0;
					pDibNew = Whiter();
					goto renew;

				case ID_TOREVERSE:
					if(SetGamma(0) > 0){
scr_rev:				SetGamma(-SetGamma(0));
						if(w.pDib)
							goto re_open;
					}
					return 0;

				case ID_TONORMAL:
					if(SetGamma(0) < 0)
						goto scr_rev;
					return 0;

				case ID_REVERSE:
to_reverse:			if(w.pDib == NULL)
						return 0;
					SetGamma(-SetGamma(0));
					goto re_open;

				case ID_DRLINE:
				case ID_DRBOX:
					CheckMenuSet(id_value, ID_DRLINE, ID_DRBOX);
					draw_style = id_value - ID_DRLINE;
inipm:				if(g_winData.hWndPresenMenu)
						SendMessage( g_winData.hWndPresenMenu, WM_INITDIALOG, 0, 0 );
					return 0;

				case ID_DRERACE:
					SetPoint(0, 0, -2);
					goto show;

				case ID_DRRED:
				case ID_DRBLACK:
				case ID_DRBLUE:
				case ID_DRGREEN:
					CheckMenuSet(id_value, ID_DRRED, ID_DRGREEN);
					draw_color = (id_value - ID_DRRED)|(draw_color&F_DTHICK);
					goto inipm;

				case ID_DTHICK:
					draw_color ^= F_DTHICK;
					CheckMenu(ID_DTHICK, draw_color&F_DTHICK);
					goto inipm;

				case ID_BMARKPAGE:
					if((id_value = GetUserKey(4)) != 0)
						goto wmcmd;
					id_value = ID_MARKPAGE;
				case ID_MARKPAGE:
				case ID_MARKRANGE:
					MessageBeep(MB_OK);
					SaveH_Hist(&w, id_value - (ID_MARKPAGE-2));
					if(id_value == ID_MARKRANGE){
						if( h_hist[PAGE_MARK].id != id_dvi )
							SaveH_Hist(&w, 2);
					}
					if( h_hist[RANGE_MARK].id == id_dvi )
						SetMarkRange( h_hist[PAGE_MARK].page,
							h_hist[RANGE_MARK].page );
					return 0;

				case ID_BGOMARK:
					if((id_value = GetUserKey(5)) != 0)
						goto wmcmd;
				case ID_GOMARK:
				case ID_EXMARK:
					if(h_hist[PAGE_MARK].id != id_dvi || w.pDib == NULL)
						return 0;
					f_hist_msg = F_HM_MARK;
					SaveH_Hist(&w, 1);
					pt.x = h_hist[PAGE_MARK].x;
					pt.y = h_hist[PAGE_MARK].y;
					temp_page = h_hist[PAGE_MARK].page;
					if(id_value == ID_EXMARK)
						SaveH_Hist(&w, 2);
					size = 0;
					goto go_hist;

				case ID_TOPPAGE:
top_page:			if(w.pDib == NULL)
						return 0;
					temp_page = -50000;
					if( (HWND)lParam == g_winData.hWndToolBar && f_rev_movebutton )
						temp_page *= -1;
					goto nxtpg;

				case ID_LASTPAGE:
bottom_page:		if(w.pDib == NULL)
						return 0;
					temp_page = 50000;
					if( (HWND)lParam == g_winData.hWndToolBar && f_rev_movebutton )
						temp_page *= -1;
					goto nxtpg;

				case ID_DOWNPAGE:
downpage:			if(w.pDib == NULL)
						return 0;
					if(b_presentation_mode && (f_cover == 1) && !f_2page){
						if(GetPause(&xx, &yy, 1) >= 0){
							MoveCover(xx, yy, 1);
							if(f_coverM)
								Move2Pause(&w, cover_xpos, cover_ypos, 
									f_coverH);
							break;
						}
						if(  cover_xpos < GetTextXSize()
						  && cover_ypos < GetTextYSize() ){
							MoveCover((f_coverH & 2)?0x2000:-0x2000, 
								0x10000, 0);
							if(f_coverM)
								Move2Pause(&w, cover_xpos, cover_ypos, 
									f_coverH);
							break;
						}
					}
					if(!IS_MPAGE && CheckStop(0)){
// sprintf(common_work+0x1000, "%d:%d %d", GetCurrentPage(), stop_level, stop_max);
// AskYes(common_work+0x1000, "stop_level");
// AskYes("Same Page", "RESULT");
							SetStartPage(GetCurrentPage());
							f_KeepDraw = TRUE;
							if(pDibKeep)
								FreeBmp(pDibKeep);
							if(f_pDibKeep){
								pDibKeep = w.pDib;
								w.pDib = NULL;
							}
							rcStop.left = rcStop.right = 0;
							JoinBoundigBox(&rcStop, &StopG1Rec);
							goto opendvi;
					}
					if(GetCurrentPage() >= GetTotalPage()){
 						if( b_presentation_mode ){
							temp_page = -50000;
							goto nxtpg;
						} else
							return 0;
					}
					SaveH_Hist(&w, 1);
#ifdef	DOUBLE_PAGE
					if(IS_MPAGE)
						goto f2spq;
#endif
					if(ReplaceBmp(&w, nextpage(GetShiftPage(1))) == FALSE)
						return 0;
					ScrollWindow( g_winData.hWnd, 0, 
						-w.nVscrollPos, NULL, NULL );
					f_CheckCover = TRUE;
					if( f_flatscroll && GetVersionLevel() > 0 )
					{
						g_FlatSB_SetScrollPos( g_winData.hWnd, SB_VERT,
							w.nVscrollPos = 0, TRUE );
					}
					else
					{
						SetScrollPos( g_winData.hWnd, SB_VERT,
							w.nVscrollPos = 0, TRUE );
					}
					goto show0;

				case ID_UPPAGE:
uppage:				if(w.pDib == NULL || GetCurrentPage() <= 1)
						return 0;
					SaveH_Hist(&w, 1);
#ifdef	DOUBLE_PAGE
					if(IS_MPAGE)
						goto f2spp;
#endif
					if(ReplaceBmp(&w, nextpage(GetShiftPage(-1))) == FALSE)
						return 0;
					ScrollWindow( g_winData.hWnd, 0, 
						w.nVscrollMax - w.nVscrollPos, NULL, NULL );
					if( f_flatscroll && GetVersionLevel() > 0 )
					{
						g_FlatSB_SetScrollPos( g_winData.hWnd, SB_VERT,
							w.nVscrollPos = w.nVscrollMax, TRUE );
					}
					else
					{
						SetScrollPos( g_winData.hWnd, SB_VERT,
							w.nVscrollPos = w.nVscrollMax, TRUE );
					}
					goto show0;

				case ID_NEXTPAGE:
					temp_page = 1;
					if( (HWND)lParam == g_winData.hWndToolBar && f_rev_movebutton ) temp_page *= -1;
					if( GetKeyState( VK_SHIFT ) < 0 )
						temp_page *= 5;
					if( GetKeyState( VK_CONTROL ) < 0 )
						temp_page *= 10;
new_page:			if(w.pDib == NULL)
						return 0;
nxtpg:				CoverSuspend();
					SaveH_Hist(&w, 1);
					SetPageMoveButtons( &w );
#ifdef	DOUBLE_PAGE
					if(IS_MPAGE){
						if(temp_page == 1){
f2spq:						if(GetCurrentPage() >= GetTotalPage())
								return 0;
							pos = GetCurrentPage() + 1;
							goto f2sp0;
						}else if(temp_page == -1){
f2spp:						if(f_2top <= 1)
								return 0;
							pos = f_2top - (IS_16PAGE?16:4);
f2sp0:						xx = f_2page;
							if(ReplaceBmp(&w, GotoPage(pos)) == FALSE)
								return 0;
f2sp1:						if(xx & 0x2000)
								goto id_16page;
							goto id_cross;
						}
					}
#endif
					if((pDibNew	= nextpage(GetShiftPage(temp_page))) == NULL)
						return 0;
renew:
#ifdef	DOUBLE_PAGE
					if(IS_2PAGE)
						Get2Bmp();
#endif
					if(ReplaceBmp(&w, pDibNew) == FALSE){
						if( !(f_hyper && F_H_CURRENTPAGE) )
							return 0;
					}
					f_hyper &= ~F_H_CURRENTPAGE;
					pDibNew = NULL;
					goto show;

				case ID_BFORMERHIST:
					if((id_value = GetUserKey(2)) != 0)
						goto wmcmd;
				case ID_FORMERHIST:
					size = -1;
					if(h_hist_pt == h_hist_n){
						f_hist_msg = F_HM_HISTORY;
						SaveH_Hist(&w, 1);
					}
idhist:				GetH_Hist(&pt, &temp_page, size);
go_hist:			if(!temp_page){
						if(size == -1)
							goto lastfile;
						break;
					}
					if(temp_page != GetCurrentPage()
					  && ReplaceBmp(&w, GotoPage(temp_page)) == FALSE)
						break;
					BufPoint2Center(&w, pt.x, pt.y);
					goto show;

				case ID_BNEXTHIST:
					if((id_value = GetUserKey(3)) != 0)
						goto wmcmd;

				case ID_NEXTHIST:
					size = 1;
nxthst:				if(h_hist_pt == h_hist_n)
						break;
					goto idhist;

				case ID_QUITHIST:
					size = 0;
					goto nxthst;

				case ID_PREVPAGE:
					temp_page = -1;
					if( (HWND)lParam == g_winData.hWndToolBar && f_rev_movebutton ) temp_page *= -1;
					if( GetKeyState( VK_SHIFT ) < 0 )
						temp_page *= 5;
					if( GetKeyState( VK_CONTROL ) < 0 )
						temp_page *= 10;
					goto new_page;

				case ID_50PAGE:
					temp_page = 50;
					goto new_page;

				case ID_20PAGE:
					temp_page = 20;
					goto new_page;

				case ID_10PAGE:
					temp_page = 10;
					goto new_page;

				case ID_5PAGE:
					temp_page = 5;
					goto new_page;

				case ID_2PAGE:
					temp_page = 2;
					goto new_page;

				case ID_m2PAGE:
					temp_page = -2;
					goto new_page;

				case ID_m5PAGE:
					temp_page = -5;
					goto new_page;

				case ID_m10PAGE:
					temp_page = -10;
					goto new_page;

				case ID_m20PAGE:
					temp_page = -20;
					goto new_page;

				case ID_m50PAGE:
					temp_page = -50;
					goto new_page;

				case ID_EDITPAGE:
					SetFocus(g_winData.hWndPageEdit);
					SetWindowText( g_winData.hWndPageEdit, "" );
					return 0;

				case ID_INFO:
					if(w.pDib)
						DisplayInfo(w.pDib);
					else
						MessageNoFile();
					return 0;

				case ID_INFO_BUFFER:
					ShowBuffer();
					return 0;

				case ID_INFO_MAP:
					fttInfo();
					return 0;

				case ID_INFO_FONT:
					if(w.pDib)
						ShowInformation();
					else
						MessageNoFile();
					return 0;

				case ID_INFO_SYS:
					EnvironInfo();
					error(DATATITLE, "System Information");
					return 0;

				case ID_INFO_PARA:
					ShowParameter();
					return 0;

				case ID_INFO_PROPW:
					if(!AskYes(
						"Do you really want to perform this function?\n"
						"See newjfm.txt/propw.txt in a package in ./FONT",
						"Output character sizes of TrueType Japanese fonts"))
						return 0;
					SetPropw(2);
					goto chk_re_open;

				case ID_DIFOPTION:
					error(C_MSG, "%s", PrintAllPara(0));
					error(DATATITLE, "Non-default parameters");
					return 0;

				case ID_ALLOPTION:
					error(C_MSG, "%s", PrintAllPara(1));
					error(DATATITLE, "All parameters");
					return 0;

				case ID_OPTION:
					f_prop = 1;
					CreateTabCtrl( g_winData.hMainWnd );
					if(f_prop)
						return 0;
					CheckMenu(ID_COLOR, f_spcolor);
					CheckMenu(ID_REPCOLOR, f_rpcolor >= 2 && f_rpcolor != 6);
					tmpname = GetParaString("y");
land:				CheckMenu(ID_LANDSCAPE,
						tmpname != NULL && *tmpname
						&& tmpname[strlen(tmpname)-1] == 'L');
					goto chk_re_open;

				case ID_PREPARA:
					if(b_presentation_mode){
						KillTimer8();
						ActivateCursor();
					}
					DialogBox(g_winData.hInstance,
						MAKEINTRESOURCE(IDD_READMACRO),
						g_winData.hWnd, DlgReadParaProc);
					if(b_presentation_mode)
						KillCursor();
					goto chk_re_open;

				case ID_INSTALL:
					InstallPara();
					break;

				case ID_UNINSTALL:
				  {
					static char *reg_key[] = {
						"FILE", "FIND", "KeyTable", "Settings"
					};
					if(MessageBox(g_winData.hMainWnd,
						"Delete all data in registry created by dviout\n"
						"and quit dviout (cf. Help->Help Topics->Uninstall).",
						"Warning",
						MB_OKCANCEL|MB_DEFBUTTON2|MB_ICONEXCLAMATION)
							== IDOK
					 && MessageBox(g_winData.hMainWnd,
						"Do you really want to uninstall dviout?",
						"Warning",
						MB_OKCANCEL|MB_DEFBUTTON2|MB_ICONEXCLAMATION)
							== IDOK){
						if((tmpname = getenv("TMP")) != NULL ||
						   (tmpname = getenv("TEMP")) != NULL){
						   strcpy(common_work, tmpname);
						   tmpname = common_work + strlen(common_work);
						   if(tmpname == common_work || *(tmpname-1) != '\\')
							*tmpname++ = '\\';
							strcpy(tmpname, "DVITMP.BAT");
							unlink(common_work);
							strcpy(tmpname, "DVITMP.PAR");
							unlink(common_work);
							strcpy(tmpname, "GEN_TMP.BAT");
							unlink(common_work);
						}
			// parameters
						strcpy(fname, "Software\\SHIMA\\DVIOUT\\");
						for(temp_page = 0; 
						  temp_page < sizeof(reg_key)/sizeof(char *);
						  temp_page++){
							strcpy(fname+22, reg_key[temp_page]);
							RegDeleteKey(HKEY_CURRENT_USER, fname);
						}
						for(temp_page = 0; temp_page < 10; temp_page++){
							wsprintf(fname+22, "para%c", temp_page + '0');
							RegDeleteKey(HKEY_CURRENT_USER, fname);
						}
						fname[21] = 0;
						RegDeleteKey(HKEY_CURRENT_USER, fname);
						fname[14] = 0;
						RegDeleteKey(HKEY_CURRENT_USER, fname);

			// .dvi
						strcpy(fname, "dvifile\\Shell\\open\\command");
						RestoreClassString(common_work, 0x200, fname, 
							NULL, "");
						tmpname = GetOutPath("exe");
						for(pos = 0; tmpname[pos]; pos++){
							if(tmpname[pos] != common_work[pos])
								goto uninst_skip;
						}
						RegDeleteKey(HKEY_CLASSES_ROOT, fname);
						fname[18] = 0;
						RegDeleteKey(HKEY_CLASSES_ROOT, fname);
						fname[13] = 0;
						RegDeleteKey(HKEY_CLASSES_ROOT, 
							"dvifile\\Defaulticon");
						RegDeleteKey(HKEY_CLASSES_ROOT, "dvifile");
						RegDeleteKey(HKEY_CLASSES_ROOT, ".dvi");

uninst_skip:	// start menu
						if(CallExplorer(START_EXPL, NULL, NULL, NULL)
						  == 0)
							goto uninst_end;
						CallExplorer(DELETE_GROUP, "dviout", NULL, NULL);
						CallExplorer(END_EXPL, NULL, NULL, NULL);
uninst_end:				pos = strlen(tmpname);
						strcpy(tmpname + pos - 3, "gid");
						chmod(tmpname, S_IREAD|S_IWRITE);
						unlink(tmpname);
						strcpy(tmpname + pos - 4, "e.gid");
						chmod(tmpname, S_IREAD|S_IWRITE);
						unlink(tmpname);
						while(--pos > 1){
							if(tmpname[pos] == '\\' || tmpname[pos] == '/')
								break;
						}
						tmpname[pos] = 0;
						sprintf(common_work, 
							"Registry is restored.\n"
							"The holder of dviout is %s\n"
							"Push [Ok] and move the holder to trash box "
							"by explorer if it is unnecessary.",
							tmpname);
						MessageBox(g_winData.hMainWnd, common_work, 
							"Uninstall", MB_OK);
						exit(0);
					}
				  }
					return 0;

				case ID_MODE_CHANGE:
					DialogBox( g_winData.hInstance,
						MAKEINTRESOURCE(IDD_MODE),
						g_winData.hWnd, ModeDlgProc );
					goto chk_re_open;

				case ID_NOMORE_DVIOUT:
					DialogBox( g_winData.hInstance,
						MAKEINTRESOURCE(IDD_NOMORE),
					g_winData.hWnd, NoMoreDlgProc );
					return 0;

				case ID_CHGFONT:
					DialogBox(g_winData.hInstance,
						MAKEINTRESOURCE(IDD_CHGFONT),
						g_winData.hWnd, DlgChgFontProc);
					goto chk_re_open;

				case ID_MYHELP:
					WinHelp(g_winData.hMainWnd, "WINHELP32.HLP", 
						HELP_FINDER, 0);
					return 0;

				case ID_HELP_CONTENTS:
//					WinHelp(g_winData.hMainWnd, GetHelpPath(), 
//						HELP_FINDER, 0);
					HtmlHelp(g_winData.hMainWnd, GetHelpPath(),HH_DISPLAY_TOC, (DWORD)NULL);
					return 0;

				case ID_FRAME0:
					g_view.f_StatusBar = g_view.f_PageSlider
					= g_view.f_ToolBar = g_view.f_ScrollBar = 0;
					CheckMenu(ID_STATUS_VIEW, 0);
					CheckMenu(ID_SLIDER_VIEW, 0);
					CheckMenu(ID_TOOLBAR_VIEW, 0);
					CheckMenu(ID_SCROLLBAR_VIEW, 0);
					ResizeAllWindows();
					ShowHyperLink( NULL );
					bShowingHref = FALSE;
					f_quit = 1;
					if(w.pDib == NULL)
						break;
					goto show;

				case ID_KSTOP:
					f_kill = !f_kill;
kill:				CheckMenu(ID_KSTOP, f_kill);
					stop_level = 0;
					if(!f_kill)
						CheckStop(1);
					break;

				case ID_STOPON:
					f_kill = TRUE;
					goto kill;

				case ID_STOPOFF:
					f_kill = FALSE;
					goto kill;

				case ID_DIN:
					f_Din = !f_Din;
Din:				CheckMenu(ID_DIN, f_Din);
					break;

				case ID_DINON:
					f_Din = TRUE;
					goto Din;

				case ID_DINOFF:
					f_Din = FALSE;
					goto Din;
				
				case ID_STATUS_VIEW:
					toggle = &g_view.f_StatusBar;
					goto view_bar;

				case ID_SLIDER_VIEW:
					toggle = &g_view.f_PageSlider;
					goto view_bar;

				case ID_TOOLBAR_VIEW:
					toggle = &g_view.f_ToolBar;
view_bar:			*toggle = !*toggle;
					ResizeAllWindows();
					ShowHyperLink( NULL );
					bShowingHref = FALSE;
					CheckMenu(id_value, *toggle);
					break;

				case ID_SCROLLBAR_VIEW:
					g_view.f_ScrollBar = !g_view.f_ScrollBar;
					CheckMenu(id_value, g_view.f_ScrollBar);
					if( w.pDib == NULL )
						break;
					goto show;

				case ID_WARNING_VIEW:
					CheckMenu(ID_WARNING_VIEW, view_warning(1));
					break;

				case ID_USELBUTTON:
					f_coverB ^= 1;
					goto usrrb;

				case ID_USERBUTTON:
					f_coverB ^= 2;
usrrb:				CheckMenu(ID_USELBUTTON, f_coverB & 1);
					CheckMenu(ID_USERBUTTON, f_coverB & 2 );
					break;

				case ID_EDITOR_VIEW:
					ShowPickedString("", "Small Editor");
					break;

				case ID_COVERSUSPEND:		// Presentation mode only
					CoverSuspend();
					break;

				case ID_COVERRETURN:		// Presentation mode only
					if((pos = CoverReturn()) != 0){
						if(f_2page){
							if(IS_2PAGE){
								Clear2Page();
								CheckMenu(ID_DOUBLE, 0);
								CheckMenu(ID_RDOUBLE, 0);
								CheckMenu(ID_VDOUBLE, 0);
							}else{
								AddKeepBMP(0);
								ClearKeepBMP();
							}
							f_2page = 0;
						}
						f_cover = 1;
						if(pos == 2)
							goto opendvi1;
						SaveH_Hist(&w, 1);
						pDibNew = nextpage(0);
						goto renew;
					}
					break;

				case ID_COVEROFF:
					if(f_cover){
						CheckMenuSet(id_value, ID_COVERSHEET, ID_COVERSHEET+2);
						CoverSuspend();		// keep if COVER ON
						f_cover = 0;
						if(b_presentation_mode){
							if(g_winData.hWndPresenMenu)
								SendMessage( g_winData.hWndPresenMenu, WM_INITDIALOG, 0, 0 );
							goto chk_re_open;
						}
					}
					break;

				case ID_COVERON:
				case ID_COVERSHEET:
					f_cover = 1;
					f_coverP = (id_value == ID_COVERSHEET)?TRUE:FALSE;
					CheckMenuSet(id_value, ID_COVERSHEET, ID_COVERSHEET+2);
					if(!b_presentation_mode)
						break;
					if(w.pDib)
						KeepCover();
					if(!f_HandMouse){
						f_HandMouse = TRUE;
						g_loupe.f_circle |= F_LHAND;
						SendMessage( g_winData.hWndToolBar, 
							TB_CHECKBUTTON, ID_MHAND, MAKELONG(TRUE,0));
					}
					if(!f_2page && f_coverP
					  && !cover_xpos && !cover_ypos ){
						if(GetPause(&xx, &yy, 1) >= 0)
							MoveCover(xx, yy, 1);
						else
							f_CheckCover = TRUE;
					}
					if(g_winData.hWndPresenMenu)
						SendMessage( g_winData.hWndPresenMenu, WM_INITDIALOG, 0, 0 );
					RenewCover();
					f_CheckCover = TRUE;
					goto chk_re_open;

				case ID_SCROL2PAUSE:
					f_coverM = !f_coverM;
					CheckMenu(ID_SCROL2PAUSE, f_coverM);
					break;

				case ID_SEAMLESS:
					f_seamless = !f_seamless;
					CheckMenu(ID_SEAMLESS, f_seamless);
					break;

				case ID_PAINTON:
					f_StopPaint = FALSE;
					break;

				case ID_PAINTOFF:
					f_StopPaint = TRUE;
					break;

				case ID_ENGLISH_HELP:
					f_English = !f_English;
					CheckMenu(ID_ENGLISH_HELP, f_English);
					break;

				case ID_TROUBLE_HELP:
				case ID_TIPS:
					strcpy(common_work, GetOutPath("exe"));
					pos = strlen(common_work);
					while(pos-- > 0 && common_work[pos] != '\\');
					strcpy(common_work+pos+1, 
						id_value==ID_TROUBLE_HELP?
						"\\DOC\\dvioutQA.html":(f_English?
							"\\DOC\\dviouttipse.html":"\\DOC\\dviouttips.html"));
					ExecHref(hwnd, common_work);
					break;

				case ID_INPUT:
					strcpy(common_work, GetOutPath("exe"));
					xx = pos = strlen(common_work)+1;
					if(texhelp != NULL)
						strcpy(common_work+pos, texhelp);
					else
						common_work[pos] = 0;
					
					if(strlen(common_work+pos) < 4){
						yy = GetSystemMetrics(SM_CXSCREEN);
						sprintf(common_work+pos, 
							"-NULL=(%d,-20)-(%d,751) -dpi=", yy-478, yy+3);
						yy = GetXDpi();
						if(yy%100 == 0){
							sprintf(common_work+0x1000,
								"%d -BMP=%d:%d:800",
								yy, yy/100, yy/100);
							strcat(common_work+pos, common_work+0x1000);
						}else
							strcat(common_work+pos, "600 -BMP=6:6:800");
					}
					while(common_work[pos] > 0 && common_work[pos] <= ' ')
						pos++;
					yy = pos;
					if(common_work[pos]){
						while(common_work[pos])
							pos++;
						if(!strcmp(common_work+pos-4, ".dvi")){
							while(common_work[--pos] > ' ' || common_work[pos] < 0);
							pos++;
							SetPath(common_work+pos, common_work+pos);
							goto texhlp;	
						}
						common_work[pos++] = ' ';
					}
					strcpy(common_work+pos, common_work);
					pos += xx-1;
					while(pos-- > 0 && common_work[pos] != '\\');
					strcpy(common_work+pos+1, "HyperTeX\\input.dvi");
texhlp:				ShellExecute(hwnd, NULL, common_work, common_work+xx,
						NULL, SW_SHOWNORMAL);
					break;

				case ID_GRAPHIC:
					if(!f_graphics){
						f_graphics = f_GS|((f_gbox)?0x1000:0x2000);
						f_GS = 0;
						f_gbox = TRUE;
					}else{
						f_GS = (f_graphics & 0xff);
						if(!(f_graphics & 0x1000))
							f_gbox = FALSE;
						f_graphics = 0;
					}
					CheckMenu(ID_GRAPHIC, !f_graphics);
					goto chk_re_open;

				case ID_COLOR:
					f_spcolor = 1 - f_spcolor;
					CheckMenu(ID_COLOR, f_spcolor);
					goto chk_re_open;

				case ID_REPCOLOR:
					if(f_rpcolor >= 2 && f_rpcolor != 6){
						f_rpold2 = f_rpcolor;
						f_rpcolor = (f_rpold >= 0)?f_rpold:0;
					}else{
						f_rpold = f_rpcolor;
						f_rpcolor = (f_rpold2 >=0)?f_rpold2:2;
					}
					CheckMenu(ID_REPCOLOR, f_rpcolor >= 2 && f_rpcolor!=6);
chk_re_open:		if(w.pDib)
						goto re_open;
					return 0;

				case ID_PENONOFF:
					f_Pen = !f_Pen;
					CheckMenu(ID_PENONOFF, f_Pen);
					break;

				case ID_FLASHLESS:
					f_pDibKeep = !f_pDibKeep;
					CheckMenu(ID_FLASHLESS, f_pDibKeep);
					break;

 // 0x0f Black
 // 0x9f(blue), 0xaf(green),  0xbf(cyan), 0xcf(red), 0xdf(magenta), 0xef(yellow)
				case ID_PENBLACK:
				case ID_PENRED:
				case ID_PENBLUE:
				case ID_PENGREEN:
				case ID_PENMAGENTA:
				case ID_PENCYAN:
				case ID_PENYELLOW:
				case ID_PENWHITE:
					xx = id_value - ID_PENBLACK;
					PenType &= 0xf;
					if(SetGamma(0) > 0)
						PenType |= xx*0x10+0x80;
					else
						PenType |= (~xx & 0x0f)*0x10;
					CheckMenuSet(id_value, ID_PENBLACK, ID_PENWHITE);
					break;

				case ID_PENW1:
				case ID_PENW2:
				case ID_PENW3:
				case ID_PENW4:
					PenWidth = id_value - ID_PENW1;
					if(PenWidth >= 3)
						PenWidth += 2;
					CheckMenuSet(id_value, ID_PENW1, ID_PENW4);
					break;

				case ID_PENT1:
				case ID_PENT2:
				case ID_PENT3:
				case ID_PENT4:
				case ID_PENT5:
					xx = PenTdata[id_value - ID_PENT1];
					PenType = (PenType & 0xf0)|xx;
					CheckMenuSet(id_value, ID_PENT1, ID_PENT5);
					break;

				case ID_PENCLEAR:
					CheckPenBuf();
					goto show;

				case ID_TOOLBAR_CHANGE:
					EnableButton(TRUE);
					SendMessage(g_winData.hWndToolBar, TB_ENABLEBUTTON, 
						ID_BNEXTHIST, TRUE);
					SendMessage(g_winData.hWndToolBar, TB_ENABLEBUTTON, 
						ID_BGOMARK, TRUE);
					ChangeToolBar(2);
					if( w.pDib == NULL ){
						EnableButton(FALSE);
						return 0;
					}
					goto show;

				case ID_FLAT_SCROLLBAR:
					f_flatscroll = f_flatscroll?FALSE:TRUE;
					MessageCBox( g_winData.hWnd, "The style of scroll bar will change\n"
						"when you restart dviout.", "Information", MB_OK );
					CheckMenu(ID_FLAT_SCROLLBAR, f_flatscroll);
					break;

				case ID_PAGEBUTTON:
					f_pagebutton = f_pagebutton?FALSE:TRUE;
					if( f_pagebutton )
						MessageCBox( g_winData.hWnd, "The buttons to move page will\n"
						"appear when you restart dviout.", "Information", MB_OK );
					else
						MessageCBox( g_winData.hWnd, "The buttons to move page will\n"
						"disappear when you restart dviout.", "Information", MB_OK );
					CheckMenu(ID_PAGEBUTTON, f_flatscroll);
					break;

				case ID_REVERSE_MOVEBUTTON:
					f_rev_movebutton = f_rev_movebutton?FALSE:TRUE;
					CheckMenu(ID_REVERSE_MOVEBUTTON, f_rev_movebutton );
					SetPageMoveButtons( &w );
					break;

				case ID_VBACK_DEF:
					pos = -1;
					goto v_back;

				case ID_VBACK_WHITE:
					pos = 0xffffff;
					goto v_back;

				case ID_VBACK_BLACK:
					pos = 0;
v_back:				ReserveInt("Settings", "ViewBack", pos);
					CheckMenuSet(id_value, ID_VBACK_DEF, ID_VBACK_BLACK);
					MessageCBox( g_winData.hWnd, 
						"Setting of the background will be valid\n"
						"when you restart dviout.", "Information",
						 MB_OK );
					break;

				case ID_WHITEDEF:
				case ID_BLACKDEF:
				case ID_DEFDEF:
				case ID_BLACKBACK:
				case ID_WHITEBACK:
					f_background = id_value - ID_WHITEDEF;
					CheckMenuSet(id_value, ID_WHITEDEF, ID_WHITEBACK);
					break;

				case ID_COVERB:
				case ID_COVERR:
				case ID_COVERL:
				case ID_COVERBR:
				case ID_COVERBL:
					xx = id_value - ID_COVERB;
					switch(xx){
						case 0:
							f_coverH = 1;
							break;
						case 1:
							f_coverH = 2;
							break;
						case 2:
							f_coverH = 4;
							break;
						case 3:
							f_coverH = 3;
							break;
						case 4:
							f_coverH = 5;
							break;
					}
					CheckMenuSet(id_value, ID_COVERB, ID_COVERB+4);
					break;

				case ID_INF_LARGE:
					inf_size = 4 ;
					goto check_inf_size;
				case ID_INF_MEDIUM:
					inf_size = 2;
					goto check_inf_size;
				case ID_INF_SMALL:
					inf_size = 1;
check_inf_size:		CheckMenuSet(id_value, ID_INF_LARGE, ID_INF_SMALL);
					CYSHOWMESSAGE = MINI_INFO*inf_size;
					ResizeAllWindows();
					break;

				case ID_ABOUTB:
					if((id_value=GetUserKey(0)) == 0)
						id_value = ID_DVIPRT;
					goto wmcmd;

				case ID_ABOUT:
					DialogBox( g_winData.hInstance, 
							MAKEINTRESOURCE(IDD_ABOUTDIALOG), 
							g_winData.hMainWnd, AboutDlgProc );
					return 0;

				case ID_LASTFILE:
lastfile:				if(f_hist_pt > f_hist0 + 1)
						SendMessage(g_winData.hWnd, WM_USR_HDIALOG, 
							(f_hist_pt - 2)|0x1000, 0L);
					return 0;

				case ID_F_HISTORY:
					if(f_hist_pt <= f_hist0)
						return 0;
					goto diaghis;

				case ID_P_HISTORY:
					if(w.pDib){
diaghis:				id_hist = id_value;
						f_hist_msg = F_HM_HISTORY;
						SaveH_Hist(&w, 1);
						DialogBox( g_winData.hInstance, 
							MAKEINTRESOURCE(IDD_HISTORYDIALOG),
							hwnd, DlgHFunct);
					}
					return 0;

				case ID_FMENU1:
				case ID_FMENU2:
				case ID_FMENU3:
				case ID_FMENU4:
				case ID_FMENU5:
				case ID_FMENU6:
				case ID_FMENU7:
				case ID_FMENU8:
				case ID_FMENU9:
					pos = id_value - ID_FMENU1;
					if(!f_fmenu[pos].name)
						return 0;
					if(		HIBYTE(GetKeyState(VK_SHIFT))
						&& !HIBYTE(GetKeyState(VK_CONTROL)) ){
						strncpy(fname, f_fmenu[pos].name+3, MAX_PATH);
						size = strlen(fname);
						while(size && fname[size] != '\\' && 
						  fname[size] != ':')
							size--;		// cut the file name
						if(size){
							fname[size+1] = 0;
							size = GetFileAttributes(fname);
							if(size != 0xffffffff
							  && (size & FILE_ATTRIBUTE_DIRECTORY)
							  && QueryFileName(fname))
								goto opendvi0;
							return 0;
						}
					}
					if(strcmp(current_name, f_fmenu[pos].name+3) || !w.pDib){
						if(access(f_fmenu[pos].name+3, 0)){
							error(WARNING, "Cannot find %s", 
								f_fmenu[pos].name+3);
							return 0;
						}
						DefineDVIFileName( f_fmenu[pos].name+3 );
						if(!HIBYTE(GetKeyState(VK_CONTROL)))
							SetStartPage(f_fmenu[pos].page);
						else
opendvi0:					if(HIBYTE(GetKeyState(VK_SHIFT)))
								SetStartPage(30000);
						SetColor(4);
						goto opendvi1;
					}
					if(!(temp_page = f_fmenu[pos].page-GetCurrentPage()))
						return 0;
					goto nxtpg;

				case ID_SCRUP:
					goto scr_up;

				case ID_SCRDW:
					goto scr_down;

				case ID_SCRLF:
					goto scr_left;

				case ID_SCRRT:
					goto scr_right;

				case ID_FILEOPEN:
					if( !QueryFileName(NULL) )
						return 0;
					SetColor(4);
					goto new_open;

				case ID_SAVECLIPBMP:
				case ID_SAVECLIPWMF:
					if(w.pDib == NULL)
						return 0;
/*
					if(RectCut(0)){
						pos = AskYes(
							"Save indicated Region (Yes)?\n"
							"No -> the current whole sheet",
							(id_value == ID_SAVECLIPBMP)?
							"Copy to Clipboard as BMP":
							"Copy to Clipboard as EMF");
					}else
						pos = 0;
*/
					pos = RectCut(0)?1:0;
					tmpname = NULL;
					xx = ((BITMAPINFOHEADER*)w.pDib)->biBitCount;
					if(id_value == ID_SAVECLIPBMP)
						goto clipbmp;
					goto clipemf;

				case ID_SAVEIMG:
					if(w.pDib == NULL)
						return 0;
					if(RectCut(0)){
						pos = AskYes(
							"Save indicated Region (Yes)?\n"
							"No -> the current whole sheet",
							"Save as a image file(BMP/EMF/BMC/PNG/PDF/EPS etc.)");
					}else
						pos = 0;
					if((tmpname = QuerySaveName()) != NULL ){
						char *ext;

						size = strlen(tmpname);
						for(ext = NULL, xx = 1; xx < 5 && xx < size; xx++){
							if(tmpname[size - xx] == '.'){
								ext = tmpname + size - xx;
								break;
							}
						}
						if(ext == NULL){
							strcat(tmpname + size, ".bmp");
							ext = tmpname+size;
							size += 4;
						}
						xx = ((BITMAPINFOHEADER*)w.pDib)->biBitCount;

			/* EMF output */
						if( !stricmp(ext, ".emf") ){
clipemf:					if(pos){
								href = MareaPara("y OX OY", 1);
								RectCut(1);
								ReplaceBmp(&w, MakeBMP());
							}
							error(C_MSG, "%s: %d x %d pixel (%d bits)", 
								(tmpname==NULL)?"clipboad":tmpname, 
								GetDibWidth(w.pDib), GetDibHeight(w.pDib), xx);
							error(DATATITLE, "Save as a emf file");
							Page2EMF(tmpname);
							if(!pos)
								goto re_open;
rect_recv:					href = MareaPara(href, -1);
rect_rec2:					ExpandPage();
							pDibNew = MakeBMP();
							goto renew;
						}
			/* general format except for emf/bmp/bmc */
						if(*ext && ext[1]
						  && stricmp(ext, ".bmp") && stricmp(ext, ".bmc") ){
							sprintf(common_work, "^x\\utility\\dvi$%s.bat", ext+1);
							if(my_access(common_work, 0) != FAILURE){
								SaveImage(pos, tmpname);
								return 0;
							}
				/* ask A-B converter */
							yy = open_xplugin(ext, xx);
							if(yy && yy <= 8){
								unsigned char *Binfo, *Bdata;
								int Sdata, Ssize;

								if(xx != yy){
									if(xx = 1)
										yy = 8;
									SetColor(yy);
								}
								if(pos || xx != yy){
									if(pos){
										href = MareaPara("y OX OY sdpi", 1);
										RectCut(1);
									}
									SetParaInt("sdpi", GetXDpi()*2);
									pDibNew = MakeBMP();
								}
								else
									pDibNew = w.pDib-sizeof(BITMAPFILEHEADER);

				/* require memory blocks */
								Ssize=((BITMAPFILEHEADER*)pDibNew)->bfSize;
								Sdata=((BITMAPFILEHEADER*)pDibNew)->bfOffBits;
								Binfo = marea(Sdata-sizeof(BITMAPFILEHEADER));
								memcpy(Binfo, pDibNew+sizeof(BITMAPFILEHEADER),
									Sdata - sizeof(BITMAPFILEHEADER));
								Bdata = (pos || xx != yy)?
										pDibNew:marea(Ssize - Sdata);
								memmove(Bdata, pDibNew + Sdata, Ssize - Sdata);

				/* use A-B converter */
								inf_size = SavePicture(tmpname, Binfo, Bdata, 
									GetDibWidth(Binfo), GetDibHeight(Binfo),
									yy, "Created by dviout");

								open_xplugin(NULL, 0);

								if(xx != yy)
									SetColor(xx);
								error(C_MSG, "%s: %d x %d pixel (%d bits)", 
									tmpname, 
									GetDibWidth(Binfo), GetDibHeight(Binfo),
									yy);
								Free0(Binfo);
								Free0(Bdata);

								error(DATATITLE, "%save as a %s file", 
									inf_size?"Cannot s":"S",
									ext + 1);
								ToDviDir();
								if(pos)
									goto rect_recv;
								if(xx != yy)
									goto rect_rec2;
								return 0;
							}
							if(yy){
								open_xplugin(NULL, 0);
								error(WARNING, "Cannot save as a %s file"
									"(color bits %d)", ext+1, yy);
							}else
								error(WARNING, "Cannot save as a %s file"
									"(No plug-in: ex%s.xpi)", ext+1, ext+1);
							return 0;
						}
		/* bmp/bmc format */
						if( (fp = fopenf(tmpname, "wb")) != NULL ){
clipbmp:					if(pos){
								href = MareaPara("y OX OY", 1);
								RectCut(1);
								ReplaceBmp(&w, MakeBMP());
							}
							error(C_MSG, "%s: %d x %d pixel (%d bits)", 
								(tmpname==NULL)?"clipboad":tmpname, 
								GetDibWidth(w.pDib), GetDibHeight(w.pDib), xx);
							if(tmpname == NULL){
								unsigned char *Bdata;

								pDibNew = w.pDib-sizeof(BITMAPFILEHEADER);
								xx =((BITMAPFILEHEADER*)pDibNew)->bfSize -sizeof(BITMAPFILEHEADER);
								Bdata = marea(xx);
								memmove(Bdata, w.pDib, xx);
								OpenClipboard(g_winData.hMainWnd);
								EmptyClipboard();
								SetClipboardData(CF_DIB, GlobalHandle(Bdata));
								CloseClipboard();
								Free(Bdata);
							}else if(!stricmp(ext, ".bmc")){
								tmpname[size-1] = 'p';
								fclose(fp);
								bmp2bmc(tmpname,
		(unsigned char*)w.pDib - sizeof(BITMAPFILEHEADER),
		((BITMAPFILEHEADER *)((char*)w.pDib-sizeof(BITMAPFILEHEADER)))->bfSize);
								tmpname = "BMC";
							}else{
								fwrite((char*)w.pDib-sizeof(BITMAPFILEHEADER),
		((BITMAPFILEHEADER *)((char*)w.pDib-sizeof(BITMAPFILEHEADER)))->bfSize,
							  	1, fp);
								fclose(fp);
								tmpname = "BMP";
							}
							ToDviDir();
							if(tmpname==NULL)
								error(DATATITLE, "Saved in Clipboard");
							else
								error(DATATITLE, "Saved as a %s file", tmpname);
							if(pos)
								goto rect_recv;
						}else
							error(WARNING, "Cannot open %s", tmpname);
					}
					return 0;

				case ID_READOPTION:
					if((tmpname = QueryParaName()) == NULL)
						return 0;
					pos = GetNamePos(tmpname);
					pos = ( tmpname[pos] ==  '$' && tmpname[pos+1] == '_')?
						0x1000:0;
					pos |= CheckParaFile(tmpname, NULL);
					pos = MessageCBox( g_winData.hMainWnd, 
						  common_work, tmpname, (pos&0x1000)?
						  	MB_YESNOCANCEL:MB_OKCANCEL);
					if(pos == IDYES)
						Install2Reg(tmpname);
					else if(pos == IDNO || pos == IDOK)
						set_config(tmpname);
					else
						pos = -1;
					if( w.pDib != NULL ){
						ToDviDir();
						if(pos != -1)
							goto re_open;
					}
					return 0;

				case ID_INFO_KEY:
					DisplayKeyInfo();
					return 0;

				case ID_INFO_URL:
					DisplayURL();
					return 0;

				case ID_INFO_ANCHOR:
					DisplayAnchor(w.pDib);
					return 0;

				case ID_INFO_SRC:
					DisplaySRC(w.pDib);
					return 0;

				case ID_INFO_ETF:
					DisplayETF();
					return 0;

				case ID_INFO_INIT:
					size = GetAddMemory("initial.par", NULL, 0);
					if(size > 0){
						tmpname = marea(size+1);
						GetAddMemory("initial.par", tmpname, size);
						tmpname[size] = 0;
						error(C_MSG, "%s", tmpname);
						Free(tmpname);
						error(DATATITLE, "initial.par");
					}
					break;


				case ID_RESTOREKEY:
					RestoreBinary( key_table, MAX_KEYDEF, 
						"KeyTable", "Key", 0 );
					return 0;

				case ID_SAVEKEY:
					ReserveBinary( "KeyTable", "Key", key_table, MAX_KEYDEF );
					return 0;

				case ID_TIMER:
					f_timer = !f_timer;
					CheckMenu(ID_TIMER, f_timer);
					if(f_timer)
						SetTimer(g_winData.hMainWnd, 9, 500, (TIMERPROC)Timer9Proc);
					else
						KillTimer(g_winData.hMainWnd, 9);
					break;

				case ID_MACRO1:
				case ID_MACRO2:
				case ID_MACRO3:
				case ID_MACRO4:
				case ID_MACRO5:
					if(f_macro || key_macro == NULL)
						return 0;
					id_value -= ID_MACRO1;

							/* search id_value-th paramater */
					for(tmpname = key_macro; id_value-- > 0; ){
						if(*tmpname++ == '"'){
							while(*tmpname !=  '"'){
								if(!*tmpname++)
									return 0;
							}
							tmpname++;
						}else
							while((unsigned char)*tmpname > ' ')
								tmpname++;
						while((unsigned char)*tmpname <= ' '){
							if(!*tmpname++)
								return 0;
						}
					}

					if(*tmpname == '"'){
						tmpname++;
						pos = 1;
					}else
						pos = 0;
					while((unsigned char)*tmpname <= ' ' && *tmpname)
						tmpname++;
					for(size = 0; *tmpname; ){
						if(pos){
							if(*tmpname == '"')
								break;
						}else if((unsigned char)*tmpname <= ' ')
							break;
						common_work[size++] = *tmpname++;
					}
					common_work[size] = 0;
					DoMacro(common_work, 0);
					return 0;

				case ID_INITIALIZE:
					if( f_Expand )
						goto chk_re_open;
					return 0;

				case ID_BACKGROUND:
					if(b_presentation_mode){
						size = GetBackGround();
						if(pr_color != (COLORREF)size){
							pr_color = (COLORREF)size;
							pos = COLOR_APPWORKSPACE;
							SetSysColors(1, &pos, &pr_color);
						}
					}
					return 0;

				case ID_BREOPEN:
					if((id_value = GetUserKey(1)) != 0)
						goto wmcmd;

				case ID_REOPEN:
					ResetFile();
					if(!IS_MPAGE && (f_killstop = f_kill) == FALSE){
						stop_level = 0;
						CheckStop(1);
					}
					id_current_macro = 0;	// Re expand dviout specials

				case ID_REOPENMACRO:
re_open:			SetStartPage(GetCurrentPage());
new_open:			if(b_presentation_mode && f_background == 2){
						size = GetBackGround();
						if(pr_color != (COLORREF)size){
							pr_color = (COLORREF)size;
							pos = COLOR_APPWORKSPACE;
							SetSysColors(1, &pos, &pr_color);
						}
					}
					if(f_macro)
						SendMessage( g_winData.hMainWnd, WM_USER_FILE_OPEN, 
							0, 0 );
					else
						PostMessage( g_winData.hMainWnd, WM_USER_FILE_OPEN, 
							0, 0 );
					return 0;

#ifdef	USE_ETF
				case ID_ETF:
					if(w.pDib){
						pos = DialogBox( g_winData.hInstance, 
							MAKEINTRESOURCE(IDD_INITETF), hwnd, DlgInitETF);
						temp_page = GetCurrentPage();
						if(pos == IDC_ETFDEL)
							DeleteETF(0);
						else if(pos == IDC_ETFSTRIP)
							DeleteETF(1);
						else if(pos != IDOK || !MakeETF())
							return 0;
						SetStartPage(temp_page);
						goto new_open;
					}
					return 0;
#endif
				case ID_DVIPRT:
					f_startdviprt = TRUE;
				case ID_PRINT:
					if( w.pDib == NULL || b_presentation_mode)
					{	/*  w.pDib == NULL, i.e. \ĂȂȂ
					   bZ[W\Ĕ */
						ShowMessage("Not opened dvi file.", NULL, 
							SM_OKCONT);
						f_startdviprt = FALSE;
						return 0;
					}
					pos = f_hyper;
					f_hyper &= ~1;
					size = SetColor(0);
					SetColor(4);
					PrintBmp( w.pDib );
					f_startdviprt = FALSE;
					SetColor(size);
					f_hyper = pos;
					if(f_dstop){
						f_dstop = 0;
						goto show;
					}
					return 0;

				case ID_SEARCH:
#ifdef	DOUBLE_PAGE
					if(!f_2page)
#endif
					{
						if(g_winData.hWndFind != NULL)
							break;
						if(w.pDib == NULL){
							MessageNoFile();
							return 0;
						}
						g_winData.hWndFind = FindText(&fr);
					}
					return 0;
				
				case ID_PRECAND:
precand:			SetUpSearchFromCombo( &fr );
					if( w.pDib == NULL || !IsSetSearchStr() || szFind[0] == 0)
						break;
					if((href = Search2Href(fr.lpstrFindWhat)) != NULL)
						goto hpjp0;
					fr.Flags &= ~FR_DOWN;
sstr:				f_hist_msg = F_HM_SEARCH;
					SaveH_Hist(&w, 1);
					if(SearchStr(&w, &fr, 1))
						goto show;
					else
						goto notfound;

				case ID_NEXTCAND:
nextcand:			if( w.pDib == NULL)
						break;
					SetUpSearchFromCombo( &fr );
					if( w.pDib == NULL || !IsSetSearchStr() || szFind[0] == 0)
						break;
					if((href = Search2Href(fr.lpstrFindWhat)) != NULL)
						goto hpjp0;
					fr.Flags |= FR_DOWN; 
					goto sstr;

				case ID_QUIT:
					f_quit = 1;

				case ID_APPEXIT:
					if(b_presentation_mode){
						pos = COLOR_APPWORKSPACE;
						SetSysColors( 1, &pos, &wbk_color );
						f_quit = 1;
					}
					PostMessage( g_winData.hMainWnd, WM_DESTROY, 0, 0 );
					return 0;

				case ID_HYPERTEX:
					f_hypertex = !f_hypertex;
					CheckMenu(ID_HYPERTEX, f_hypertex);
					break;

				case ID_HYPER:
#ifdef	DOUBLE_PAGE
					if(f_2page)
						return 0;
#endif
					f_hyper ^= F_H_IGNORE;
					pos = !(f_hyper & F_H_IGNORE)?TRUE:FALSE;
					SendMessage( g_winData.hWndToolBar, TB_CHECKBUTTON,
						ID_HYPER, MAKELONG(pos,0) );
					EnableMenuItem( g_winData.hMenu, ID_HYPERTEX, 
						pos?MF_ENABLED:MF_GRAYED );
					EnableMenuItem( g_winData.hMenu, ID_SRCSPECIAL, 
						pos?MF_ENABLED:MF_GRAYED );
					if(w.pDib == NULL)
						break;
					if(!(f_hyper & F_H_IGNORE) && !IsHyperTag())
						ExpandPage();	// On HyperJump && not yet exapanded
					pDibNew = MakeBMP();
					goto renew;

				case ID_LOGOPEN:
					f_log = (f_log == TRUE)?FALSE:TRUE;
					CheckMenu(ID_LOGOPEN, f_log);
					break;

				case ID_HEADFOOT:
					if(!w.nVscrollPos)
						goto uppage;
					SendMessage( g_winData.hWnd, WM_VSCROLL,
						MAKEWPARAM( SB_PAGEUP, 0 ), (LPARAM)g_winData.hWnd );
					break;

				case ID_PAGEHEAD:						
page_head:			SendMessage( g_winData.hWnd, WM_VSCROLL,
					MAKEWPARAM( SB_TOP, 0 ), (LPARAM)g_winData.hWnd );
						break;

				case ID_FOOTHEAD:
					if(w.nVscrollMax <= w.nVscrollPos)
					goto downpage;
					SendMessage( g_winData.hWnd, WM_VSCROLL,
						MAKEWPARAM( SB_PAGEDOWN, 0 ), (LPARAM)g_winData.hWnd );
					break;

				case ID_PAGEFOOT:
page_foot:			SendMessage( g_winData.hWnd, WM_VSCROLL,
					MAKEWPARAM( SB_BOTTOM, 0 ), (LPARAM)g_winData.hWnd );
						break;

				case ID_LEFTHOME:
					if(w.pDib)
						 SendMessage( g_winData.hWnd, WM_USER_HSCROLL,
							-w.nHscrollPos, 0 );
					break;

				case ID_RIGHTHOME:
					if(w.pDib)
						 SendMessage( g_winData.hWnd, WM_USER_HSCROLL,
							w.nHscrollMax - w.nHscrollPos, 0 );
					break;

				case ID_LBIG:
					if(g_loupe.diam < 1000)
						g_loupe.diam += 50;
					break;

				case ID_LLITTLE:
					if(g_loupe.diam >= 60)
						g_loupe.diam -= 50;
					else
						g_loupe.diam = 10;
					break;

				case ID_LMAGNIFY:
					if(g_loupe.div > 1)
						g_loupe.div--;
					break;

				case ID_LREDUCE:
					if(g_loupe.div < 32)
						g_loupe.div++;
					break;

				case ID_LMEASURE:
					g_loupe.f_circle ^= F_LMEASURE;
					CheckMenu(ID_LMEASURE, g_loupe.f_circle & F_LMEASURE);
					break;

				case ID_RECTON:
					if(w.pDib){
						f_rectcut = !f_rectcut;
						if(f_rectcut){
							rectcut.top = rectcut.left = 0;
							rectcut.right = GetTextXSize();
							rectcut.bottom = GetTextYSize();
						}
						CheckMenu(ID_RECTON, f_rectcut);
						if(!b_presentation_mode)
							goto show;
						else if(g_winData.hWndPresenMenu)
							SendMessage( g_winData.hWndPresenMenu, WM_INITDIALOG, 0, 0 );
					}
					break;

				case ID_RECTCUT:
					if(w.pDib && RectCut(0)){
						if(rectcut_org == NULL)
							rectcut_org = MareaPara("y OX OY", 1);
						RectCut(1);
new_rec:				pDibNew = MakeBMP();
						rectcut.top = rectcut.left = 0;
						rectcut.right = GetTextXSize();
						rectcut.bottom = GetTextYSize();
						goto renew;
					}
					break;

				case ID_RECTREC:
					if(w.pDib && rectcut_org != NULL){
						rectcut_org = MareaPara(rectcut_org, -1);
						ExpandPage();
						goto new_rec;
					}
					break;

				case ID_LCURSOR:
					f_lcursor = f_lcursor?0:F_LCURSOR;
					CheckMenu(ID_LCURSOR, f_lcursor);
					break;

				case ID_ANIMECURSOR:
					f_animecursor = !f_animecursor;
					CheckMenu(ID_ANIMECURSOR, f_animecursor);
					break;

				case ID_FGRID:
					f_grid =!f_grid;
					CheckMenu(ID_FGRID, f_grid);
					goto new_exp;

				case ID_WGRID:
					DialogBox( g_winData.hInstance,
							MAKEINTRESOURCE(IDD_GRIDSCALEDIALOG),
							g_winData.hWnd, GlidScaleDlgProc );
new_exp:			if(w.pDib){
						ExpandPage();
						goto new_rec;
					}
					break;

				case ID_CSHOW:
					f_Wshow = !f_Wshow;
					CheckMenu(ID_CSHOW, f_Wshow);
					break;

				case ID_DIRECTSRC:
					f_directsrc = !f_directsrc;
					CheckMenu(ID_DIRECTSRC, f_directsrc);
					break;

				case ID_GEDIT:
					f_gedit = !f_gedit;
					CheckMenu(ID_GEDIT, f_gedit);
					break;

				case ID_CHKCOLOR:
					f_chkcolor = !f_chkcolor;
					CheckMenu(ID_CHKCOLOR, f_chkcolor);
					break;

				case ID_LANDSCAPE:
					tmpname = GetParaString("y");
					if(tmpname != NULL && *tmpname){
						strcpy(common_work, tmpname);
						tmpname = common_work + strlen(common_work)-1;
						if(*tmpname == 'L')
							*tmpname = 'P';
						else if(*tmpname == 'P')
							*tmpname = 'L';
set_y:					SetParaString("y", common_work);
						goto land;
					}else if(paper_type == SIZE_A4){
						tmpname = common_work + 2;
						sprintf(common_work, "A4%c", (f_rotate)?'P':'L');
						goto set_y;
					}
					break;
				
				case ID_PAPER_A3:
				case ID_PAPER_A4:
				case ID_PAPER_A5:
				case ID_PAPER_A6:
				case ID_PAPER_A7:
				case ID_PAPER_B3:
				case ID_PAPER_B4:
				case ID_PAPER_B5:
				case ID_PAPER_B6:
				case ID_PAPER_B3JPN:
				case ID_PAPER_B4JPN:
				case ID_PAPER_B5JPN:
				case ID_PAPER_B6JPN:
				case ID_PAPER_KIKU:
				case ID_PAPER_46:
				case ID_PAPER_NEWBOOK:
				case ID_PAPER_AB:
				case ID_PAPER_LETTER:
				case ID_PAPER_HALFLETTER:
				case ID_PAPER_GOVLETTER:
				case ID_PAPER_LEGAL:
				case ID_PAPER_GOVLEGAL:
				case ID_PAPER_EXECUTIVE:
				case ID_PAPER_POSTCARD:
				case ID_PAPER_SVGA:
				case ID_PAPER_XGA:
				case ID_PAPER_SXGA:
				case ID_PAPER_UVGA:
				case ID_PAPER_USERDEFINED:
				{
					BOOL portrait = TRUE;

					tmpname = GetParaString("y");
					if(tmpname != NULL && *tmpname){
						strcpy(common_work, tmpname);
						tmpname = common_work + strlen(common_work)-1;
						if(*tmpname == 'L')
							portrait = FALSE;
						else if(*tmpname == 'P')
							portrait = TRUE;
					}
					if(id_value != ID_PAPER_USERDEFINED){
						strcpy( common_work, 
							para_paper[id_value - ID_PAPER_A3] );
set_PL:					strcat( common_work, portrait?"P":"L" );
						SetParaString("y", common_work);
						goto chk_re_open;
					}else{
						DialogBox( g_winData.hInstance,
							MAKEINTRESOURCE(IDD_PAPERSIZEDIALOG),
							g_winData.hWnd, PaperSizeDlgProc );
						if(*common_work)
							goto set_PL;
					}
				}
				break;

				case ID_MHAND:
					if( f_HandMouse )
					{
						f_HandMouse = FALSE;
						g_loupe.f_circle &= ~F_LHAND;
						SendMessage( g_winData.hWndToolBar, TB_CHECKBUTTON,
								ID_MHAND, MAKELONG(FALSE,0) );
						SetCursor( g_winData.hNormalCursor );
						ReleaseCapture();
						f_Capturing = FALSE;
					}
					else if(w.nVscrollMax || w.nHscrollMax)
					{
						f_HandMouse = TRUE;
						g_loupe.f_circle |= F_LHAND;
						SendMessage( g_winData.hWndToolBar, TB_CHECKBUTTON,
								ID_MHAND, MAKELONG(TRUE,0) );
					}
					break;

				case ID_DVIOUTSPECIAL:
					f_dvioutspecial = !f_dvioutspecial;
					CheckMenu( ID_DVIOUTSPECIAL, f_dvioutspecial );
					break;

				case ID_SRCSPECIAL:
					f_srcspecial = !f_srcspecial;
					CheckMenu( ID_SRCSPECIAL, f_srcspecial );
					break;
#ifdef	USE_ETF
			    case ID_USEETF:
					f_use_etf = !f_use_etf;
					CheckMenu( ID_USEETF, f_use_etf );
					if(w.pDib){
						ClearFont();
						goto re_open;
					}
					break;
#endif					
				case ID_SAVEPRESENT:
					DisplayMessage("Save the settings");
					pos = f_pmenu << 4;
					if(!pmenu.top && !pmenu.left)
						pos |= 0x80;
					if(!f_presenmenu)
						pos |= 0x100;
					ReserveInt( "Settings", "Background", pos | f_background );
					pos = f_coverH;
					if(f_cover & 1)
						pos |= 0x1000;
					if(f_coverP)
						pos |= 0x2000;
					if(f_coverM)
						pos |= 0x4000;
					if(!f_dvioutspecial)
						pos |= 0x8000;
					if(!f_srcspecial)
						pos |= 0x10000;
#ifdef	USE_ETF
					if(!f_use_etf)
						pos |= 0x20000;
#endif
					if(!f_hypertex)
						pos |= 0x40000;
					pos |= f_coverB*0x100000;
					ReserveInt( "Settings", "CoverSheet", pos );
					sleep0(500);
					DisplayMessage(NULL);
					break;

				case ID_PRESENMENU:
					f_presenmenu = !f_presenmenu;
					CheckMenu(ID_PRESENMENU, f_presenmenu);
					break;

				case ID_PMLOC:
				{
					RECT pmenu2;

					if(pmenu.top || pmenu.left){
						MoveWindow(g_winData.hWndPresenMenu,
							0, 0,
							pmenu.right - pmenu.left,
							pmenu.bottom - pmenu.top,
							TRUE);
						break;
					}
pmloc:				GetWindowRect(g_winData.hWnd, &pmenu2);
					xx = pmenu.right - pmenu.left;
					yy = pmenu.bottom - pmenu.top;
					switch(f_pmenu){
						case 0:
							xx = xx*53/93;
							yy = yy*41/44;
							break;
						case 1:
							xx = xx*55/93;
							yy = yy*181/185;
							break;
						case 2:
							xx = xx*55/93;
							yy = yy*288/292;
							break;
					}
					MoveWindow(g_winData.hWndPresenMenu,
							pmenupt.x = pmenu2.right - xx,
							pmenupt.y = pmenu2.bottom - yy,
							pmenu.right - pmenu.left,
							pmenu.bottom - pmenu.top, TRUE);
					ShowWindow(g_winData.hWndPresenMenu, SW_SHOW );
					if(!f_ShowCursor){
						ActivateCursor();
						CheckCursor();
					}
					break;
				}

				case ID_SHAPE:
				{
					RECT pmenu2;

					if(g_winData.hWndPresenMenu){
						SendMessage( g_winData.hWndPresenMenu, WM_COMMAND, IDCANCEL, 0 );
						f_pmenu++;
						if( pmenu.left != 0
						 && pmenupt.x == pmenu.left && pmenupt.y == pmenu.top)
						 	f_pmenu |= 8;
					}
					switch(f_pmenu & 3){
						case 0:
						case 3:
							xx = IDD_PRESEN2;
							f_pmenu &= ~3;
							break;
						case 1:
							xx = IDD_PRESEN1;
							break;
						case 2:
							xx = IDD_PRESEN;
							break;
					}
					g_winData.hWndPresenMenu =
						CreateDialog(g_winData.hInstance,
							MAKEINTRESOURCE(xx),
							g_winData.hWnd, DlgPresenProc);
					f_pmshow = TRUE;
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu2);
					MoveWindow(g_winData.hWndPresenMenu,
						pmenu.left, pmenu.top,
						pmenu2.right - pmenu2.left + 1 ,
						pmenu2.bottom - pmenu2.top + 1,
						FALSE);
					GetWindowRect(g_winData.hWndPresenMenu, &pmenu);
					if(f_pmenu & 8){
						f_pmenu &= 3;
						goto pmloc;
					}
					ShowWindow(g_winData.hWndPresenMenu, SW_SHOW );
					if(!f_ShowCursor){
						ActivateCursor();
						CheckCursor();
					}
					break;
				}

				case ID_RELATEDVI:
					RelateDVI();
					break;

				case ID_SETSTARTMENU:
					SetStartMenu();
					break;

				case ID_PRESENTOFF:
					if(b_presentation_mode)
						goto pr_off;
					break;

				case ID_PRESENTON:
					if( b_presentation_mode )
						break;

				case ID_PRESENTATION:
				{
					static BOOL view_StatusBar, view_pageSlider, 
							  view_ToolBar, view_ScrollBar, 
							  org_rectcut, keep_rectcut, f_keep_rect;
					static WINDOWPLACEMENT wpl;
					static int old_loupe;
					static int old_gamma;
					static int old_cmode;
					static int old_OX;
					static int old_OY;
					static BOOL old_f_Pen;
					static save_normal_states = FALSE;
					char c;

					f_killstop = f_kill;
					if( b_presentation_mode )
					{
pr_off:					if(g_winData.hWndPresenMenu)
							SendMessage( g_winData.hWndPresenMenu, WM_COMMAND, IDCANCEL, 0 );
			 			SetForegroundWindow( g_winData.hMainWnd );
						CheckMenu(ID_STATUS_VIEW, 
							g_view.f_StatusBar = view_StatusBar);
						CheckMenu(ID_TOOLBAR_VIEW, 
							g_view.f_ToolBar = view_ToolBar);
						CheckMenu(ID_SCROLLBAR_VIEW, 
							g_view.f_ScrollBar = view_ScrollBar);
						CheckMenu(ID_SLIDER_VIEW, 
							g_view.f_PageSlider = view_pageSlider);
						keep_rectcut = f_rectcut;
//						CheckMenu(ID_RECTCUT, f_rectcut = org_rectcut);
						f_keep_rect = TRUE;
						pos = COLOR_APPWORKSPACE;
						SetSysColors( 1, &pos, &wbk_color );

						SetWindowLong( g_winData.hMainWnd, GWL_STYLE, wl );
						SetWindowLong( g_winData.hWnd, GWL_EXSTYLE, wlc );
						SetMenu( g_winData.hMainWnd, g_winData.hMenu );
						KillTimer8();
						ShowWindow( g_winData.hMainWnd, SW_SHOW );
						SetWindowPlacement( g_winData.hMainWnd, &wpl );
						ShowHyperLink( NULL );
						f_FIT = 0;
						bShowingHref = b_presentation_mode = FALSE;

						save_normal_states = FALSE;
						g_loupe.f_circle = old_loupe;
						f_HandMouse = (ArrangeScroll(&w,0) && 
							(g_loupe.f_circle & F_LHAND))?FALSE:TRUE;
				 		SendMessage( g_winData.hMainWnd, WM_COMMAND, ID_MHAND, 0 );
						SetClassLong( g_winData.hWnd, GCL_HCURSOR, (LONG)g_winData.hNormalCursor );
						ActivateCursor();

						InitLoupeWindow();
						if(old_OX != OX || old_OY != old_OY){
							ReSetMetric();
							goto set_re_open;
						}
						f_Pen = old_f_Pen;
						if(  old_e != GetParaInt("e")		// changed size
							|| old_varf != GetParaFlag("varf")
							|| old_XGray != GetXGray()
							|| old_YGray != GetYGray()
							|| old_gamma != SetGamma(0)
							|| old_cmode != GetParaInt("cmode")
							|| strcmp(old_y, GetParaString("y")) )
						{
set_re_open:				SetParaInt("e", old_e);
							SetParaFlag("varf", old_varf);
							SetXYGray(old_XGray, old_YGray);
							c = old_y[max(1,strlen(old_y))-1];
							if( c != 'p' && c != 'P' && c != 'l' && c != 'L' )
								strcat(old_y,"P");
							SetParaString("y", old_y);
							SetGamma(old_gamma);
							SetParaInt("cmode", old_cmode);
							OX = old_OX;
							OY = old_OY;
							CheckView(-1);
							goto chk_re_open;
						}
					} // end of if( b_presen... )
					else
					{
						SetForegroundWindow( g_winData.hMainWnd );
						view_StatusBar = g_view.f_StatusBar;
						view_pageSlider = g_view.f_PageSlider;
						view_ToolBar = g_view.f_ToolBar;
						view_ScrollBar = g_view.f_ScrollBar;
						g_view.f_StatusBar = g_view.f_PageSlider
							= g_view.f_ToolBar = g_view.f_ScrollBar = FALSE;
						if( !save_normal_states ){
							old_e = GetParaInt("e");
							old_varf = GetParaFlag("varf");
							if(GetParaString("y") != NULL)
								strncpy(old_y, GetParaString("y"), 0x20);
							else
								strcpy(old_y, "A4P");
							old_XGray = GetXGray();
							old_YGray = GetYGray();
							old_loupe = g_loupe.f_circle;
							old_gamma = SetGamma(0);
							old_cmode = GetParaInt("cmode");
							org_rectcut = f_rectcut;
							old_OX = OX;
							old_OY = OY;
							old_f_Pen = f_Pen;
							save_normal_states = TRUE;
						}
						if(f_keep_rect)
							f_Pen = f_rectcut = keep_rectcut;
						else
							f_Pen = FALSE;
if(!f_2page)
							SetColor(8);
						if(old_cmode == 0)
							SetParaInt("cmode", 3);
						ShowHyperLink( NULL );
						bShowingHref = FALSE;
						wbk_color = GetSysColor( COLOR_APPWORKSPACE );
						if(f_background & 1)
						{		 			// black
							if(f_background == 1)		// default
								g_loupe.f_circle = 
									(g_loupe.f_circle & ~F_LCOLOR)|F_LBLACK;
							size = 0;
						}
						else if(f_background == 2)
						{ 					// default color
							g_loupe.f_circle &= ~F_LCOLOR;
							size = GetBackGround();
							if(size != 0xffffff)
								g_loupe.f_circle = 
									(g_loupe.f_circle & ~F_LCOLOR)|F_LBLACK;
						}
						else
						{					// white
							if(f_background == 0)		// white
								g_loupe.f_circle &= ~F_LCOLOR;
							size = 0xffffff;
						}
						pos = COLOR_APPWORKSPACE;
						SetSysColors(1, &pos, &size);

						wl = GetWindowLong(g_winData.hMainWnd, GWL_STYLE);
						wlc = GetWindowLong(g_winData.hWnd, GWL_EXSTYLE);
						wpl.length = sizeof(WINDOWPLACEMENT);
						GetWindowPlacement( g_winData.hMainWnd, &wpl );
						SetMenu( g_winData.hMainWnd, NULL );
						SetWindowLong( g_winData.hMainWnd, GWL_STYLE, 
							wl & ~WS_OVERLAPPEDWINDOW );
						SetWindowLong( g_winData.hWnd, GWL_EXSTYLE, 
							wlc & ~WS_EX_CLIENTEDGE );
						ShowWindow( g_winData.hMainWnd, SW_NORMAL );
						ShowWindow( g_winData.hMainWnd, SW_MAXIMIZE );
						b_presentation_mode = TRUE;
						InitLoupeWindow();
						KillCursor();
						SetClassLong( g_winData.hWnd, GCL_HCURSOR, 
							(g_loupe.f_circle&F_LHAND)?(LONG)g_winData.hLaserHand:(LONG)g_winData.hLaserPointer );

						if(f_cover == 1)
						{
							if(w.pDib) KeepCover();
							if(!f_HandMouse)
							{
								f_HandMouse = TRUE;
								g_loupe.f_circle |= F_LHAND;
								SendMessage( g_winData.hWndToolBar, 
									TB_CHECKBUTTON, ID_MHAND, MAKELONG(TRUE,0));
							}
							if(!f_2page && f_coverP
								&& !cover_xpos && !cover_ypos )
							{
								if(GetPause(&xx, &yy, 1) >= 0)
									MoveCover(xx, yy, 1);
								else
									f_CheckCover = TRUE;
							}
						}
						if(f_presenmenu && g_winData.hWndPresenMenu == NULL)
							PostMessage( g_winData.hMainWnd, WM_COMMAND, ID_SHAPE, 0 );
			   			if(f_background == 0)
						{
							if(SetGamma(0) < 0)
								goto to_reverse;
						}
						else if(f_background == 1 && SetGamma(0) > 0)
							goto to_reverse;
						if(w.pDib) goto show;
					} // end of if(b_presentation_mode)
					break;
				} // end of case ID_PRESENTATION:

				case ID_AUTO_SAVE_IMAGE:
					if( !autosavebmp.f_autosavebmp )
					{
						if( DialogBox(g_winData.hInstance, MAKEINTRESOURCE(IDD_AUTOSAVE_IMG),
							g_winData.hWnd, AutoSaveDlgProc) == IDOK )
						{
							CheckMenu( ID_AUTO_SAVE_IMAGE, TRUE );
							autosavebmp.f_autosavebmp = TRUE;
						}
					}
					else
					{
						CheckMenu( ID_AUTO_SAVE_IMAGE, FALSE );
						autosavebmp.f_autosavebmp = FALSE;
					}
					break;	
			} // end of WM_COMMAND
			return 0;

		case WM_USER_EXECMACRO:
			if( timer_id == id_page ){
				timer_id = 0;
				if(waiting_macro[0]){
					size = strlen(waiting_macro);
					DoMacro(waiting_macro, waiting_macro_mode);
					if(  size != strlen(waiting_macro)	// multiple ;
					  || waiting_macro_mode != 1)		// not dviout special
						break;
					waiting_macro[0] = 0;
				}
				ExecMacro(1);
			}else
				waiting_macro[0] = 0;
			break;

		case WM_DROPFILES:		/* Drag-Drop */
			DragQueryFile((HDROP)wParam, 0, fname, sizeof(fname));
			if((size = strlen(fname)) > 4 && 
			  !stricmp(fname + size - 4, ".lnk"))
				ChangeLinkToReal(fname);
			size = strlen(fname);
			if( size < 4
				|| (strcmpi(fname + size - 4, ".dvi") != 0
				   && strcmpi(fname + size - 4, ".tar") != 0)
	//			|| !DragQueryPoint((HDROP)wParam, &pt)		/* My Window? */
			) return 0;
			DefineDVIFileName( fname );
			DragFinish((HDROP)wParam);
			SetColor(4);

opendvi1:	if(!strstr(g_szFileName, ".dvi#")){
				f_killstop = f_kill;
				stop_level = 0;
			}

		case WM_USER_FILE_OPEN: /* g_szFileName Ɏw肳ꂽ̧قJ */
			/*  w.pDib != NULL <=> \ ȂC */
opendvi:	if( w.pDib != NULL )
			{
				FreeBmp( w.pDib );
				w.pDib = NULL;
			}
			CheckPenBuf();
			/* ̧قǂݍ݁ADIB`ɓWJ */
			if( (tmpname = strstr(g_szFileName, ".dvi#")) != NULL){
				pos = 0;
				if(tmpname[5] == ' ' && (pos = atoi(tmpname+6)) > 0){
					size = 5;
					while(tmpname[++size] >= '0' && tmpname[size] <= '9');
					while(tmpname[size] == ' ')
						size++;
					if(tmpname[size] != 0)		// source special
						pos = 0;
				}
				if(pos)
					SetStartPage(pos);
				else
					SetHyperTag(tmpname + 4);
				tmpname[4] = 0;
			}
			pos = f_renew;
			f_renew = 0;
            SetForegroundWindow( g_winData.hMainWnd );
			f_renew = pos;
			CheckStop(2);
reopendvi:	ChangeWaitCursor(1);
			{
				if( (w.pDib = ReadDIB( g_szFileName )) == NULL
			 	&&	 g_szFileName2[0] != 0
			 	&& (w.pDib = ReadDIB( g_szFileName2 )) != NULL )
					strcpy(g_szFileName, GetOpenName());
				else
					g_szFileName2[0] = 0;
				ChangeWaitCursor(0);
			}
			if( w.pDib == NULL )
			{
				if(pDibKeep){
					FreeBmp(pDibKeep);
					pDibKeep = NULL;
				}
				if(f_error)
					goto chkerr;
				strncpy(fname, g_szFileName, MAX_PATH);
				size = strlen(fname);
				if(size > 4 && strcmp(fname + size - 4, ".dvi") == 0)
					fname[size-4] = 0;
				size = strlen(fname);
				if(size && fname[size - 1] == '\\')
					fname[--size] = 0;
				pos = GetFileAttributes(fname);
				if(pos != 0xffffffff && (pos & FILE_ATTRIBUTE_DIRECTORY)){
					g_szFileName[0] = 0;
					if ((pos = QueryFileName(fname))!= 0)
						goto reopendvi;
				}
				if(pos)
chkerr:				CheckError();
				EnableButton( FALSE );
				if( g_szFileName[0] ){
					SetStartPage(PrevPage);
					return SendMessage( g_winData.hMainWnd, WM_USER_FILE_OPEN, 0, 0 );
				}
				return 0;
			}
			EnableButton( TRUE );
			SaveH_Hist(&w, 0);
			if((f_hyper & F_H_DVIOPEN) && hypertag != NULL){
				href = hypertag;
				if(pDibKeep){
					FreeBmp(pDibKeep);
					pDibKeep = NULL;
				}
				goto do_href;
			}
#ifdef	DOUBLE_PAGE
			if(IS_2PAGE)
				Get2Bmp();
#endif
			/* ۰͈ٔ͂𒲐 */
			f_h_renew = FALSE;
show:		if(!ArrangeScroll(&w, 0) &&
			   (!b_presentation_mode || f_cover != 1 || f_2page)){
				if(f_HandMouse){
					f_HandMouse = FALSE;
					SetCursor( g_winData.hNormalCursor );
				}
			}
			else if(g_loupe.f_circle & F_LHAND)
				f_HandMouse = TRUE;
			if(	f_h_renew == TRUE ){
				Cursor2BufPoint2Center(&w, pt.x, pt.y);
				AnimationPointer( &w, g_winData.hWnd, g_winData.hInstance, 
					pt.x, pt.y, FALSE );
			}
			SetPageMoveButtons( &w );
			SendMessage( g_winData.hWndToolBar, TB_CHECKBUTTON, ID_MHAND, 
				MAKELONG((g_loupe.f_circle & F_LHAND)?TRUE:FALSE,0) );
			if( f_Capturing ){
				ReleaseCapture();
				f_Capturing = FALSE;
			}
			if(f_CheckCover){
				if(b_presentation_mode && !f_2page && f_coverP){
					if(!GetPause(&xx, &yy, 2)){			// No special pause
						cover_xpos = GetTextXSize();
						cover_ypos = GetTextYSize();
					}else if(GetPause(&xx, &yy, 0) == 0){	// Initial use
						GetPause(&xx, &yy, 1);
						MoveCover(xx, yy, 1);
					}
				}
				f_CheckCover = FALSE;
			}
			temp_page = IsHyperTag();
#ifdef	DOUBLE_PAGE
			if(!(IS_2PAGE) || !pDib2 )
#endif
			{
				if(temp_page > 0)
					ShowBox(w.pDib, h_box + temp_page + 1, h_box[temp_page].y0,
						f_h_color);
			}
#if	HYPER_2VERT
			else if(IS_2VERT && b_presentation_mode){
				if(temp_page > 0)
					ShowBox(pDib2, h_box + temp_page + 1, h_box[temp_page].y0, f_h_color);
				pos = GetCurrentPage();
				ChgPage(pos - (IsSecondPage(pos)?1:(-1)));
				if(pos != GetCurrentPage() && (temp_page = IsHyperTag()) > 0)
					ShowBox(w.pDib, h_box + temp_page + 1, h_box[temp_page].y0, f_h_color);
				ChgPage(pos);
			}
#endif
			if(ChangeToolBar(-1)){
				if(!GetUserKey(3))
					SendMessage(g_winData.hWndToolBar, TB_ENABLEBUTTON, 
						ID_BNEXTHIST, (h_hist_pt != h_hist_n));
				if(!GetUserKey(5))
					SendMessage(g_winData.hWndToolBar, TB_ENABLEBUTTON, 
						ID_BGOMARK, (h_hist[PAGE_MARK].id == id_dvi));
			}
			/* NCAg̈𖳌 <=> WM_PAINT 𑗂 */
			if(!f_StopPaint){
				if(pDibKeep){
					RECT rcc;
					JoinBoundigBox(&rcStop, &StopG0Rec);
					if(rcStop.left < rcStop.right){
						rcStop.left  /= (xx = GetXGray());
						rcStop.right = (rcStop.right+xx-1)/xx;
						rcStop.top   /= (yy = GetYGray());
						rcStop.bottom = (rcStop.bottom+yy-1)/yy;
					}
					xx = CompBMP(w.pDib, pDibKeep, &rcc);
					FreeBmp(pDibKeep);
					pDibKeep = NULL;
					if(xx >= 0){
						JoinBoundigBox(&rcc, &rcStop);
						rcc.left  += g_nxIndent- w.nHscrollPos;
						if(rcc.left < 0)
							rcc.left = 0;
						rcc.right += g_nxIndent- w.nHscrollPos;
						if(rcc.right < 0) 
							rcc.right = 0;
						rcc.top   += g_nyIndent- w.nVscrollPos;
						if(rcc.top < 0)
							rcc.top = 0;
						rcc.bottom += g_nyIndent- w.nVscrollPos;
						if(rcc.bottom < 0)
							rcc.bottom = 0;
						InvalidateRect( g_winData.hWnd, &rcc, FALSE );

					}else
						goto Invalid;
				}else
Invalid:			InvalidateRect( g_winData.hWnd, inval, TRUE );
				inval = NULL; 
				UpdateWindow( g_winData.hWnd );
				AnimationPointer( &w, g_winData.hWnd, g_winData.hInstance, 
					0, 0,TRUE );
			}
			{
				/* Xe[^Xo[̕\ */
				char szText[300];
				wsprintf( szText, "%s(%d/%d) - %s", 
					current_name,
					GetCurrentPage(),
					GetTotalPage(),
					g_winData.szWindowTitle );
				SetWindowText( g_winData.hMainWnd, szText );
				SetSpinRange( 1, GetTotalPage(), GetCurrentPage() );
				if( h_hist[RANGE_MARK].id == id_dvi )
					SetMarkRange( h_hist[PAGE_MARK].page,
						h_hist[RANGE_MARK].page);
				else
					SetMarkRange(0,0);
				SetPageView( SetStatusWindow() );
				UpdateWindow( g_winData.hWndPageSpin );
			}
			AutoSaveBmp();
			return 0;

		case WM_PAINT:
			SendMessage( g_winData.hWndFindCombo, CB_SHOWDROPDOWN, FALSE, 0 );
			ViewBmpFile( w.pDib, w.nHscrollPos, w.nVscrollPos );
			return 0;
		
		case 0x0319: // Intelli Mouse Explorer.
//			if( wParam != 0xC40 ) break;
//			error( WARNING, "%x", lParam );
			if( lParam == 0x80010000 )
				SendMessage( g_winData.hWnd, WM_COMMAND, 
					MAKEWPARAM(ID_FORMERHIST,0), 0L );
			else if( lParam == 0x80020000 )
				SendMessage( g_winData.hWnd, WM_COMMAND, 
					MAKEWPARAM(ID_NEXTHIST,0), 0L );
			else return 0;
			return 0;
	}
	return DefWindowProc( hwnd, message, wParam, lParam );
}

void SetPageView( int currentpage )
{
	char temp[17];

	if(GetTotalPage()){
		SetDlgItemInt( g_winData.hWndToolBar, ID_PAGEEDIT, 
			currentpage, FALSE );
		wsprintf( temp, "(%d)", TransPage( currentpage) );
		SetWindowText( g_winData.hWndNombreStatic, temp );
	}
}

void SetUpSearchFromCombo( LPFINDREPLACE fr )
{
	char szTemp[MAX_FIND_LEN+1];
	HWND hwnd;
	
	/* This function setup a string to search buffer from combo box.
	   For this, if edit box in combobox doesn't have a keyboard focus
	   this function need to be nothing, else we remove it
	   from combobox and set it to DVI window. One more we have to do is
	   to remove list box if it was shown.
	   I believe that drop down list box is shown only if edit box 
	   or the combo box has keyboard focus.
	   If my think is a lie, please tell me. */
	hwnd = GetFocus();
	if( hwnd == g_winData.hWndEditInCombo
	 || hwnd == g_winData.hWndFindCombo )
	{
		SetFocus( g_winData.hWnd );
	}
	szTemp[0] = 0;
	SendMessage( g_winData.hWndFindCombo, CB_SHOWDROPDOWN, FALSE, 0 );
	/* the following will be proceeded when edit box in combo box will have
	   had keyboard focus. Only we have to do is to copy the string at
	   edit box in combo box to our buffer to finding string. */
	GetWindowText( g_winData.hWndFindCombo, szTemp, MAX_FIND_LEN );
	if(szTemp[0])
		strcpy( szFind, szTemp );
	SetSearchStr( szFind );
	AddStringToCombo( szFind );
	SetStringToCombo( szFind );
}

static int IsMouseInDVIWindow( struct DVIINFO w, POINT* pt )
{
	int flag;

	/* We check wheter mouse cursor is in Client area of DvI window or not.
	And return the point of client coordinates in pt. */
	GetCursorPos( pt );
	flag = (g_winData.hWnd == WindowFromPoint(*pt))?1:0;
	ScreenToClient( g_winData.hWnd, pt );
	if( 0 <= pt->y && pt->y <= w.cyClient
	 && 0 <= pt->x && pt->x <= w.cxClient )
		flag |= 2;
	return flag;
}

static void SetPageMoveButtons( struct DVIINFO* w )
{
	HWND hwnd = g_winData.hWndToolBar;
	
	WPARAM top = f_rev_movebutton?ID_LASTPAGE:ID_TOPPAGE;
	WPARAM last = f_rev_movebutton?ID_TOPPAGE:ID_LASTPAGE;
	WPARAM prev = f_rev_movebutton?ID_NEXTPAGE:ID_PREVPAGE;
	WPARAM next = f_rev_movebutton?ID_PREVPAGE:ID_NEXTPAGE;

	if( w->pDib == NULL || GetTotalPage() == 1 )
	{
		SendMessage( hwnd, TB_ENABLEBUTTON, top, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, prev, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, next, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, last, MAKELONG(FALSE,0) );
		EnableMenuItem( g_winData.hMenu, ID_TOPPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_PREVPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_UPPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_NEXTPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_DOWNPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_LASTPAGE, MF_GRAYED );
		return;
	}
	SendMessage( hwnd, TB_ENABLEBUTTON, top, MAKELONG(TRUE,0) );
	SendMessage( hwnd, TB_ENABLEBUTTON, prev, MAKELONG(TRUE,0) );
	SendMessage( hwnd, TB_ENABLEBUTTON, next, MAKELONG(TRUE,0) );
	SendMessage( hwnd, TB_ENABLEBUTTON, last, MAKELONG(TRUE,0) );
	EnableMenuItem( g_winData.hMenu, ID_TOPPAGE, MF_ENABLED );
	EnableMenuItem( g_winData.hMenu, ID_PREVPAGE, MF_ENABLED );
	EnableMenuItem( g_winData.hMenu, ID_UPPAGE, MF_ENABLED );
	EnableMenuItem( g_winData.hMenu, ID_NEXTPAGE, MF_ENABLED );
	EnableMenuItem( g_winData.hMenu, ID_DOWNPAGE, MF_ENABLED );
	EnableMenuItem( g_winData.hMenu, ID_LASTPAGE, MF_ENABLED );
	/* assume GetTotalPage() > 1 */
	if( GetCurrentPage() == 1 )
	{
		SendMessage( hwnd, TB_ENABLEBUTTON, top, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, prev, MAKELONG(FALSE,0) );
		EnableMenuItem( g_winData.hMenu, ID_TOPPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_PREVPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_UPPAGE, MF_GRAYED );
	}
	if( GetCurrentPage() == GetTotalPage() )
	{
		SendMessage( hwnd, TB_ENABLEBUTTON, next, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, last, MAKELONG(FALSE,0) );
		EnableMenuItem( g_winData.hMenu, ID_NEXTPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_DOWNPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_LASTPAGE, MF_GRAYED );
	}
	if( f_2page & F_MPAGE ) // 4 or 16 pages
	{
		SendMessage( hwnd, TB_ENABLEBUTTON, top, MAKELONG(FALSE,0) );
		SendMessage( hwnd, TB_ENABLEBUTTON, last, MAKELONG(FALSE,0) );
		EnableMenuItem( g_winData.hMenu, ID_TOPPAGE, MF_GRAYED );
		EnableMenuItem( g_winData.hMenu, ID_LASTPAGE, MF_GRAYED );
	}
}

void InitMenuItems( void )
{
	int item_id, i;
	char* tmpname;
	HMENU hmenu;
	
	tmpname = GetParaString("y");
	hmenu = GetSubMenu(g_winData.hMenu, 6);
	CheckMenuItem(hmenu, 0, MF_BYPOSITION|MFS_UNCHECKED);
	CheckMenuItem(hmenu, 1, MF_BYPOSITION|MFS_UNCHECKED);
	CheckMenuItem(hmenu, 2, MF_BYPOSITION|MFS_UNCHECKED);
	CheckMenuItem(hmenu, 7, MF_BYPOSITION|MFS_UNCHECKED);

	if(tmpname != NULL && *tmpname){
		switch( toupper(*tmpname) )
		{
			case 'A':
				switch( tmpname[1] )
				{
					case '3':
						item_id = ID_PAPER_A3;
						break;
					case '4':
						item_id = ID_PAPER_A4;
						break;
					case '5':
						item_id = ID_PAPER_A5;
						break;
					case '6':
						item_id = ID_PAPER_A6;
						break;
					case '7':
						item_id = ID_PAPER_A7;
						break;
				}
				break;
			case 'E':
				switch( tmpname[1] )
				{
					case '3':
						item_id = ID_PAPER_B3;
						break;
					case '4':
						item_id = ID_PAPER_B4;
						break;
					case '5':
						item_id = ID_PAPER_B5;
						break;
					case '6':
						item_id = ID_PAPER_B6;
						break;
					case 'x':
						item_id = ID_PAPER_EXECUTIVE;
						break;
				}
				break;
			case 'B':
				switch( tmpname[1] )
				{
					case '3':
						item_id = ID_PAPER_B3JPN;
						break;
					case '4':
						item_id = ID_PAPER_B4JPN;
						break;
					case '5':
						item_id = ID_PAPER_B5JPN;
						break;
					case '6':
						item_id = ID_PAPER_B6JPN;
						break;
				}
				break;
			case 'J':
				switch( tmpname[1] )
				{
					case '1':
						item_id = ID_PAPER_KIKU;
						break;
					case '2':
						item_id = ID_PAPER_46;
						break;
					case '3':
						item_id = ID_PAPER_NEWBOOK;
						break;
					case '4':
						item_id = ID_PAPER_AB;
						break;
				}
				break;
			case 'L':
				switch( tmpname[2] )
				{
					case 't':
						item_id = ID_PAPER_LETTER;
						break;
					case 'g':
						item_id = ID_PAPER_LEGAL;
						break;
				}
				break;
			case 'G':
				switch( tmpname[5] )
				{
					case 't':
						item_id = ID_PAPER_GOVLETTER;
						break;
					case 'g':
						item_id = ID_PAPER_GOVLEGAL;
						break;
				}
				break;
			case 'H':
				if( tmpname[1] == 'a' )
					item_id = ID_PAPER_HALFLETTER;
				else
					item_id = ID_PAPER_POSTCARD;
				break;
			case 'S':
				item_id = (tmpname[1] == 'V')?
						ID_PAPER_SVGA:ID_PAPER_SXGA;
				break;
			case 'X':
				item_id = ID_PAPER_XGA;
				break;
			case 'U':
				item_id = ID_PAPER_UVGA;
				break;
			case 'F':
				item_id = ID_PAPER_USERDEFINED;
				break;
		}	
		tmpname += strlen(tmpname)-1;
		CheckMenu( ID_LANDSCAPE, (*tmpname == 'L')?TRUE:FALSE );
	}
	else{
		item_id = ID_PAPER_A4;
		CheckMenu(ID_LANDSCAPE, FALSE);
	}
	if(item_id >= ID_PAPER_A3 && item_id <= ID_PAPER_B6JPN){
		if(item_id <= ID_PAPER_A7)
			CheckMenuItem(hmenu, 0, MF_BYPOSITION|MFS_CHECKED);
		else if(item_id <= ID_PAPER_B6)
			CheckMenuItem(hmenu, 1, MF_BYPOSITION|MFS_CHECKED);
		else
			CheckMenuItem(hmenu, 2, MF_BYPOSITION|MFS_CHECKED);
	}else{
		switch(item_id){
			case ID_PAPER_46:
			case ID_PAPER_KIKU:
			case ID_PAPER_NEWBOOK:
			case ID_PAPER_AB:
			case ID_PAPER_HALFLETTER:
			case ID_PAPER_GOVLEGAL:
			case ID_PAPER_GOVLETTER:
			case ID_PAPER_SVGA:
			case ID_PAPER_XGA:
			case ID_PAPER_SXGA:
			case ID_PAPER_UVGA:
  				CheckMenuItem(hmenu, 7, MF_BYPOSITION|MFS_CHECKED);
		}
	}
	for(i = ID_PAPER_A3; i <= ID_PAPER_USERDEFINED ; i++)
		CheckMenu(i, 0);
	CheckMenuSet(item_id, item_id, item_id);
}

void AutoSaveBmp( void )
{
	static BOOL f_twice = FALSE;
	char save_filename[MAX_PATH];
	FILE* fp;
	int i, j, k;
	int col = 0;

	if( !autosavebmp.f_autosavebmp || w.pDib == NULL ) return;
	if( autosavebmp.f_bmp == 1 && f_twice )
	{
		f_twice = FALSE;
		return;
	}

	j = 0;
	for( i = 0; autosavebmp.sz_template[i] != '\0'; i++ )
	{
		if( j == MAX_PATH - 6 ) break;
		if( autosavebmp.sz_template[i] != '^' )
		{
			save_filename[j++] = autosavebmp.sz_template[i];
			continue;
		}
		else
		{
			col = 0;
expand_macro:
			if( '0' <= autosavebmp.sz_template[++i] && autosavebmp.sz_template[i] <= '9' )
			{
				col = autosavebmp.sz_template[i] - '1' + 1;
				goto expand_macro;
			}
			else
			{
				switch( autosavebmp.sz_template[i] )
				{
					case 'd':
						if( col == 0 )
						{
							char temp[10];
							wsprintf( temp, "%lu", GetCurrentPage() );
							for( k = 0; temp[k] != '\0'; k++ )
							{
								save_filename[j++] = temp[k];
								if( j == MAX_PATH - 6 ) break;
							}
						}
						else
						{
							char exp_str[6];
							char temp[10];
							wsprintf( exp_str, "%%0%dlu", col );
							wsprintf( temp, exp_str, GetCurrentPage() );
							for( k = 0; temp[k] != '\0'; k++ )
							{
								save_filename[j++] = temp[k];
								if( j == MAX_PATH - 6 ) break;
							}
						}
						break;
					case 'f':
						for( k = 0; current_name_pt[k] != '\0'; k++ )
						{
							save_filename[j++] = current_name_pt[k];
							if( j == MAX_PATH - 6 ) break;
						}
						j -= 4;
						break;
				} // end '^f' or '^d'
			} // end '^'
		} // end replace
	} // end
	save_filename[j] = '\0';
	ToDviDir();
	switch( autosavebmp.f_bmp )
	{
		case 0: // BMP
			strcat( save_filename, ".bmp" );
			fp = fopenf( save_filename, "wb");
			if( fp == NULL ) return;
			fwrite( (char*)w.pDib - sizeof(BITMAPFILEHEADER),
				((BITMAPFILEHEADER *)
					((char*)w.pDib-sizeof(BITMAPFILEHEADER)))->bfSize, 1, fp);
			fclose(fp);
			break;
		case 1:	// EMF
			strcat( save_filename, ".emf" );
			f_twice = TRUE;
			Page2EMF( save_filename );
	 		SendMessage( g_winData.hMainWnd, WM_COMMAND, ID_REOPEN, 0 );
			break;
		case 2: // BMC
			strcat( save_filename, ".bmc");
			bmp2bmc(save_filename,
				(unsigned char*)w.pDib - sizeof(BITMAPFILEHEADER),
				((BITMAPFILEHEADER *)((char*)w.pDib-sizeof(BITMAPFILEHEADER)))->bfSize);
			break;
		default:
			break;
	}
	return;
}

void AnimationPointer( struct DVIINFO *w, HWND hWndParent, HINSTANCE
		hInst, int x, int y, BOOL fDraw )
{
	char anim[] = "AnimPoint";
	UINT anim_wnd_id = 40000;

	WNDCLASSEX wc;
	HWND hwnd;
	static POINT pt;
	HDC hdc;
	int center = 15;
	int i;
	HBRUSH hBrush, hOldBrush;

	if( !fDraw && f_animecursor){
		Buf2WinPoint(w, &pt, x, y);
//		pt.y -= 2*center;
		pt.x -= center;
		pt.y -= center;
		f_DrawAnimationPointer = TRUE;
		return;
	}
	if( !f_DrawAnimationPointer )
		return;
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = DefWindowProc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = NULL;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName = NULL;
	wc.lpszClassName = anim;
	wc.hIconSm = NULL;
	RegisterClassEx( &wc );

	hwnd = CreateWindowEx( WS_EX_TRANSPARENT, anim, anim, WS_CHILD | WS_VISIBLE,
		pt.x, pt.y, 2*center, 2*center, hWndParent, (HMENU)anim_wnd_id, 
		hInst, NULL );
	ShowWindow( hwnd, SW_SHOWNORMAL );
	UpdateWindow( hwnd ); // Send WM_PAINT
	hdc = GetDC(hwnd);
	hBrush = CreateSolidBrush(RGB(0xff,0x00,0x00));
	hOldBrush = SelectObject(hdc,hBrush);
	for( i = 1; i < center; i+=4 ){
		Ellipse( hdc, center-i, center-i, center+i, center+i );
		Sleep(1);
	}
	SelectObject(hdc,hOldBrush);
	DeleteObject(hBrush);
	hBrush = GetStockObject(WHITE_BRUSH);
	SelectObject(hdc, hBrush);
	for( i = 1; i < center; i+=2 ){
		Ellipse( hdc, center-i, center-i, center+i, center+i );
		Sleep(1);
	}
	Sleep( 0 );
	ReleaseDC(hwnd, hdc);
	DestroyWindow( hwnd );
	f_DrawAnimationPointer = FALSE;
	return;
}


