/*
 *  TEX Device Driver  ver 2.25-
 *  copyright(c) 1988, 1989 by TSG, 1990-93 by SHIMA
 *
 *  stack.c : to operate 'stack' of dvi-file
 *     5  May   1992 : modified for ptex by Oh-Yeah?
 */

#include <stdio.h>
#include <stdlib.h>
#define _DEF_STDIO_H_
#include "dd.h"
#include "err.h"

char *marea(int);

#define	STACK_ROOM	4

struct STACK {
	/* stack */
	SCALED_PT d, h, v, w, x, y, z;
	char ptex_d;	/* ptex direction: 0 = yoko, 1 = tate */
};

struct STACK *stack_buf = NULL;
int depth, STACK_MAX;

void FreeStack(void)
{
	Free0((void *)stack_buf);
}

void stack_init(int stack_max)
{
	ENTER("stack_init");

	FreeStack();
	depth = 0;
	STACK_MAX = stack_max + STACK_ROOM;
	if ((stack_buf =
		 (struct STACK *)marea(sizeof(struct STACK)*STACK_MAX)) == NULL)
		    error(NO_MEMORY, "Cannot get memory for Stack");

	END();
}

void stack_rewind(void)
{
	ENTER("stack_rewind");

	depth = 0;
	if (stack_buf == NULL)
		error(PROGRAM_STOP, "Stack not initialized");

	END();
}

/* end of file: stack.c */
