#include <stdio.h>
#include <ctype.h>

void dump(FILE *fp)
{
  int c, col;
  int eol_f, checksum_f;
  char tbl[256][5];
  unsigned long checksum;

  for (c=0;c<256;c++) {
    sprintf(tbl[c],"0x%02x",c);
  }
  col = 0;
  
  printf("#include <config.h>\n");
  printf("unsigned char poolfilecontents[]={\n");
  eol_f = 1;
  checksum_f = 0;
  for ( ; ; ) {
    c = getc(fp);
    if (c == EOF) break;
    fputs(tbl[c], stdout);
    fputs(", ", stdout);
    if (++col == 8) {
      fputs("\n", stdout);
      col = 0;
    }
    if (eol_f) {
      if (c == '*') {
	checksum_f = 1;
	checksum = 0;
      }
      else checksum_f = 0;
    }
    else if (checksum_f && isdigit(c)) {
      checksum = checksum * 10 + (c - '0');
    }
    eol_f = (c == '\n');
  }
  fputs("\n0x00 };\n", stdout);
  printf("unsigned long poolfilechecksum = %lu;\n", checksum);
}

int main(int argc, char *argv[])
{
  int code = 0;
  if (argc == 1) {
    dump(stdin);
  }
  else if (argc == 2) {
    FILE *fp = fopen(argv[1],"rb");
    if (fp) {
      dump(fp);
      fclose(fp);
    }
    else {
      fprintf(stderr,"%s: Could not open.\n",argv[1]);
      code = 1;
    }
  }
  else {
    fprintf(stderr,"Usage: %s [file-name]\n", argv[0]);
    code =1;
  }
  
  return code;
}
