/* Maximum number of programs taken into account */
#define MAX_PROGS 10
#define MAX_LINES 12

#define SEPARATORS " \t\n\""

#define mvfile(a,b) CopyFile(a, b, FALSE)

#include <direct.h>
#include <process.h>

#include <kpathsea/config.h>
#include <kpathsea/c-ctype.h>
#include <kpathsea/c-fopen.h>
#include <kpathsea/c-stat.h>
#include <kpathsea/expand.h>
#include <kpathsea/getopt.h>
#include <kpathsea/line.h>
#include <kpathsea/pathsearch.h>
#include <kpathsea/c-memstr.h>
#include <kpathsea/c-pathch.h>
#include <kpathsea/c-pathmx.h>
#include <kpathsea/proginit.h>
#include <kpathsea/tex-file.h>
#include <kpathsea/tex-glyph.h>
#include <kpathsea/variable.h>

#if defined(__STDC__) || defined(WIN32)
#define NeedVarargsPrototypes   1
#include <stdarg.h>
#else
#define NeedVarargsPrototypes   0
#include <varargs.h>
#endif

#define fopen(f, m) (fprintf(stderr, "opening %s\n", f), fopen(f, m))
#define fclose(f) (fprintf(stderr, "closing %x\n", f), fclose(f))
/*
  We are keeping trace of the environment (ie: cwd, file redirections)
  with the help of these ops and structures. There is a global stack
  inidcating wich actions have been taken.
  */
typedef enum { CHDIR = 1, REDIRECT } op_env;
typedef struct mod_env {
  op_env op;
  union {
  char *path;
  int oldfd[3];
  } data;
} mod_env;

/* The global stack. */
mod_env stack_env[256];
int index_env = 0;

extern DllImport char* kpathsea_version_string;

/* Variables for MakeTeX* scripts */
static int program_number = -1;
static char* progname;
static char* texmf, *texmfpath;
static char* ls_R_magic = "% ls-R -- maintained by MakeTeXls-R; do not change this line.\n";
static char tfmname[MAXPATHLEN];
static char pkname[MAXPATHLEN];
static char pkdestdir[MAXPATHLEN];
static char tfmdestdir[MAXPATHLEN];
static char tmpdir[MAXPATHLEN]; /* Working temporary directory */
static char *output = "astdout";
FILE *fout;
static boolean downcase_names;

/* Variables for MakeTeX.site */
static char* mode;
static int dpi;
static char* bdpi;
static char* dcfontdir;
static char *tsfontdir;
static char* sauterfontdir;
static char* mt_features;
boolean mt_dosnames = FALSE;
boolean mt_nomode = FALSE;
boolean mt_strip = FALSE;
boolean mt_varfonts = FALSE;

/* Variables for MakeTeXnames.cnf */
static char* mt_dir_perms;
static char* mt_pkname;
static char* mt_namepart;
static char* mt_destroot;

/* Type of function to execute */
typedef void (*execfn)(char*, struct stat*);
static struct stat stat_buf;


/* Test whether getopt found an option ``A''.
   Assumes the option index is in the variable `option_index', and the
   option table in a variable `long_options'.  */
#define ARGUMENT_IS(a) STREQ (long_options[option_index].name, a)

static struct option long_options [] = {
  { "debug",               1, 0, 0},
  { "help",                0, 0, 0},
  { "version",             0, 0, 0},
  {0, 0, 0, 0}
};

/*
  This array describes all the programs that are taken into account.
  Each program is caracterized by :
  name, args required, args max, usage_msg
  */

void maketexpk(int, char**);
void maketextfm(int, char**);
void maketextex(int, char**);
void maketexmf(int, char**);
void maketexlsr(int, char**);
void maketexupdate(int, char**);
void maketexmkdir(int, char**);
void maketexrmdir(int, char**);
void maketexnames(int, char**);

void rec_rmdir(char*);
void do_rmdir(char*);
void do_makedir(char*);
void delmulslash(char *);

typedef void (*pf)(int, char**);

static struct program_description {
  char* name;
  char* altname;
  int arg_min;
  int arg_max;
  pf prog;
} makedesc [] = {
  {"MakeTeXPK",     "makepk",    4, 6, maketexpk },
  {"MakeTeXTFM",    "maketfm",   1, 1, maketextfm },
  {"MakeTeXTeX",    "maketex",   4, 6, maketextex },
  {"MakeTeXMF",     "makemf",    1, 1, maketexmf },
  {"MakeTeXls-R",   "makelsr",   0, 1, maketexlsr },
  {"MakeTeXupdate", "makeupd",   2, 2, maketexupdate },
  {"MakeTeXmkdir",  "makemd",    1, 255, maketexmkdir },
  {"MakeTeXrmdir",  "makerd",    1, 255, maketexrmdir },
  {"MakeTeXnames",  "makename",  1, 4, maketexnames },
  {0, 0, 0}
};

/*
  First  argument takes argv[0];
  Other arguments take no arguments.
  */
static char* usage_msg[][MAX_LINES] = {
  /* MakeTeXPK */
  {"Usage: %s NAME DPI BDPI MAG [MODE [DESTDIR]].\n",
   "Try to create a PK file for NAME at resolution DPI,",
   "with an assumed device base resolution of BDPI,\n",
   "and a Metafont `mag' of MAG.",
   "Use MODE for the Metafont mode if supplied, unless MODE is `default', in",
   "which case guess as usual. (This is so you can specify DESTDIR without MODE.)",
   "Use DESTDIR for the root of where to install into, either the absolute",
   "directory name to use (if it starts with a /) or relative to the default",
   "DESTDIR (if not).",
   0
  },
  /* MakeTeXTFM */
  {
    "Usage : %s FONT.",
    "Makes a TFM file for FONT, if possible.",
    0
  },
  /* MakeTeXTeX */
  {
    0
  },
  /* MakeTeXMF */
  {
    "Usage : %s FONT.",
    "Makes the Metafont source file for FONT, if possible.",
    "For example, 'dcr12' or 'cmr11'.",
    0
  },
  /* MakeTeXls-R */
  {
    "Usage : %s.",
    "Rebuild the ls-R file completely.",
    0
  },
  /* MakeTeXupdate */
  {
    "Usage : %s DIR FILE.",
    "Update the ls-R file with an entry for FILE in DIR.",
    0
  },
  /* MakeTeXmkdir */
  {
    "Usage : %s DIRS ...",
    "Create each DIR, including any missing leading directories.",
    0
  },
  /* MakeTeXrmdir */
  {
    "Usage : %s DIRS ...",
    "Recursively remove each DIR.",
    0
  },
  /* MakeTeXnames */
  {
    "Usage : %s NAME [DPI MODE] [DESTDIR].",
    "Output the PK and TFM names for a font NAME.",
    0
  }
};

static struct alist {
  char *key;
  char **var;
  char *val;
} vardef[] = {
  {"MODE", &mode, "ljfour"},
  {"BDPI", &bdpi, "600"},
  {"dcfontdir", &dcfontdir, "$TEXMF/fonts/source/jknappen/dc"},
  {"tsfontdir", &tsfontdir, "$TEXMF/fonts/source/jknappen/ts"},
  {"sauterfontdir", &sauterfontdir, "$TEXMF/fonts/source/public/sauter"},
  {"MT_FEATURES", &mt_features, ""},
  {NULL, NULL, NULL}
};

void mt_exit(int);

#if     NeedVarargsPrototypes
void
oops(const char *message, ...)
#else
/* VARARGS */
void
oops(va_alist)
        va_dcl
#endif
{
#if     !NeedVarargsPrototypes
        const char *message;
#endif
        va_list args;

#if     NeedVarargsPrototypes
        va_start(args, message);
#else
        va_start(args);
        message = va_arg(args, const char *);
#endif
        vfprintf(stderr, message, args);
        va_end(args);
        fputc('\n', stderr);
        mt_exit(1);
}

/* pushd */
void pushd(char *p)
{
#if 1
  fprintf(stderr, "pushing %s\n", p);
#endif
  if ((stack_env[index_env].data.path = malloc(MAXPATHLEN)) == NULL
      || getcwd(stack_env[index_env].data.path, MAXPATHLEN) == NULL) {
    fprintf(stderr, "pushd error!\n");
    mt_exit(1);
  }
  stack_env[index_env].op = CHDIR;
  index_env++;
  if (chdir(p) == -1) {
    perror(p);
    mt_exit(1);
  }
}
/* popd */
void popd()
{
  index_env--;
#if 1
  fprintf(stderr, "popping %s\n", stack_env[index_env].data.path);
#endif
  assert(stack_env[index_env].op == CHDIR);
  if (chdir(stack_env[index_env].data.path) == -1) {
    perror(stack_env[index_env].data.path);
    mt_exit(1);
  }
  free(stack_env[index_env].data.path);
}
/* redirect */
void push_fd(int newfd[3])
{
  int i;
#if 1
  fprintf(stderr, "pushing fds %d %d %d\n", newfd[0], newfd[1], newfd[2]);
#endif
  flushall();
  stack_env[index_env].op = REDIRECT;
  for(i = 0; i < 3; i++) {
    if (i == newfd[i])
      stack_env[index_env].data.oldfd[i] = i;
    else {
      if ((stack_env[index_env].data.oldfd[i] = dup(i)) == -1) {
	perror("push_fd: dup");
	mt_exit(1);
      }
      if (dup2(newfd[i], i)) {
	perror("push_fd : dup2");
	mt_exit(1);
      }
    }
  }
  index_env++;
}

void pop_fd()
{
  int i;
  index_env--;
  assert(stack_env[index_env].op == REDIRECT);
#if 1
  fprintf(stderr, "popping fds %d %d %d\n", 
	  stack_env[index_env].data.oldfd[0],
	  stack_env[index_env].data.oldfd[1],
	  stack_env[index_env].data.oldfd[2]);
#endif
  flushall();
  for(i = 0; i < 3; i++)
    if (i != stack_env[index_env].data.oldfd[i]) {
      close(i);
      if (dup2(stack_env[index_env].data.oldfd[i], i)) {
	perror("pop_fd : dup2");
	mt_exit(1);
      }
      close(stack_env[index_env].data.oldfd[i]);
      fprintf(stderr, "Closing %d\n", stack_env[index_env].data.oldfd[i]);
    }
}

/* popenv */
void popenv()
{
  switch(stack_env[index_env-1].op) {
  case CHDIR:
    popd();
    break;
  case REDIRECT:
    pop_fd();
    break;
  default:
    fprintf(stderr, "popenv : unknown op %d.\n", stack_env[index_env-1].op);
    break;
  }
}
    
/* Reading MakeTeX.site */
void read_mtsite()
{
  FILE *f;
  boolean found;
  char buf[256];
  int len;
  struct alist *p;
  char *mtsite = kpse_var_expand("$TEXMFCNF_DIR/MakeTeX.site");
  char *t;

  /* First assigning default values to all variables. */
  for(p = vardef; p->key != NULL; p++) {
    /* testing if there is an env var */
    strcpy(buf, "$"); strcat(buf, p->key);
    *(p->var) = kpse_var_expand(buf);
    if (*(p->var) == NULL || **(p->var) == '\0')
      *(p->var) = p->val;
  }

  /* and next overriding those variables in MakeTeX.site */
  if ((f = fopen(mtsite, "r")) == NULL) 
    return;
  while (fgets(buf, 256, f)) {
    if (buf[0] == '#' || isspace(buf[0]))
      continue;
    
    found = FALSE;
    for(p = vardef; !found && p->key != NULL; p++) {
      len = strlen(p->key);
      if (strncmp(p->key, buf, len) == 0 && buf[len] == '=') {
	*(p->var) = strdup(buf+len+1);
	found = TRUE;
      }
    }
    if (!found) 
      fprintf(stderr, "MakeTeX.site: unrecognized keyword in '%s'\n.",
	      buf);
  }
  fclose(f);
  /* Processing of mt_features (roughly equivalent to MakeTeXnames.cnf) */
  /* We just set booleans for future use */
  t = strtok(mt_features, SEPARATORS);
  while(t != NULL && *t != '\0') {
    if (strcmp(t, "dosnames") == 0)
      mt_dosnames = TRUE;
    else if (strcmp(t, "nomode") == 0)
      mt_nomode = TRUE;
    else if (strcmp(t, "strip") == 0)
      mt_strip = TRUE;
    else if (strcmp(t, "varfonts") == 0) {
      mt_varfonts = TRUE;
    }
    t = strtok(NULL, SEPARATORS);
  }
}

void usage()
{
  int i;
  fprintf(stderr, "%s version of kpathsea %s\n", progname, kpathsea_version_string);
  fprintf(stderr,usage_msg[program_number][0], progname );
  fputs("\n", stderr);
  for(i = 1; usage_msg[program_number][i]; ++i)
    fputs(usage_msg[program_number][i], stderr);
}

/*
BOOL WINAPI ctrl_event(DWORD d)
{
  fprintf(stderr, "Signal %d caught!\n", d);
  mt_exit(1);
  return FALSE;
}
*/

void mt_exit(int code)
{
  /* rtablir les 0, 1 et 2 d'origine avant de tenter quoi que ce soit ! */

  FILE *f;
  char buf[256];

  /* unstack all env but the first
     (pushd(tmpdir) from main) */
  for( ; index_env > 1; popenv());

  fcloseall();
  printf("Coucou2!\n");
  /* output result if any */
  if (code == 0 && (f = fopen(output, "r")) != NULL) {
    while(fgets(buf, 256, f))
      fputs(buf, stdout);
    fclose(f);
  }

  if (DeleteFile(output) == FALSE) {
    fclose(fout);
    if (DeleteFile(output) == FALSE) {
      fprintf(stderr, "Error deleting %s.\n", output);
    }
  }
  popd();
  rec_rmdir(tmpdir);
  exit(code);
}

/* ensure that the path is written with the same DIR_SEP */
void slashify(char *path)
{
  while(*path) {
    if (IS_DIR_SEP(*path))
      *path = DIR_SEP;
    path++;
  }
}


int main(int argc, char* argv[])
{
  int i;
  int g; /* getopt return code */
  int option_index;
  struct program_description * program;
  char *tempenv;
  FILE *fnul;
  int newfd[3];


  tempenv = getenv("TEMP");
  sprintf(tmpdir, "%s/mtXXXXXX", (tempenv ? tempenv : "/tmp"));
  mktemp(tmpdir);
  do_makedir(tmpdir);

  pushd(tmpdir);
  
  if ((fout = fopen(output, "w")) == NULL) {
    perror(output);
    mt_exit(1);
  }
  
  
  SetConsoleCtrlHandler((PHANDLER_ROUTINE)mt_exit, TRUE);
  
  fnul = fopen("nul", "r");	/* fopen /dev/null */
  
  newfd[0] = fileno(fnul);
  newfd[1] = fileno(fout);
  newfd[2] = 2;
  
  push_fd(newfd);

  printf("Coucou !\n");

  fprintf(stderr, "Err ...\n");

  printf("%s : %d\n", "ljfive", get_mode_from_mf("ljfive"));

  fclose(fnul);
  fclose(fout);

  mt_exit(0);

}

/* Like the test function from Unix */
boolean test_file(char c, char *path)
{
  boolean file_exists = (stat(path, &stat_buf) != -1);
  if (!file_exists) return FALSE;
  switch (c) {
  case 'd':
    return ((stat_buf.st_mode & S_IFMT) == S_IFDIR);
  case 'e':
    return TRUE;
  case 'f':
  case 'r':
    return ((stat_buf.st_mode & S_IFMT) == S_IFREG);
  case 's':
    return (stat_buf.st_size > 0);
  }
}

/* Recursively destructs files & directories from path. */
void rec_rmdir(char *path)
{
  char *p;
#if 0
  fprintf(stderr, "Path : %s, l = %d, last : %c\n", path, strlen(path), path[strlen(path)-1]);
#endif
  for(p=path+strlen(path)-1; IS_DIR_SEP(*p) && (p > path) ; p--) {
    *p = '\0';
  }
  do_rmdir(path);
}

/*
  Recursive walk through the directory tree. Depth-first order. 
*/
void recurse_dir(char* path, execfn before, execfn after)
{
    /* In depth traversal of the subdir tree */
#if defined(_WIN32)
  WIN32_FIND_DATA find_file_data;
  HANDLE hnd;
  int index;
#else
    DIR *dp;
    struct dirent *ep;
#endif
    struct stat stat_buf;	/* We have to have one local because
				   of after */

    int path_len = strlen(path);

    /* current node */
    if (stat(path, &stat_buf))
	perror(path);

    /* execute before for the current node */
    if (before)
      (*before)(path, &stat_buf);

    /* if it is a directory, recurse through all sons */
    if ((stat_buf.st_mode & S_IFMT) == S_IFDIR) {
#if defined(_WIN32)
      index = strlen(path);
      strcat(path, "/*");
#if 1
      fprintf(stderr, "Opening hnd on %s\n", path);
#endif
      hnd = FindFirstFile(path, &find_file_data);
      while (hnd != INVALID_HANDLE_VALUE && 
	     FindNextFile(hnd, &find_file_data) != FALSE) { 
	if(!strcmp(find_file_data.cFileName, ".")
	   || !strcmp(find_file_data.cFileName, "..")) 
	  continue;
	path[index+1] = '\0';
	strcat(path, find_file_data.cFileName);
	recurse_dir(path, before, after);
      }
      path[index] = '\0';
#if 1
      fprintf(stderr, "Closing hnd on %s\n", path);
#endif
      FindClose(hnd);
#else
	if (dp = opendir(path)) {
	    while (ep = readdir(dp))
		if (strcmp(ep->d_name, ".") &&
		    strcmp(ep->d_name, "..")) {
		    path[path_len] = '/';
		    strcpy(path+path_len+1, ep->d_name);
		    recurse_dir(path, opt);
		}
	    closedir(dp);
	}
	else
	    perror(NULL);
#endif
    }
    /* execute after for the current node */
    if (after)
      (*after)(path, &stat_buf);
}

/* remove something which already exists */
void remove_path(char *path, struct stat* st)
{
#if 1
  fprintf(stderr, "Removing %s.\n", path);
#endif
  if ((st->st_mode & S_IFMT) == S_IFDIR) {
    if (rmdir(path) == -1)
      perror(path);
  }
  else {
  if (unlink(path) == -1)
    perror(path);
  /*
    fprintf(stderr, "Error removing %s : %d.\n", path, GetLastError());
    */
  }
}

#if 0
void remove_path(char *path, struct stat* st)
{
  WIN32_FIND_DATA ffd;
  HANDLE hnd;
  int index;
  char buf[MAXPATHLEN];
  if ((st->st_mode & S_IFMT) == S_IFDIR) {
    strcpy(buf, path);
    index = strlen(buf);
    strcat(buf, "/*");
#if 1
      fprintf(stderr, "Opening hnd on %s\n", buf);
#endif
    hnd = FindFirstFile(buf, &ffd);
    while (hnd != INVALID_HANDLE_VALUE && 
	   FindNextFile(hnd, &ffd) != FALSE) { 
	if(!strcmp(ffd.cFileName, ".")
	   || !strcmp(ffd.cFileName, "..")) 
	  continue;
	buf[index] = '/';
	strcpy(buf+index+1, ffd.cFileName);
#if 1
	fprintf(stderr, "Trying to delete %s\n", buf);
#endif	
	if (ffd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
	  if (DeleteFile(buf) == FALSE) {
	    fprintf(stderr, "Error removing %s.\n", buf);
	  }
	else
	  if (DeleteFile(buf) == FALSE) {
	    fprintf(stderr, "Error removing %s.\n", buf);
	  }
    }
#if 1
      fprintf(stderr, "Closing hnd on %s\n", buf);
#endif
    FindClose(hnd);
  }
  else
    if (unlink(path) == -1)
      perror(path);
}
#endif

void do_rmdir(char* path)
{
  static char name[PATH_MAX];
  strcpy(name,path);

  if (test_file('d', path)) {
    recurse_dir(name, NULL, remove_path);
#if 0
    if (rmdir(path) == -1) perror(path);
#endif
  }
  else
    DeleteFile(path);
}


/* Creates path, and all intermediate directories if necessary. */

void do_makedir(char* path)
{
  char *p = path;

  /* We can't authrize multiple slashes here */
  delmulslash(path);

  if (stat(path, &stat_buf) == 0 &&
      (stat_buf.st_mode & S_IFMT) == S_IFDIR)
    return;			/* The path already exists */

  /* Finding the [drive letter][:] */
  if (IS_DEVICE_SEP(*(p+1)))
    p +=2;

  if (IS_DIR_SEP(*p))
    p++;

  for ( ; *p ; p++) {
    if (IS_DIR_SEP(*p)) {
      *p = '\0';
      if ((_mkdir(path) == -1)
	  && (errno != EEXIST)) { /* We do it for each path elt, even if it
				     already exists */
	perror(path);
	fprintf(stderr, "%s: MakeTeXmkdir %s failed.\n", progname, path);
	mt_exit(1);
      }
      *p = DIR_SEP;
    }
  }
  /* and for the whole path */
  if (_mkdir(path) == -1) {
    perror(path);
    fprintf(stderr, "%s: MakeTeXmkdir %s failed.\n", progname, path);
    mt_exit(1);
  }

}

/* Output the string in lower case or without modification according
   to downcase_names. */
void output_name(char *name, FILE *f)
{
  char *p;
  if (downcase_names) {
    for(p = name; *p; p++)
      *p = tolower(*p);
  }
  fputs(name, f);
}

/* Updates ls-R db for directory pointed to by path. */
void print_path(char* path, struct stat* st)
{
  WIN32_FIND_DATA find_file_data;
  HANDLE hnd;
  int index;
  if ((st->st_mode & S_IFMT) == S_IFDIR) {
    output_name(path, stdout);
    putchar(':'); putchar('\n');
    index = strlen(path);
    strcat(path, "/*");
    hnd = FindFirstFile(path, &find_file_data);
    while (FindNextFile(hnd, &find_file_data)) { 
      if(!strcmp(find_file_data.cFileName, ".")
	 || !strcmp(find_file_data.cFileName, "..")) 
	continue;
      output_name(find_file_data.cFileName, stdout);
      putchar('\n');/* We do want a \n */
    }
    path[index] = '\0';
    FindClose(hnd);
  }
}

/* return true if the fs on which path lies is case sensitive.
   Insufficient. Some people may have copied the complete tree in
   upper case rfom a case insensitive fs.
   Second test : look at the texmf name. If GetShortName !=
   GetLongName it is ok. 
*/
boolean is_casesensitive(char *path)
{
  char name[256];
  char volname[256];
  DWORD sernum;
  DWORD maxcomplen;
  DWORD fsflags;
  char fsname[256];
  
  /* How should the db be output ? Preserve case or lower case ? 
   First, determine the root volume : if path has the drive, ok. If
   not, get current drive. */
  
  if (IS_DEVICE_SEP(path[1])) {	/* the shortest path is "." and has 2 chars */
    name[0] =  path[0];
  }
  else
    name[0] = _getdrive() + 'A' - 1;

  strcpy(name+1, ":\\");

  if (GetVolumeInformation(name, volname, 256, &sernum, &maxcomplen,
			   &fsflags, fsname, 256) == FALSE) {
    fprintf(stderr, "Error getting volume info on %s.\n", name);
    mt_exit(1);
  }
  return (boolean)((fsflags & FS_CASE_IS_PRESERVED) != 0);

}

void do_maketexlsr(char *path)
{
  static char name[PATH_MAX];

  downcase_names = ! is_casesensitive(path);

  strcpy(name,path);
  recurse_dir(name, print_path, NULL);
}

void maketexlsr(int argc, char **argv)
{
  /* We have to take multiple root trees into account. 
     Not for the moment. */

  char lsrname[MAXPATHLEN];
  char tmpname[32];
  FILE* lsrfile;
  int old, newfd[3];

  strcpy(lsrname,texmf);
  strcat(lsrname,"/ls-R"); /* the final destination */
  strcpy(tmpname, "lsXXXXXX");	/* temporary ls-R file */
  if (mktemp(tmpname) == NULL) {
    perror("lsXXXXXX");
    mt_exit(1);
  }
  if ((lsrfile = fopen(tmpname, "w")) == NULL) {
    perror(lsrname);
    mt_exit(1);
  }
  
  newfd[0] = 0;
  newfd[1] = fileno(lsrfile);
  newfd[2] = 2;
  push_fd(newfd);

  puts(ls_R_magic);
  putchar('\n');

  pushd(texmf);
  do_maketexlsr(".");

  popd();			/* back to tmpdir */
   /* Restore original stdout */
  pop_fd();

  fflush(stdout);
  fclose(lsrfile);

  if (mvfile(tmpname, lsrname) == FALSE) {
    fprintf(stderr, "Error : can't copy %s on %s.\n", tmpname, lsrname);
    mt_exit(1);
  }
}

char* findmap(char* name, char* fontname)
{
  FILE *f;
  char buf[255];
  char* token;
  char* filename = concat(fontname, "/special.map");
  char* namepart = NULL;
  char* source = NULL;
  char* typeface = NULL;

  filename = kpse_find_file("special.map", kpse_fontmap_format, true);
  f = filename ? fopen(filename, FOPEN_R_MODE) : NULL;;
  if (f == NULL) oops("Cannot find file special.map.");
  
  while(fgets(buf, 255, f) != NULL) {
    token = strtok(buf, SEPARATORS);
#if 0
    fprintf(stderr, "%s %s %d %c\n", token, name, strlen(token), name[strlen(name)-1]);
#endif
    if (!strcmp(token, name)
	|| (!strncmp(token, name, strlen(token))
	    && isdigit(name[strlen(name)-1]))) {
      source = strtok(NULL, SEPARATORS);
      typeface = strtok(NULL, SEPARATORS);
      namepart = concat3(source, DIR_SEP_STRING, typeface);
      break;
    }
  }
  if (!namepart) {
    free(filename);
    /*    filename = concat(fontname, "/supplier.map"); */
    filename = kpse_find_file("supplier.map", kpse_fontmap_format, true);
    f = filename ? freopen(filename, FOPEN_R_MODE, f) : NULL;
    if (f == NULL) oops("Cannot find file supplier.map.");

    while(fgets(buf, 255, f) != NULL) {
      token = strtok(buf, SEPARATORS);
      if ((strlen(token) == 1) && (*token == *name)) {
	source = strdup(strtok(NULL, SEPARATORS));
	break;
      }
    }
    free(filename);
    /*    filename = concat(fontname, "/typeface.map"); */
    if (source) {
      filename = kpse_find_file("typeface.map", kpse_fontmap_format, true);
      f = filename ? freopen(filename, FOPEN_R_MODE, f) : NULL;
      if (f == NULL) oops("Cannot find file typeface.map.");
      /*      if ((f = freopen(filename, "r", f)) == NULL) {
	perror(filename);
	return NULL;
      } */
      while(fgets(buf, 255, f) != NULL) {
	token = strtok(buf, SEPARATORS);
	if ((strlen(token) == 2)
	    && (name[1] == token[0]) && (name[2] == token[1])) {
	  typeface = strdup(strtok(NULL, SEPARATORS));
	  break;
	}
      }
      if (typeface) {
	namepart = concat3(source, DIR_SEP_STRING, typeface);
	free(source);
	free(typeface);
      }
    }
  }
  free(filename);
  fclose(f);
  return namepart;
}

void delmulslash(char *path)
{
  char *p, *q;
#if 0
  fprintf(stderr, "Delmulslash before : %s\n", path);
#endif
  /* Delete any multiple slashes */
  for (p = q = path; *p != '\0'; p++, q++) {
    if (*p == '/') {
      *q = *p;
      q++;
      while (*++p == '/');
    }
    *q = *p;
  }
  *q = '\0';
#if 0
  fprintf(stderr, "Delmulslash after : %s\n", path);
#endif
}  

void do_maketexnames(char* name, char* dest, int dpi, char* mode)
{
  char *fontname = kpse_var_expand("$TEXFONTMAPS");
  char *mt_destroot, *mt_namepart, *mt_mode;
  char *mt_tfmpart = "tfm";
  char *mt_pkpart = "pk";
  char sdpi[24];

  /* we do not need to determine fontname, just need to call
     kpse_find_file with special.map ... */
  if ((fontname == NULL) || (*fontname == '\0'))
    fontname = concat(texmf, "/fontname");

  /* find namepart in *.map */
  if ((mt_namepart = findmap(name, fontname)) == NULL)
    mt_namepart = "tmp";
  
  mt_destroot = concat(texmf, "/fonts");

  if (mt_varfonts) {
    mt_destroot = kpse_var_expand("$VARTEXFONTS");
    mt_namepart = "";
    if (!mt_destroot || !*mt_destroot) {
      fprintf(stderr, "%s: You asked for varfonts in MT_FEATURES, but VARTEXFONTS\n", progname);
      fprintf(stderr, "%s: is not set as an environment variable or in texmf.cnf.\n", progname);
    }
  }
  
  if (mt_nomode)
    mt_mode = "";
  else
    mt_mode = mode;

  if (mt_strip)
    mt_namepart = "";
    
  *pkdestdir = '\0';
  if (dest)
    if (kpse_absolute_p(dest, false))
      strcpy(pkdestdir,dest);
    else
      mt_namepart = dest;

  if (!*pkdestdir)
    sprintf(pkdestdir, "%s/%s/%s/%s", mt_destroot, mt_pkpart, mt_mode, mt_namepart);
  sprintf(tfmdestdir, "%s/%s/%s", mt_destroot, mt_tfmpart, mt_namepart);

  if (mt_dosnames) {
    strcat(pkdestdir, "/dpi");
    itoa(dpi, sdpi, 10);
    strcat(pkdestdir, sdpi);
    sprintf(pkname, "%s/%s.pk", pkdestdir, name);
  }
  else
    sprintf(pkname, "%s/%s.%dpk", pkdestdir, name, dpi);

  /*  tfmname = tfmdestdir/name.tfm */
  sprintf(tfmname, "%s/%s.tfm\n", tfmdestdir, name);
  
  delmulslash(pkdestdir );
  delmulslash(tfmdestdir);
  delmulslash(pkname);
  delmulslash(tfmname);
}

void maketexnames(int argc, char **argv)
{
  char* name = argv[1];
  char* dest = NULL;

  argc--; /* We are eliminating argv[0] */
  if (argc <= 2) 
    dpi = atoi(bdpi);
  if (argc == 2)
    dest = argv[2];
  if (argc >= 3) {
    dpi = atoi(argv[2]);
    mode = argv[3];
  }
  if (argc == 4)
    dest = argv[4];

  do_maketexnames(name, dest, dpi, mode);

  fputs(pkname, fout); fputc(' ', fout);
  fputs(tfmname, fout); fputc(' ', fout);
}

void maketexmkdir(int argc, char **argv)
{
  int i;
  char *path;
  for(i = 1; i < argc; i++) {
    /* We have to concat the original wd if argv[i] is not absolute */
    if (kpse_absolute_p(argv[i], false))
      do_makedir(argv[i]);
    else {
      /* original path is in stack_env[0] */
      path = concat3(stack_env[0].data.path, DIR_SEP_STRING, argv[i]);
      do_makedir(path);
      free(path);
    }
  }
      
}

void maketexrmdir(int argc, char **argv)
{
  int i;
  char *path;
  for(i = 1; i < argc; i++) {
      do_rmdir(argv[i]);
  }
      
}

void do_maketexupdate(char* destdir, char *name)
{
  char *path, *db_file;
  char buf[256];
  FILE *f;

  slashify(destdir);
  if (!test_file('d', destdir)) {
    fprintf(stderr, "%s: %s is not a directory.\n", progname, destdir);
    mt_exit(1);
  }
  path = concat3(destdir, DIR_SEP_STRING, name);
  if (!test_file('f', path)) {
    fprintf(stderr, "%s: %s is not a file.\n", progname, name);
    mt_exit(1);
  }
  free(path);
  db_file = concat(texmf, "/ls-R");
  if (!test_file('f', db_file)) {
    maketexlsr(1, NULL);
    if (!test_file('f', db_file)) {
      fprintf(stderr, "%s: %s does not exist.\n", progname, db_file);
      mt_exit(1);
    }
  }
  if ((f = fopen(db_file, "r+")) == NULL) {
    fprintf(stderr, "%s: %s unwritable.\n", progname, db_file);
    mt_exit(1);
  }
  if (!fgets(buf, 256, f) || strncmp(buf, ls_R_magic, strlen(ls_R_magic))) {
    fprintf(stderr, "%s: %s lacks magic string\n%s.\n", progname, db_file,
	    ls_R_magic);
    mt_exit(1);
  }
  if (strncmp(destdir, texmf, strlen(texmf))) {
    fprintf(stderr, 
	    "%s: MakeTeXupdate found that %s isn't a directory in the %s tree.\n", 
	    progname, destdir, texmf);
  }
  else {
    destdir = destdir + strlen(texmf) - 1;
    *destdir = '.';
    fseek(f, 0L, SEEK_END);
    /* does the fs preserve case ? */
    if (!is_casesensitive(texmf)) {
      char *p;
      for(p = destdir; *p; p++)
	*p = tolower(*p);
      for(p = name; *p; p++)
	*p = tolower(*p);
    }
    fprintf(f, "%s:\n%s\n", destdir, name); 
    /*    fputs(destdir, f); fputs(":\n", f);
    fputs(name, f); fputc('\n', f); */
  }
  fclose(f);
}

void maketexupdate(int argc, char **argv)
{
  do_maketexupdate(argv[1], argv[2]);
}

void maketexmf(int argc, char **argv)
{

}

void maketextex(int argc, char **argv)
{

}

void maketextfm(int argc, char **argv)
{

}

int get_mode_from_mf(char *mode)
{
  int std_in[2], std_out[2];
  int new_fd[3], oldin, oldout, pid, status, result = 0;
  char buf[1024], *p;
  FILE *mf_in, *mf_out;

  if (pipe(std_in, 0, _O_TEXT) != 0 
      || pipe(std_out, 0, _O_TEXT) != 0) {
    perror("pipe");
    mt_exit(1);
  }
  /*
  flushall();
  
  oldin = dup(0);
  oldout = dup(1);
  
  if (dup2(std_in[0], 0) != 0)
    perror("dup2 std_in");
  if (dup2(std_out[1], 1) != 0)
    perror("dup2 std_out");
  flushall();
  */
  new_fd[0] = std_in[0];
  new_fd[1] = std_out[1];
  new_fd[2] = 2;
  push_fd(new_fd);

  pid = spawnlp(_P_NOWAIT, "mf", "mf", NULL);
  Sleep(50); /* Don't know why, but emacs is doing it too ... */

  /*
  dup2(oldin, 0);
  dup2(oldout, 1);
  */
  pop_fd();
  /* close(10); */
  /* close(12); */
  /*
  close(std_in[0]);
  close(std_out[1]);
  */

  if (pid == -1) {
    fprintf(stderr, "errno = %d\npath length = %d\n", errno, strlen(getenv("PATH")));
    perror("Spawning mf.exe");
    close(std_in[1]); close(std_out[0]);
    mt_exit(1);
  }

  mf_in = fdopen(std_in[1], "w");
  mf_out = fdopen(std_out[0], "r");

  sprintf(buf, "\\mode:=%s; mode_setup; message\"BDPI= \"&decimal round pixels_per_inch;end.\n", mode);
  fprintf(mf_in, buf);
  flushall();
  for(; result==0 && !feof(mf_out) ;) {
    memset(buf, '\0', 1024);
    fgets(buf, 1024, mf_out);
    for(p = buf; *p; p++)
      if (strncmp(p, "DPI= ", 5) ==0) {
	result=atoi(p+5);
	break;
      }
  }

  if (_cwait(&status, pid, 0) == -1) {
    perror("wait");
    mt_exit(1);
  }
  close(std_in[1]);
  close(std_out[0]);
  return result;
}

void maketexpk(int argc, char **argv)
{
  char *name = argv[1];
  char *dpi = argv[2];
  char *bdpi = argv[3];
  char *mag = argv[4];
  char *dest = NULL;
  char line[256], cmd[256];
  char *pkbasename, *psfontmapname;
  char gfname[MAXPATHLEN];
  char gfpkname[MAXPATHLEN];
  char pktempname[MAXPATHLEN];
  FILE *config_file;
  char *index;
  int len = strlen(name);
  int mf_bdpi, ibdpi;
  boolean res;

  if (argc >= 6)
    mode = argv[5];
  if (argc == 7)
    dest = argv[6];

  /* look for name in psfont.map */
  config_file = kpse_open_file("psfonts.map", kpse_dvips_config_format);
  if (config_file == NULL) oops("Cannot find file psfonts.map.");
  /* looking for pattern "^r$name(0|8r)?([ \t]|$)" */
  res = false;
  while (fgets(line,255,config_file) != NULL) {
    index = line;
    if (*line == 'r' && !strcmp(line+1, name))
      index += len+1;
    else if (!strcmp(line, name))
      index += len;
    else
      continue;
    if (*index == '0')
      index++;
    else if (*index == '8' && *(index+1) == 'r')
      index++;
    else continue;
    if (*index == '\0' || isspace(*index)) {
      res = true;
      break;
    }
  }
  fclose(config_file);
  if (res == true) {
    strcpy(mode, "gsftopk");
    sprintf(cmd, "%s %s %s", mode, name, dpi);
  }
  else if (strlen(mode) > 0) {
    if ((mf_bdpi = get_mode_from_mf(mode)) != atoi(bdpi)) {
      fprintf(stderr, "%s: Mismatched mode %s and resolution %s; ignoring mode.\n", progname, mode, bdpi);
      strcpy(mode, "");
    }
    if (strlen(mode) == 0  || strcmp(mode, "default") == 0) {
      ibdpi = atoi(bdpi);
      if (ibdpi == 300)
	mode = "cx";
      else if (ibdpi == 600)
	mode = "ljfour";
      else {
	fprintf(stderr, "%s: Can't guess mode for %s dpi devices.\n",
		progname, bdpi);
	fprintf(stderr, "%s: Use a config file, or update me.\n", progname);
	mt_exit(1);
      }
    }
    sprintf(cmd, "mf \\mode:=%s; mag:=%s; scrollmode; input %s",
	    mode, mag, name);
  }
    
  /* Put files into proper place */
  do_maketexnames(name, dest, atoi(dpi), mode);
  do_makedir(pkdestdir);

  pkbasename = basename(pkname);

  sprintf(gfname, "%s.%sgf", name, dpi);
  sprintf(gfpkname, "%s.%spk", name, dpi);

  if (test_file('e', pkname)) {
    fprintf(stderr, "%s: %s already exists.\n", progname, pkname);
    fputs(pkname, fout); fputc('\n', fout);
    do_maketexupdate(pkdestdir, pkbasename);
    return;
  }

  /* Now run metafont or gsftopk */
  if (system(cmd) == -1) {
    perror(mode);
    fprintf(stderr, "%s: '%s' failed.\n", progname, cmd);
    mt_exit(1);
  }
  
  if (test_file('e', gfname)) {
    sprintf(cmd, "gftopk ./%s %s", gfname, pkbasename);
    if (system(cmd) == -1) {
      perror("gsftopk");
      fprintf(stderr, "%s: gsftopk failed to make %s.\n", progname, pkbasename);
      mt_exit(1);
    }
  }
  if (!test_file('e', pkbasename) && test_file('e', gfpkname))
    if (mvfile(gfpkname, pkbasename) != TRUE) {
      fprintf(stderr, "%s: can't move %s to %s.\n", gfpkname, pkbasename);
      mt_exit(1);
    }
  if (!test_file('s', pkbasename)) {
    fprintf(stderr, "%s: '%s' failed to make %s.\n", progname, cmd,
	    pkbasename);
    mt_exit(1);
  }

  sprintf(pktempname, "%s/pktmp.XXX", pkdestdir);
  mktemp(pktempname);
  if (mvfile(pkbasename, pktempname) == FALSE) {
    fprintf(stderr, "%s: can't move %s to %s.\n", progname, pkbasename, 
	    pktempname);
    mt_exit(1);
  }
  if (!test_file('e', pkname))
    if (mvfile(pktempname, pkname) == FALSE 
	|| DeleteFile(pktempname) == FALSE ) {
      fprintf(stderr, "%s: can't move %s to %s.\n", progname, pktempname, 
	      pkname);
    mt_exit(1);
    }
  
  do_maketexupdate(pkdestdir, pkbasename);

  /* Maybe we should have been waiting before restoring stdin & stdout*/
  fputs(pkname, fout);
}

/* This one should help to clean up a font tree in a TDS way. It
  should also regenerate any pk font older than the same tfm font. 
  */
void maketextdsify(int arc, char **argv)
{

}
