/* current.c: current directory operation.
*/

#include <kpathsea/config.h>

#include <kpathsea/c-pathch.h>

extern string my_dirname (const_string name);    /* progname.c */

string kpse_dot_expand(const_string name)
{
#ifdef EXDLL
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
#endif
  const_string expansion = NULL;
  
  assert (name);
  
  if (*name == '.') {
    if (IS_DIR_SEP(*(name+1)))
      expansion = concat(current_dir, name+1);
    else
    if (!*(name+1))
      expansion = xstrdup (current_dir);
    else
    if (*(name+1) == '.') {
      if (IS_DIR_SEP(*(name+2)))
        expansion = concat(my_dirname(current_dir), name+2);
      else
      if (!*(name+2))
        expansion = my_dirname(current_dir);
    }
  } else
    expansion = name;

  if (!expansion)
    expansion = xstrdup (current_dir);

  /* We may return the same thing as the original, and then we might not
     be returning a malloc-ed string.  Callers beware.  Sorry.  */
  return (string) expansion;
}

boolean kpse_change_dir(const_string dir)
{
#ifdef EXDLL
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
#endif
  string expansion;

  assert (dir);
  
  expansion = kpse_expand (dir);
  
  if (access(expansion, F_OK) == -1) {
    perror(expansion);
    if (expansion != dir)
      fprintf(stderr, "before expansion = %s\n", dir);
    return false;
  }
  
  free (current_dir);
  if (expansion == dir)
    current_dir = xstrdup (dir);
  else
    current_dir = expansion;
  
  return true;
}