// Japanese TrueType font support utility program
// for Ghostscript with Japanese extension.

#define STRICT

#include <windows.h>
#include <tchar.h>
#include <mbctype.h>
#include "gsjfures.h"

HINSTANCE g_hInstance;
DWORD g_dwFormat = IDC_STRING;
HANDLE g_hFont = 0;

int CALLBACK EnumFontCallback(const LOGFONT* lpEnum, const TEXTMETRIC* lpNTM,
			      DWORD dwFontType, LPARAM lParam)
{
  if (!(dwFontType & TRUETYPE_FONTTYPE))
    return 1;
  
  ::SendMessage((HWND)lParam, LB_INSERTSTRING,
		-1, (LPARAM)lpEnum->lfFaceName);
  
  return 1;
}

void EscOct(unsigned char c, char* p)
{
  *p++ = '\\';
  *p++ = (c >> 6) + '0';
  *p++ = ((c >> 3) & 0x07) + '0';
  *p++ = (c & 0x07) + '0';
}

void SetLabel(HWND hWnd)
{
  HWND hList = ::GetDlgItem(hWnd, IDC_FONT_LIST);
  LRESULT lSel = ::SendMessage(hList, LB_GETCURSEL, 0, 0);
  if (lSel == LB_ERR) return;
  
  LONG lLen = ::SendMessageA(hList, LB_GETTEXTLEN, lSel, 0);
  LPSTR lpszName = new char[lLen + 1];
  ::SendMessageA(hList, LB_GETTEXT, lSel, (LPARAM)lpszName);
  ::SetDlgItemTextA(hWnd, IDC_AS_IS, lpszName);
  LPSTR lpszBuf;
  lpszBuf = new char[lLen * 4 + 10];
  strcpy(lpszBuf, "(");
  LPSTR p = lpszBuf + 1;
  LPCSTR q = lpszName;
  while (*q) {
    if (*q == '\\') {
      *p++ = '\\';
      *p++ = '\\';
    }
    else if (_ismbblead(*(unsigned char*)q)) {
      if (*(q+1) == '\\') {
	EscOct(*(unsigned char*)q, p);
	p += 4;
	q++;
	*p++ = *q;
      }
      else {
	*p++ = *q++;
	*p++ = *q;
      }
    }
    else if (isprint(*q))
      *p++ = *q;
    else {
      EscOct(*(unsigned char*)q, p);
      p += 4;
    }
    q++;
  }
  strcpy(p, ")");
  ::SetDlgItemTextA(hWnd, IDC_STRING, lpszBuf);
  strcpy(lpszBuf, "<");
  q = lpszName;
  p = lpszBuf + 1;
  while (*q) {
    static const char hex[] = "0123456789ABCDEF";
    *p++ = hex[*(unsigned char*)q >> 4];
    *p++ = hex[*q & 0x0f];
    q++;
  }
  strcpy(p, ">");
  ::SetDlgItemTextA(hWnd, IDC_HEX, lpszBuf);
  delete[]lpszBuf;
  delete[]lpszName;
}

void SetSample(HWND hWnd)
{
  HWND hList = ::GetDlgItem(hWnd, IDC_FONT_LIST);
  LRESULT lSel = ::SendMessage(hList, LB_GETCURSEL, 0, 0);
  if (lSel == LB_ERR) return;

  LOGFONT lf;
  HWND hEdit = ::GetDlgItem(hWnd, IDC_SAMPLE);
  RECT rect;
  ::GetClientRect(hEdit, &rect);
  lf.lfHeight = rect.bottom - rect.top;
  if (lf.lfHeight > 24) lf.lfHeight = 24;
  lf.lfWidth = 0;
  lf.lfEscapement = 0;
  lf.lfOrientation = 0;
  lf.lfWeight = 0;
  lf.lfItalic = FALSE;
  lf.lfUnderline = FALSE;
  lf.lfStrikeOut = FALSE;
  lf.lfCharSet = SHIFTJIS_CHARSET;
  lf.lfOutPrecision = OUT_TT_PRECIS;
  lf.lfClipPrecision = CLIP_TT_ALWAYS;
  lf.lfQuality = PROOF_QUALITY;
  lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
  ::SendMessage(hList, LB_GETTEXT, lSel, (LPARAM)lf.lfFaceName);
  
  HFONT hFont = ::CreateFontIndirect(&lf);
  if (hFont) {
    if (g_hFont) ::DeleteObject(g_hFont);
    g_hFont = hFont;
    ::SendMessage(hEdit, WM_SETFONT, (WPARAM)g_hFont, MAKELPARAM(TRUE, 0));
  }
}

void InitFontList(HWND hWnd)
{
  HDC hDC = ::GetWindowDC(HWND_DESKTOP);
  LOGFONT lf;
  lf.lfCharSet = SHIFTJIS_CHARSET;
  _tcscpy(lf.lfFaceName, _T(""));
  lf.lfPitchAndFamily = DEFAULT_PITCH | FF_DONTCARE;
  ::EnumFontFamiliesEx(hDC, &lf, EnumFontCallback,
		       (LPARAM)::GetDlgItem(hWnd, IDC_FONT_LIST), 0);
  ::ReleaseDC(HWND_DESKTOP, hDC);
  ::SendMessage(::GetDlgItem(hWnd, IDC_FONT_LIST), LB_SETCURSEL, 0, 0);
  SetLabel(hWnd);
}

LRESULT CALLBACK FontUtilDlgProc(HWND hWnd, UINT uMsg,
				 WPARAM wParam, LPARAM lParam)
{
  switch (uMsg) {
  case WM_INITDIALOG:
    ::CheckDlgButton(hWnd, g_dwFormat, TRUE);
    ::SetDlgItemText(hWnd, IDC_SAMPLE, _T("Tv Sample\r\n Text"));
    InitFontList(hWnd);
    SetSample(hWnd);
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDOK:
    case IDCANCEL:
      ::EndDialog(hWnd, LOWORD(wParam));
      break;
    case IDC_COPY:
      if (::SendMessage(::GetDlgItem(hWnd, IDC_FONT_LIST),
			LB_GETCURSEL, 0, 0) == LB_ERR)
	break;
      {
	char buf[1000];
	DWORD dwLen = 1000;
	LPSTR lpszStr = buf;
	::GetDlgItemTextA(hWnd, g_dwFormat, lpszStr, dwLen);
	if (::OpenClipboard(hWnd)) {
	  HGLOBAL hMem = ::GlobalAlloc(GMEM_SHARE, strlen(lpszStr) + 1);
	  LPVOID lpBuf = ::GlobalLock(hMem);
	  strcpy((char*)lpBuf, lpszStr);
	  ::GlobalUnlock(hMem);
	  ::EmptyClipboard();
	  ::SetClipboardData(CF_TEXT, hMem);
	  ::CloseClipboard();
	}
      }
      break;
    case IDC_AS_IS:
    case IDC_STRING:
    case IDC_HEX:
      g_dwFormat = LOWORD(wParam);
      break;
    case IDC_FONT_LIST:
      if (HIWORD(wParam) == LBN_SELCHANGE) {
	SetLabel(hWnd);
	SetSample(hWnd);
      }
      break;
    }
    break;
  }
  return 0;
}

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
{
  g_hInstance = hInstance;
  
  ::DialogBox(g_hInstance, MAKEINTRESOURCE(IDD_FONT_UTIL),
	      0, (DLGPROC)FontUtilDlgProc);

  if (g_hFont) {
    ::DeleteObject(g_hFont);
  }
  
  return 0;
}
