#include "gs.h"
#include "epsgsres.h"
#include <commctrl.h>

#define REGISTRY_KEY \
  "Software\\Kazunori Asayama\\Susie Plugin with Ghostscript"
#define DEFAULT_GS_DLL "D:\\Program Files\\TeX\\gstools\\gs5.10\\gsdll32.dll"

#define DPI_MIN 32
#define DPI_MAX 10000
  
static LPCSTR g_lpszRegKey = REGISTRY_KEY;

static BOOL CALLBACK SetupDlgProc(HWND hWnd, UINT uMsg,
				  WPARAM wParam, LPARAM lParam)
{
  if (uMsg == WM_INITDIALOG) {
    ::SetWindowLong(hWnd, DWL_USER, lParam);
  }
  CGS* lpGS = (CGS*)::GetWindowLong(hWnd, DWL_USER);
  if (lpGS) return lpGS->SetupDlgProc(hWnd, uMsg, wParam, lParam);
  else return 0;
}

int CGS::DoSetup(HWND hParent)
{
  int code =
    DialogBoxParam(g_hModule, MAKEINTRESOURCE(IDD_SETUP),
		   hParent, ::SetupDlgProc, (LPARAM)this);
  if (code == IDOK) {
    SaveConfig();
  }

  return SPI_ERROR_NORMAL;
}

BOOL CGS::SetupDlgProc(HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  HWND hItem;
  HWND hItem2;
  
  switch (uMsg) {
  case WM_INITDIALOG:
    if (m_lpszGsDll) {
      ::SetDlgItemText(hWnd, IDC_GS, m_lpszGsDll);
    }
    hItem = ::GetDlgItem(hWnd, IDC_ALPHA_TEXT);
    hItem2 = ::GetDlgItem(hWnd, IDC_ALPHA_GRAPHICS);
    {
      char buf[32];
      ::LoadString(g_hModule, IDS_ANTIALIAS_1, buf, 32);
      ::SendMessage(hItem, CB_INSERTSTRING, 0, (LPARAM)buf);
      ::SendMessage(hItem2, CB_INSERTSTRING, 0, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_ANTIALIAS_2, buf, 32);
      ::SendMessage(hItem, CB_INSERTSTRING, 1, (LPARAM)buf);
      ::SendMessage(hItem2, CB_INSERTSTRING, 1, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_ANTIALIAS_4, buf, 32);
      ::SendMessage(hItem, CB_INSERTSTRING, 2, (LPARAM)buf);
      ::SendMessage(hItem2, CB_INSERTSTRING, 2, (LPARAM)buf);
    }
    ::SendMessage(hItem, CB_SETCURSEL, m_nAlphaText, 0);
    ::SendMessage(hItem2, CB_SETCURSEL, m_nAlphaGraphics, 0);
    
    hItem = ::GetDlgItem(hWnd, IDC_MAGIC_NUMBER);
    {
      char buf[50];
      ::LoadString(g_hModule, IDS_MAGIC_PERCENT, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 0, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_MAGIC_PS, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 1, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_MAGIC_ADOBE, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 2, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_MAGIC_EPSF, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 3, (LPARAM)buf);
      ::SendMessage(hItem, CB_SETCURSEL, (int)m_eMagicNumber, 0);
    }
    ::SetDlgItemInt(hWnd, IDC_XDPI, m_dwXResolution, FALSE);
    ::SetDlgItemInt(hWnd, IDC_YDPI, m_dwYResolution, FALSE);
    ::CheckDlgButton(hWnd, IDC_NORMAL_ASPECT, m_bNormalAspect);
    ::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_LABEL), !m_bNormalAspect);
    ::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI), !m_bNormalAspect);
    ::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_SPIN), !m_bNormalAspect);
    ::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_DPI), !m_bNormalAspect);
    
    ::SendMessage(::GetDlgItem(hWnd, IDC_XDPI_SPIN), UDM_SETRANGE,
		  0, MAKELPARAM(DPI_MAX, DPI_MIN));
    ::SendMessage(::GetDlgItem(hWnd, IDC_YDPI_SPIN), UDM_SETRANGE,
		  0, MAKELPARAM(DPI_MAX, DPI_MIN));
    
    {
      hItem = ::GetDlgItem(hWnd, IDC_COLOR);
      char buf[50];
      ::LoadString(g_hModule, IDS_BPP_DEFAULT, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 0, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_BPP_1, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 1, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_BPP_4, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 2, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_BPP_8, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 3, (LPARAM)buf);
      ::LoadString(g_hModule, IDS_BPP_24, buf, 50);
      ::SendMessage(hItem, CB_INSERTSTRING, 4, (LPARAM)buf);
      int idx;
      switch (m_dwDepth) {
      case 1:
	idx = 1; break;
      case 4:
	idx = 2; break;
      case 8:
	idx = 3; break;
      case 24:
	idx = 4; break;
      default:
	idx = 0; break;
      }
      ::SendMessage(hItem, CB_SETCURSEL, idx, 0);
      ::CheckDlgButton(hWnd, IDC_CLIP, m_bClip);
    }
    {
      hItem = ::GetDlgItem(hWnd, IDC_PAPER);
      int i;
      for (i=0;g_paper[i].lpszName;i++)
	::SendMessage(hItem, CB_INSERTSTRING, i, (LPARAM)g_paper[i].lpszName);
      if (m_lpszDefaultPaper) {
	::SendMessage(hItem, CB_SELECTSTRING, -1, (LPARAM)m_lpszDefaultPaper);
      }
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDOK: // update state
      {
	char buf[_MAX_PATH + 1];
	::GetDlgItemText(hWnd, IDC_GS, buf, _MAX_PATH);
	if (buf[0] != 0) {
	  if (m_lpszGsDll) delete[]m_lpszGsDll;
	  m_lpszGsDll = new char[strlen(buf) + 1];
	  strcpy(m_lpszGsDll, buf);
	}
	HWND hItem = ::GetDlgItem(hWnd, IDC_PAPER);
	int n = ::SendMessage(hItem, CB_GETCURSEL, 0, 0);
	if (n != CB_ERR) {
	  if (::SendMessage(hItem, CB_GETLBTEXT, n, (LPARAM)buf) != CB_ERR) {
	    if (m_lpszDefaultPaper) delete[]m_lpszDefaultPaper;
	    m_lpszDefaultPaper = new char[strlen(buf) + 1];
	    strcpy(m_lpszDefaultPaper, buf);
	  }
	}
      }
      m_bNormalAspect = ::IsDlgButtonChecked(hWnd, IDC_NORMAL_ASPECT);
      
      m_dwXResolution = ::GetDlgItemInt(hWnd, IDC_XDPI, 0, FALSE);
      if (m_dwXResolution < DPI_MIN) m_dwXResolution = DPI_MIN;
      else if (m_dwXResolution > DPI_MAX) m_dwXResolution = DPI_MAX;
      m_dwYResolution = ::GetDlgItemInt(hWnd, IDC_YDPI, 0, FALSE);
      if (m_dwYResolution < DPI_MIN) m_dwYResolution = DPI_MIN;
      else if (m_dwYResolution > DPI_MAX) m_dwYResolution = DPI_MAX;
      
      {
	int n = ::SendMessage(::GetDlgItem(hWnd, IDC_COLOR),
			      CB_GETCURSEL, 0, 0);
	DWORD dwOldDepth = m_dwDepth;
	switch (n) {
	case 0:
	  m_dwDepth = 0; break;
	case 1:
	  m_dwDepth = 1; break;
	case 2:
	  m_dwDepth = 4; break;
	case 3:
	  m_dwDepth = 8; break;
	case 4:
	  m_dwDepth = 24; break;
	}
	if (m_dwDepth != dwOldDepth)
	  m_bMustRestart = TRUE;
	n = ::SendMessage(::GetDlgItem(hWnd, IDC_ALPHA_TEXT),
			  CB_GETCURSEL, 0, 0);
	if (n >= 0 || n <= 2) {
	  if (m_nAlphaText != n) m_bMustRestart = TRUE;
	  m_nAlphaText = n;
	}
	n = ::SendMessage(::GetDlgItem(hWnd, IDC_ALPHA_GRAPHICS),
			  CB_GETCURSEL, 0, 0);
	if (n >= 0 || n <= 2) {
	  if (m_nAlphaGraphics != n) m_bMustRestart = TRUE;
	  m_nAlphaGraphics = n;
	}
	n = ::SendMessage(::GetDlgItem(hWnd, IDC_MAGIC_NUMBER),
			  CB_GETCURSEL, 0, 0);
	if (n >= 0 && n < MNT_MAX) m_eMagicNumber = (MagicNumberType)n;
      }
      m_bClip = ::IsDlgButtonChecked(hWnd, IDC_CLIP);
      ::EndDialog(hWnd, IDOK);
      break;
    case IDCANCEL:
      ::EndDialog(hWnd, IDCANCEL);
      break;
    case IDC_NORMAL_ASPECT:
      {
	BOOL bEnable = !::IsDlgButtonChecked(hWnd, IDC_NORMAL_ASPECT);
	::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_LABEL), bEnable);
	::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI), bEnable);
	::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_SPIN), bEnable);
	::EnableWindow(::GetDlgItem(hWnd, IDC_YDPI_DPI), bEnable);
      }
      break;
    case IDC_BROWSE_GS:
      {
	OPENFILENAME ofn;
	char buf[_MAX_PATH + 1];
	::GetDlgItemText(hWnd, IDC_GS, buf, _MAX_PATH);
	ZeroMemory(&ofn, sizeof(ofn));
	ofn.lStructSize = sizeof(ofn);
	ofn.hwndOwner = hWnd;
	ofn.lpstrFilter = "DLL (*.DLL)\0*.DLL\0All Files (*.*)\0*\0";
	ofn.nFilterIndex = 0;
	ofn.lpstrFile = buf;
	ofn.nMaxFile = _MAX_PATH;
	ofn.Flags = OFN_FILEMUSTEXIST | OFN_NOCHANGEDIR | OFN_NONETWORKBUTTON;
	ofn.lpstrDefExt = "DLL";
	if (::GetOpenFileName(&ofn)) {
	  SetDlgItemText(hWnd, IDC_GS, buf);
	}
      }
      break;
    }
    break;
  }
  return 0;
}

static BOOL GetRegistry(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName,
			LPVOID lpData, LPDWORD lpdwSize, LPDWORD lpdwType)
{
  HKEY hKey;
  if (::RegOpenKeyEx(hHive, lpszSubKey, 0, KEY_READ, &hKey) != ERROR_SUCCESS)
    return FALSE;
  BOOL bSucceeded = FALSE;
  if (::RegQueryValueEx(hKey, lpszName, 0, lpdwType,
			(LPBYTE)lpData, lpdwSize) ==
      ERROR_SUCCESS)
    bSucceeded = TRUE;
  ::RegCloseKey(hKey);
  return TRUE;
}

static BOOL GetRegistryInt(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName,
			   LPDWORD lpdwValue)
{
  DWORD dwSize = sizeof(DWORD);
  DWORD dwType;
  if (!GetRegistry(hHive, lpszSubKey, lpszName, lpdwValue, &dwSize, &dwType))
    return FALSE;
  return (dwType == REG_DWORD);
}

static LPSTR GetRegistryString(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName)
{
  char buf[2048];
  DWORD dwSize = 2048;
  DWORD dwType;
  if (!GetRegistry(hHive, lpszSubKey, lpszName, buf, &dwSize, &dwType))
    return 0;
  if (dwType != REG_SZ) return 0;
  LPSTR p = new char[strlen(buf) + 1];
  strncpy(p, buf, dwSize);
  p[dwSize] = 0;
  return p;
}

BOOL CGS::LoadConfig()
{
  LPSTR p;
  p = ::GetRegistryString(HKEY_CURRENT_USER, g_lpszRegKey, "gsDllPath");
  if (p) {
    if (m_lpszGsDll) delete[]m_lpszGsDll;
    m_lpszGsDll = p;
  }
#if 0
  else if (m_lpszGsDll == 0) {
    p = DEFAULT_GS_DLL;
    m_lpszGsDll = new char[strlen(p) + 1];
    strcpy(m_lpszGsDll, p);
  }
#endif
  
  p = ::GetRegistryString(HKEY_CURRENT_USER, g_lpszRegKey, "paper");
  if (m_lpszDefaultPaper) delete[]m_lpszDefaultPaper;
  if (p) {
    m_lpszDefaultPaper = p;
  }
  else {
    m_lpszDefaultPaper = new char[3];
    strcpy(m_lpszDefaultPaper, "A4");
  }
  
  DWORD n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "depth", &m_dwDepth))
    m_dwDepth = 0;
  
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"xDpi", &m_dwXResolution))
    m_dwXResolution = 72;
  else if (m_dwXResolution < DPI_MIN)
    m_dwXResolution = DPI_MIN;
  else if (m_dwXResolution > DPI_MAX)
    m_dwXResolution = DPI_MAX;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"yDpi", &m_dwYResolution))
    m_dwYResolution = 72;
  else if (m_dwYResolution < DPI_MIN)
    m_dwYResolution = DPI_MIN;
  else if (m_dwYResolution > DPI_MAX)
    m_dwYResolution = DPI_MAX;
  
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"aspect", &n))
    m_bNormalAspect = TRUE;
  else
    m_bNormalAspect = n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "clip", &n))
    m_bClip = TRUE;
  else
    m_bClip = n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"alphaText", &n) || n < 0 || n > 2)
    m_nAlphaText = 0;
  else
    m_nAlphaText = n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"alphaGraphics", &n) || n < 0 || n > 2)
    m_nAlphaGraphics = 0;
  else
    m_nAlphaGraphics = n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "restartAlways", &n))
    m_bRestartAlways = FALSE;
  else
    m_bRestartAlways = n;
  if (!::GetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
			"magicNumberType", &n) || n < 0 || n >= MNT_MAX)
    m_eMagicNumber = MNT_PERCENT;
  else
    m_eMagicNumber = (MagicNumberType)n;
  
  m_hDLL = 0;
  m_bStarted = FALSE;
  
  return TRUE;
}

static BOOL SetRegistry(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName,
			const void* lpData, DWORD dwSize, DWORD dwType)
{
  HKEY hKey;
  DWORD dwDp;
  if (::RegCreateKeyEx(hHive, lpszSubKey, 0, "", REG_OPTION_NON_VOLATILE,
		       KEY_ALL_ACCESS, 0, &hKey, &dwDp) != ERROR_SUCCESS)
    return FALSE;
  BOOL bSucceeded = FALSE;
  if (::RegSetValueEx(hKey, lpszName, 0, dwType,
		      (const BYTE*)lpData, dwSize) == ERROR_SUCCESS)
    bSucceeded = TRUE;
  ::RegCloseKey(hKey);
  return TRUE;
}

static BOOL SetRegistryInt(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName,
			   DWORD dwValue)
{
  return SetRegistry(hHive, lpszSubKey, lpszName, &dwValue,
		     sizeof(DWORD), REG_DWORD);
}

static BOOL SetRegistryString(HKEY hHive, LPCSTR lpszSubKey, LPCSTR lpszName,
			      LPCSTR lpszString)
{
  return SetRegistry(hHive, lpszSubKey, lpszName, lpszString,
		     strlen(lpszString), REG_SZ);
}

BOOL CGS::SaveConfig()
{
  if (m_lpszGsDll)
    ::SetRegistryString(HKEY_CURRENT_USER, g_lpszRegKey, "gsDllPath",
			m_lpszGsDll);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "depth", m_dwDepth);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "xDpi", m_dwXResolution);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "yDpi", m_dwYResolution);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "aspect", m_bNormalAspect);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "clip", m_bClip);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey, "alphaText", m_nAlphaText);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
		   "alphaGraphics", m_nAlphaGraphics);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
		   "restartAlways", m_bRestartAlways);
  ::SetRegistryInt(HKEY_CURRENT_USER, g_lpszRegKey,
		   "magicNumberType", m_eMagicNumber);
  return TRUE;
}
