#include "gs.h"

int CFileMapping::Map(LPCSTR lpszFileName, DWORD dwOffset)
{
  Unmap();

  m_bByHandle = FALSE;
  m_hFile =
    ::CreateFile(lpszFileName, GENERIC_READ, FILE_SHARE_READ,
		 0, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
  if (m_hFile == INVALID_HANDLE_VALUE)
    return SPI_ERROR_READ;

  return MapInternal(dwOffset);
}

int CFileMapping::Map(HANDLE hFile, DWORD dwOffset)
{
  Unmap();
  m_hFile = hFile;
  m_bByHandle = TRUE;
  return MapInternal(dwOffset);
}

int CFileMapping::MapInternal(DWORD dwOffset)
{
  m_hMap = ::CreateFileMapping(m_hFile, 0, PAGE_READONLY, 0, 0, 0);
  if (!m_hMap) {
    Unmap();
    return SPI_ERROR_READ;
  }
  
  m_lpView = ::MapViewOfFileEx(m_hMap, FILE_MAP_READ, 0, dwOffset, 0, 0);
  if (!m_lpView) {
    Unmap();
    return SPI_ERROR_READ;
  }

  m_dwSize = ::GetFileSize(m_hFile, 0);
  m_dwSize = (m_dwSize > dwOffset) ? (m_dwSize - dwOffset) : 0;
  
  return SPI_ERROR_NORMAL;
}

void CFileMapping::Unmap()
{
  if (m_lpView) {
    ::UnmapViewOfFile(m_lpView);
    m_lpView = 0;
  }
  if (m_hMap) {
    ::CloseHandle(m_hMap);
    m_hMap = 0;
  }
  if (m_hFile != INVALID_HANDLE_VALUE) {
    if (!m_bByHandle)
      ::CloseHandle(m_hFile);
    m_hFile = INVALID_HANDLE_VALUE;
  }
  
  m_dwSize = 0;
}
