#include "gs.h"
#include <stdio.h>

static LPCSTR g_lpszPSMagic = "%!";

BOOL MatchLine(LPCSTR p, LPCSTR lpEnd, LPCSTR lpStr)
{
  int n = strlen(lpStr);
  return (lpEnd - p >= strlen(lpStr) && memcmp(lpStr, p, n) == 0);
}

LPCSTR PSNextLine(LPCSTR p, LPCSTR lpEnd)
{
  while (p < lpEnd) {
    if (*p == '\n') {
      if (p + 1 < lpEnd && *(p + 1) == '\r') return p + 2;
      else return p + 1;
    }
    else if (*p == '\r') {
      if (p + 1 < lpEnd && *(p + 1) == '\n') return p + 2;
      else return p + 1;
    }
    p++;
  }
  return lpEnd;
}

LPCSTR PSNextDSC(LPCSTR p, LPCSTR lpEnd)
{
  while (p < lpEnd) {
    LPCSTR q = PSNextLine(p, lpEnd);
    if (MatchLine(p, q, "%%"))
      return p;
    p = q;
  }
  return 0;
}

LPCSTR PSFindDSC(LPCSTR p, LPCSTR lpEnd, LPCSTR lpDSC)
{
  while (p < lpEnd) {
    p = PSNextDSC(p, lpEnd);
    if (!p) return 0;
    LPCSTR q = PSNextLine(p, lpEnd);
    if (MatchLine(p, q, lpDSC))
      return p;
    p = q;
  }
  return 0;
}

BOOL CGS::IsPS(LPCSTR lpData, LPCSTR lpEnd)
{
  if (m_eMagicNumber == MNT_PERCENT) {
    return (lpEnd - lpData >= 2) && (memcmp("%!", lpData, 2) == 0);
  }
  else if (m_eMagicNumber == MNT_PS) {
    return (lpEnd - lpData >= 4) && (memcmp("%!PS", lpData, 4) == 0);
  }
  else { // MNT_PS_ADOBE or MNT_EPS
    BOOL bMatch =
      (lpEnd - lpData >= (m_eMagicNumber == MNT_EPSF ? 23 : 14)) &&
	(memcmp("%!PS-Adobe-", lpData, 11) == 0) &&
	  isdigit(lpData[11]) && lpData[12] == '.' && isdigit(lpData[13]);
    if (!bMatch || m_eMagicNumber == MNT_PS_ADOBE)
      return bMatch;
    return (memcmp(" EPSF-", lpData + 14, 6) == 0) &&
      isdigit(lpData[20]) && lpData[21] == '.' && isdigit(lpData[22]);
  }
}

BOOL CGS::ParsePSF(LPCSTR lpData, LPCSTR lpEnd, CPSFInfo& psi, LONG nPage)
{
  ZeroMemory(&psi, sizeof(psi));

  LPCSTR lpBegin = lpData;
  psi.bEPS = TRUE;

  BOOL bBBFound = FALSE;
  BOOL bTrailerFound = FALSE;
  BOOL bPrologFound = FALSE;
  BOOL bSetupFound = FALSE;
  
  DWORD dwIncludeStack = 0;
  while (lpData < lpEnd) {
    LPCSTR lpDSC = PSNextDSC(lpData, lpEnd);
    if (!lpDSC) break;
    lpData = PSNextLine(lpDSC, lpEnd);
    
    if (MatchLine(lpDSC, lpData, "%%BeginDocument:")) {
      dwIncludeStack++;
    }
    else if (MatchLine(lpDSC, lpData, "%%EndDocument")) {
      if (dwIncludeStack) dwIncludeStack--;
    }
    else if (dwIncludeStack)
      ;
    else if (MatchLine(lpDSC, lpData, "%%BeginProlog")) {
      psi.nBeginProlog = lpDSC - lpBegin;
    }
    else if (MatchLine(lpDSC, lpData, "%%EndProlog")) {
      psi.nEndProlog = lpDSC - lpBegin;
    }
    else if (MatchLine(lpDSC, lpData, "%%BeginSetup")) {
      psi.nBeginSetup = lpDSC - lpBegin;
    }
    else if (MatchLine(lpDSC, lpData, "%%EndSetup")) {
      psi.nEndSetup = lpDSC - lpBegin;
    }
    else if (MatchLine(lpDSC, lpData, "%%Trailer")) {
      if (psi.nPages)
	psi.lpPage[psi.nPages - 1].nPageEnd = lpDSC - lpBegin;
      psi.nBeginTrailer = lpDSC - lpBegin;
      bTrailerFound = TRUE;
    }
    else if (MatchLine(lpDSC, lpData, "%%BoundingBox:")) {
      lpDSC += 14;
      while (lpDSC < lpData && isspace(*lpDSC))
	lpDSC++;
      if (lpDSC < lpData) {
	LPSTR p = new char[lpData - lpDSC + 1];
	memcpy(p, lpDSC, lpData - lpDSC);
	p[lpData - lpDSC] = 0;
	int col =
	  sscanf(p, "%ld%ld%ld%ld",
		 &psi.bb.llx, &psi.bb.lly, &psi.bb.urx, &psi.bb.ury);
	delete[]p;
	if (col == 4) bBBFound = TRUE;
      }
    }
    else if (MatchLine(lpDSC, lpData, "%%Page:")) {
      if (psi.nPages == 0) {
	psi.lpPage = new CPSFInfo::CPSFPageInfo[psi.nPages + 1];
      }
      else {
	CPSFInfo::CPSFPageInfo* lpTmp = psi.lpPage;
	psi.lpPage = new CPSFInfo::CPSFPageInfo[psi.nPages + 1];
	memcpy(psi.lpPage, lpTmp, sizeof(CPSFInfo::CPSFPageInfo) * psi.nPages);
	delete[]psi.lpPage;
	psi.lpPage[psi.nPages].nPageEnd = lpDSC - lpBegin;
      }
      psi.lpPage[psi.nPages + 1].nPageBegin = lpDSC - lpBegin;
      psi.nPages++;
    }
  }

  psi.nEndTrailer = lpEnd - lpBegin;
  if (!bTrailerFound && psi.nPages)
    psi.lpPage[psi.nPages - 1].nPageEnd = lpEnd - lpBegin;
  
  return bBBFound;
}
