#include "gs.h"
#include "epsgsres.h"
#include <stdio.h>

#define GS_DEVICE_NAME "mswindll"

CGS::CGS()
{
  m_lpszGsDll = 0;
  m_lpszDefaultPaper = 0;
  
  m_lpGSDevice = 0;
  m_bMustRestart = FALSE;
  m_bStarted = FALSE;
  
  LoadConfig();
}

CGS::~CGS()
{
  Stop();
  if (m_lpszGsDll) delete[]m_lpszGsDll;
  if (m_lpszDefaultPaper) delete[]m_lpszDefaultPaper;
}

BOOL CGS::LoadDLL()
{
  if (m_hDLL) return TRUE;
  if (!m_lpszGsDll) {
    int code = Message(IDS_ERROR_SETGSPATH, MB_OKCANCEL | MB_ICONWARNING);
    if (code != IDOK) return FALSE;
    DoSetup(0);
    if (!m_lpszGsDll) return FALSE;
  }
  
  m_hDLL = ::LoadLibrary(m_lpszGsDll);
  if (!m_hDLL) {
    Message(IDS_ERROR_LOADGS, MB_OK | MB_ICONERROR);
    return FALSE;
  }

  (FARPROC&)dll_revision = ::GetProcAddress(m_hDLL, "gsdll_revision");
  (FARPROC&)dll_init = ::GetProcAddress(m_hDLL, "gsdll_init");
  (FARPROC&)dll_execute_begin =
    ::GetProcAddress(m_hDLL, "gsdll_execute_begin");
  (FARPROC&)dll_execute_cont =
    ::GetProcAddress(m_hDLL, "gsdll_execute_cont");
  (FARPROC&)dll_execute_end =
    ::GetProcAddress(m_hDLL, "gsdll_execute_end");
  (FARPROC&)dll_exit = ::GetProcAddress(m_hDLL, "gsdll_exit");
  (FARPROC&)dll_lock_device = ::GetProcAddress(m_hDLL, "gsdll_lock_device");
  (FARPROC&)dll_copy_dib = ::GetProcAddress(m_hDLL, "gsdll_copy_dib");

  if (!dll_revision ||
      !dll_init ||
      !dll_execute_begin ||
      !dll_execute_cont ||
      !dll_execute_end ||
      !dll_exit ||
      !dll_lock_device ||
      !dll_copy_dib) {
    UnloadDLL();
    Message(IDS_ERROR_GSENTRYPOINT, MB_OK | MB_ICONERROR);
    return FALSE;
  }
  
  return TRUE;
}

void CGS::UnloadDLL()
{
  if (m_hDLL) {
    ::FreeLibrary(m_hDLL);
    m_hDLL = 0;
  }
}

static CGS* g_lpCurGS = 0;

static int dll_callback(int nMsg, LPSTR lpszStr, ULONG uCount)
{
  switch (nMsg) {
  case GSDLL_DEVICE:
    if (g_lpCurGS) g_lpCurGS->SetGSDevice((LPBYTE)lpszStr);
    break;
  case GSDLL_STDOUT:
    if (g_lpCurGS) g_lpCurGS->WriteConsole(lpszStr, uCount);
    return uCount;
  }
  return 0;
}

BOOL CGS::Start()
{
  if (m_bMustRestart) {
    Stop();
    m_bMustRestart = FALSE;
  }
  
  g_lpCurGS = this;
  
  if (m_bStarted)
    return TRUE;
  
  if (!LoadDLL())
    return FALSE;
    
  InitConsole();
  
  m_nArgc = 0;
  m_lppArgv[m_nArgc++] = "gs-susie-plugin";
  m_lppArgv[m_nArgc++] = "-sDEVICE=" GS_DEVICE_NAME;
  m_lppArgv[m_nArgc++] = "-dNOPAUSE";
  m_lppArgv[m_nArgc++] = m_szResolution;
  m_lppArgv[m_nArgc++] = "-g8x8";
  m_lppArgv[m_nArgc++] = m_szBitsPerPixel;
  if (m_nAlphaText) {
    m_lppArgv[m_nArgc++] = "-dNOPLATFONTS";
  }
  m_lppArgv[m_nArgc] = 0;
  sprintf(m_szResolution, "-r%lux%lu", GetXResolution(), GetYResolution());
  sprintf(m_szBitsPerPixel, "-dBitsPerPixel=%lu", GetDepth());
  int code = (*dll_init)(dll_callback, 0, m_nArgc, m_lppArgv);
  if (code != 0)
    return FALSE;
  
  m_bStarted = TRUE;
  
  return TRUE;
}

void CGS::Stop(BOOL bUnload)
{
  if (m_bStarted) {
    (*dll_exit)();
    m_bStarted = FALSE;
    SetGSDevice(0);
    g_lpCurGS = 0;
  }
  if (bUnload) UnloadDLL();
}

int CGS::BeginPage()
{
  return SPI_ERROR_NORMAL;
}

int CGS::EndPage()
{
  if (m_bRestartAlways) Stop();
  return SPI_ERROR_NORMAL;
}

int CGS::DoPage(LPCSTR lpStart, DWORD dwLen,
		DWORD dwWidth, DWORD dwHeight,
		const CPSFInfo& psi,
		FARPROC lpProgressCallback,
		LONG lProgressCallbackParam,
		HGLOBAL* lphDib)
{
  if (!Start()) return SPI_ERROR_INTERNAL;
  
  static LPCSTR lpszStartPage =
    "\n"
    "erasepage save/.spi@save exch def\n"
    "countdictstack/.spi@dictstack.count exch def\n"
    "count/.spi@count exch def\n"
    "/showpage{}def\n";
  static LPCSTR lpszEndPage =
    "\n"
    "count .spi@count sub{pop}repeat\n"
    "countdictstack .spi@dictstack.count sub{end}repeat\n"
    ".spi@save restore\n";
    "showpage\n";
  
  int code;
  code = (*dll_execute_begin)();
  if (code != 0) return SPI_ERROR_INTERNAL;
  
  code = GSPuts("mark\n");
  if (code != SPI_ERROR_NORMAL) return code;
  code = GSPrintf("/HWSize[%lu %lu]/HWResolution[%lu %lu]",
		  dwWidth, dwHeight,
		  GetXResolution(), GetYResolution());
  if (code != SPI_ERROR_NORMAL) return code;
  code = GSPuts("\ncurrentdevice putdeviceprops pop\n");
  if (code != SPI_ERROR_NORMAL) return code;
  code = GSPrintf("<</TextAlphaBits %d /GraphicsAlphaBits %d\n",
		  1 << m_nAlphaText,
		  1 << m_nAlphaGraphics);
  if (code != SPI_ERROR_NORMAL) return code;
  code = GSPuts("\n>> systemdict /setpagedevice get exec\n");
  if (code != SPI_ERROR_NORMAL) return code;
  
  code = GSWrite(lpszStartPage, strlen(lpszStartPage));
  if (code != SPI_ERROR_NORMAL) return code;
  
  code = GSPrintf("%lu %lu div %ld 72 div div\n",
		  dwWidth, GetXResolution(), psi.bb.urx - psi.bb.llx);
  if (code != SPI_ERROR_NORMAL) return code;
  code = GSPrintf("%lu %lu div %ld 72 div div scale\n",
		  dwHeight, GetYResolution(), psi.bb.ury - psi.bb.lly);
  if (code != SPI_ERROR_NORMAL) return code;
  
  code = GSPrintf("%ld %ld translate\n", -psi.bb.llx, -psi.bb.lly);
  if (code != SPI_ERROR_NORMAL) return code;
  
#define BLOCK_SIZE 4096
  DWORD dwDoneSize = 0;
  int (CALLBACK *proc)(int , int, long);
  (FARPROC&)proc = lpProgressCallback;
  
  while (dwDoneSize < dwLen) {
    DWORD dwSize =
      (dwLen - dwDoneSize) > BLOCK_SIZE ? BLOCK_SIZE : (dwLen - dwDoneSize);
    if (lpProgressCallback) {
      if ((*proc)(dwDoneSize, dwLen, lProgressCallbackParam)) {
	(*dll_execute_end)();
	return SPI_ERROR_ABORTED_BY_CALLBACK;
      }
    }
    code = GSWrite(lpStart, dwSize);
    if (code != SPI_ERROR_NORMAL) return code;
    lpStart += dwSize;
    dwDoneSize += dwSize;
  }
  code = GSPuts(lpszEndPage);
  if (code != SPI_ERROR_NORMAL) return code;
  
  code = (*dll_execute_end)();
  if (code != 0) return SPI_ERROR_INTERNAL;
  
  if (!m_lpGSDevice) return SPI_ERROR_INTERNAL;
  
  *lphDib = (*dll_copy_dib)(m_lpGSDevice);
  if (!*lphDib) return SPI_ERROR_INTERNAL;

  if ((*proc)(dwLen, dwLen, lProgressCallbackParam))
    code = SPI_ERROR_ABORTED_BY_CALLBACK;
  else
    code = SPI_ERROR_NORMAL;
  return code;
}

int CGS::GSWrite(LPCVOID lpData, DWORD dwLen)
{
  int code = (*dll_execute_cont)((LPCSTR)lpData, dwLen);
  if (code < 0) {
    Stop(FALSE);
    return SPI_ERROR_DATA_BROKEN;
  }
  return SPI_ERROR_NORMAL;
}

int CGS::GSPrintf(LPCSTR lpszFmt, ...)
{
  va_list a;
  va_start(a, lpszFmt);
  char buf[1024];
  int len = vsprintf(buf, lpszFmt, a);
  va_end(a);
  return GSWrite(buf, len);
}

DWORD CGS::GetDepth() const
{
  DWORD dep;
  if (m_dwDepth != 0)
    dep = m_dwDepth;
  else {
    HWND hWnd = ::GetDesktopWindow();
    HDC hDC = ::GetWindowDC(hWnd);
    dep = ::GetDeviceCaps(hDC, BITSPIXEL);
    ::ReleaseDC(hWnd, hDC);
  }
  if (dep < 4) dep = 1;
  else if (dep < 8) dep = 4;
  else if (dep == 16) dep = 24;
  else if (dep < 24) dep = 8;
  else dep = 24;
  return dep;
}

CPaper g_paper[] = {
  { "A3", 842, 1190, },
  { "A4", 595, 842, },
  { "A5", 421, 595, },
  { "A6", 297, 421, },
  { "B3", 1002, 1418, },
  { "B4", 709, 1002, },
  { "B5", 501, 709, },
  { "Letter", 612, 792, },
  { "Legal", 612, 1008, },
  { "Ledger", 1224, 792, },
  { "Tabloid", 792, 1224, },
  { 0, 0, 0, }
};

CBoundingBox CGS::GetDefaultBoundingBox() const
{
  CBoundingBox bb;
  bb.llx = bb.lly = 0;

  int i = 0;
  if (m_lpszDefaultPaper) {
    for (i=0;g_paper[i].lpszName;i++) {
      if (stricmp(g_paper[i].lpszName, m_lpszDefaultPaper) == 0)
	break;
    }
    if (!g_paper[i].lpszName) i = 0;
  }
  bb.urx = g_paper[i].dwWidth;
  bb.ury = g_paper[i].dwHeight;
  return bb;
}

void CGS::InitConsole()
{
}

void CGS::WriteConsole(LPCSTR lpszString, DWORD dwLen)
{
}
