#include <windows.h>
#include <stdio.h>
#include <win32dll/win32lib.h>

static LPTSTR get_registry_internal(HKEY hTop, LPCTSTR key, LPCTSTR name)
{
  LPTSTR value = NULL;
  HKEY hKey;

  if (RegOpenKeyEx(hTop, key, 0,
		   KEY_QUERY_VALUE, &hKey) == ERROR_SUCCESS) {
    char buf[2048];
    DWORD type, len;
    len = 2048;
    if (RegQueryValueEx(hKey, name, NULL,
			&type, buf, &len) == ERROR_SUCCESS) {
      value = win32_malloc(len + 1);
      memcpy(value, buf, len);
      value[len] = '\0';
    }
    RegCloseKey(hKey);
  }
  
  return value;
}

LPSTR win32_get_registry_string(LPCSTR key, LPCSTR name, LPCSTR default_value)
{
  LPSTR value = get_registry_internal(HKEY_CURRENT_USER, key, name);
  if (!value) value = get_registry_internal(HKEY_LOCAL_MACHINE, key, name);
  if (!value && default_value) value = win32_strdup(default_value);
  return value;
}

LONG win32_get_registry_int(LPCSTR key, LPCSTR name, LONG default_value)
{
  LONG i;
  LPTSTR value = get_registry_internal(HKEY_CURRENT_USER, key, name);
  if (!value) value = get_registry_internal(HKEY_LOCAL_MACHINE, key, name);
  if (value) {
    LPLONG pi = (LPLONG)value;
    i = *pi;
  }
  else i = default_value;
  return i;
}

static BOOL set_registry_internal(HKEY hTop, LPCTSTR key, LPCTSTR name,
				  LPVOID value, DWORD type, DWORD len)
{
  HKEY hKey;
  DWORD disp;
  
  if (RegCreateKeyEx(hTop, key, 0, "",
		     REG_OPTION_NON_VOLATILE, KEY_WRITE,  NULL,
		     &hKey, &disp) == ERROR_SUCCESS) {
    BOOL code = FALSE;
    if (RegSetValueEx(hKey, name, 0,
		      type, value, len) == ERROR_SUCCESS) {
      code = TRUE;
    }
    RegCloseKey(hKey);
    return code;
  }
  else return FALSE;
}

BOOL win32_set_registry_int(HKEY hTop,
			    LPCTSTR key, LPCTSTR name, LONG value)
{
  return set_registry_internal(hTop,
			       key, name, &value, REG_DWORD, sizeof(LONG));
}
