#include <win32dll/win32lib.h>
#include <win32dll/texdll.h>
#include <win32dll/maketexlib.h>

#define MF_DLL "mf.dll"

typedef struct {
  LPFTeXCallbackProc callback;
  LPVOID callback_data;
  LPSTR name;
  LPSTR result;
} InternalData;

static BOOL WINAPI main_internal(InternalData* pData)
{
  BOOL ret = FALSE;
  HINSTANCE hMF;

  win32_init_module(GetModuleHandle(NULL));
  hMF = win32_load_tex_library(MF_DLL);
  if (hMF) {
    LPFTeXGetProceduresProc GetProc;

    GetProc =
      (LPFTeXGetProceduresProc)GetProcAddress(hMF, "MFGetProcedures");
    
    if (GetProc) {
      LPCTeXProcedures Procs = (*GetProc)();
      HTeX hTeX;
      LPSTR workdir = GetTFMDirectory(pData->name);
      
      hTeX = (*Procs->Initialize)(pData->callback, pData->callback_data,
				  workdir);
      if (hTeX) {
	LONG code;

	if (win32_mkdir_recursively(workdir)) {
	  LPCSTR path;
	  code = (*Procs->VaMain)(hTeX,
				  "mf", "\\mode:=nullmode;scrollmode;input",
				  pData->name, NULL);
	  path = (*Procs->GetTFMFileName)(hTeX);
	  if (path) {
	    strcpy(pData->result, path);
	    ret = TRUE;
	    if (code == 0) {
	      DeleteFile((*Procs->GetLogFileName)(hTeX));
	    }
	  }
	}
	(*Procs->Uninitialize)(hTeX);
      }
      win32_free(workdir);
    }
    FreeLibrary(hMF);
  }
  
  return ret;
}

static UINT CALLBACK thread_func(LPVOID pv)
{
  InternalData *pData = pv;
  BOOL code = FALSE;
  
  if (win32_init_main(pData->callback, pData->callback_data, NULL)) {
    win32_set_progname("MakeTeXTFM");
    code = main_internal(pData);
    win32_uninit_main();
  }
  return code;
}

BOOL WINAPI MakeTeXTFMMain(LPSTR filename, DWORD filename_len,
			   LPFTeXCallbackProc callback, LPVOID callback_data,
			   LPCSTR name)
{
  LONG code = FALSE;
  InternalData* pdata = win32_malloc(sizeof(InternalData));
  DWORD idThread;
  HANDLE hThread;
  
  EnterCriticalSection(&critical_section);
  pdata->callback = callback;
  pdata->callback_data = callback_data;
  pdata->name = strdup(name);
  pdata->result = malloc(filename_len);
  
  hThread = (HANDLE)_beginthreadex(NULL, 0, thread_func,
				   pdata, 0, &idThread);
  if (hThread) {
    WaitForSingleObject(hThread, INFINITE);
    GetExitCodeThread(hThread, &code);
    if (code) strcpy(filename, pdata->result);
    CloseHandle(hThread);
  }
  
  free(pdata->name);
  free(pdata->result);
  free(pdata);
  
  LeaveCriticalSection(&critical_section);

  if (code) UpdateLSR();
  
  return code;
}
