#include "win32lib.h"
#include "maketexlib.h"

static LPCSTR ls_R_magic =
  "% ls-R -- maintained by MakeTeXls-R; do not change this line.";

struct direlm {
  LPSTR name;
  BOOL dir;
  struct direlm *next;
};

static int compare_filename(const void *a, const void *b)
{
  return _mbsicmp((*(struct direlm **)a)->name, (*(struct direlm **)b)->name);
}

BOOL ls_r(FILE *fp, LPCSTR topDir, LPCSTR dir)
{
  WIN32_FIND_DATA findData;
  HANDLE hFind;
  BOOL code = TRUE;
  LPSTR pattern = win32_concat_filename(dir, "*");
  struct direlm *elms = NULL;
  int elmcount = 0;
  
  {
    LPSTR dirUnix = win32_strdup(dir);
    LPCSTR p = dirUnix + strlen(topDir);
    win32_dos2unix(dirUnix);
    putc('.', fp);
    if (*p != '/') putc('/', fp);
    fputs(p, fp);
    /*    fputs(dirUnix, fp); */
    fputs(":\n", fp);
  }
  hFind = FindFirstFile(pattern, &findData);
  if (hFind == INVALID_HANDLE_VALUE) {
    win32_free(pattern);
    return FALSE;
  }
  do {
    if (findData.cFileName[0] != '.') {
      struct direlm *e = win32_malloc(sizeof(struct direlm));
      e->next = elms;
      e->name = win32_strdup(findData.cFileName);
      e->dir = (findData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY);
      elms = e;
      elmcount++;
    }
  } while (FindNextFile(hFind, &findData));
  FindClose(hFind);
  win32_free(pattern);
  
  if (elmcount) {
    int i;
    struct direlm *e;
    struct direlm **elmarray = win32_malloc(sizeof(struct direlm*) * elmcount);
    for (e = elms, i=0;e;e=e->next, i++)
      elmarray[i] = e;
    qsort(elmarray, elmcount, sizeof(struct direlm*), compare_filename);

    for (i=0;i<elmcount;i++) {
      e = elmarray[i];
      fputs(e->name, fp);
      putc('\n', fp);
    }
    for (i=0;i<elmcount;i++) {
      e = elmarray[i];
      if (e->dir) {
	LPSTR dirChild = win32_concat_filename(dir, e->name);
	putc('\n', fp);
	code = ls_r(fp, topDir, dirChild);
	win32_free(dirChild);
	if (!code) break;
      }
    }
    for (i=0;i<elmcount;i++)
      win32_free(elmarray[i]);
    win32_free(elmarray);
  }
  
  return code;
}

typedef struct {
  LPSTR topdir;
  LPSTR lsr;
} thread_info;

static UINT CALLBACK thread_func(LPVOID pv)
{
  BOOL code = TRUE;
  thread_info* lpThreadInfo = pv;
  LPSTR texmf_lsr;
  LPSTR lsr_filename, lsr_temp_filename;
  char temp_dir[_MAX_PATH + 1];
  if (!GetTempPath(_MAX_PATH, temp_dir))
    strcpy(temp_dir, ".");
  
  win32_set_progname("MakeTeXls-R");
  texmf_lsr = lpThreadInfo->topdir;
  if (!texmf_lsr) texmf_lsr = win32_var_value("TEXMFLS_R");
  if (!texmf_lsr) {
    texmf_lsr = win32_var_value("TEXMFMAIN");
    if (!texmf_lsr) return FALSE;
  }
  win32_unix2dos(texmf_lsr);
  
  lsr_filename =
    lpThreadInfo->lsr ?
      lpThreadInfo->lsr : win32_concat_filename(texmf_lsr, "ls-R");
  {
    char suffix[50];
    LPSTR p = win32_concat_filename(temp_dir, "lsr");
    sprintf(suffix, "%05lx.%03lx",
	    (DWORD)GetCurrentTime() & 0xfffff,
	    (DWORD)GetCurrentThreadId() & 0xfff);
    lsr_temp_filename = win32_concat(p, suffix);
    win32_free(p);
  }

  {
    FILE *fp = fopen(lsr_temp_filename, "w");
    if (!fp) return FALSE;
    fputs(ls_R_magic, fp);
    fputs("\n\n", fp);
    code = ls_r(fp, texmf_lsr, texmf_lsr);
    fclose(fp);
    if (code) {
      DeleteFile(lsr_filename);
      MoveFile(lsr_temp_filename, lsr_filename);
    }
    else
      DeleteFile(lsr_temp_filename);
  }
  
  return code;
}

static LONG WINAPI dummy_callback(TeXDLLMessage msg,
				  DWORD param1, DWORD param2,
				  LPVOID app_data)
{
  return 0;
}

BOOL WINAPI MakeTeXlsRMain(LPCSTR lpszTopDir, LPCSTR lpszLSR)
{
  BOOL code = FALSE;
  EnterCriticalSection(&critical_section);
  if (win32_init_main(dummy_callback, NULL, NULL)) {
    DWORD idThread;
    HANDLE hThread;
    thread_info* ti = win32_malloc(sizeof(thread_info));
    ti->topdir  = lpszTopDir ? win32_strdup(lpszTopDir) : NULL;
    ti->lsr = lpszLSR ? win32_strdup(lpszLSR) : NULL;
    hThread = (HANDLE)_beginthreadex(NULL, 0, thread_func,
				     ti, 0, &idThread);
    if (hThread) {
      DWORD exit_code;
      WaitForSingleObject(hThread, INFINITE);
      GetExitCodeThread(hThread, &exit_code);
      code = exit_code;
      CloseHandle(hThread);
    }
    win32_uninit_main();
  }
  LeaveCriticalSection(&critical_section);
  return code;
}
