#define EXTERN extern
#include "../mfd.h"

#ifdef WIN32_DLL
#include <stdlib.h>
#include <windows.h>
#include <win32dll/texdll.h>

static int initialized_f;
static BOOL drawing_started_f;
static BOOL first_draw_f;
static HDC hDC;

#undef mf_mswin_termscreen
void mf_mswin_termscreen(void);

static void SetDC()
{
  if (first_draw_f) {
    hDC = (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_BEGINCHAR,
					    0, 0,
					    win32_dll_context->lpvCallbackData);
    first_draw_f = FALSE;
  }
}

dll_init_mfscreen(void)
{
  initialized_f = 0;
}

boolean
mf_mswin_initscreen(void)
{
  drawing_started_f = FALSE;
  first_draw_f = TRUE;
  hDC = NULL;
  return
    (initialized_f =
     (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_INITIALIZE,
				       screenwidth, screendepth,
				       win32_dll_context->lpvCallbackData));
}

void
mf_mswin_updatescreen(void)
{
  if (drawing_started_f)
    (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_ENDCHAR, 0, 0,
				      win32_dll_context->lpvCallbackData);
  first_draw_f = TRUE;
}

void
mf_mswin_blankrectangle(left, right, top, bottom)
     screencol left, right;
     screenrow top, bottom;
{
  SetDC();
  if (hDC) {
    if (BeginPath(hDC)) {
      MoveToEx(hDC, left,top, NULL);
      LineTo(hDC, left,bottom);
      LineTo(hDC, right,bottom);
      LineTo(hDC, right,top);
      CloseFigure(hDC);
      EndPath(hDC);
      FillPath(hDC);
    }
  }
  else {
    static RECT rect;
    rect.left = left;
    rect.right = right;
    rect.top = top;
    rect.bottom = bottom;
    (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_CLEAR, (DWORD)&rect, 0,
				      win32_dll_context->lpvCallbackData);
  }
}

mf_mswin_paintrow(row, init_color, tvect, vector_size)
     screenrow row;
     pixelcolor init_color;
     transspec tvect;
     screencol vector_size;
{
  SetDC();
  if (hDC) {
    do {
      int col_1 = *tvect++;
      if (init_color) {
	MoveToEx(hDC, col_1, row, NULL);
	LineTo(hDC, *tvect, row);
      }
      init_color = !init_color;
    } while (--vector_size > 0);
  }
  else {
    static MFDisplayRaster raster;
    raster.bBlack = (init_color != 0);
    raster.dwRow  = row;
    raster.dwVectorSize = vector_size;
    raster.lpdwVector = tvect;
    (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_PAINT,
				      (DWORD)&raster, 0,
				      win32_dll_context->lpvCallbackData);
  }
  drawing_started_f = TRUE;
}

void
mf_mswin_termscreen(void)
{
  if (initialized_f)
    (*win32_dll_context->lpfCallback)(TeXDLL_MFDISPLAY_UNINITIALIZE, 0, 0,
				      win32_dll_context->lpvCallbackData);
}
#else
int mf_mswin_dummy;
#endif
