#include <win32dll/win32lib.h>

#include <mbstring.h>
#include <stdlib.h>

static HANDLE win32_module_handle = NULL;
static char ThisDllFileName[_MAX_PATH+1];
static char ThisDllPathName[_MAX_PATH+1];

BOOL win32_init_module(HANDLE hModule)
{
  char *p;
  win32_module_handle = hModule;
  GetModuleFileName(hModule, ThisDllFileName, _MAX_PATH+1);
  strcpy(ThisDllPathName, ThisDllFileName);
  p = win32_basename(ThisDllPathName);
  *p = '\0';
  
  return TRUE;
}

HMODULE win32_get_module_handle(void)
{
  return win32_module_handle;
}

LPCSTR win32_module_filename(void)
{
  return ThisDllFileName;
}

LPCSTR win32_module_pathname(void)
{
  return ThisDllPathName;
}

HINSTANCE win32_load_library_just_in_same_directory(LPCSTR dllname)
{
  HINSTANCE hDLL;
  char *dllpath = win32_concat(win32_module_pathname(), dllname);
  hDLL = LoadLibrary(dllpath);
  win32_free(dllpath);
  return hDLL;
}

HINSTANCE win32_load_library_in_same_directory(LPCSTR dllname)
{
  HINSTANCE hDLL = win32_load_library_just_in_same_directory(dllname);
  return hDLL ? hDLL : LoadLibrary(dllname);
}

HINSTANCE win32_load_just_registry_library(LPCSTR key, LPCSTR value,
					   LPCSTR dllname)
{
  LPSTR dlldir = win32_get_registry_string(key, value, NULL);
  HINSTANCE hDLL = NULL;
  if (dlldir) {
    char *dllpath;
    char *bs = _mbsrchr(dlldir, '\\');
    if (bs && bs - dlldir == strlen(dlldir) - 1)
      dllpath = win32_concat(dlldir, dllname);
    else
      dllpath = win32_concat3(dlldir, "\\", dllname);
    hDLL = LoadLibrary(dllpath);
    win32_free(dllpath);
    win32_free(dlldir);
  }
  return hDLL;
}

HINSTANCE win32_load_registry_library(LPCSTR key, LPCSTR value,
				      LPCSTR dllname)
{
  HINSTANCE hDLL = win32_load_just_registry_library(key, value, dllname);
  return hDLL ? hDLL : LoadLibrary(dllname);
}

HINSTANCE win32_load_tex_library(LPCSTR dllname)
{
  HINSTANCE hDLL = win32_load_library_just_in_same_directory(dllname);
  if (hDLL) return hDLL;
  return win32_load_registry_library(TeXDLL_REGISTRY_KEY, "Path", dllname);
}
