#include <win32dll/win32lib.h>
#include <errno.h>
#if 0
#include <objidl.h>
#endif

/* File I/O */

#define IS_DLL_OUTCONSOLE(fp) \
  (win32_dll_context && ((fp) == WIN32_STDOUT || (fp) == WIN32_STDERR))
#define IS_DLL_INCONSOLE(fp) (win32_dll_context && (fp) == WIN32_STDIN)

#define FWRITEBUFFER(fp) \
  (((fp) == WIN32_STDOUT) ? &stdout_buffer : &stderr_buffer)

/* OLE2 structured storage support.
   Sorry. Not implemented yet.*/
#if 0
static LPSTORAGE topStorage = NULL;
#endif

typedef enum {
  file_type_file, file_type_stream,
} file_type;
typedef struct TeXFILE_s TeXFILE;
struct TeXFILE_s {
  file_type type;
  int file_no;
  char *name;
  union {
    FILE *pFile;
#if 0
    LPSTREAM pStream;
#endif
  } file;
  TeXFILE* next;
};

#define WRITE_BUFFER_SIZE 2047
typedef struct {
  TeXDLLMessage msg;
  char buffer[WRITE_BUFFER_SIZE+2];
  int ptr;
  BOOL mb_first;
} WriteBuffer;

WriteBuffer stdout_buffer = { TeXDLL_STDOUT_WRITE, "", 0, FALSE, };
WriteBuffer stderr_buffer = { TeXDLL_CONSOLE_WRITE, "", 0, FALSE, };

static TeXFILE* open_file_list = NULL;

int win32_fileno(FILE *fp)
{
  if (fp == WIN32_STDIN)
    return fileno(stdin);
  else if (fp == WIN32_STDOUT)
    return fileno(stdout);
  else if (fp == WIN32_STDERR)
    return fileno(stderr);
  else
    return fileno(fp);
}

static VOID win32_console_flush(WriteBuffer* p)
{
  if (p->ptr) {
    p->buffer[p->ptr] = 0;
    (*win32_dll_context->lpfCallback)(p->msg,
				      (DWORD)p->buffer,
				      p->ptr,
				      win32_dll_context->lpvCallbackData);
    p->ptr = 0;
  }
}

static void win32_console_putc(int c, WriteBuffer *p)
{
  if (p->mb_first) {
    p->buffer[p->ptr++] = c;
    p->mb_first = FALSE;
  }
  else {
    if (p->ptr >= WRITE_BUFFER_SIZE)
      win32_console_flush(p);
    p->buffer[p->ptr++] = c;
    if (_ismbblead(c)) p->mb_first = TRUE;
    else if (c == '\n') {
      p->mb_first = FALSE;
      win32_console_flush(p);
    }
  }
}

static VOID win32_console_write_internal(const LPVOID buf, LONG len,
					 WriteBuffer *b)
{
  LPBYTE p = buf;
  while (len-- > 0) win32_console_putc(*p++, b);
}

size_t win32_write(const LPVOID buf, size_t size, size_t count, FILE *fp)
{
  if (IS_DLL_OUTCONSOLE(fp)) {
    WriteBuffer *wb = FWRITEBUFFER(fp);
    size_t c;
    BYTE *b = buf;
    for (c=0;c<count;c++) {
      win32_console_write_internal(b, size, wb);
      b += size;
    }
    return count;
  }
  else
    return fwrite(buf, size, count, fp);
}

static void win32_console_vprintf(WriteBuffer* b, const char *fmt, va_list a)
{
  char buf[2000];
  int len = vsprintf(buf, fmt, a);
  win32_console_write_internal(buf, len, b);
}

void win32_console_printf(const char *fmt, ...)
{
  va_list a;
  va_start(a,fmt);
  if (win32_dll_context)
    win32_console_vprintf(FWRITEBUFFER(WIN32_STDERR), fmt, a);
  else vprintf(fmt, a);
}

void win32_stdout_printf(const char *fmt, ...)
{
  va_list a;
  va_start(a,fmt);
  if (win32_dll_context)
    win32_console_vprintf(FWRITEBUFFER(WIN32_STDOUT), fmt, a);
  else vprintf(fmt, a);
}

void win32_printf(FILE *fp, const char *fmt, ...)
{
  va_list a;
  va_start(a, fmt);
  if (IS_DLL_OUTCONSOLE(fp))
    win32_console_vprintf(FWRITEBUFFER(fp), fmt, a);
  else
    vfprintf(fp, fmt, a);
}

int win32_puts(const char *s, FILE *fp)
{
  if (IS_DLL_OUTCONSOLE(fp))
    win32_console_write_internal((LPVOID)s, strlen(s), FWRITEBUFFER(fp));
  else
    fputs(s,fp);
  return 0;
}

int win32_putc(int c, FILE *fp)
{
  if (IS_DLL_OUTCONSOLE(fp)) {
    win32_console_putc(c, FWRITEBUFFER(fp));
    return c;
  }
  else
    return putc(c, fp);
}

static int in_buf = EOF;
BOOL kill_tex_f = FALSE;
static int console_eof_f = FALSE;

static int win32_console_getc(void)
{
  int c;
  if (console_eof_f || kill_tex_f)
    c = EOF;
  else if (in_buf == EOF) {
    win32_console_flush(FWRITEBUFFER(WIN32_STDOUT));
    win32_console_flush(FWRITEBUFFER(WIN32_STDERR));
    c = (*win32_dll_context->lpfCallback)(TeXDLL_CONSOLE_GET, 0, 0,
					  win32_dll_context->lpvCallbackData);
    if (c < 0) c = EOF;
  }
  else {
    c = in_buf;
    in_buf = EOF;
  }
  if (c == EOF) {
    console_eof_f = TRUE;
  }
  return c;
}

static void win32_console_ungetc(int c)
{
  if (c != EOF) {
    console_eof_f = FALSE;
    in_buf = c;
  }
}

int win32_getc(FILE* f)
{ return IS_DLL_INCONSOLE(f) ? win32_console_getc() : getc(f);
}

void win32_ungetc(int c,FILE* f)
{ IS_DLL_INCONSOLE(f) ? win32_console_ungetc(c) : ungetc(c,f);
}

char *win32_gets(char *buf, int len, FILE *f)
{
  if (IS_DLL_INCONSOLE(f)) {
    char *p = buf;
    while (--len > 0) {
      int c = win32_getc(f);
      if (c == EOF) {
	if (p == buf) return NULL;
	else break;
      }
      *p = c;
      if (*p == '\n') {
	p++;
	break;
      }
      p++;
    }
    *p++ = '\0';
    return buf;
  }
  else {
    return fgets(buf, len, f);
  }
}

void win32_flush(FILE *fp)
{
  if (IS_DLL_OUTCONSOLE(fp)) win32_console_flush(FWRITEBUFFER(fp));
  else
    fflush(fp);
}

int win32_feof(FILE *fp)
{
  if (win32_dll_context) {
    if (fp == WIN32_STDIN)
      return console_eof_f;
    else if (fp == WIN32_STDOUT || fp == WIN32_STDOUT)
      return FALSE;
  }
  return feof(fp);
}

long win32_tell(FILE *f)
{
  return ftell(f);
}

int win32_seek(FILE *f, long off, int org)
{
  return fseek(f,off,org);
}

BOOL win32_absolute_path(LPCSTR name)
{
  return (name[0] != '\\' && name[0] != '/' &&
	  (!isalpha(name[0]) || name[1] != ':' ||
	   (name[2] != '\\' && name[2] != '/')));
}

LPSTR win32_make_fullpath(LPCSTR name)
{
  if (win32_dll_context->lpszWorkDir &&
      win32_absolute_path(name)) { /* relative path */
    return win32_concat_filename(win32_dll_context->lpszWorkDir, name);
  }
  else {
    char full_path[1000];
    char* filePart;
    char* tmp_name;
    tmp_name = win32_unix2dos(win32_strdup(name));
    GetFullPathName(tmp_name, 1000, full_path, &filePart);
    win32_free(tmp_name);
    return win32_strdup(full_path);
  }
}

FILE* win32_fopen(const char* name, const char* mode)
{
  if (win32_dll_context) {
    BOOL write_mode = strchr(mode, 'w') ? TRUE : FALSE;
    LPSTR tmp_name = win32_make_fullpath(name);
    FILE* fp;
    (*win32_dll_context->lpfCallback)(TeXDLL_NOTIFY_FILE_OPEN, write_mode,
				      (DWORD)tmp_name,
				      win32_dll_context->lpvCallbackData);
    fp = fopen(tmp_name, mode);
    if (fp) {
      TeXFILE* pfile = win32_malloc(sizeof(TeXFILE));
      if (!pfile) return NULL;
      pfile->type = file_type_file;
      pfile->name = tmp_name;
      win32_unix2dos(pfile->name);
      pfile->file_no = fileno(fp);
      pfile->file.pFile = fp;
      pfile->next = open_file_list;
      open_file_list = pfile;
    }
    else win32_free(tmp_name);
    return fp;
  }
  else return fopen(name, mode);
}

FILE* win32_xfopen(const char* name, const char* mode)
{
  FILE *fp = win32_fopen(name, mode);
  if (fp == NULL) {
    win32_perror(name);
    win32_exit(1);
  }
  return fp;
}

int win32_fclose(FILE* fp)
{
  if (IS_DLL_INCONSOLE(fp) || IS_DLL_OUTCONSOLE(fp)) {
    return 0;
  }
  else if (win32_dll_context) {
    TeXFILE* pfile = open_file_list;
    TeXFILE* pfile_prev;
    while (pfile) {
      if (pfile->type == file_type_file && pfile->file.pFile == fp) {
	int code;
	if (pfile == open_file_list)
	  open_file_list = pfile->next;
	else
	  pfile_prev->next = pfile->next;
	code = fclose(fp);
	(*win32_dll_context->lpfCallback)(TeXDLL_NOTIFY_FILE_CLOSE, 0,
					  (DWORD)pfile->name,
					  win32_dll_context->lpvCallbackData);
	win32_free(pfile->name);
	win32_free(pfile);
	return code;
      }
      pfile_prev = pfile;
      pfile = pfile->next;
    }
  }
  else return fclose(fp);
}

void win32_fclose_all()
{
  if (win32_dll_context) {
    while (open_file_list)
      win32_fclose(open_file_list->file.pFile);
  }
}

void win32_perror(const char* str)
{
  if (str) win32_console_printf("%s: %s\n", str, strerror(errno));
  else win32_console_printf("%s\n", strerror(errno));
}

int win32_ferror(FILE *fp)
{
  if (IS_DLL_INCONSOLE(fp) || IS_DLL_OUTCONSOLE(fp))
    return 0;
  return ferror(fp);
}

BOOL win32_init_io(void)
{
  in_buf = EOF;
  open_file_list = NULL;
  console_eof_f = FALSE;
  kill_tex_f = FALSE;

  stdout_buffer.ptr = 0;
  stdout_buffer.mb_first = FALSE;
  stderr_buffer.ptr = 0;
  stderr_buffer.mb_first = FALSE;
  
  return TRUE;
}

void win32_uninit_io(void)
{
  win32_fclose_all();
}
