static CRITICAL_SECTION critical_section;

#define MESSAGE_WINDOW_CLASS_NAME_PREFIX "6048A3E1-A282-11d0-BAA0-FE0C77D16A5C"

#ifdef INTERRUPT_NEEDED
static BOOL register_message_window_class(HANDLE hModule)
{
  WNDCLASS wc;
  
  sprintf(msgWndClass, "TeXDLL." MESSAGE_WINDOW_CLASS_NAME_PREFIX
                       ".%08lx%08lx%08lx",
	  (ULONG)GetCurrentTime(),
	  (ULONG)GetCurrentThreadId(),
	  (ULONG)hModule);
  
  wc.style = CS_HREDRAW | CS_VREDRAW;
  wc.lpfnWndProc = msg_wnd_proc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = sizeof(LPTeXContext);
  wc.hInstance = GetModuleHandle(NULL);
  wc.hIcon = NULL;
  wc.hCursor = NULL;
  wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
  wc.lpszMenuName = msgWndClass;
  wc.lpszClassName = msgWndClass;
  
  return (RegisterClass(&wc) != 0);
}
#endif

BOOL APIENTRY DllMain(HANDLE hModule, 
		      DWORD ul_reason_for_call, 
		      LPVOID lpReserved)
{
  switch(ul_reason_for_call) {
  case DLL_PROCESS_ATTACH:
    InitializeCriticalSection(&critical_section);
    win32_init_module(hModule);
#ifdef INTERRUPT_NEEDED
    wm_texdll = RegisterWindowMessage(TeXDLL_WM_TEXDLL);
    msgWndClassRegistered = register_message_window_class(hModule);
#endif
    break;
  case DLL_PROCESS_DETACH:
#ifdef INTERRUPT_NEEDED
    if (msgWndClassRegistered)
      UnregisterClass(msgWndClass, GetModuleHandle(NULL));
#endif
    DeleteCriticalSection(&critical_section);
    break;
  }
  return TRUE;
}

#define main main_sub
#ifdef INTERRUPT_NEEDED
void main_sub(int, char**);
#else
int main_sub(int, char**);
#endif
#include <setjmp.h>

LONG main_internal(LPTeXContext pContext, LONG argc, LPSTR *argv)
{
  volatile int exit_code;
  extern jmp_buf win32_exit_jmp;
  
  if ((exit_code = setjmp(win32_exit_jmp)) != 0) {
    afterjob(pContext,exit_code);
    return exit_code > 0 ? exit_code-1 : exit_code; 
  }

  if (!beforejob(pContext)) uexit(1); 
#ifdef MF
  dll_init_mfscreen();
#endif
#ifdef INTERRUPT_NEEDED
  main_sub(argc, argv);
#else
  exit_code = main_sub(argc, argv);
  uexit(exit_code);
#endif
}

TeXDLL_EXPORT
LONG WINAPI TeXMain(HTeX hTeX, LONG ac, const char *av[])
{
  LPSTR *dupargv = malloc(sizeof(LPSTR)*ac);
  LPTeXContext pContext = hTeX;
  int i;
  for (i=0;i<ac;i++)
    dupargv[i] = strdup(av[i]);
  return main_internal(pContext, ac, dupargv);
}

TeXDLL_EXPORT
LONG WINAPI TeXVaMain(HTeX hTeX, LPCSTR name, ...)
{
  LPTeXContext pContext = hTeX;
  va_list va;
  int ac, i;
  char *arg;
  LPSTR *av;
  
  va_start(va, name);
  for (ac=1;arg=va_arg(va, char*);ac++)
    ;
  va_end(va);
  av = malloc(sizeof(LPCSTR)*ac);
  va_start(va, name);
  av[0] = strdup(name);
  for (i=1;i<ac;i++) {
    arg = va_arg(va, char*);
    av[i] = strdup(arg);
  }
  va_end(va);
  
  return main_internal(pContext, ac, av);
}

TeXDLL_EXPORT
LPCSTR WINAPI TeXGetLibraryFileName(void)
{
  return win32_module_filename();
}

static void destroy_internal_objects(LPTeXContext pContext)
{
#ifdef INTERRUPT_NEEDED
  if (pContext->hBgDoneEvent) CloseHandle(pContext->hBgDoneEvent);
  if (pContext->hMsgWnd) DestroyWindow(pContext->hMsgWnd);
#endif
  if (pContext->jobname) free(pContext->jobname);
  if (pContext->error_filename) free(pContext->error_filename);
  if (pContext->output_basename) free(pContext->output_basename);
  if (pContext->output_filename) free(pContext->output_filename);
  if (pContext->tfm_filename) free(pContext->tfm_filename);
  if (pContext->log_filename) free(pContext->log_filename);
}

TeXDLL_EXPORT
HTeX WINAPI TeXInitialize(LPFTeXCallbackProc callback,
			  LPVOID callback_data,
			  LPCSTR workdir)
{
  LPTeXContext pContext = NULL;
  BOOL code = TRUE;
  
  EnterCriticalSection(&critical_section);
  
  if (win32_init_main(callback, callback_data, workdir)) {
    pContext = malloc(sizeof(TeXContext));
    if (pContext) {
      pContext->pWin32Context = win32_dll_context;
      pContext->exit_code = 0;
      pContext->jobname = NULL;
      pContext->error_filename = NULL;
      pContext->output_filename = NULL;
      pContext->output_basename = NULL;
      pContext->tfm_filename = NULL;
      pContext->log_filename = NULL;
      pContext->hMsgWnd = NULL;
      pContext->hBgThread = NULL;
      
#ifdef INTERRUPT_NEEDED
      pContext->hInstance = GetModuleHandle(NULL);
      if (code) {
	pContext->hBgDoneEvent = CreateEvent(NULL, TRUE, FALSE, NULL);
	if (pContext->hBgDoneEvent == NULL)
	  code = FALSE;
      }
      if (code) {
	pContext->hBgThread =
	  (HANDLE)_beginthreadex(NULL, 0, background_thread, pContext, 0,
				 &pContext->idBgThread);
	if (pContext->hBgThread == NULL)
	  code = FALSE;
      }
      if (!code) {
	destroy_internal_objects(pContext);
	free(pContext);
	pContext = NULL;
      }
      else {
	WaitForSingleObject(pContext->hBgDoneEvent, INFINITE);
      }
#endif
    }
    if (pContext == NULL) {
      win32_uninit_main();
    }
  }
  
  if (pContext == NULL) {
    LeaveCriticalSection(&critical_section);
  }
  
  return pContext;
}

TeXDLL_EXPORT
void WINAPI TeXUninitialize(HTeX hTeX)
{
  LPTeXContext pContext = hTeX;
#ifdef INTERRUPT_NEEDED
  terminate_background_thread(pContext);
#endif
  destroy_internal_objects(pContext);
  free(pContext);
  
  win32_uninit_main();
  
  LeaveCriticalSection(&critical_section);
}

static char* pascalstr_copy(char* pascal_str)
{
  char* ptr = pascal_str;
  char* r;
  r = strdup(pascal_str+1);
  return r;
}

#if defined(TeX) || defined(MF) || defined(MP) || defined(BibTeX) || defined(GFtoDVI)
static char *strpool_copy(integer index)
{
#if defined(TeX)
  extern poolpointer *strstart;
  extern packedASCIIcode *strpool;
#elif defined(MF)
  extern poolpointer strstart[];
  extern packedASCIIcode strpool[];
#elif defined(MP)
  extern poolpointer *strstart;
  extern poolASCIIcode *strpool;
#else
  extern long strstart[];
  extern unsigned char *strpool;
#endif
  
  char buf[1024];
  int p;
  int s,e;
  if (index == 0) return NULL;
  
  s = strstart[index];
  e = strstart[index+1];
  p = 1;
  while (s < e) {
    buf[p++] = strpool[s++];
  }
  buf[p] = '\0';

  return pascalstr_copy(buf);
}
#endif
