#include <stdio.h>
#include <win32dll/texdll.h>
#include <win32dll/win32lib.h>
#include <win32dll/maketexlib.h>

#define MAKETEX_DLL "MakeTeX.dll"

int main(int argc, char **argv)
{
  BOOL code;
  LPCTSTR name;
  char filename[MAX_PATH + 1];
  HINSTANCE hMakeTeX;

  if (argc != 2) {
    fputs("Usage: MakeTeXTFM <FONT>\n", stderr);
    exit(1);
  }
  
  name = argv[1];
  
  hMakeTeX = win32_load_tex_library(MAKETEX_DLL);
  if (hMakeTeX) {
    LPFMakeTeXTFMProc Main;
    Main = (LPFMakeTeXTFMProc)GetProcAddress(hMakeTeX, "MakeTeXTFMMain");
    if (Main) {
      MakeTeXCallbackInfo* pInfo;
      pInfo = MakeTeXInitCallback(FALSE);
      if (pInfo) {
	code = Main(filename, MAX_PATH+1,
		    MakeTeXCallback, (LPVOID)pInfo, name);
	MakeTeXUninitCallback(pInfo);
	if (code) {
	  puts(filename);
	}
      }
    }
    else {
      fputs("MakeTeXTFMMain: Could not resolve the entry point.\n", stderr);
    }
    FreeLibrary(hMakeTeX);
  }
  else {
    fputs(MAKETEX_DLL ": Could not load.\n", stderr);
  }
  
  return 0;
}
