# paths.make -- installation directories.
#
# The compile-time paths are defined in kpathsea/paths.h, which is built
# from kpathsea/paths.h.in and these definitions.  See kpathsea/INSTALL
# for how the various path-related files are used and created.

# Do not change prefix and exec_prefix in Makefile.in!
# configure doesn't propagate the change to the other Makefiles.
# Instead, give the -prefix/-exec-prefix options to configure.
# (See kpathsea/INSTALL for more details.) This is arguably
# a bug, but it's not likely to change soon.
prefix = D:\PROGRA~1\TeX
exec_prefix = $(prefix)

# Architecture-dependent executables.
bindir = $(prefix)\bin\win32

# Architecture-independent executables.
scriptdir = $(bindir)

# Architecture-dependent files, such as lib*.a files.
libdir = $(prefix)\lib

# Architecture-independent files.
datadir = $(prefix)

# Header files.
includedir = $(prefix)\include

# GNU .info* files.
infodir = $(prefix)\info

# Unix man pages.
manext = 1
mandir = $(prefix)\man\man$(manext)

# TeX system-specific directories. Not all of the following are relevant
# for all programs, but it seems cleaner to collect everything in one place.

# The default paths are now in kpathsea/paths.h.in. Passing all the
# paths to sub-makes can make the arg list too long on system V.

# The root of the main tree.
texmf = $(datadir)\texmf

# Regular input files.
texinputdir = $(texmf)\tex
mfinputdir = $(texmf)\mf
mpinputdir = $(texmf)\mp
mftinputdir = $(texmf)\mft

# dvips's epsf.tex, rotate.tex, etc. get installed here;
# ditto for dvilj's fonts support.
dvips_plain_macrodir = $(texinputdir)\plain\dvips
dvilj_latex2e_macrodir = $(texinputdir)\latex\dvilj

# MakeTeXPK.site, texmf.cnf, etc.
web2cdir = $(texmf)\web2c

# The top-level font directory.
fontdir = $(texmf)\fonts

# Memory dumps (.fmt/.base/.mem).
fmtdir = $(web2cdir)
basedir = $(fmtdir)
memdir = $(fmtdir)

# Pool files.
texpooldir = $(web2cdir)
mfpooldir = $(texpooldir)
mppooldir = $(texpooldir)

# Where the .map files from fontname are installed.
fontnamedir = $(texmf)\fontname

# For dvips configuration files, psfonts.map, etc.
dvipsdir = $(texmf)\dvips

# For dvips .pro files, gsftopk's render.ps, etc.
psheaderdir = $(dvipsdir)

# If a font can't be found close enough to its stated size, we look for
# each of these sizes in the order given.  This colon-separated list is
# overridden by the envvar TEXSIZES, and by a program-specific variable
# (e.g., XDVISIZES), and perhaps by a config file (e.g., in dvips).
# This list must be sorted in ascending order.
default_texsizes = 300:600

# End of paths.make.

# Local Variables:
# mode: Makefile
# End: