/* callback.c: for Win32 DLL
    Micorsoft Visual C++ Version 4.0
*/

#include <kpathsea/config.h>
#include <stdio.h>
#include <stdarg.h>

#define INFO_SIZE 2

#define KpseConsoleWrite(param1, param2, param3) \
    callback(KPSE_CONSOLE_WRITE, (DWORD)param1, (DWORD)param2, param3)
#define KpseConsoleFlush(param3) \
    callback(KPSE_CONSOLE_FLUSH, 0, 0, param3)
#define KpseTerminate(status, param3) \
    callback(KPSE_TERMINATE, status, 0, param3)

int fprintf(FILE *stream, const char *format, ...)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  va_list argptr;
  int ret;
  long callback_ret = 0;

  va_start(argptr, format);
  if (callback && (stream == stderr || stream == stdout)) {
    while (1) {
      ret = _vsnprintf(msgbuf, msglen, format, argptr);
      if (ret == -1) {
        msglen += MAX_PATH;
        msgbuf = xrealloc(msgbuf, msglen);
        continue;
      }
      break;
    }
    if (ret > 0)
      callback_ret = KpseConsoleWrite(msgbuf, ret, usr_param);
  }
  if (!callback || !callback_ret)
    ret = vfprintf(stream, format, argptr);

  return ret;
}

int fputs(const char *str, FILE *stream)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  int ret;
  long callback_ret = 0;
#undef fputs
  strncat(msgbuf, str, msglen);
  if (callback && (stream == stderr || stream == stdout)) {
    ret = strlen(str);
    callback_ret = KpseConsoleWrite(str, ret, usr_param);
  }
  if (!callback || !callback_ret)
    ret = fputs(str, stream);

  return ret;
}

int putc(int c, FILE *stream)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  int ret = c;
  long callback_ret = 0;
#undef putc
  sprintf(msgbuf, "%c", c);
  if (callback && (stream == stderr || stream == stdout)) {
    callback_ret = KpseConsoleWrite(msgbuf, 1, usr_param);
  }
  if (!callback || !callback_ret)
    ret = putc(c, stream);
  msgbuf[0] = '\0';

  return ret;
}

int fflush(FILE *stream)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  int ret;
  long callback_ret = 0;
#undef fflush
  if (callback && (stream == stderr || stream == stdout)) {
    callback_ret = KpseConsoleFlush(usr_param);
  }
  if (!callback || !callback_ret)
    ret = fflush(stream);
  msgbuf[0] = '\0';

  return ret;
}

void perror(const char *str)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  long callback_ret = 0;
#undef perror
  strncpy(msgbuf, _strerror(str), msglen);
  if (callback) {
    callback_ret = KpseConsoleWrite(msgbuf, strlen(msgbuf), usr_param);
  }
  if (!callback || !callback_ret)
    perror(str);
}

void exit(int status)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  DWORD info[INFO_SIZE] = {(DWORD)msgbuf, (DWORD)usr_param};
#undef exit
  if (callback) {
    KpseTerminate(status, usr_param);
  }
  RaiseException((3<<30)|(1<<29)|('K'<<16)|status,
      EXCEPTION_NONCONTINUABLE, INFO_SIZE, info);
  exit(status);
}

void abort(void)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  static const char msg[] = "abnormal program termination";
  DWORD info[INFO_SIZE] = {(DWORD)msgbuf, (DWORD)usr_param};
#undef abort
  if (callback) {
    KpseConsoleWrite(msg, strlen(msg), usr_param);
    KpseTerminate(3, usr_param);
  }
  RaiseException((3<<30)|(1<<29)|('K'<<16)|3,
      EXCEPTION_NONCONTINUABLE, INFO_SIZE, info);
  exit(3);
}

void kpse_set_callback(KpseCallBack *func, DWORD param)
{
  kpse_context_type *kpse_context = TlsGetValue(g_dwTlsIndex);
  callback = func;
  usr_param = param;
}
