#include <stdio.h>

char table[256][5];
void init_table(void)
{
  int i;
  for (i=0;i<256;i++) {
    table[i][0] = i/100 ? i/100+'0' : ' ';
    table[i][1] = i/10 ? (i/10)%10+'0' : ' ';
    table[i][2] = i%10+'0';
    table[i][3] = ',';
    table[i][4] = '\0';
  }
}

int do_file(FILE *fp)
{
  int i=0;
  for ( ; ; ) {
    int c = getc(fp);
    if (c == EOF) break;
    fputs(table[c],stdout);
    if (i == 15) { i = 0; putc('\n',stdout); }
    else i++;
  }
  if (i) putc('\n',stdout);
  return 0;
}

int main(int argc,char **argv)
{
  FILE *fp;
  if (argc != 2) {
    fputs("Usage: bin2c <filename>",stderr);
    exit(1);
  }
  init_table();
  fp = fopen(argv[1],"rb");
  if (fp == NULL) { perror(argv[1]); exit(1); }
  do_file(fp);
  fclose(fp);
  return 0;
}
