#include <stdio.h>
#include <malloc.h>
#include <string.h>
#include <process.h>

#ifdef pTeX
#  define VIRTEX "virptex"
#  define FMT ".fmt"
#else
#  ifdef TeX
#    define VIRTEX "virtex"
#    define FMT ".fmt"
#  else
#    ifdef MF
#      define VIRTEX "virmf"
#      define FMT ".base"
#    else
#      error !!! unexpected
#    endif
#  endif
#endif

#define Strrchr strrchr

void *xmalloc(unsigned int );

int main(int argc,char *argv[])
{
  char *p,*q;
  char *prog;
  char *fmt;
  char **cargv;
  int cargc;
  int i;
  
  prog = xmalloc(strlen(argv[0])+10);
  strcpy(prog,argv[0]);
  p = Strrchr(prog,'\\');
  q = Strrchr(prog,'/');
  if (q > p) p = q;
  if (p == NULL) p = prog;
  else p++;
  fmt = xmalloc(strlen(p)+10);
  strcpy(fmt+1,p);
  fmt[0] = '&';
  strcpy(p,VIRTEX);
  p = Strrchr(fmt,'.');
  if (p == NULL) p = fmt + strlen(fmt);
  strcpy(p,FMT);

  cargv = xmalloc(sizeof(char *)*(argc+4));
  cargv[0] = prog;
  cargv[1] = fmt;
  for (i=1;i<argc;i++)
    cargv[i+1] = argv[i];
  cargv[i+1] = NULL;

  return spawnvp(P_WAIT,cargv[0],cargv);
}

void *xmalloc(unsigned int s)
{ void *p = malloc(s);
  if (p == NULL) {
    fputs("Memory exhausted.\n",stderr);
    exit(1);
  }
  return p;
}
