@echo off
if "%1"=="" goto arg_err
if not "%3"=="" goto arg_err
for %%s in (vc2 djgpp-v1 djgpp-v2 djgpp-lfn) do if "%%s"=="%1" goto start
goto uk_sys

:start
if not exist w2ckpa26.hlp goto no_webp
if not exist ..\kpse-2.6\nul goto no_kpse
if not exist ..\ptex-src\nul goto no_asc

echo Starting setup for `%1'.

if "%1"=="vc2" goto no_fix
if "%1"=="djgpp-lfn" goto no_fix
echo Fixing filenames in patches.
sed "/^[-*][-*][-*]/s/\([^ 	][^ 	]*\)\.\([^ 	.][^ 	.]*\)\.in/\1_\2.in/" <w2ckpa26.hlp>kpse-2.6\w2ckpa26.hlp
sed "/^[-*][-*][-*]/s/\([^ 	][^ 	]*\)\.\([^ 	.][^ 	.]*\)\.in/\1_\2.in/" <..\ptex-src\ptex.patch>kpse-2.6\ptex.patch
goto end_fix
:no_fix
for %%f in (w2ckpa26.hlp ..\ptex-src\ptex.patch) do copy /b %%f kpse-2.6
:end_fix

echo Copying TeX sources for pTeX.
if not exist ..\kpse-2.6\web2c\ptex\nul mkdir ..\kpse-2.6\web2c\ptex>nul
xcopy /e/s ..\kpse-2.6\web2c\tex ..\kpse-2.6\web2c\ptex>nul

echo Copying pTeX sources.
xcopy /e/s ..\ptex-src\web2c ..\kpse-2.6\web2c>nul

echo Copying additional files for MS-DOS.
xcopy /e/s .\kpse-2.6 ..\kpse-2.6>nul

echo Copying additional files for %1.
xcopy /e/s .\%1 ..\kpse-2.6>nul

echo Entering the directory ../kpse-2.6.
chdir ..\kpse-2.6

echo Applying patch for kpathsea 2.6.
patch -p -s <w2ckpa26.hlp
echo Applying patch for pTeX.
patch -p -s <ptex.patch
echo Applying patch for DJ's GPP.
patch -p -s <dj-kpse.diff
patch -p -s <dj-web2c.diff
patch -p -s <dj-ptex.diff
echo {touch}>>web2c\web\tanglebo.p

echo Set kanji code to Shift JIS (library).
chdir web2c\lib
if "%1"=="vc2" goto lfn_kh
if "%1"=="djgpp-lfn" goto lfn_kh
sed -e s/output-kanji-code/SJIS/ -e s/internal-kanji-code/SJIS/ kanji_h.in > kanji.h
goto end_kh
:lfn_kh
sed -e s/output-kanji-code/SJIS/ -e s/internal-kanji-code/SJIS/ kanji.h.in > kanji.h
:end_kh
chdir ..\..

echo Set kanji code to Shift JIS (pTeX).
chdir web2c\ptex
echo /^#ifndef JPN/,/^#else JPN/d; /^#ifdef JPN/d; /^#endif JPN/d>temp.sed
echo /^#ifdef EUC/,/^#endif EUC/d; /^#ifdef SJIS/d; /^#endif SJIS/d; s/output-kanji-code/SJIS/>>temp.sed
sed -f temp.sed ptex.chg > tex.ch
del temp.sed>nul
chdir ..\..

echo Set kanji code to Shift JIS (pltotf, tftopl).
chdir web2c\fontutil
sed -e s/output-kanji-code/SJIS/ pltotf.chg > pltotf.ch
sed -e s/output-kanji-code/SJIS/ tftopl.chg > tftopl.ch
chdir ..\..

echo Done.

echo Leaving directory ..\kpse-2.6
chdir ..\djptex-1.1
goto ex

:uk_sys
echo Unknown system type `%1'.
goto arg_err

:arg_err
echo Usage: setup "system-type"
echo System type:
echo   djgpp-v1   DJ's GPP version 1.12 (MS-DOS)
echo   djgpp-v2   DJ's GPP version 2.00 (MS-DOS)
echo   djgpp-lfn  DJ's GPP version 2.00 (Win95 Long File Name)
echo   vc2        Visual C++ 2.0 (Win95 Long File Name)
goto ex

:no_webp
echo File w2ckpa26.hlp (web2c.kpathsea-2.6.help) does not exist.
goto ex

:no_ascd
echo Directory ..\ptex-src does not exist.
echo Note:
echo   You must rename the directory of the source codes of original pTeX
echo ("ptex-2.1.4" etc.) to "ptex-src".
goto ex

:no_kpse
echo Directory ..\kpse-2.6 (../kpathsea-2.6) does not exist.
goto ex

:ex
