#include <stdio.h>
#include <stdlib.h>

extern char *vtfmname;
extern int unit,zw,jfm_id;

FILE *vfopen(name)
char *name;
{
	FILE *fp;

	fp = fopen(name,"w");
	if (fp == NULL) {
		fprintf(stderr,"I cannot create VF file, %s.",name);
		exit(-1);
	}

	fputc(247,fp); /* PRE */
	fputc(202,fp); /* ID */
	fputc(0,fp); /* comment size */
	fputnum(0,4,fp); /* TFM check sum */
	fputnum(10*(1<<20),4,fp); /* TFM design size */

	fputc(243,fp); /* fnt_def1 */
	fputc(1,fp); /* Font ID */
	fputnum(0,4,fp); /* TFM check sum */
	fputnum(zw,4,fp); /* font design size (scaled) */
	fputnum(10*(1<<20),4,fp); /* font design size */
	fputc(0,fp); /* directory length */
	fputc(strlen(vtfmname),fp); /* fontname length */
	fputstr(vtfmname,strlen(vtfmname),fp); /* directory + fontname */

	return fp;
}

writevf(code,fp)
int code;
FILE *fp;
{
	int w,skip=0;

	w = jfmread(code);

	fputc(242,fp); /* long_char */

	switch (code) {
	case 0x2146: /*  */
	case 0x2148: /*  */
	case 0x214a: /*  */
	case 0x214c: /*  */
	case 0x214e: /*  */
	case 0x2150: /*  */
	case 0x2152: /*  */
	case 0x2154: /*  */
	case 0x2156: /*  */
	case 0x2158: /*  */
	case 0x215a: /*  */
		skip = -(zw-w);
		fputnum(3+1+numcount(skip),4,fp);
		break;
	case 0x2121: /* spc */
	case 0x2122: /*  */
	case 0x2123: /*  */
	case 0x2124: /*  */
	case 0x2125: /*  */
	case 0x212b: /*  */
	case 0x212c: /*  */
	case 0x2147: /*  */
	case 0x2149: /*  */
	case 0x214b: /*  */
	case 0x214d: /*  */
	case 0x214f: /*  */
	case 0x2151: /*  */
	case 0x2153: /*  */
	case 0x2155: /*  */
	case 0x2157: /*  */
	case 0x2159: /*  */
	case 0x215b: /*  */
	case 0x216b: /*  */
	case 0x216c: /*  */
	case 0x216d: /*  */
		fputnum(3,4,fp);
		break;
	default:
		if (w != zw) {
			skip = -(zw-w)/2;
			fputnum(3+1+numcount(skip),4,fp);
		}
		else {
			fputnum(3,4,fp);
		}
		break;
	}

	fputnum(code,4,fp); /* char code */
	fputnum(w,4,fp); /* char width */
	if (skip != 0) {
		fputc(143+numcount(skip)-1,fp); /* RIGHT */
		fputnum2(skip,fp);
	}
	fputc(129,fp); /* SET2 */
	fputnum(code,2,fp); /* char code */
}

int vfclose(fp)
FILE *fp;
{
	int i,cc;

    cc = ftell(fp);
    for (i = 0 ; i < 4-(cc%4) ; i++) {
        fputc(248,fp); /* POST */
	}
	fclose(fp);
}

int maketfm(name)
char *name;
{
	char nbuf[256];
	FILE *fp;

	strcpy(nbuf,name);
	strcat(nbuf,".tfm");
	fp = fopen(nbuf,"w");
	if (fp == NULL) {
		fprintf(stderr,"I cannot create TFM file, %s.",name);
		exit(-1);
	}

	fputnum(jfm_id,2,fp); /* JFM ID */
	fputnum(1,2,fp); /* number of char type */
	fputnum(27,2,fp); /* file words */
	fputnum(2,2,fp); /* header words */
	fputnum(0,2,fp); /* min of char type */
	fputnum(0,2,fp); /* max of char type */
	fputnum(2,2,fp); /* width words */
	fputnum(2,2,fp); /* height words */
	fputnum(2,2,fp); /* depth words */
	fputnum(1,2,fp); /* italic words */
	fputnum(0,2,fp); /* glue/kern words */
	fputnum(0,2,fp); /* kern words */
	fputnum(0,2,fp); /* glue words */
	fputnum(9,2,fp); /* param words */

	fputnum(0,4,fp); /* check sum */
	fputnum(10*(1<<20),4,fp); /* design size */

	fputnum(0,2,fp); /* char code */
	fputnum(0,2,fp); /* char type */

	fputnum((1<<24)+(1<<20)+(1<<16),4,fp); /* char info */
	fputnum(0,4,fp); /* width */
	fputnum(1<<20,4,fp); /* width */
	if (jfm_id == 11) {
		fputnum(0,4,fp); /* height */
		fputnum((int)((1<<20)*0.9),4,fp); /* height */
		fputnum(0,4,fp); /* depth */
		fputnum((1<<20)-(int)((1<<20)*0.9),4,fp); /* depth */
	}
	else {
		fputnum(0,4,fp); /* height */
		fputnum(1<<19,4,fp); /* height */
		fputnum(0,4,fp); /* depth */
		fputnum(1<<19,4,fp); /* depth */
	}
	fputnum(0,4,fp); /* italic */

	fputnum(0,4,fp); /* tan */
	fputnum(0,4,fp); /* kanjiskip */
	fputnum(0,4,fp); /* +kanjiskip */
	fputnum(0,4,fp); /* -kanjiskip */
	fputnum(1<<20,4,fp); /* zh */
	fputnum(1<<20,4,fp); /* zw */
	fputnum(0,4,fp); /* xkanjiskip */
	fputnum(0,4,fp); /* +xkanjiskip */
	fputnum(0,4,fp); /* -xkanjiskip */

	fclose(fp);
}
