/* go32func.c */
#include <sys/types.h>
#include <go32.h>
#include <dpmi.h>
#include <dos.h>
#include <stdio.h>

extern int _go32_machine_type;
extern volatile int interrupt;

static void ctrl_break_isr(_go32_dpmi_registers *regs)
{
  interrupt = 1;
}

typedef struct {
	int vector;
	int hooked;
	int isr;
	_go32_dpmi_seginfo old_vector,new_vector;
} interrupt_info;

static interrupt_info pc98_interrupt_vector_list[] = {
	{ 0x06,0,(int)ctrl_break_isr },
	{ 0x23,0,(int)ctrl_break_isr },
};
#define PC98_INTERRUPT_VECTOR_LIST_COUNT \
	(sizeof(pc98_interrupt_vector_list)/sizeof(interrupt_info))

static interrupt_info pcat_interrupt_vector_list[] = {
	{ 0x1b,0,(int)ctrl_break_isr },
	{ 0x23,0,(int)ctrl_break_isr },
};
#define PCAT_INTERRUPT_VECTOR_LIST_COUNT \
	(sizeof(pcat_interrupt_vector_list)/sizeof(interrupt_info))

static interrupt_info default_interrupt_vector_list[] = {
	{ 0x23,0,(int)ctrl_break_isr },
};
#define DEFAULT_INTERRUPT_VECTOR_LIST_COUNT \
	(sizeof(default_interrupt_vector_list)/sizeof(interrupt_info))

static int interrupt_vector_list_count = 0;
static interrupt_info *interrupt_vector_list = NULL;
static _go32_dpmi_registers regs;

void go32_catch_interrupt(void)
{
	int i;
	union REGS r;

	switch (_go32_machine_type>>4) {
	case 0:
		interrupt_vector_list_count = PCAT_INTERRUPT_VECTOR_LIST_COUNT;
		interrupt_vector_list = pcat_interrupt_vector_list;
		break;
	case 1:
		interrupt_vector_list_count = PC98_INTERRUPT_VECTOR_LIST_COUNT;
		interrupt_vector_list = pc98_interrupt_vector_list;
		break;
	default:
		interrupt_vector_list_count = DEFAULT_INTERRUPT_VECTOR_LIST_COUNT;
		interrupt_vector_list = default_interrupt_vector_list;
		break;
	}

	for (i=0;i<interrupt_vector_list_count;i++) {
	    if (!interrupt_vector_list[i].hooked) {
		    _go32_dpmi_get_real_mode_interrupt_vector(
					interrupt_vector_list[i].vector,
					&interrupt_vector_list[i].old_vector);
		    interrupt_vector_list[i].new_vector.pm_offset =
				interrupt_vector_list[i].isr;
		    _go32_dpmi_allocate_real_mode_callback_iret(
					&interrupt_vector_list[i].new_vector,&regs);
		    _go32_dpmi_set_real_mode_interrupt_vector(
					interrupt_vector_list[i].vector,
					&interrupt_vector_list[i].new_vector);
		    interrupt_vector_list[i].hooked = 1;
		}
	}

    r.x.ax = 0x3301;
    r.h.dl = 0;
    intdos(&r,&r);

    interrupt = 0;
}

void go32_reset_interrupt(void)
{
	int i;
    if (interrupt_vector_list == NULL)
      return;

	for (i=0;i<interrupt_vector_list_count;i++) {
	    if (interrupt_vector_list[i].hooked) {
		    _go32_dpmi_set_real_mode_interrupt_vector(
    			interrupt_vector_list[i].vector,
				&interrupt_vector_list[i].old_vector);
		    _go32_dpmi_free_real_mode_callback(
				&interrupt_vector_list[i].new_vector);
		    interrupt_vector_list[i].hooked = 0;
		}
	}
    interrupt = 0;
	interrupt_vector_list = NULL;
}
