/* 
  pm4epm.e
  Routines by PM (Petr Mikulik) for EPM --- pm_command family: commands 
  with expansion dependent on the currently edited file or its master.

  This file belongs to the "pmCSTeX for EPM" package, see 
    http://www.sci.muni.cz/~mikulik/os2/pmCSTeX.html
  or pmcstex.zip on hobbes, leo and CTAN archives.

  Copyright  1996  Petr Mikulik
  -----------------------------
  License: free-latex     distributed under the same terms as LaTeX
  This program can be redistributed and/or modified under the terms
  of the LaTeX Project Public License Distributed from CTAN
  archives in directory macros/latex/base/lppl.txt; either
  version 1 of the License, or any later version.
 
  License meaning in short: use and distribution permitted, like any 
  freeware. Package must be distributed together with the source code. 
  Reuse of the source code or any part of it is allowed. Any changes or
  enhancement to this package must involve a change of name unless these
  changes are accepted by the author. You are welcome to submit your 
  bugfixes, updates or new features.
    Because the program is licensed free of charge, there is no warranty 
  for any of its component. You are responsible for any software, hardware, 
  human or nature disaster resulting from installing and using of this 
  package.


  Author's address:
  -----------------
  Petr Mikulk
  Department of Solid State Physics 
    and Laboratory of Thin Films and Nanostructures
  Faculty of Science
  Kotlarska 2 (Kotl\'a\v rsk\'a 2)
  Masaryk University
  Brno
  Czech Republic

  mikulik@physics.muni.cz
  http://www.sci.muni.cz/~mikulik/


  History:
  --------
  Support &%latex format syntax: 2.4.2000
  Update for MakeIndex options: 13.4.1997
  Update for master file to be
  firstly searched in the 
  directory of the working file:
				 4.1.1997, 15.1.1997, 11.2.1997
  Update for emtex options:	17.5.1996
  Update for dvips options:	15.5.1996
  Original version:		20.2.1996
 */


/* 
USAGE: I use this macro file for actions on the EPM toolbar, and in the package 
CSTeX that implements menu for many (La)TeX related commands.

INSTALLATION: 
  1. cite this file (pm4epm) in the  actions.lst  file
  2. write  'link pm4epm'  into your Profile.erx

COMMANDS DEFINED HERE:
 pm_expand		- expands the string and then executes it
 pm_command_os2 	- expands the string and runs it as os2 program
 pm_command_os2fs	- expands the string and runs full-screen os2 program
 pm_command_cmd  	- expands the string and runs it through cmd
 pm_command_pm  	- expands the string and runs it (only START)
 pm_command_dos 	- expands the string and runs it as dos program
 pm_command_dosfs	- expands the string and runs full-screen dos program
 etc. 

The expansion depends on the edited file (currently active file in the editor). 

SYNTAX of pm_expand WITH EXAMPLE: work file is e:\tmp\a.tex => 

Syntax	  Internal Variable	Explanation			Example
%w	  EFname		work file name  		a
%.w	  EFext     		work file extension		tex
%W	  EFwholename    	full name without extension	e:\tmp\a
%.W	  EF			full name			e:\tmp\a.tex

Note: pm_expansion('%.W') equals .filename

The same holds for the Master file specified by the MASTER: key (see below):
%m     %.m   %M   %.M

Both types written in the Unix format (i.e. backslahes replaced by slashes): 
%x %.x %X %.X	for the work file      e.g.  %.X = e:/tmp/a.tex
%n %.n %N %.N	for the master file

%h MFdrive		drive of the master file (e:)
%d MainDirectory	directory of the master file (\tmp)
%D XMainDirectory	directory in the Unix format (/home/petr/tex)

Key specifications: 
The work file can have some of the following keyword written on its first line. 
They are expanded as well according to this rules:

Syntax     Internal Variable	Introducing key word	If key not specified
%master 	MF		  Master:		   MF := EF
%format     TheFormat   	Format:  		 envir. var. TEXFORMATDEFAULT 
							 of "latex"
%etc	   TheEtc		Etc:			empty string
%orient   TheOrient		Orientation:		empty string
%choice   TheChoice		Choice:  		empty string

Synonym to the 'Format: myformat' is '%&myformat' starting the command line; 
this allows to accept cweb/unix (?) style of format determination.

The following are expanded as verbatims, e.i. from the first char occuring after 
the key to the next same char:
%opts				Opts:			empty string
%viewopts			ViewOpts:		empty string
%optsdvips			dvips:			empty string
%optsemtex			EmtexOpt:		empty string
%optsmakeindex		makeindex:		empty string

The syntax $(Name) expands environmental variable Name


*** Example 1 ***
We edit file E:\TEXT\FERDA.TEX having the first line
% Master: SEKORA.TEX  Format: latex209  Choice: none

Then commands are expanded:
"copy %.W %W.old"		=> "copy E:\TEXT\FERDA.TEX E:\TEXT\FERDA.old"
"type %w%.w"    		=> "type FERDA.TEX"
"%format.cmd %.N"		=> "latex209.cmd E:/TEXT/SEKORA.TEX"
"echo %choice *%etc*"   	=> "echo none **"

*** Example 2 ***
We edit file E:\TEXT\BROUK.TEX having the first line
% ViewOpts: +/tr1 /m1440+ Etc: does not exist Opts: =any other=
"start cmd /c cykl %.W %format.cmd %N" =>
   "start cmd /c cykl E:\TEXT\BROUK.TEX latex.cmd E:/TEXT/BROUK"
"start /fs dviscr %viewopts %M.dvi" =>
  "start /fs dviscr /tr1 /m1440 e:\text\brouk.dvi"

*/

include 'stdconst.e'


/************************ CONSTANTS *********************************/

const

 PM_STARTos2   = 'start /C /WIN '
 PM_STARTos2fs = 'start /C /FS '
 PM_STARTcmd   = 'start /C /WIN cmd /c '
 PM_STARTpm    = 'start '
 PM_STARTdos   = 'start /C /WIN /DOS command.com /c '
 PM_STARTdosfs = 'start /C /FS /DOS command.com /c '

/* Message strings */

 pm_expand_inf = "Expand command with: Work file: %w (name) %.w (ext) %W (path\name) %.W (full name); Main drive:\dir %d; 'MASTER:' file: %m %.m %M %.M; 'FORMAT:' %format 'ORIENTATION:' %orient; 'ETC:' %etc; 'CHOICE:' %choice; Verbatims: 'EMTEXOPT:' %optsemtex; 'DVIPS:' %optsdvips; 'VIEWOPTS:' %viewopts; 'OPTS:' %opts"
 pm_command_os2_inf = "Expand command line (as pm_expand) and execute OS/2 exe program"
 pm_command_os2fs_inf = "Expand command line (as pm_expand) and execute full-screen OS/2 exe program"
 pm_command_cmd_inf = "Expand command line (as pm_expand) and execute .cmd file"
 pm_command_pm_inf = "Expand command line (as pm_expand) and execute Prezentation Manager program"
 pm_command_dos_inf = "Expand command line (as pm_expand) and execute dos exe program"
 pm_command_dosfs_inf = "Expand command line (as pm_expand) and execute dos exe program (full screen)"


/* The following command adds the action commands to the list */

DEFINIT
  universal pm4epm_MasterNotFound

DEFC pm4epm_actionlist
universal ActionsList_FileID

 insertline 'pm_expand'pm_expand_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_cmd'pm_command_cmd_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_os2'pm_command_os2_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_os2fs'pm_command_os2fs_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_pm'pm_command_pm_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_dos'pm_command_dos_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID
 insertline 'pm_command_dosfs'pm_command_dosfs_inf'pm4epm',ActionsList_FileID.last+1,ActionsList_FileID



/*************************** ROUTINES ******************************/

DEFPROC PM_GetNextWord ( WhichWord, line, uline )
-- routine returns the next word after the keyword  WhichWord  or  WhichWord:
i = wordpos(WhichWord,uline)
if i=0 then i = wordpos(WhichWord':',uline) endif
if i=words(uline) then i=0; TheWord='' endif
if i<>0 then TheWord=word(line,i+1)
         else TheWord='' 
         endif
return TheWord


DEFPROC PM_GetNextWordOptions ( WhichWord, line, uline )
-- routine scans for WhichWord. The first char of the next word as taken as the 
-- key char. Then line is copied to TheOpts until the next key char appears. 
-- This is similar to \verb*TheOpts...* in LaTeX
i = wordpos(WhichWord,uline)
if i=0 then i = wordpos(WhichWord':',uline) endif
if i=words(uline) then i=0; TheOpts='' endif
if i<>0 
  then TheOpts=subword(line,i+1,words(line)-i)
	KeyChar=substr(TheOpts,1,1); TheOpts=delstr(TheOpts,1,1)
	i=pos(KeyChar,TheOpts)
	if (i<>0) then TheOpts=substr(TheOpts,1,i-1) endif
  else TheOpts=''
  endif
return TheOpts


DEFPROC PM_SubstKeys ( TheCommand, TheKey, ByWhat )
-- routine substitutes TheKey strings by ByWhat strings in TheCommand
i = pos(TheKey,TheCommand)
do while (i<>0)
   l = length(TheKey)
   TheCommand = substr(TheCommand,1,i-1)ByWhat''substr(TheCommand,i+l,length(TheCommand)-i-l+1)
   i = pos(TheKey,TheCommand)
   end
return TheCommand


DEFPROC PM_SubstEnvironment ( TheCommand )
-- routine substitutes the environmental variables (like $(PATH)) within TheCommand
i = pos('$(',TheCommand)
do while (i<>0)
   e = substr(TheCommand,i+2,length(TheCommand)-i-2)
   TheCommand = substr(TheCommand,1,i-1)
   i = pos(')',e)
   if i>0 
     then TheCommand=TheCommand''get_env(substr(e,1,i-1))''substr(e,i+1,length(e)-i-1)
     else TheCommand=TheCommand''get_env(substr(e,1,length(e)))
   endif
   i = pos('$(',TheCommand)
   end
return TheCommand


DEFPROC save_the_ring() =
n = filesinring()
for i = 1 to n
  if .modify then call savefile(.filename); endif
  nextfile
  endfor
return

DEFPROC InfoBox( title, text) = --Information box 
call WinMessageBox( title, text, MB_OK + MB_MOVEABLE + MB_INFORMATION )
return

/* ErrorBox */
DEFPROC ErrorBox( title, text) =
Beep(440, 133)
call WinMessageBox( title, text, MB_OK + MB_MOVEABLE + MB_ERROR )
return

/* Debug box */
DEFPROC DebugBox( text ) =
call WinMessageBox( 'Debugging', text, MB_OK + MB_MOVEABLE + MB_NOICON )
return

/* Split file name into parts. Taken from ZWepmTeX.e by Z. Wagner */
DEFPROC split_file_name(var drive, var path, var base, var ext, filespec) =
fn = strip(filespec)
if substr(fn, 2, 1) = ':' then
  drive = substr(fn, 1, 2)
  fn = substr(fn, 3)
else drive = ''
endif
dotpos = lastpos('.', fn)
bspos = lastpos('\', fn)
if dotpos <= bspos then dotpos = length(fn) + 1; endif
path = substr(fn, 1, bspos)
base = substr(fn, bspos+1, dotpos-bspos-1)
ext = substr(fn, dotpos)
return

/**************************** DEFINE pm_command **********************/

DEFPROC pm_expansion ( TheCommand )
  universal pm4epm_MasterNotFound;

/* Read the first line of the current file in order to find Main file */
EF = .filename; MF = ''; 
TheFormat=''; TheEtc=''; TheOrient=''; TheChoice=''; 
TheOpts=''; TheViewOpts=''; TheDvips=''; TheEmtexOpt=''; TheMakeindex=''
pm4epm_MasterNotFound=0 -- clear toggle

/*** Analysis of the first line of the current file ***/

/* search Master or Master: ; result goes to MF */

getline line, 1
uline = translate(line)  -- uppercase
--  parse value uline with . 'MASTER' ':' MF .    -- this would not be case sensitive

-- oh... REXX has MFdrive = filespec("Drive",MF), but E not ! 
call split_file_name(EFdrive, EFdir, EFname, EFext, EF)

MF=PM_GetNextWord('MASTER',line,uline)
if MF=''
  then MF=.filename; MFisEF=1
  else 
    MFisEF=0; MF = translate(MF,'\','/') -- convert from the unix format
  endif

-- the following deals with the case when user specifies only file name
-- It works with absolute path, but not with relative paths having ..\
MFwholename='' -- MFwholename is now used temporarily
if pos('\',MF)=0 then
  if already_in_ring(MF,n) then  -- suggestion by kroni@bite.shnet.org, 16.5.1996
      MF=n.filename
    else
      i=pos(':',MF); if i>0 then MF=substr(MF,i+1,length(MF)-i); endif
      MFwholename=EFdrive''EFdir''MF
      if exist(MFwholename)
	then -- look firstly for the master at the working file's directory
	  MF=MFwholename
	else -- no drive letter if specified MF=directory()'\'MF; 
	  MF=directory()'\'MF
	endif
    endif
  endif

if not exist(MF) then 
	-- beep(444,222); sayerror 'Master file 'MF' not found!'
	if ( (MFwholename='') or (translate(MFwholename)=translate(MF)) )
	  then ErrorBox('Error','Master file 'MF' not found!')
	  else ErrorBox('Error','Master file 'MFwholename' nor 'MF' not found!')
	  endif
	pm4epm_MasterNotFound=1;
--        return 
	endif

/* fill MF-compliant variables */

-- oh... REXX has MFdrive = filespec("Drive",MF), but E not ! 
call split_file_name(MFdrive, MFdir, MFname, MFext, MF)
-- call split_file_name(EFdrive, EFdir, EFname, EFext, EF) -- up to 4.1.1997

if (MFisEF==0) then -- files are different
        if (MFdrive='') then MFdrive=EFdrive endif
        if (MFdir='') then MFdir=EFdir endif
        endif

MFdir = delstr(MFdir, length(MFdir)) -- del last backslash
MainDirectory = MFdrive''MFDir
MFext = delstr(MFext, 1,1) -- del .
MFwholename = MainDirectory'\'MFname

EFext = delstr(EFext,1,1) -- del .
if (MFisEF=1)
	then  EFdrive=MFdrive; EFdir=MFdir
        else  EFdir = delstr(EFdir, length(EFdir)) -- del last backslash
	endif
EFwholename = EFdrive''EFdir'\'EFname

/* Now master file MF and edit file EF are fully qualified. 
    We should read the first line of the master file to get the information 
    about Format, Orientation, Etc, Opts
*/

if (MFisEF=0) then -- read  line, uline  from Master
if pfile_exists(MF) 
    then  /* if Master file is in the ring */
        getfileid working_fid
        getfileid master_fid,MF
        activatefile master_fid
        getline line, 1
        activatefile working_fid
    else
        'edit /d' MF
        getfileid master_fid
        getline line, 1
        'quit'
    endif
uline = translate(line)
endif

/*  Now parse   line   (note: uline is line in uppercase)  */

w=word(uline,1); -- support for &%latex syntax of format (2.4.2000)
if substr(w,1,2)='%&' then TheFormat = substr(w,3,length(w)-2); endif
if TheFormat='' then TheFormat=PM_GetNextWord('FORMAT',line,uline) endif
if TheFormat='' then TheFormat=get_env('TEXFORMATDEFAULT') endif
if TheFormat='' then TheFormat='latex' endif

TheOrient=PM_GetNextWord('ORIENTATION',line,uline)

TheEtc=PM_GetNextWord('ETC',line,uline)

TheChoice=PM_GetNextWord('CHOICE',line,uline)

-- TheOpts=PM_GetNextWord('OPTS',line,uline)
TheOpts = PM_GetNextWordOptions('OPTS',line,uline)
TheViewOpts = PM_GetNextWordOptions('VIEWOPTS',line,uline)
TheDvips = PM_GetNextWordOptions('DVIPS',line,uline)
TheMakeindex = PM_GetNextWordOptions('MAKEINDEX',line,uline)
TheEmtexOpt = PM_GetNextWordOptions('EMTEXOPT',line,uline)

/* Finally perform the substitution on TheCommand
Not for those who want to expand this list: long commands (%opt) must precede 
    the short ones (%o) ! 
*/

/* strings cannot be empty nor spaces since they will be chained */

if EFname='' then EFname=\250 endif
if EFext='' then EFext=\250 endif
if MFname='' then MFname=\250 endif
if MFext='' then MFext=\250 endif
if MainDirectory='' then MainDirectory=\250 endif
if TheFormat='' then TheFormat=\250 endif
if TheOrient='' then TheOrient=\250 endif
if TheEtc='' then TheEtc=\250 endif
if TheChoice='' then TheChoice=\250 endif

XMF = translate(MF,'/','\') -- convert to unix format
XMFwholename = translate(MFwholename,'/','\')
XEF = translate(EF,'/','\') 
XEFwholename = translate(EFwholename,'/','\')
XMainDirectory = translate(MainDirectory,'/','\')

Shorts = '%% ' -- hide %% sequence
Longs = '!$PETR$! '
Shorts = Shorts'%w %W %.w %.W '
Longs  = Longs''EFname' 'EFwholename' 'EFext' 'EF ' '
Shorts = Shorts'%m %M %.m %.M '
Longs = Longs''MFname' 'MFwholename' 'MFext' 'MF' '
Shorts = Shorts'%x %X %.x %.X '
Longs  = Longs''EFname' 'XEFwholename' 'EFext' 'XEF ' '
Shorts = Shorts'%n %N %.n %.N '
Longs = Longs''MFname' 'XMFwholename' 'MFext' 'XMF' '
Shorts = Shorts'%h %d %D '
Longs = Longs''MFdrive' 'MainDirectory' 'XMainDirectory' '
Shorts = Shorts'%choice %format %etc %orient '
Longs = Longs''TheChoice' 'TheFormat' 'TheEtc' 'TheOrient' '

TheCommand=translate(TheCommand,'',\250) -- del those 250

/* replace single words */

do i = 1 to words(Shorts)
  sh = word(Shorts, i)
  p = pos(sh,TheCommand)
  do while (p<>0)
     l = length(sh)
     TheCommand = substr(TheCommand,1,p-1)word(Longs,i)substr(TheCommand,p+l,length(TheCommand)-p-l+1)
     p = pos(sh,TheCommand)
     end
end

/* replace single words by long words (verbatims) */
TheCommand=PM_SubstKeys(TheCommand,'%optsemtex',TheEmtexOpt)
TheCommand=PM_SubstKeys(TheCommand,'%optsdvips',TheDvips)
TheCommand=PM_SubstKeys(TheCommand,'%optsmakeindex',TheMakeindex)
TheCommand=PM_SubstKeys(TheCommand,'%opts',TheOpts)
TheCommand=PM_SubstKeys(TheCommand,'%viewopts',TheViewOpts)
TheCommand=PM_SubstKeys(TheCommand,'!$PETR$!','%%') -- restore %%
TheCommand=PM_SubstEnvironment(TheCommand)

/*
sayerror "RESULT="TheCommand
WinMessageBox( 'PM for himself', 'Continue...', MB_OK + MB_MOVEABLE + MB_ERROR)
better: DebugBox('RESULT='TheCommand)
*/

RETURN TheCommand



/**************************** DEFINE pm_command_cmd **********************/

DEFPROC pm_command_start ( action, HowStart, TheCommand, TheInfo )

if action = 'S' then    
     /* button launched => replace %xxx sequences and run TheCommand */
    if TheCommand='' then 
        ErrorBox('Please define your action in the icon/edit/customization/parameters')
        return
        endif 
    TheCommand=pm_expansion(TheCommand)
-- how to detect if all is OK?
    save_the_ring()
    HowStart''TheCommand
    return

/* this is obsolete now
if (word(TheCommand,1)='-') 
  then TheCommand=subword(TheCommand,2,words(TheCommand)-1)
	sayerror 'STARTing 'TheCommand
	'START 'TheCommand
  elseif (word(TheCommand,1)='--') then
	TheCommand=subword(TheCommand,2,words(TheCommand)-1)
sayerror 'STARTing 'TheCommand
	TheCommand
  else  sayerror PMOS2cmd '"'TheCommand'"'
	PMOS2cmd '"'TheCommand'"'
  endif
*/

/**** HELP ACTION ****/
elseif action ='H' then sayerror 'Here can be help window or sth like that'
/**** INFO ACTION (button held on the icon) ****/
elseif action ='I' then sayerror TheInfo
else ErrorBox("Error", 'The action 'action' is not implemented')
endif
return

/**************** END OF pm_command_start *************************/


DEFC pm_expand
parse arg action TheCommand
pm_command_start(action,'',TheCommand,pm_expand_inf)

DEFC pm_command_os2
parse arg action TheCommand
pm_command_start(action,PM_STARTos2,TheCommand,pm_command_os2_inf)

DEFC pm_command_os2fs
parse arg action TheCommand
pm_command_start(action,PM_STARTos2fs,TheCommand,pm_command_os2fs_inf)

DEFC pm_command_cmd
parse arg action TheCommand
-- InfoBox('DEFC','action='action'   TheCommand='TheCommand)
pm_command_start(action,PM_STARTcmd,TheCommand,pm_command_cmd_inf)

DEFC pm_command_pm
parse arg action TheCommand
pm_command_start(action,PM_STARTpm,TheCommand,pm_command_pm_inf)

DEFC pm_command_dos
parse arg action TheCommand
pm_command_start(action,PM_STARTdos,TheCommand,pm_command_dos_inf)

DEFC pm_command_dosfs
parse arg action TheCommand
pm_command_start(action,PM_STARTdosfs,TheCommand,pm_command_dosfs_inf)

/* end of pm4EPM */

