// Copyright 2001 by
// DANTE e.V. and any individual authors listed elsewhere in this file. 
// 
// This file is part of the NTS system.
// ------------------------------------
// 
// It may be distributed and/or modified under the
// conditions of the NTS Public License (NTSPL), either version 1.0
// of this license or (at your option) any later version.
// The latest version of this license is in
//    http://www.dante.de/projects/nts/ntspl.txt
// and version 1.0 or later is part of all distributions of NTS 
// version 1.0-beta or later.
// 
// The list of all files belonging to the NTS distribution is given in
// the file `manifest.txt'. 
// 
// Filename: nts/typo/ItalCorrPrim.java
// $Id: ItalCorrPrim.java,v 1.1.1.1 1999/08/18 07:27:58 ksk Exp $
package	nts.typo;

import	nts.base.Dimen;
import	nts.node.Node;
import	nts.builder.Builder;
import	nts.command.Token;

public class	ItalCorrPrim	extends BuilderPrim {

    public ItalCorrPrim(String name) { super(name); }

    /* TeXtp[1113] */
    public final Action		NORMAL = new Action() {
	public void	exec(Builder bld, Token src) {
	    Node	node = bld.lastNode();
	    if (node != Node.NULL) {
		Dimen	corr = node.getItalCorr();
		if (corr != Dimen.NULL) bld.addKern(corr);
	    }
	}
    };

}
