/*
 * Decompiled with CFR 0.152.
 */
package nts.typo;

import nts.base.Dimen;
import nts.base.Glue;
import nts.command.CommandBase;
import nts.command.Prim;
import nts.command.TokenList;
import nts.node.Box;
import nts.node.NamedVSkipNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.VBoxNode;
import nts.node.VertSplit;
import nts.node.VoidBoxNode;
import nts.typo.FetchBoxPrim;
import nts.typo.SetBoxPrim;
import nts.typo.TypoCommand;

public class VSplitPrim
extends FetchBoxPrim {
    private final SetBoxPrim reg;
    private final TokenList.Maintainer firstMark;
    private final TokenList.Maintainer lastMark;

    public Box getBoxValue() {
        int idx = Prim.scanRegisterCode();
        if (!CommandBase.scanKeyword("to")) {
            CommandBase.error("MissingToForVsplit");
        }
        Dimen size = CommandBase.scanDimen();
        Box box = this.reg.get(idx);
        this.firstMark.setToksValue(TokenList.EMPTY);
        this.lastMark.setToksValue(TokenList.EMPTY);
        if (box.isVoid()) {
            return box;
        }
        NodeEnum nodes = box.getVertList();
        if (nodes == null) {
            CommandBase.error("SplittingNonVbox", this, CommandBase.esc("vbox"));
            return VoidBoxNode.BOX;
        }
        Dimen maxDepth = CommandBase.getConfig().getDimParam(TypoCommand.DIMP_SPLIT_MAX_DEPTH);
        VSplitSplit splitter = new VSplitSplit(nodes);
        NodeList head = splitter.makeSplitting(size, maxDepth);
        VSplitPrim.setMarks(head.nodes(), this.firstMark, this.lastMark);
        splitter.pruneTop();
        NodeList tail = new NodeList(splitter.nodes());
        box = tail.isEmpty() ? VoidBoxNode.BOX : VBoxNode.packedOf(tail);
        this.reg.foist(idx, box);
        return TypoCommand.packVBox(head, size, maxDepth);
    }

    public static boolean setMarks(NodeEnum nodes, TokenList.Maintainer first, TokenList.Maintainer last) {
        boolean noMark = true;
        while (nodes.hasMoreNodes()) {
            Node node = nodes.nextNode();
            if (!node.isMark()) continue;
            if (noMark) {
                noMark = false;
                first.setToksValue(node.getMark());
            }
            last.setToksValue(node.getMark());
        }
        return !noMark;
    }

    public static Node makeTopAdjustment(Dimen height, int param, Glue skip) {
        Dimen dim = skip.getDimen();
        dim = dim.moreThan(height) ? dim.minus(height) : Dimen.ZERO;
        skip = skip.resizedCopy(dim);
        return new NamedVSkipNode(skip, CommandBase.getConfig().getGlueName(param));
    }

    public static Node makeTopAdjustment(Dimen height, int param) {
        return VSplitPrim.makeTopAdjustment(height, param, CommandBase.getConfig().getGlueParam(param));
    }

    public VSplitPrim(String name, SetBoxPrim reg, TokenList.Maintainer firstMark, TokenList.Maintainer lastMark) {
        super(name);
        this.reg = reg;
        this.firstMark = firstMark;
        this.lastMark = lastMark;
    }

    protected static class VSplitSplit
    extends VertSplit {
        protected Node topAdjustment(Dimen height) {
            return VSplitPrim.makeTopAdjustment(height, TypoCommand.GLUEP_SPLIT_TOP_SKIP);
        }

        public VSplitSplit(NodeEnum nodes) {
            super(nodes);
        }
    }
}

