/*
 * Decompiled with CFR 0.152.
 */
package nts.tfm;

import java.util.Stack;
import nts.base.BinFraction;
import nts.base.BoolPar;
import nts.base.IntPar;
import nts.io.CharCode;
import nts.io.Name;
import nts.node.MathWordBuilder;
import nts.node.Node;
import nts.node.WordRebuilder;
import nts.tfm.FixWord;
import nts.tfm.TeXFm;

public abstract class TeXLigKernBuilder
implements WordRebuilder,
MathWordBuilder {
    public static final short NO_CHAR_CODE = -1;
    private static final Cell BOUNDARY = new BoundCell();
    private Cell left = null;
    private Stack stack = new Stack();
    private Name.Buffer buffer = new Name.Buffer();
    private boolean collapsed = false;
    private BoolPar keepLeft = new BoolPar();
    private BoolPar keepRight = new BoolPar();
    private IntPar stepOver = new IntPar();
    private boolean leftHit = false;
    private boolean rightHit = false;

    public boolean lastHasCollapsed() {
        return this.collapsed;
    }

    private void push(Cell cell) {
        this.stack.push(cell);
        this.collapsed = false;
    }

    private Cell pop() {
        return (Cell)this.stack.pop();
    }

    private Cell peek() {
        return (Cell)this.stack.peek();
    }

    private boolean empty() {
        return this.stack.empty();
    }

    public boolean add(CharCode code) {
        char index = code.toChar();
        if (index != '\uffff' && this.exists((short)index)) {
            TeXLigKernBuilder teXLigKernBuilder = this;
            if (teXLigKernBuilder == null) {
                throw null;
            }
            CharCell cell = teXLigKernBuilder.new CharCell(code);
            if (this.left == null) {
                this.left = cell;
                this.buffer.append(code);
            } else {
                this.push(cell);
                this.proceed();
            }
            return true;
        }
        this.close();
        return false;
    }

    public byte addIfBelongsToCut(CharCode code) {
        char index = code.toChar();
        if (index != '\uffff' && this.exists((short)index)) {
            TeXLigKernBuilder teXLigKernBuilder = this;
            if (teXLigKernBuilder == null) {
                throw null;
            }
            CharCell cell = teXLigKernBuilder.new CharCell(code);
            if (this.left == null) {
                this.left = cell;
                this.buffer.append(code);
            } else {
                byte how = 0;
                this.push(cell);
                while (!this.empty()) {
                    TeXFm.LigKern lk = this.getLigKern(this.left.getIdx(), this.peek().getIdx());
                    if (lk != null) {
                        how = 1;
                        short lig = lk.getLig(this.keepLeft, this.keepRight, this.stepOver);
                        if (lig != -1) {
                            this.ligStep(lig);
                            continue;
                        }
                        FixWord kern = lk.getKern();
                        if (kern != null) {
                            if (this.peek() == cell) {
                                this.pop();
                                this.close();
                                this.makeKern(kern);
                                return how;
                            }
                            this.move();
                            this.makeKern(kern);
                            continue;
                        }
                    }
                    if (this.peek() == cell) {
                        this.pop();
                        this.close();
                        return how;
                    }
                    this.move();
                }
            }
            return 2;
        }
        this.close();
        return 0;
    }

    public boolean prolongsCut(CharCode code) {
        char index;
        if (this.left != null && (index = code.toChar()) != '\uffff' && this.exists((short)index)) {
            TeXFm.LigKern lk = this.getLigKern(this.left.getIdx(), (short)index);
            return lk != null;
        }
        return false;
    }

    private void proceed() {
        while (!this.empty()) {
            TeXFm.LigKern lk = this.getLigKern(this.left.getIdx(), this.peek().getIdx());
            if (lk != null) {
                short lig = lk.getLig(this.keepLeft, this.keepRight, this.stepOver);
                if (lig != -1) {
                    this.ligStep(lig);
                    continue;
                }
                FixWord kern = lk.getKern();
                if (kern != null) {
                    this.move();
                    this.makeKern(kern);
                    continue;
                }
            }
            this.move();
        }
    }

    private void ligStep(short lig) {
        if (this.left.isBoundary()) {
            this.leftHit = true;
        } else if (this.peek().isBoundary()) {
            this.rightHit = true;
        }
        CharCode code = this.keepRight.get() ? null : this.pop().getCode();
        TeXLigKernBuilder teXLigKernBuilder = this;
        if (teXLigKernBuilder == null) {
            throw null;
        }
        LigCell cell = teXLigKernBuilder.new LigCell(lig, code);
        if (this.keepLeft.get()) {
            this.push(cell);
        } else {
            this.setLeft(cell);
            this.collapsed = this.empty();
        }
        int i = this.stepOver.get();
        while (i > 0) {
            this.move();
            --i;
        }
    }

    public void close(boolean rightBoundary) {
        if (rightBoundary) {
            this.close(BOUNDARY);
        } else {
            this.close();
        }
    }

    public void close(CharCode code) {
        this.close(new CharBoundCell(code));
    }

    private void close(Cell cell) {
        if (this.left != null && !this.left.isBoundary()) {
            this.push(cell);
            this.proceed();
        }
        this.close();
    }

    public void close() {
        if (this.left != null) {
            this.left.makeNode(this.leftHit, this.rightHit);
            this.left = null;
        }
        this.rightHit = false;
        this.leftHit = false;
        this.buffer.clear();
    }

    private Node takeLastNode(boolean larger) {
        Node node = null;
        if (this.left != null) {
            node = this.left.makeNode(this.leftHit, this.rightHit, larger);
            this.left = null;
        }
        this.rightHit = false;
        this.leftHit = false;
        this.buffer.clear();
        return node;
    }

    private void move() {
        this.move(this.pop());
    }

    private void move(Cell right) {
        if (this.rightHit && right.isBoundary()) {
            this.left.makeNode(this.leftHit, true);
            this.rightHit = false;
        } else {
            this.left.makeNode(this.leftHit, false);
        }
        if (!this.left.isBoundary()) {
            this.leftHit = false;
        }
        this.buffer.clear();
        this.setLeft(right);
    }

    private void setLeft(Cell cell) {
        this.left = cell;
        CharCode code = cell.getCode();
        if (code != null) {
            this.buffer.append(code);
        }
    }

    public Node takeLastNode() {
        return this.takeLastNode(false);
    }

    public Node takeLastLargerNode() {
        return this.takeLastNode(true);
    }

    protected abstract boolean exists(short var1);

    protected abstract TeXFm.LigKern getLigKern(short var1, short var2);

    protected abstract void makeChar(CharCode var1);

    protected abstract void makeLig(short var1, Name var2, boolean var3, boolean var4);

    protected abstract void makeKern(BinFraction var1);

    protected abstract Node makeChar(CharCode var1, boolean var2);

    protected abstract Node makeLig(short var1, Name var2, boolean var3, boolean var4, boolean var5);

    public TeXLigKernBuilder(boolean leftBoundary) {
        if (leftBoundary) {
            this.left = BOUNDARY;
        }
    }

    protected TeXLigKernBuilder(CharCode code) {
        TeXLigKernBuilder teXLigKernBuilder = this;
        if (teXLigKernBuilder == null) {
            throw null;
        }
        this.left = teXLigKernBuilder.new CharCell(code);
    }

    protected TeXLigKernBuilder(short index, Name subst, boolean leftHit) {
        TeXLigKernBuilder teXLigKernBuilder = this;
        if (teXLigKernBuilder == null) {
            throw null;
        }
        this.left = teXLigKernBuilder.new LigCell(index);
        this.buffer.append(subst);
        this.leftHit = leftHit;
    }

    private static interface Cell {
        public static final Cell NULL;

        public short getIdx();

        public CharCode getCode();

        public boolean isBoundary();

        public void makeNode(boolean var1, boolean var2);

        public Node makeNode(boolean var1, boolean var2, boolean var3);
    }

    private class CharCell
    implements Cell {
        private final CharCode code;

        public short getIdx() {
            return (short)this.code.toChar();
        }

        public CharCode getCode() {
            return this.code;
        }

        public boolean isBoundary() {
            return false;
        }

        public void makeNode(boolean lh, boolean rh) {
            TeXLigKernBuilder.this.makeChar(this.code);
        }

        public Node makeNode(boolean lh, boolean rh, boolean larger) {
            return TeXLigKernBuilder.this.makeChar(this.code, larger);
        }

        public CharCell(CharCode code) {
            this.code = code;
        }
    }

    private class LigCell
    implements Cell {
        private final short index;
        private final CharCode code;

        public short getIdx() {
            return this.index;
        }

        public CharCode getCode() {
            return this.code;
        }

        public boolean isBoundary() {
            return false;
        }

        public void makeNode(boolean lh, boolean rh) {
            TeXLigKernBuilder.this.makeLig(this.index, TeXLigKernBuilder.this.buffer.toName(), lh, rh);
        }

        public Node makeNode(boolean lh, boolean rh, boolean larger) {
            return TeXLigKernBuilder.this.makeLig(this.index, TeXLigKernBuilder.this.buffer.toName(), lh, rh, larger);
        }

        public LigCell(short index, CharCode code) {
            this.index = index;
            this.code = code;
        }

        public LigCell(short index) {
            this(index, null);
        }
    }

    private static class BoundCell
    implements Cell {
        public short getIdx() {
            return -1;
        }

        public CharCode getCode() {
            return null;
        }

        public boolean isBoundary() {
            return true;
        }

        public void makeNode(boolean lh, boolean rh) {
        }

        public Node makeNode(boolean lh, boolean rh, boolean larger) {
            return null;
        }

        BoundCell() {
        }
    }

    private static class CharBoundCell
    extends BoundCell {
        private final CharCode code;

        public short getIdx() {
            return (short)this.code.toChar();
        }

        public CharBoundCell(CharCode code) {
            this.code = code;
        }
    }
}

