/*
 * Decompiled with CFR 0.152.
 */
package nts.align;

import nts.align.Alignment;
import nts.align.AnyUnsetNode;
import nts.align.HAlignBuilder;
import nts.base.Dimen;
import nts.base.Glue;
import nts.builder.Builder;
import nts.builder.HBoxBuilder;
import nts.builder.ListBuilder;
import nts.command.CommandBase;
import nts.command.Token;
import nts.command.TokenList;
import nts.io.Log;
import nts.node.AnyBoxNode;
import nts.node.AnySkipNode;
import nts.node.BoxSizes;
import nts.node.GlueSetting;
import nts.node.HBoxNode;
import nts.node.HSkipNode;
import nts.node.HorizIterator;
import nts.node.NamedHSkipNode;
import nts.node.Node;
import nts.node.NodeEnum;
import nts.node.NodeList;
import nts.node.SizesSummarizer;
import nts.typo.TypoCommand;

public class HorizAlignment
extends Alignment {
    protected final ListBuilder builder;
    protected HBoxBuilder rowBuilder;
    protected HBoxBuilder spanBuilder;
    protected NodeList rowMigrations;

    protected void pushNewRowBuilder() {
        this.rowBuilder = new HAlignBuilder(CommandBase.currLineNumber());
        this.rowMigrations = new NodeList();
        Builder.push(this.rowBuilder);
    }

    protected void pushNewSpanBuilder() {
        this.spanBuilder = new HBoxBuilder(CommandBase.currLineNumber());
        Builder.push(this.spanBuilder);
    }

    protected void addNamedSkipToRow(Glue skip, String name) {
        this.rowBuilder.addNamedSkip(skip, name);
    }

    protected Dimen packedSpanSize(int spanCount) {
        NodeList list = this.spanBuilder.getList();
        Builder.pop();
        this.spanBuilder = null;
        if (this.builder.wantsMigrations()) {
            this.rowMigrations.append(list.extractedMigrations());
        }
        SizesSummarizer pack = new SizesSummarizer();
        HorizIterator.summarize(list.nodes(), pack);
        Dimen size = pack.getBody().plus(pack.getDepth());
        BoxSizes sizes = new BoxSizes(pack.getWidth(), size, pack.getLeftX(), pack.getHeight());
        byte strOrder = pack.maxTotalStr();
        byte shrOrder = pack.maxTotalShr();
        this.rowBuilder.addNode(new AnyUnsetNode(sizes, list, spanCount, pack.getTotalStr(strOrder), strOrder, pack.getTotalShr(shrOrder), shrOrder));
        return size;
    }

    protected void packRow() {
        NodeList list = this.rowBuilder.getList();
        Builder.pop();
        this.rowBuilder = null;
        TypoCommand.appendBox((Builder)this.builder, (Node)new AnyUnsetNode(HorizIterator.naturalSizes(list.nodes()), list), this.rowMigrations.nodes());
        this.rowMigrations = null;
    }

    protected NodeEnum getUnsetNodes() {
        return this.builder.getList().nodes();
    }

    protected Dimen getRelevantSize(BoxSizes sizes) {
        return sizes.getWidth();
    }

    protected BoxSizes transformSizes(BoxSizes sizes, Dimen dim) {
        return sizes.withWidth(dim);
    }

    protected AnyBoxNode makeBox(BoxSizes sizes, GlueSetting setting, NodeList list) {
        return new HBoxNode(sizes, setting, list);
    }

    protected AnySkipNode makeSkip(Glue skip) {
        return new HSkipNode(skip);
    }

    protected AnySkipNode makeSkip(Glue skip, String name) {
        return new NamedHSkipNode(skip, name);
    }

    protected TypoCommand.AnyBoxPacker makeBoxPacker() {
        HorizAlignment horizAlignment = this;
        if (horizAlignment == null) {
            throw null;
        }
        return new TypoCommand.HBoxPacker(horizAlignment){
            private final /* synthetic */ HorizAlignment this$0;

            protected void reportLocation(Log log) {
                log.add("in alignment at lines ").add(this.this$0.builder.getStartLine()).add("--").add(CommandBase.currLineNumber());
            }
            {
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(HorizAlignment horizAlignment) {
            }
        };
    }

    public void copyPrevParameters(Builder bld) {
        bld.setPrevDepth(this.builder.getPrevDepth());
    }

    public HorizAlignment(Dimen size, boolean exactly, TokenList.Inserter everyCr, Token frzCr, Token frzEndt, ListBuilder builder) {
        super(size, exactly, everyCr, frzCr, frzEndt);
        this.builder = builder;
    }
}

