# Copyright 2012-2024, Alexander Shibakov
# This file is part of SPLinT
#
# SPLinT is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# SPLinT is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

SPLINT_ROOT := $(dir $(CURDIR)/$(word $(words $(MAKEFILE_LIST)),$(MAKEFILE_LIST)))
# taken from a stackoverflow answer by Xavier Holt

TEXINPUTS := .:${SPLINT_ROOT}cweb/:${SPLINT_ROOT}tex/:${SPLINT_ROOT}:${TEXINPUTS}
TEXFONTS := .:${SPLINT_ROOT}tex/fonts:${SPLINT_ROOT}:${TEXFONTS}
VFFONTS := .:${SPLINT_ROOT}tex/fonts:${SPLINT_ROOT}:${VFFONTS}
TFMFONTS := .:${SPLINT_ROOT}tex/fonts:${SPLINT_ROOT}:${TFMFONTS}

SPLINT_DRIVER_DIR = ${SPLINT_ROOT}cweb

SPLINT_TEXSTYLES_BASE = yycommon.sty yymisc.sty trt1.sty xarithm.sty yyfaststack.sty
SPLINT_TEXSTYLES_BASE_PARSER0 = yyinput.sty flex.sty yyparse.sty yystype.sty yydebug.sty
SPLINT_TEXSTYLES_BASE_PARSER1 = yyinit.sty yybootstrap.sty yyunion.sty yy.sty
SPLINT_TEXSTYLES_BASE_TOKENS = yypretty.sty $(patsubst %, %tokenset.sty, b f s fre)
SPLINT_TEXSTYLES_BASE_DISPLAY = limbo.sty dcols.sty gindex.sty noweb.sty yytexlex.sty

SPLINT_TEXSTYLES  = ${SPLINT_TEXSTYLES_BASE} ${SPLINT_TEXSTYLES_BASE_PARSER0} ${SPLINT_TEXSTYLES_BASE_PARSER1}
SPLINT_TEXSTYLES += ${SPLINT_TEXSTYLES_BASE_TOKENS} ${SPLINT_TEXSTYLES_BASE_DISPLAY}

SPLINT_PTABLES = byytab.tex dyytab.tex fyytab.tex gyytab.tex fiptab.tex reptab.tex raptab.tex ddptab.tex
SPLINT_PTABLES += small_tab.tex
SPLINT_LTABLES = ltab.tex filtab.tex small_dfa.tex
SPLINT_OTABLES = bo.tok fo.tok

SPLINT_XTEXSTYLES = $(patsubst %, ${SPLINT_ROOT}tex/%, ${SPLINT_TEXSTYLES})
SPLINT_XPTABLES = $(patsubst %, ${SPLINT_ROOT}cweb/%, ${SPLINT_PTABLES})
SPLINT_XLTABLES = $(patsubst %, ${SPLINT_ROOT}cweb/%, ${SPLINT_LTABLES})
SPLINT_XOTABLES = $(patsubst %, ${SPLINT_ROOT}cweb/%, ${SPLINT_OTABLES})
SPLINT_XTABLES = ${SPLINT_XPTABLES} ${SPLINT_XLTABLES} ${SPLINT_XOTABLES}

SPLINT_DOC_PREREQS = splint.tex ${SPLINT_PTABLES} ${SPLINT_LTABLES} ${SPLINT_OTABLES} ${SPLINT_XTEXSTYLES}
SPLINT_DOC_PREREQS += ${SPLINT_ROOT}tex/frontmatter.sty

SPLINT_DOC_PREREQS_XREF = ${SPLINT_DOC_PREREQS} splint.scn splint.idx 

EXPORT_TEX_ENVIRON = TEXINPUTS=${TEXINPUTS} TEXFONTS=${TEXFONTS} VFFONTS=${VFFONTS} TFMFONTS=${TFMFONTS}

PDFTEX = export ${EXPORT_TEX_ENVIRON} && pdftex -recorder -file-line-error -synctex=1
TEX = export ${EXPORT_TEX_ENVIRON} && tex
DVIPS = dvips
PDFVIEW = evince
CWEAVE = cweave -bhp
CTANGLE = ctangle -bhp
BISON = ${BISON_ROOT}bison -v
FLEX = ${FLEX_ROOT}flex

MODEBOOTSTRAP = \\let\\ifbootstrapmode\\iftrue

BRACK = ${SPLINT_ROOT}scripts/brack.pl
UNLINE = ${SPLINT_ROOT}scripts/unline.pl
BINDX = ${SPLINT_ROOT}scripts/bindx.pl
MISCCW = ${SPLINT_ROOT}scripts/misccw.pl

# remove the default implicit rules

%.c:		%.w
%.c:		%.y
%.pdf:		%.tex
%.ps:		%.dvi
%.o:		%.c
%.c:		%.l

# new implicit rules

%.x %.u %.m:	%.w
		${BRACK} --bison-link=$*.m $< $*.x $*.u

%.c:		%.y
		${BISON} $^ -o $@

%.c:		%.l
		${FLEX} -o $@ $^

%.l:		%.ll
		${UNLINE} $^ $@

%.y:		%.yy
		cp -f $^ $@

%.ps:		%.dvi
		${DVIPS} $^ -o $@

%.gdy:		%.gdx
		${BINDX} $^ $@

all:		docs

${SPLINT_ROOT}cweb/%:
		cd ${SPLINT_ROOT}cweb && ${MAKE} $(notdir $@)

clean_temp:	
	-rm -f  *.o *.tab.* *.dvi *.pdf *.ps *~ *.log *.rli *.rls *.lpg \
        *.output *.lst *.exl *.*pk *.gdx *.fls *.synctex.gz

clean_core:   clean_temp
	-rm -f *.c *.h *.tex *.idx *.scn *.toc *.tok *.sns *.aux *.gdy *.x \
	*.u *.m *.hx *.hy *.yy *.yx *.ll *.y *.l

# to ensure that interrupted and erroneous builds are cleaned up

.DELETE_ON_ERROR:
			-rm -f *.gdx *.gdy *.aux *.tok
