#!/bin/awk -f 

#
#    REFERENCES -- bibliographic software
#    Copyright (C) 1995-2006  Volker Kiefel
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
#    USA
#

#    ex_arr.awk -- Extract reference numbers from a References archive file
#
#    Usage:
#
#       awk [-v output_file=NameOfOutputFile.txt] -f ex_arr.awk arrfile
#
#    Versions:
#    30.7.2005: name of `ausgabe_datei' may be changed (for References v4.2)
#

BEGIN {
  i=0;
  feldname="RECN:";

   if (!output_file)
   {
     ausgabe_datei = "ex_arr.tbt"
   } else
   {
     ausgabe_datei=output_file
   }

  eingabe_datei="";
  abbruch=0;
  printf("\n");
}

{
   eingabe_datei=FILENAME;
   if (index($0,feldname)==1)
   {
      kennziffer = substr($0,length(feldname)+1);
      printf("* %s *  *\n",kennziffer) > ausgabe_datei;
      i++;
      # next line may be commented out
      printf("%6i\b\b\b\b\b\b",i);
   }
}

END {
  
  close(ausgabe_datei);
  if(!abbruch)
  {
    print i " reference numbers from `" eingabe_datei "' written to `" \
    ausgabe_datei "'\n";
  }
}

# vim:tw=2048

