/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul.filter;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LZWInputStream
extends FilterInputStream {
    boolean atEOF;
    static final int MAX_BITS = 12;
    static final int MAX_VALUE = 4095;
    static final int CLEAR_TABLE = 256;
    static final int EOD = 257;
    static final int MIN_CODE = 258;
    private int codeBits;
    private int[] prefixCode;
    private byte[] appendCharacter;
    private int nextCode;
    private int oldCode;
    private byte character;
    ByteStack decodeStack = new ByteStack();
    private int inputBitCount = 0;
    private int inputBitBuffer = 0;

    public LZWInputStream(InputStream in) throws IOException {
        super(in);
        this.clearTable();
    }

    public int available() throws IOException {
        return this.atEOF ? 0 : 1;
    }

    private void clearTable() throws IOException {
        this.codeBits = 9;
        this.nextCode = 258;
        this.prefixCode = new int[4096];
        this.appendCharacter = new byte[4096];
        do {
            this.oldCode = this.inputCode();
        } while (this.oldCode == 256);
        this.character = (byte)this.oldCode;
        this.decodeStack.push(this.oldCode);
    }

    private void decodeString(int code) {
        while (code >= 258) {
            this.decodeStack.push(this.appendCharacter[code]);
            code = this.prefixCode[code];
        }
        this.decodeStack.push(code);
    }

    private boolean expandNextCode() throws IOException {
        int code = this.inputCode();
        if (code == 256) {
            this.clearTable();
        } else {
            if (code == 257) {
                return false;
            }
            if (code >= this.nextCode) {
                this.decodeStack.push(this.character);
                this.decodeString(this.oldCode);
            } else {
                this.decodeString(code);
            }
            this.character = (byte)this.decodeStack.top();
            if (this.nextCode <= 4095) {
                this.prefixCode[this.nextCode] = this.oldCode;
                this.appendCharacter[this.nextCode] = this.character;
                ++this.nextCode;
                if (this.nextCode >= (1 << this.codeBits) - 1 && this.codeBits < 12) {
                    ++this.codeBits;
                }
            }
            this.oldCode = code;
        }
        return true;
    }

    private int inputCode() throws IOException {
        while (this.inputBitCount <= 24) {
            this.inputBitBuffer |= (this.in.read() & 0xFF) << 24 - this.inputBitCount;
            this.inputBitCount += 8;
        }
        int result = this.inputBitBuffer >>> 32 - this.codeBits;
        this.inputBitBuffer <<= this.codeBits;
        this.inputBitCount -= this.codeBits;
        return result;
    }

    public static void main(String[] args) {
        try {
            int c;
            InputStream src = args.length > 0 ? new BufferedInputStream(new FileInputStream(args[0])) : System.in;
            LZWInputStream in = new LZWInputStream(src);
            while ((c = ((InputStream)in).read()) != -1) {
                System.out.write(c);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public int read() throws IOException {
        if (this.atEOF) {
            return -1;
        }
        if (this.decodeStack.empty()) {
            this.atEOF = this.expandNextCode() ^ true;
            if (this.atEOF) {
                return -1;
            }
        }
        return this.decodeStack.pop();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        int i = 1;
        try {
            while (i < len) {
                c = this.read();
                if (c != -1) {
                    if (b != null) {
                        b[off + i] = (byte)c;
                    }
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {}
        return i;
    }

    public long skip(long n) throws IOException {
        long count = 0L;
        while (n-- > 0L) {
            if (this.read() == -1) {
                throw new EOFException();
            }
            ++count;
        }
        return count;
    }

    private final class ByteStack {
        private byte[] stack = new byte[32];
        private int top = -1;

        ByteStack() {
        }

        void dumpStack() {
            int i = this.top;
            while (i > 0) {
                System.err.println(this.stack[i] & 0xFF);
                --i;
            }
        }

        boolean empty() {
            return this.top < 0;
        }

        int pop() {
            return this.stack[this.top--] & 0xFF;
        }

        void push(int b) {
            ++this.top;
            if (this.top >= this.stack.length) {
                byte[] newStack = new byte[this.stack.length * 2];
                System.arraycopy(this.stack, 0, newStack, 0, this.stack.length);
                this.stack = newStack;
            }
            this.stack[this.top] = (byte)b;
        }

        int top() {
            return this.stack[this.top] & 0xFF;
        }
    }
}

