/*
 * Decompiled with CFR 0.152.
 */
package de.nm.ant.group;

import de.nm.ant.group.AbstractGroup;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GroupTask
extends AbstractGroup {
    protected String basename;
    private File destdir;
    protected File destfile = null;
    private String extname;
    protected String mode = "ifnewer";
    protected File srcfile = null;
    protected File workdir;

    public void execute() throws BuildException {
        if (this.name == null) {
            throw new BuildException("name must be set.");
        }
        AbstractGroup.GroupEntry groupentry = (AbstractGroup.GroupEntry)group.get(this.name);
        Vector<Task> tasks = groupentry.tasks;
        this.logVerboseHeader("use group " + this.name);
        if (tasks != null) {
            for (Task task : tasks) {
                this.logVerbose("run task " + task.getTaskName());
                task = this.checkTask(task);
                if (groupentry.passthrough) {
                    if ("ifnewer".equalsIgnoreCase(this.mode)) {
                        this.checkMethod(task, "setWorkdir", this.workdir);
                        this.checkMethod(task, "setSrcfile", this.srcfile);
                        this.checkMethod(task, "setDestfile", this.destfile);
                        this.checkMethod(task, "setBasename", this.basename);
                    } else {
                        this.checkMethod(task, "setDestdir", this.destdir);
                        this.checkMethod(task, "setWorkdir", this.destdir);
                        this.checkMethod(task, "setBasename", this.basename);
                        this.checkMethod(task, "setExtname", this.extname);
                    }
                }
                task.perform();
            }
        } else {
            this.logVerboseHeader("group is empty");
        }
    }

    public void setBasename(String basename) {
        this.basename = basename;
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setDestfile(File destfile) {
        this.destfile = destfile;
    }

    public void setExtname(String extname) {
        this.extname = extname;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public void setSrcfile(File srcfile) {
        this.srcfile = srcfile;
    }

    public void setWorkdir(File workdir) {
        this.workdir = workdir;
    }
}

