/* Copyright (C) 2001-2003 artofcode LLC. All rights reserved.

   This software is distributed under license and may not be copied, modified
   or distributed except as expressly authorized under the terms of that
   license.  Refer to licensing information at http://www.artifex.com/ or
   contact Artifex Software, Inc., 101 Lucas Valley Road #110,
   San Rafael, CA  94903, (415)492-9861, for further information. */

/* $Id: gp_mspol.c,v 1.2 2003/05/06 23:58:53 stefan Exp $ */
/*
 * Microsoft Windows platform polling support for Ghostscript.
 *
 */

#include "gx.h"
#include "gp.h"
#include "gpcheck.h"
#include "iapi.h"
#include "iref.h"
#include "iminst.h"
#include "imain.h"

/* ------ Process message loop ------ */
/* 
 * Check messages and interrupts; return true if interrupted.
 * This is called frequently - it must be quick!
 */
#ifdef CHECK_INTERRUPTS
int
gp_check_interrupts(void)
{
    gs_main_instance *minst = gs_main_instance_default();
    if (minst && minst->poll_fn)
	return (*minst->poll_fn)(minst->caller_handle);
    return 0;
}
#endif
