// Copyright (c) 1991 by Parag Patel.  All Rights Reserved.
// $Header: bitvec.h,v 1.4 91/02/22 15:59:36 hmgr Exp $

#ifndef __BITVEC_H_
#define __BITVEC_H_

#include "boolean.h"

// BUG: machine dependent macros: sizeof (unsigned long) must == 32 bits
#define __B_V_BIT(n) ((unsigned long)(1L << (n & 0x1F)))
#define __B_V_ELT(n) (n >> 5)

// a set of longs (esp. enums) - also an array of bits
class Bitvec
{
    long num;
    unsigned long *elts;

    void bumpsize(long);		// grow the Bitvec
    // inline for speed
    void BUMPSIZE(long largest) { if (num < largest) bumpsize(largest); }

public: 
    Bitvec(long);		// new size
    Bitvec(Bitvec const &);	// new Bitvec
    Bitvec() { elts = new unsigned long; num = 0; elts[0] = 0L; }
    ~Bitvec() { delete elts; }	// destructor

    Bitvec& operator=(Bitvec const &);   // dup

    Bitvec& add(long);		// add to
    Bitvec& remove(long);	// delete from
    Bitvec& operator+=(long e) { return add(e); }
    Bitvec& operator-=(long e) { return remove(e); }

    long size() const;			// number of elements in Bitvec
    boolean isin(long bit) const
	{ return bit >= 0 && bit <= num &&
		(elts[__B_V_ELT(bit)] & __B_V_BIT(bit)); }
    void clear();		// clear the set

    long get(long elt) const
	    { return (elt >= 0 && elt <= num &&
		    (elts[__B_V_ELT(elt)] & __B_V_BIT(elt))) ? 1 : 0; }
    long operator[](long elt) const { return get(elt); }
    unsigned long *getelts() { return elts; }

    // equality testing:
    boolean operator==(Bitvec const &s) const;
    boolean operator!=(Bitvec const &s) const { return !(s == *this); }
};

#undef __B_V_ELT
#undef __B_V_BIT

#endif /* __BITVEC_H_ */
