%!
% This is the builtin.pro for use by dvi2ps version 3.1
%
% Original macros to reencode Adobe fonts as TeX fonts were written by LA Carr.
% They are based on the routine in the Laserwriter Cookbook.
%
% They were revised by:	Van Jacobson, LBL
%			<van@lbl-csam.arpa>
% This version by:	Kevin Coombes, University of Michiogan
%			<kevin@math.lsa.umich.edu>
%			<Kevin_Coombes@ub.cc.umich.edu>
%
% This is the basic machinery to change a builtin font to a texfont.
% The @texmakefont routine asumes no reencoding is needed. Most calls
% are filtered through @ps2texfont, which makes this determination.

/TeXDict where
 {/TeXDict get begin}
 { (Need to load basic TeXDict first\n) print
    currentfile flushfile} 
ifelse

% newfont basefont size @texmakefont -
/@texmakefont {
	/TeXsize exch def		% Store the scalefactor.
	[ TeXsize 0 0 TeXsize neg 0 0 ] makefont	% Rescale.
	def				% Give the font a new name.
} bind def

% newfont size basefont style @ps2texfont -
/@ps2texfont {
	dup FontDirectory exch known	% Determine if style already ReEncoded.
		{ exch pop findfont }	% Remove the basefont and
		{ ReEncodeForTeX }	% leave the fontstyle on the stack.
	ifelse
	exch @texmakefont
} bind def

% basefont newfontname ReEncodeForTeX  font
/ReEncodeForTeX
  { /newfontname exch def
    /basefontname exch def
    /TeXstr 30 string def	% Allocate space for a string to hold the name.

    /basefontdict basefontname findfont def	% Get the old font dictionary.
    /newfont basefontdict maxlength dict def	% Create dict for the new font.
    basefontdict				% Make new copies of entries 
      { exch dup /FID ne			% from the old font into the new
	  { dup /Encoding eq			% font. Skip FID (which must be
	    { exch dup length array copy	% created by definefont) and
	        newfont 3 1 roll put }		% copy the Encoding array into 
	    { exch newfont 3 1 roll put }	% a new array.
	    ifelse
	  }
	{ pop pop }
	ifelse
      } forall
						% Determine which additional
      basefontdict /MathFontName known not	% characters should be Encoded
        { 					% for this font.
	  /TeXvec 
	    basefontname TeXstr cvs (Courier) search
	    { pop pop pop TeXcourvec }
	    { pop TeXnormalvec }
	    ifelse 
	  def
          TeXvec aload pop
          TeXvec length 2 idiv
	    { newfont /Encoding get 3 1 roll put }
	  repeat				% Add additional Encodings.
	}
      if

      newfontname newfont definefont		% Install new font name.
  } bind def					% Leave font on stack.

/TeXnormalvec
	[ 8#014 /fi 8#015 /fl 8#020 /dotlessi 8#022 /grave 8#023 /acute
	  8#024 /caron 8#025 /breve 8#026 /macron 8#027 /ring 8#030 /cedilla
	  8#031 /germandbls 8#032 /ae 8#033 /oe 8#034 /oslash 8#035 /AE
	  8#036 /OE 8#037 /Oslash 8#042 /quotedblright 8#074 /exclamdown
	  8#076 /questiondown 8#134 /quotedblleft 8#136 /circumflex
	  8#137 /dotaccent 8#173 /endash 8#174 /emdash 8#175 /hungarumlat
	  8#176 /tilde 8#177 /dieresis ] def
/TeXcourvec
	[ 8#016 /exclamdown 8#017 /questiondown 8#020 /dotlessi 8#022 /grave
	  8#023 /acute 8#024 /caron 8#025 /breve 8#026 /macron 8#027 /ring
	  8#030 /cedilla 8#031 /germandbls 8#032 /ae 8#033 /oe 8#034 /oslash
	  8#035 /AE 8#036 /OE 8#037 /Oslash 8#074 /less 8#076 /greater
	  8#134 /backslash 8#136 /circumflex 8#137 /underscore 8#173 /braceleft
	  8#174 /bar 8#175 /braceright 8#177 /dieresis ] def

% The remaining commands to deal with builtin fonts are called indirectly by
% dvi2ps. An initialization string is added to  psfonts.map  in order to
% create modifications to standard builtin fonts, such as Oblique, or SmallCaps.

% Create a General Oblique font
% fontname basefontname angle ObliqueFont -
/ObliqueFont {
    /ObliqueAngle exch def
    /ObliqueBaseName exch def
    /ObliqueFontName exch def
    /ObliqueTransform [1 0 ObliqueAngle sin ObliqueAngle cos div 1 0 0] def
    /basefontdict ObliqueBaseName findfont ObliqueTransform makefont def
    /newfont basefontdict maxlength dict def
    basefontdict
      { exch dup /FID ne
	  { dup /Encoding eq
	    { exch dup length array copy
	        newfont 3 1 roll put }
	    { exch newfont 3 1 roll put }
	    ifelse
	  }
	{ pop pop }
	ifelse
      } forall

     newfont /FontName ObliqueFontName put
     ObliqueFontName newfont definefont pop
} bind def

%Create a General SmallCaps font
% fontname basename SmallCapsFont -
/SmallCapsFont {
    /SmallCapsBaseName exch def
    /SmallCapsFontName exch def
    /basefontdict SmallCapsBaseName findfont def
    /newfont basefontdict maxlength 10 add dict def

    newfont begin
	/FontName SmallCapsFontName def
	/FontBaseDict basefontdict 1000 scalefont def
	/FontSCDict FontBaseDict .8 scalefont def
	/FontType 3 def
	/BuildChar {SmallCapChar} def
	/FontMatrix dup basefontdict exch get def
	/FontBBox dup basefontdict exch get def
	/Encoding dup basefontdict exch get def
    end
    SmallCapsFontName newfont definefont pop
} bind def

% fontdict ch SmallCapChar -
/SmallCapChar {
    /achar (A) def
    achar exch 0 exch put
    begin
    achar 0 get dup 97 ge exch 122 le and {
	% handle 'a' through 'z' specially
	achar 0 achar 0 get 32 sub put
	FontSCDict
    } {
	FontBaseDict
    } ifelse
    setfont achar stringwidth FontBBox setcachedevice
    newpath 0 0 moveto achar show
    end
} bind def

/MathEncodingVec [
/Gamma /Delta /Theta /Lambda /Xi /Pi /Sigma /Upsilon1
/Phi /Psi /Omega /alpha /beta /gamma /delta /epsilon
/zeta /nu /theta /iota /kappa /lambda /mu /nu
/xi /pi /rho /sigma /tau /upsilon /phi /chi
/psi /omega /epsilon /theta1 /omega1 /rho /sigma /phi1
/arrowleft /arrowleft /arrowright /arrowright
/suchthat /congruent /proportional /angle
/zero /one /two /three /four /five /six /seven
/eight /nine /period /comma /less /slash /greater /asteriskmath
/partialdiff /A /B /C /D /E /F /G
/H /I /J /K /L /M /N /O
/P /Q /R /S /T /U /V /W
/X /Y /Z /registerserif /copyrightserif /trademarkserif /logicalor /logicaland
/section /a /b /c /d /e /f /g
/h /i /j /k /l /m /n /o
/p /q /r /s /t /u /v /w
/x /y /z /dotlessi /j /weierstrass /macron /breve
] def

% the following gives the character codes of the above characters
% in their font.  I.e., this is the character we have to hand "show"
% to image the characters above.
/MathCharVec [
	71	68	81	76	88	80	83	161
	70	89	87	97	98	103	100	101
	122	110	113	105	107	108	109	110
	120	112	114	115	116	117	102	99
	121	119	101	74	118	114	115	106
	172	172	174	174	39	64	181	208
	48	49	50	51	52	53	54	55
	56	57	46	44	60	47	62	42
	182	65	66	67	68	69	70	71
	72	73	74	75	76	77	78	79
	80	81	82	83	84	85	86	87
	88	89	90	210	211	212	218	217
	167	97	98	99	100	101	102	103
	104	105	106	107	108	109	110	111
	112	113	114	115	116	117	118	119
	120	121	122	245	106	195	197	198
] def

% this array tells which font dictionary holds each character above
% (0 = basefont, 1 = symbol (maybe slanted), 2 = symbol (unslanted)).
/MathDictVec [
	1 1 1 1 1 1 1 1
	1 1 1 1 1 1 1 1
	1 1 1 1 1 1 1 1
	1 1 1 1 1 1 1 1
	1 1 1 1 1 1 1 1
	2 2 2 2 2 2 2 2
	0 0 0 0 0 0 0 0
	0 0 0 0 2 2 2 2
	2 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0
	0 0 0 2 2 2 2 2
	2 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0
	0 0 0 0 0 0 0 0
	0 0 0 0 0 2 0 0
] def

% fontname basename symbolname symbolbase angle MathOblique -
% Create a "math" font with the symbol font characters slanted
% by "angle"
/MathOblique {
    3 copy ObliqueFont
    pop pop MathFont
} bind def  

% fontname basename symbolname MathFont -	Create a math italic font
%
% We build this font out of the base font & the symbol font
% using an encoding vec as close as we can get to cmmi10 with
% standard postscript characters.  An array parallel to the
% encoding vector tells which font dictionary to use for a
% particular character.
/MathFont {
    /MathSymName exch def
    /MathBaseName exch def
    /MathFontName exch def
    /basefontdict MathBaseName findfont def
    /newfont basefontdict maxlength 10 add dict def

    newfont begin
	/FontName MathFontName def
	/FontDictArray [
	    basefontdict 1000 scalefont
	    MathSymName findfont 950 scalefont
	    /Symbol findfont 950 scalefont
	   ] def
	/FontType 3 def
	/BuildChar {MathFontChar} def
	/FontMatrix dup basefontdict exch get def
	/FontBBox dup basefontdict exch get def
	% the encoding vector is a copy of the original font's
	% encoding, modified "appropriately".
	/Encoding dup basefontdict exch get dup length array copy def
	/WhichFont MathDictVec def
	/WhichChar MathCharVec def
	MathEncodingVec Encoding copy pop
	/achar (A) def
    end
    MathFontName newfont definefont pop
} bind def

% fontdict ch MathFontChar -
/MathFontChar {
    exch begin
    achar exch 0 exch put
    FontDictArray WhichFont achar 0 get get get setfont
    achar dup 0 get WhichChar exch get 0 exch put
    achar stringwidth FontBBox setcachedevice
    newpath 0 0 moveto achar show
    end
} bind def

end	%TeXDict
