/* Generated by re2c 0.13.5 */
#line 1 "Zend/zend_language_scanner.l"
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2015 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "zend_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16
#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	INIT_PZVAL(&retval_znode.u.constant);
	ZVAL_LONG(&retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = Z_STRVAL_P(filename);
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(Z_STRVAL_P(filename), Z_STRLEN_P(filename));
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce ZEND_MMAP_AHEAD trailing NULLs for flex... */
	Z_STRVAL_P(str) = str_erealloc(Z_STRVAL_P(str), Z_STRLEN_P(str) + ZEND_MMAP_AHEAD);
	memset(Z_STRVAL_P(str) + Z_STRLEN_P(str), 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = Z_STRVAL_P(str);
	size = Z_STRLEN_P(str);

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (Z_STRLEN_P(source_string)==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result != 0) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&Z_STRVAL_P(zendlval), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		Z_STRLEN_P(zendlval) = sz; \
	} else { \
		Z_STRVAL_P(zendlval) = (char *) estrndup(yytext, yyleng); \
		Z_STRLEN_P(zendlval) = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'r':
					*t++ = '\r';
					Z_STRLEN_P(zendlval)--;
					break;
				case 't':
					*t++ = '\t';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'f':
					*t++ = '\f';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'v':
					*t++ = '\v';
					Z_STRLEN_P(zendlval)--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					Z_STRLEN_P(zendlval)--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						Z_STRLEN_P(zendlval)--; /* for the 'x' */

						hex_buf[0] = *(++s);
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						Z_STRLEN_P(zendlval)--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							Z_STRLEN_P(zendlval)--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								Z_STRLEN_P(zendlval)--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)((unsigned char **)&Z_STRVAL_P(zendlval), &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval) TSRMLS_CC);
		Z_STRLEN_P(zendlval) = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


#line 1001 "Zend/zend_language_scanner.c"
{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	if (YYGETCONDITION() < 5) {
		if (YYGETCONDITION() < 2) {
			if (YYGETCONDITION() < 1) {
				goto yyc_ST_IN_SCRIPTING;
			} else {
				goto yyc_ST_LOOKING_FOR_PROPERTY;
			}
		} else {
			if (YYGETCONDITION() < 3) {
				goto yyc_ST_BACKQUOTE;
			} else {
				if (YYGETCONDITION() < 4) {
					goto yyc_ST_DOUBLE_QUOTES;
				} else {
					goto yyc_ST_HEREDOC;
				}
			}
		}
	} else {
		if (YYGETCONDITION() < 7) {
			if (YYGETCONDITION() < 6) {
				goto yyc_ST_LOOKING_FOR_VARNAME;
			} else {
				goto yyc_ST_VAR_OFFSET;
			}
		} else {
			if (YYGETCONDITION() < 8) {
				goto yyc_INITIAL;
			} else {
				if (YYGETCONDITION() < 9) {
					goto yyc_ST_END_HEREDOC;
				} else {
					goto yyc_ST_NOWDOC;
				}
			}
		}
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};

		YYDEBUG(0, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych != '<') goto yy4;
		YYDEBUG(2, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '?') {
			if (yych == '%') goto yy7;
			if (yych >= '?') goto yy5;
		} else {
			if (yych <= 'S') {
				if (yych >= 'S') goto yy9;
			} else {
				if (yych == 's') goto yy9;
			}
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1749 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&Z_STRVAL_P(zendlval), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		Z_STRLEN_P(zendlval) = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  Z_STRVAL_P(zendlval) = (char *) estrndup(yytext, yyleng);
	  Z_STRLEN_P(zendlval) = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
#line 1160 "Zend/zend_language_scanner.c"
yy4:
		YYDEBUG(4, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy3;
yy5:
		YYDEBUG(5, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'O') {
			if (yych == '=') goto yy45;
		} else {
			if (yych <= 'P') goto yy47;
			if (yych == 'p') goto yy47;
		}
yy6:
		YYDEBUG(6, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1739 "Zend/zend_language_scanner.l"
		{
	if (CG(short_tags)) {
		ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1188 "Zend/zend_language_scanner.c"
yy7:
		YYDEBUG(7, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy43;
		YYDEBUG(8, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1720 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
#line 1205 "Zend/zend_language_scanner.c"
yy9:
		YYDEBUG(9, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy11;
		if (yych == 'c') goto yy11;
yy10:
		YYDEBUG(10, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 0) {
			goto yy3;
		} else {
			goto yy6;
		}
yy11:
		YYDEBUG(11, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy12;
		if (yych != 'r') goto yy10;
yy12:
		YYDEBUG(12, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy13;
		if (yych != 'i') goto yy10;
yy13:
		YYDEBUG(13, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy14;
		if (yych != 'p') goto yy10;
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy15;
		if (yych != 't') goto yy10;
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy10;
		if (yych == 'l') goto yy10;
		goto yy17;
yy16:
		YYDEBUG(16, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy17:
		YYDEBUG(17, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy16;
		}
		if (yych == 'L') goto yy18;
		if (yych != 'l') goto yy10;
yy18:
		YYDEBUG(18, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy19;
		if (yych != 'a') goto yy10;
yy19:
		YYDEBUG(19, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy20;
		if (yych != 'n') goto yy10;
yy20:
		YYDEBUG(20, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy21;
		if (yych != 'g') goto yy10;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy22;
		if (yych != 'u') goto yy10;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy23;
		if (yych != 'a') goto yy10;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy24;
		if (yych != 'g') goto yy10;
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy25;
		if (yych != 'e') goto yy10;
yy25:
		YYDEBUG(25, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(26, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy25;
			if (yych <= '\f') goto yy10;
			goto yy25;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy25;
			} else {
				if (yych != '=') goto yy10;
			}
		}
yy27:
		YYDEBUG(27, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(28, *YYCURSOR);
		if (yych <= '!') {
			if (yych <= '\f') {
				if (yych <= 0x08) goto yy10;
				if (yych <= '\n') goto yy27;
				goto yy10;
			} else {
				if (yych <= '\r') goto yy27;
				if (yych == ' ') goto yy27;
				goto yy10;
			}
		} else {
			if (yych <= 'O') {
				if (yych <= '"') goto yy30;
				if (yych == '\'') goto yy31;
				goto yy10;
			} else {
				if (yych <= 'P') goto yy29;
				if (yych != 'p') goto yy10;
			}
		}
yy29:
		YYDEBUG(29, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy42;
		if (yych == 'h') goto yy42;
		goto yy10;
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy39;
		if (yych == 'p') goto yy39;
		goto yy10;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy32;
		if (yych != 'p') goto yy10;
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy33;
		if (yych != 'h') goto yy10;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy34;
		if (yych != 'p') goto yy10;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '\'') goto yy10;
yy35:
		YYDEBUG(35, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(36, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy10;
			if (yych <= '\n') goto yy35;
			if (yych <= '\f') goto yy10;
			goto yy35;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy10;
				goto yy35;
			} else {
				if (yych != '>') goto yy10;
			}
		}
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(38, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1686 "Zend/zend_language_scanner.l"
		{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1406 "Zend/zend_language_scanner.c"
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy40;
		if (yych != 'h') goto yy10;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy41;
		if (yych != 'p') goto yy10;
yy41:
		YYDEBUG(41, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy35;
		goto yy10;
yy42:
		YYDEBUG(42, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy35;
		if (yych == 'p') goto yy35;
		goto yy10;
yy43:
		YYDEBUG(43, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(44, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1702 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
#line 1443 "Zend/zend_language_scanner.c"
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1713 "Zend/zend_language_scanner.l"
		{
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
#line 1455 "Zend/zend_language_scanner.c"
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy48;
		if (yych != 'h') goto yy10;
yy48:
		YYDEBUG(48, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy49;
		if (yych != 'p') goto yy10;
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy10;
			if (yych >= '\v') goto yy10;
		} else {
			if (yych <= '\r') goto yy52;
			if (yych != ' ') goto yy10;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		++YYCURSOR;
yy51:
		YYDEBUG(51, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1731 "Zend/zend_language_scanner.l"
		{
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
#line 1489 "Zend/zend_language_scanner.c"
yy52:
		YYDEBUG(52, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy50;
		goto yy51;
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(53, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych != '$') goto yy60;
		} else {
			if (yych <= '`') goto yy58;
			if (yych == '{') goto yy57;
			goto yy60;
		}
		YYDEBUG(55, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy56;
			if (yych <= 'Z') goto yy63;
			if (yych >= '_') goto yy63;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy63;
			} else {
				if (yych <= '{') goto yy66;
				if (yych >= 0x7F) goto yy63;
			}
		}
yy56:
		YYDEBUG(56, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2194 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1601 "Zend/zend_language_scanner.c"
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy61;
		goto yy56;
yy58:
		YYDEBUG(58, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(59, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2138 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
#line 1617 "Zend/zend_language_scanner.c"
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy56;
yy61:
		YYDEBUG(61, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(62, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2125 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1634 "Zend/zend_language_scanner.c"
yy63:
		YYDEBUG(63, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(64, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy63;
		}
		if (yych == '-') goto yy68;
		if (yych == '[') goto yy70;
yy65:
		YYDEBUG(65, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1831 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1656 "Zend/zend_language_scanner.c"
yy66:
		YYDEBUG(66, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(67, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1465 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1667 "Zend/zend_language_scanner.c"
yy68:
		YYDEBUG(68, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy72;
yy69:
		YYDEBUG(69, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy65;
yy70:
		YYDEBUG(70, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1823 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1689 "Zend/zend_language_scanner.c"
yy72:
		YYDEBUG(72, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy69;
			if (yych <= 'Z') goto yy73;
			if (yych <= '^') goto yy69;
		} else {
			if (yych <= '`') goto yy69;
			if (yych <= 'z') goto yy73;
			if (yych <= '~') goto yy69;
		}
yy73:
		YYDEBUG(73, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1813 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1715 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(75, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy80;
			goto yy82;
		} else {
			if (yych <= '$') goto yy77;
			if (yych == '{') goto yy79;
			goto yy82;
		}
yy77:
		YYDEBUG(77, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy78;
			if (yych <= 'Z') goto yy85;
			if (yych >= '_') goto yy85;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy85;
			} else {
				if (yych <= '{') goto yy88;
				if (yych >= 0x7F) goto yy85;
			}
		}
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2144 "Zend/zend_language_scanner.l"
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 1832 "Zend/zend_language_scanner.c"
yy79:
		YYDEBUG(79, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy83;
		goto yy78;
yy80:
		YYDEBUG(80, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(81, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2133 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
#line 1848 "Zend/zend_language_scanner.c"
yy82:
		YYDEBUG(82, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy78;
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(84, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2125 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 1865 "Zend/zend_language_scanner.c"
yy85:
		YYDEBUG(85, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(86, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy85;
		}
		if (yych == '-') goto yy90;
		if (yych == '[') goto yy92;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1831 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1887 "Zend/zend_language_scanner.c"
yy88:
		YYDEBUG(88, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(89, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1465 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 1898 "Zend/zend_language_scanner.c"
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy94;
yy91:
		YYDEBUG(91, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy87;
yy92:
		YYDEBUG(92, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(93, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1823 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1920 "Zend/zend_language_scanner.c"
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy91;
			if (yych <= 'Z') goto yy95;
			if (yych <= '^') goto yy91;
		} else {
			if (yych <= '`') goto yy91;
			if (yych <= 'z') goto yy95;
			if (yych <= '~') goto yy91;
		}
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1813 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 1946 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(97, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(99, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(100, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2111 "Zend/zend_language_scanner.l"
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
#line 1970 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(101, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy103;
		if (yych == '{') goto yy105;
		goto yy106;
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy104;
			if (yych <= 'Z') goto yy109;
			if (yych >= '_') goto yy109;
		} else {
			if (yych <= 'z') {
				if (yych >= 'a') goto yy109;
			} else {
				if (yych <= '{') goto yy112;
				if (yych >= 0x7F) goto yy109;
			}
		}
yy104:
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2236 "Zend/zend_language_scanner.l"
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 2105 "Zend/zend_language_scanner.c"
yy105:
		YYDEBUG(105, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy107;
		goto yy104;
yy106:
		YYDEBUG(106, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy104;
yy107:
		YYDEBUG(107, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2125 "Zend/zend_language_scanner.l"
		{
	Z_LVAL_P(zendlval) = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
#line 2127 "Zend/zend_language_scanner.c"
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyaccept = 0;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(110, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy109;
		}
		if (yych == '-') goto yy114;
		if (yych == '[') goto yy116;
yy111:
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1831 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2149 "Zend/zend_language_scanner.c"
yy112:
		YYDEBUG(112, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1465 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
#line 2160 "Zend/zend_language_scanner.c"
yy114:
		YYDEBUG(114, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy118;
yy115:
		YYDEBUG(115, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy111;
yy116:
		YYDEBUG(116, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(117, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1823 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2182 "Zend/zend_language_scanner.c"
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy115;
			if (yych <= 'Z') goto yy119;
			if (yych <= '^') goto yy115;
		} else {
			if (yych <= '`') goto yy115;
			if (yych <= 'z') goto yy119;
			if (yych <= '~') goto yy115;
		}
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1813 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 2208 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 192,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			192,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 60,  60,  44,  44,  44,  44,  44,  44, 
			 44,  44,   0,   0,   0,   0,   0,   0, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  0,  36,  36,  36,  36,  36,  36,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   0,   0,   0,   0,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
			  4,   4,   4,   4,   4,   4,   4,   4, 
		};
		YYDEBUG(121, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 0x00:
		case 0x01:
		case 0x02:
		case 0x03:
		case 0x04:
		case 0x05:
		case 0x06:
		case 0x07:
		case 0x08:
		case '\v':
		case '\f':
		case 0x0E:
		case 0x0F:
		case 0x10:
		case 0x11:
		case 0x12:
		case 0x13:
		case 0x14:
		case 0x15:
		case 0x16:
		case 0x17:
		case 0x18:
		case 0x19:
		case 0x1A:
		case 0x1B:
		case 0x1C:
		case 0x1D:
		case 0x1E:
		case 0x1F:	goto yy184;
		case '\t':
		case '\n':
		case '\r':
		case ' ':	goto yy140;
		case '!':	goto yy154;
		case '"':	goto yy180;
		case '#':	goto yy176;
		case '$':	goto yy165;
		case '%':	goto yy159;
		case '&':	goto yy160;
		case '\'':	goto yy178;
		case '(':	goto yy148;
		case ')':
		case ',':
		case ';':
		case '@':
		case '[':
		case ']':
		case '~':	goto yy166;
		case '*':	goto yy157;
		case '+':	goto yy153;
		case '-':	goto yy138;
		case '.':	goto yy145;
		case '/':	goto yy158;
		case '0':	goto yy172;
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
		case '8':
		case '9':	goto yy174;
		case ':':	goto yy142;
		case '<':	goto yy155;
		case '=':	goto yy151;
		case '>':	goto yy156;
		case '?':	goto yy167;
		case 'A':
		case 'a':	goto yy133;
		case 'B':
		case 'b':	goto yy135;
		case 'C':
		case 'c':	goto yy127;
		case 'D':
		case 'd':	goto yy125;
		case 'E':
		case 'e':	goto yy123;
		case 'F':
		case 'f':	goto yy126;
		case 'G':
		case 'g':	goto yy136;
		case 'I':
		case 'i':	goto yy131;
		case 'L':
		case 'l':	goto yy152;
		case 'N':
		case 'n':	goto yy146;
		case 'O':
		case 'o':	goto yy163;
		case 'P':
		case 'p':	goto yy137;
		case 'R':
		case 'r':	goto yy128;
		case 'S':
		case 's':	goto yy134;
		case 'T':
		case 't':	goto yy130;
		case 'U':
		case 'u':	goto yy149;
		case 'V':
		case 'v':	goto yy147;
		case 'W':
		case 'w':	goto yy132;
		case 'X':
		case 'x':	goto yy164;
		case 'Y':
		case 'y':	goto yy129;
		case '\\':	goto yy143;
		case '^':	goto yy162;
		case '_':	goto yy150;
		case '`':	goto yy182;
		case '{':	goto yy168;
		case '|':	goto yy161;
		case '}':	goto yy170;
		default:	goto yy175;
		}
yy123:
		YYDEBUG(123, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(-1, yych);
		switch ((yych = *YYCURSOR)) {
		case 'C':
		case 'c':	goto yy742;
		case 'L':
		case 'l':	goto yy743;
		case 'M':
		case 'm':	goto yy744;
		case 'N':
		case 'n':	goto yy745;
		case 'V':
		case 'v':	goto yy746;
		case 'X':
		case 'x':	goto yy747;
		default:	goto yy187;
		}
yy124:
		YYDEBUG(124, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1854 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 2397 "Zend/zend_language_scanner.c"
yy125:
		YYDEBUG(125, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'H') {
				if (yych == 'E') goto yy724;
				goto yy187;
			} else {
				if (yych <= 'I') goto yy725;
				if (yych <= 'N') goto yy187;
				goto yy726;
			}
		} else {
			if (yych <= 'h') {
				if (yych == 'e') goto yy724;
				goto yy187;
			} else {
				if (yych <= 'i') goto yy725;
				if (yych == 'o') goto yy726;
				goto yy187;
			}
		}
yy126:
		YYDEBUG(126, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych <= 'N') {
				if (yych == 'I') goto yy700;
				goto yy187;
			} else {
				if (yych <= 'O') goto yy701;
				if (yych <= 'T') goto yy187;
				goto yy702;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'i') goto yy700;
				goto yy187;
			} else {
				if (yych <= 'o') goto yy701;
				if (yych == 'u') goto yy702;
				goto yy187;
			}
		}
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych <= 'K') {
				if (yych == 'A') goto yy665;
				goto yy187;
			} else {
				if (yych <= 'L') goto yy666;
				if (yych <= 'N') goto yy187;
				goto yy667;
			}
		} else {
			if (yych <= 'k') {
				if (yych == 'a') goto yy665;
				goto yy187;
			} else {
				if (yych <= 'l') goto yy666;
				if (yych == 'o') goto yy667;
				goto yy187;
			}
		}
yy128:
		YYDEBUG(128, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy647;
		if (yych == 'e') goto yy647;
		goto yy187;
yy129:
		YYDEBUG(129, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy642;
		if (yych == 'i') goto yy642;
		goto yy187;
yy130:
		YYDEBUG(130, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'R') {
			if (yych == 'H') goto yy630;
			if (yych <= 'Q') goto yy187;
			goto yy631;
		} else {
			if (yych <= 'h') {
				if (yych <= 'g') goto yy187;
				goto yy630;
			} else {
				if (yych == 'r') goto yy631;
				goto yy187;
			}
		}
yy131:
		YYDEBUG(131, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'L') {
				if (yych == 'F') goto yy577;
				goto yy187;
			} else {
				if (yych <= 'M') goto yy579;
				if (yych <= 'N') goto yy580;
				if (yych <= 'R') goto yy187;
				goto yy581;
			}
		} else {
			if (yych <= 'm') {
				if (yych == 'f') goto yy577;
				if (yych <= 'l') goto yy187;
				goto yy579;
			} else {
				if (yych <= 'n') goto yy580;
				if (yych == 's') goto yy581;
				goto yy187;
			}
		}
yy132:
		YYDEBUG(132, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy572;
		if (yych == 'h') goto yy572;
		goto yy187;
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych <= 'M') {
				if (yych == 'B') goto yy554;
				goto yy187;
			} else {
				if (yych <= 'N') goto yy555;
				if (yych <= 'Q') goto yy187;
				if (yych <= 'R') goto yy556;
				goto yy557;
			}
		} else {
			if (yych <= 'n') {
				if (yych == 'b') goto yy554;
				if (yych <= 'm') goto yy187;
				goto yy555;
			} else {
				if (yych <= 'q') goto yy187;
				if (yych <= 'r') goto yy556;
				if (yych <= 's') goto yy557;
				goto yy187;
			}
		}
yy134:
		YYDEBUG(134, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'W') {
			if (yych == 'T') goto yy542;
			if (yych <= 'V') goto yy187;
			goto yy543;
		} else {
			if (yych <= 't') {
				if (yych <= 's') goto yy187;
				goto yy542;
			} else {
				if (yych == 'w') goto yy543;
				goto yy187;
			}
		}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych <= '"') {
				if (yych <= '!') goto yy187;
				goto yy534;
			} else {
				if (yych == '\'') goto yy535;
				goto yy187;
			}
		} else {
			if (yych <= 'R') {
				if (yych <= '<') goto yy533;
				if (yych <= 'Q') goto yy187;
				goto yy536;
			} else {
				if (yych == 'r') goto yy536;
				goto yy187;
			}
		}
yy136:
		YYDEBUG(136, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'L') goto yy523;
			if (yych <= 'N') goto yy187;
			goto yy524;
		} else {
			if (yych <= 'l') {
				if (yych <= 'k') goto yy187;
				goto yy523;
			} else {
				if (yych == 'o') goto yy524;
				goto yy187;
			}
		}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'R') goto yy499;
			if (yych <= 'T') goto yy187;
			goto yy500;
		} else {
			if (yych <= 'r') {
				if (yych <= 'q') goto yy187;
				goto yy499;
			} else {
				if (yych == 'u') goto yy500;
				goto yy187;
			}
		}
yy138:
		YYDEBUG(138, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '<') {
			if (yych == '-') goto yy495;
		} else {
			if (yych <= '=') goto yy493;
			if (yych <= '>') goto yy497;
		}
yy139:
		YYDEBUG(139, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1454 "Zend/zend_language_scanner.l"
		{
	return yytext[0];
}
#line 2633 "Zend/zend_language_scanner.c"
yy140:
		YYDEBUG(140, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy492;
yy141:
		YYDEBUG(141, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1175 "Zend/zend_language_scanner.l"
		{
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 2648 "Zend/zend_language_scanner.c"
yy142:
		YYDEBUG(142, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy489;
		goto yy139;
yy143:
		YYDEBUG(143, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(144, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1202 "Zend/zend_language_scanner.l"
		{
	return T_NS_SEPARATOR;
}
#line 2663 "Zend/zend_language_scanner.c"
yy145:
		YYDEBUG(145, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '/') {
			if (yych == '.') goto yy486;
			goto yy139;
		} else {
			if (yych <= '9') goto yy482;
			if (yych == '=') goto yy484;
			goto yy139;
		}
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy470;
			if (yych <= 'D') goto yy187;
			goto yy471;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy187;
				goto yy470;
			} else {
				if (yych == 'e') goto yy471;
				goto yy187;
			}
		}
yy147:
		YYDEBUG(147, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy467;
		if (yych == 'a') goto yy467;
		goto yy187;
yy148:
		YYDEBUG(148, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy392;
					if (yych <= 0x1F) goto yy139;
					goto yy392;
				} else {
					if (yych <= '@') goto yy139;
					if (yych == 'C') goto yy139;
					goto yy392;
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy392;
					if (yych <= 'H') goto yy139;
					goto yy392;
				} else {
					if (yych == 'O') goto yy392;
					if (yych <= 'Q') goto yy139;
					goto yy392;
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'b') {
					if (yych == 'U') goto yy392;
					if (yych <= '`') goto yy139;
					goto yy392;
				} else {
					if (yych == 'd') goto yy392;
					if (yych <= 'e') goto yy139;
					goto yy392;
				}
			} else {
				if (yych <= 'o') {
					if (yych == 'i') goto yy392;
					if (yych <= 'n') goto yy139;
					goto yy392;
				} else {
					if (yych <= 's') {
						if (yych <= 'q') goto yy139;
						goto yy392;
					} else {
						if (yych == 'u') goto yy392;
						goto yy139;
					}
				}
			}
		}
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'S') {
			if (yych == 'N') goto yy383;
			if (yych <= 'R') goto yy187;
			goto yy384;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy187;
				goto yy383;
			} else {
				if (yych == 's') goto yy384;
				goto yy187;
			}
		}
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy301;
		goto yy187;
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy139;
		if (yych <= '=') goto yy295;
		if (yych <= '>') goto yy297;
		goto yy139;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy291;
		if (yych == 'i') goto yy291;
		goto yy187;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy289;
		if (yych == '=') goto yy287;
		goto yy139;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy284;
		goto yy139;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy256;
			goto yy139;
		} else {
			if (yych <= '<') goto yy254;
			if (yych <= '=') goto yy257;
			if (yych <= '>') goto yy259;
			goto yy139;
		}
yy156:
		YYDEBUG(156, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy139;
		if (yych <= '=') goto yy250;
		if (yych <= '>') goto yy248;
		goto yy139;
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '*') goto yy242;
		if (yych == '=') goto yy244;
		goto yy139;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy234;
			goto yy139;
		} else {
			if (yych <= '/') goto yy236;
			if (yych == '=') goto yy237;
			goto yy139;
		}
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy139;
		if (yych <= '=') goto yy230;
		if (yych <= '>') goto yy228;
		goto yy139;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy224;
		if (yych == '=') goto yy226;
		goto yy139;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy222;
		if (yych == '|') goto yy220;
		goto yy139;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy218;
		goto yy139;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy216;
		if (yych == 'r') goto yy216;
		goto yy187;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy213;
		if (yych == 'o') goto yy213;
		goto yy187;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy139;
			if (yych <= 'Z') goto yy210;
			if (yych <= '^') goto yy139;
			goto yy210;
		} else {
			if (yych <= '`') goto yy139;
			if (yych <= 'z') goto yy210;
			if (yych <= '~') goto yy139;
			goto yy210;
		}
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy139;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy206;
		goto yy139;
yy168:
		YYDEBUG(168, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1459 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
#line 2902 "Zend/zend_language_scanner.c"
yy170:
		YYDEBUG(170, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(171, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1471 "Zend/zend_language_scanner.l"
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
#line 2916 "Zend/zend_language_scanner.c"
yy172:
		YYDEBUG(172, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'E') {
			if (yych <= '9') {
				if (yych == '.') goto yy188;
				if (yych >= '0') goto yy191;
			} else {
				if (yych == 'B') goto yy199;
				if (yych >= 'E') goto yy193;
			}
		} else {
			if (yych <= 'b') {
				if (yych == 'X') goto yy198;
				if (yych >= 'b') goto yy199;
			} else {
				if (yych <= 'e') {
					if (yych >= 'e') goto yy193;
				} else {
					if (yych == 'x') goto yy198;
				}
			}
		}
yy173:
		YYDEBUG(173, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1521 "Zend/zend_language_scanner.l"
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		Z_LVAL_P(zendlval) = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		Z_LVAL_P(zendlval) = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				Z_DVAL_P(zendlval) = zend_oct_strtod(yytext, NULL);
			} else {
				Z_DVAL_P(zendlval) = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
#line 2965 "Zend/zend_language_scanner.c"
yy174:
		YYDEBUG(174, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy188;
			if (yych <= '/') goto yy173;
			goto yy191;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy173;
				goto yy193;
			} else {
				if (yych == 'e') goto yy193;
				goto yy173;
			}
		}
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy187;
yy176:
		YYDEBUG(176, *YYCURSOR);
		++YYCURSOR;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1861 "Zend/zend_language_scanner.l"
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
#line 3027 "Zend/zend_language_scanner.c"
yy178:
		YYDEBUG(178, *YYCURSOR);
		++YYCURSOR;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1948 "Zend/zend_language_scanner.l"
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	ZVAL_STRINGL(zendlval, yytext+bprefix+1, yyleng-bprefix-2, 1);

	/* convert escape sequences */
	s = t = Z_STRVAL_P(zendlval);
	end = s+Z_STRLEN_P(zendlval);
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					Z_STRLEN_P(zendlval)--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = Z_STRVAL_P(zendlval);
		SCNG(output_filter)((unsigned char **)&Z_STRVAL_P(zendlval), &sz, (unsigned char *)s, (size_t)Z_STRLEN_P(zendlval) TSRMLS_CC);
		Z_STRLEN_P(zendlval) = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
#line 3100 "Zend/zend_language_scanner.c"
yy180:
		YYDEBUG(180, *YYCURSOR);
		++YYCURSOR;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2015 "Zend/zend_language_scanner.l"
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
#line 3148 "Zend/zend_language_scanner.c"
yy182:
		YYDEBUG(182, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(183, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2105 "Zend/zend_language_scanner.l"
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
#line 3159 "Zend/zend_language_scanner.c"
yy184:
		YYDEBUG(184, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(185, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2368 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 3174 "Zend/zend_language_scanner.c"
yy186:
		YYDEBUG(186, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy187:
		YYDEBUG(187, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy186;
		}
		goto yy124;
yy188:
		YYDEBUG(188, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy188;
		}
		if (yych == 'E') goto yy193;
		if (yych == 'e') goto yy193;
yy190:
		YYDEBUG(190, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1580 "Zend/zend_language_scanner.l"
		{
	ZVAL_DOUBLE(zendlval, zend_strtod(yytext, NULL));
	return T_DNUMBER;
}
#line 3206 "Zend/zend_language_scanner.c"
yy191:
		YYDEBUG(191, *YYCURSOR);
		yyaccept = 2;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(192, *YYCURSOR);
		if (yych <= '9') {
			if (yych == '.') goto yy188;
			if (yych <= '/') goto yy173;
			goto yy191;
		} else {
			if (yych <= 'E') {
				if (yych <= 'D') goto yy173;
			} else {
				if (yych != 'e') goto yy173;
			}
		}
yy193:
		YYDEBUG(193, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy195;
		} else {
			if (yych <= '-') goto yy195;
			if (yych <= '/') goto yy194;
			if (yych <= '9') goto yy196;
		}
yy194:
		YYDEBUG(194, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept <= 0) {
					goto yy124;
				} else {
					goto yy139;
				}
			} else {
				goto yy173;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept <= 3) {
					goto yy190;
				} else {
					goto yy235;
				}
			} else {
				goto yy255;
			}
		}
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy194;
		if (yych >= ':') goto yy194;
yy196:
		YYDEBUG(196, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(197, *YYCURSOR);
		if (yych <= '/') goto yy190;
		if (yych <= '9') goto yy196;
		goto yy190;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 32) {
			goto yy203;
		}
		goto yy194;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy200;
		}
		goto yy194;
yy200:
		YYDEBUG(200, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(201, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy200;
		}
		YYDEBUG(202, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1497 "Zend/zend_language_scanner.l"
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		if (len == 0) {
			Z_LVAL_P(zendlval) = 0;
		} else {
			Z_LVAL_P(zendlval) = strtol(bin, NULL, 2);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_bin_strtod(bin, NULL));
		return T_DNUMBER;
	}
}
#line 3322 "Zend/zend_language_scanner.c"
yy203:
		YYDEBUG(203, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(204, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy203;
		}
		YYDEBUG(205, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1542 "Zend/zend_language_scanner.l"
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			Z_LVAL_P(zendlval) = 0;
		} else {
			Z_LVAL_P(zendlval) = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		ZVAL_DOUBLE(zendlval, zend_hex_strtod(hex, NULL));
		return T_DNUMBER;
	}
}
#line 3358 "Zend/zend_language_scanner.c"
yy206:
		YYDEBUG(206, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy208;
		if (yych == '\r') goto yy209;
yy207:
		YYDEBUG(207, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1929 "Zend/zend_language_scanner.l"
		{
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
#line 3373 "Zend/zend_language_scanner.c"
yy208:
		YYDEBUG(208, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy207;
yy209:
		YYDEBUG(209, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy208;
		goto yy207;
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy210;
			} else {
				if (yych <= '@') goto yy212;
				if (yych <= 'Z') goto yy210;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy210;
			} else {
				if (yych <= 'z') goto yy210;
				if (yych >= 0x7F) goto yy210;
			}
		}
yy212:
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1831 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 3413 "Zend/zend_language_scanner.c"
yy213:
		YYDEBUG(213, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy214;
		if (yych != 'r') goto yy187;
yy214:
		YYDEBUG(214, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1442 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_XOR;
}
#line 3431 "Zend/zend_language_scanner.c"
yy216:
		YYDEBUG(216, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(217, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1434 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_OR;
}
#line 3444 "Zend/zend_language_scanner.c"
yy218:
		YYDEBUG(218, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(219, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1422 "Zend/zend_language_scanner.l"
		{
	return T_XOR_EQUAL;
}
#line 3454 "Zend/zend_language_scanner.c"
yy220:
		YYDEBUG(220, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(221, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1426 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_OR;
}
#line 3464 "Zend/zend_language_scanner.c"
yy222:
		YYDEBUG(222, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(223, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1418 "Zend/zend_language_scanner.l"
		{
	return T_OR_EQUAL;
}
#line 3474 "Zend/zend_language_scanner.c"
yy224:
		YYDEBUG(224, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(225, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1430 "Zend/zend_language_scanner.l"
		{
	return T_BOOLEAN_AND;
}
#line 3484 "Zend/zend_language_scanner.c"
yy226:
		YYDEBUG(226, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(227, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1414 "Zend/zend_language_scanner.l"
		{
	return T_AND_EQUAL;
}
#line 3494 "Zend/zend_language_scanner.c"
yy228:
		YYDEBUG(228, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '\n') goto yy232;
		if (yych == '\r') goto yy233;
yy229:
		YYDEBUG(229, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1936 "Zend/zend_language_scanner.l"
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
#line 3514 "Zend/zend_language_scanner.c"
yy230:
		YYDEBUG(230, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(231, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1402 "Zend/zend_language_scanner.l"
		{
	return T_MOD_EQUAL;
}
#line 3524 "Zend/zend_language_scanner.c"
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy229;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy232;
		goto yy229;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy239;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1895 "Zend/zend_language_scanner.l"
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
#line 3576 "Zend/zend_language_scanner.c"
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy177;
yy237:
		YYDEBUG(237, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(238, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1394 "Zend/zend_language_scanner.l"
		{
	return T_DIV_EQUAL;
}
#line 3590 "Zend/zend_language_scanner.c"
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy240;
		}
		goto yy194;
yy240:
		YYDEBUG(240, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(241, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy240;
		}
		goto yy235;
yy242:
		YYDEBUG(242, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy246;
		YYDEBUG(243, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1386 "Zend/zend_language_scanner.l"
		{
	return T_POW;
}
#line 3618 "Zend/zend_language_scanner.c"
yy244:
		YYDEBUG(244, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(245, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1382 "Zend/zend_language_scanner.l"
		{
	return T_MUL_EQUAL;
}
#line 3628 "Zend/zend_language_scanner.c"
yy246:
		YYDEBUG(246, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(247, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1390 "Zend/zend_language_scanner.l"
		{
	return T_POW_EQUAL;
}
#line 3638 "Zend/zend_language_scanner.c"
yy248:
		YYDEBUG(248, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy252;
		YYDEBUG(249, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1450 "Zend/zend_language_scanner.l"
		{
	return T_SR;
}
#line 3649 "Zend/zend_language_scanner.c"
yy250:
		YYDEBUG(250, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(251, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1370 "Zend/zend_language_scanner.l"
		{
	return T_IS_GREATER_OR_EQUAL;
}
#line 3659 "Zend/zend_language_scanner.c"
yy252:
		YYDEBUG(252, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(253, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1410 "Zend/zend_language_scanner.l"
		{
	return T_SR_EQUAL;
}
#line 3669 "Zend/zend_language_scanner.c"
yy254:
		YYDEBUG(254, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy255;
		if (yych <= '<') goto yy270;
		if (yych <= '=') goto yy268;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1446 "Zend/zend_language_scanner.l"
		{
	return T_SL;
}
#line 3684 "Zend/zend_language_scanner.c"
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy261;
		if (yych == 's') goto yy261;
		goto yy194;
yy257:
		YYDEBUG(257, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(258, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1366 "Zend/zend_language_scanner.l"
		{
	return T_IS_SMALLER_OR_EQUAL;
}
#line 3700 "Zend/zend_language_scanner.c"
yy259:
		YYDEBUG(259, *YYCURSOR);
		++YYCURSOR;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1362 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_EQUAL;
}
#line 3711 "Zend/zend_language_scanner.c"
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy262;
		if (yych != 'c') goto yy194;
yy262:
		YYDEBUG(262, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy263;
		if (yych != 'r') goto yy194;
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy264;
		if (yych != 'i') goto yy194;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy265;
		if (yych != 'p') goto yy194;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy266;
		if (yych != 't') goto yy194;
yy266:
		YYDEBUG(266, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(267, *YYCURSOR);
		if (yych <= '\r') {
			if (yych <= 0x08) goto yy194;
			if (yych <= '\n') goto yy266;
			if (yych <= '\f') goto yy194;
			goto yy266;
		} else {
			if (yych <= ' ') {
				if (yych <= 0x1F) goto yy194;
				goto yy266;
			} else {
				if (yych == '>') goto yy206;
				goto yy194;
			}
		}
yy268:
		YYDEBUG(268, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(269, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1406 "Zend/zend_language_scanner.l"
		{
	return T_SL_EQUAL;
}
#line 3766 "Zend/zend_language_scanner.c"
yy270:
		YYDEBUG(270, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(271, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy270;
		}
		if (yych <= 'Z') {
			if (yych <= '&') {
				if (yych == '"') goto yy275;
				goto yy194;
			} else {
				if (yych <= '\'') goto yy274;
				if (yych <= '@') goto yy194;
			}
		} else {
			if (yych <= '`') {
				if (yych != '_') goto yy194;
			} else {
				if (yych <= 'z') goto yy272;
				if (yych <= '~') goto yy194;
			}
		}
yy272:
		YYDEBUG(272, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(273, *YYCURSOR);
		if (yych <= '@') {
			if (yych <= '\f') {
				if (yych == '\n') goto yy279;
				goto yy194;
			} else {
				if (yych <= '\r') goto yy281;
				if (yych <= '/') goto yy194;
				if (yych <= '9') goto yy272;
				goto yy194;
			}
		} else {
			if (yych <= '_') {
				if (yych <= 'Z') goto yy272;
				if (yych <= '^') goto yy194;
				goto yy272;
			} else {
				if (yych <= '`') goto yy194;
				if (yych <= 'z') goto yy272;
				if (yych <= '~') goto yy194;
				goto yy272;
			}
		}
yy274:
		YYDEBUG(274, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy194;
		if (yych <= '/') goto yy283;
		if (yych <= '9') goto yy194;
		goto yy283;
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy194;
		if (yych <= '/') goto yy277;
		if (yych <= '9') goto yy194;
		goto yy277;
yy276:
		YYDEBUG(276, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy277:
		YYDEBUG(277, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych != '"') goto yy194;
			} else {
				if (yych <= '9') goto yy276;
				if (yych <= '@') goto yy194;
				goto yy276;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy276;
				goto yy194;
			} else {
				if (yych <= 'z') goto yy276;
				if (yych <= '~') goto yy194;
				goto yy276;
			}
		}
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy279;
		if (yych == '\r') goto yy281;
		goto yy194;
yy279:
		YYDEBUG(279, *YYCURSOR);
		++YYCURSOR;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2057 "Zend/zend_language_scanner.l"
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
#line 3918 "Zend/zend_language_scanner.c"
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy279;
		goto yy280;
yy282:
		YYDEBUG(282, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy283:
		YYDEBUG(283, *YYCURSOR);
		if (yych <= 'Z') {
			if (yych <= '/') {
				if (yych == '\'') goto yy278;
				goto yy194;
			} else {
				if (yych <= '9') goto yy282;
				if (yych <= '@') goto yy194;
				goto yy282;
			}
		} else {
			if (yych <= '`') {
				if (yych == '_') goto yy282;
				goto yy194;
			} else {
				if (yych <= 'z') goto yy282;
				if (yych <= '~') goto yy194;
				goto yy282;
			}
		}
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '=') goto yy260;
		YYDEBUG(285, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(286, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1354 "Zend/zend_language_scanner.l"
		{
	return T_IS_NOT_IDENTICAL;
}
#line 3962 "Zend/zend_language_scanner.c"
yy287:
		YYDEBUG(287, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(288, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1374 "Zend/zend_language_scanner.l"
		{
	return T_PLUS_EQUAL;
}
#line 3972 "Zend/zend_language_scanner.c"
yy289:
		YYDEBUG(289, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(290, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1342 "Zend/zend_language_scanner.l"
		{
	return T_INC;
}
#line 3982 "Zend/zend_language_scanner.c"
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy292;
		if (yych != 's') goto yy187;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy293;
		if (yych != 't') goto yy187;
yy293:
		YYDEBUG(293, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(294, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1330 "Zend/zend_language_scanner.l"
		{
	return T_LIST;
}
#line 4005 "Zend/zend_language_scanner.c"
yy295:
		YYDEBUG(295, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '=') goto yy299;
		YYDEBUG(296, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1358 "Zend/zend_language_scanner.l"
		{
	return T_IS_EQUAL;
}
#line 4016 "Zend/zend_language_scanner.c"
yy297:
		YYDEBUG(297, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(298, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1326 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_ARROW;
}
#line 4026 "Zend/zend_language_scanner.c"
yy299:
		YYDEBUG(299, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(300, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1350 "Zend/zend_language_scanner.l"
		{
	return T_IS_IDENTICAL;
}
#line 4036 "Zend/zend_language_scanner.c"
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'C':
		case 'c':	goto yy303;
		case 'D':
		case 'd':	goto yy308;
		case 'F':
		case 'f':	goto yy305;
		case 'H':
		case 'h':	goto yy302;
		case 'L':
		case 'l':	goto yy307;
		case 'M':
		case 'm':	goto yy306;
		case 'N':
		case 'n':	goto yy309;
		case 'T':
		case 't':	goto yy304;
		default:	goto yy187;
		}
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy370;
		if (yych == 'a') goto yy370;
		goto yy187;
yy303:
		YYDEBUG(303, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy363;
		if (yych == 'l') goto yy363;
		goto yy187;
yy304:
		YYDEBUG(304, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy356;
		if (yych == 'r') goto yy356;
		goto yy187;
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'U') {
			if (yych == 'I') goto yy340;
			if (yych <= 'T') goto yy187;
			goto yy341;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy187;
				goto yy340;
			} else {
				if (yych == 'u') goto yy341;
				goto yy187;
			}
		}
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy332;
		if (yych == 'e') goto yy332;
		goto yy187;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy326;
		if (yych == 'i') goto yy326;
		goto yy187;
yy308:
		YYDEBUG(308, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy321;
		if (yych == 'i') goto yy321;
		goto yy187;
yy309:
		YYDEBUG(309, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy310;
		if (yych != 'a') goto yy187;
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy311;
		if (yych != 'm') goto yy187;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy312;
		if (yych != 'e') goto yy187;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy313;
		if (yych != 's') goto yy187;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy314;
		if (yych != 'p') goto yy187;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy315;
		if (yych != 'a') goto yy187;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy316;
		if (yych != 'c') goto yy187;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy317;
		if (yych != 'e') goto yy187;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(319, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(320, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1676 "Zend/zend_language_scanner.l"
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
#line 4176 "Zend/zend_language_scanner.c"
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy322;
		if (yych != 'r') goto yy187;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(324, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(325, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1651 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	ZVAL_STRING(zendlval, dirname, 0);
	return T_DIR;
}
#line 4221 "Zend/zend_language_scanner.c"
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy327;
		if (yych != 'n') goto yy187;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy328;
		if (yych != 'e') goto yy187;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(330, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(331, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1636 "Zend/zend_language_scanner.l"
		{
	ZVAL_LONG(zendlval, CG(zend_lineno));
	return T_LINE;
}
#line 4251 "Zend/zend_language_scanner.c"
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy333;
		if (yych != 't') goto yy187;
yy333:
		YYDEBUG(333, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy334;
		if (yych != 'h') goto yy187;
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy335;
		if (yych != 'o') goto yy187;
yy335:
		YYDEBUG(335, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy336;
		if (yych != 'd') goto yy187;
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(338, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(339, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1623 "Zend/zend_language_scanner.l"
		{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;

	Z_STRLEN_P(zendlval) = zend_spprintf(&Z_STRVAL_P(zendlval), 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
#line 4299 "Zend/zend_language_scanner.c"
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy351;
		if (yych == 'l') goto yy351;
		goto yy187;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy342;
		if (yych != 'n') goto yy187;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy343;
		if (yych != 'c') goto yy187;
yy343:
		YYDEBUG(343, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy344;
		if (yych != 't') goto yy187;
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy345;
		if (yych != 'i') goto yy187;
yy345:
		YYDEBUG(345, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy346;
		if (yych != 'o') goto yy187;
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy347;
		if (yych != 'n') goto yy187;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(349, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(350, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1613 "Zend/zend_language_scanner.l"
		{
	zend_op_array *op_array = CG(active_op_array);
	if (op_array && op_array->function_name) {
		ZVAL_STRING(zendlval, op_array->function_name, 1);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_FUNC_C;
}
#line 4360 "Zend/zend_language_scanner.c"
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy352;
		if (yych != 'e') goto yy187;
yy352:
		YYDEBUG(352, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(354, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(355, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1641 "Zend/zend_language_scanner.l"
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	ZVAL_STRING(zendlval, filename, 1);
	return T_FILE;
}
#line 4390 "Zend/zend_language_scanner.c"
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy357;
		if (yych != 'a') goto yy187;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy358;
		if (yych != 'i') goto yy187;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy359;
		if (yych != 't') goto yy187;
yy359:
		YYDEBUG(359, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(361, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(362, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1603 "Zend/zend_language_scanner.l"
		{
	zend_class_entry *ce = CG(active_class_entry);
	if (ce && ce->name && ZEND_ACC_TRAIT == (ce->ce_flags & ZEND_ACC_TRAIT)) {
		ZVAL_STRINGL(zendlval, ce->name, ce->name_length, 1);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_TRAIT_C;
}
#line 4430 "Zend/zend_language_scanner.c"
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy364;
		if (yych != 'a') goto yy187;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy365;
		if (yych != 's') goto yy187;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy366;
		if (yych != 's') goto yy187;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(368, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(369, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1585 "Zend/zend_language_scanner.l"
		{
	zend_class_entry *ce = CG(active_class_entry);
	if (ce && ZEND_ACC_TRAIT == (ce->ce_flags & ZEND_ACC_TRAIT)) {
		/* We create a special __CLASS__ constant that is going to be resolved
		   at run-time */
		Z_STRLEN_P(zendlval) = sizeof("__CLASS__")-1;
		Z_STRVAL_P(zendlval) = estrndup("__CLASS__", Z_STRLEN_P(zendlval));
		zendlval->type = IS_CONSTANT;
	} else {
		if (ce && ce->name) {
			ZVAL_STRINGL(zendlval, ce->name, ce->name_length, 1);
		} else {
			ZVAL_EMPTY_STRING(zendlval);
		}
	}
	return T_CLASS_C;
}
#line 4478 "Zend/zend_language_scanner.c"
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy371;
		if (yych != 'l') goto yy187;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy372;
		if (yych != 't') goto yy187;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '_') goto yy187;
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy374;
		if (yych != 'c') goto yy187;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy375;
		if (yych != 'o') goto yy187;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy376;
		if (yych != 'm') goto yy187;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy377;
		if (yych != 'p') goto yy187;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy378;
		if (yych != 'i') goto yy187;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy379;
		if (yych != 'l') goto yy187;
yy379:
		YYDEBUG(379, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy380;
		if (yych != 'e') goto yy187;
yy380:
		YYDEBUG(380, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy381;
		if (yych != 'r') goto yy187;
yy381:
		YYDEBUG(381, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(382, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1294 "Zend/zend_language_scanner.l"
		{
	return T_HALT_COMPILER;
}
#line 4544 "Zend/zend_language_scanner.c"
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy387;
		if (yych == 's') goto yy387;
		goto yy187;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy385;
		if (yych != 'e') goto yy187;
yy385:
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(386, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1274 "Zend/zend_language_scanner.l"
		{
	return T_USE;
}
#line 4568 "Zend/zend_language_scanner.c"
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy388;
		if (yych != 'e') goto yy187;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy389;
		if (yych != 't') goto yy187;
yy389:
		YYDEBUG(389, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(390, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1322 "Zend/zend_language_scanner.l"
		{
	return T_UNSET;
}
#line 4591 "Zend/zend_language_scanner.c"
yy391:
		YYDEBUG(391, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy392:
		YYDEBUG(392, *YYCURSOR);
		if (yych <= 'S') {
			if (yych <= 'D') {
				if (yych <= ' ') {
					if (yych == '\t') goto yy391;
					if (yych <= 0x1F) goto yy194;
					goto yy391;
				} else {
					if (yych <= 'A') {
						if (yych <= '@') goto yy194;
						goto yy396;
					} else {
						if (yych <= 'B') goto yy394;
						if (yych <= 'C') goto yy194;
						goto yy399;
					}
				}
			} else {
				if (yych <= 'I') {
					if (yych == 'F') goto yy400;
					if (yych <= 'H') goto yy194;
					goto yy401;
				} else {
					if (yych <= 'O') {
						if (yych <= 'N') goto yy194;
						goto yy395;
					} else {
						if (yych <= 'Q') goto yy194;
						if (yych <= 'R') goto yy398;
						goto yy397;
					}
				}
			}
		} else {
			if (yych <= 'f') {
				if (yych <= 'a') {
					if (yych == 'U') goto yy393;
					if (yych <= '`') goto yy194;
					goto yy396;
				} else {
					if (yych <= 'c') {
						if (yych <= 'b') goto yy394;
						goto yy194;
					} else {
						if (yych <= 'd') goto yy399;
						if (yych <= 'e') goto yy194;
						goto yy400;
					}
				}
			} else {
				if (yych <= 'q') {
					if (yych <= 'i') {
						if (yych <= 'h') goto yy194;
						goto yy401;
					} else {
						if (yych == 'o') goto yy395;
						goto yy194;
					}
				} else {
					if (yych <= 's') {
						if (yych <= 'r') goto yy398;
						goto yy397;
					} else {
						if (yych != 'u') goto yy194;
					}
				}
			}
		}
yy393:
		YYDEBUG(393, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy460;
		if (yych == 'n') goto yy460;
		goto yy194;
yy394:
		YYDEBUG(394, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy447;
			if (yych <= 'N') goto yy194;
			goto yy448;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy194;
				goto yy447;
			} else {
				if (yych == 'o') goto yy448;
				goto yy194;
			}
		}
yy395:
		YYDEBUG(395, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy439;
		if (yych == 'b') goto yy439;
		goto yy194;
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy432;
		if (yych == 'r') goto yy432;
		goto yy194;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy424;
		if (yych == 't') goto yy424;
		goto yy194;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy422;
		if (yych == 'e') goto yy422;
		goto yy194;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy418;
		if (yych == 'o') goto yy418;
		goto yy194;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy411;
		if (yych == 'l') goto yy411;
		goto yy194;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy402;
		if (yych != 'n') goto yy194;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy403;
		if (yych != 't') goto yy194;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy404;
		if (yych != 'e') goto yy406;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy409;
		if (yych == 'g') goto yy409;
		goto yy194;
yy405:
		YYDEBUG(405, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy406:
		YYDEBUG(406, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy405;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy405;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(407, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1222 "Zend/zend_language_scanner.l"
		{
	return T_INT_CAST;
}
#line 4767 "Zend/zend_language_scanner.c"
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy410;
		if (yych != 'e') goto yy194;
yy410:
		YYDEBUG(410, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy405;
		if (yych == 'r') goto yy405;
		goto yy194;
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy412;
		if (yych != 'o') goto yy194;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy413;
		if (yych != 'a') goto yy194;
yy413:
		YYDEBUG(413, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy414;
		if (yych != 't') goto yy194;
yy414:
		YYDEBUG(414, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(415, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy414;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy414;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(416, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(417, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1226 "Zend/zend_language_scanner.l"
		{
	return T_DOUBLE_CAST;
}
#line 4815 "Zend/zend_language_scanner.c"
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy419;
		if (yych != 'u') goto yy194;
yy419:
		YYDEBUG(419, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy420;
		if (yych != 'b') goto yy194;
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy421;
		if (yych != 'l') goto yy194;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy414;
		if (yych == 'e') goto yy414;
		goto yy194;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy423;
		if (yych != 'a') goto yy194;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy414;
		if (yych == 'l') goto yy414;
		goto yy194;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy425;
		if (yych != 'r') goto yy194;
yy425:
		YYDEBUG(425, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy426;
		if (yych != 'i') goto yy194;
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy427;
		if (yych != 'n') goto yy194;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'G') goto yy428;
		if (yych != 'g') goto yy194;
yy428:
		YYDEBUG(428, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(429, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy428;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy428;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(430, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(431, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1230 "Zend/zend_language_scanner.l"
		{
	return T_STRING_CAST;
}
#line 4889 "Zend/zend_language_scanner.c"
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy433;
		if (yych != 'r') goto yy194;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy434;
		if (yych != 'a') goto yy194;
yy434:
		YYDEBUG(434, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy435;
		if (yych != 'y') goto yy194;
yy435:
		YYDEBUG(435, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(436, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy435;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy435;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(437, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(438, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1234 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY_CAST;
}
#line 4926 "Zend/zend_language_scanner.c"
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'J') goto yy440;
		if (yych != 'j') goto yy194;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy441;
		if (yych != 'e') goto yy194;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy442;
		if (yych != 'c') goto yy194;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy443;
		if (yych != 't') goto yy194;
yy443:
		YYDEBUG(443, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(444, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy443;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy443;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(445, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(446, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1238 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_CAST;
}
#line 4968 "Zend/zend_language_scanner.c"
yy447:
		YYDEBUG(447, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy457;
		if (yych == 'n') goto yy457;
		goto yy194;
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy449;
		if (yych != 'o') goto yy194;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy450;
		if (yych != 'l') goto yy194;
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy455;
		if (yych == 'e') goto yy455;
		goto yy452;
yy451:
		YYDEBUG(451, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy452:
		YYDEBUG(452, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy451;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy451;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(453, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(454, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1242 "Zend/zend_language_scanner.l"
		{
	return T_BOOL_CAST;
}
#line 5013 "Zend/zend_language_scanner.c"
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy456;
		if (yych != 'a') goto yy194;
yy456:
		YYDEBUG(456, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy451;
		if (yych == 'n') goto yy451;
		goto yy194;
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy458;
		if (yych != 'a') goto yy194;
yy458:
		YYDEBUG(458, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy459;
		if (yych != 'r') goto yy194;
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy428;
		if (yych == 'y') goto yy428;
		goto yy194;
yy460:
		YYDEBUG(460, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy461;
		if (yych != 's') goto yy194;
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy462;
		if (yych != 'e') goto yy194;
yy462:
		YYDEBUG(462, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy463;
		if (yych != 't') goto yy194;
yy463:
		YYDEBUG(463, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(464, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy463;
			goto yy194;
		} else {
			if (yych <= ' ') goto yy463;
			if (yych != ')') goto yy194;
		}
		YYDEBUG(465, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(466, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1246 "Zend/zend_language_scanner.l"
		{
	return T_UNSET_CAST;
}
#line 5077 "Zend/zend_language_scanner.c"
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy468;
		if (yych != 'r') goto yy187;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(469, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1218 "Zend/zend_language_scanner.l"
		{
	return T_VAR;
}
#line 5095 "Zend/zend_language_scanner.c"
yy470:
		YYDEBUG(470, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy474;
		if (yych == 'm') goto yy474;
		goto yy187;
yy471:
		YYDEBUG(471, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy472;
		if (yych != 'w') goto yy187;
yy472:
		YYDEBUG(472, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(473, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1210 "Zend/zend_language_scanner.l"
		{
	return T_NEW;
}
#line 5119 "Zend/zend_language_scanner.c"
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy475;
		if (yych != 'e') goto yy187;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy476;
		if (yych != 's') goto yy187;
yy476:
		YYDEBUG(476, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy477;
		if (yych != 'p') goto yy187;
yy477:
		YYDEBUG(477, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy478;
		if (yych != 'a') goto yy187;
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy479;
		if (yych != 'c') goto yy187;
yy479:
		YYDEBUG(479, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy480;
		if (yych != 'e') goto yy187;
yy480:
		YYDEBUG(480, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(481, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1270 "Zend/zend_language_scanner.l"
		{
	return T_NAMESPACE;
}
#line 5162 "Zend/zend_language_scanner.c"
yy482:
		YYDEBUG(482, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(483, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy190;
			if (yych <= '9') goto yy482;
			goto yy190;
		} else {
			if (yych <= 'E') goto yy193;
			if (yych == 'e') goto yy193;
			goto yy190;
		}
yy484:
		YYDEBUG(484, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(485, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1398 "Zend/zend_language_scanner.l"
		{
	return T_CONCAT_EQUAL;
}
#line 5188 "Zend/zend_language_scanner.c"
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != '.') goto yy194;
		YYDEBUG(487, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(488, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1206 "Zend/zend_language_scanner.l"
		{
	return T_ELLIPSIS;
}
#line 5201 "Zend/zend_language_scanner.c"
yy489:
		YYDEBUG(489, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(490, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1198 "Zend/zend_language_scanner.l"
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
#line 5211 "Zend/zend_language_scanner.c"
yy491:
		YYDEBUG(491, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy492:
		YYDEBUG(492, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy141;
			if (yych <= '\n') goto yy491;
			goto yy141;
		} else {
			if (yych <= '\r') goto yy491;
			if (yych == ' ') goto yy491;
			goto yy141;
		}
yy493:
		YYDEBUG(493, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(494, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1378 "Zend/zend_language_scanner.l"
		{
	return T_MINUS_EQUAL;
}
#line 5237 "Zend/zend_language_scanner.c"
yy495:
		YYDEBUG(495, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(496, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1346 "Zend/zend_language_scanner.l"
		{
	return T_DEC;
}
#line 5247 "Zend/zend_language_scanner.c"
yy497:
		YYDEBUG(497, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(498, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1170 "Zend/zend_language_scanner.l"
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
#line 5258 "Zend/zend_language_scanner.c"
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'I') goto yy506;
			if (yych <= 'N') goto yy187;
			goto yy507;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy187;
				goto yy506;
			} else {
				if (yych == 'o') goto yy507;
				goto yy187;
			}
		}
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy501;
		if (yych != 'b') goto yy187;
yy501:
		YYDEBUG(501, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy502;
		if (yych != 'l') goto yy187;
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy503;
		if (yych != 'i') goto yy187;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy504;
		if (yych != 'c') goto yy187;
yy504:
		YYDEBUG(504, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(505, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1318 "Zend/zend_language_scanner.l"
		{
	return T_PUBLIC;
}
#line 5307 "Zend/zend_language_scanner.c"
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'V') {
			if (yych == 'N') goto yy515;
			if (yych <= 'U') goto yy187;
			goto yy516;
		} else {
			if (yych <= 'n') {
				if (yych <= 'm') goto yy187;
				goto yy515;
			} else {
				if (yych == 'v') goto yy516;
				goto yy187;
			}
		}
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy508;
		if (yych != 't') goto yy187;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy509;
		if (yych != 'e') goto yy187;
yy509:
		YYDEBUG(509, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy510;
		if (yych != 'c') goto yy187;
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy511;
		if (yych != 't') goto yy187;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy512;
		if (yych != 'e') goto yy187;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy513;
		if (yych != 'd') goto yy187;
yy513:
		YYDEBUG(513, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(514, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1314 "Zend/zend_language_scanner.l"
		{
	return T_PROTECTED;
}
#line 5366 "Zend/zend_language_scanner.c"
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy521;
		if (yych == 't') goto yy521;
		goto yy187;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy517;
		if (yych != 'a') goto yy187;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy518;
		if (yych != 't') goto yy187;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy519;
		if (yych != 'e') goto yy187;
yy519:
		YYDEBUG(519, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(520, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1310 "Zend/zend_language_scanner.l"
		{
	return T_PRIVATE;
}
#line 5400 "Zend/zend_language_scanner.c"
yy521:
		YYDEBUG(521, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(522, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1146 "Zend/zend_language_scanner.l"
		{
	return T_PRINT;
}
#line 5413 "Zend/zend_language_scanner.c"
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy528;
		if (yych == 'o') goto yy528;
		goto yy187;
yy524:
		YYDEBUG(524, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy525;
		if (yych != 't') goto yy187;
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy526;
		if (yych != 'o') goto yy187;
yy526:
		YYDEBUG(526, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(527, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1138 "Zend/zend_language_scanner.l"
		{
	return T_GOTO;
}
#line 5442 "Zend/zend_language_scanner.c"
yy528:
		YYDEBUG(528, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy529;
		if (yych != 'b') goto yy187;
yy529:
		YYDEBUG(529, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy530;
		if (yych != 'a') goto yy187;
yy530:
		YYDEBUG(530, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy531;
		if (yych != 'l') goto yy187;
yy531:
		YYDEBUG(531, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(532, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1282 "Zend/zend_language_scanner.l"
		{
	return T_GLOBAL;
}
#line 5470 "Zend/zend_language_scanner.c"
yy533:
		YYDEBUG(533, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy541;
		goto yy194;
yy534:
		YYDEBUG(534, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy181;
yy535:
		YYDEBUG(535, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy179;
yy536:
		YYDEBUG(536, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy537;
		if (yych != 'e') goto yy187;
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy538;
		if (yych != 'a') goto yy187;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'K') goto yy539;
		if (yych != 'k') goto yy187;
yy539:
		YYDEBUG(539, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1130 "Zend/zend_language_scanner.l"
		{
	return T_BREAK;
}
#line 5511 "Zend/zend_language_scanner.c"
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy270;
		goto yy194;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy549;
		if (yych == 'a') goto yy549;
		goto yy187;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy544;
		if (yych != 'i') goto yy187;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy545;
		if (yych != 't') goto yy187;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy546;
		if (yych != 'c') goto yy187;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy547;
		if (yych != 'h') goto yy187;
yy547:
		YYDEBUG(547, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(548, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1114 "Zend/zend_language_scanner.l"
		{
	return T_SWITCH;
}
#line 5555 "Zend/zend_language_scanner.c"
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy550;
		if (yych != 't') goto yy187;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy551;
		if (yych != 'i') goto yy187;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy552;
		if (yych != 'c') goto yy187;
yy552:
		YYDEBUG(552, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(553, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1298 "Zend/zend_language_scanner.l"
		{
	return T_STATIC;
}
#line 5583 "Zend/zend_language_scanner.c"
yy554:
		YYDEBUG(554, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy565;
		if (yych == 's') goto yy565;
		goto yy187;
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy563;
		if (yych == 'd') goto yy563;
		goto yy187;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy559;
		if (yych == 'r') goto yy559;
		goto yy187;
yy557:
		YYDEBUG(557, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(558, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1110 "Zend/zend_language_scanner.l"
		{
	return T_AS;
}
#line 5614 "Zend/zend_language_scanner.c"
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy560;
		if (yych != 'a') goto yy187;
yy560:
		YYDEBUG(560, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy561;
		if (yych != 'y') goto yy187;
yy561:
		YYDEBUG(561, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1334 "Zend/zend_language_scanner.l"
		{
	return T_ARRAY;
}
#line 5637 "Zend/zend_language_scanner.c"
yy563:
		YYDEBUG(563, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(564, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1438 "Zend/zend_language_scanner.l"
		{
	return T_LOGICAL_AND;
}
#line 5650 "Zend/zend_language_scanner.c"
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy566;
		if (yych != 't') goto yy187;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy567;
		if (yych != 'r') goto yy187;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy568;
		if (yych != 'a') goto yy187;
yy568:
		YYDEBUG(568, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy569;
		if (yych != 'c') goto yy187;
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy570;
		if (yych != 't') goto yy187;
yy570:
		YYDEBUG(570, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(571, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1302 "Zend/zend_language_scanner.l"
		{
	return T_ABSTRACT;
}
#line 5688 "Zend/zend_language_scanner.c"
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy573;
		if (yych != 'i') goto yy187;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy574;
		if (yych != 'l') goto yy187;
yy574:
		YYDEBUG(574, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy575;
		if (yych != 'e') goto yy187;
yy575:
		YYDEBUG(575, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(576, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1070 "Zend/zend_language_scanner.l"
		{
	return T_WHILE;
}
#line 5716 "Zend/zend_language_scanner.c"
yy577:
		YYDEBUG(577, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(578, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1054 "Zend/zend_language_scanner.l"
		{
	return T_IF;
}
#line 5729 "Zend/zend_language_scanner.c"
yy579:
		YYDEBUG(579, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy621;
		if (yych == 'p') goto yy621;
		goto yy187;
yy580:
		YYDEBUG(580, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'C') {
				if (yych <= 'B') goto yy187;
				goto yy588;
			} else {
				if (yych <= 'R') goto yy187;
				if (yych <= 'S') goto yy586;
				goto yy587;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'c') goto yy588;
				goto yy187;
			} else {
				if (yych <= 's') goto yy586;
				if (yych <= 't') goto yy587;
				goto yy187;
			}
		}
yy581:
		YYDEBUG(581, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy582;
		if (yych != 's') goto yy187;
yy582:
		YYDEBUG(582, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy583;
		if (yych != 'e') goto yy187;
yy583:
		YYDEBUG(583, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy584;
		if (yych != 't') goto yy187;
yy584:
		YYDEBUG(584, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(585, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1286 "Zend/zend_language_scanner.l"
		{
	return T_ISSET;
}
#line 5785 "Zend/zend_language_scanner.c"
yy586:
		YYDEBUG(586, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy607;
		if (yych == 't') goto yy607;
		goto yy187;
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy600;
		if (yych == 'e') goto yy600;
		goto yy187;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy589;
		if (yych != 'l') goto yy187;
yy589:
		YYDEBUG(589, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy590;
		if (yych != 'u') goto yy187;
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy591;
		if (yych != 'd') goto yy187;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy592;
		if (yych != 'e') goto yy187;
yy592:
		YYDEBUG(592, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy186;
			} else {
				if (yych <= '@') goto yy593;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy594;
			} else {
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy593:
		YYDEBUG(593, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1254 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE;
}
#line 5843 "Zend/zend_language_scanner.c"
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy595;
		if (yych != 'o') goto yy187;
yy595:
		YYDEBUG(595, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy596;
		if (yych != 'n') goto yy187;
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy597;
		if (yych != 'c') goto yy187;
yy597:
		YYDEBUG(597, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy598;
		if (yych != 'e') goto yy187;
yy598:
		YYDEBUG(598, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(599, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1258 "Zend/zend_language_scanner.l"
		{
	return T_INCLUDE_ONCE;
}
#line 5876 "Zend/zend_language_scanner.c"
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy601;
		if (yych != 'r') goto yy187;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy602;
		if (yych != 'f') goto yy187;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy603;
		if (yych != 'a') goto yy187;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy604;
		if (yych != 'c') goto yy187;
yy604:
		YYDEBUG(604, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy605;
		if (yych != 'e') goto yy187;
yy605:
		YYDEBUG(605, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(606, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1154 "Zend/zend_language_scanner.l"
		{
	return T_INTERFACE;
}
#line 5914 "Zend/zend_language_scanner.c"
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'E') {
			if (yych == 'A') goto yy608;
			if (yych <= 'D') goto yy187;
			goto yy609;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy187;
			} else {
				if (yych == 'e') goto yy609;
				goto yy187;
			}
		}
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy615;
		if (yych == 'n') goto yy615;
		goto yy187;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy610;
		if (yych != 'a') goto yy187;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy611;
		if (yych != 'd') goto yy187;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy612;
		if (yych != 'o') goto yy187;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy613;
		if (yych != 'f') goto yy187;
yy613:
		YYDEBUG(613, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(614, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1278 "Zend/zend_language_scanner.l"
		{
        return T_INSTEADOF;
}
#line 5968 "Zend/zend_language_scanner.c"
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy616;
		if (yych != 'c') goto yy187;
yy616:
		YYDEBUG(616, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy617;
		if (yych != 'e') goto yy187;
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy618;
		if (yych != 'o') goto yy187;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy619;
		if (yych != 'f') goto yy187;
yy619:
		YYDEBUG(619, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(620, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1106 "Zend/zend_language_scanner.l"
		{
	return T_INSTANCEOF;
}
#line 6001 "Zend/zend_language_scanner.c"
yy621:
		YYDEBUG(621, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy622;
		if (yych != 'l') goto yy187;
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy623;
		if (yych != 'e') goto yy187;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy624;
		if (yych != 'm') goto yy187;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy625;
		if (yych != 'e') goto yy187;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy626;
		if (yych != 'n') goto yy187;
yy626:
		YYDEBUG(626, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy627;
		if (yych != 't') goto yy187;
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy628;
		if (yych != 's') goto yy187;
yy628:
		YYDEBUG(628, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(629, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1166 "Zend/zend_language_scanner.l"
		{
	return T_IMPLEMENTS;
}
#line 6049 "Zend/zend_language_scanner.c"
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy638;
		if (yych == 'r') goto yy638;
		goto yy187;
yy631:
		YYDEBUG(631, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'Y') {
			if (yych == 'A') goto yy634;
			if (yych <= 'X') goto yy187;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy187;
				goto yy634;
			} else {
				if (yych != 'y') goto yy187;
			}
		}
		YYDEBUG(632, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1038 "Zend/zend_language_scanner.l"
		{
	return T_TRY;
}
#line 6081 "Zend/zend_language_scanner.c"
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy635;
		if (yych != 'i') goto yy187;
yy635:
		YYDEBUG(635, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy636;
		if (yych != 't') goto yy187;
yy636:
		YYDEBUG(636, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1158 "Zend/zend_language_scanner.l"
		{
	return T_TRAIT;
}
#line 6104 "Zend/zend_language_scanner.c"
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy639;
		if (yych != 'o') goto yy187;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy640;
		if (yych != 'w') goto yy187;
yy640:
		YYDEBUG(640, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1050 "Zend/zend_language_scanner.l"
		{
	return T_THROW;
}
#line 6127 "Zend/zend_language_scanner.c"
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy643;
		if (yych != 'e') goto yy187;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy644;
		if (yych != 'l') goto yy187;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy645;
		if (yych != 'd') goto yy187;
yy645:
		YYDEBUG(645, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(646, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1034 "Zend/zend_language_scanner.l"
		{
	return T_YIELD;
}
#line 6155 "Zend/zend_language_scanner.c"
yy647:
		YYDEBUG(647, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'Q') goto yy649;
			if (yych <= 'S') goto yy187;
		} else {
			if (yych <= 'q') {
				if (yych <= 'p') goto yy187;
				goto yy649;
			} else {
				if (yych != 't') goto yy187;
			}
		}
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy661;
		if (yych == 'u') goto yy661;
		goto yy187;
yy649:
		YYDEBUG(649, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy650;
		if (yych != 'u') goto yy187;
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy651;
		if (yych != 'i') goto yy187;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy652;
		if (yych != 'r') goto yy187;
yy652:
		YYDEBUG(652, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy653;
		if (yych != 'e') goto yy187;
yy653:
		YYDEBUG(653, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy186;
			} else {
				if (yych <= '@') goto yy654;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy655;
			} else {
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy654:
		YYDEBUG(654, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1262 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE;
}
#line 6220 "Zend/zend_language_scanner.c"
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy656;
		if (yych != 'o') goto yy187;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy657;
		if (yych != 'n') goto yy187;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy658;
		if (yych != 'c') goto yy187;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy659;
		if (yych != 'e') goto yy187;
yy659:
		YYDEBUG(659, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1266 "Zend/zend_language_scanner.l"
		{
	return T_REQUIRE_ONCE;
}
#line 6253 "Zend/zend_language_scanner.c"
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy662;
		if (yych != 'r') goto yy187;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy663;
		if (yych != 'n') goto yy187;
yy663:
		YYDEBUG(663, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1030 "Zend/zend_language_scanner.l"
		{
	return T_RETURN;
}
#line 6276 "Zend/zend_language_scanner.c"
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'L') {
				if (yych <= 'K') goto yy187;
				goto yy688;
			} else {
				if (yych <= 'R') goto yy187;
				if (yych <= 'S') goto yy687;
				goto yy686;
			}
		} else {
			if (yych <= 'r') {
				if (yych == 'l') goto yy688;
				goto yy187;
			} else {
				if (yych <= 's') goto yy687;
				if (yych <= 't') goto yy686;
				goto yy187;
			}
		}
yy666:
		YYDEBUG(666, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'O') {
			if (yych == 'A') goto yy678;
			if (yych <= 'N') goto yy187;
			goto yy679;
		} else {
			if (yych <= 'a') {
				if (yych <= '`') goto yy187;
				goto yy678;
			} else {
				if (yych == 'o') goto yy679;
				goto yy187;
			}
		}
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy668;
		if (yych != 'n') goto yy187;
yy668:
		YYDEBUG(668, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych <= 'R') goto yy187;
			if (yych >= 'T') goto yy670;
		} else {
			if (yych <= 'r') goto yy187;
			if (yych <= 's') goto yy669;
			if (yych <= 't') goto yy670;
			goto yy187;
		}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy676;
		if (yych == 't') goto yy676;
		goto yy187;
yy670:
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy671;
		if (yych != 'i') goto yy187;
yy671:
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy672;
		if (yych != 'n') goto yy187;
yy672:
		YYDEBUG(672, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy673;
		if (yych != 'u') goto yy187;
yy673:
		YYDEBUG(673, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy674;
		if (yych != 'e') goto yy187;
yy674:
		YYDEBUG(674, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(675, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1134 "Zend/zend_language_scanner.l"
		{
	return T_CONTINUE;
}
#line 6370 "Zend/zend_language_scanner.c"
yy676:
		YYDEBUG(676, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(677, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1026 "Zend/zend_language_scanner.l"
		{
	return T_CONST;
}
#line 6383 "Zend/zend_language_scanner.c"
yy678:
		YYDEBUG(678, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy683;
		if (yych == 's') goto yy683;
		goto yy187;
yy679:
		YYDEBUG(679, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy680;
		if (yych != 'n') goto yy187;
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy681;
		if (yych != 'e') goto yy187;
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(682, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1214 "Zend/zend_language_scanner.l"
		{
	return T_CLONE;
}
#line 6412 "Zend/zend_language_scanner.c"
yy683:
		YYDEBUG(683, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy684;
		if (yych != 's') goto yy187;
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1150 "Zend/zend_language_scanner.l"
		{
	return T_CLASS;
}
#line 6430 "Zend/zend_language_scanner.c"
yy686:
		YYDEBUG(686, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy697;
		if (yych == 'c') goto yy697;
		goto yy187;
yy687:
		YYDEBUG(687, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy695;
		if (yych == 'e') goto yy695;
		goto yy187;
yy688:
		YYDEBUG(688, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy689;
		if (yych != 'l') goto yy187;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy690;
		if (yych != 'a') goto yy187;
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'B') goto yy691;
		if (yych != 'b') goto yy187;
yy691:
		YYDEBUG(691, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy692;
		if (yych != 'l') goto yy187;
yy692:
		YYDEBUG(692, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy693;
		if (yych != 'e') goto yy187;
yy693:
		YYDEBUG(693, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(694, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1338 "Zend/zend_language_scanner.l"
		{
 return T_CALLABLE;
}
#line 6480 "Zend/zend_language_scanner.c"
yy695:
		YYDEBUG(695, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1122 "Zend/zend_language_scanner.l"
		{
	return T_CASE;
}
#line 6493 "Zend/zend_language_scanner.c"
yy697:
		YYDEBUG(697, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy698;
		if (yych != 'h') goto yy187;
yy698:
		YYDEBUG(698, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(699, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1042 "Zend/zend_language_scanner.l"
		{
	return T_CATCH;
}
#line 6511 "Zend/zend_language_scanner.c"
yy700:
		YYDEBUG(700, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy717;
		if (yych == 'n') goto yy717;
		goto yy187;
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy710;
		if (yych == 'r') goto yy710;
		goto yy187;
yy702:
		YYDEBUG(702, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy703;
		if (yych != 'n') goto yy187;
yy703:
		YYDEBUG(703, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy704;
		if (yych != 'c') goto yy187;
yy704:
		YYDEBUG(704, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy705;
		if (yych != 't') goto yy187;
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy706;
		if (yych != 'i') goto yy187;
yy706:
		YYDEBUG(706, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy707;
		if (yych != 'o') goto yy187;
yy707:
		YYDEBUG(707, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy708;
		if (yych != 'n') goto yy187;
yy708:
		YYDEBUG(708, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(709, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1022 "Zend/zend_language_scanner.l"
		{
	return T_FUNCTION;
}
#line 6566 "Zend/zend_language_scanner.c"
yy710:
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy711;
				if (yych <= '9') goto yy186;
			} else {
				if (yych == 'E') goto yy712;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy186;
			} else {
				if (yych <= 'e') goto yy712;
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1082 "Zend/zend_language_scanner.l"
		{
	return T_FOR;
}
#line 6594 "Zend/zend_language_scanner.c"
yy712:
		YYDEBUG(712, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy713;
		if (yych != 'a') goto yy187;
yy713:
		YYDEBUG(713, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy714;
		if (yych != 'c') goto yy187;
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy715;
		if (yych != 'h') goto yy187;
yy715:
		YYDEBUG(715, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(716, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1090 "Zend/zend_language_scanner.l"
		{
	return T_FOREACH;
}
#line 6622 "Zend/zend_language_scanner.c"
yy717:
		YYDEBUG(717, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy718;
		if (yych != 'a') goto yy187;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy719;
		if (yych != 'l') goto yy187;
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy720;
				if (yych <= '9') goto yy186;
			} else {
				if (yych == 'L') goto yy721;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= 'k') {
				if (yych != '`') goto yy186;
			} else {
				if (yych <= 'l') goto yy721;
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy720:
		YYDEBUG(720, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1306 "Zend/zend_language_scanner.l"
		{
	return T_FINAL;
}
#line 6660 "Zend/zend_language_scanner.c"
yy721:
		YYDEBUG(721, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy722;
		if (yych != 'y') goto yy187;
yy722:
		YYDEBUG(722, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(723, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1046 "Zend/zend_language_scanner.l"
		{
	return T_FINALLY;
}
#line 6678 "Zend/zend_language_scanner.c"
yy724:
		YYDEBUG(724, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'F') {
			if (yych == 'C') goto yy730;
			if (yych <= 'E') goto yy187;
			goto yy731;
		} else {
			if (yych <= 'c') {
				if (yych <= 'b') goto yy187;
				goto yy730;
			} else {
				if (yych == 'f') goto yy731;
				goto yy187;
			}
		}
yy725:
		YYDEBUG(725, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy728;
		if (yych == 'e') goto yy728;
		goto yy187;
yy726:
		YYDEBUG(726, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(727, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1078 "Zend/zend_language_scanner.l"
		{
	return T_DO;
}
#line 6713 "Zend/zend_language_scanner.c"
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1018 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6726 "Zend/zend_language_scanner.c"
yy730:
		YYDEBUG(730, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy737;
		if (yych == 'l') goto yy737;
		goto yy187;
yy731:
		YYDEBUG(731, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy732;
		if (yych != 'a') goto yy187;
yy732:
		YYDEBUG(732, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'U') goto yy733;
		if (yych != 'u') goto yy187;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy734;
		if (yych != 'l') goto yy187;
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy735;
		if (yych != 't') goto yy187;
yy735:
		YYDEBUG(735, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(736, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1126 "Zend/zend_language_scanner.l"
		{
	return T_DEFAULT;
}
#line 6765 "Zend/zend_language_scanner.c"
yy737:
		YYDEBUG(737, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy738;
		if (yych != 'a') goto yy187;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy739;
		if (yych != 'r') goto yy187;
yy739:
		YYDEBUG(739, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy740;
		if (yych != 'e') goto yy187;
yy740:
		YYDEBUG(740, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(741, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1098 "Zend/zend_language_scanner.l"
		{
	return T_DECLARE;
}
#line 6793 "Zend/zend_language_scanner.c"
yy742:
		YYDEBUG(742, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy804;
		if (yych == 'h') goto yy804;
		goto yy187;
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy798;
		if (yych == 's') goto yy798;
		goto yy187;
yy744:
		YYDEBUG(744, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy794;
		if (yych == 'p') goto yy794;
		goto yy187;
yy745:
		YYDEBUG(745, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy760;
		if (yych == 'd') goto yy760;
		goto yy187;
yy746:
		YYDEBUG(746, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy757;
		if (yych == 'a') goto yy757;
		goto yy187;
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'T') {
			if (yych == 'I') goto yy748;
			if (yych <= 'S') goto yy187;
			goto yy749;
		} else {
			if (yych <= 'i') {
				if (yych <= 'h') goto yy187;
			} else {
				if (yych == 't') goto yy749;
				goto yy187;
			}
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy755;
		if (yych == 't') goto yy755;
		goto yy187;
yy749:
		YYDEBUG(749, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy750;
		if (yych != 'e') goto yy187;
yy750:
		YYDEBUG(750, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy751;
		if (yych != 'n') goto yy187;
yy751:
		YYDEBUG(751, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy752;
		if (yych != 'd') goto yy187;
yy752:
		YYDEBUG(752, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy753;
		if (yych != 's') goto yy187;
yy753:
		YYDEBUG(753, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(754, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1162 "Zend/zend_language_scanner.l"
		{
	return T_EXTENDS;
}
#line 6877 "Zend/zend_language_scanner.c"
yy755:
		YYDEBUG(755, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(756, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1014 "Zend/zend_language_scanner.l"
		{
	return T_EXIT;
}
#line 6890 "Zend/zend_language_scanner.c"
yy757:
		YYDEBUG(757, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy758;
		if (yych != 'l') goto yy187;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1250 "Zend/zend_language_scanner.l"
		{
	return T_EVAL;
}
#line 6908 "Zend/zend_language_scanner.c"
yy760:
		YYDEBUG(760, *YYCURSOR);
		yych = *++YYCURSOR;
		YYDEBUG(-1, yych);
		switch (yych) {
		case 'D':
		case 'd':	goto yy761;
		case 'F':
		case 'f':	goto yy762;
		case 'I':
		case 'i':	goto yy763;
		case 'S':
		case 's':	goto yy764;
		case 'W':
		case 'w':	goto yy765;
		default:	goto yy187;
		}
yy761:
		YYDEBUG(761, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy787;
		if (yych == 'e') goto yy787;
		goto yy187;
yy762:
		YYDEBUG(762, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy779;
		if (yych == 'o') goto yy779;
		goto yy187;
yy763:
		YYDEBUG(763, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy777;
		if (yych == 'f') goto yy777;
		goto yy187;
yy764:
		YYDEBUG(764, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'W') goto yy771;
		if (yych == 'w') goto yy771;
		goto yy187;
yy765:
		YYDEBUG(765, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy766;
		if (yych != 'h') goto yy187;
yy766:
		YYDEBUG(766, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy767;
		if (yych != 'i') goto yy187;
yy767:
		YYDEBUG(767, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy768;
		if (yych != 'l') goto yy187;
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy769;
		if (yych != 'e') goto yy187;
yy769:
		YYDEBUG(769, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1074 "Zend/zend_language_scanner.l"
		{
	return T_ENDWHILE;
}
#line 6982 "Zend/zend_language_scanner.c"
yy771:
		YYDEBUG(771, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy772;
		if (yych != 'i') goto yy187;
yy772:
		YYDEBUG(772, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy773;
		if (yych != 't') goto yy187;
yy773:
		YYDEBUG(773, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy774;
		if (yych != 'c') goto yy187;
yy774:
		YYDEBUG(774, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy775;
		if (yych != 'h') goto yy187;
yy775:
		YYDEBUG(775, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(776, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1118 "Zend/zend_language_scanner.l"
		{
	return T_ENDSWITCH;
}
#line 7015 "Zend/zend_language_scanner.c"
yy777:
		YYDEBUG(777, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(778, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1062 "Zend/zend_language_scanner.l"
		{
	return T_ENDIF;
}
#line 7028 "Zend/zend_language_scanner.c"
yy779:
		YYDEBUG(779, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy780;
		if (yych != 'r') goto yy187;
yy780:
		YYDEBUG(780, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy781;
				if (yych <= '9') goto yy186;
			} else {
				if (yych == 'E') goto yy782;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= 'd') {
				if (yych != '`') goto yy186;
			} else {
				if (yych <= 'e') goto yy782;
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy781:
		YYDEBUG(781, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1086 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOR;
}
#line 7061 "Zend/zend_language_scanner.c"
yy782:
		YYDEBUG(782, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy783;
		if (yych != 'a') goto yy187;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy784;
		if (yych != 'c') goto yy187;
yy784:
		YYDEBUG(784, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy785;
		if (yych != 'h') goto yy187;
yy785:
		YYDEBUG(785, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(786, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1094 "Zend/zend_language_scanner.l"
		{
	return T_ENDFOREACH;
}
#line 7089 "Zend/zend_language_scanner.c"
yy787:
		YYDEBUG(787, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy788;
		if (yych != 'c') goto yy187;
yy788:
		YYDEBUG(788, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy789;
		if (yych != 'l') goto yy187;
yy789:
		YYDEBUG(789, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy790;
		if (yych != 'a') goto yy187;
yy790:
		YYDEBUG(790, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy791;
		if (yych != 'r') goto yy187;
yy791:
		YYDEBUG(791, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy792;
		if (yych != 'e') goto yy187;
yy792:
		YYDEBUG(792, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(793, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1102 "Zend/zend_language_scanner.l"
		{
	return T_ENDDECLARE;
}
#line 7127 "Zend/zend_language_scanner.c"
yy794:
		YYDEBUG(794, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy795;
		if (yych != 't') goto yy187;
yy795:
		YYDEBUG(795, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'Y') goto yy796;
		if (yych != 'y') goto yy187;
yy796:
		YYDEBUG(796, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(797, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1290 "Zend/zend_language_scanner.l"
		{
	return T_EMPTY;
}
#line 7150 "Zend/zend_language_scanner.c"
yy798:
		YYDEBUG(798, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy799;
		if (yych != 'e') goto yy187;
yy799:
		YYDEBUG(799, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '^') {
			if (yych <= '@') {
				if (yych <= '/') goto yy800;
				if (yych <= '9') goto yy186;
			} else {
				if (yych == 'I') goto yy801;
				if (yych <= 'Z') goto yy186;
			}
		} else {
			if (yych <= 'h') {
				if (yych != '`') goto yy186;
			} else {
				if (yych <= 'i') goto yy801;
				if (yych <= 'z') goto yy186;
				if (yych >= 0x7F) goto yy186;
			}
		}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1066 "Zend/zend_language_scanner.l"
		{
	return T_ELSE;
}
#line 7183 "Zend/zend_language_scanner.c"
yy801:
		YYDEBUG(801, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'F') goto yy802;
		if (yych != 'f') goto yy187;
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1058 "Zend/zend_language_scanner.l"
		{
	return T_ELSEIF;
}
#line 7201 "Zend/zend_language_scanner.c"
yy804:
		YYDEBUG(804, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy805;
		if (yych != 'o') goto yy187;
yy805:
		YYDEBUG(805, *YYCURSOR);
		++YYCURSOR;
		if (yybm[0+(yych = *YYCURSOR)] & 4) {
			goto yy186;
		}
		YYDEBUG(806, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1142 "Zend/zend_language_scanner.l"
		{
	return T_ECHO;
}
#line 7219 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			  0,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,   0,   0,   0,   0,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
			 64,  64,  64,  64,  64,  64,  64,  64, 
		};
		YYDEBUG(807, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '-') {
			if (yych <= '\r') {
				if (yych <= 0x08) goto yy815;
				if (yych <= '\n') goto yy809;
				if (yych <= '\f') goto yy815;
			} else {
				if (yych == ' ') goto yy809;
				if (yych <= ',') goto yy815;
				goto yy811;
			}
		} else {
			if (yych <= '_') {
				if (yych <= '@') goto yy815;
				if (yych <= 'Z') goto yy813;
				if (yych <= '^') goto yy815;
				goto yy813;
			} else {
				if (yych <= '`') goto yy815;
				if (yych <= 'z') goto yy813;
				if (yych <= '~') goto yy815;
				goto yy813;
			}
		}
yy809:
		YYDEBUG(809, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy821;
yy810:
		YYDEBUG(810, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1175 "Zend/zend_language_scanner.l"
		{
	ZVAL_STRINGL(zendlval, yytext, yyleng, 0); /* no copying - intentional */
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
#line 7298 "Zend/zend_language_scanner.c"
yy811:
		YYDEBUG(811, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) == '>') goto yy818;
yy812:
		YYDEBUG(812, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1192 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
#line 7312 "Zend/zend_language_scanner.c"
yy813:
		YYDEBUG(813, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy817;
yy814:
		YYDEBUG(814, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1185 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7328 "Zend/zend_language_scanner.c"
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy812;
yy816:
		YYDEBUG(816, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy817:
		YYDEBUG(817, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy816;
		}
		goto yy814;
yy818:
		YYDEBUG(818, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(819, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1181 "Zend/zend_language_scanner.l"
		{
	return T_OBJECT_OPERATOR;
}
#line 7353 "Zend/zend_language_scanner.c"
yy820:
		YYDEBUG(820, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy821:
		YYDEBUG(821, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy820;
		}
		goto yy810;
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(822, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy826;
			if (yych <= 'Z') goto yy824;
			if (yych <= '^') goto yy826;
		} else {
			if (yych <= '`') goto yy826;
			if (yych <= 'z') goto yy824;
			if (yych <= '~') goto yy826;
		}
yy824:
		YYDEBUG(824, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '_') {
			if (yych <= '@') {
				if (yych <= '/') goto yy825;
				if (yych <= '9') goto yy828;
			} else {
				if (yych <= '[') goto yy828;
				if (yych >= '_') goto yy828;
			}
		} else {
			if (yych <= '|') {
				if (yych <= '`') goto yy825;
				if (yych <= 'z') goto yy828;
			} else {
				if (yych != '~') goto yy828;
			}
		}
yy825:
		YYDEBUG(825, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1490 "Zend/zend_language_scanner.l"
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
#line 7445 "Zend/zend_language_scanner.c"
yy826:
		YYDEBUG(826, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy825;
yy827:
		YYDEBUG(827, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy828:
		YYDEBUG(828, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy827;
		}
		if (yych == '[') goto yy830;
		if (yych == '}') goto yy830;
		YYDEBUG(829, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy825;
yy830:
		YYDEBUG(830, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(831, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1480 "Zend/zend_language_scanner.l"
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
#line 7479 "Zend/zend_language_scanner.c"
	}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(832, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(834, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(835, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
#line 2310 "Zend/zend_language_scanner.l"
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7547 "Zend/zend_language_scanner.c"
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 112, 112, 112, 112, 112, 112, 
			112, 112,   0,   0,   0,   0,   0,   0, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0,  80,  80,  80,  80,  80,  80,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(836, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		if (yych <= '/') {
			if (yych <= ' ') {
				if (yych <= '\f') {
					if (yych <= 0x08) goto yy850;
					if (yych <= '\n') goto yy846;
					goto yy850;
				} else {
					if (yych <= '\r') goto yy846;
					if (yych <= 0x1F) goto yy850;
					goto yy846;
				}
			} else {
				if (yych <= '$') {
					if (yych <= '"') goto yy845;
					if (yych <= '#') goto yy846;
					goto yy841;
				} else {
					if (yych == '\'') goto yy846;
					goto yy845;
				}
			}
		} else {
			if (yych <= '\\') {
				if (yych <= '@') {
					if (yych <= '0') goto yy838;
					if (yych <= '9') goto yy840;
					goto yy845;
				} else {
					if (yych <= 'Z') goto yy848;
					if (yych <= '[') goto yy845;
					goto yy846;
				}
			} else {
				if (yych <= '_') {
					if (yych <= ']') goto yy843;
					if (yych <= '^') goto yy845;
					goto yy848;
				} else {
					if (yych <= '`') goto yy845;
					if (yych <= 'z') goto yy848;
					if (yych <= '~') goto yy845;
					goto yy848;
				}
			}
		}
yy838:
		YYDEBUG(838, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'W') {
			if (yych <= '9') {
				if (yych >= '0') goto yy862;
			} else {
				if (yych == 'B') goto yy859;
			}
		} else {
			if (yych <= 'b') {
				if (yych <= 'X') goto yy861;
				if (yych >= 'b') goto yy859;
			} else {
				if (yych == 'x') goto yy861;
			}
		}
yy839:
		YYDEBUG(839, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1566 "Zend/zend_language_scanner.l"
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		ZVAL_LONG(zendlval, strtol(yytext, NULL, 10));
	} else {
		ZVAL_STRINGL(zendlval, yytext, yyleng, 1);
	}
	return T_NUM_STRING;
}
#line 7663 "Zend/zend_language_scanner.c"
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy858;
yy841:
		YYDEBUG(841, *YYCURSOR);
		++YYCURSOR;
		if ((yych = *YYCURSOR) <= '_') {
			if (yych <= '@') goto yy842;
			if (yych <= 'Z') goto yy854;
			if (yych >= '_') goto yy854;
		} else {
			if (yych <= '`') goto yy842;
			if (yych <= 'z') goto yy854;
			if (yych >= 0x7F) goto yy854;
		}
yy842:
		YYDEBUG(842, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1842 "Zend/zend_language_scanner.l"
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
#line 7688 "Zend/zend_language_scanner.c"
yy843:
		YYDEBUG(843, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(844, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1837 "Zend/zend_language_scanner.l"
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
#line 7699 "Zend/zend_language_scanner.c"
yy845:
		YYDEBUG(845, *YYCURSOR);
		yych = *++YYCURSOR;
		goto yy842;
yy846:
		YYDEBUG(846, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(847, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1847 "Zend/zend_language_scanner.l"
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
#line 7716 "Zend/zend_language_scanner.c"
yy848:
		YYDEBUG(848, *YYCURSOR);
		++YYCURSOR;
		yych = *YYCURSOR;
		goto yy853;
yy849:
		YYDEBUG(849, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1854 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
#line 7731 "Zend/zend_language_scanner.c"
yy850:
		YYDEBUG(850, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(851, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 2368 "Zend/zend_language_scanner.l"
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
#line 7746 "Zend/zend_language_scanner.c"
yy852:
		YYDEBUG(852, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy853:
		YYDEBUG(853, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy852;
		}
		goto yy849;
yy854:
		YYDEBUG(854, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(855, *YYCURSOR);
		if (yych <= '^') {
			if (yych <= '9') {
				if (yych >= '0') goto yy854;
			} else {
				if (yych <= '@') goto yy856;
				if (yych <= 'Z') goto yy854;
			}
		} else {
			if (yych <= '`') {
				if (yych <= '_') goto yy854;
			} else {
				if (yych <= 'z') goto yy854;
				if (yych >= 0x7F) goto yy854;
			}
		}
yy856:
		YYDEBUG(856, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1831 "Zend/zend_language_scanner.l"
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
#line 7788 "Zend/zend_language_scanner.c"
yy857:
		YYDEBUG(857, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy858:
		YYDEBUG(858, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy857;
		}
		goto yy839;
yy859:
		YYDEBUG(859, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy867;
		}
yy860:
		YYDEBUG(860, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy839;
yy861:
		YYDEBUG(861, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy865;
		}
		goto yy860;
yy862:
		YYDEBUG(862, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(863, *YYCURSOR);
		if (yych <= '/') goto yy864;
		if (yych <= '9') goto yy862;
yy864:
		YYDEBUG(864, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
#line 1575 "Zend/zend_language_scanner.l"
		{ /* Offset must be treated as a string */
	ZVAL_STRINGL(zendlval, yytext, yyleng, 1);
	return T_NUM_STRING;
}
#line 7833 "Zend/zend_language_scanner.c"
yy865:
		YYDEBUG(865, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(866, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy865;
		}
		goto yy864;
yy867:
		YYDEBUG(867, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(868, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy867;
		}
		goto yy864;
	}
}
#line 2377 "Zend/zend_language_scanner.l"

}
