/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.30 from the
 * contents of LibXML.xs. Do not edit this file, edit LibXML.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "LibXML.xs"
/* $Id$
 *
 * This is free software, you may use it and distribute it under the same terms as
 * Perl itself.
 *
 * Copyright 2001-2003 AxKit.com Ltd., 2002-2006 Christian Glahn, 2006-2009 Petr Pajas
*/

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_MSC_VER)
#define _CRT_SECURE_NO_DEPRECATE 1
#define _CRT_NONSTDC_NO_DEPRECATE 1
#endif

/* perl stuff */
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#define NEED_newRV_noinc_GLOBAL
#define NEED_sv_2pv_flags
#include "ppport.h"
#include "Av_CharPtrPtr.h"  /* XS_*_charPtrPtr() */

#include <fcntl.h>

#ifndef WIN32
#include <unistd.h>
#endif

/* libxml2 configuration properties */
#include <libxml/xmlversion.h>

#define DEBUG_C14N

/* libxml2 stuff */
#include <libxml/xmlversion.h>
#include <libxml/globals.h>
#include <libxml/xmlmemory.h>
#include <libxml/parser.h>
#include <libxml/parserInternals.h>
#include <libxml/HTMLparser.h>
#include <libxml/HTMLtree.h>
#include <libxml/c14n.h>
#include <libxml/tree.h>
#include <libxml/xpath.h>
#include <libxml/xpathInternals.h>
#include <libxml/xmlIO.h>
/* #include <libxml/debugXML.h> */
#include <libxml/xmlerror.h>
#include <libxml/xinclude.h>
#include <libxml/valid.h>

#ifdef LIBXML_PATTERN_ENABLED
#include <libxml/pattern.h>
#endif

#ifdef LIBXML_REGEXP_ENABLED
#include <libxml/xmlregexp.h>
#endif

#if LIBXML_VERSION >= 20510
#define HAVE_SCHEMAS
#include <libxml/relaxng.h>
#include <libxml/xmlschemas.h>
#endif

#if LIBXML_VERSION >= 20621
#define WITH_SERRORS
#ifdef LIBXML_READER_ENABLED
#define HAVE_READER_SUPPORT
#include <libxml/xmlreader.h>
#endif
#endif

#ifdef LIBXML_CATALOG_ENABLED
#include <libxml/catalog.h>
#endif

#ifdef HAVE_READER_SUPPORT

typedef enum {
    XML_TEXTREADER_NONE = -1,
    XML_TEXTREADER_START= 0,
    XML_TEXTREADER_ELEMENT= 1,
    XML_TEXTREADER_END= 2,
    XML_TEXTREADER_EMPTY= 3,
    XML_TEXTREADER_BACKTRACK= 4,
    XML_TEXTREADER_DONE= 5,
    XML_TEXTREADER_ERROR= 6
} xmlTextReaderState;

typedef enum {
    XML_TEXTREADER_NOT_VALIDATE = 0,
    XML_TEXTREADER_VALIDATE_DTD = 1,
    XML_TEXTREADER_VALIDATE_RNG = 2,
    XML_TEXTREADER_VALIDATE_XSD = 4
} xmlTextReaderValidate;

#endif /* HAVE_READER_SUPPORT */

/* GDOME support
 * libgdome installs only the core functions to the system.
 * this is not enough for XML::LibXML <-> XML::GDOME conversion.
 * therefore there is the need to ship as well the GDOME core headers.
 */
#ifdef XML_LIBXML_GDOME_SUPPORT

#include <libgdome/gdome.h>
#include <libgdome/gdome-libxml-util.h>

#endif


#if LIBXML_VERSION < 20621
/* HTML_PARSE_RECOVER was added in libxml2 2.6.21 */
#  define HTML_PARSE_RECOVER XML_PARSE_RECOVER
#endif


/* XML::LibXML stuff */
#include "perl-libxml-mm.h"
#include "perl-libxml-sax.h"

#include "dom.h"
#include "xpath.h"
#include "xpathcontext.h"

#ifdef __cplusplus
}
#endif


#define TEST_PERL_FLAG(flag) \
    SvTRUE(get_sv(flag, FALSE)) ? 1 : 0

#ifdef HAVE_READER_SUPPORT
#define LIBXML_READER_TEST_ELEMENT(reader,name,nsURI) \
  (xmlTextReaderNodeType(reader) == XML_READER_TYPE_ELEMENT) &&	\
   ((!nsURI && !name) \
    || \
    (!nsURI && xmlStrcmp((const xmlChar*)name, xmlTextReaderConstName(reader) ) == 0 ) \
    || \
    (nsURI && xmlStrcmp((const xmlChar*)nsURI, xmlTextReaderConstNamespaceUri(reader))==0 \
     && \
     (!name || xmlStrcmp((const xmlChar*)name, xmlTextReaderConstLocalName(reader)) == 0)))
#endif

/* this should keep the default */
static xmlExternalEntityLoader LibXML_old_ext_ent_loader = NULL;

/* global external entity loader */
SV *EXTERNAL_ENTITY_LOADER_FUNC = (SV *)NULL;

SV* PROXY_NODE_REGISTRY_MUTEX = NULL;

/* ****************************************************************
 * Error handler
 * **************************************************************** */

#ifdef WITH_SERRORS

#define INIT_READER_ERROR_HANDLER(reader)

#define PREINIT_SAVED_ERROR   SV* saved_error = sv_2mortal(newSV(0));

#define INIT_ERROR_HANDLER                                                      \
     xmlSetGenericErrorFunc((void *)saved_error,                                \
			    (xmlGenericErrorFunc) LibXML_flat_handler);         \
     xmlSetStructuredErrorFunc((void *)saved_error,			        \
			    (xmlStructuredErrorFunc)LibXML_struct_error_handler)

#define REPORT_ERROR(recover) LibXML_report_error_ctx(saved_error, recover)

#define CLEANUP_ERROR_HANDLER  xmlSetGenericErrorFunc(NULL,NULL); \
                               xmlSetStructuredErrorFunc(NULL,NULL)

#else /* WITH_SERRORS */

#define INIT_READER_ERROR_HANDLER(reader)                                 \
  if (reader)                                                             \
    xmlTextReaderSetErrorHandler(reader, LibXML_reader_error_handler,     \
                                 sv_2mortal(newSVpv("",0)));

#define PREINIT_SAVED_ERROR  SV* saved_error = sv_2mortal(newSVpv("",0));

#define INIT_ERROR_HANDLER                                                \
    xmlSetGenericErrorFunc((void *) saved_error,                          \
                           (xmlGenericErrorFunc) LibXML_error_handler_ctx)

#define REPORT_ERROR(recover) LibXML_report_error_ctx(saved_error, recover)

#define CLEANUP_ERROR_HANDLER xmlSetGenericErrorFunc(NULL,NULL);


#endif  /* WITH_SERRORS */

#ifdef WITH_SERRORS
void
LibXML_struct_error_callback(SV * saved_error, SV * libErr )
{

    dTHX;
    dSP;

    if ( saved_error == NULL ) {
        warn( "have no save_error\n" );
    }

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);

    XPUSHs(sv_2mortal(libErr));
    if ( saved_error != NULL && SvOK(saved_error) ) {
        XPUSHs(saved_error);
    }
    PUTBACK;

    if ( saved_error != NULL ) {
      call_pv( "XML::LibXML::Error::_callback_error", G_SCALAR | G_EVAL );
    } else {
      call_pv( "XML::LibXML::Error::_instant_error_callback", G_SCALAR );
    }
    SPAGAIN;

    if ( SvTRUE(ERRSV) ) {
      (void) POPs;
      croak_obj;
    } else {
      sv_setsv(saved_error, POPs);
    }

    PUTBACK;
    FREETMPS;
    LEAVE;
}

void
LibXML_struct_error_handler(SV * saved_error, xmlErrorPtr error )
{
    const char * CLASS = "XML::LibXML::LibError";
    SV* libErr;

    libErr = NEWSV(0,0);
    sv_setref_pv( libErr, CLASS, (void*)error );
    LibXML_struct_error_callback( saved_error, libErr);
}


void
LibXML_flat_handler(SV * saved_error, const char * msg, ...)
{
    SV* sv;
    va_list args;

    sv = newSVpv("",0);
    va_start(args, msg);
    sv_vcatpvf(sv, msg, &args);
    va_end(args);
    xs_warn("flat error\n");
    LibXML_struct_error_callback( saved_error, sv);
}

#endif /* WITH_SERRORS */


/* If threads-support is working correctly in libxml2 then
 * this method will be called with the correct thread-context */
void
LibXML_error_handler_ctx(void * ctxt, const char * msg, ...)
{
	va_list args;
	SV * saved_error = (SV *) ctxt;

	/* If saved_error is null we croak with the error */
	if( NULL == saved_error ) {
		SV * sv = sv_2mortal(newSV(0));
		va_start(args, msg);
                /* vfprintf(stderr, msg, args); */
   		sv_vsetpvfn(sv, msg, strlen(msg), &args, NULL, 0, NULL);
   		va_end(args);
		croak("%s", SvPV_nolen(sv));
	/* Otherwise, save the error */
	} else {
		va_start(args, msg);
                /* vfprintf(stderr, msg, args);	*/
   		sv_vcatpvfn(saved_error, msg, strlen(msg), &args, NULL, 0, NULL);
		va_end(args);
	}
}

static void
LibXML_validity_error_ctx(void * ctxt, const char *msg, ...)
{
	va_list args;
	SV * saved_error = (SV *) ctxt;

	/* If saved_error is null we croak with the error */
	if( NULL == saved_error ) {
		SV * sv = sv_2mortal(newSV(0));
		va_start(args, msg);
   		sv_vsetpvfn(sv, msg, strlen(msg), &args, NULL, 0, NULL);
   		va_end(args);
		croak("%s", SvPV_nolen(sv));
	/* Otherwise, save the error */
	} else {
		va_start(args, msg);
   		sv_vcatpvfn(saved_error, msg, strlen(msg), &args, NULL, 0, NULL);
		va_end(args);
	}
}

static void
LibXML_validity_warning_ctx(void * ctxt, const char *msg, ...)
{
	va_list args;
	SV * saved_error = (SV *) ctxt;
	STRLEN len;

	/* If saved_error is null we croak with the error */
	if( NULL == saved_error ) {
		SV * sv = sv_2mortal(newSV(0));
		va_start(args, msg);
   		sv_vsetpvfn(sv, msg, strlen(msg), &args, NULL, 0, NULL);
   		va_end(args);
		croak("LibXML_validity_warning_ctx internal error: context was null (%s)", SvPV_nolen(sv));
	/* Otherwise, give the warning */
	} else {
		va_start(args, msg);
   		sv_vcatpvfn(saved_error, msg, strlen(msg), &args, NULL, 0, NULL);
		va_end(args);
		warn("validation error: %s", SvPV(saved_error, len));
	}
}

static int
LibXML_will_die_ctx(SV * saved_error, int recover)
{
#ifdef WITH_SERRORS
    if( saved_error!=NULL && SvOK(saved_error) ) {
	if ( recover == 0 ) {
	  return 1;
	}
    }
#else
    if( 0 < SvCUR( saved_error ) ) {
	if ( recover == 0 ) {
	    return 1;
	}
    }
#endif
    return 0;
}


static void
LibXML_report_error_ctx(SV * saved_error, int recover)
{
#ifdef WITH_SERRORS
  if( saved_error!=NULL && SvOK( saved_error ) ) {
    if (!recover || recover==1) {
      dTHX;
      dSP;

      ENTER;
      SAVETMPS;
      PUSHMARK(SP);
      EXTEND(SP, 1);
      PUSHs(saved_error);
      PUTBACK;
      if (recover==1) {
	call_pv( "XML::LibXML::Error::_report_warning", G_SCALAR | G_DISCARD);
      } else {
	call_pv( "XML::LibXML::Error::_report_error", G_SCALAR | G_DISCARD);
      }
      SPAGAIN;

      PUTBACK;
      FREETMPS;
      LEAVE;
    }
  }
#else
    if( 0 < SvCUR( saved_error ) ) {
	if( recover ) {
	    if ( recover == 1 ) {
		warn("%s", SvPV_nolen(saved_error));
	    } /* else recover silently */
	} else {
	    croak("%s", SvPV_nolen(saved_error));
	}
    }
#endif
}

#ifdef HAVE_READER_SUPPORT

#ifndef WITH_SERRORS
static void
LibXML_reader_error_handler(void * ctxt,
				const char * msg,
				xmlParserSeverities severity,
				xmlTextReaderLocatorPtr locator)
{
  int line = xmlTextReaderLocatorLineNumber(locator);
  xmlChar * filename = xmlTextReaderLocatorBaseURI(locator);
  SV * msg_sv = sv_2mortal(C2Sv((xmlChar*) msg,NULL));
  SV * error = sv_2mortal(newSVpv("", 0));

  switch (severity) {
  case XML_PARSER_SEVERITY_VALIDITY_WARNING:
    sv_catpv(error, "Validity WARNING");
    break;
  case XML_PARSER_SEVERITY_WARNING:
    sv_catpv(error, "Reader WARNING");
    break;
  case XML_PARSER_SEVERITY_VALIDITY_ERROR:
    sv_catpv(error, "Validity ERROR");
    break;
  case XML_PARSER_SEVERITY_ERROR:
    sv_catpv(error, "Reader ERROR");
    break;
  }
  if (filename) {
    sv_catpvf(error, " in %s", filename);
    xmlFree(filename);
  }
  if (line >= 0) {
    sv_catpvf(error, " at line %d", line);
  }
  sv_catpvf(error, ": %s", SvPV_nolen(msg_sv));
  if (severity == XML_PARSER_SEVERITY_VALIDITY_WARNING ||
      severity == XML_PARSER_SEVERITY_WARNING ) {
    warn("%s", SvPV_nolen(error));
  } else {
    SV * error_sv = (SV*) ctxt;
    if (error_sv) {
      sv_catpvf(error_sv, "%s  ", SvPV_nolen(error));
    } else {
      croak("%s",SvPV_nolen(error));
    }
  }
}
#endif /* !defined WITH_SERRORS */

SV *
LibXML_get_reader_error_data(xmlTextReaderPtr reader)
{
  SV * saved_error = NULL;
  xmlTextReaderErrorFunc f = NULL;
  xmlTextReaderGetErrorHandler(reader, &f, (void **) &saved_error);
  return saved_error;
}

#ifndef WITH_SERRORS
static void
LibXML_report_reader_error(xmlTextReaderPtr reader)
{
  SV * saved_error = NULL;
  xmlTextReaderErrorFunc f = NULL;
  xmlTextReaderGetErrorHandler(reader, &f, (void **) &saved_error);
  if ( saved_error && SvOK( saved_error) && 0 < SvCUR( saved_error ) ) {
    croak("%s", SvPV_nolen(saved_error));
  }
}
#endif /* !defined WITH_SERRORS */

#endif /* HAVE_READER_SUPPORT */

static int
LibXML_get_recover(HV * real_obj)
{
    SV** item = hv_fetch( real_obj, "XML_LIBXML_RECOVER", 18, 0 );
    return ( item != NULL && SvTRUE(*item) ) ? SvIV(*item) : 0;
}

static SV *
LibXML_NodeToSv(HV * real_obj, xmlNodePtr real_doc)
{
    SV** item = hv_fetch( real_obj, "XML_LIBXML_GDOME", 16, 0 );

    if ( item != NULL && SvTRUE(*item) ) {
        return PmmNodeToGdomeSv(real_doc);
    }
    else {
        return PmmNodeToSv(real_doc, NULL);
    }
}

/* ****************************************************************
 * IO callbacks
 * **************************************************************** */

int
LibXML_read_perl (SV * ioref, char * buffer, int len)
{
    dTHX;
    dSP;

    int cnt;
    SV * read_results;
    IV read_results_iv;
    STRLEN read_length;
    char * chars;
    SV * tbuff = NEWSV(0,len);
    SV * tsize = newSViv(len);

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 3);
    PUSHs(ioref);
    PUSHs(sv_2mortal(tbuff));
    PUSHs(sv_2mortal(tsize));
    PUTBACK;

    if (sv_isobject(ioref)) {
        cnt = call_method("read", G_SCALAR | G_EVAL);
    }
    else {
        cnt = call_pv("XML::LibXML::__read", G_SCALAR | G_EVAL);
    }

    SPAGAIN;

    if (cnt != 1) {
        croak("read method call failed");
    }

    if (SvTRUE(ERRSV)) {
       (void) POPs;
       croak_obj;
    }

    read_results = POPs;

    if (!SvOK(read_results)) {
        croak("read error");
    }

    read_results_iv = SvIV(read_results);

    chars = SvPV(tbuff, read_length);

    /*
     * If the file handle uses an encoding layer, the length parameter is
     * interpreted as character count, not as byte count. So it's possible
     * that more than len bytes are read which would overflow the buffer.
     * Check for this condition also by comparing the return value.
     */
    if (read_results_iv != read_length || read_length > len) {
        croak("Read more bytes than requested. Do you use an encoding-related"
              " PerlIO layer?");
    }
    strncpy(buffer, chars, read_length);

    PUTBACK;
    FREETMPS;
    LEAVE;

    return read_length;
}

/* used only by Reader */
int
LibXML_close_perl (SV * ioref)
{
  SvREFCNT_dec(ioref);
  return 0;
}

int
LibXML_input_match(char const * filename)
{
    int results;
    int count;
    SV * res;

    results = 0;

    {
        dTHX;
        dSP;

        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 1);
        PUSHs(sv_2mortal(newSVpv((char*)filename, 0)));
        PUTBACK;

        count = call_pv("XML::LibXML::InputCallback::_callback_match",
                             G_SCALAR | G_EVAL);

        SPAGAIN;

        if (count != 1) {
            croak("match callback must return a single value");
        }

        if (SvTRUE(ERRSV)) {
            (void) POPs;
            croak_obj;
        }

        res = POPs;

        if (SvTRUE(res)) {
            results = 1;
        }

        PUTBACK;
        FREETMPS;
        LEAVE;
    }
    return results;
}

void *
LibXML_input_open(char const * filename)
{
    SV * results;
    int count;

    dTHX;
    dSP;

    ENTER;
    SAVETMPS;

    PUSHMARK(SP);
    EXTEND(SP, 1);
    PUSHs(sv_2mortal(newSVpv((char*)filename, 0)));
    PUTBACK;

    count = call_pv("XML::LibXML::InputCallback::_callback_open",
                              G_SCALAR | G_EVAL);

    SPAGAIN;

    if (count != 1) {
        croak("open callback must return a single value");
    }

    if (SvTRUE(ERRSV)) {
        (void) POPs;
        croak_obj;
    }

    results = POPs;

    (void)SvREFCNT_inc(results);

    PUTBACK;
    FREETMPS;
    LEAVE;

    return (void *)results;
}

int
LibXML_input_read(void * context, char * buffer, int len)
{
    STRLEN res_len;
    const char * output;
    SV * ctxt;
    SV * output_sv;

    res_len = 0;
    ctxt = (SV *)context;

    {
        int count;

        dTHX;
        dSP;

        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 2);
        PUSHs(ctxt);
        PUSHs(sv_2mortal(newSViv(len)));
        PUTBACK;

        count = call_pv("XML::LibXML::InputCallback::_callback_read",
                             G_SCALAR | G_EVAL);

        SPAGAIN;

        if (count != 1) {
            croak("read callback must return a single value");
        }

        if (SvTRUE(ERRSV)) {
            (void) POPs;
            croak_obj;
        }

        /*
         * Handle undef()s gracefully, to avoid using POPpx which warns upon $^W
         * being set. See t/49callbacks_returning_undef.t and:
         * https://rt.cpan.org/Ticket/Display.html?id=70321
         * */

        output_sv = POPs;
        output = SvOK(output_sv) ? SvPV_nolen(output_sv) : NULL;

        if (output != NULL) {
            res_len = strlen(output);
            if (res_len) {
                strncpy(buffer, output, res_len);
            }
            else {
                buffer[0] = 0;
            }
        }

	PUTBACK;
        FREETMPS;
        LEAVE;
    }
    return res_len;
}

void
LibXML_input_close(void * context)
{
    SV * ctxt;

    ctxt = (SV *)context;

    {
        dTHX;
        dSP;

        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 1);
        PUSHs(ctxt);
        PUTBACK;

        call_pv("XML::LibXML::InputCallback::_callback_close",
                             G_SCALAR | G_EVAL | G_DISCARD);

        SvREFCNT_dec(ctxt);

        if (SvTRUE(ERRSV)) {
            croak_obj;
        }

        FREETMPS;
        LEAVE;
    }
}

int
LibXML_output_write_handler(void * ioref, char * buffer, int len)
{
    if ( buffer != NULL && len > 0) {
        dTHX;
        dSP;

        SV * tbuff = newSVpv(buffer,len);
        SV * tsize = newSViv(len);


        ENTER;
        SAVETMPS;

        PUSHMARK(SP);
        EXTEND(SP, 3);
        PUSHs((SV*)ioref);
        PUSHs(sv_2mortal(tbuff));
        PUSHs(sv_2mortal(tsize));
        PUTBACK;

        call_pv("XML::LibXML::__write", G_SCALAR | G_EVAL | G_DISCARD );

        if (SvTRUE(ERRSV)) {
            croak_obj;
        }

        FREETMPS;
        LEAVE;
    }
    return len;
}

int
LibXML_output_close_handler( void * handler )
{
    return 1;
}

xmlParserInputPtr
LibXML_load_external_entity(
        const char * URL,
        const char * ID,
        xmlParserCtxtPtr ctxt)
{
    SV ** func;
    int count;
    SV * results;
    STRLEN results_len;
    const char * results_pv;
    xmlParserInputBufferPtr input_buf;

    if (ctxt->_private == NULL && EXTERNAL_ENTITY_LOADER_FUNC == NULL)
    {
        return xmlNewInputFromFile(ctxt, URL);
    }

    if (URL == NULL) {
        URL = "";
    }
    if (ID == NULL) {
        ID = "";
    }

    /* fetch entity loader function */
    if(EXTERNAL_ENTITY_LOADER_FUNC != NULL)
    {
       func = &EXTERNAL_ENTITY_LOADER_FUNC;
    }
    else
    {
       SV * self;
       HV * real_obj;

       self = (SV *)ctxt->_private;
       real_obj = (HV *)SvRV(self);
       func = hv_fetch(real_obj, "ext_ent_handler", 15, 0);
    }

    if (func != NULL && SvTRUE(*func)) {
        dTHX;
        dSP;

        ENTER;
        SAVETMPS;

        PUSHMARK(SP) ;
        XPUSHs(sv_2mortal(newSVpv((char*)URL, 0)));
        XPUSHs(sv_2mortal(newSVpv((char*)ID, 0)));
        PUTBACK;

        count = call_sv(*func, G_SCALAR | G_EVAL);

        SPAGAIN;

        if (count == 0) {
            croak("external entity handler did not return a value");
        }

        if (SvTRUE(ERRSV)) {
            (void) POPs;
            croak_obj;
        }

        results = POPs;

        results_pv = SvPV(results, results_len);
        input_buf = xmlParserInputBufferCreateMem(
                        results_pv,
                        results_len,
                        XML_CHAR_ENCODING_NONE
                        );

        PUTBACK;
        FREETMPS;
        LEAVE;

        return xmlNewIOInputStream(ctxt, input_buf, XML_CHAR_ENCODING_NONE);
    }
    else {
        if (URL == NULL) {
            return NULL;
        }
        return xmlNewInputFromFile(ctxt, URL);
    }
}

/* ****************************************************************
 * Helper functions
 * **************************************************************** */

HV*
LibXML_init_parser( SV * self, xmlParserCtxtPtr ctxt ) {
    /* we fetch all switches and callbacks from the hash */
    HV* real_obj = NULL;
    SV** item    = NULL;
    int parserOptions = XML_PARSE_NODICT;

    /* A NOTE ABOUT xmlInitParser();                     */
    /* xmlInitParser() should be used only at startup and*/
    /* not for initializing a single parser. libxml2's   */
    /* documentation is quite clear about this. If       */
    /* something fails it is a problem elsewhere. Simply */
    /* resetting the entire module will lead to unwanted */
    /* results in server environments, such as if        */
    /* mod_perl is used together with php's xml module.  */
    /* calling xmlInitParser() here is definitely wrong!  */
    /* xmlInitParser(); */

#ifndef WITH_SERRORS
    xmlGetWarningsDefaultValue = 0;
#endif
    if ( self != NULL ) {
        /* first fetch the values from the hash */
        real_obj = (HV *)SvRV(self);

        item = hv_fetch( real_obj, "XML_LIBXML_PARSER_OPTIONS", 25, 0 );
        if (item != NULL && SvOK(*item)) parserOptions = sv_2iv(*item);

        /* compatibility with old implementation:
           absence of XML_PARSE_DTDLOAD (load_ext_dtd) implies absence of
           all DTD related flags
         */
        if ((parserOptions & XML_PARSE_DTDLOAD) == 0) {
            parserOptions &= ~(XML_PARSE_DTDVALID | XML_PARSE_DTDATTR | XML_PARSE_NOENT );
        }
        if (ctxt) xmlCtxtUseOptions(ctxt, parserOptions ); /* Note: sets ctxt->linenumbers = 1 */

        /*
         * Without this if/else conditional, NOBLANKS has no effect.
         *
         * For more information, see:
         *
         * https://rt.cpan.org/Ticket/Display.html?id=76696
         *
         * */
        if (parserOptions & XML_PARSE_NOBLANKS) {
            xmlKeepBlanksDefault(0);
        }
        else {
            xmlKeepBlanksDefault(1);
        }

        item =  hv_fetch( real_obj, "XML_LIBXML_LINENUMBERS", 22, 0 );
        if ( item != NULL && SvTRUE(*item) ) {
            if (ctxt) ctxt->linenumbers = 1;
        }
        else {
            if (ctxt) ctxt->linenumbers = 0;
        }

       if(EXTERNAL_ENTITY_LOADER_FUNC == NULL)
       {
            item = hv_fetch(real_obj, "ext_ent_handler", 15, 0);
            if (item != NULL  && SvTRUE(*item)) {
                LibXML_old_ext_ent_loader =  xmlGetExternalEntityLoader();
                xmlSetExternalEntityLoader( (xmlExternalEntityLoader)LibXML_load_external_entity );
            }
            else
             {
                if (parserOptions & XML_PARSE_NONET)
                {
                    LibXML_old_ext_ent_loader = xmlGetExternalEntityLoader();
                    xmlSetExternalEntityLoader( xmlNoNetExternalEntityLoader );
                }
                /* LibXML_old_ext_ent_loader =  NULL; */
            }
       }
    }

    return real_obj;
}

void
LibXML_cleanup_parser() {
#ifndef WITH_SERRORS
    xmlGetWarningsDefaultValue = 0;
#endif
    if (EXTERNAL_ENTITY_LOADER_FUNC == NULL && LibXML_old_ext_ent_loader != NULL)
    {
        xmlSetExternalEntityLoader( (xmlExternalEntityLoader)LibXML_old_ext_ent_loader );
    }
}

int
LibXML_test_node_name( xmlChar * name )
{
    xmlChar * cur = name;
    int tc  = 0;
    int len = 0;

    if ( cur == NULL || *cur == 0 ) {
        /* warn("name is empty" ); */
        return(0);
    }

    tc = domParseChar( cur, &len );

    if ( !( IS_LETTER( tc ) || (tc == '_') || (tc == ':')) ) {
        /* warn( "is not a letter\n" ); */
        return(0);
    }

    tc  =  0;
    cur += len;

    while (*cur != 0 ) {
        tc = domParseChar( cur, &len );

        if (!(IS_LETTER(tc) || IS_DIGIT(tc) || (tc == '_') ||
             (tc == '-') || (tc == ':') || (tc == '.') ||
             IS_COMBINING(tc) || IS_EXTENDER(tc)) ) {
            /* warn( "is not a letter\n" ); */
            return(0);
        }
        tc = 0;
        cur += len;
    }

    /* warn("name is ok"); */
    return(1);
}

/* Assumes that the node has a proxy. */
static void
LibXML_reparent_removed_node(xmlNodePtr node) {
    /*
     * Attribute nodes can't be added to document fragments. Adding
     * DTD nodes would cause a memory leak.
     */
    if (node->type != XML_ATTRIBUTE_NODE
        && node->type != XML_DTD_NODE) {
        ProxyNodePtr docfrag = PmmNewFragment(node->doc);
        xmlAddChild(PmmNODE(docfrag), node);
        PmmFixOwner(PmmPROXYNODE(node), docfrag);
    }
}

static void
LibXML_set_int_subset(xmlDocPtr doc, xmlNodePtr dtd) {
    xmlNodePtr old_dtd = (xmlNodePtr)doc->intSubset;
    if (old_dtd == dtd) {
        return;
    }

    if (old_dtd != NULL) {
        xmlUnlinkNode(old_dtd);

        if (PmmPROXYNODE(old_dtd) == NULL) {
            xmlFreeDtd((xmlDtdPtr)old_dtd);
        }
    }

    doc->intSubset = (xmlDtdPtr)dtd;
}

/* ****************************************************************
 * XPathContext helper functions
 * **************************************************************** */

/* Temporary node pool:                                              *
 * Stores pnode in context node-pool hash table in order to preserve *
 * at least one reference.                                           *
 * If pnode is NULL, only return current value for hashkey           */
static SV*
LibXML_XPathContext_pool ( xmlXPathContextPtr ctxt, void * hashkey, SV * pnode ) {
    SV ** value;
    SV * key;
    STRLEN len;
    char * strkey;
    dTHX;

    if (XPathContextDATA(ctxt)->pool == NULL) {
        if (pnode == NULL) {
            return &PL_sv_undef;
        } else {
            xs_warn("initializing node pool");
            XPathContextDATA(ctxt)->pool = newHV();
        }
    }

    key = newSViv(PTR2IV(hashkey));
    strkey = SvPV(key, len);
    if (pnode != NULL && !hv_exists(XPathContextDATA(ctxt)->pool,strkey,len)) {
        value = hv_store(XPathContextDATA(ctxt)->pool,strkey,len, SvREFCNT_inc(pnode),0);
    } else {
        value = hv_fetch(XPathContextDATA(ctxt)->pool,strkey,len, 0);
    }
    SvREFCNT_dec(key);

    if (value == NULL) {
        return &PL_sv_undef;
    } else {
        return *value;
    }
}

/* convert perl result structures to LibXML structures */
static xmlXPathObjectPtr
LibXML_perldata_to_LibXMLdata(xmlXPathParserContextPtr ctxt,
                              SV* perl_result) {
    dTHX;

    if (!SvOK(perl_result)) {
        return (xmlXPathObjectPtr)xmlXPathNewCString("");
    }
    if (SvROK(perl_result) &&
        SvTYPE(SvRV(perl_result)) == SVt_PVAV) {
        /* consider any array ref to be a nodelist */
        int i;
        int length;
        SV ** pnode;
        AV * array_result;
        xmlXPathObjectPtr ret;

        ret = (xmlXPathObjectPtr) xmlXPathNewNodeSet(INT2PTR(xmlNodePtr,NULL));
        array_result = (AV*)SvRV(perl_result);
        length = av_len(array_result);
        for( i = 0; i <= length ; i++ ) {
            pnode = av_fetch(array_result,i,0);
            if (pnode != NULL && sv_isobject(*pnode) &&
                sv_derived_from(*pnode,"XML::LibXML::Node")) {
                xmlXPathNodeSetAdd(ret->nodesetval,
                                   INT2PTR(xmlNodePtr,PmmSvNode(*pnode)));
                if(ctxt) {
                    LibXML_XPathContext_pool(ctxt->context,
                                             PmmSvNode(*pnode), *pnode);
                }
            } else {
                warn("XPathContext: ignoring non-node member of a nodelist");
            }
        }
        return ret;
    } else if (sv_isobject(perl_result) &&
               (SvTYPE(SvRV(perl_result)) == SVt_PVMG))
        {
            if (sv_derived_from(perl_result, "XML::LibXML::Node")) {
                xmlNodePtr tmp_node;
                xmlXPathObjectPtr ret;

                ret =  INT2PTR(xmlXPathObjectPtr,xmlXPathNewNodeSet(NULL));
                tmp_node = INT2PTR(xmlNodePtr,PmmSvNode(perl_result));
                xmlXPathNodeSetAdd(ret->nodesetval,tmp_node);
                if(ctxt) {
                    LibXML_XPathContext_pool(ctxt->context, PmmSvNode(perl_result),
                                             perl_result);
                }

                return ret;
            }
            else if (sv_isa(perl_result, "XML::LibXML::Boolean")) {
                return (xmlXPathObjectPtr)
                    xmlXPathNewBoolean(SvIV(SvRV(perl_result)));
            }
            else if (sv_isa(perl_result, "XML::LibXML::Literal")) {
                return (xmlXPathObjectPtr)
                    xmlXPathNewCString(SvPV_nolen(SvRV(perl_result)));
            }
            else if (sv_isa(perl_result, "XML::LibXML::Number")) {
                return (xmlXPathObjectPtr)
                    xmlXPathNewFloat(SvNV(SvRV(perl_result)));
            }
        } else if (SvNOK(perl_result) || SvIOK(perl_result)) {
            return (xmlXPathObjectPtr)xmlXPathNewFloat(SvNV(perl_result));
        } else {
            return (xmlXPathObjectPtr)
                xmlXPathNewCString(SvPV_nolen(perl_result));
    }
    return NULL;
}


/* save XPath context and XPathContextDATA for recursion */
static xmlXPathContextPtr
LibXML_save_context(xmlXPathContextPtr ctxt)
{
    xmlXPathContextPtr copy;
    copy = xmlMalloc(sizeof(xmlXPathContext));
    if (copy) {
	/* backup ctxt */
	memcpy(copy, ctxt, sizeof(xmlXPathContext));
	/* clear namespaces so that they are not freed and overwritten
	   by configure_namespaces */
	ctxt->namespaces = NULL;
	/* backup data */
	copy->user = xmlMalloc(sizeof(XPathContextData));
	if (XPathContextDATA(copy)) {
	    memcpy(XPathContextDATA(copy), XPathContextDATA(ctxt),sizeof(XPathContextData));
	    /* clear ctxt->pool, so that it is not used freed during re-entrance */
	    XPathContextDATA(ctxt)->pool = NULL;
	}
    }
    return copy;
}

/* restore XPath context and XPathContextDATA from a saved copy */
static void
LibXML_restore_context(xmlXPathContextPtr ctxt, xmlXPathContextPtr copy)
{
    dTHX;
    /* cleanup */
    if (XPathContextDATA(ctxt)) {
	/* cleanup newly created pool */
	if (XPathContextDATA(ctxt)->pool != NULL &&
	    SvOK(XPathContextDATA(ctxt)->pool)) {
	    SvREFCNT_dec((SV *)XPathContextDATA(ctxt)->pool);
	}
    }
    if (ctxt->namespaces) {
	/* free namespaces allocated during recursion */
        xmlFree( ctxt->namespaces );
    }

    /* restore context */
    if (copy) {
	/* 1st restore our data */
	if (XPathContextDATA(copy)) {
	    memcpy(XPathContextDATA(ctxt),XPathContextDATA(copy),sizeof(XPathContextData));
	    xmlFree(XPathContextDATA(copy));
	    copy->user = XPathContextDATA(ctxt);
	}
	/* now copy the rest */
	memcpy(ctxt, copy, sizeof(xmlXPathContext));
	xmlFree(copy);
    }
}


/* ****************************************************************
 * Variable Lookup
 * **************************************************************** */
/* Much of the code is borrowed from Matt Sergeant's XML::LibXSLT   */
static xmlXPathObjectPtr
LibXML_generic_variable_lookup(void* varLookupData,
                               const xmlChar *name,
                               const xmlChar *ns_uri)
{
    xmlXPathObjectPtr ret;
    xmlXPathContextPtr ctxt;
    xmlXPathContextPtr copy;
    XPathContextDataPtr data;
    I32 count;
    dTHX;
    dSP;

    ctxt = (xmlXPathContextPtr) varLookupData;
    if ( ctxt == NULL )
	croak("XPathContext: missing xpath context");
    data = XPathContextDATA(ctxt);
    if ( data == NULL )
	croak("XPathContext: missing xpath context private data");
    if ( data->varLookup == NULL || !SvROK(data->varLookup) ||
	 SvTYPE(SvRV(data->varLookup)) != SVt_PVCV )
        croak("XPathContext: lost variable lookup function!");

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);

    XPUSHs( (data->varData != NULL) ? data->varData : &PL_sv_undef );
    XPUSHs(sv_2mortal(C2Sv(name,NULL)));
    XPUSHs(sv_2mortal(C2Sv(ns_uri,NULL)));

    /* save context to allow recursive usage of XPathContext */
    copy = LibXML_save_context(ctxt);

    PUTBACK ;
    count = call_sv(data->varLookup, G_SCALAR|G_EVAL);
    SPAGAIN;

    /* restore the xpath context */
    LibXML_restore_context(ctxt, copy);

    if (SvTRUE(ERRSV)) {
        (void) POPs;
        croak_obj;
    }
    if (count != 1) croak("XPathContext: variable lookup function returned none or more than one argument!");

    ret = LibXML_perldata_to_LibXMLdata(NULL, POPs);

    PUTBACK;
    FREETMPS;
    LEAVE;
    return ret;
}

/* ****************************************************************
 * Generic Extension Function
 * **************************************************************** */
/* Much of the code is borrowed from Matt Sergeant's XML::LibXSLT   */
static void
LibXML_generic_extension_function(xmlXPathParserContextPtr ctxt, int nargs)
{
    xmlXPathObjectPtr obj,ret;
    xmlNodeSetPtr nodelist = NULL;
    int count;
    SV * perl_dispatch;
    int i;
    STRLEN len;
    ProxyNodePtr owner = NULL;
    SV *key;
    char *strkey;
    const char *function, *uri;
    SV **perl_function;
    dTHX;
    dSP;
    SV * data;
    xmlXPathContextPtr copy;

    /* warn("entered LibXML_generic_extension_function for %s\n",ctxt->context->function); */
    data = (SV *) ctxt->context->funcLookupData;
    if (ctxt->context->funcLookupData == NULL || !SvROK(data) ||
        SvTYPE(SvRV(data)) != SVt_PVHV) {
        croak("XPathContext: lost function lookup data structure!");
    }

    function = (char*) ctxt->context->function;
    uri = (char*) ctxt->context->functionURI;

    key = newSVpvn("",0);
    if (uri && *uri) {
        sv_catpv(key, "{");
        sv_catpv(key, (const char*)uri);
        sv_catpv(key, "}");
    }
    sv_catpv(key, (const char*)function);
    strkey = SvPV(key, len);
    perl_function =
        hv_fetch((HV*)SvRV(data), strkey, len, 0);
    if ( perl_function == NULL || !SvOK(*perl_function) ||
         !(SvPOK(*perl_function) ||
           (SvROK(*perl_function) &&
            SvTYPE(SvRV(*perl_function)) == SVt_PVCV))) {
        croak("XPathContext: lost perl extension function!");
    }
    SvREFCNT_dec(key);

    ENTER;
    SAVETMPS;
    PUSHMARK(SP);

    XPUSHs(*perl_function);

    /* set up call to perl dispatcher function */
    for (i = 0; i < nargs; i++) {
        obj = (xmlXPathObjectPtr)valuePop(ctxt);
        switch (obj->type) {
        case XPATH_XSLT_TREE:
        case XPATH_NODESET:
            nodelist = obj->nodesetval;
            if ( nodelist ) {
                XPUSHs(sv_2mortal(newSVpv("XML::LibXML::NodeList", 0)));
                XPUSHs(sv_2mortal(newSViv(nodelist->nodeNr)));
                if ( nodelist->nodeNr > 0 ) {
                    int j;
                    const char * cls = "XML::LibXML::Node";
                    xmlNodePtr tnode;
                    SV * element;
                    int l = nodelist->nodeNr;

                    for( j = 0 ; j < l; j++){
                        tnode = nodelist->nodeTab[j];
                        if( tnode != NULL && tnode->doc != NULL) {
                            owner = PmmOWNERPO(PmmNewNode(INT2PTR(xmlNodePtr,tnode->doc)));
                        } else {
                            owner = NULL;
                        }
                        if (tnode->type == XML_NAMESPACE_DECL) {
                            element = NEWSV(0,0);
                            cls = PmmNodeTypeName( tnode );
                            element = sv_setref_pv( element,
                                                    (const char *)cls,
                                                    (void *)xmlCopyNamespace((xmlNsPtr)tnode)
                                );
                        }
                        else {
                            element = PmmNodeToSv(tnode, owner);
                        }
                        XPUSHs( sv_2mortal(element) );
                    }
                }
            } else {
                /* PP: We can't simply leave out an empty nodelist as Matt does! */
                /* PP: The number of arguments must match! */
                XPUSHs(sv_2mortal(newSVpv("XML::LibXML::NodeList", 0)));
                XPUSHs(sv_2mortal(newSViv(0)));
            }
            /* prevent libxml2 from freeing the actual nodes */
            if (obj->boolval) obj->boolval=0;
            break;
        case XPATH_BOOLEAN:
            XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Boolean", 0)));
            XPUSHs(sv_2mortal(newSViv(obj->boolval)));
            break;
        case XPATH_NUMBER:
            XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Number", 0)));
            XPUSHs(sv_2mortal(newSVnv(obj->floatval)));
            break;
        case XPATH_STRING:
            XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Literal", 0)));
            XPUSHs(sv_2mortal(C2Sv(obj->stringval, 0)));
            break;
        default:
            warn("Unknown XPath return type (%d) in call to {%s}%s - assuming string", obj->type, uri, function);
            XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Literal", 0)));
            XPUSHs(sv_2mortal(C2Sv(xmlXPathCastToString(obj), 0)));
        }
        xmlXPathFreeObject(obj);
    }

    /* save context to allow recursive usage of XPathContext */
    copy = LibXML_save_context(ctxt->context);

    /* call perl dispatcher */
    PUTBACK;
    perl_dispatch = sv_2mortal(newSVpv("XML::LibXML::XPathContext::_perl_dispatcher",0));
    count = call_sv(perl_dispatch, G_SCALAR|G_EVAL);
    SPAGAIN;

    /* restore the xpath context */
    LibXML_restore_context(ctxt->context, copy);

    if (SvTRUE(ERRSV)) {
        (void) POPs;
        croak_obj;
    }

    if (count != 1) croak("XPathContext: perl-dispatcher in pm file returned none or more than one argument!");

    ret = LibXML_perldata_to_LibXMLdata(ctxt, POPs);

    valuePush(ctxt, ret);
    PUTBACK;
    FREETMPS;
    LEAVE;
}

static void
LibXML_configure_namespaces( xmlXPathContextPtr ctxt ) {
    xmlNodePtr node = ctxt->node;

    if (ctxt->namespaces != NULL) {
        xmlFree( ctxt->namespaces );
        ctxt->namespaces = NULL;
    }
    if (node != NULL) {
        if (node->type == XML_DOCUMENT_NODE) {
            ctxt->namespaces = xmlGetNsList( node->doc,
                                             xmlDocGetRootElement( node->doc ) );
        } else {
            ctxt->namespaces = xmlGetNsList(node->doc, node);
        }
        ctxt->nsNr = 0;
        if (ctxt->namespaces != NULL) {
	  int cur=0;
	  xmlNsPtr ns;
	  /* we now walk through the list and
	     drop every ns that was declared via registration */
	  while (ctxt->namespaces[cur] != NULL) {
	    ns = ctxt->namespaces[cur];
	    if (ns->prefix==NULL ||
		xmlHashLookup(ctxt->nsHash, ns->prefix) != NULL) {
	      /* drop it */
	      ctxt->namespaces[cur]=NULL;
	    } else {
	      if (cur != ctxt->nsNr) {
		/* move the item to the new tail */
		ctxt->namespaces[ctxt->nsNr]=ns;
		ctxt->namespaces[cur]=NULL;
	      }
	      ctxt->nsNr++;
	    }
	    cur++;
	  }
        }
    }
}

static void
LibXML_configure_xpathcontext( xmlXPathContextPtr ctxt ) {
    xmlNodePtr node = PmmSvNode(XPathContextDATA(ctxt)->node);

    if (node != NULL) {
        ctxt->doc = node->doc;
    } else {
        ctxt->doc = NULL;
    }
    ctxt->node = node;
    LibXML_configure_namespaces(ctxt);
}

#ifdef HAVE_READER_SUPPORT

static void
LibXML_set_reader_preserve_flag( xmlTextReaderPtr reader ) {
    HV *hash;
    char key[32];

    hash = get_hv("XML::LibXML::Reader::_preserve_flag", 0);
    if (!hash) {
        return;
    }

    (void) snprintf(key, sizeof(key), "%p", reader);
    (void) hv_store(hash, key, strlen(key), newSV(0), 0);
}

static int
LibXML_get_reader_preserve_flag( xmlTextReaderPtr reader ) {
    HV *hash;
    char key[32];

    hash = get_hv("XML::LibXML::Reader::_preserve_flag", 0);
    if (!hash) {
        return 0;
    }

    (void) snprintf(key, sizeof(key), "%p", reader);
    if ( hv_exists(hash, key, strlen(key)) ) {
        (void) hv_delete(hash, key, strlen(key), G_DISCARD);
        return 1;
    }

    return 0;
}

#endif /* HAVE_READER_SUPPORT */

extern void boot_XML__LibXML__Devel(pTHX_ CV*);

#line 1546 "LibXML.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 1690 "LibXML.c"

XS_EUPXS(XS_XML__LibXML__CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__CLONE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "class");
    {
#line 1564 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
     if( PmmUSEREGISTRY )
       PmmCloneProxyNodes();
#endif
#line 1704 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__leaked_nodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__leaked_nodes)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1572 "LibXML.xs"
     RETVAL = 0;
#ifdef XML_LIBXML_THREADS
     if( PmmUSEREGISTRY )
       RETVAL = PmmProxyNodeRegistrySize();
#endif
#line 1725 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__dump_registry); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__dump_registry)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 1583 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
		if( PmmUSEREGISTRY )
			PmmDumpRegistry(PmmREGISTRY);
#endif
#line 1746 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML_LIBXML_DOTTED_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_LIBXML_DOTTED_VERSION)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;
#line 1591 "LibXML.xs"
        RETVAL = LIBXML_DOTTED_VERSION;
#line 1764 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_LIBXML_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_LIBXML_VERSION)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1599 "LibXML.xs"
        RETVAL = LIBXML_VERSION;
#line 1782 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_HAVE_STRUCT_ERRORS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_HAVE_STRUCT_ERRORS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1606 "LibXML.xs"
#ifdef WITH_SERRORS
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 1804 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_HAVE_SCHEMAS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_HAVE_SCHEMAS)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1617 "LibXML.xs"
#ifdef HAVE_SCHEMAS
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 1826 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_HAVE_READER); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_HAVE_READER)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1628 "LibXML.xs"
#ifdef HAVE_READER_SUPPORT
        RETVAL = 1;
#else
        RETVAL = 0;
#endif
#line 1848 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_HAVE_THREAD_SUPPORT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_HAVE_THREAD_SUPPORT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1639 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
        RETVAL = (PmmUSEREGISTRY ? 1 : 0);
#else
        RETVAL = 0;
#endif
#line 1870 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_LIBXML_RUNTIME_VERSION); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_LIBXML_RUNTIME_VERSION)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	const char *	RETVAL;
	dXSTARG;
#line 1651 "LibXML.xs"
        RETVAL = xmlParserVersion;
#line 1888 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_END); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_END)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1658 "LibXML.xs"
        xmlCleanupParser();
#line 1904 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML_INIT_THREAD_SUPPORT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_INIT_THREAD_SUPPORT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
	int	RETVAL;
	dXSTARG;
#line 1663 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
      SV *threads = get_sv("threads::threads", 0); /* no create */
      if( threads && SvOK(threads) && SvTRUE(threads) ) {
        PROXY_NODE_REGISTRY_MUTEX = get_sv("XML::LibXML::__PROXY_NODE_REGISTRY_MUTEX",0);
	RETVAL = 1;
      } else {
	croak("XML::LibXML ':threads_shared' can only be used after 'use threads'");
      }
#else
        RETVAL = 0;
#endif
#line 1931 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_DISABLE_THREAD_SUPPORT); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_DISABLE_THREAD_SUPPORT)
{
    dVAR; dXSARGS;
    if (items != 0)
       croak_xs_usage(cv,  "");
    {
#line 1680 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
        PROXY_NODE_REGISTRY_MUTEX = NULL;
#else
        croak("XML::LibXML compiled without threads!");
#endif
#line 1951 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__parse_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_string)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, string, dir = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	string = ST(1)
;
	SV *	dir;
#line 1692 "LibXML.xs"
        char * directory = NULL;
        STRLEN len;
        const char * ptr;
        HV * real_obj;
        int well_formed;
        int valid;
        int validate;
        xmlDocPtr real_doc;
        int recover = 0;
	PREINIT_SAVED_ERROR
#line 1980 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    dir = &PL_sv_undef;
	else {
	    dir = ST(2)
;
	}
#line 1703 "LibXML.xs"
        if (SvPOK(dir)) {
            directory = SvPV(dir, len);
            if (len <= 0) {
                directory = NULL;
            }
        }
        /* If string is a reference to a string - dereference it.
         * See: https://rt.cpan.org/Ticket/Display.html?id=64051 (broke it)
         *      https://rt.cpan.org/Ticket/Display.html?id=77864 (fixed it) */
        if (SvROK(string) && !SvOBJECT(SvRV(string))) {
            string = SvRV(string);
        }
        ptr = SvPV_const(string, len);
        if (len <= 0) {
            croak("Empty string\n");
            XSRETURN_UNDEF;
        }
#line 2007 "LibXML.c"
#line 1721 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        {
            xmlParserCtxtPtr ctxt = xmlCreateMemoryParserCtxt(ptr, len);
            if (ctxt == NULL) {
	        CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(1);
                croak("Could not create memory parser context!\n");
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);


            if ( directory != NULL ) {
                ctxt->directory = directory;
            }
            ctxt->_private = (void*)self;

            /* make libxml2-2.6 display line number on error */
            if ( ctxt->input != NULL ) {
                if (directory != NULL) {
		  ctxt->input->filename = (char *) xmlStrdup((const xmlChar *) directory);
                } else {
		  ctxt->input->filename = (char *) xmlStrdup((const xmlChar *) "");
                }
            }

            xs_warn( "context initialized\n" );

            xmlParseDocument(ctxt);
            xs_warn( "document parsed \n");

            ctxt->directory = NULL;
            well_formed = ctxt->wellFormed;
            valid = ctxt->valid;
            validate = ctxt->validate;
            real_doc = ctxt->myDoc;
            ctxt->myDoc = NULL;
            xmlFreeParserCtxt(ctxt);
        }
        if ( real_doc != NULL ) {
  	    if (real_doc->URL != NULL) { /* free "" assigned above */
               xmlFree((char*) real_doc->URL);
               real_doc->URL = NULL;
            }

            if ( directory == NULL ) {
                SV * newURI = sv_2mortal(newSVpvf("unknown-%p", (void*)real_doc));
                real_doc->URL = xmlStrdup((const xmlChar*)SvPV_nolen(newURI));
            } else {
                real_doc->URL = xmlStrdup((const xmlChar*)directory);
            }
            if ( ! LibXML_will_die_ctx(saved_error, recover) &&
		 (recover || ( well_formed &&
                              ( !validate
                                || ( valid || ( real_doc->intSubset == NULL
                                                && real_doc->extSubset == NULL )))))) {
                RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
            } else {
                xmlFreeDoc(real_doc);
		real_doc=NULL;
            }
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2077 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_sax_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_sax_string)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, string");
    {
	SV *	self = ST(0)
;
	SV *	string = ST(1)
;
#line 1797 "LibXML.xs"
        STRLEN len;
        char * ptr;
        HV * real_obj;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2102 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 1803 "LibXML.xs"
        ptr = SvPV(string, len);
        if (len <= 0) {
            croak("Empty string\n");
            XSRETURN_UNDEF;
        }
#line 2111 "LibXML.c"
#line 1809 "LibXML.xs"
        RETVAL = 0;
        INIT_ERROR_HANDLER;

        {
            xmlParserCtxtPtr ctxt = xmlCreateMemoryParserCtxt((const char*)ptr, len);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(recover ? recover : 1);
                croak("Could not create memory parser context!\n");
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);

            PmmSAXInitContext( ctxt, self, saved_error );
            xs_warn( "context initialized \n");
            {
                RETVAL = xmlParseDocument(ctxt);
                xs_warn( "document parsed \n");
            }

            PmmSAXCloseContext(ctxt);
            xmlFreeParserCtxt(ctxt);
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2141 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_fh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_fh)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, fh, dir = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	fh = ST(1)
;
	SV *	dir;
#line 1846 "LibXML.xs"
        STRLEN len;
        char * directory = NULL;
        HV * real_obj;
        int well_formed;
        int valid;
        int validate;
        xmlDocPtr real_doc;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2170 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    dir = &PL_sv_undef;
	else {
	    dir = ST(2)
;
	}
#line 1856 "LibXML.xs"
        if (SvPOK(dir)) {
            directory = SvPV(dir, len);
            if (len <= 0) {
                directory = NULL;
            }
        }
#line 2186 "LibXML.c"
#line 1863 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;

        {
            int read_length;
            char buffer[1024];
            xmlParserCtxtPtr ctxt;

            read_length = LibXML_read_perl(fh, buffer, 4);
            if (read_length <= 0) {
                CLEANUP_ERROR_HANDLER;
                croak( "Empty Stream\n" );
            }

            ctxt = xmlCreatePushParserCtxt(NULL, NULL, buffer, read_length, NULL);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(1);
                croak("Could not create xml push parser context!\n");
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);
#if LIBXML_VERSION > 20600
	    /* dictionaries not support yet */
	    ctxt->dictNames = 0;
#endif
            if ( directory != NULL ) {
                ctxt->directory = directory;
            }
            ctxt->_private = (void*)self;
            xs_warn( "context initialized \n");
            {
                int ret;
                while ((read_length = LibXML_read_perl(fh, buffer, 1024))) {
                    ret = xmlParseChunk(ctxt, buffer, read_length, 0);
                    if ( ret != 0 ) {
                        break;
                    }
                }
                ret = xmlParseChunk(ctxt, buffer, 0, 1);
                xs_warn( "document parsed \n");
            }

            ctxt->directory = NULL;
            well_formed = ctxt->wellFormed;
            valid = ctxt->valid;
            validate = ctxt->validate;
            real_doc = ctxt->myDoc;
            ctxt->myDoc = NULL;
            xmlFreeParserCtxt(ctxt);
        }

        if ( real_doc != NULL ) {

            if ( directory == NULL ) {
                SV * newURI = sv_2mortal(newSVpvf("unknown-%p", (void*)real_doc));
                real_doc->URL = xmlStrdup((const xmlChar*)SvPV_nolen(newURI));
            } else {
                real_doc->URL = xmlStrdup((const xmlChar*)directory);
            }

            if ( ! LibXML_will_die_ctx(saved_error, recover) &&
		 (recover || ( well_formed &&
                              ( !validate
                                || ( valid || ( real_doc->intSubset == NULL
                                                && real_doc->extSubset == NULL )))))) {
                RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
            } else {
                xmlFreeDoc(real_doc);
		real_doc=NULL;
            }
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2265 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_sax_fh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_sax_fh)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, fh, dir = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	fh = ST(1)
;
	SV *	dir;
#line 1949 "LibXML.xs"
        STRLEN len;
        char * directory = NULL;
        HV * real_obj;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2291 "LibXML.c"

	if (items < 3)
	    dir = &PL_sv_undef;
	else {
	    dir = ST(2)
;
	}
#line 1955 "LibXML.xs"
        if (SvPOK(dir)) {
            directory = SvPV(dir, len);
            if (len <= 0) {
                directory = NULL;
            }
        }
#line 2306 "LibXML.c"
#line 1962 "LibXML.xs"
        INIT_ERROR_HANDLER;
        {
            int read_length;
            char buffer[1024];
            xmlSAXHandlerPtr sax;
            xmlParserCtxtPtr ctxt;

            read_length = LibXML_read_perl(fh, buffer, 4);
            if (read_length <= 0) {
                CLEANUP_ERROR_HANDLER;
                croak( "Empty Stream\n" );
            }

            sax = PSaxGetHandler();
            ctxt = xmlCreatePushParserCtxt(sax, NULL, buffer, read_length, NULL);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(recover ? recover : 1);
                croak("Could not create xml push parser context!\n");
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);

            if ( directory != NULL ) {
                ctxt->directory = directory;
            }
            PmmSAXInitContext( ctxt, self, saved_error );
            xs_warn( "context initialized \n");

            {
                int ret;
                while ((read_length = LibXML_read_perl(fh, buffer, 1024))) {
                    ret = xmlParseChunk(ctxt, buffer, read_length, 0);
                    if ( ret != 0 ) {
                        break;
                    }
                }
                ret = xmlParseChunk(ctxt, buffer, 0, 1);
                xs_warn( "document parsed \n");
            }

            ctxt->directory = NULL;
            xmlFree(ctxt->sax);
            ctxt->sax = NULL;
            xmlFree(sax);
            PmmSAXCloseContext(ctxt);
            xmlFreeParserCtxt(ctxt);
        }
        CLEANUP_ERROR_HANDLER;
        LibXML_cleanup_parser();
        REPORT_ERROR(recover);
#line 2360 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__parse_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, filename_sv");
    {
	SV *	self = ST(0)
;
	SV *	filename_sv = ST(1)
;
#line 2020 "LibXML.xs"
        STRLEN len;
        char * filename;
        HV * real_obj;
        int well_formed;
        int valid;
        int validate;
        xmlDocPtr real_doc;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2387 "LibXML.c"
	SV *	RETVAL;
#line 2030 "LibXML.xs"
        filename = SvPV(filename_sv, len);
        if (len <= 0) {
            croak("Empty filename\n");
            XSRETURN_UNDEF;
        }
#line 2395 "LibXML.c"
#line 2036 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;

        {
            xmlParserCtxtPtr ctxt = xmlCreateFileParserCtxt(filename);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(1);
                croak("Could not create file parser context for file \"%s\": %s\n",
                      filename, strerror(errno));
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);

            ctxt->_private = (void*)self;

            xs_warn( "context initialized\n" );
            xmlParseDocument(ctxt);
            xs_warn( "document parsed \n");

            well_formed = ctxt->wellFormed;
            valid = ctxt->valid;
            validate = ctxt->validate;
            real_doc = ctxt->myDoc;
            ctxt->myDoc = NULL;
            xmlFreeParserCtxt(ctxt);
        }

        if ( real_doc != NULL ) {
            if ( ! LibXML_will_die_ctx(saved_error, recover) &&
		 (recover || ( well_formed &&
                              ( !validate
                                || ( valid || ( real_doc->intSubset == NULL
                                                && real_doc->extSubset == NULL )))))) {
                RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
            } else {
                xmlFreeDoc(real_doc);
		real_doc=NULL;
            }
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2442 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_sax_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_sax_file)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, filename_sv");
    {
	SV *	self = ST(0)
;
	SV *	filename_sv = ST(1)
;
#line 2089 "LibXML.xs"
        STRLEN len;
        char * filename;
        HV * real_obj;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2467 "LibXML.c"
#line 2095 "LibXML.xs"
        filename = SvPV(filename_sv, len);
        if (len <= 0) {
            croak("Empty filename\n");
            XSRETURN_UNDEF;
        }
#line 2474 "LibXML.c"
#line 2101 "LibXML.xs"
        INIT_ERROR_HANDLER;

        {
            xmlParserCtxtPtr ctxt = xmlCreateFileParserCtxt(filename);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(recover ? recover : 1);
                croak("Could not create file parser context for file \"%s\": %s\n",
                      filename, strerror(errno));
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self, ctxt);
            recover = LibXML_get_recover(real_obj);

            ctxt->sax = PSaxGetHandler();
            PmmSAXInitContext( ctxt, self, saved_error );
            xs_warn( "context initialized \n");

            {
                xmlParseDocument(ctxt);
                xs_warn( "document parsed \n");
            }

            PmmSAXCloseContext(ctxt);
            xmlFreeParserCtxt(ctxt);
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2506 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__parse_html_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_html_string)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "self, string, svURL, svEncoding, options = 0");
    {
	SV *	self = ST(0)
;
	SV *	string = ST(1)
;
	SV *	svURL = ST(2)
;
	SV *	svEncoding = ST(3)
;
	int	options;
#line 2140 "LibXML.xs"
        STRLEN len;
        char * ptr;
        char* URL = NULL;
        const char * encoding = NULL;
        HV * real_obj;
        htmlDocPtr real_doc;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2537 "LibXML.c"
	SV *	RETVAL;

	if (items < 5)
	    options = 0;
	else {
	    options = (int)SvIV(ST(4))
;
	}
#line 2149 "LibXML.xs"
        /* If string is a reference to a string - dereference it.
         * See: https://rt.cpan.org/Ticket/Display.html?id=64051 (broke it)
         *      https://rt.cpan.org/Ticket/Display.html?id=77864 (fixed it) */
        if (SvROK(string) && !SvOBJECT(SvRV(string))) {
            string = SvRV(string);
        }
        ptr = SvPV(string, len);
        if (len <= 0) {
            croak("Empty string\n");
            XSRETURN_UNDEF;
        }
        if (SvOK(svURL))
          URL = SvPV_nolen( svURL );
        if (SvOK(svEncoding))
          encoding = SvPV_nolen( svEncoding );
#line 2562 "LibXML.c"
#line 2165 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);
        if (encoding == NULL && SvUTF8( string )) {
	  encoding = "UTF-8";
        }
        if (options & HTML_PARSE_RECOVER) {
          recover = ((options & HTML_PARSE_NOERROR) ? 2 : 1);
        }
#if LIBXML_VERSION >= 20627
        real_doc = htmlReadDoc((xmlChar*)ptr, URL, encoding, options);
#else
        real_doc = htmlParseDoc((xmlChar*)ptr, encoding);
        if ( real_doc ) {
            if (real_doc->URL) xmlFree((xmlChar *)real_doc->URL);
   	    if (URL) {
                real_doc->URL = xmlStrdup((const xmlChar*) URL);
            }
        }
#endif
        if ( real_doc ) {
	   if (URL==NULL) {
             SV * newURI = sv_2mortal(newSVpvf("unknown-%p", (void*)real_doc));
             real_doc->URL = xmlStrdup((const xmlChar*)SvPV_nolen(newURI));
           }
            /* This HTML memory parser doesn't use a ctxt; there is no "well-formed"
             * distinction, and if it manages to parse the HTML, it returns non-null. */
           RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2597 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_html_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_html_file)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "self, filename_sv, svURL, svEncoding, options = 0");
    {
	SV *	self = ST(0)
;
	SV *	filename_sv = ST(1)
;
	SV *	svURL = ST(2)
;
	SV *	svEncoding = ST(3)
;
	int	options;
#line 2210 "LibXML.xs"
        STRLEN len;
        char * filename;
        char * URL = NULL;
	char * encoding = NULL;
        HV * real_obj;
        htmlDocPtr real_doc;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 2630 "LibXML.c"
	SV *	RETVAL;

	if (items < 5)
	    options = 0;
	else {
	    options = (int)SvIV(ST(4))
;
	}
#line 2219 "LibXML.xs"
        filename = SvPV(filename_sv, len);
        if (len <= 0) {
            croak("Empty filename\n");
            XSRETURN_UNDEF;
        }
        if (SvOK(svURL))
          URL = SvPV_nolen( svURL );
        if (SvOK(svEncoding))
          encoding = SvPV_nolen( svEncoding );
#line 2649 "LibXML.c"
#line 2229 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);
        if (options & HTML_PARSE_RECOVER) {
          recover = ((options & HTML_PARSE_NOERROR) ? 2 : 1);
        }
#if LIBXML_VERSION >= 20627
        real_doc = htmlReadFile((const char *)filename,
				encoding,
				options);
#else
        real_doc = htmlParseFile((const char *)filename, encoding);
#endif
        if ( real_doc != NULL ) {

            /* This HTML file parser doesn't use a ctxt; there is no "well-formed"
             * distinction, and if it manages to parse the HTML, it returns non-null. */
	    if (URL) {
                if (real_doc->URL) xmlFree((xmlChar*) real_doc->URL);
                real_doc->URL = xmlStrdup((const xmlChar*) URL);
	    }
            RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );

        }
        CLEANUP_ERROR_HANDLER;
        LibXML_cleanup_parser();
        REPORT_ERROR(recover);
#line 2678 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_html_fh); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_html_fh)
{
    dVAR; dXSARGS;
    if (items < 4 || items > 5)
       croak_xs_usage(cv,  "self, fh, svURL, svEncoding, options = 0");
    {
	SV *	self = ST(0)
;
	SV *	fh = ST(1)
;
	SV *	svURL = ST(2)
;
	SV *	svEncoding = ST(3)
;
	int	options;
#line 2267 "LibXML.xs"
        HV * real_obj;
        htmlDocPtr real_doc;
        int recover = 0;
        char * URL = NULL;
        PREINIT_SAVED_ERROR
#if LIBXML_VERSION >= 20627
        char * encoding = NULL;
#else
        xmlCharEncoding enc = XML_CHAR_ENCODING_NONE;
#endif
#line 2713 "LibXML.c"
	SV *	RETVAL;

	if (items < 5)
	    options = 0;
	else {
	    options = (int)SvIV(ST(4))
;
	}
#line 2278 "LibXML.xs"
        if (SvOK(svURL))
          URL = SvPV_nolen( svURL );
#if LIBXML_VERSION >= 20627
        if (SvOK(svEncoding))
          encoding = SvPV_nolen( svEncoding );
#else
        if (SvOK(svEncoding))
          enc = xmlParseCharEncoding(SvPV_nolen( svEncoding ));
#endif
#line 2732 "LibXML.c"
#line 2288 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);
        if (options & HTML_PARSE_RECOVER) {
          recover = ((options & HTML_PARSE_NOERROR) ? 2 : 1);
        }
#if LIBXML_VERSION >= 20627

        real_doc = htmlReadIO((xmlInputReadCallback) LibXML_read_perl,
                              NULL,
			      (void *) fh,
			      URL,
			      encoding,
			      options);
#else /* LIBXML_VERSION >= 20627 */
        {
            int read_length;
            int well_formed;
            char buffer[1024];
            htmlParserCtxtPtr ctxt;

            read_length = LibXML_read_perl(fh, buffer, 4);
            if (read_length <= 0) {
                CLEANUP_ERROR_HANDLER;
                croak( "Empty Stream\n" );
            }
            ctxt = htmlCreatePushParserCtxt(NULL, NULL, buffer, read_length,
                                            URL, enc);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(recover ? recover : 1);
                croak("Could not create html push parser context!\n");
            }
            ctxt->_private = (void*)self;
            {
                int ret;
                while ((read_length = LibXML_read_perl(fh, buffer, 1024))) {
                    ret = htmlParseChunk(ctxt, buffer, read_length, 0);
                    if ( ret != 0 ) {
                        break;
                    }
                }
                ret = htmlParseChunk(ctxt, buffer, 0, 1);
            }
            well_formed = ctxt->wellFormed;
            real_doc = ctxt->myDoc;
            ctxt->myDoc = NULL;
            htmlFreeParserCtxt(ctxt);
        }
#endif /* LIBXML_VERSION >= 20627 */
        if ( real_doc != NULL ) {
            if (real_doc->URL) xmlFree((xmlChar*) real_doc->URL);
	    if (URL) {
                real_doc->URL = xmlStrdup((const xmlChar*) URL);
	    } else {
                SV * newURI = sv_2mortal(newSVpvf("unknown-%p", (void*)real_doc));
                real_doc->URL = xmlStrdup((const xmlChar*)SvPV_nolen(newURI));
            }

	    RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 2799 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_xml_chunk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_xml_chunk)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, svchunk, enc = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	svchunk = ST(1)
;
	SV *	enc;
#line 2362 "LibXML.xs"
        STRLEN len;
        const char * encoding = "UTF-8";
        HV * real_obj;
        int recover = 0;
        xmlChar * chunk;
        xmlNodePtr rv = NULL;
        PREINIT_SAVED_ERROR
#line 2827 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    enc = &PL_sv_undef;
	else {
	    enc = ST(2)
;
	}
#line 2370 "LibXML.xs"
        if (SvPOK(enc)) {
            encoding = SvPV(enc, len);
            if (len <= 0) {
                encoding = "UTF-8";
            }
        }
#line 2843 "LibXML.c"
#line 2377 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);

        chunk = Sv2C(svchunk, (const xmlChar*)encoding);

        if ( chunk != NULL ) {
            recover = LibXML_get_recover(real_obj);

            rv = domReadWellBalancedString( NULL, chunk, recover );

            if ( rv != NULL ) {
                xmlNodePtr fragment= NULL;
                xmlNodePtr rv_end = NULL;

                /* now we append the nodelist to a document
                   fragment which is unbound to a Document!!!! */

                /* step 1: create the fragment */
                fragment = xmlNewDocFragment( NULL );
                RETVAL = LibXML_NodeToSv(real_obj, fragment);

                /* step 2: set the node list to the fragment */
                fragment->children = rv;
                rv_end = rv;
                while ( rv_end->next != NULL ) {
                    rv_end->parent = fragment;
                    rv_end = rv_end->next;
                }
                /* the following line is important, otherwise we'll have
                   occasional segmentation faults
                 */
                rv_end->parent = fragment;
                fragment->last = rv_end;
            }

            /* free the chunk we created */
            xmlFree( chunk );
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);

	if (rv == NULL) {
            croak("_parse_xml_chunk: chunk parsing failed\n");
        }
#line 2892 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__parse_sax_xml_chunk); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__parse_sax_xml_chunk)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, svchunk, enc = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	svchunk = ST(1)
;
	SV *	enc;
#line 2433 "LibXML.xs"
        STRLEN len;
        char * ptr;
        const char * encoding = "UTF-8";
        HV * real_obj;
        int recover = 0;
        xmlChar * chunk;
        int retCode              = -1;
        xmlNodePtr nodes         = NULL;
        xmlSAXHandlerPtr handler = NULL;
        PREINIT_SAVED_ERROR
#line 2923 "LibXML.c"

	if (items < 3)
	    enc = &PL_sv_undef;
	else {
	    enc = ST(2)
;
	}
#line 2444 "LibXML.xs"
        if (SvPOK(enc)) {
            encoding = SvPV(enc, len);
            if (len <= 0) {
                encoding = "UTF-8";
            }
        }
        ptr = SvPV(svchunk, len);
        if (len <= 0) {
            croak("Empty string\n");
        }
#line 2942 "LibXML.c"
#line 2455 "LibXML.xs"
        INIT_ERROR_HANDLER;

        chunk = Sv2C(svchunk, (const xmlChar*)encoding);

        if ( chunk != NULL ) {
            xmlParserCtxtPtr ctxt = xmlCreateMemoryParserCtxt((const char*)ptr, len);
            if (ctxt == NULL) {
                CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(recover ? recover : 1);
                croak("Could not create memory parser context!\n");
            }
            xs_warn( "context created\n");
            real_obj = LibXML_init_parser(self,ctxt);
            recover = LibXML_get_recover(real_obj);

            PmmSAXInitContext( ctxt, self, saved_error );
            handler = PSaxGetHandler();

            retCode = xmlParseBalancedChunkMemory( NULL,
                                                   handler,
                                                   ctxt,
                                                   0,
                                                   chunk,
                                                   &nodes );

            xmlFree( handler );
            PmmSAXCloseContext(ctxt);
            xmlFreeParserCtxt(ctxt);

            /* free the chunk we created */
            xmlFree( chunk );
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);

	if (retCode == -1) {
            croak("_parse_sax_xml_chunk: chunk parsing failed\n");
        }
#line 2984 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__processXIncludes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__processXIncludes)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, doc, options=0");
    {
	SV *	self = ST(0)
;
	SV *	doc = ST(1)
;
	int	options;
#line 2502 "LibXML.xs"
        xmlDocPtr real_doc;
        HV * real_obj;
        int recover = 0;
        PREINIT_SAVED_ERROR
#line 3007 "LibXML.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    options = 0;
	else {
	    options = (int)SvIV(ST(2))
;
	}
#line 2507 "LibXML.xs"
        real_doc = (xmlDocPtr) PmmSvNode(doc);
        if (real_doc == NULL) {
            croak("No document to process!\n");
            XSRETURN_UNDEF;
        }
#line 3023 "LibXML.c"
#line 2513 "LibXML.xs"
        RETVAL = 0;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);
        recover = LibXML_get_recover(real_obj);

        RETVAL = xmlXIncludeProcessFlags(real_doc,options);

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);

        if ( RETVAL < 0 ) {
            croak( "unknown error during XInclude processing\n" );
            XSRETURN_UNDEF;
        } else if ( RETVAL == 0 ) {
            RETVAL = 1;
        }
#line 3042 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__start_push); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__start_push)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, with_sax=0");
    {
	SV *	self = ST(0)
;
	int	with_sax;
#line 2538 "LibXML.xs"
        HV * real_obj;
        int recover = 0;
        xmlParserCtxtPtr ctxt = NULL;
        PREINIT_SAVED_ERROR
#line 3064 "LibXML.c"
	SV *	RETVAL;

	if (items < 2)
	    with_sax = 0;
	else {
	    with_sax = (int)SvIV(ST(1))
;
	}
#line 2543 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;

        /* create empty context */
        ctxt = xmlCreatePushParserCtxt( NULL, NULL, NULL, 0, NULL );
        real_obj = LibXML_init_parser(self,ctxt);
        recover = LibXML_get_recover(real_obj);
        if ( with_sax == 1 ) {
	    PmmSAXInitContext( ctxt, self, saved_error );
        }

        RETVAL = PmmContextSv( ctxt );

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);
#line 3090 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__push); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__push)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, pctxt, data");
    {
	SV *	self = ST(0)
;
	SV *	pctxt = ST(1)
;
	SV *	data = ST(2)
;
#line 2568 "LibXML.xs"
        HV * real_obj;
        int recover = 0;
        xmlParserCtxtPtr ctxt = NULL;
        STRLEN len = 0;
        char * chunk = NULL;
        PREINIT_SAVED_ERROR
#line 3118 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 2575 "LibXML.xs"
        ctxt = PmmSvContext( pctxt );
        if ( ctxt == NULL ) {
            croak( "parser context already freed\n" );
            XSRETURN_UNDEF;
        }
        if ( data == &PL_sv_undef ) {
            XSRETURN_UNDEF;
        }
        chunk = SvPV( data, len );
        if ( len <= 0 ) {
            xs_warn( "empty string" );
            XSRETURN_UNDEF;
        }
#line 3135 "LibXML.c"
#line 2589 "LibXML.xs"
        RETVAL = 0;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);
        recover = LibXML_get_recover(real_obj);

        xmlParseChunk(ctxt, (const char *)chunk, len, 0);

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(recover);

        if ( ctxt->wellFormed == 0 ) {
            croak( "XML not well-formed in xmlParseChunk\n" );
            XSRETURN_UNDEF;
        }
        RETVAL = 1;
#line 3153 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__end_push); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__end_push)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, pctxt, restore");
    {
	SV *	self = ST(0)
;
	SV *	pctxt = ST(1)
;
	int	restore = (int)SvIV(ST(2))
;
#line 2614 "LibXML.xs"
        HV * real_obj;
        int well_formed;
        xmlParserCtxtPtr ctxt = NULL;
        xmlDocPtr real_doc = NULL;
        PREINIT_SAVED_ERROR
#line 3179 "LibXML.c"
	SV *	RETVAL;
#line 2620 "LibXML.xs"
        ctxt = PmmSvContext( pctxt );
        if ( ctxt == NULL ) {
            croak( "parser context already freed\n" );
            XSRETURN_UNDEF;
        }
#line 3187 "LibXML.c"
#line 2626 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);

        xmlParseChunk(ctxt, "", 0, 1); /* finish the parse */
        xs_warn( "Finished with push parser\n" );

        well_formed = ctxt->wellFormed;
        real_doc = ctxt->myDoc;
        ctxt->myDoc = NULL;
        xmlFreeParserCtxt(ctxt);
        PmmNODE( SvPROXYNODE( pctxt ) ) = NULL;

        if ( real_doc != NULL ) {
            if ( restore || well_formed ) {
                RETVAL = LibXML_NodeToSv( real_obj, INT2PTR(xmlNodePtr,real_doc) );
            } else {
                xmlFreeDoc(real_doc);
                real_doc = NULL;
            }
        }

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(restore);

        if ( real_doc == NULL ){
            croak( "no document found!\n" );
            XSRETURN_UNDEF;
        }
#line 3219 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__end_sax_push); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__end_sax_push)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pctxt");
    {
	SV *	self = ST(0)
;
	SV *	pctxt = ST(1)
;
#line 2664 "LibXML.xs"
        HV * real_obj;
        xmlParserCtxtPtr ctxt = NULL;
        PREINIT_SAVED_ERROR
#line 3242 "LibXML.c"
#line 2668 "LibXML.xs"
        ctxt = PmmSvContext( pctxt );
        if ( ctxt == NULL ) {
            croak( "parser context already freed\n" );
        }
#line 3248 "LibXML.c"
#line 2673 "LibXML.xs"
        INIT_ERROR_HANDLER;
        real_obj = LibXML_init_parser(self,NULL);

        xmlParseChunk(ctxt, "", 0, 1); /* finish the parse */
        xs_warn( "Finished with SAX push parser\n" );

        xmlFree(ctxt->sax);
        ctxt->sax = NULL;
        PmmSAXCloseContext(ctxt);
        xmlFreeParserCtxt(ctxt);
        PmmNODE( SvPROXYNODE( pctxt ) ) = NULL;

        LibXML_cleanup_parser();
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
#line 3265 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML_import_GDOME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_import_GDOME)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, sv_gdome, deep=1");
    {
	SV *	sv_gdome = ST(1)
;
	int	deep;
#line 2694 "LibXML.xs"
        xmlNodePtr node  = NULL;
#line 3283 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    deep = 1;
	else {
	    deep = (int)SvIV(ST(2))
;
	}
#line 2696 "LibXML.xs"
        RETVAL = &PL_sv_undef;
#ifndef XML_LIBXML_GDOME_SUPPORT
        croak( "GDOME Support not compiled" );
#endif
        if ( sv_gdome == NULL || sv_gdome == &PL_sv_undef ) {
            croak( "no XML::GDOME data found" );
        }
#ifdef XML_LIBXML_GDOME_SUPPORT
        else {
            GdomeNode* gnode = NULL;
            gnode = (GdomeNode*)SvIV((SV*)SvRV( sv_gdome ));
            if ( gnode == NULL ) {
                croak( "no XML::GDOME data found (datastructure empty)" );
            }

            node = gdome_xml_n_get_xmlNode( gnode );
            if ( node == NULL ) {
                croak( "no XML::LibXML node found in GDOME object" );
            }
        }
#endif
#line 3314 "LibXML.c"
#line 2718 "LibXML.xs"
        if ( node->type == XML_NAMESPACE_DECL ) {
            const char * CLASS = "XML::LibXML::Namespace";
            RETVAL = NEWSV(0,0);
            RETVAL = sv_setref_pv( RETVAL,
                                   CLASS,
                                   (void*)xmlCopyNamespace((xmlNsPtr)node) );
        }
        else {
            RETVAL = PmmNodeToSv( PmmCloneNode( node, deep ), NULL );
        }
#line 3326 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_export_GDOME); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_export_GDOME)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, sv_libxml, deep=1");
    {
	SV *	sv_libxml = ST(1)
;
	int	deep;
#line 2737 "LibXML.xs"
        xmlNodePtr node  = NULL, retnode = NULL;
#line 3346 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    deep = 1;
	else {
	    deep = (int)SvIV(ST(2))
;
	}
#line 2739 "LibXML.xs"
        RETVAL = &PL_sv_undef;
#ifndef XML_LIBXML_GDOME_SUPPORT
        croak( "GDOME Support not configured!" );
#endif
        if ( sv_libxml == NULL || sv_libxml == &PL_sv_undef ) {
            croak( "no XML::LibXML data found" );
        }
        node = PmmSvNode( sv_libxml );
        if ( node == NULL ) {
            croak( "no XML::LibXML data found (empty structure)" );
        }
#line 3367 "LibXML.c"
#line 2751 "LibXML.xs"
        retnode = PmmCloneNode( node, deep );
        if ( retnode == NULL ) {
            croak( "Copy node failed" );
        }

        RETVAL =  PmmNodeToGdomeSv( retnode );
#line 3375 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML_load_catalog); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML_load_catalog)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, filename");
    {
	SV *	filename = ST(1)
;
#line 2765 "LibXML.xs"
        const char * fn = (const char *) Sv2C(filename, NULL);
#line 3394 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 2767 "LibXML.xs"
        if ( fn == NULL || xmlStrlen( (xmlChar *)fn ) == 0 ) {
            croak( "cannot load catalog" );
        }
#line 3401 "LibXML.c"
#line 2771 "LibXML.xs"
#ifdef LIBXML_CATALOG_ENABLED
        RETVAL = xmlLoadCatalog( fn );
#else
        XSRETURN_UNDEF;
#endif
#line 3408 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__default_catalog); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__default_catalog)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, catalog");
    {
	SV *	catalog = ST(1)
;
#line 2785 "LibXML.xs"
#ifdef LIBXML_CATALOG_ENABLED
        xmlCatalogPtr catal = INT2PTR(xmlCatalogPtr,SvIV(SvRV(catalog)));
#endif
#line 3428 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 2789 "LibXML.xs"
        if ( catal == NULL ) {
            croak( "empty catalog\n" );
        }
#line 3435 "LibXML.c"
#line 2793 "LibXML.xs"
        warn( "this feature is not implemented" );
        RETVAL = 0;
#line 3439 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__externalEntityLoader); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__externalEntityLoader)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "loader");
    {
	SV*	loader = ST(0)
;
	SV *	RETVAL;
#line 2802 "LibXML.xs"
        {
            RETVAL = EXTERNAL_ENTITY_LOADER_FUNC;
            if(EXTERNAL_ENTITY_LOADER_FUNC == NULL)
            {
                EXTERNAL_ENTITY_LOADER_FUNC = newSVsv(loader);
            }

            if (LibXML_old_ext_ent_loader == NULL )
            {
                LibXML_old_ext_ent_loader = xmlGetExternalEntityLoader();
                xmlSetExternalEntityLoader((xmlExternalEntityLoader)LibXML_load_external_entity);
            }
        }
#line 3470 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__HashTable_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__HashTable_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	const char *	CLASS = (const char *)SvPV_nolen(ST(0))
;
	xmlHashTablePtr	RETVAL;
#line 2824 "LibXML.xs"
		RETVAL = xmlHashCreate(8);
#line 3490 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__HashTable_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__HashTable_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "table");
    {
	xmlHashTablePtr	table;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            table = INT2PTR(xmlHashTablePtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::HashTable::DESTROY() -- table is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 2832 "LibXML.xs"
        xs_warn("DESTROY XMLHASHTABLE\n");
	PmmFreeHashTable(table);
#line 3521 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__ParserContext_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__ParserContext_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 2841 "LibXML.xs"
        xs_warn( "DROP PARSER CONTEXT!" );
        PmmContextREFCNT_dec( SvPROXYNODE( self ) );
#line 3539 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document__toString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document__toString)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, format=0");
    {
	xmlDocPtr	self;
	int	format;
#line 2852 "LibXML.xs"
        xmlChar *result=NULL;
        int len=0;
        SV* internalFlag = NULL;
        int oldTagFlag = xmlSaveNoEmptyTags;
        xmlDtdPtr intSubset = NULL;
        /* PREINIT_SAVED_ERROR */
#line 3561 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::_toString() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::_toString() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    format = 0;
	else {
	    format = (int)SvIV(ST(1))
;
	}
#line 2859 "LibXML.xs"
        RETVAL = &PL_sv_undef;
        internalFlag = get_sv("XML::LibXML::setTagCompression", 0);
        if( internalFlag ) {
            xmlSaveNoEmptyTags = SvTRUE(internalFlag);
        }

        internalFlag = get_sv("XML::LibXML::skipDTD", 0);
        if ( internalFlag && SvTRUE(internalFlag) ) {
            intSubset = xmlGetIntSubset( self );
            if ( intSubset )
                xmlUnlinkNode( INT2PTR(xmlNodePtr,intSubset) );
        }

        /* INIT_ERROR_HANDLER; */

        if ( format <= 0 ) {
            xs_warn( "use no formated toString!" );
            xmlDocDumpMemory(self, &result, &len);
        }
        else {
            int t_indent_var = xmlIndentTreeOutput;
            xs_warn( "use formated toString!" );
            xmlIndentTreeOutput = 1;
            xmlDocDumpFormatMemory( self, &result, &len, format );
            xmlIndentTreeOutput = t_indent_var;
        }

        if ( intSubset != NULL ) {
            if (self->children == NULL) {
                xmlAddChild(INT2PTR(xmlNodePtr,self), INT2PTR(xmlNodePtr,intSubset));
            }
            else {
                xmlAddPrevSibling(self->children, INT2PTR(xmlNodePtr,intSubset));
            }
        }

        xmlSaveNoEmptyTags = oldTagFlag;

        /* REPORT_ERROR(0); */

        if (result == NULL) {
            xs_warn("Failed to convert doc to string");
            XSRETURN_UNDEF;
        } else {
            /* warn("%s, %d\n",result, len); */
            RETVAL = newSVpvn( (const char *)result, len );
	    /* C2Sv( result, self->encoding ); */
            xmlFree(result);
        }
#line 3633 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_toFH); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_toFH)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, filehandler, format=0");
    {
	xmlDocPtr	self;
	SV *	filehandler = ST(1)
;
	int	format;
#line 2917 "LibXML.xs"
        xmlOutputBufferPtr buffer;
        const xmlChar * encoding = NULL;
        xmlCharEncodingHandlerPtr handler = NULL;
        SV* internalFlag = NULL;
        int oldTagFlag = xmlSaveNoEmptyTags;
        xmlDtdPtr intSubset = NULL;
        int t_indent_var = xmlIndentTreeOutput;
        PREINIT_SAVED_ERROR
#line 3661 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::toFH() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::toFH() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    format = 0;
	else {
	    format = (int)SvIV(ST(2))
;
	}
#line 2926 "LibXML.xs"
        internalFlag = get_sv("XML::LibXML::setTagCompression", 0);
        if( internalFlag ) {
            xmlSaveNoEmptyTags = SvTRUE(internalFlag);
        }

        internalFlag = get_sv("XML::LibXML::skipDTD", 0);
        if ( internalFlag && SvTRUE(internalFlag) ) {
            intSubset = xmlGetIntSubset( self );
            if ( intSubset )
                xmlUnlinkNode( INT2PTR(xmlNodePtr,intSubset) );
        }

        xmlRegisterDefaultOutputCallbacks();
        encoding = (self)->encoding;
        if ( encoding != NULL ) {
            if ( xmlParseCharEncoding((const char*)encoding) != XML_CHAR_ENCODING_UTF8) {
                handler = xmlFindCharEncodingHandler((const char*)encoding);
            }

        }
        else {
            xs_warn("no encoding?");
        }

        buffer = xmlOutputBufferCreateIO( (xmlOutputWriteCallback) &LibXML_output_write_handler,
                                          (xmlOutputCloseCallback)&LibXML_output_close_handler,
                                          filehandler,
                                          handler );

        if ( format <= 0 ) {
            format = 0;
            xmlIndentTreeOutput = 0;
        }
        else {
            xmlIndentTreeOutput = 1;
        }

        INIT_ERROR_HANDLER;

        RETVAL = xmlSaveFormatFileTo( buffer,
                                      self,
                                      (const char *) encoding,
                                      format);

        if ( intSubset != NULL ) {
            if (self->children == NULL) {
                xmlAddChild(INT2PTR(xmlNodePtr,self), INT2PTR(xmlNodePtr,intSubset));
            }
            else {
                xmlAddPrevSibling(self->children, INT2PTR(xmlNodePtr,intSubset));
            }
        }

        xmlIndentTreeOutput = t_indent_var;
        xmlSaveNoEmptyTags = oldTagFlag;
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
#line 3742 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_toFile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_toFile)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, filename, format=0");
    {
	xmlDocPtr	self;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
	int	format;
#line 2992 "LibXML.xs"
        SV* internalFlag = NULL;
        int oldTagFlag = xmlSaveNoEmptyTags;
        PREINIT_SAVED_ERROR
#line 3764 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::toFile() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::toFile() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    format = 0;
	else {
	    format = (int)SvIV(ST(2))
;
	}
#line 2996 "LibXML.xs"
        internalFlag = get_sv("XML::LibXML::setTagCompression", 0);
        if( internalFlag ) {
            xmlSaveNoEmptyTags = SvTRUE(internalFlag);
        }

        INIT_ERROR_HANDLER;

        if ( format <= 0 ) {
            xs_warn( "use no formated toFile!" );
            RETVAL = xmlSaveFile( filename, self );
        }
        else {
            int t_indent_var = xmlIndentTreeOutput;
            xmlIndentTreeOutput = 1;
            RETVAL =xmlSaveFormatFile( filename,
                                       self,
                                       format);
            xmlIndentTreeOutput = t_indent_var;
        }

        xmlSaveNoEmptyTags = oldTagFlag;
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);

        if ( RETVAL > 0 )
            RETVAL = 1;
        else
            XSRETURN_UNDEF;
#line 3816 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_toStringHTML); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_toStringHTML)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3033 "LibXML.xs"
        xmlChar *result=NULL;
        int len = 0;
        PREINIT_SAVED_ERROR
#line 3836 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::toStringHTML() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::toStringHTML() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3037 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        xs_warn( "use no formated toString!" );
        INIT_ERROR_HANDLER;
        htmlDocDumpMemory(self, &result, &len);
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);

        if (result == NULL) {
            XSRETURN_UNDEF;
        } else {
            /* warn("%s, %d\n",result, len); */
            RETVAL = newSVpvn((char *)result, (STRLEN)len);
            xmlFree(result);
        }
#line 3866 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_URI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_URI)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	const char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::URI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::URI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3061 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = (const char*)xmlStrdup(self->URL );
#line 3901 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setURI)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, new_URI");
    {
	xmlDocPtr	self;
	char *	new_URI = (char *)SvPV_nolen(ST(1))
;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3071 "LibXML.xs"
        if (new_URI) {
            xmlFree((xmlChar*)self->URL );
            self->URL = xmlStrdup((const xmlChar*)new_URI);
        }
#line 3936 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_createDocument); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createDocument)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "CLASS, version=\"1.0\", encoding=NULL");
    {
	char *	version;
	char *	encoding;
#line 3083 "LibXML.xs"
        xmlDocPtr doc=NULL;
#line 3954 "LibXML.c"
	SV *	RETVAL;

	if (items < 2)
	    version = "1.0";
	else {
	    version = (char *)SvPV_nolen(ST(1))
;
	}

	if (items < 3)
	    encoding = NULL;
	else {
	    encoding = (char *)SvPV_nolen(ST(2))
;
	}
#line 3085 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        doc = xmlNewDoc((const xmlChar*)version);
        if (encoding && *encoding != 0) {
            doc->encoding = (const xmlChar*)xmlStrdup((const xmlChar*)encoding);
        }
        RETVAL = PmmNodeToSv(INT2PTR(xmlNodePtr,doc),NULL);
#line 3977 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createInternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createInternalSubset)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, Pname, extID, sysID");
    {
	xmlDocPtr	self;
	SV *	Pname = ST(1)
;
	SV *	extID = ST(2)
;
	SV *	sysID = ST(3)
;
#line 3101 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        xmlChar * name = NULL;
        xmlChar * externalID = NULL;
        xmlChar * systemID = NULL;
#line 4004 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createInternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createInternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3106 "LibXML.xs"
        name = Sv2C( Pname, NULL );
        if ( name == NULL ) {
            XSRETURN_UNDEF;
        }

        externalID = Sv2C(extID, NULL);
        systemID   = Sv2C(sysID, NULL);

        dtd = xmlCreateIntSubset( self, name, externalID, systemID );
        xmlFree(externalID);
        xmlFree(systemID);
        xmlFree(name);
        if ( dtd ) {
            RETVAL = PmmNodeToSv( INT2PTR(xmlNodePtr,dtd), PmmPROXYNODE(self) );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4038 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createExternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createExternalSubset)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, Pname, extID, sysID");
    {
	xmlDocPtr	self;
	SV *	Pname = ST(1)
;
	SV *	extID = ST(2)
;
	SV *	sysID = ST(3)
;
#line 3134 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        xmlChar * name = NULL;
        xmlChar * externalID = NULL;
        xmlChar * systemID = NULL;
#line 4065 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createExternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createExternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3139 "LibXML.xs"
        name = Sv2C( Pname, NULL );
        if ( name == NULL ) {
            XSRETURN_UNDEF;
        }

        externalID = Sv2C(extID, NULL);
        systemID   = Sv2C(sysID, NULL);

        dtd = xmlNewDtd( self, name, externalID, systemID );

        xmlFree(externalID);
        xmlFree(systemID);
        xmlFree(name);
        if ( dtd ) {
            RETVAL = PmmNodeToSv( (xmlNodePtr)dtd, PmmPROXYNODE(self) );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4100 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createDTD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createDTD)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, Pname, extID, sysID");
    {
	xmlDocPtr	self;
	SV *	Pname = ST(1)
;
	SV *	extID = ST(2)
;
	SV *	sysID = ST(3)
;
#line 3168 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        xmlChar * name = NULL;
        xmlChar * externalID = NULL;
        xmlChar * systemID = NULL;
#line 4127 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createDTD() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createDTD() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3173 "LibXML.xs"
        name = Sv2C( Pname, NULL );
        if ( name == NULL ) {
            XSRETURN_UNDEF;
        }

        externalID = Sv2C(extID, NULL);
        systemID   = Sv2C(sysID, NULL);

        dtd = xmlNewDtd( NULL, name, externalID, systemID );
        dtd->doc = self;

        xmlFree(externalID);
        xmlFree(systemID);
        xmlFree(name);
        if ( dtd ) {
            RETVAL = PmmNodeToSv( (xmlNodePtr)dtd, PmmPROXYNODE(self) );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4163 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createDocumentFragment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createDocumentFragment)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createDocumentFragment() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createDocumentFragment() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3200 "LibXML.xs"
        RETVAL = PmmNodeToSv(xmlNewDocFragment(self), PmmPROXYNODE(self));
#line 4195 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createElement)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, name");
    {
	xmlDocPtr	self;
	SV*	name = ST(1)
;
#line 3209 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * elname = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4217 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createElement() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createElement() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3213 "LibXML.xs"
        elname = nodeSv2C( name , (xmlNodePtr) self);
        if ( !LibXML_test_node_name( elname ) ) {
            xmlFree( elname );
            croak( "bad name" );
        }

        newNode = xmlNewNode(NULL , elname);
        xmlFree(elname);
        if ( newNode != NULL ) {
            docfrag = PmmNewFragment( self );
            newNode->doc = self;
            xmlAddChild(PmmNODE(docfrag), newNode);
            RETVAL = PmmNodeToSv(newNode,docfrag);
        }
        else {
            xs_warn( "no node created!" );
            XSRETURN_UNDEF;
        }
#line 4251 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createRawElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createRawElement)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, name");
    {
	xmlDocPtr	self;
	SV*	name = ST(1)
;
#line 3239 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * elname = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4273 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createRawElement() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createRawElement() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3243 "LibXML.xs"
        elname = nodeSv2C( name , (xmlNodePtr) self);
        if ( !elname || xmlStrlen(elname) <= 0 ) {
            xmlFree( elname );
            croak( "bad name" );
        }

        newNode = xmlNewDocNode(self,NULL , elname, NULL);
        xmlFree(elname);
        if ( newNode != NULL ) {
            docfrag = PmmNewFragment( self );
            xmlAddChild(PmmNODE(docfrag), newNode);
            RETVAL = PmmNodeToSv(newNode,docfrag);
        }
        else {
            xs_warn( "no node created!" );
            XSRETURN_UNDEF;
        }
#line 4306 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createElementNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createElementNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nsURI, name");
    {
	xmlDocPtr	self;
	SV *	nsURI = ST(1)
;
	SV *	name = ST(2)
;
#line 3269 "LibXML.xs"
        xmlChar * ename        = NULL;
        xmlChar * prefix       = NULL;
        xmlChar * localname    = NULL;
        xmlChar * eURI         = NULL;
        xmlNsPtr ns            = NULL;
        ProxyNodePtr docfrag   = NULL;
        xmlNodePtr newNode     = NULL;
#line 4334 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createElementNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createElementNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3277 "LibXML.xs"
        ename = nodeSv2C( name , (xmlNodePtr) self );
        if ( !LibXML_test_node_name( ename ) ) {
            xmlFree( ename );
            croak( "bad name" );
        }

        eURI  = Sv2C( nsURI , NULL );

        if ( eURI != NULL && xmlStrlen(eURI)!=0 ){
            localname = xmlSplitQName2(ename, &prefix);
            if ( localname == NULL ) {
                localname = xmlStrdup( ename );
            }

			ns = xmlNewNs( NULL, eURI, prefix );
            newNode = xmlNewDocNode( self, ns, localname, NULL );
			newNode->nsDef = ns;

            xmlFree(localname);
        }
        else {
            xs_warn( " ordinary element " );
            /* ordinary element */
            localname = ename;

            newNode = xmlNewDocNode( self, NULL , localname, NULL );
        }

        docfrag = PmmNewFragment( self );
        xmlAddChild(PmmNODE(docfrag), newNode);
        RETVAL = PmmNodeToSv(newNode, docfrag);

        if ( prefix != NULL ) {
            xmlFree(prefix);
        }
        if ( eURI != NULL ) {
            xmlFree(eURI);
        }
        xmlFree(ename);
#line 4389 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createRawElementNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createRawElementNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nsURI, name");
    {
	xmlDocPtr	self;
	SV *	nsURI = ST(1)
;
	SV *	name = ST(2)
;
#line 3325 "LibXML.xs"
        xmlChar * ename        = NULL;
        xmlChar * prefix       = NULL;
        xmlChar * localname    = NULL;
        xmlChar * eURI         = NULL;
        xmlNsPtr ns            = NULL;
        ProxyNodePtr docfrag   = NULL;
        xmlNodePtr newNode     = NULL;
#line 4417 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createRawElementNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createRawElementNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3333 "LibXML.xs"
        ename = nodeSv2C( name , (xmlNodePtr) self );
        if ( !LibXML_test_node_name( ename ) ) {
            xmlFree( ename );
            croak( "bad name" );
        }

        eURI  = Sv2C( nsURI , NULL );

        if ( eURI != NULL && xmlStrlen(eURI)!=0 ){
            localname = xmlSplitQName2(ename, &prefix);
            if ( localname == NULL ) {
                localname = xmlStrdup( ename );
            }

            newNode = xmlNewDocNode( self,NULL , localname, NULL );

            ns = xmlSearchNsByHref( self, newNode, eURI );
            if ( ns == NULL ) {
                /* create a new NS if the NS does not already exists */
                ns = xmlNewNs(newNode, eURI , prefix );
            }

            if ( ns == NULL ) {
                xmlFreeNode( newNode );
                xmlFree(eURI);
                xmlFree(localname);
                if ( prefix != NULL ) {
                    xmlFree(prefix);
                }
                xmlFree(ename);
                XSRETURN_UNDEF;
            }

            xmlFree(localname);
        }
        else {
            xs_warn( " ordinary element " );
            /* ordinary element */
            localname = ename;

            newNode = xmlNewDocNode( self, NULL , localname, NULL );
        }

        xmlSetNs(newNode, ns);
        docfrag = PmmNewFragment( self );
        xmlAddChild(PmmNODE(docfrag), newNode);
        RETVAL = PmmNodeToSv(newNode, docfrag);

        if ( prefix != NULL ) {
            xmlFree(prefix);
        }
        if ( eURI != NULL ) {
            xmlFree(eURI);
        }
        xmlFree(ename);
#line 4488 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createTextNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createTextNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, content");
    {
	xmlDocPtr	self;
	SV *	content = ST(1)
;
#line 3396 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * elname = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4510 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createTextNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createTextNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3400 "LibXML.xs"
        elname = nodeSv2C( content , (xmlNodePtr) self );
        if ( elname != NULL || xmlStrlen(elname) > 0 ) {
            newNode = xmlNewDocText( self, elname );
            xmlFree(elname);
            if ( newNode != NULL ) {
                docfrag = PmmNewFragment( self );
                newNode->doc = self;
                xmlAddChild(PmmNODE(docfrag), newNode);
                RETVAL = PmmNodeToSv(newNode,docfrag);
            }
            else {
                xs_warn( "no node created!" );
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4544 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createComment); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createComment)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, content");
    {
	xmlDocPtr	self;
	SV *	content = ST(1)
;
#line 3426 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * elname = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4566 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createComment() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createComment() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3430 "LibXML.xs"
        elname = nodeSv2C( content , (xmlNodePtr) self );
        if ( elname != NULL || xmlStrlen(elname) > 0 ) {
            newNode = xmlNewDocComment( self, elname );
            xmlFree(elname);
            if ( newNode != NULL ) {
                docfrag = PmmNewFragment( self );
                newNode->doc = self;
                xmlAddChild(PmmNODE(docfrag), newNode);
                xs_warn( newNode->name );
                RETVAL = PmmNodeToSv(newNode,docfrag);
            }
            else {
                xs_warn( "no node created!" );
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4601 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createCDATASection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createCDATASection)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, content");
    {
	xmlDocPtr	self;
	SV *	content = ST(1)
;
#line 3457 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * elname = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4623 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createCDATASection() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createCDATASection() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3461 "LibXML.xs"
        elname = nodeSv2C( content , (xmlNodePtr)self );
        if ( elname != NULL || xmlStrlen(elname) > 0 ) {
            newNode = xmlNewCDataBlock( self, elname, xmlStrlen(elname) );
            xmlFree(elname);
            if ( newNode != NULL ) {
                docfrag = PmmNewFragment( self );
                newNode->doc = self;
                xmlAddChild(PmmNODE(docfrag), newNode);
                xs_warn( "[CDATA section]" );
                RETVAL = PmmNodeToSv(newNode,docfrag);
            }
            else {
                xs_warn( "no node created!" );
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 4658 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createEntityReference); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createEntityReference)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pname");
    {
	xmlDocPtr	self;
	SV *	pname = ST(1)
;
#line 3488 "LibXML.xs"
        xmlNodePtr newNode;
        xmlChar * name = Sv2C( pname, NULL );
        ProxyNodePtr docfrag = NULL;
#line 4680 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createEntityReference() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createEntityReference() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3492 "LibXML.xs"
        if ( name == NULL ) {
            XSRETURN_UNDEF;
        }
        newNode = xmlNewReference( self, name );
        xmlFree(name);
        if ( newNode == NULL ) {
            XSRETURN_UNDEF;
        }
        docfrag = PmmNewFragment( self );
        xmlAddChild(PmmNODE(docfrag), newNode);
        RETVAL = PmmNodeToSv( newNode, docfrag );
#line 4707 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createAttribute)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, pname, pvalue=&PL_sv_undef");
    {
	xmlDocPtr	self;
	SV *	pname = ST(1)
;
	SV *	pvalue;
#line 3512 "LibXML.xs"
        xmlChar * name = NULL;
        xmlChar * value = NULL;
        xmlAttrPtr newAttr = NULL;
        xmlChar * buffer = NULL;
#line 4731 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createAttribute() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createAttribute() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    pvalue = &PL_sv_undef;
	else {
	    pvalue = ST(2)
;
	}
#line 3517 "LibXML.xs"
        name = nodeSv2C( pname , (xmlNodePtr) self );
        if ( !LibXML_test_node_name( name ) ) {
            xmlFree(name);
            XSRETURN_UNDEF;
        }

        value = nodeSv2C( pvalue , (xmlNodePtr) self );
        /* unlike xmlSetProp, xmlNewDocProp does not encode entities in value */
        buffer = xmlEncodeEntitiesReentrant(self, value);
        newAttr = xmlNewDocProp( self, name, buffer );
        RETVAL = PmmNodeToSv((xmlNodePtr)newAttr, PmmPROXYNODE(self));

        xmlFree(name);
        xmlFree(buffer);
        if ( value ) {
            xmlFree(value);
        }
#line 4771 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createAttributeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createAttributeNS)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "self, URI, pname, pvalue=&PL_sv_undef");
    {
	xmlDocPtr	self;
	SV *	URI = ST(1)
;
	SV *	pname = ST(2)
;
	SV *	pvalue;
#line 3544 "LibXML.xs"
        xmlChar * name = NULL;
        xmlChar * value = NULL;
        xmlChar * prefix = NULL;
        const xmlChar * pchar = NULL;
        xmlChar * localname = NULL;
        xmlChar * nsURI = NULL;
        xmlAttrPtr newAttr = NULL;
        xmlNsPtr ns = NULL;
#line 4801 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createAttributeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createAttributeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 4)
	    pvalue = &PL_sv_undef;
	else {
	    pvalue = ST(3)
;
	}
#line 3553 "LibXML.xs"
        name = nodeSv2C( pname , (xmlNodePtr) self );
        if ( !LibXML_test_node_name( name ) ) {
            xmlFree(name);
            XSRETURN_UNDEF;
        }

        nsURI = Sv2C( URI , NULL );
        value = nodeSv2C( pvalue, (xmlNodePtr) self  );

        if ( nsURI != NULL && xmlStrlen(nsURI) > 0 ) {
            xmlNodePtr root = xmlDocGetRootElement(self );
            if ( root ) {
                pchar = xmlStrchr(name, ':');
                if ( pchar != NULL ) {
                    localname = xmlSplitQName2(name, &prefix);
                }
                else {
                    localname = xmlStrdup( name );
                }
                ns = xmlSearchNsByHref( self, root, nsURI );
                if ( ns == NULL ) {
                    /* create a new NS if the NS does not already exists */
                    ns = xmlNewNs(root, nsURI , prefix );
                }

                if ( ns == NULL ) {
                    xmlFree(nsURI);
                    xmlFree(localname);
                    if ( prefix ) {
                        xmlFree(prefix);
                    }
                    xmlFree(name);
                    if ( value ) {
                        xmlFree(value);
                    }
                    XSRETURN_UNDEF;
                }

                newAttr = xmlNewDocProp( self, localname, value );
                xmlSetNs((xmlNodePtr)newAttr, ns);

                RETVAL = PmmNodeToSv((xmlNodePtr)newAttr, PmmPROXYNODE(self) );

                xmlFree(nsURI);
                xmlFree(name);
                if ( prefix ) {
                    xmlFree(prefix);
                }
                xmlFree(localname);
                if ( value ) {
                    xmlFree(value);
                }
            }
            else {
                croak( "can't create a new namespace on an attribute!" );
                xmlFree(name);
                if ( value ) {
                    xmlFree(value);
                }
                XSRETURN_UNDEF;
            }
        }
        else {
            xmlChar *buffer;
            /* unlike xmlSetProp, xmlNewDocProp does not encode entities in value */
            buffer = xmlEncodeEntitiesReentrant(self, value);
            newAttr = xmlNewDocProp( self, name, buffer );
            RETVAL = PmmNodeToSv((xmlNodePtr)newAttr,PmmPROXYNODE(self));
            xmlFree(name);
            xmlFree(buffer);
            if ( value ) {
                xmlFree(value);
            }
        }
#line 4898 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_createProcessingInstruction); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_createProcessingInstruction)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, name, value=&PL_sv_undef");
    {
	xmlDocPtr	self;
	SV *	name = ST(1)
;
	SV *	value;
#line 3638 "LibXML.xs"
        xmlChar * n = NULL;
        xmlChar * v = NULL;
        xmlNodePtr newNode = NULL;
        ProxyNodePtr docfrag = NULL;
#line 4923 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::createProcessingInstruction() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::createProcessingInstruction() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    value = &PL_sv_undef;
	else {
	    value = ST(2)
;
	}
#line 3643 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        n = nodeSv2C(name, (xmlNodePtr)self);
        if ( !n ) {
            XSRETURN_UNDEF;
        }
        v = nodeSv2C(value, (xmlNodePtr)self);
        newNode = xmlNewPI(n,v);
        xmlFree(v);
        xmlFree(n);
	if ( newNode != NULL ) {
 	   docfrag = PmmNewFragment( self );
           newNode->doc = self;
	   xmlAddChild(PmmNODE(docfrag), newNode);
	   RETVAL = PmmNodeToSv(newNode,docfrag);
	} else {
 	   xs_warn( "no node created!" );
 	   XSRETURN_UNDEF;
        }
#line 4964 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document__setDocumentElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document__setDocumentElement)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, proxy");
    {
	xmlDocPtr	self;
	SV *	proxy = ST(1)
;
#line 3669 "LibXML.xs"
        xmlNodePtr elem, oelem;
#line 4984 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::_setDocumentElement() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::_setDocumentElement() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3671 "LibXML.xs"
        elem = PmmSvNode(proxy);
        if ( elem == NULL ) {
            XSRETURN_UNDEF;
        }
#line 5003 "LibXML.c"
#line 3676 "LibXML.xs"
        /* please correct me if i am wrong: the document element HAS to be
         * an ELEMENT NODE
         */
        if ( elem->type == XML_ELEMENT_NODE ) {
            if ( self != elem->doc ) {
	        domImportNode( self, elem, 1, 1 );
            }

            oelem = xmlDocGetRootElement( self );
            if ( oelem == NULL || oelem->_private == NULL ) {
                xmlDocSetRootElement( self, elem );
            }
            else {
                ProxyNodePtr docfrag = PmmNewFragment( self );
                xmlReplaceNode( oelem, elem );
                xmlAddChild( PmmNODE(docfrag), oelem );
                PmmFixOwner( ((ProxyNodePtr)oelem->_private), docfrag);
            }

            if ( elem->_private != NULL ) {
                PmmFixOwner( SvPROXYNODE(proxy), PmmPROXYNODE(self));
            }
        } else {
            croak("setDocumentElement: ELEMENT node required");
        }
#line 5030 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_documentElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_documentElement)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3708 "LibXML.xs"
        xmlNodePtr elem;
#line 5047 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::documentElement() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::documentElement() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3710 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        elem = xmlDocGetRootElement( self );
        if ( elem ) {
            RETVAL = PmmNodeToSv(elem, PmmPROXYNODE(self));
        }
        else {
            XSRETURN_UNDEF;
        }
#line 5071 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_externalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_externalSubset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3725 "LibXML.xs"
        xmlDtdPtr dtd;
#line 5089 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::externalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::externalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3727 "LibXML.xs"
        if ( self->extSubset == NULL ) {
            XSRETURN_UNDEF;
        }

        dtd = self->extSubset;
        RETVAL = PmmNodeToSv((xmlNodePtr)dtd, PmmPROXYNODE(self));
#line 5111 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_internalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_internalSubset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3740 "LibXML.xs"
        xmlDtdPtr dtd;
#line 5129 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::internalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::internalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3742 "LibXML.xs"
        if ( self->intSubset == NULL ) {
            XSRETURN_UNDEF;
        }

        dtd = self->intSubset;
RETVAL = PmmNodeToSv(INT2PTR(xmlNodePtr,dtd), PmmPROXYNODE(self));
#line 5151 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setExternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setExternalSubset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, extdtd");
    {
	xmlDocPtr	self;
	SV *	extdtd = ST(1)
;
#line 3756 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        xmlDtdPtr olddtd = NULL;
#line 5172 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setExternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setExternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3759 "LibXML.xs"
        dtd = (xmlDtdPtr)PmmSvNode(extdtd);
        if ( dtd == NULL ) {
            croak( "lost DTD node" );
        }
#line 5191 "LibXML.c"
#line 3764 "LibXML.xs"
        if ( dtd && dtd != self->extSubset ) {
            if ( dtd->doc == NULL ) {
                xmlSetTreeDoc( (xmlNodePtr) dtd, self );
            } else if ( dtd->doc != self ) {
	        domImportNode( self, (xmlNodePtr) dtd,1,1);
            }

            if ( dtd == self->intSubset ) {
                xmlUnlinkNode( (xmlNodePtr)dtd );
                self->intSubset = NULL;
            }

            olddtd = self->extSubset;
            if ( olddtd && olddtd->_private == NULL ) {
                xmlFreeDtd( olddtd );
            }
            self->extSubset = dtd;
        }
#line 5211 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_setInternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setInternalSubset)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, extdtd");
    {
	xmlDocPtr	self;
	SV *	extdtd = ST(1)
;
#line 3788 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        xmlDtdPtr olddtd = NULL;
#line 5230 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setInternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setInternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3791 "LibXML.xs"
        dtd = (xmlDtdPtr)PmmSvNode(extdtd);
        if ( dtd == NULL ) {
            croak( "lost DTD node" );
        }
#line 5249 "LibXML.c"
#line 3796 "LibXML.xs"
        if ( dtd && dtd != self->intSubset ) {
            if ( dtd->doc != self ) {
                croak( "can't import DTDs" );
                domImportNode( self, (xmlNodePtr) dtd,1,1);
            }

            if ( dtd == self->extSubset ) {
                self->extSubset = NULL;
            }

            olddtd = xmlGetIntSubset( self );
            if( olddtd ) {
                xmlReplaceNode( (xmlNodePtr)olddtd, (xmlNodePtr) dtd );
                if ( olddtd->_private == NULL ) {
                    xmlFreeDtd( olddtd );
                }
            }
            else {
                if (self->children == NULL)
                    xmlAddChild((xmlNodePtr) self, (xmlNodePtr) dtd);
                else
                    xmlAddPrevSibling(self->children, (xmlNodePtr) dtd);
            }
            self->intSubset = dtd;
        }
#line 5276 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_removeInternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_removeInternalSubset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3826 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
#line 5292 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::removeInternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::removeInternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3828 "LibXML.xs"
        dtd = xmlGetIntSubset(self);
        if ( !dtd ) {
            XSRETURN_UNDEF;
        }
        xmlUnlinkNode( (xmlNodePtr)dtd );
        self->intSubset = NULL;
        RETVAL = PmmNodeToSv( (xmlNodePtr)dtd, PmmPROXYNODE(self) );
#line 5315 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_removeExternalSubset); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_removeExternalSubset)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
#line 3842 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
#line 5333 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::removeExternalSubset() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::removeExternalSubset() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3844 "LibXML.xs"
        dtd = self->extSubset;
        if ( !dtd ) {
            XSRETURN_UNDEF;
        }
        self->extSubset = NULL;
        RETVAL = PmmNodeToSv( (xmlNodePtr)dtd, PmmPROXYNODE(self) );
#line 5355 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_importNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_importNode)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, node, dummy=0");
    {
	xmlDocPtr	self;
	xmlNodePtr	node;
	int	dummy;
#line 3859 "LibXML.xs"
        xmlNodePtr ret = NULL;
        ProxyNodePtr docfrag = NULL;
#line 5376 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::importNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::importNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Document::importNode() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Document::importNode() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    dummy = 0;
	else {
	    dummy = (int)SvIV(ST(2))
;
	}
#line 3862 "LibXML.xs"
        if ( node->type == XML_DOCUMENT_NODE
             || node->type == XML_HTML_DOCUMENT_NODE ) {
            croak( "Can't import Documents!" );
            XSRETURN_UNDEF;
        }
        if (node->type == XML_DTD_NODE) {
            croak("Can't import DTD nodes");
        }

        ret = domImportNode( self, node, 0, 1 );
        if ( ret ) {
            docfrag = PmmNewFragment( self );
            xmlAddChild( PmmNODE(docfrag), ret );
            RETVAL = PmmNodeToSv( ret, docfrag);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 5430 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_adoptNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_adoptNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, node");
    {
	xmlDocPtr	self;
	xmlNodePtr	node;
#line 3888 "LibXML.xs"
        xmlNodePtr ret = NULL;
        ProxyNodePtr docfrag = NULL;
#line 5450 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::adoptNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::adoptNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Document::adoptNode() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Document::adoptNode() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3891 "LibXML.xs"
        if ( node->type == XML_DOCUMENT_NODE
             || node->type == XML_HTML_DOCUMENT_NODE ) {
            croak( "Can't adopt Documents!" );
            XSRETURN_UNDEF;
        }
        if (node->type == XML_DTD_NODE) {
            croak("Can't adopt DTD nodes");
        }

        ret = domImportNode( self, node, 1, 1 );

        if ( ret ) {
            docfrag = PmmNewFragment( self );
            RETVAL = PmmNodeToSv(node, docfrag);
            xmlAddChild( PmmNODE(docfrag), ret );
            PmmFixOwner(SvPROXYNODE(RETVAL), docfrag);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 5499 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_encoding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_encoding)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::encoding() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::encoding() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3921 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = (char *) self->encoding;
#line 5534 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setEncoding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setEncoding)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, encoding = NULL");
    {
	xmlDocPtr	self;
	char *	encoding;
#line 3931 "LibXML.xs"
        int charset = XML_CHAR_ENCODING_ERROR;
#line 5552 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setEncoding() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setEncoding() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    encoding = NULL;
	else {
	    encoding = (char *)SvPV_nolen(ST(1))
;
	}
#line 3933 "LibXML.xs"
        if ( self->encoding != NULL ) {
            xmlFree( (xmlChar*) self->encoding );
        }
        if (encoding!=NULL && strlen(encoding)) {
	  self->encoding = xmlStrdup( (const xmlChar *)encoding );
	  charset = (int)xmlParseCharEncoding( (const char*)self->encoding );
	  if ( charset <= 0 ) {
            charset = XML_CHAR_ENCODING_ERROR;
	  }
	} else {
	  self->encoding=NULL;
          charset = XML_CHAR_ENCODING_UTF8;
	}
        SetPmmNodeEncoding(self, charset);
#line 5588 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_standalone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_standalone)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::standalone() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::standalone() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3955 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = self->standalone;
#line 5621 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setStandalone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setStandalone)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, value = 0");
    {
	xmlDocPtr	self;
	int	value;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setStandalone() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setStandalone() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    value = 0;
	else {
	    value = (int)SvIV(ST(1))
;
	}
#line 3965 "LibXML.xs"
        if ( value > 0 ) {
            self->standalone = 1;
        }
        else if ( value < 0 ) {
            self->standalone = -1;
        }
        else {
            self->standalone = 0;
        }
#line 5667 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_version); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_version)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::version() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::version() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3982 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = (char *) self->version;
#line 5700 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setVersion); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setVersion)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, version");
    {
	xmlDocPtr	self;
	char *	version = (char *)SvPV_nolen(ST(1))
;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setVersion() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setVersion() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 3992 "LibXML.xs"
        if ( self->version != NULL ) {
            xmlFree( (xmlChar*) self->version );
        }
        self->version = xmlStrdup( (const xmlChar*)version );
#line 5735 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_compression); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_compression)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::compression() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::compression() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4001 "LibXML.xs"
        RETVAL = xmlGetDocCompressMode(self);
#line 5766 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_setCompression); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_setCompression)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, zLevel");
    {
	xmlDocPtr	self;
	int	zLevel = (int)SvIV(ST(1))
;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::setCompression() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::setCompression() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4010 "LibXML.xs"
        xmlSetDocCompressMode(self, zLevel);
#line 5798 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Document_is_valid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_is_valid)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	xmlDocPtr	self;
#line 4017 "LibXML.xs"
        xmlValidCtxt cvp;
        xmlDtdPtr dtd = NULL;
        SV * dtd_sv;
        PREINIT_SAVED_ERROR
#line 5817 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::is_valid() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::is_valid() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4022 "LibXML.xs"
        INIT_ERROR_HANDLER;

        cvp.userData = saved_error;
        cvp.error = (xmlValidityErrorFunc)LibXML_validity_error_ctx;
        cvp.warning = (xmlValidityWarningFunc)LibXML_validity_warning_ctx;

        /* we need to initialize the node stack, because perl might
         * already have messed it up.
         */
        cvp.nodeNr = 0;
        cvp.nodeTab = NULL;
        cvp.vstateNr = 0;
        cvp.vstateTab = NULL;

        PmmClearPSVI(self);
        PmmInvalidatePSVI(self);
        if (items > 1) {
            dtd_sv = ST(1);
            if ( sv_isobject(dtd_sv) && (SvTYPE(SvRV(dtd_sv)) == SVt_PVMG) ) {
                dtd = (xmlDtdPtr)PmmSvNode(dtd_sv);
            }
            RETVAL = xmlValidateDtd(&cvp, self, dtd);
        }
        else {
            RETVAL = xmlValidateDocument(&cvp, self);
        }
        CLEANUP_ERROR_HANDLER;
        /* REPORT_ERROR(1); */
#line 5862 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_validate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_validate)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "self, ...");
    {
	xmlDocPtr	self;
#line 4057 "LibXML.xs"
        xmlValidCtxt cvp;
        xmlDtdPtr dtd;
        SV * dtd_sv;
        PREINIT_SAVED_ERROR
#line 5882 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::validate() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::validate() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4062 "LibXML.xs"
        INIT_ERROR_HANDLER;

        cvp.userData = saved_error;
        cvp.error = (xmlValidityErrorFunc)LibXML_validity_error_ctx;
        cvp.warning = (xmlValidityWarningFunc)LibXML_validity_warning_ctx;
        /* we need to initialize the node stack, because perl might
         * already have messed it up.
         */
        cvp.nodeNr = 0;
        cvp.nodeTab = NULL;
        cvp.vstateNr = 0;
        cvp.vstateTab = NULL;

        PmmClearPSVI(self);
        PmmInvalidatePSVI(self);

        if (items > 1) {
            dtd_sv = ST(1);
            if ( sv_isobject(dtd_sv) && (SvTYPE(SvRV(dtd_sv)) == SVt_PVMG) ) {
                dtd = (xmlDtdPtr)PmmSvNode(dtd_sv);
            }
            else {
                CLEANUP_ERROR_HANDLER;
                croak("is_valid: argument must be a DTD object");
            }
            RETVAL = xmlValidateDtd(&cvp, self , dtd);
        }
        else {
            RETVAL = xmlValidateDocument(&cvp, self);
        }
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(RETVAL ? 1 : 0);
#line 5931 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_cloneNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_cloneNode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, deep=0");
    {
	xmlDocPtr	self;
	int	deep;
#line 4102 "LibXML.xs"
        xmlDocPtr ret = NULL;
#line 5949 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::cloneNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::cloneNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    deep = 0;
	else {
	    deep = (int)SvIV(ST(1))
;
	}
#line 4104 "LibXML.xs"
        ret = xmlCopyDoc( self, deep );
        if ( ret == NULL ) {
            XSRETURN_UNDEF;
        }
        RETVAL = PmmNodeToSv((xmlNodePtr)ret, NULL);
#line 5977 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_getElementById); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_getElementById)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, id");
    {
	xmlDocPtr	self;
	const char *	id = (const char *)SvPV_nolen(ST(1))
;
#line 4119 "LibXML.xs"
        xmlNodePtr elem;
        xmlAttrPtr attr;
#line 5999 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::getElementById() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::getElementById() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4122 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if ( id != NULL ) {
            attr = xmlGetID(self, (xmlChar *) id);
            if (attr == NULL)
                elem = NULL;
            else if (attr->type == XML_ATTRIBUTE_NODE)
                elem = attr->parent;
            else if (attr->type == XML_ELEMENT_NODE)
                elem = (xmlNodePtr) attr;
            else
                elem = NULL;
            if (elem != NULL) {
                RETVAL = PmmNodeToSv(elem, PmmPROXYNODE(self));
            }
            else {
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6036 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Document_indexElements); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Document_indexElements)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDocPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDocPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Document::indexElements() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::Document::indexElements() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4150 "LibXML.xs"
#if LIBXML_VERSION >= 20508
        RETVAL = xmlXPathOrderDocElems( self );
#else
        RETVAL = -2;
#endif
#line 6073 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "node");
    {
	SV *	node = ST(0)
;
#line 4164 "LibXML.xs"
        int count;
        SV *is_shared;
#line 6092 "LibXML.c"
#line 4167 "LibXML.xs"
#ifdef XML_LIBXML_THREADS
    if ( (is_shared = get_sv("XML::LibXML::__threads_shared", 0)) == NULL ) {
        is_shared = &PL_sv_undef;
    }
    if ( SvTRUE(is_shared) ) {
        dSP;
        ENTER;
        SAVETMPS;
        PUSHMARK(SP);
        XPUSHs(node);
        PUTBACK;
        count = call_pv("threads::shared::is_shared", G_SCALAR);
        SPAGAIN;
        if (count != 1)
            croak("Couldn't checks if the variable is shared or not\n");
        is_shared = POPs;
        PUTBACK;
        FREETMPS;
        LEAVE;
        if (is_shared != &PL_sv_undef) {
            XSRETURN_UNDEF;
        }
    }
	if( PmmUSEREGISTRY ) {
	  SvLOCK(PROXY_NODE_REGISTRY_MUTEX);
	  PmmRegistryREFCNT_dec(SvPROXYNODE(node));
        }
#endif
        PmmREFCNT_dec(SvPROXYNODE(node));
#ifdef XML_LIBXML_THREADS
	if( PmmUSEREGISTRY )
	  SvUNLOCK(PROXY_NODE_REGISTRY_MUTEX);
#endif
#line 6127 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_nodeName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nodeName)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4208 "LibXML.xs"
        xmlChar * name = NULL;
#line 6144 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nodeName() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nodeName() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4210 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        name =  (xmlChar*)domName( self );
        if ( name != NULL ) {
            RETVAL = C2Sv(name,NULL);
            xmlFree( name );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6169 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_localname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_localname)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::localname() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::localname() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4230 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if (    self->type == XML_ELEMENT_NODE
             || self->type == XML_ATTRIBUTE_NODE
             || self->type == XML_ELEMENT_DECL
             || self->type == XML_ATTRIBUTE_DECL ) {
            RETVAL = C2Sv(self->name,NULL);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6211 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_prefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_prefix)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::prefix() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::prefix() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4249 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if( ( self->type == XML_ELEMENT_NODE
	    || self->type == XML_ATTRIBUTE_NODE
	    || self->type == XML_PI_NODE )
            && self->ns != NULL
            && self->ns->prefix != NULL ) {
            RETVAL = C2Sv(self->ns->prefix, NULL);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6254 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_namespaceURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_namespaceURI)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4269 "LibXML.xs"
        xmlChar * nsURI;
#line 6273 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::namespaceURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::namespaceURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4271 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if ( ( self->type == XML_ELEMENT_NODE
	    || self->type == XML_ATTRIBUTE_NODE
	    || self->type == XML_PI_NODE )
	     && self->ns != NULL
             && self->ns->href != NULL ) {
            nsURI =  xmlStrdup(self->ns->href);
            RETVAL = C2Sv( nsURI, NULL );
            xmlFree( nsURI );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6302 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_lookupNamespaceURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_lookupNamespaceURI)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, svprefix=&PL_sv_undef");
    {
	xmlNodePtr	self;
	SV *	svprefix;
#line 4293 "LibXML.xs"
        xmlChar * nsURI;
        xmlChar * prefix = NULL;
        xmlNsPtr ns;
#line 6323 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::lookupNamespaceURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::lookupNamespaceURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    svprefix = &PL_sv_undef;
	else {
	    svprefix = ST(1)
;
	}
#line 4297 "LibXML.xs"
        prefix = nodeSv2C( svprefix , self );
        if ( prefix != NULL && xmlStrlen(prefix) == 0) {
            xmlFree( prefix );
            prefix = NULL;
        }
        ns = xmlSearchNs( self->doc, self, prefix );
        if ( prefix != NULL) {
            xmlFree( prefix );
	}
        if ( ns != NULL ) {
	  nsURI = xmlStrdup(ns->href);
	  RETVAL = C2Sv( nsURI, NULL );
	  xmlFree( nsURI );
	}
	else {
	  XSRETURN_UNDEF;
        }
#line 6363 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_lookupNamespacePrefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_lookupNamespacePrefix)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, svuri");
    {
	xmlNodePtr	self;
	SV *	svuri = ST(1)
;
#line 4322 "LibXML.xs"
        xmlChar * nsprefix;
        xmlChar * href = NULL;
#line 6384 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::lookupNamespacePrefix() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::lookupNamespacePrefix() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4325 "LibXML.xs"
        href = nodeSv2C( svuri , self );
        if ( href != NULL && xmlStrlen(href) > 0) {
            xmlNsPtr ns = xmlSearchNsByHref( self->doc, self, href );
            xmlFree( href );
            if ( ns != NULL ) {
		    if ( ns->prefix != NULL ) {
			  nsprefix = xmlStrdup( ns->prefix );
			  RETVAL = C2Sv( nsprefix, NULL );
			  xmlFree(nsprefix);
		    } else {
			  RETVAL = newSVpv("",0);
		    }
            }
            else {
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6420 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_setNodeName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_setNodeName)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	xmlNodePtr	self;
	SV*	value = ST(1)
;
#line 4356 "LibXML.xs"
        xmlChar* string;
        xmlChar* localname;
        xmlChar* prefix;
#line 6443 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::setNodeName() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::setNodeName() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4360 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        string = nodeSv2C( value , self );
        if ( !LibXML_test_node_name( string ) ) {
            xmlFree(string);
            croak( "bad name" );
        }
        if( ( self->type == XML_ELEMENT_NODE
	    || self->type == XML_ATTRIBUTE_NODE
	    || self->type == XML_PI_NODE)
	    && self->ns ){
            localname = xmlSplitQName2(string, &prefix);
	    if ( localname == NULL ) {
	      localname = xmlStrdup( string );
	    }
            xmlNodeSetName(self, localname );
            xmlFree(localname);
            xmlFree(prefix);
        }
        else {
            xs_warn("node name normal\n");
            xmlNodeSetName(self, string );
        }
        xmlFree(string);
#line 6481 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_setRawName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_setRawName)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	xmlNodePtr	self;
	SV *	value = ST(1)
;
#line 4389 "LibXML.xs"
        xmlChar* string;
        xmlChar* localname;
        xmlChar* prefix;
#line 6501 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::setRawName() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::setRawName() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4393 "LibXML.xs"
        string = nodeSv2C( value , self );
        if ( !string || xmlStrlen( string) <= 0 ) {
            xmlFree(string);
            XSRETURN_UNDEF;
        }
        if( ( self->type == XML_ELEMENT_NODE
	     || self->type == XML_ATTRIBUTE_NODE
	     || self->type == XML_PI_NODE)
	    && self->ns ){
            localname = xmlSplitQName2(string, &prefix);
            xmlNodeSetName(self, localname );
            xmlFree(localname);
            xmlFree(prefix);
        }
        else {
            xmlNodeSetName(self, string );
        }
        xmlFree(string);
#line 6534 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_nodeValue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nodeValue)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, useDomEncoding = &PL_sv_undef");
    {
	xmlNodePtr	self;
	SV *	useDomEncoding;
#line 4424 "LibXML.xs"
        xmlChar * content = NULL;
#line 6552 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nodeValue() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nodeValue() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    useDomEncoding = &PL_sv_undef;
	else {
	    useDomEncoding = ST(1)
;
	}
#line 4426 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        content = domGetNodeValue( self );

        if ( content != NULL ) {
            if ( SvTRUE(useDomEncoding) ) {
                RETVAL = nodeC2Sv(content, self);
            }
            else {
                RETVAL = C2Sv(content, NULL);
            }
            xmlFree(content);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 6590 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_nodeType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nodeType)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nodeType() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nodeType() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4450 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = self->type;
#line 6625 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_parentNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_parentNode)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::parentNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::parentNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4463 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv( self->parent,
                              PmmOWNERPO( PmmPROXYNODE(self) ) );
#line 6659 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_nextSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nextSibling)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nextSibling() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nextSibling() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4475 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv( self->next,
                              PmmOWNERPO(PmmPROXYNODE(self)) );
#line 6694 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_nextNonBlankSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nextNonBlankSibling)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4485 "LibXML.xs"
        xmlNodePtr next;
#line 6712 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nextNonBlankSibling() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nextNonBlankSibling() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4487 "LibXML.xs"
        next = self->next;
        while (next != NULL && xmlIsBlankNode(next))
          next = next->next;
        RETVAL = PmmNodeToSv( next,
                              PmmOWNERPO(PmmPROXYNODE(self)) );
#line 6733 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_previousSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_previousSibling)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::previousSibling() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::previousSibling() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4502 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv( self->prev,
                              PmmOWNERPO( PmmPROXYNODE(self) ) );
#line 6768 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_previousNonBlankSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_previousNonBlankSibling)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4512 "LibXML.xs"
        xmlNodePtr prev;
#line 6786 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::previousNonBlankSibling() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::previousNonBlankSibling() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4514 "LibXML.xs"
        prev = self->prev;
        while (prev != NULL && xmlIsBlankNode(prev))
          prev = prev->prev;
        RETVAL = PmmNodeToSv( prev,
                              PmmOWNERPO(PmmPROXYNODE(self)) );
#line 6807 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node__childNodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__childNodes)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, only_nonblank = 0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	xmlNodePtr	self;
	int	only_nonblank;
#line 4530 "LibXML.xs"
        xmlNodePtr cld;
        SV * element;
        int len = 0;
        int wantarray = GIMME_V;
#line 6832 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::_childNodes() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::_childNodes() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    only_nonblank = 0;
	else {
	    only_nonblank = (int)SvIV(ST(1))
;
	}
#line 4535 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if ( self->type != XML_ATTRIBUTE_NODE ) {
            cld = self->children;
            xs_warn("childnodes start");
            while ( cld ) {
	        if ( !(only_nonblank && xmlIsBlankNode(cld)) ) {
                  if( wantarray != G_SCALAR ) {
                      element = PmmNodeToSv(cld, PmmOWNERPO(PmmPROXYNODE(self)) );
                      XPUSHs(sv_2mortal(element));
                  }
                  len++;
                }
                cld = cld->next;
            }
        }
        if ( wantarray == G_SCALAR ) {
            XPUSHs(sv_2mortal(newSViv(len)) );
        }
#line 6872 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node__getChildrenByTagNameNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__getChildrenByTagNameNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, namespaceURI, node_name");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	node_name = ST(2)
;
#line 4560 "LibXML.xs"
        xmlChar * name;
        xmlChar * nsURI;
        xmlNodePtr cld;
        SV * element;
        int len = 0;
	int name_wildcard = 0;
	int ns_wildcard = 0;
        int wantarray = GIMME_V;
#line 6902 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::_getChildrenByTagNameNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::_getChildrenByTagNameNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4569 "LibXML.xs"
        name = nodeSv2C(node_name, self );
        nsURI = nodeSv2C(namespaceURI, self );

        if ( nsURI != NULL ) {
            if (xmlStrlen(nsURI) == 0 ) {
                xmlFree(nsURI);
                nsURI = NULL;
            } else if (xmlStrcmp( nsURI, (xmlChar *)"*" )==0) {
                ns_wildcard = 1;
            }
        }
        if ( name !=NULL && xmlStrcmp( name, (xmlChar *)"*" ) == 0) {
            name_wildcard = 1;
        }
        if ( self->type != XML_ATTRIBUTE_NODE ) {
            cld = self->children;
            xs_warn("childnodes start");
            while ( cld ) {
	      if (((name_wildcard && (cld->type == XML_ELEMENT_NODE)) ||
		   xmlStrcmp( name, cld->name ) == 0)
		   && (ns_wildcard ||
		       (cld->ns != NULL &&
                        xmlStrcmp(nsURI,cld->ns->href) == 0 ) ||
                       (cld->ns == NULL && nsURI == NULL))) {
                if( wantarray != G_SCALAR ) {
                    element = PmmNodeToSv(cld, PmmOWNERPO(PmmPROXYNODE(self)) );
                    XPUSHs(sv_2mortal(element));
                }
                len++;
	      }
	      cld = cld->next;
            }
        }
        if ( wantarray == G_SCALAR ) {
            XPUSHs(sv_2mortal(newSViv(len)) );
        }
        xmlFree(name);
        if (nsURI) xmlFree(nsURI);
#line 6955 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node_firstChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_firstChild)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::firstChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::firstChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4614 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv( self->children,
                              PmmOWNERPO( PmmPROXYNODE(self) ) );
#line 6989 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_firstNonBlankChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_firstNonBlankChild)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4624 "LibXML.xs"
	xmlNodePtr child;
#line 7007 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::firstNonBlankChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::firstNonBlankChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4626 "LibXML.xs"
	child = self->children;
        while (child !=NULL && xmlIsBlankNode(child))
	  child = child->next;
        RETVAL = PmmNodeToSv( child,
                              PmmOWNERPO( PmmPROXYNODE(self) ) );
#line 7028 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_lastChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_lastChild)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::lastChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::lastChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4640 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv( self->last,
                              PmmOWNERPO( PmmPROXYNODE(self) ) );
#line 7063 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node__attributes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__attributes)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	xmlNodePtr	self;
#line 4652 "LibXML.xs"
        xmlAttrPtr attr = NULL;
        xmlNsPtr ns = NULL;
        SV * element;
        int len=0;
        int wantarray = GIMME_V;
#line 7088 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::_attributes() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::_attributes() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4658 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if ( self->type != XML_ATTRIBUTE_NODE
             && self->type != XML_DTD_NODE ) {
            attr = self->properties;
            while ( attr != NULL ) {
                if ( wantarray != G_SCALAR ) {
                    element = PmmNodeToSv((xmlNodePtr)attr,
                                           PmmOWNERPO(PmmPROXYNODE(self)) );
                    XPUSHs(sv_2mortal(element));
                }
                attr = attr->next;
                len++;
            }
	    if (self->type == XML_ELEMENT_NODE) {
	      ns = self->nsDef;
	      while ( ns != NULL ) {
                const char * CLASS = "XML::LibXML::Namespace";
                if ( wantarray != G_SCALAR ) {
                    /* namespace handling is kinda odd:
                     * as soon we have a namespace isolated from its
                     * owner, we loose the context. therefore it is
                     * forbidden to access the NS information directly.
                     * instead the use will receive a copy of the real
                     * namespace, that can be destroied and is not
                     * bound to a document.
                     *
                     * this avoids segfaults in the end.
                     */
			  if ((ns->prefix != NULL || ns->href != NULL)) {
				xmlNsPtr tns = xmlCopyNamespace(ns);
				if ( tns != NULL ) {
				    element = sv_newmortal();
				    XPUSHs(sv_setref_pv( element,
								 (char *)CLASS,
								 (void*)tns));
				}
			  }
                }
                ns = ns->next;
                len++;
	      }
	    }
        }
        if( wantarray == G_SCALAR ) {
            XPUSHs( sv_2mortal(newSViv(len)) );
        }
#line 7149 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node_hasChildNodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_hasChildNodes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::hasChildNodes() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::hasChildNodes() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4709 "LibXML.xs"
        if ( self->type == XML_ATTRIBUTE_NODE ) {
            RETVAL = 0;
        }
        else {
            RETVAL =  self->children ? 1 : 0 ;
        }
#line 7186 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_hasAttributes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_hasAttributes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::hasAttributes() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::hasAttributes() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4722 "LibXML.xs"
        if ( self->type == XML_ATTRIBUTE_NODE
             || self->type == XML_DTD_NODE ) {
            RETVAL = 0;
        }
        else {
            RETVAL =  self->properties ? 1 : 0 ;
        }
#line 7224 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_ownerDocument); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_ownerDocument)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::ownerDocument() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::ownerDocument() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4738 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        xs_warn( "GET OWNERDOC\n" );
        if( self != NULL
            && self->doc != NULL ){
            RETVAL = PmmNodeToSv((xmlNodePtr)(self->doc), NULL);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 7264 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_ownerNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_ownerNode)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::ownerNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::ownerNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4757 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = PmmNodeToSv(PmmNODE(PmmOWNERPO(PmmPROXYNODE(self))), NULL);
#line 7298 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_normalize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_normalize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::normalize() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::normalize() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4767 "LibXML.xs"
        domNodeNormalize( self );
#line 7329 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_insertBefore); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_insertBefore)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nNode, refNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
	SV *	refNode = ST(2)
;
#line 4776 "LibXML.xs"
        xmlNodePtr oNode=NULL, rNode;
#line 7348 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::insertBefore() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::insertBefore() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::insertBefore() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::insertBefore() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4778 "LibXML.xs"
        oNode = PmmSvNode(refNode);
#line 7378 "LibXML.c"
#line 4780 "LibXML.xs"
        rNode = domInsertBefore( self, nNode, oNode );
        if ( rNode != NULL ) {
            RETVAL = PmmNodeToSv( rNode,
                                  PmmOWNERPO(PmmPROXYNODE(self)) );
            if (rNode->type == XML_DTD_NODE) {
                LibXML_set_int_subset(self->doc, rNode);
            }
            PmmFixOwner(PmmPROXYNODE(rNode), PmmOWNERPO(PmmPROXYNODE(self)));
        }
        else {
            XSRETURN_UNDEF;
        }
#line 7392 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_insertAfter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_insertAfter)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nNode, refNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
	SV*	refNode = ST(2)
;
#line 4801 "LibXML.xs"
        xmlNodePtr oNode = NULL, rNode;
#line 7413 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::insertAfter() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::insertAfter() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::insertAfter() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::insertAfter() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4803 "LibXML.xs"
        oNode = PmmSvNode(refNode);
#line 7443 "LibXML.c"
#line 4805 "LibXML.xs"
        rNode = domInsertAfter( self, nNode, oNode );
        if ( rNode != NULL ) {
            RETVAL = PmmNodeToSv( rNode,
                                  PmmOWNERPO(PmmPROXYNODE(self)) );
            if (rNode->type == XML_DTD_NODE) {
                LibXML_set_int_subset(self->doc, rNode);
            }
            PmmFixOwner(PmmPROXYNODE(rNode), PmmOWNERPO(PmmPROXYNODE(self)));
        }
        else {
            XSRETURN_UNDEF;
        }
#line 7457 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_replaceChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_replaceChild)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, nNode, oNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
	xmlNodePtr	oNode;
#line 4826 "LibXML.xs"
        xmlNodePtr ret = NULL;
#line 7477 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::replaceChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::replaceChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::replaceChild() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::replaceChild() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(2)) && (SvTYPE(SvRV(ST(2))) == SVt_PVMG) ) {
            oNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(2)));
            if ( oNode == NULL ) {
               croak( "XML::LibXML::Node::replaceChild() -- oNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::replaceChild() -- oNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4828 "LibXML.xs"
       if ( self->type == XML_DOCUMENT_NODE ) {
                switch ( nNode->type ) {
                case XML_ELEMENT_NODE:
                    warn("replaceChild with an element on a document node not supported yet!");
                    XSRETURN_UNDEF;
                    break;
                case XML_DOCUMENT_FRAG_NODE:
                    warn("replaceChild with a document fragment node on a document node not supported yet!");
                    XSRETURN_UNDEF;
                    break;
                case XML_TEXT_NODE:
                case XML_CDATA_SECTION_NODE:
                    warn("replaceChild with a text node not supported on a document node!");
                    XSRETURN_UNDEF;
                    break;
                default:
                    break;
                }
        }
        ret = domReplaceChild( self, nNode, oNode );
        if (ret == NULL) {
            XSRETURN_UNDEF;
        }
        else {
            LibXML_reparent_removed_node(ret);
            RETVAL = PmmNodeToSv(ret, PmmOWNERPO(PmmPROXYNODE(ret)));
            if (nNode->type == XML_DTD_NODE) {
                LibXML_set_int_subset(nNode->doc, nNode);
            }
            if ( nNode->_private != NULL ) {
                PmmFixOwner( PmmPROXYNODE(nNode),
                             PmmOWNERPO(PmmPROXYNODE(self)) );
            }
        }
#line 7553 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_replaceNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_replaceNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, nNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
#line 4870 "LibXML.xs"
        xmlNodePtr ret = NULL;
        ProxyNodePtr owner = NULL;
#line 7573 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::replaceNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::replaceNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::replaceNode() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::replaceNode() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4873 "LibXML.xs"
        if ( domIsParent( self, nNode ) == 1 ) {
            XSRETURN_UNDEF;
        }
        owner = PmmOWNERPO(PmmPROXYNODE(self));

        if ( self->type != XML_ATTRIBUTE_NODE ) {
              ret = domReplaceChild( self->parent, nNode, self);
        }
        else {
             ret = xmlReplaceNode( self, nNode );
        }
        if ( ret ) {
            LibXML_reparent_removed_node(ret);
            RETVAL = PmmNodeToSv(ret, PmmOWNERPO(PmmPROXYNODE(ret)));
            if (nNode->type == XML_DTD_NODE) {
                LibXML_set_int_subset(nNode->doc, nNode);
            }
            if ( nNode->_private != NULL ) {
                PmmFixOwner(PmmPROXYNODE(nNode), owner);
            }
        }
        else {
            croak( "replacement failed" );
            XSRETURN_UNDEF;
        }
#line 7627 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_removeChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_removeChild)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, node");
    {
	xmlNodePtr	self;
	xmlNodePtr	node;
#line 4906 "LibXML.xs"
        xmlNodePtr ret;
#line 7646 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::removeChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::removeChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Node::removeChild() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::removeChild() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4908 "LibXML.xs"
        ret = domRemoveChild( self, node );
        if (ret == NULL) {
            XSRETURN_UNDEF;
        }
        else {
            LibXML_reparent_removed_node(ret);
            RETVAL = PmmNodeToSv(ret, NULL);
        }
#line 7683 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_removeChildNodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_removeChildNodes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4923 "LibXML.xs"
        xmlNodePtr elem, fragment;
        ProxyNodePtr docfrag;
#line 7702 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::removeChildNodes() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::removeChildNodes() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4926 "LibXML.xs"
        docfrag  = PmmNewFragment( self->doc );
        fragment = PmmNODE( docfrag );
        elem = self->children;
        while ( elem ) {
            xmlNodePtr next = elem->next;
            xmlUnlinkNode( elem );
            if (elem->type == XML_ATTRIBUTE_NODE
                || elem->type == XML_DTD_NODE) {
                if (PmmPROXYNODE(elem) == NULL) {
                    xmlFreeNode(elem);
                }
            }
            else {
                /* this following piece is the function of domAppendChild()
                 * but in this special case we can avoid most of the logic of
                 * that function.
                 */
                if ( fragment->children != NULL ) {
                    xs_warn("unlink node!\n");
                    domAddNodeToList( elem, fragment->last, NULL );
                }
                else {
                    fragment->children = elem;
                    fragment->last     = elem;
                    elem->parent= fragment;
                }
                PmmFixOwnerNode( elem, docfrag );
            }
            elem = next;
        }

        self->children = self->last = NULL;
        if ( PmmREFCNT(docfrag) <= 0 ) {
            xs_warn( "have not references left" );
            PmmREFCNT_inc( docfrag );
            PmmREFCNT_dec( docfrag );
        }
#line 7754 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_unbindNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_unbindNode)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 4971 "LibXML.xs"
        ProxyNodePtr docfrag     = NULL;
#line 7771 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::unbindNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::unbindNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4973 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        if ( self->type != XML_DOCUMENT_NODE
             && self->type != XML_DOCUMENT_FRAG_NODE ) {
            xmlUnlinkNode( self );
            LibXML_reparent_removed_node(self);
        }
#line 7792 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_appendChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_appendChild)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, nNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
#line 4985 "LibXML.xs"
        xmlNodePtr rNode;
#line 7809 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::appendChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::appendChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::appendChild() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::appendChild() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 4987 "LibXML.xs"
        if (self->type == XML_DOCUMENT_NODE ) {
            /* NOT_SUPPORTED_ERR
             */
            switch ( nNode->type ) {
            case XML_ELEMENT_NODE:
                warn("Appending an element to a document node not supported yet!");
                XSRETURN_UNDEF;
                break;
            case XML_DOCUMENT_FRAG_NODE:
                warn("Appending a document fragment node to a document node not supported yet!");
                XSRETURN_UNDEF;
                break;
            case XML_TEXT_NODE:
            case XML_CDATA_SECTION_NODE:
                warn("Appending text node not supported on a document node yet!");
                XSRETURN_UNDEF;
                break;
            default:
                break;
            }
        }

        rNode = domAppendChild( self, nNode );

        if ( rNode == NULL ) {
            XSRETURN_UNDEF;
        }

        RETVAL = PmmNodeToSv( nNode,
                              PmmOWNERPO(PmmPROXYNODE(self)) );
        if (nNode->type == XML_DTD_NODE) {
            LibXML_set_int_subset(self->doc, nNode);
        }
        PmmFixOwner( SvPROXYNODE(RETVAL), PmmPROXYNODE(self) );
#line 7872 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_addChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_addChild)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, nNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
#line 5029 "LibXML.xs"
        xmlNodePtr retval = NULL;
        ProxyNodePtr proxy;
#line 7892 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::addChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::addChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::addChild() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::addChild() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5032 "LibXML.xs"
        switch ( nNode->type ) {
        case XML_DOCUMENT_FRAG_NODE:
            croak("Adding document fragments with addChild not supported!");
            XSRETURN_UNDEF;
        case XML_DOCUMENT_NODE :
        case XML_HTML_DOCUMENT_NODE :
        case XML_DOCB_DOCUMENT_NODE :
            croak("addChild: HIERARCHY_REQUEST_ERR\n");
            XSRETURN_UNDEF;
        case XML_NOTATION_NODE :
        case XML_NAMESPACE_DECL :
        case XML_DTD_NODE :
        case XML_DOCUMENT_TYPE_NODE :
        case XML_ENTITY_DECL :
        case XML_ELEMENT_DECL :
        case XML_ATTRIBUTE_DECL :
            croak("addChild: unsupported node type!");
            XSRETURN_UNDEF;
	default:
	  break;
        }

        xmlUnlinkNode(nNode);
        proxy = PmmPROXYNODE(nNode);
        retval = xmlAddChild( self, nNode );

        if ( retval == NULL ) {
            croak( "Error: addChild failed (check node types)!\n" );
        }

        if ( retval != nNode ) {
            xs_warn( "node was lost during operation\n" );
            PmmNODE(proxy) = NULL;
        }

        RETVAL = PmmNodeToSv( retval,
                              PmmOWNERPO(PmmPROXYNODE(self)) );
        if ( retval != self ) {
            PmmFixOwner( SvPROXYNODE(RETVAL), PmmPROXYNODE(self) );
        }
#line 7961 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_addSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_addSibling)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, nNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	nNode;
#line 5081 "LibXML.xs"
        xmlNodePtr ret = NULL;
        ProxyNodePtr owner = NULL;
#line 7981 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::addSibling() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::addSibling() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            nNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( nNode == NULL ) {
               croak( "XML::LibXML::Node::addSibling() -- nNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::addSibling() -- nNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5084 "LibXML.xs"
        if ( nNode->type == XML_DOCUMENT_FRAG_NODE ) {
            croak("Adding document fragments with addSibling not yet supported!");
            XSRETURN_UNDEF;
        }
        owner = PmmOWNERPO(PmmPROXYNODE(self));

        if (self->type == XML_TEXT_NODE && nNode->type == XML_TEXT_NODE
            && self->name == nNode->name) {
            /* As a result of text merging, the added node may be freed. */
            xmlNodePtr copy = xmlCopyNode(nNode, 0);
            ret = xmlAddSibling(self, copy);

            if (ret) {
                RETVAL = PmmNodeToSv(ret, owner);
                /* Unlink original node. */
                xmlUnlinkNode(nNode);
                LibXML_reparent_removed_node(nNode);
            }
            else {
                xmlFreeNode(copy);
                XSRETURN_UNDEF;
            }
        }
        else {
            ret = xmlAddSibling( self, nNode );

            if ( ret ) {
                RETVAL = PmmNodeToSv(ret, owner);
                if (nNode->type == XML_DTD_NODE) {
                    LibXML_set_int_subset(self->doc, nNode);
                }
                PmmFixOwner(SvPROXYNODE(RETVAL), owner);
            }
            else {
                XSRETURN_UNDEF;
            }
        }
#line 8047 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_cloneNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_cloneNode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, deep=0");
    {
	xmlNodePtr	self;
	int	deep;
#line 5129 "LibXML.xs"
        xmlNodePtr ret;
        xmlDocPtr doc = NULL;
        ProxyNodePtr docfrag = NULL;
#line 8068 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::cloneNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::cloneNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    deep = 0;
	else {
	    deep = (int)SvIV(ST(1))
;
	}
#line 5133 "LibXML.xs"
        ret = PmmCloneNode( self, deep );
        if ( ret == NULL ) {
            XSRETURN_UNDEF;
        }

        if ( ret->type  == XML_DTD_NODE ) {
            RETVAL = PmmNodeToSv(ret, NULL);
        }
        else {
            doc = self->doc;

            if ( doc != NULL ) {
                xmlSetTreeDoc(ret, doc); /* setting to self, no need to clear psvi */
            }

            docfrag = PmmNewFragment( doc );
            xmlAddChild( PmmNODE(docfrag), ret );
            RETVAL = PmmNodeToSv(ret, docfrag);
        }
#line 8110 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_isSameNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_isSameNode)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, oNode");
    {
	xmlNodePtr	self;
	xmlNodePtr	oNode;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::isSameNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::isSameNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            oNode = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( oNode == NULL ) {
               croak( "XML::LibXML::Node::isSameNode() -- oNode contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::isSameNode() -- oNode is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5162 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = ( self == oNode ) ? 1 : 0;
#line 8159 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_unique_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_unique_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	IV	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::unique_key() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::unique_key() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5171 "LibXML.xs"
        /* Cast pointer to IV */
        RETVAL = PTR2IV(self);
#line 8192 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_baseURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_baseURI)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 5180 "LibXML.xs"
        xmlChar * uri;
#line 8209 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::baseURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::baseURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5182 "LibXML.xs"
        uri = xmlNodeGetBase( self->doc, self );
        RETVAL = C2Sv( uri, NULL );
        xmlFree( uri );
#line 8228 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_setBaseURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_setBaseURI)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, URI");
    {
	xmlNodePtr	self;
	SV *	URI = ST(1)
;
#line 5193 "LibXML.xs"
        xmlChar * uri;
#line 8248 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::setBaseURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::setBaseURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5195 "LibXML.xs"
        uri = nodeSv2C( URI, self );
        if ( uri != NULL ) {
            xmlNodeSetBase( self, uri );
        }
#line 8267 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Node_toString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_toString)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, format=0, useDomEncoding = &PL_sv_undef");
    {
	xmlNodePtr	self;
	SV *	useDomEncoding;
	int	format;
#line 5208 "LibXML.xs"
        xmlBufferPtr buffer;
        const xmlChar *ret = NULL;
        SV* internalFlag = NULL;
        int oldTagFlag = xmlSaveNoEmptyTags;
#line 8289 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::toString() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::toString() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    useDomEncoding = &PL_sv_undef;
	else {
	    useDomEncoding = ST(2)
;
	}

	if (items < 2)
	    format = 0;
	else {
	    format = (int)SvIV(ST(1))
;
	}
#line 5213 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        internalFlag = get_sv("XML::LibXML::setTagCompression", 0);

        if ( internalFlag ) {
            xmlSaveNoEmptyTags = SvTRUE(internalFlag);
        }
        buffer = xmlBufferCreate();

        if ( format <= 0 ) {
            xmlNodeDump( buffer,
                         self->doc,
                         self, 0, format);
        }
        else {
            int t_indent_var = xmlIndentTreeOutput;
            xmlIndentTreeOutput = 1;
            xmlNodeDump( buffer,
                         self->doc,
                         self, 0, format);
            xmlIndentTreeOutput = t_indent_var;
        }

        ret = xmlBufferContent( buffer );

        xmlSaveNoEmptyTags = oldTagFlag;

        if ( ret != NULL ) {
            if ( useDomEncoding != &PL_sv_undef && SvTRUE(useDomEncoding) ) {
                RETVAL = nodeC2Sv((xmlChar*)ret, PmmNODE(PmmPROXYNODE(self))) ;
                SvUTF8_off(RETVAL);
            }
            else {
                RETVAL = C2Sv((xmlChar*)ret, NULL) ;
            }
            xmlBufferFree( buffer );
        }
        else {
            xmlBufferFree( buffer );
            xs_warn("Failed to convert node to string");
            XSRETURN_UNDEF;
        }
#line 8360 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node__toStringC14N); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__toStringC14N)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 6)
       croak_xs_usage(cv,  "self, comments=0, xpath=&PL_sv_undef, exclusive=0, inc_prefix_list=NULL, xpath_context");
    {
	xmlNodePtr	self;
	int	comments;
	SV *	xpath;
	int	exclusive;
	char**	inc_prefix_list;
	SV *	xpath_context = ST(5)
;
#line 5268 "LibXML.xs"
        xmlChar *result               = NULL;
        xmlChar *nodepath             = NULL;
        xmlXPathContextPtr child_ctxt = NULL;
        xmlXPathObjectPtr xpath_res = NULL;
        xmlNodeSetPtr nodelist        = NULL;
        xmlNodePtr refNode            = NULL;
        PREINIT_SAVED_ERROR
#line 8390 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::_toStringC14N() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::_toStringC14N() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    comments = 0;
	else {
	    comments = (int)SvIV(ST(1))
;
	}

	if (items < 3)
	    xpath = &PL_sv_undef;
	else {
	    xpath = ST(2)
;
	}

	if (items < 4)
	    exclusive = 0;
	else {
	    exclusive = (int)SvIV(ST(3))
;
	}

	if (items < 5)
	    inc_prefix_list = NULL;
	else {
	    inc_prefix_list = XS_unpack_charPtrPtr(ST(4))
;
	}
#line 5276 "LibXML.xs"
        /* due to how c14n is implemented, the nodeset it receives must
          include child nodes; ie, child nodes aren't assumed to be rendered.
          so we use an xpath expression to find all of the child nodes. */

        if ( self->doc == NULL ) {
            croak("Node passed to toStringC14N must be part of a document");
        }

        refNode = self;
#line 8443 "LibXML.c"
#line 5286 "LibXML.xs"
        if ( xpath != NULL && xpath != &PL_sv_undef ) {
            nodepath = Sv2C( xpath, NULL );
        }

        if ( nodepath != NULL && xmlStrlen( nodepath ) == 0 ) {
            xmlFree( nodepath );
            nodepath = NULL;
        }

        if ( nodepath == NULL
             && self->type != XML_DOCUMENT_NODE
             && self->type != XML_HTML_DOCUMENT_NODE
             && self->type != XML_DOCB_DOCUMENT_NODE
           ) {
            if (comments)
	      nodepath = xmlStrdup( (const xmlChar *) "(. | .//node() | .//@* | .//namespace::*)" );
            else
              nodepath = xmlStrdup( (const xmlChar *) "(. | .//node() | .//@* | .//namespace::*)[not(self::comment())]" );
        }

        if ( nodepath != NULL ) {
            if ( self->type == XML_DOCUMENT_NODE
                 || self->type == XML_HTML_DOCUMENT_NODE
                 || self->type == XML_DOCB_DOCUMENT_NODE ) {
                refNode = xmlDocGetRootElement( self->doc );
            }
	    if (SvOK(xpath_context)) {
	      child_ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(xpath_context)));
	      if ( child_ctxt == NULL ) {
		croak("XPathContext: missing xpath context\n");
	      }
	    } else {
	      xpath_context = NULL;
	      child_ctxt = xmlXPathNewContext(self->doc);
	    }
            if (!child_ctxt) {
                if ( nodepath != NULL ) {
                    xmlFree( nodepath );
                }
                croak("Failed to create xpath context");
            }

            child_ctxt->node = self;
	    LibXML_configure_namespaces(child_ctxt);

            xpath_res = xmlXPathEval(nodepath, child_ctxt);
	    if (child_ctxt->namespaces != NULL) {
	      xmlFree( child_ctxt->namespaces );
	      child_ctxt->namespaces = NULL;
	    }
	    if (!xpath_context) xmlXPathFreeContext(child_ctxt);
	    if ( nodepath != NULL ) {
	      xmlFree( nodepath );
	    }

            if (xpath_res == NULL) {
                croak("2 Failed to compile xpath expression");
            }

            nodelist = xpath_res->nodesetval;
            if ( nodelist == NULL ) {
                xmlXPathFreeObject(xpath_res);
                croak( "cannot canonize empty nodeset!" );
            }
        }

        INIT_ERROR_HANDLER;

        xmlC14NDocDumpMemory( self->doc,
                              nodelist,
                              exclusive, (xmlChar **) inc_prefix_list,
                              comments,
                              &result );

        if ( xpath_res ) xmlXPathFreeObject(xpath_res);
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);

        if (result == NULL) {
             croak("Failed to convert doc to string in doc->toStringC14N");
        } else {
            RETVAL = C2Sv( result, NULL );
            xmlFree(result);
        }
#line 8529 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_string_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_string_value)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, useDomEncoding = &PL_sv_undef");
    {
	xmlNodePtr	self;
	SV *	useDomEncoding;
#line 5381 "LibXML.xs"
         xmlChar * string = NULL;
#line 8549 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::string_value() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::string_value() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    useDomEncoding = &PL_sv_undef;
	else {
	    useDomEncoding = ST(1)
;
	}
#line 5383 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        /* we can't just return a string, because of UTF8! */
        string = xmlXPathCastNodeToString(self);
        if ( SvTRUE(useDomEncoding) ) {
            RETVAL = nodeC2Sv(string,
                              self);
        }
        else {
            RETVAL = C2Sv(string,
                          NULL);
        }
        xmlFree(string);
#line 8584 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_to_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_to_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	double	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::to_number() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::to_number() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5402 "LibXML.xs"
        RETVAL = xmlXPathCastNodeToNumber(self);
#line 8617 "LibXML.c"
	XSprePUSH; PUSHn((double)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node__find); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__find)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pnode, pxpath, to_bool");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	pnode = ST(0)
;
	SV *	pxpath = ST(1)
;
	int	to_bool = (int)SvIV(ST(2))
;
#line 5413 "LibXML.xs"
        xmlNodePtr node = PmmSvNode(pnode);
        ProxyNodePtr owner = NULL;
        xmlXPathObjectPtr found = NULL;
        xmlNodeSetPtr nodelist = NULL;
        xmlChar * xpath = NULL;
        xmlXPathCompExprPtr comp = NULL;
        PREINIT_SAVED_ERROR
#line 8647 "LibXML.c"
#line 5421 "LibXML.xs"
        if ( node == NULL ) {
            croak( "lost node" );
        }
        if (sv_isobject(pxpath) && sv_isa(pxpath,"XML::LibXML::XPathExpression")) {
             comp = INT2PTR(xmlXPathCompExprPtr,SvIV((SV*)SvRV( pxpath )));
             if (!comp) XSRETURN_UNDEF;
        } else {
            xpath = nodeSv2C(pxpath, node);
            if ( !(xpath && xmlStrlen(xpath)) ) {
                xs_warn( "bad xpath\n" );
                if ( xpath )
                    xmlFree(xpath);
                croak( "empty XPath found" );
                XSRETURN_UNDEF;
            }
        }
#line 8665 "LibXML.c"
#line 5438 "LibXML.xs"
        INIT_ERROR_HANDLER;
        if (comp) {
          found = domXPathCompFind( node, comp, to_bool );
        } else {
          found = domXPathFind( node, xpath, to_bool );
          xmlFree( xpath );
        }
        CLEANUP_ERROR_HANDLER;
        if (found) {
	    REPORT_ERROR(1);
            switch (found->type) {
                case XPATH_NODESET:
                    /* return as a NodeList */
                    /* access ->nodesetval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::NodeList", 0)));
                    nodelist = found->nodesetval;
                    if ( nodelist ) {
                        if ( nodelist->nodeNr > 0 ) {
                            int i;
                            const char * cls = "XML::LibXML::Node";
                            xmlNodePtr tnode;
                            SV * element;
                            int l = nodelist->nodeNr;

                            owner = PmmOWNERPO(SvPROXYNODE(pnode));
                            for( i=0 ; i < l; i++){
                                /* we have to create a new instance of an
                                 * objectptr. and then
                                 * place the current node into the new
                                 * object. afterwards we can
                                 * push the object to the array!
                                 */
                                tnode = nodelist->nodeTab[i];

                                /* let's be paranoid */
                                if (tnode->type == XML_NAMESPACE_DECL) {
                                     xmlNsPtr newns = xmlCopyNamespace((xmlNsPtr)tnode);
                                    if ( newns != NULL ) {
                                        element = NEWSV(0,0);
                                        cls = PmmNodeTypeName( tnode );
                                        element = sv_setref_pv( element,
                                                                (const char *)cls,
                                                                (void*)newns
                                                          );
                                    }
                                    else {
                                        continue;
                                    }
                                }
                                else {
                                    element = PmmNodeToSv(tnode, owner);
                                }

                                XPUSHs( sv_2mortal(element) );
                            }
                        }
                        xmlXPathFreeNodeSet( found->nodesetval );
                        found->nodesetval = NULL;
                    }
                    break;
                case XPATH_BOOLEAN:
                    /* return as a Boolean */
                    /* access ->boolval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Boolean", 0)));
                    XPUSHs(sv_2mortal(newSViv(found->boolval)));
                    break;
                case XPATH_NUMBER:
                    /* return as a Number */
                    /* access ->floatval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Number", 0)));
                    XPUSHs(sv_2mortal(newSVnv(found->floatval)));
                    break;
                case XPATH_STRING:
                    /* access ->stringval */
                    /* return as a Literal */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Literal", 0)));
                    XPUSHs(sv_2mortal(C2Sv(found->stringval, NULL)));
                    break;
                default:
                    croak("Unknown XPath return type");
            }
            xmlXPathFreeObject(found);
        } else {
	  REPORT_ERROR(0);
	}
#line 8752 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node__findnodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node__findnodes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pnode, perl_xpath");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	pnode = ST(0)
;
	SV *	perl_xpath = ST(1)
;
#line 5529 "LibXML.xs"
        xmlNodePtr node = PmmSvNode(pnode);
        ProxyNodePtr owner = NULL;
        xmlNodeSetPtr nodelist = NULL;
        SV * element = NULL ;
        xmlChar * xpath = NULL ;
        xmlXPathCompExprPtr comp = NULL;
        PREINIT_SAVED_ERROR
#line 8780 "LibXML.c"
#line 5537 "LibXML.xs"
        if ( node == NULL ) {
	  if ( xpath )
	    xmlFree(xpath);
	  croak( "lost node" );
        }
        if (sv_isobject(perl_xpath) && sv_isa(perl_xpath,"XML::LibXML::XPathExpression")) {
             comp = INT2PTR(xmlXPathCompExprPtr,SvIV((SV*)SvRV( perl_xpath )));
             if (!comp) XSRETURN_UNDEF;
        } else {
            xpath = nodeSv2C(perl_xpath, node);
            if ( !(xpath && xmlStrlen(xpath)) ) {
                xs_warn( "bad xpath\n" );
                if ( xpath )
                    xmlFree(xpath);
                croak( "empty XPath found" );
                XSRETURN_UNDEF;
            }
        }
#line 8800 "LibXML.c"
#line 5556 "LibXML.xs"
        INIT_ERROR_HANDLER;
        if (comp) {
	    nodelist = domXPathCompSelect( node, comp );
        } else {
	    nodelist = domXPathSelect( node, xpath );
            xmlFree(xpath);
        }
        CLEANUP_ERROR_HANDLER;

        if ( nodelist ) {
	    REPORT_ERROR(1);
            if ( nodelist->nodeNr > 0 ) {
                int i;
                int len = nodelist->nodeNr;
                const char * cls = "XML::LibXML::Node";
                xmlNodePtr tnode;
                owner = PmmOWNERPO(SvPROXYNODE(pnode));

                for(i=0 ; i < len; i++){
                    /* we have to create a new instance of an objectptr.
                     * and then place the current node into the new object.
                     * afterwards we can push the object to the array!
                     */
                    element = NULL;
                    tnode = nodelist->nodeTab[i];
                    if (tnode->type == XML_NAMESPACE_DECL) {
                        xmlNsPtr newns = xmlCopyNamespace((xmlNsPtr)tnode);
                        if ( newns != NULL ) {
                            element = NEWSV(0,0);
                            cls = PmmNodeTypeName( tnode );
                            element = sv_setref_pv( element,
                                                    (const char *)cls,
                                                    newns
                                                  );
                        }
                        else {
                            continue;
                        }
                    }
                    else {
                        element = PmmNodeToSv(tnode, owner);
                    }

                    XPUSHs( sv_2mortal(element) );
                }
            }
            xmlXPathFreeNodeSet( nodelist );
        } else {
	  REPORT_ERROR(0);
	}
#line 8852 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node_getNamespaces); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_getNamespaces)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "pnode");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pnode = ST(0)
;
#line 5613 "LibXML.xs"
        xmlNodePtr node;
        xmlNsPtr ns = NULL;
        xmlNsPtr newns = NULL;
        SV* element = &PL_sv_undef;
        const char * class = "XML::LibXML::Namespace";
#line 8877 "LibXML.c"
#line 5619 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        node = PmmSvNode(pnode);
        if ( node == NULL ) {
            croak( "lost node" );
        }
#line 8884 "LibXML.c"
#line 5625 "LibXML.xs"
        if (node->type == XML_ELEMENT_NODE) {
	  ns = node->nsDef;
	  while ( ns != NULL ) {
	    if (ns->prefix != NULL || ns->href != NULL) {
	      newns = xmlCopyNamespace(ns);
	      if ( newns != NULL ) {
		element = NEWSV(0,0);
		element = sv_setref_pv( element,
					(const char *)class,
					(void*)newns
					);
		XPUSHs( sv_2mortal(element) );
	      }
	    }
            ns = ns->next;
	  }
	}
#line 8903 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__Node_getNamespace); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_getNamespace)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "node");
    {
	xmlNodePtr	node;
#line 5650 "LibXML.xs"
        xmlNsPtr ns = NULL;
        xmlNsPtr newns = NULL;
        const char * class = "XML::LibXML::Namespace";
#line 8923 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Node::getNamespace() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::getNamespace() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5654 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
	if ( node->type == XML_ELEMENT_NODE
	    || node->type == XML_ATTRIBUTE_NODE
	    || node->type == XML_PI_NODE ) {
	  ns = node->ns;
	  if ( ns != NULL ) {
            newns = xmlCopyNamespace(ns);
            if ( newns != NULL ) {
	      RETVAL = NEWSV(0,0);
	      RETVAL = sv_setref_pv( RETVAL,
				     (const char *)class,
				     (void*)newns
				     );
            } else {
	      XSRETURN_UNDEF;
	    }
	  }
	  else {
            XSRETURN_UNDEF;
	  }
	} else {
          XSRETURN_UNDEF;
	}
#line 8962 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_nodePath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_nodePath)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
#line 5685 "LibXML.xs"
        xmlChar * path = NULL;
#line 8980 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::nodePath() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::nodePath() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5687 "LibXML.xs"
        path = xmlGetNodePath( self );
        if ( path == NULL ) {
            croak( "cannot calculate path for the given node" );
        }
        RETVAL = C2Sv( path, NULL );
        xmlFree(path);
#line 9002 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Node_line_number); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Node_line_number)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlNodePtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Node::line_number() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Node::line_number() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5700 "LibXML.xs"
        RETVAL = xmlGetLineNo( self );
#line 9035 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, name");
    {
	char *	name = (char *)SvPV_nolen(ST(1))
;
#line 5710 "LibXML.xs"
        xmlNodePtr newNode;
        ProxyNodePtr docfrag = NULL;
#line 9054 "LibXML.c"
	SV *	RETVAL;
#line 5713 "LibXML.xs"
        docfrag = PmmNewFragment(NULL);
        newNode = xmlNewNode( NULL, (const xmlChar*)name );
        newNode->doc = NULL;
        xmlAddChild(PmmNODE(docfrag), newNode);
        RETVAL = PmmNodeToSv(newNode, docfrag );
#line 9062 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__setNamespace); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__setNamespace)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "self, namespaceURI, namespacePrefix = &PL_sv_undef, flag = 1");
    {
	SV *	self = ST(0)
;
	SV *	namespaceURI = ST(1)
;
	SV *	namespacePrefix;
	int	flag;
#line 5728 "LibXML.xs"
        xmlNodePtr node = PmmSvNode(self);
        xmlChar * nsURI = nodeSv2C(namespaceURI,node);
        xmlChar * nsPrefix = NULL;
        xmlNsPtr ns = NULL;
#line 9088 "LibXML.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    namespacePrefix = &PL_sv_undef;
	else {
	    namespacePrefix = ST(2)
;
	}

	if (items < 4)
	    flag = 1;
	else {
	    flag = (int)SvIV(ST(3))
;
	}
#line 5733 "LibXML.xs"
        if ( node == NULL ) {
            croak( "lost node" );
        }
#line 9109 "LibXML.c"
#line 5737 "LibXML.xs"
       /* if ( !nsURI ){
            XSRETURN_UNDEF;
		} */

        nsPrefix = nodeSv2C(namespacePrefix, node);
        if ( xmlStrlen( nsPrefix ) == 0 ) {
            xmlFree(nsPrefix);
            nsPrefix = NULL;
        }
        if ( xmlStrlen( nsURI ) == 0 ) {
            xmlFree(nsURI);
            nsURI = NULL;
        }
        if ( nsPrefix == NULL && nsURI == NULL ) {
	    /* special case: empty namespace */
	    if ( (ns = xmlSearchNs(node->doc, node, NULL)) &&
		 ( ns->href && xmlStrlen( ns->href ) != 0 ) ) {
		/* won't take it */
		RETVAL = 0;
	    } else if ( flag ) {
		/* no namespace */
		xmlSetNs(node, NULL);
		RETVAL = 1;
	    } else {
		RETVAL = 0;
	    }
	}
        else if ( flag && (ns = xmlSearchNs(node->doc, node, nsPrefix)) ) {
	  /* user just wants to set the namespace for the node */
	  /* try to reuse an existing declaration for the prefix */
            if ( xmlStrEqual( ns->href, nsURI ) ) {
                RETVAL = 1;
            }
            else if ( (ns = xmlNewNs( node, nsURI, nsPrefix )) ) {
                RETVAL = 1;
            }
            else {
                RETVAL = 0;
            }
        }
        else if ( (ns = xmlNewNs( node, nsURI, nsPrefix )) )
	  RETVAL = 1;
	else
	  RETVAL = 0;

        if ( flag && ns ) {
            xmlSetNs(node, ns);
        }
        if ( nsPrefix ) xmlFree(nsPrefix);
        if ( nsURI ) xmlFree(nsURI);
#line 9161 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_setNamespaceDeclURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_setNamespaceDeclURI)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, svprefix, newURI");
    {
	xmlNodePtr	self;
	SV *	svprefix = ST(1)
;
	SV *	newURI = ST(2)
;
#line 5796 "LibXML.xs"
        xmlChar * prefix = NULL;
        xmlChar * nsURI = NULL;
        xmlNsPtr ns;
#line 9184 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::setNamespaceDeclURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::setNamespaceDeclURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5800 "LibXML.xs"
	RETVAL = 0;
	prefix = nodeSv2C( svprefix , self );
	nsURI = nodeSv2C( newURI , self );
	/* null empty values */
	if ( prefix && xmlStrlen(prefix) == 0) {
	  xmlFree( prefix );
	  prefix = NULL;
	}
        if ( nsURI && xmlStrlen(nsURI) == 0) {
	  xmlFree( nsURI );
	  nsURI = NULL;
	}
        ns = self->nsDef;
        while ( ns ) {
	  if ((ns->prefix || ns->href ) &&
	      ( xmlStrcmp( ns->prefix, prefix ) == 0 )) {
	    if (ns->href) xmlFree((char*)ns->href);
	    ns->href = nsURI;
	    if ( nsURI == NULL ) {
	      domRemoveNsRefs( self, ns );
	    } else
	      nsURI = NULL; /* do not free it */
	    RETVAL = 1;
	    break;
	    } else {
	    ns = ns->next;
	  }
	}
        if ( prefix ) xmlFree( prefix );
        if ( nsURI ) xmlFree( nsURI );
#line 9231 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_setNamespaceDeclPrefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_setNamespaceDeclPrefix)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, svprefix, newPrefix");
    {
	xmlNodePtr	self;
	SV *	svprefix = ST(1)
;
	SV *	newPrefix = ST(2)
;
#line 5839 "LibXML.xs"
        xmlChar * prefix = NULL;
        xmlChar * nsPrefix = NULL;
        xmlNsPtr ns;
#line 9254 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::setNamespaceDeclPrefix() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::setNamespaceDeclPrefix() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5843 "LibXML.xs"
	RETVAL = 0;
	prefix = nodeSv2C( svprefix , self );
	nsPrefix = nodeSv2C( newPrefix , self );
	/* null empty values */
	if ( prefix != NULL && xmlStrlen(prefix) == 0) {
	  xmlFree( prefix );
	  prefix = NULL;
	}
        if ( nsPrefix != NULL && xmlStrlen(nsPrefix) == 0) {
	  xmlFree( nsPrefix );
	  nsPrefix = NULL;
	}
        if ( xmlStrcmp( prefix, nsPrefix ) == 0 ) {
	  RETVAL = 1;
	} else {
	  /* check that new prefix is not in scope */
	  ns = xmlSearchNs( self->doc, self, nsPrefix );
	  if ( ns != NULL ) {
	    if (nsPrefix != NULL) xmlFree( nsPrefix );
	    if (prefix != NULL) xmlFree( prefix );
	    croak("setNamespaceDeclPrefix: prefix '%s' is in use", ns->prefix);
	  }
	  /* lookup the declaration */
	  ns = self->nsDef;
	  while ( ns != NULL ) {
	    if ((ns->prefix != NULL || ns->href != NULL) &&
		xmlStrcmp( ns->prefix, prefix ) == 0 ) {
	      if ( ns->href == NULL && nsPrefix != NULL ) {
		/* xmlns:foo="" - no go */
		if ( prefix != NULL) xmlFree(prefix);
		croak("setNamespaceDeclPrefix: cannot set non-empty prefix for empty namespace");
	      }
	      if ( ns->prefix != NULL )
		xmlFree( (xmlChar*)ns->prefix );
	      ns->prefix = nsPrefix;
	      nsPrefix = NULL; /* do not free it */
	      RETVAL = 1;
	      break;
	    } else {
	      ns = ns->next;
	    }
	  }
	}
        if ( nsPrefix != NULL ) xmlFree(nsPrefix);
        if ( prefix != NULL) xmlFree(prefix);
#line 9316 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__getNamespaceDeclURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__getNamespaceDeclURI)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ns_prefix");
    {
	xmlNodePtr	self;
	SV *	ns_prefix = ST(1)
;
#line 5897 "LibXML.xs"
        xmlChar * prefix;
        xmlNsPtr ns;
#line 9336 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::_getNamespaceDeclURI() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::_getNamespaceDeclURI() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5900 "LibXML.xs"
        prefix = nodeSv2C(ns_prefix, self );
        if ( prefix != NULL && xmlStrlen(prefix) == 0) {
		xmlFree( prefix );
		prefix = NULL;
	  }
        RETVAL = &PL_sv_undef;
        ns = self->nsDef;
        while ( ns != NULL ) {
		if ( (ns->prefix != NULL || ns->href != NULL) &&
		     xmlStrcmp( ns->prefix, prefix ) == 0 ) {
		    RETVAL = C2Sv(ns->href, NULL);
		    break;
		} else {
		    ns = ns->next;
		}
	  }
        if ( prefix != NULL ) {
		xmlFree( prefix );
	  }

#line 9372 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_hasAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_hasAttribute)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_name");
    {
	xmlNodePtr	self;
	SV *	attr_name = ST(1)
;
#line 5928 "LibXML.xs"
        xmlChar * name;
#line 9392 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::hasAttribute() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::hasAttribute() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5930 "LibXML.xs"
        name  = nodeSv2C(attr_name, self );
        if ( ! name ) {
            XSRETURN_UNDEF;
        }
        if ( domGetAttrNode( self, name ) ) {
            RETVAL = 1;
        }
        else {
            RETVAL = 0;
        }
        xmlFree(name);
#line 9420 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_hasAttributeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_hasAttributeNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, namespaceURI, attr_name");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	attr_name = ST(2)
;
#line 5950 "LibXML.xs"
        xmlChar * name;
        xmlChar * nsURI;
	xmlNodePtr attr;
#line 9443 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::hasAttributeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::hasAttributeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 5954 "LibXML.xs"
        name = nodeSv2C(attr_name, self );
        nsURI = nodeSv2C(namespaceURI, self );

        if ( name == NULL ) {
            if ( nsURI != NULL ) {
              xmlFree(nsURI);
            }
            XSRETURN_UNDEF;
        }
        if ( nsURI != NULL && xmlStrlen(nsURI) == 0 ){
            xmlFree(nsURI);
            nsURI = NULL;
        }
        attr = (xmlNodePtr) xmlHasNsProp( self, name, nsURI );
        if ( attr && attr->type == XML_ATTRIBUTE_NODE ) {
            RETVAL = 1;
        }
        else {
            RETVAL = 0;
        }

        xmlFree(name);
        if ( nsURI != NULL ){
            xmlFree(nsURI);
        }
#line 9485 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__getAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__getAttribute)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, attr_name, useDomEncoding = 0");
    {
	xmlNodePtr	self;
	SV *	attr_name = ST(1)
;
	int	useDomEncoding;
#line 5988 "LibXML.xs"
        xmlChar * name;
        xmlChar * prefix    = NULL;
        xmlChar * localname = NULL;
        xmlChar * ret = NULL;
        xmlNsPtr ns = NULL;
#line 9509 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::_getAttribute() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::_getAttribute() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    useDomEncoding = 0;
	else {
	    useDomEncoding = (int)SvIV(ST(2))
;
	}
#line 5994 "LibXML.xs"
        name = nodeSv2C(attr_name, self );
        if( !name ) {
            XSRETURN_UNDEF;
        }

        ret = xmlGetNoNsProp(self, name);
        if ( ret == NULL ) {
            localname = xmlSplitQName2(name, &prefix);
            if ( localname != NULL ) {
		    ns = xmlSearchNs( self->doc, self, prefix );
		    if ( ns != NULL ) {
			  ret = xmlGetNsProp(self, localname, ns->href);
		    }
		    if ( prefix != NULL) {
			  xmlFree( prefix );
		    }
		    xmlFree( localname );
		}
        }
        xmlFree(name);
        if ( ret ) {
            if ( useDomEncoding ) {
                RETVAL = nodeC2Sv(ret, self);
            }
            else {
                RETVAL = C2Sv(ret, NULL);
            }
            xmlFree( ret );
        }
        else {
            XSRETURN_UNDEF;
	}

#line 9565 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__setAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__setAttribute)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, attr_name, attr_value");
    {
	xmlNodePtr	self;
	SV *	attr_name = ST(1)
;
	SV *	attr_value = ST(2)
;
#line 6036 "LibXML.xs"
        xmlChar * name  = NULL;
        xmlChar * value = NULL;
#if LIBXML_VERSION < 20621
        xmlChar * prefix    = NULL;
        xmlChar * localname = NULL;
#endif
#line 9592 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::_setAttribute() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::_setAttribute() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6043 "LibXML.xs"
        name  = nodeSv2C(attr_name, self );

        if ( !LibXML_test_node_name(name) ) {
            xmlFree(name);
            croak( "bad name" );
        }
        value = nodeSv2C(attr_value, self );
#if LIBXML_VERSION >= 20621
	/*
	 * For libxml2-2.6.21 and later we can use just xmlSetProp
         */
        xmlSetProp(self,name,value);
#else
        /*
         * but xmlSetProp does not work correctly for older libxml2 versions
	 * The following is copied from libxml2 source
         * with xmlSplitQName3 replaced by xmlSplitQName2 for compatibility
         * with older libxml2 versions
         */
        localname = xmlSplitQName2(name, &prefix);
        if (localname != NULL) {
          xmlNsPtr ns;
	  ns = xmlSearchNs(self->doc, self, prefix);
	  if (prefix != NULL)
	      xmlFree(prefix);
	  if (ns != NULL)
	      xmlSetNsProp(self, ns, localname, value);
	  else
              xmlSetNsProp(self, NULL, name, value);
          xmlFree(localname);
        } else {
            xmlSetNsProp(self, NULL, name, value);
        }
#endif
        xmlFree(name);
        xmlFree(value);
#line 9643 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_removeAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_removeAttribute)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_name");
    {
	xmlNodePtr	self;
	SV *	attr_name = ST(1)
;
#line 6086 "LibXML.xs"
        xmlChar * name;
        xmlAttrPtr xattr = NULL;
#line 9662 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::removeAttribute() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::removeAttribute() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6089 "LibXML.xs"
        name  = nodeSv2C(attr_name, self );
        if ( name ) {
            xattr = domGetAttrNode( self, name );

            if ( xattr ) {
                xmlUnlinkNode((xmlNodePtr)xattr);
                if ( xattr->_private ) {
                    PmmFixOwner((ProxyNodePtr)xattr->_private, NULL);
                }
                else {
                    xmlFreeProp(xattr);
                }
            }
            xmlFree(name);
        }
#line 9692 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_getAttributeNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_getAttributeNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_name");
    {
	xmlNodePtr	self;
	SV *	attr_name = ST(1)
;
#line 6110 "LibXML.xs"
        xmlChar * name;
        xmlAttrPtr ret = NULL;
#line 9711 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::getAttributeNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::getAttributeNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6113 "LibXML.xs"
        name = nodeSv2C(attr_name, self );
        if ( !name ) {
            XSRETURN_UNDEF;
        }

        ret = domGetAttrNode( self, name );
        xmlFree(name);
        if ( ret ) {
            RETVAL = PmmNodeToSv( (xmlNodePtr)ret,
                                   PmmOWNERPO(PmmPROXYNODE(self)) );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 9741 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_setAttributeNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_setAttributeNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_node");
    {
	xmlNodePtr	self;
	SV *	attr_node = ST(1)
;
#line 6135 "LibXML.xs"
        xmlAttrPtr attr = (xmlAttrPtr)PmmSvNode( attr_node );
        xmlAttrPtr ret = NULL;
#line 9762 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::setAttributeNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::setAttributeNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6138 "LibXML.xs"
        if ( attr == NULL ) {
            croak( "lost attribute" );
        }
#line 9781 "LibXML.c"
#line 6142 "LibXML.xs"
        if ( attr != NULL && attr->type != XML_ATTRIBUTE_NODE ) {
            XSRETURN_UNDEF;
        }
        if ( attr->doc != self->doc ) {
	    domImportNode( self->doc, (xmlNodePtr)attr, 1, 1);
        }
        ret = domGetAttrNode( self, attr->name );
        if ( ret != NULL ) {
            if ( ret != attr ) {
                xmlReplaceNode( (xmlNodePtr)ret, (xmlNodePtr)attr );
            }
            else {
                XSRETURN_UNDEF;
            }
        }
        else {
            xmlAddChild( self, (xmlNodePtr)attr );
        }

        if ( attr->_private != NULL ) {
            PmmFixOwner( SvPROXYNODE(attr_node), PmmPROXYNODE(self) );
        }

        if ( ret == NULL ) {
            XSRETURN_UNDEF;
        }

        RETVAL = PmmNodeToSv( (xmlNodePtr)ret, NULL );
        PmmFixOwner( SvPROXYNODE(RETVAL), NULL );
#line 9812 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__getAttributeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__getAttributeNS)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "self, namespaceURI, attr_name, useDomEncoding = 0");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	attr_name = ST(2)
;
	int	useDomEncoding;
#line 6181 "LibXML.xs"
        xmlChar * name;
        xmlChar * nsURI;
        xmlChar * ret = NULL;
#line 9837 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::_getAttributeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::_getAttributeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 4)
	    useDomEncoding = 0;
	else {
	    useDomEncoding = (int)SvIV(ST(3))
;
	}
#line 6185 "LibXML.xs"
        name = nodeSv2C( attr_name, self );
        nsURI = nodeSv2C( namespaceURI, self );
        if ( !name ) {
            xmlFree(nsURI);
            XSRETURN_UNDEF;
        }
        if ( nsURI && xmlStrlen(nsURI) ) {
            ret = xmlGetNsProp( self, name, nsURI );
        }
        else {
            ret = xmlGetProp( self, name );
        }

        xmlFree( name );
        if ( nsURI ) {
            xmlFree( nsURI );
        }
        if ( ret ) {
            if (useDomEncoding) {
                RETVAL = nodeC2Sv( ret, self );
            } else {
                RETVAL = C2Sv( ret, NULL );
            }
            xmlFree( ret );
        }
        else {
            XSRETURN_UNDEF;
        }
#line 9888 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element__setAttributeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element__setAttributeNS)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, namespaceURI, attr_name, attr_value");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	attr_name = ST(2)
;
	SV *	attr_value = ST(3)
;
#line 6223 "LibXML.xs"
        xmlChar * nsURI;
        xmlChar * name  = NULL;
        xmlChar * value = NULL;
        xmlNsPtr ns         = NULL;
        xmlChar * localname = NULL;
        xmlChar * prefix    = NULL;
        xmlNsPtr * all_ns   = NULL;
        int i;
#line 9919 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::_setAttributeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::_setAttributeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6232 "LibXML.xs"
        name  = nodeSv2C( attr_name, self );

        if ( !LibXML_test_node_name(name) ) {
            xmlFree(name);
            croak( "bad name" );
        }

        nsURI = nodeSv2C( namespaceURI, self );
        localname = xmlSplitQName2(name, &prefix);
        if ( localname ) {
            xmlFree( name );
            name = localname;
        }
#line 9947 "LibXML.c"
#line 6246 "LibXML.xs"
        value = nodeSv2C( attr_value, self );

        if ( nsURI && xmlStrlen(nsURI) ) {
            xs_warn( "found uri" );

            ns = xmlSearchNsByHref( self->doc, self, nsURI );

            /*
             * check for any prefixed namespaces occluded by a default namespace
             * because xmlSearchNsByHref will return default namespaces unless
             * you are searching on an attribute node, which may not exist yet
             */
            if ( ns && !ns->prefix )
            {
                all_ns = xmlGetNsList(self->doc, self);
                if ( all_ns )
                {
                    i = 0;
                    ns = all_ns[i];
                    while ( ns )
                    {
                        if ( ns->prefix && xmlStrEqual(ns->href, nsURI) )
                        {
                            break;
                        }
                        ns = all_ns[i++];
                    }
                    xmlFree(all_ns);
                }
            }

            if ( !ns ) {
                /* create new ns */
                if ( prefix && xmlStrlen( prefix ) ) {
                    ns = xmlNewNs(self, nsURI , prefix);
                }
                else {
                    ns = NULL;
                }
            }
        }

        if ( nsURI && xmlStrlen(nsURI) && !ns ) {
	  if ( prefix ) xmlFree( prefix );
	  if ( nsURI ) xmlFree( nsURI );
	  xmlFree( name );
	  xmlFree( value );
	  croak( "bad ns attribute!" );
        }
        else {
            /* warn( "set attribute %s->%s", name, value ); */
            xmlSetNsProp( self, ns, name, value );
        }

        if ( prefix ) {
            xmlFree( prefix );
        }
        if ( nsURI ) {
            xmlFree( nsURI );
        }
        xmlFree( name );
        xmlFree( value );
#line 10011 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_removeAttributeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_removeAttributeNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, namespaceURI, attr_name");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	attr_name = ST(2)
;
#line 6315 "LibXML.xs"
        xmlChar * nsURI;
        xmlChar * name  = NULL;
        xmlAttrPtr xattr = NULL;
#line 10033 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::removeAttributeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::removeAttributeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6319 "LibXML.xs"
        nsURI = nodeSv2C( namespaceURI, self );
        name  = nodeSv2C( attr_name, self );
        if ( ! name ) {
            xmlFree(nsURI);
            XSRETURN_UNDEF;
        }

        if ( nsURI && xmlStrlen(nsURI) ) {
            xattr = xmlHasNsProp( self, name, nsURI );
        }
        else {
            xattr = xmlHasNsProp( self, name, NULL );
        }
        if ( xattr && xattr->type == XML_ATTRIBUTE_NODE ) {
            xmlUnlinkNode((xmlNodePtr)xattr);
            if ( xattr->_private ) {
                PmmFixOwner((ProxyNodePtr)xattr->_private, NULL);
            }
            else {
                xmlFreeProp(xattr);
            }
        }
        xmlFree(nsURI);
        xmlFree( name );
#line 10072 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_getAttributeNodeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_getAttributeNodeNS)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, namespaceURI, attr_name");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	attr_name = ST(2)
;
#line 6351 "LibXML.xs"
        xmlChar * nsURI;
        xmlChar * name;
        xmlAttrPtr ret = NULL;
#line 10094 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::getAttributeNodeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::getAttributeNodeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6355 "LibXML.xs"
        nsURI = nodeSv2C(namespaceURI, self );
        name = nodeSv2C(attr_name, self );
        if ( !name ) {
            xmlFree(nsURI);
            XSRETURN_UNDEF;
        }
        if ( nsURI && xmlStrlen(nsURI) ) {
            ret = xmlHasNsProp( self, name, nsURI );
        }
        else {
            ret = xmlHasNsProp( self, name, NULL );
        }
        xmlFree(name);
        if ( nsURI ) {
            xmlFree(nsURI);
        }
        if ( ret &&
	     ret->type == XML_ATTRIBUTE_NODE /* we don't want fixed attribute decls */
	   ) {
            RETVAL = PmmNodeToSv( (xmlNodePtr)ret,
                                   PmmOWNERPO(PmmPROXYNODE(self)) );
        }
        else {
            /* warn("no prop\n"); */
            XSRETURN_UNDEF;
        }
#line 10136 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_setAttributeNodeNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_setAttributeNodeNS)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_node");
    {
	xmlNodePtr	self;
	SV *	attr_node = ST(1)
;
#line 6389 "LibXML.xs"
        xmlAttrPtr attr = (xmlAttrPtr)PmmSvNode( attr_node );
        xmlNsPtr ns = NULL;
        xmlAttrPtr ret = NULL;
#line 10158 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::setAttributeNodeNS() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::setAttributeNodeNS() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6393 "LibXML.xs"
        if ( attr == NULL ) {
            croak( "lost attribute node" );
        }
#line 10177 "LibXML.c"
#line 6397 "LibXML.xs"
        if ( attr->type != XML_ATTRIBUTE_NODE ) {
            XSRETURN_UNDEF;
        }

        if ( attr->doc != self->doc ) {
           domImportNode( self->doc, (xmlNodePtr)attr, 1,1);
        }


        ns = attr->ns;
        if ( ns != NULL ) {
            ret = xmlHasNsProp( self, ns->href, attr->name );
        }
        else {
            ret = xmlHasNsProp( self, NULL, attr->name );
        }

        if ( ret && ret->type == XML_ATTRIBUTE_NODE ) {
            if ( ret != attr ) {
                xmlReplaceNode( (xmlNodePtr)ret, (xmlNodePtr)attr );
            }
            else {
                XSRETURN_UNDEF;
            }
        }
        else {
            xmlAddChild( self, (xmlNodePtr)attr );
            xmlReconciliateNs(self->doc, self);
        }
        if ( attr->_private != NULL ) {
            PmmFixOwner( SvPROXYNODE(attr_node), PmmPROXYNODE(self) );
        }
        if ( ret != NULL && ret->type == XML_ATTRIBUTE_NODE ) {
	    RETVAL = PmmNodeToSv( (xmlNodePtr)ret, NULL );
	    PmmFixOwner( SvPROXYNODE(RETVAL), NULL );
	} else {
            XSRETURN_UNDEF;
        }
#line 10217 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_removeAttributeNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_removeAttributeNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, attr_node");
    {
	xmlNodePtr	self;
	SV *	attr_node = ST(1)
;
#line 6443 "LibXML.xs"
        xmlAttrPtr attr = (xmlAttrPtr)PmmSvNode( attr_node );
        xmlAttrPtr ret;
#line 10238 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::removeAttributeNode() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::removeAttributeNode() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6446 "LibXML.xs"
        if ( attr == NULL ) {
            croak( "lost attribute node" );
        }
#line 10257 "LibXML.c"
#line 6450 "LibXML.xs"
        if ( attr->type != XML_ATTRIBUTE_NODE ) {
            XSRETURN_UNDEF;
        }
        if ( attr->parent != self ) {
            XSRETURN_UNDEF;
        }
        ret = attr;
        xmlUnlinkNode( (xmlNodePtr)attr );
        RETVAL = PmmNodeToSv( (xmlNodePtr)ret, NULL );
        PmmFixOwner( SvPROXYNODE(RETVAL), NULL );
#line 10269 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Element_appendText); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_appendText)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, string");
    {
	xmlNodePtr	self;
	SV *	string = ST(1)
;
#line 6472 "LibXML.xs"
        xmlChar * content = NULL;
#line 10290 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::appendText() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::appendText() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6474 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        content = nodeSv2C( string, self );
        if ( content == NULL ) {
            XSRETURN_UNDEF;
        }
        if ( xmlStrlen(content) == 0 ) {
            xmlFree( content );
            XSRETURN_UNDEF;
        }
#line 10314 "LibXML.c"
#line 6484 "LibXML.xs"
        xmlNodeAddContent( self, content );
        xmlFree(content);
#line 10318 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_appendTextChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_appendTextChild)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 4)
       croak_xs_usage(cv,  "self, strname, strcontent=&PL_sv_undef, nsURI=&PL_sv_undef");
    {
	xmlNodePtr	self;
	SV *	strname = ST(1)
;
	SV *	strcontent;
	SV *	nsURI;
#line 6495 "LibXML.xs"
        xmlChar * name;
        xmlChar * content = NULL;
        xmlChar * encstr  = NULL;
#line 10340 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::appendTextChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::appendTextChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    strcontent = &PL_sv_undef;
	else {
	    strcontent = ST(2)
;
	}

	if (items < 4)
	    nsURI = &PL_sv_undef;
	else {
	    nsURI = ST(3)
;
	}
#line 6499 "LibXML.xs"
        name    = nodeSv2C( strname, self );
        if ( xmlStrlen(name) == 0 ) {
            xmlFree(name);
            XSRETURN_UNDEF;
        }
#line 10374 "LibXML.c"
#line 6505 "LibXML.xs"
        content = nodeSv2C(strcontent, self);
        if ( content &&  xmlStrlen( content ) == 0 ) {
            xmlFree(content);
            content=NULL;
        }
        else if ( content ) {
            encstr = xmlEncodeEntitiesReentrant( self->doc, content );
            xmlFree(content);
        }

        xmlNewChild( self, NULL, name, encstr );

        if ( encstr )
            xmlFree(encstr);
        xmlFree(name);
#line 10391 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Element_addNewChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Element_addNewChild)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "self, namespaceURI, nodename");
    {
	xmlNodePtr	self;
	SV *	namespaceURI = ST(1)
;
	SV *	nodename = ST(2)
;
#line 6529 "LibXML.xs"
        xmlChar * nsURI = NULL;
        xmlChar * name  = NULL;
        xmlChar * localname  = NULL;
        xmlChar * prefix     = NULL;
        xmlNodePtr newNode = NULL;
        xmlNodePtr prev = NULL;
        xmlNsPtr ns = NULL;
#line 10418 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Element::addNewChild() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Element::addNewChild() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6537 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        name = nodeSv2C(nodename, self);
        if ( name &&  xmlStrlen( name ) == 0 ) {
            xmlFree(name);
            XSRETURN_UNDEF;
        }

        nsURI = nodeSv2C(namespaceURI, self);
        if ( nsURI &&  xmlStrlen( nsURI ) == 0 ) {
            xmlFree(nsURI);
            nsURI=NULL;
        }

        if ( nsURI != NULL ) {
            localname = xmlSplitQName2(name, &prefix);
            ns = xmlSearchNsByHref(self->doc, self, nsURI);

            newNode = xmlNewDocNode(self->doc,
                                ns,
                                localname?localname:name,
                                NULL);
            if ( ns == NULL )  {
	        xmlSetNs(newNode,xmlNewNs(newNode, nsURI, prefix));
            }

            xmlFree(localname);
            xmlFree(prefix);
            xmlFree(nsURI);
        }
        else {
            newNode = xmlNewDocNode(self->doc,
                                    NULL,
                                    name,
                                    NULL);
        }
        xmlFree(name);
        /* add the node to the parent node */
        newNode->type = XML_ELEMENT_NODE;
        newNode->parent = self;
        newNode->doc = self->doc;

        if (self->children == NULL) {
            self->children = newNode;
            self->last = newNode;
        } else {
            prev = self->last;
            prev->next = newNode;
            newNode->prev = prev;
            self->last = newNode;
        }
        RETVAL = PmmNodeToSv(newNode, PmmOWNERPO(PmmPROXYNODE(self)) );
#line 10485 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Text_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, content");
    {
	SV *	content = ST(1)
;
#line 6597 "LibXML.xs"
        xmlChar * data;
        xmlNodePtr newNode;
        ProxyNodePtr docfrag = NULL;
#line 10506 "LibXML.c"
	SV *	RETVAL;
#line 6601 "LibXML.xs"
        data = Sv2C(content, NULL);
        newNode = xmlNewText( data );
        xmlFree(data);
        if( newNode != NULL ) {
            docfrag = PmmNewFragment( NULL );
            xmlAddChild(PmmNODE(docfrag), newNode);
            RETVAL = PmmNodeToSv(newNode,docfrag);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 10520 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Text_substringData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_substringData)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, offset, length");
    {
	xmlNodePtr	self;
	int	offset = (int)SvIV(ST(1))
;
	int	length = (int)SvIV(ST(2))
;
#line 6621 "LibXML.xs"
        xmlChar * data = NULL;
        xmlChar * substr = NULL;
#line 10543 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::substringData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::substringData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6624 "LibXML.xs"
        if ( offset >= 0 && length >= 0 ) {
            data = domGetNodeValue( self );
            if ( data != NULL ) {
                substr = xmlUTF8Strsub( data, offset, length );
                RETVAL = C2Sv( (const xmlChar*)substr, NULL );
                xmlFree( substr );
            }
            else {
                XSRETURN_UNDEF;
            }
        }
        else {
            XSRETURN_UNDEF;
        }
#line 10573 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Text_setData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_setData)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	xmlNodePtr	self;
	SV *	value = ST(1)
;
#line 6649 "LibXML.xs"
        xmlChar * encstr = NULL;
#line 10594 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::setData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::setData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6651 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        encstr = nodeSv2C(value,self);
        domSetNodeValue( self, encstr );
        xmlFree(encstr);
#line 10613 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Text_appendData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_appendData)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, value");
    {
	xmlNodePtr	self;
	SV *	value = ST(1)
;
#line 6661 "LibXML.xs"
        xmlChar * encstring = NULL;
        int strlen = 0;
#line 10632 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::appendData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::appendData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6664 "LibXML.xs"
        encstring = Sv2C( value,
                          self->doc!=NULL ? self->doc->encoding : NULL );

       if ( encstring != NULL ) {
            strlen = xmlStrlen( encstring );
            xmlTextConcat( self, encstring, strlen );
            xmlFree( encstring );
        }
#line 10655 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Text_insertData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_insertData)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, offset, value");
    {
	xmlNodePtr	self;
	int	offset = (int)SvIV(ST(1))
;
	SV *	value = ST(2)
;
#line 6679 "LibXML.xs"
        xmlChar * after= NULL;
        xmlChar * data = NULL;
        xmlChar * new  = NULL;
        xmlChar * encstring = NULL;
        int dl = 0;
#line 10679 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::insertData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::insertData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6685 "LibXML.xs"
        if ( offset >= 0 ) {
            encstring = Sv2C( value,
                              self->doc!=NULL ? self->doc->encoding : NULL );
            if ( encstring != NULL && xmlStrlen( encstring ) > 0 ) {
                data = domGetNodeValue(self);
                if ( data != NULL && xmlStrlen( data ) > 0 ) {
                    if ( xmlUTF8Strlen( data ) < offset ) {
                        data = xmlStrcat( data, encstring );
                        domSetNodeValue( self, data );
                    }
                    else {
                        dl = xmlUTF8Strlen( data ) - offset;

                        if ( offset > 0 )
                            new   = xmlUTF8Strsub(data, 0, offset );

                        after = xmlUTF8Strsub(data, offset, dl );

                        if ( new != NULL ) {
                            new = xmlStrcat(new, encstring );
                        }
                        else {
                            new = xmlStrdup( encstring );
                        }

                        if ( after != NULL )
                            new = xmlStrcat(new, after );

                        domSetNodeValue( self, new );

                        xmlFree( new );
                        xmlFree( after );
                    }
                    xmlFree( data );
                }
                else {
                    domSetNodeValue( self, encstring );
                }
                xmlFree(encstring);
            }
        }
#line 10735 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Text_deleteData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_deleteData)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, offset, length");
    {
	xmlNodePtr	self;
	int	offset = (int)SvIV(ST(1))
;
	int	length = (int)SvIV(ST(2))
;
#line 6733 "LibXML.xs"
        xmlChar * data  = NULL;
        xmlChar * after = NULL;
        xmlChar * new   = NULL;
        int len = 0;
        int dl1 = 0;
        int dl2 = 0;
#line 10760 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::deleteData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::deleteData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6740 "LibXML.xs"
        if ( length > 0 && offset >= 0 ) {
            data = domGetNodeValue(self);
            len = xmlUTF8Strlen( data );
            if ( data != NULL
                 && len > 0
                 && len > offset ) {
                dl1 = offset + length;
                if ( offset > 0 )
                    new = xmlUTF8Strsub( data, 0, offset );

                if ( len > dl1 ) {
                    dl2 = len - dl1;
                    after = xmlUTF8Strsub( data, dl1, dl2 );
                    if ( new != NULL ) {
                        new = xmlStrcat( new, after );
                        xmlFree(after);
                    }
                    else {
                        new = after;
                    }
                }

                domSetNodeValue( self, new );
                xmlFree(new);
            }
        }
#line 10801 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Text_replaceData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Text_replaceData)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "self, offset, length, value");
    {
	xmlNodePtr	self;
	int	offset = (int)SvIV(ST(1))
;
	int	length = (int)SvIV(ST(2))
;
	SV *	value = ST(3)
;
#line 6774 "LibXML.xs"
        xmlChar * after= NULL;
        xmlChar * data = NULL;
        xmlChar * new  = NULL;
        xmlChar * encstring = NULL;
        int len = 0;
        int dl1 = 0;
        int dl2 = 0;
#line 10829 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlNodePtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Text::replaceData() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Text::replaceData() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 6782 "LibXML.xs"
        if ( offset >= 0 ) {
            encstring = Sv2C( value,
                              self->doc!=NULL ? self->doc->encoding : NULL );

            if ( encstring != NULL && xmlStrlen( encstring ) > 0 ) {
                data = domGetNodeValue(self);
                len = xmlUTF8Strlen( data );

                if ( data != NULL
                     && len > 0
                     && len > offset  ) {

                    dl1 = offset + length;
                    if ( dl1 < len ) {
                        dl2 = xmlUTF8Strlen( data ) - dl1;
                        if ( offset > 0 ) {
                            new = xmlUTF8Strsub(data, 0, offset );
                            new = xmlStrcat(new, encstring );
                        }
                        else {
                            new   = xmlStrdup( encstring );
                        }

                        after = xmlUTF8Strsub(data, dl1, dl2 );
                        new = xmlStrcat(new, after );

                        domSetNodeValue( self, new );

                        xmlFree( new );
                        xmlFree( after );
                    }
                    else {
                        /* replace until end! */
                        if ( offset > 0 ) {
                            new = xmlUTF8Strsub(data, 0, offset );
                            new = xmlStrcat(new, encstring );
                        }
                        else {
                            new   = xmlStrdup( encstring );
                        }
                        domSetNodeValue( self, new );
                        xmlFree( new );
                    }
                    xmlFree( data );
                }

                xmlFree(encstring);
            }
        }
#line 10893 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Comment_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Comment_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, content");
    {
	SV *	content = ST(1)
;
#line 6838 "LibXML.xs"
        xmlChar * encstring;
        xmlNodePtr newNode;
        ProxyNodePtr docfrag = NULL;
#line 10912 "LibXML.c"
	SV *	RETVAL;
#line 6842 "LibXML.xs"
        encstring = Sv2C(content, NULL);
        newNode = xmlNewComment( encstring );
        xmlFree(encstring);
        if( newNode != NULL ) {
            docfrag = PmmNewFragment( NULL );
            xmlAddChild(PmmNODE(docfrag), newNode);
            RETVAL = PmmNodeToSv(newNode,docfrag);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 10926 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__CDATASection_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__CDATASection_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, content");
    {
	SV *	content = ST(1)
;
#line 6862 "LibXML.xs"
        xmlChar * encstring;
        xmlNodePtr newNode;
        ProxyNodePtr docfrag = NULL;
#line 10947 "LibXML.c"
	SV *	RETVAL;
#line 6866 "LibXML.xs"
        encstring = Sv2C(content, NULL);
        newNode = xmlNewCDataBlock( NULL , encstring, xmlStrlen( encstring ) );
        xmlFree(encstring);
        if ( newNode != NULL ){
            docfrag = PmmNewFragment( NULL );
            xmlAddChild(PmmNODE(docfrag), newNode);
            RETVAL = PmmNodeToSv(newNode,docfrag);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 10961 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__DocumentFragment_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__DocumentFragment_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
#line 6885 "LibXML.xs"
        xmlNodePtr real_doc=NULL;
#line 10978 "LibXML.c"
	SV *	RETVAL;
#line 6887 "LibXML.xs"
        real_doc = xmlNewDocFragment( NULL );
        RETVAL = PmmNodeToSv( real_doc, NULL );
#line 10983 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr_new)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "CLASS, pname, pvalue");
    {
	SV *	pname = ST(1)
;
	SV *	pvalue = ST(2)
;
#line 6899 "LibXML.xs"
        xmlNodePtr attr = NULL;
        xmlChar * name;
        xmlChar * value;
#line 11006 "LibXML.c"
	SV *	RETVAL;
#line 6903 "LibXML.xs"
        name  = Sv2C(pname,NULL);
        value = Sv2C(pvalue,NULL);
        if ( name == NULL ) {
            XSRETURN_UNDEF;
        }
        attr =  (xmlNodePtr)xmlNewProp( NULL, name, value );
        attr->doc = NULL;
        RETVAL = PmmNodeToSv(attr,NULL);
#line 11017 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr_parentElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr_parentElement)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	RETVAL;
#line 6924 "LibXML.xs"
        /* override the original parentElement(), since this an attribute is
         * not part of the main tree
         */

        PERL_UNUSED_VAR(ix);
        XSRETURN_UNDEF;
#line 11041 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr_serializeContent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr_serializeContent)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, useDomEncoding = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	useDomEncoding;
#line 6938 "LibXML.xs"
        xmlBufferPtr buffer;
        const xmlChar *ret = NULL;
        xmlAttrPtr node = (xmlAttrPtr)PmmSvNode(self);
#line 11063 "LibXML.c"
	SV *	RETVAL;

	if (items < 2)
	    useDomEncoding = &PL_sv_undef;
	else {
	    useDomEncoding = ST(1)
;
	}
#line 6942 "LibXML.xs"
        buffer = xmlBufferCreate();
        domAttrSerializeContent(buffer, node);
        if ( xmlBufferLength(buffer) > 0 ) {
            ret = xmlBufferContent( buffer );
        }
        if ( ret != NULL ) {
            if ( useDomEncoding != &PL_sv_undef && SvTRUE(useDomEncoding) ) {
                RETVAL = nodeC2Sv((xmlChar*)ret, PmmNODE(PmmPROXYNODE(node))) ;
            }
            else {
                RETVAL = C2Sv((xmlChar*)ret, NULL) ;
            }
            xmlBufferFree( buffer );
        }
        else {
            xmlBufferFree( buffer );
            xs_warn("Failed to convert attribute to string");
            XSRETURN_UNDEF;
        }
#line 11092 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr_toString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr_toString)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "self, format=0, useDomEncoding = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	useDomEncoding;
	int	format;
#line 6972 "LibXML.xs"
        xmlAttrPtr node = (xmlAttrPtr)PmmSvNode(self);
        xmlBufferPtr buffer;
        const xmlChar *ret = NULL;
#line 11116 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    useDomEncoding = &PL_sv_undef;
	else {
	    useDomEncoding = ST(2)
;
	}

	if (items < 2)
	    format = 0;
	else {
	    format = (int)SvIV(ST(1))
;
	}
#line 6976 "LibXML.xs"
        /* we add an extra method for serializing attributes since
           XML::LibXML::Node::toString causes segmentation fault inside
           libxml2
	 */
        PERL_UNUSED_VAR(ix);
        buffer = xmlBufferCreate();
        xmlBufferAdd(buffer, BAD_CAST " ", 1);
        if ((node->ns != NULL) && (node->ns->prefix != NULL)) {
	  xmlBufferAdd(buffer, node->ns->prefix, xmlStrlen(node->ns->prefix));
	  xmlBufferAdd(buffer, BAD_CAST ":", 1);
	}
        xmlBufferAdd(buffer, node->name, xmlStrlen(node->name));
        xmlBufferAdd(buffer, BAD_CAST "=\"", 2);
        domAttrSerializeContent(buffer, node);
        xmlBufferAdd(buffer, BAD_CAST "\"", 1);

        if ( xmlBufferLength(buffer) > 0 ) {
            ret = xmlBufferContent( buffer );
        }
        if ( ret != NULL ) {
            if ( useDomEncoding != &PL_sv_undef && SvTRUE(useDomEncoding) ) {
                RETVAL = nodeC2Sv((xmlChar*)ret, PmmNODE(PmmPROXYNODE(node))) ;
            }
            else {
                RETVAL = C2Sv((xmlChar*)ret, NULL) ;
            }
            xmlBufferFree( buffer );
        }
        else {
            xmlBufferFree( buffer );
            xs_warn("Failed to convert attribute to string");
            XSRETURN_UNDEF;
        }
#line 11166 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr__setNamespace); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr__setNamespace)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, namespaceURI, namespacePrefix = &PL_sv_undef");
    {
	SV *	self = ST(0)
;
	SV *	namespaceURI = ST(1)
;
	SV *	namespacePrefix;
#line 7019 "LibXML.xs"
        xmlAttrPtr node = (xmlAttrPtr)PmmSvNode(self);
        xmlChar * nsURI = nodeSv2C(namespaceURI,(xmlNodePtr)node);
        xmlChar * nsPrefix = NULL;
        xmlNsPtr ns = NULL;
#line 11191 "LibXML.c"
	int	RETVAL;
	dXSTARG;

	if (items < 3)
	    namespacePrefix = &PL_sv_undef;
	else {
	    namespacePrefix = ST(2)
;
	}
#line 7024 "LibXML.xs"
        if ( node == NULL ) {
            croak( "lost node" );
        }
#line 11205 "LibXML.c"
#line 7028 "LibXML.xs"
        if ( !nsURI || xmlStrlen(nsURI)==0 ){
	    xmlSetNs((xmlNodePtr)node, NULL);
            RETVAL = 1;
        }
        if ( !node->parent ) {
            XSRETURN_UNDEF;
        }
        nsPrefix = nodeSv2C(namespacePrefix, (xmlNodePtr)node);
        if ( (ns = xmlSearchNs(node->doc, node->parent, nsPrefix)) &&
             xmlStrEqual( ns->href, nsURI) ) {
	    /* same uri and prefix */
	    RETVAL = 1;
	}
	else if ( (ns = xmlSearchNsByHref(node->doc, node->parent, nsURI)) ) {
	    /* set uri, but with a different prefix */
            RETVAL = 1;
	}
        else
            RETVAL = 0;

        if ( ns ) {
	    if ( ns->prefix ) {
		xmlSetNs((xmlNodePtr)node, ns);
	    } else {
                RETVAL = 0;
	    }
	}
        xmlFree(nsPrefix);
        xmlFree(nsURI);
#line 11236 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Attr_isId); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Attr_isId)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7064 "LibXML.xs"
        xmlAttrPtr attr = (xmlAttrPtr)PmmSvNode(self);
	xmlNodePtr elem;
#line 11255 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 7067 "LibXML.xs"
        if ( attr == NULL ) {
          XSRETURN_UNDEF;
        }
	elem = attr->parent;
	if ( elem == NULL || elem->doc == NULL ) {
	  XSRETURN_UNDEF;
        }
        RETVAL = xmlIsID( elem->doc, elem, attr );
#line 11267 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, namespaceURI, namespacePrefix=&PL_sv_undef");
    {
	const char *	CLASS = (const char *)SvPV_nolen(ST(0))
;
	SV *	namespaceURI = ST(1)
;
	SV *	namespacePrefix;
#line 7086 "LibXML.xs"
        xmlNsPtr ns = NULL;
        xmlChar* nsURI;
        xmlChar* nsPrefix;
#line 11290 "LibXML.c"
	SV *	RETVAL;

	if (items < 3)
	    namespacePrefix = &PL_sv_undef;
	else {
	    namespacePrefix = ST(2)
;
	}
#line 7090 "LibXML.xs"
        RETVAL = &PL_sv_undef;

        nsURI = Sv2C(namespaceURI,NULL);
        if ( !nsURI ) {
            XSRETURN_UNDEF;
        }
        nsPrefix = Sv2C(namespacePrefix, NULL);
        ns = xmlNewNs(NULL, nsURI, nsPrefix);
        if ( ns ) {
            RETVAL = NEWSV(0,0);
            RETVAL = sv_setref_pv( RETVAL,
                                   CLASS,
                                   (void*)ns);
	}
        xmlFree(nsURI);
        if ( nsPrefix )
            xmlFree(nsPrefix);
#line 11317 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7114 "LibXML.xs"
        xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
#line 11336 "LibXML.c"
#line 7116 "LibXML.xs"
        xs_warn( "DESTROY NS" );
        if (ns) {
            xmlFreeNs(ns);
        }
#line 11342 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Namespace_nodeType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_nodeType)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7127 "LibXML.xs"
        xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
#line 11360 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 7129 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = ns->type;
#line 11366 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace_declaredURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_declaredURI)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7145 "LibXML.xs"
        xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
        xmlChar * href;
#line 11386 "LibXML.c"
	SV *	RETVAL;
#line 7148 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        href = xmlStrdup(ns->href);
        RETVAL = C2Sv(href, NULL);
        xmlFree(href);
#line 11393 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace_declaredPrefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_declaredPrefix)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7162 "LibXML.xs"
        xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
        xmlChar * prefix;
#line 11414 "LibXML.c"
	SV *	RETVAL;
#line 7165 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        prefix = xmlStrdup(ns->prefix);
        RETVAL = C2Sv(prefix, NULL);
        xmlFree(prefix);
#line 11421 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace_unique_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace_unique_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7176 "LibXML.xs"
        xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
        xmlChar* key;
#line 11441 "LibXML.c"
	SV *	RETVAL;
#line 7179 "LibXML.xs"
        /* Concatenate prefix and URI with vertical bar dividing*/
        key = xmlStrdup(ns->prefix);
        key = xmlStrcat(key, (const xmlChar*)"|");
        key = xmlStrcat(key, ns->href);
        RETVAL = C2Sv(key, NULL);
#line 11449 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Namespace__isEqual); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Namespace__isEqual)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, ref_node");
    {
	SV *	self = ST(0)
;
	SV *	ref_node = ST(1)
;
#line 7192 "LibXML.xs"
       xmlNsPtr ns = INT2PTR(xmlNsPtr,SvIV(SvRV(self)));
       xmlNsPtr ons = INT2PTR(xmlNsPtr,SvIV(SvRV(ref_node)));
#line 11471 "LibXML.c"
	int	RETVAL;
	dXSTARG;
#line 7195 "LibXML.xs"
       RETVAL = 0;
       if ( ns == ons ) {
           RETVAL = 1;
       }
       else if ( xmlStrEqual(ns->href, ons->href)
            && xmlStrEqual(ns->prefix, ons->prefix) ) {
           RETVAL = 1;
       }
#line 11483 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Dtd_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Dtd_new)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "CLASS, external, system");
    {
	char *	external = (char *)SvPV_nolen(ST(1))
;
	char *	system = (char *)SvPV_nolen(ST(2))
;
#line 7216 "LibXML.xs"
        xmlDtdPtr dtd = NULL;
        PREINIT_SAVED_ERROR
#line 11505 "LibXML.c"
	SV *	RETVAL;
#line 7219 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        INIT_ERROR_HANDLER;
        dtd = xmlParseDTD((const xmlChar*)external, (const xmlChar*)system);
        if ( dtd == NULL ) {
	    CLEANUP_ERROR_HANDLER;
            REPORT_ERROR(0);
            XSRETURN_UNDEF;
        } else {
            xmlSetTreeDoc((xmlNodePtr)dtd, NULL);
            RETVAL = PmmNodeToSv( (xmlNodePtr) dtd, NULL );
	    CLEANUP_ERROR_HANDLER;
            REPORT_ERROR(0);
        }
#line 11521 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Dtd_systemId); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Dtd_systemId)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDtdPtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDtdPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Dtd::systemId() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Dtd::systemId() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7241 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
	if ( self->SystemID == NULL ) {
            XSRETURN_UNDEF;
	} else {
            RETVAL = C2Sv(self->SystemID,NULL);
	}
#line 11559 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Dtd_publicId); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Dtd_publicId)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlDtdPtr	self;
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) ) {
            self = INT2PTR(xmlDtdPtr,PmmSvNode(ST(0)));
            if ( self == NULL ) {
               croak( "XML::LibXML::Dtd::publicId() -- self contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Dtd::publicId() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7256 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
	if ( self->ExternalID == NULL ) {
            XSRETURN_UNDEF;
	} else {
            RETVAL = C2Sv(self->ExternalID,NULL);
	}
#line 11597 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Dtd_parse_string); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Dtd_parse_string)
{
    dVAR; dXSARGS;
    if (items < 2)
       croak_xs_usage(cv,  "CLASS, str, ...");
    {
	char *	str = (char *)SvPV_nolen(ST(1))
;
#line 7269 "LibXML.xs"
        xmlDtdPtr res;
        SV * encoding_sv;
        xmlParserInputBufferPtr buffer;
        xmlCharEncoding enc = XML_CHAR_ENCODING_NONE;
        xmlChar * new_string;
        PREINIT_SAVED_ERROR
#line 11621 "LibXML.c"
	SV *	RETVAL;
#line 7276 "LibXML.xs"
        INIT_ERROR_HANDLER;
        if (items > 2) {
            encoding_sv = ST(2);
            if (items > 3) {
	        CLEANUP_ERROR_HANDLER;
                croak("parse_string: too many parameters");
            }
            /* warn("getting encoding...\n"); */
            enc = xmlParseCharEncoding(SvPV_nolen(encoding_sv));
            if (enc == XML_CHAR_ENCODING_ERROR) {
	        CLEANUP_ERROR_HANDLER;
                REPORT_ERROR(1);
                croak("Parse of encoding %s failed", SvPV_nolen(encoding_sv));
            }
        }
        buffer = xmlAllocParserInputBuffer(enc);
        /* buffer = xmlParserInputBufferCreateMem(str, xmlStrlen(str), enc); */
        if ( !buffer) {
	    CLEANUP_ERROR_HANDLER;
            REPORT_ERROR(1);
            croak("cannot create buffer!\n" );
	}
        new_string = xmlStrdup((const xmlChar*)str);
        xmlParserInputBufferPush(buffer, xmlStrlen(new_string), (const char*)new_string);

        res = xmlIOParseDTD(NULL, buffer, enc);

        /* NOTE: xmlIOParseDTD is documented to free its InputBuffer */
        xmlFree(new_string);
        if ( res && LibXML_will_die_ctx(saved_error, 0) )
	    xmlFreeDtd( res );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if (res == NULL) {
            croak("no DTD parsed!");
        }
        RETVAL = PmmNodeToSv((xmlNodePtr)res, NULL);
#line 11661 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef HAVE_SCHEMAS
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_XML__LibXML__RelaxNG_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RelaxNG_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlRelaxNGPtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlRelaxNGPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::RelaxNG::DESTROY() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7325 "LibXML.xs"
        xmlRelaxNGFree( self );
#line 11690 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_location); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_location)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, url");
    {
	char *	url = (char *)SvPV_nolen(ST(1))
;
#line 7332 "LibXML.xs"
        const char * CLASS = "XML::LibXML::RelaxNG";
        xmlRelaxNGParserCtxtPtr rngctxt = NULL;
        PREINIT_SAVED_ERROR
#line 11709 "LibXML.c"
	xmlRelaxNGPtr	RETVAL;
#line 7336 "LibXML.xs"
        INIT_ERROR_HANDLER;

        rngctxt = xmlRelaxNGNewParserCtxt( url );
        if ( rngctxt == NULL ) {
            croak( "failed to initialize RelaxNG parser" );
        }
#ifndef WITH_SERRORS
        /* Register Error callbacks */
        xmlRelaxNGSetParserErrors( rngctxt,
                                  (xmlRelaxNGValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlRelaxNGValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );
#endif
        RETVAL = xmlRelaxNGParse( rngctxt );
        xmlRelaxNGFreeParserCtxt( rngctxt );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR((RETVAL == NULL) ? 0 : 1);
#line 11729 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_buffer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_buffer)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, perlstring");
    {
	SV *	perlstring = ST(1)
;
#line 7361 "LibXML.xs"
        const char * CLASS = "XML::LibXML::RelaxNG";
        xmlRelaxNGParserCtxtPtr rngctxt = NULL;
        char * string = NULL;
        STRLEN len    = 0;
        PREINIT_SAVED_ERROR
#line 11756 "LibXML.c"
	xmlRelaxNGPtr	RETVAL;
#line 7367 "LibXML.xs"
        string = SvPV( perlstring, len );
        if ( string == NULL ) {
            croak( "cannot parse empty string" );
        }
#line 11763 "LibXML.c"
#line 7372 "LibXML.xs"
        INIT_ERROR_HANDLER;

        rngctxt = xmlRelaxNGNewMemParserCtxt( string,len );
        if ( rngctxt == NULL ) {
            croak( "failed to initialize RelaxNG parser" );
        }
#ifndef WITH_SERRORS
        /* Register Error callbacks */
        xmlRelaxNGSetParserErrors( rngctxt,
                                  (xmlRelaxNGValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlRelaxNGValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );
#endif
        RETVAL = xmlRelaxNGParse( rngctxt );
        xmlRelaxNGFreeParserCtxt( rngctxt );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR((RETVAL == NULL) ? 0 : 1);
#line 11782 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_document); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RelaxNG_parse_document)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, doc");
    {
	xmlDocPtr	doc;
#line 7397 "LibXML.xs"
        const char * CLASS = "XML::LibXML::RelaxNG";
        xmlRelaxNGParserCtxtPtr rngctxt = NULL;
        PREINIT_SAVED_ERROR
#line 11806 "LibXML.c"
	xmlRelaxNGPtr	RETVAL;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            doc = INT2PTR(xmlDocPtr,PmmSvNode(ST(1)));
            if ( doc == NULL ) {
               croak( "XML::LibXML::RelaxNG::parse_document() -- doc contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::RelaxNG::parse_document() -- doc is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7401 "LibXML.xs"
        INIT_ERROR_HANDLER;

        rngctxt = xmlRelaxNGNewDocParserCtxt( doc );
        if ( rngctxt == NULL ) {
            croak( "failed to initialize RelaxNG parser" );
        }
#ifndef WITH_SERRORS
        /* Register Error callbacks */
        xmlRelaxNGSetParserErrors( rngctxt,
                                  (xmlRelaxNGValidityErrorFunc)  LibXML_error_handler_ctx,
                                  (xmlRelaxNGValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );
#endif
        RETVAL = xmlRelaxNGParse( rngctxt );
        xmlRelaxNGFreeParserCtxt( rngctxt );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR((RETVAL == NULL) ? 0 : 1);
#line 11839 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RelaxNG_validate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RelaxNG_validate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, doc");
    {
	xmlRelaxNGPtr	self;
	xmlDocPtr	doc;
#line 7426 "LibXML.xs"
        xmlRelaxNGValidCtxtPtr vctxt = NULL;
        PREINIT_SAVED_ERROR
#line 11863 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlRelaxNGPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::RelaxNG::validate() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            doc = INT2PTR(xmlDocPtr,PmmSvNode(ST(1)));
            if ( doc == NULL ) {
               croak( "XML::LibXML::RelaxNG::validate() -- doc contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else{
            croak( "XML::LibXML::RelaxNG::validate() -- doc is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7429 "LibXML.xs"
        INIT_ERROR_HANDLER;

        if (doc) {
            PmmClearPSVI(doc);
            PmmInvalidatePSVI(doc);
        }
        vctxt  = xmlRelaxNGNewValidCtxt( self );
        if ( vctxt == NULL ) {
            CLEANUP_ERROR_HANDLER;
            REPORT_ERROR(0);
            croak( "cannot initialize the validation context" );
        }
#ifndef WITH_SERRORS
        /* Register Error callbacks */
        xmlRelaxNGSetValidErrors( vctxt,
                                  (xmlRelaxNGValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlRelaxNGValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );
#endif /* WITH_SERRORS */
	/* ** test only **
          xmlRelaxNGSetValidErrors( vctxt,
                                    (xmlRelaxNGValidityErrorFunc)fprintf,
                                    (xmlRelaxNGValidityWarningFunc)fprintf,
                                    stderr );
	*/
        RETVAL = xmlRelaxNGValidateDoc( vctxt, doc );
        xmlRelaxNGFreeValidCtxt( vctxt );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if ( RETVAL == 1 ) {
            XSRETURN_UNDEF;
        }
        if ( RETVAL == -1 ) {
            croak( "API Error" );
            XSRETURN_UNDEF;
        }
#line 11924 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Schema_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Schema_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlSchemaPtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlSchemaPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Schema::DESTROY() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7475 "LibXML.xs"
        xmlSchemaFree( self );
#line 11949 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Schema_parse_location); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Schema_parse_location)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, url");
    {
	char *	url = (char *)SvPV_nolen(ST(1))
;
#line 7482 "LibXML.xs"
        const char * CLASS = "XML::LibXML::Schema";
        xmlSchemaParserCtxtPtr rngctxt = NULL;
        PREINIT_SAVED_ERROR
#line 11968 "LibXML.c"
	xmlSchemaPtr	RETVAL;
#line 7486 "LibXML.xs"
        INIT_ERROR_HANDLER;

        rngctxt = xmlSchemaNewParserCtxt( url );
        if ( rngctxt == NULL ) {
	    CLEANUP_ERROR_HANDLER;
            REPORT_ERROR(0);
            croak( "failed to initialize Schema parser" );
        }

        /* Register Error callbacks */
        xmlSchemaSetParserErrors( rngctxt,
                                  (xmlSchemaValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlSchemaValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );

        RETVAL = xmlSchemaParse( rngctxt );
        xmlSchemaFreeParserCtxt( rngctxt );
	CLEANUP_ERROR_HANDLER;
        REPORT_ERROR((RETVAL == NULL) ? 0 : 1);
#line 11990 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Schema_parse_buffer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Schema_parse_buffer)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, perlstring");
    {
	SV *	perlstring = ST(1)
;
#line 7513 "LibXML.xs"
        const char * CLASS = "XML::LibXML::Schema";
        xmlSchemaParserCtxtPtr rngctxt = NULL;
        char * string = NULL;
        STRLEN len    = 0;
        PREINIT_SAVED_ERROR
#line 12017 "LibXML.c"
	xmlSchemaPtr	RETVAL;
#line 7519 "LibXML.xs"
        string = SvPV( perlstring, len );
        if ( string == NULL ) {
            croak( "cannot parse empty string" );
        }
#line 12024 "LibXML.c"
#line 7524 "LibXML.xs"
        INIT_ERROR_HANDLER;

        rngctxt = xmlSchemaNewMemParserCtxt( string,len );
        if ( rngctxt == NULL ) {
	    CLEANUP_ERROR_HANDLER;
	    REPORT_ERROR(0);
            croak( "failed to initialize Schema parser" );
        }

        /* Register Error callbacks */
        xmlSchemaSetParserErrors( rngctxt,
                                  (xmlSchemaValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlSchemaValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );

        RETVAL = xmlSchemaParse( rngctxt );
        xmlSchemaFreeParserCtxt( rngctxt );
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR((RETVAL == NULL) ? 0 : 1);
#line 12045 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Schema_validate); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Schema_validate)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, node");
    {
	xmlSchemaPtr	self;
	xmlNodePtr	node;
#line 7552 "LibXML.xs"
        xmlSchemaValidCtxtPtr vctxt = NULL;
        PREINIT_SAVED_ERROR
#line 12069 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlSchemaPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Schema::validate() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Schema::validate() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Schema::validate() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 7555 "LibXML.xs"
        INIT_ERROR_HANDLER;

        if (node->type == XML_DOCUMENT_NODE) {
            PmmClearPSVI((xmlDocPtr)node);
            PmmInvalidatePSVI((xmlDocPtr)node);
        }
        vctxt  = xmlSchemaNewValidCtxt( self );
        if ( vctxt == NULL ) {
            CLEANUP_ERROR_HANDLER;
	    REPORT_ERROR(0);
            croak( "cannot initialize the validation context" );
        }

        /* Register Error callbacks */
        xmlSchemaSetValidErrors( vctxt,
                                  (xmlSchemaValidityErrorFunc)LibXML_error_handler_ctx,
                                  (xmlSchemaValidityWarningFunc)LibXML_error_handler_ctx,
                                  saved_error );

        if (node->type == XML_DOCUMENT_NODE) {
            RETVAL = xmlSchemaValidateDoc(vctxt, (xmlDocPtr)node);
        }
        else {
            RETVAL = xmlSchemaValidateOneElement(vctxt, node);
        }

        xmlSchemaFreeValidCtxt( vctxt );

        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if ( RETVAL > 0 ) {
            XSRETURN_UNDEF;
        }
        if ( RETVAL == -1 ) {
            croak( "API Error" );
            XSRETURN_UNDEF;
        }
#line 12131 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif /* HAVE_SCHEMAS */

XS_EUPXS(XS_XML__LibXML__XPathContext_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_new)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "CLASS, ...");
    {
	const char *	CLASS = (const char *)SvPV_nolen(ST(0))
;
#line 7605 "LibXML.xs"
        SV * pnode = &PL_sv_undef;
#line 12150 "LibXML.c"
	SV *	RETVAL;
#line 7607 "LibXML.xs"
        xmlXPathContextPtr ctxt;
#line 12154 "LibXML.c"
#line 7609 "LibXML.xs"
        if( items > 1 )
            pnode = ST(1);

        ctxt = xmlXPathNewContext( NULL );
        ctxt->namespaces = NULL;

        New(0, ctxt->user, sizeof(XPathContextData), XPathContextData);
        if (ctxt->user == NULL) {
            croak("XPathContext: failed to allocate proxy object\n");
        }

        if (SvOK(pnode)) {
          XPathContextDATA(ctxt)->node = newSVsv(pnode);
        } else {
          XPathContextDATA(ctxt)->node = &PL_sv_undef;
        }

        XPathContextDATA(ctxt)->pool = NULL;
        XPathContextDATA(ctxt)->varLookup = NULL;
        XPathContextDATA(ctxt)->varData = NULL;

        xmlXPathRegisterFunc(ctxt,
                             (const xmlChar *) "document",
                             perlDocumentFunction);

        RETVAL = NEWSV(0,0),
        RETVAL = sv_setref_pv( RETVAL,
                               CLASS,
                               (void*)ctxt );
#line 12185 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
#line 7645 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
#line 12204 "LibXML.c"
#line 7647 "LibXML.xs"
        xs_warn( "DESTROY XPATH CONTEXT" );
        if (ctxt) {
            if (XPathContextDATA(ctxt) != NULL) {
                if (XPathContextDATA(ctxt)->node != NULL &&
                    SvOK(XPathContextDATA(ctxt)->node)) {
                    SvREFCNT_dec(XPathContextDATA(ctxt)->node);
                }
                if (XPathContextDATA(ctxt)->varLookup != NULL &&
                    SvOK(XPathContextDATA(ctxt)->varLookup)) {
                    SvREFCNT_dec(XPathContextDATA(ctxt)->varLookup);
                }
                if (XPathContextDATA(ctxt)->varData != NULL &&
                    SvOK(XPathContextDATA(ctxt)->varData)) {
                    SvREFCNT_dec(XPathContextDATA(ctxt)->varData);
                }
                if (XPathContextDATA(ctxt)->pool != NULL &&
                    SvOK(XPathContextDATA(ctxt)->pool)) {
                    SvREFCNT_dec((SV *)XPathContextDATA(ctxt)->pool);
                }
                Safefree(XPathContextDATA(ctxt));
            }

            if (ctxt->namespaces != NULL) {
                xmlFree( ctxt->namespaces );
            }
            if (ctxt->funcLookupData != NULL && SvROK((SV*)ctxt->funcLookupData)
                && SvTYPE(SvRV((SV *)ctxt->funcLookupData)) == SVt_PVHV) {
                SvREFCNT_dec((SV *)ctxt->funcLookupData);
            }

            xmlXPathFreeContext(ctxt);
        }
#line 12238 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__XPathContext_getContextNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_getContextNode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 7684 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12259 "LibXML.c"
#line 7689 "LibXML.xs"
        if(XPathContextDATA(ctxt)->node != NULL) {
            RETVAL = newSVsv(XPathContextDATA(ctxt)->node);
        } else {
            RETVAL = &PL_sv_undef;
        }
#line 12266 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_getContextPosition); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_getContextPosition)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	int	RETVAL;
	dXSTARG;
#line 7701 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12290 "LibXML.c"
#line 7706 "LibXML.xs"
        RETVAL = ctxt->proximityPosition;
#line 12293 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_getContextSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_getContextSize)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	int	RETVAL;
	dXSTARG;
#line 7714 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12316 "LibXML.c"
#line 7719 "LibXML.xs"
        RETVAL = ctxt->contextSize;
#line 12319 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_setContextNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_setContextNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pnode");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	SV *	pnode = ST(1)
;
#line 7728 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12344 "LibXML.c"
#line 7733 "LibXML.xs"
        if (XPathContextDATA(ctxt)->node != NULL) {
            SvREFCNT_dec(XPathContextDATA(ctxt)->node);
        }
        if (SvOK(pnode)) {
            XPathContextDATA(ctxt)->node = newSVsv(pnode);
        } else {
            XPathContextDATA(ctxt)->node = NULL;
        }
#line 12354 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext_setContextPosition); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_setContextPosition)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, position");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	int	position = (int)SvIV(ST(1))
;
#line 7747 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL )
            croak("XPathContext: missing xpath context\n");
        if ( position < -1 || position > ctxt->contextSize )
	    croak("XPathContext: invalid position\n");
#line 12380 "LibXML.c"
#line 7753 "LibXML.xs"
        ctxt->proximityPosition = position;
#line 12383 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext_setContextSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_setContextSize)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, size");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	self = ST(0)
;
	int	size = (int)SvIV(ST(1))
;
#line 7760 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL )
            croak("XPathContext: missing xpath context\n");
        if ( size < -1 )
	    croak("XPathContext: invalid size\n");
#line 12409 "LibXML.c"
#line 7766 "LibXML.xs"
        ctxt->contextSize = size;
        if ( size == 0 )
	    ctxt->proximityPosition = 0;
	else if ( size > 0 )
	    ctxt->proximityPosition = 1;
        else
	    ctxt->proximityPosition = -1;
#line 12418 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext_registerNs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_registerNs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pxpath_context, prefix, ns_uri");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
	SV *	prefix = ST(1)
;
	SV *	ns_uri = ST(2)
;
#line 7780 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
#line 12442 "LibXML.c"
#line 7782 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
        LibXML_configure_xpathcontext(ctxt);
#line 12449 "LibXML.c"
#line 7788 "LibXML.xs"
        if(SvOK(ns_uri)) {
	    if(xmlXPathRegisterNs(ctxt, (xmlChar *) SvPV_nolen(prefix),
                                  (xmlChar *) SvPV_nolen(ns_uri)) == -1) {
                croak("XPathContext: cannot register namespace\n");
            }
        } else {
	    if(xmlXPathRegisterNs(ctxt, (xmlChar *) SvPV_nolen(prefix), NULL) == -1) {
                croak("XPathContext: cannot unregister namespace\n");
            }
        }
#line 12461 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext_lookupNs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_lookupNs)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pxpath_context, prefix");
    {
	SV *	pxpath_context = ST(0)
;
	SV *	prefix = ST(1)
;
#line 7804 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
#line 12481 "LibXML.c"
	SV *	RETVAL;
#line 7806 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
        LibXML_configure_xpathcontext(ctxt);
#line 12489 "LibXML.c"
#line 7812 "LibXML.xs"
        RETVAL = C2Sv(xmlXPathNsLookup(ctxt, (xmlChar *) SvPV_nolen(prefix)), NULL);
#line 12492 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_getVarLookupData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_getVarLookupData)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 7820 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12515 "LibXML.c"
#line 7825 "LibXML.xs"
        if(XPathContextDATA(ctxt)->varData != NULL) {
            RETVAL = newSVsv(XPathContextDATA(ctxt)->varData);
        } else {
            RETVAL = &PL_sv_undef;
        }
#line 12522 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_getVarLookupFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_getVarLookupFunc)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	SV *	self = ST(0)
;
	SV *	RETVAL;
#line 7837 "LibXML.xs"
        xmlXPathContextPtr ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(self)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12545 "LibXML.c"
#line 7842 "LibXML.xs"
        if(XPathContextDATA(ctxt)->varData != NULL) {
            RETVAL = newSVsv(XPathContextDATA(ctxt)->varLookup);
        } else {
            RETVAL = &PL_sv_undef;
        }
#line 12552 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathContext_registerVarLookupFunc); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_registerVarLookupFunc)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pxpath_context, lookup_func, lookup_data");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
	SV *	lookup_func = ST(1)
;
	SV *	lookup_data = ST(2)
;
#line 7856 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
        XPathContextDataPtr data = NULL;
#line 12578 "LibXML.c"
#line 7859 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL )
            croak("XPathContext: missing xpath context\n");
        data = XPathContextDATA(ctxt);
        if ( data == NULL )
            croak("XPathContext: missing xpath context private data\n");
        LibXML_configure_xpathcontext(ctxt);
        /* free previous lookup function and data */
        if (data->varLookup && SvOK(data->varLookup))
            SvREFCNT_dec(data->varLookup);
        if (data->varData && SvOK(data->varData))
            SvREFCNT_dec(data->varData);
        data->varLookup=NULL;
        data->varData=NULL;
#line 12594 "LibXML.c"
#line 7874 "LibXML.xs"
        if (SvOK(lookup_func)) {
            if ( SvROK(lookup_func) && SvTYPE(SvRV(lookup_func)) == SVt_PVCV ) {
		data->varLookup = newSVsv(lookup_func);
		if (SvOK(lookup_data))
		    data->varData = newSVsv(lookup_data);
		xmlXPathRegisterVariableLookup(ctxt,
					       LibXML_generic_variable_lookup, ctxt);
		if (ctxt->varLookupData==NULL || ctxt->varLookupData != ctxt) {
		    croak( "XPathContext: registration failure\n" );
		}
            } else {
                croak("XPathContext: 1st argument is not a CODE reference\n");
            }
        } else {
            /* unregister */
            xmlXPathRegisterVariableLookup(ctxt, NULL, NULL);
        }
#line 12613 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext_registerFunctionNS); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext_registerFunctionNS)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "pxpath_context, name, uri, func");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
	char *	name = (char *)SvPV_nolen(ST(1))
;
	SV *	uri = ST(2)
;
	SV *	func = ST(3)
;
#line 7899 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
        SV * pfdr;
        SV * key;
        STRLEN len;
        char *strkey;

#line 12644 "LibXML.c"
#line 7906 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
        LibXML_configure_xpathcontext(ctxt);
        if ( !SvOK(func) ||
             (SvOK(func) && ((SvROK(func) && SvTYPE(SvRV(func)) == SVt_PVCV )
                || SvPOK(func)))) {
            if (ctxt->funcLookupData == NULL) {
                if (SvOK(func)) {
                    pfdr = newRV_noinc((SV*) newHV());
                    ctxt->funcLookupData = pfdr;
                } else {
                    /* looks like no perl function was never registered, */
                    /* nothing to unregister */
                    warn("XPathContext: nothing to unregister\n");
                    return;
                }
            } else {
                if (SvTYPE(SvRV((SV *)ctxt->funcLookupData)) == SVt_PVHV) {
                    /* good, it's a HV */
                    pfdr = (SV *)ctxt->funcLookupData;
                } else {
                    croak ("XPathContext: cannot register: funcLookupData structure occupied\n");
                }
            }
            key = newSVpvn("",0);
            if (SvOK(uri)) {
                sv_catpv(key, "{");
                sv_catsv(key, uri);
                sv_catpv(key, "}");
            }
            sv_catpv(key, (const char*)name);
            strkey = SvPV(key, len);
            /* warn("Trying to store function '%s' in %d\n", strkey, pfdr); */
            if (SvOK(func)) {
                (void) hv_store((HV *)SvRV(pfdr),strkey, len, newSVsv(func), 0);
            } else {
                /* unregister */
                (void) hv_delete((HV *)SvRV(pfdr),strkey, len, G_DISCARD);
            }
            SvREFCNT_dec(key);
        } else {
            croak("XPathContext: 3rd argument is not a CODE reference or function name\n");
        }
#line 12691 "LibXML.c"
#line 7952 "LibXML.xs"
        if (SvOK(uri)) {
	    xmlXPathRegisterFuncNS(ctxt, (xmlChar *) name,
                                   (xmlChar *) SvPV(uri, len),
                                    (SvOK(func) ?
                                    LibXML_generic_extension_function : NULL));
        } else {
            xmlXPathRegisterFunc(ctxt, (xmlChar *) name,
                                 (SvOK(func) ?
                                 LibXML_generic_extension_function : NULL));
        }
#line 12703 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext__free_node_pool); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext__free_node_pool)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "pxpath_context");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
#line 7967 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
#line 12723 "LibXML.c"
#line 7969 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
#line 12729 "LibXML.c"
#line 7974 "LibXML.xs"
        if (XPathContextDATA(ctxt)->pool != NULL) {
            SvREFCNT_dec((SV *)XPathContextDATA(ctxt)->pool);
            XPathContextDATA(ctxt)->pool = NULL;
        }
#line 12735 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext__findnodes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext__findnodes)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "pxpath_context, perl_xpath");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
	SV *	perl_xpath = ST(1)
;
#line 7984 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
        ProxyNodePtr owner = NULL;
        xmlXPathObjectPtr found = NULL;
        xmlNodeSetPtr nodelist = NULL;
        SV * element = NULL ;
        xmlChar * xpath = NULL;
        xmlXPathCompExprPtr comp = NULL;
        PREINIT_SAVED_ERROR
#line 12764 "LibXML.c"
#line 7993 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
        LibXML_configure_xpathcontext(ctxt);
        if ( ctxt->node == NULL ) {
            croak("XPathContext: lost current node\n");
        }
        if (sv_isobject(perl_xpath) && sv_isa(perl_xpath,"XML::LibXML::XPathExpression")) {
             comp = INT2PTR(xmlXPathCompExprPtr,SvIV((SV*)SvRV( perl_xpath )));
             if (!comp) XSRETURN_UNDEF;
        } else {
            xpath = nodeSv2C(perl_xpath, ctxt->node);
            if ( !(xpath && xmlStrlen(xpath)) ) {
                if ( xpath )
                    xmlFree(xpath);
                croak("XPathContext: empty XPath found\n");
                XSRETURN_UNDEF;
            }
        }
#line 12786 "LibXML.c"
#line 8014 "LibXML.xs"
        INIT_ERROR_HANDLER;

        PUTBACK ;
        if (comp) {
          found = domXPathCompFindCtxt( ctxt, comp, 0 );
        } else {
	  found = domXPathFindCtxt( ctxt, xpath, 0 );
	  xmlFree(xpath);
        }
        SPAGAIN ;

        if (found != NULL) {
          nodelist = found->nodesetval;
        } else {
          nodelist = NULL;
        }
        CLEANUP_ERROR_HANDLER;
        if ( nodelist ) {
	    REPORT_ERROR(1);
            if ( nodelist->nodeNr > 0 ) {
                int i;
                const char * cls = "XML::LibXML::Node";
                xmlNodePtr tnode;
                int l = nodelist->nodeNr;
                for( i = 0  ; i < l; i++){
                    /* we have to create a new instance of an objectptr.
                     * and then place the current node into the new object.
                     * afterwards we can push the object to the array!
                     */
                    element = NULL;
                    tnode = nodelist->nodeTab[i];
                    if (tnode->type == XML_NAMESPACE_DECL) {
                        xmlNsPtr newns = xmlCopyNamespace((xmlNsPtr)tnode);
                        if ( newns != NULL ) {
                            element = NEWSV(0,0);
                            cls = PmmNodeTypeName( tnode );
                            element = sv_setref_pv( element,
                                                    (const char *)cls,
                                                    newns
                                                  );
                        }
                        else {
                            continue;
                        }
                    }
                    else {
                        if (tnode->doc) {
                            owner = PmmOWNERPO(PmmNewNode((xmlNodePtr) tnode->doc));
                        } else {
                            /* we try to find a known node on the ancestor axis */
                            xmlNodePtr n = tnode;
                            while (n && n->_private == NULL) n = n->parent;
                            if (n) owner = PmmOWNERPO(((ProxyNodePtr)n->_private));
                            else owner = NULL; /* self contained node */
                        }
                        element = PmmNodeToSv(tnode, owner);
                    }
                    XPUSHs( sv_2mortal(element) );
                }
            }
            /* prevent libxml2 from freeing the actual nodes */
            if (found->boolval) found->boolval=0;
            xmlXPathFreeObject(found);
        }
        else {
            xmlXPathFreeObject(found);
	    REPORT_ERROR(0);
        }
#line 12856 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__XPathContext__find); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathContext__find)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "pxpath_context, pxpath, to_bool");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV *	pxpath_context = ST(0)
;
	SV *	pxpath = ST(1)
;
	int	to_bool = (int)SvIV(ST(2))
;
#line 8089 "LibXML.xs"
        xmlXPathContextPtr ctxt = NULL;
        ProxyNodePtr owner = NULL;
        xmlXPathObjectPtr found = NULL;
        xmlNodeSetPtr nodelist = NULL;
        xmlChar * xpath = NULL;
        xmlXPathCompExprPtr comp = NULL;
        PREINIT_SAVED_ERROR
#line 12886 "LibXML.c"
#line 8097 "LibXML.xs"
        ctxt = INT2PTR(xmlXPathContextPtr,SvIV(SvRV(pxpath_context)));
        if ( ctxt == NULL ) {
            croak("XPathContext: missing xpath context\n");
        }
        LibXML_configure_xpathcontext(ctxt);
        if ( ctxt->node == NULL ) {
            croak("XPathContext: lost current node\n");
        }
        if (sv_isobject(pxpath) && sv_isa(pxpath,"XML::LibXML::XPathExpression")) {
             comp = INT2PTR(xmlXPathCompExprPtr,SvIV((SV*)SvRV( pxpath )));
             if (!comp) XSRETURN_UNDEF;
        } else {
            xpath = nodeSv2C(pxpath, ctxt->node);
            if ( !(xpath && xmlStrlen(xpath)) ) {
                if ( xpath )
                    xmlFree(xpath);
                croak("XPathContext: empty XPath found\n");
                XSRETURN_UNDEF;
            }
        }
#line 12908 "LibXML.c"
#line 8118 "LibXML.xs"
        INIT_ERROR_HANDLER;
        PUTBACK ;
        if (comp) {
          found = domXPathCompFindCtxt( ctxt, comp, to_bool );
        } else {
	  found = domXPathFindCtxt( ctxt, xpath, to_bool );
	  xmlFree(xpath);
        }
        SPAGAIN ;
        CLEANUP_ERROR_HANDLER;
        if (found) {
	    REPORT_ERROR(1);
            switch (found->type) {
                case XPATH_NODESET:
                    /* return as a NodeList */
                    /* access ->nodesetval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::NodeList", 0)));
                    nodelist = found->nodesetval;
                    if ( nodelist ) {
                        if ( nodelist->nodeNr > 0 ) {
                            int i;
                            const char * cls = "XML::LibXML::Node";
                            xmlNodePtr tnode;
                            SV * element;
                            int l = nodelist->nodeNr;

                            for( i = 0 ; i < l; i++){
                                /* we have to create a new instance of an
                                 * objectptr. and then
                                 * place the current node into the new
                                 * object. afterwards we can
                                 * push the object to the array!
                                 */
                                tnode = nodelist->nodeTab[i];

                                /* let's be paranoid */
                                if (tnode->type == XML_NAMESPACE_DECL) {
                                     xmlNsPtr newns = xmlCopyNamespace((xmlNsPtr)tnode);
                                    if ( newns != NULL ) {
                                        element = NEWSV(0,0);
                                        cls = PmmNodeTypeName( tnode );
                                        element = sv_setref_pv( element,
                                                                (const char *)cls,
                                                                (void*)newns
                                                          );
                                    }
                                    else {
                                        continue;
                                    }
                                }
                                else {
                                    if (tnode->doc) {
                                        owner = PmmOWNERPO(PmmNewNode((xmlNodePtr) tnode->doc));
                                    } else {
                                        /* we try to find a known node on the ancestor axis */
                                        xmlNodePtr n = tnode;
                                        while (n && n->_private == NULL) n = n->parent;
                                        if (n) owner = PmmOWNERPO(((ProxyNodePtr)n->_private));
                                        else owner = NULL;  /* self contained node */
                                    }
                                    element = PmmNodeToSv(tnode, owner);
                                }
                                XPUSHs( sv_2mortal(element) );
                            }
                        }
                    }
                    /* prevent libxml2 from freeing the actual nodes */
                    if (found->boolval) found->boolval=0;
                    break;
                case XPATH_BOOLEAN:
                    /* return as a Boolean */
                    /* access ->boolval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Boolean", 0)));
                    XPUSHs(sv_2mortal(newSViv(found->boolval)));
                    break;
                case XPATH_NUMBER:
                    /* return as a Number */
                    /* access ->floatval */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Number", 0)));
                    XPUSHs(sv_2mortal(newSVnv(found->floatval)));
                    break;
                case XPATH_STRING:
                    /* access ->stringval */
                    /* return as a Literal */
                    XPUSHs(sv_2mortal(newSVpv("XML::LibXML::Literal", 0)));
                    XPUSHs(sv_2mortal(C2Sv(found->stringval, NULL)));
                    break;
                default:
                    croak("Unknown XPath return type");
            }
            xmlXPathFreeObject(found);
        }
        else {
	    REPORT_ERROR(0);
        }
#line 13005 "LibXML.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_XML__LibXML__InputCallback_lib_cleanup_callbacks); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__InputCallback_lib_cleanup_callbacks)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 8219 "LibXML.xs"
        xmlCleanupInputCallbacks();
        xmlRegisterDefaultInputCallbacks();
#line 13022 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__InputCallback_lib_init_callbacks); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__InputCallback_lib_init_callbacks)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
#line 8225 "LibXML.xs"
        xmlRegisterDefaultInputCallbacks(); /* important */
        xmlRegisterInputCallbacks((xmlInputMatchCallback) LibXML_input_match,
                                  (xmlInputOpenCallback) LibXML_input_open,
                                  (xmlInputReadCallback) LibXML_input_read,
                                  (xmlInputCloseCallback) LibXML_input_close);
#line 13041 "LibXML.c"
    }
    XSRETURN_EMPTY;
}

#ifdef HAVE_READER_SUPPORT
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_XML__LibXML__Reader__newForFile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__newForFile)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "CLASS, filename, encoding, options");
    {
	const char*	CLASS = (const char *)SvPV_nolen(ST(0))
;
	const char*	filename = (const char *)SvPV_nolen(ST(1))
;
	const char *	encoding = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
	int	options = SvOK(ST(3)) ? SvIV(ST(3)) : 0;
	xmlTextReaderPtr	RETVAL;
#line 8242 "LibXML.xs"
        RETVAL = xmlReaderForFile(filename, encoding, options);
	INIT_READER_ERROR_HANDLER(RETVAL);
#line 13067 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__newForIO); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__newForIO)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "CLASS, fh, url, encoding, options");
    {
	const char*	CLASS = (const char *)SvPV_nolen(ST(0))
;
	SV *	fh = ST(1)
;
	const char *	url = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
	const char *	encoding = SvOK(ST(3)) ? SvPV_nolen(ST(3)) : NULL;
	int	options = SvOK(ST(4)) ? SvIV(ST(4)) : 0;
	xmlTextReaderPtr	RETVAL;
#line 8255 "LibXML.xs"
        (void)SvREFCNT_inc(fh); /* _dec'd by LibXML_close_perl */
        RETVAL = xmlReaderForIO((xmlInputReadCallback) LibXML_read_perl,
				(xmlInputCloseCallback) LibXML_close_perl,
				(void *) fh, url, encoding, options);
	INIT_READER_ERROR_HANDLER(RETVAL)
#line 13100 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__newForString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__newForString)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "CLASS, string, url, encoding, options");
    {
	const char*	CLASS = (const char *)SvPV_nolen(ST(0))
;
	SV *	string = ST(1)
;
	const char *	url = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
	const char *	encoding = SvOK(ST(3)) ? SvPV_nolen(ST(3)) : NULL;
	int	options = SvOK(ST(4)) ? SvIV(ST(4)) : 0;
	xmlTextReaderPtr	RETVAL;
#line 8271 "LibXML.xs"
        if (encoding == NULL && SvUTF8( string )) {
	  encoding = "UTF-8";
        }
        RETVAL = xmlReaderForDoc((xmlChar* )SvPV_nolen(string), url, encoding, options);
        INIT_READER_ERROR_HANDLER(RETVAL)
#line 13133 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__newForFd); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__newForFd)
{
    dVAR; dXSARGS;
    if (items != 5)
       croak_xs_usage(cv,  "CLASS, fd, url, encoding, options");
    {
	const char*	CLASS = (const char *)SvPV_nolen(ST(0))
;
	int	fd = (int)SvIV(ST(1))
;
	const char *	url = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
	const char *	encoding = SvOK(ST(3)) ? SvPV_nolen(ST(3)) : NULL;
	int	options = SvOK(ST(4)) ? SvIV(ST(4)) : 0;
	xmlTextReaderPtr	RETVAL;
#line 8287 "LibXML.xs"
        RETVAL = xmlReaderForFd(fd, url, encoding, options);
	INIT_READER_ERROR_HANDLER(RETVAL)
#line 13163 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__newForDOM); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__newForDOM)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, perl_doc");
    {
	const char*	CLASS = (const char *)SvPV_nolen(ST(0))
;
	SV *	perl_doc = ST(1)
;
	xmlTextReaderPtr	RETVAL;
#line 8297 "LibXML.xs"
        PmmREFCNT_inc(SvPROXYNODE(perl_doc)); /* _dec in DESTROY */
        RETVAL = xmlReaderWalker((xmlDocPtr) PmmSvNode(perl_doc));
#line 13190 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)CLASS, (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_attributeCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_attributeCount)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::attributeCount() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8306 "LibXML.xs"
	RETVAL = xmlTextReaderAttributeCount(reader);
#line 13222 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_baseURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_baseURI)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8314 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13239 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::baseURI() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8316 "LibXML.xs"
	result = xmlTextReaderConstBaseUri(reader);
	RETVAL = C2Sv(result, NULL);
#line 13252 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_byteConsumed); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_byteConsumed)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	long	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::byteConsumed() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8325 "LibXML.xs"
	RETVAL = xmlTextReaderByteConsumed(reader);
#line 13280 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_close() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8333 "LibXML.xs"
	RETVAL = xmlTextReaderClose(reader);
#line 13307 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_encoding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_encoding)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8341 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13324 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::encoding() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8343 "LibXML.xs"
	result = xmlTextReaderConstEncoding(reader);
	RETVAL = C2Sv(result, NULL);
#line 13337 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_localName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_localName)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8352 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13355 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::localName() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8354 "LibXML.xs"
	result = xmlTextReaderConstLocalName(reader);
	RETVAL = C2Sv(result, NULL);
#line 13368 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_name); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_name)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8363 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13386 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::name() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8365 "LibXML.xs"
	result = xmlTextReaderConstName(reader);
	RETVAL = C2Sv(result, NULL);
#line 13399 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_namespaceURI); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_namespaceURI)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8374 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13417 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::namespaceURI() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8376 "LibXML.xs"
	result = xmlTextReaderConstNamespaceUri(reader);
	RETVAL = C2Sv(result, NULL);
#line 13430 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_prefix); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_prefix)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8385 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13448 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::prefix() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8387 "LibXML.xs"
	result = xmlTextReaderConstPrefix(reader);
	RETVAL = C2Sv(result, NULL);
#line 13461 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_value); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_value)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8396 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13479 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::value() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8398 "LibXML.xs"
	result = xmlTextReaderConstValue(reader);
	RETVAL = C2Sv(result, NULL);
#line 13492 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_xmlLang); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_xmlLang)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8407 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13510 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::xmlLang() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8409 "LibXML.xs"
	result = xmlTextReaderConstXmlLang(reader);
	RETVAL = C2Sv(result, NULL);
#line 13523 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_xmlVersion); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_xmlVersion)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8419 "LibXML.xs"
	const xmlChar *result = NULL;
#line 13541 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::xmlVersion() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8421 "LibXML.xs"
	result = xmlTextReaderConstXmlVersion(reader);
	RETVAL = C2Sv(result, NULL);
#line 13554 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_depth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_depth)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::depth() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8431 "LibXML.xs"
	RETVAL = xmlTextReaderDepth(reader);
#line 13582 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_getAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_getAttribute)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, name");
    {
	xmlTextReaderPtr	reader;
	char *	name = (char *)SvPV_nolen(ST(1))
;
#line 8441 "LibXML.xs"
	xmlChar *result = NULL;
#line 13601 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::getAttribute() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8443 "LibXML.xs"
	result = xmlTextReaderGetAttribute(reader, (xmlChar*) name);
	RETVAL = C2Sv(result, NULL);
        xmlFree(result);
#line 13615 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_getAttributeNo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_getAttributeNo)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, no");
    {
	xmlTextReaderPtr	reader;
	int	no = (int)SvIV(ST(1))
;
#line 8454 "LibXML.xs"
	xmlChar *result = NULL;
#line 13635 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::getAttributeNo() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8456 "LibXML.xs"
	result = xmlTextReaderGetAttributeNo(reader, no);
	RETVAL = C2Sv(result, NULL);
        xmlFree(result);
#line 13649 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_getAttributeNs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_getAttributeNs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "reader, localName, namespaceURI");
    {
	xmlTextReaderPtr	reader;
	char *	localName = (char *)SvPV_nolen(ST(1))
;
	char *	namespaceURI = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
#line 8468 "LibXML.xs"
	xmlChar *result = NULL;
#line 13670 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::getAttributeNs() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8470 "LibXML.xs"
	result = xmlTextReaderGetAttributeNs(reader,  (xmlChar*) localName,
					     (xmlChar*) namespaceURI);
	RETVAL = C2Sv(result, NULL);
        xmlFree(result);
#line 13685 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_columnNumber); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_columnNumber)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::columnNumber() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8481 "LibXML.xs"
	RETVAL = xmlTextReaderGetParserColumnNumber(reader);
#line 13713 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_lineNumber); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_lineNumber)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::lineNumber() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8489 "LibXML.xs"
	RETVAL = xmlTextReaderGetParserLineNumber(reader);
#line 13740 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__getParserProp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__getParserProp)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, prop");
    {
	xmlTextReaderPtr	reader;
	int	prop = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_getParserProp() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8498 "LibXML.xs"
	RETVAL = xmlTextReaderGetParserProp(reader, prop);
#line 13769 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_hasAttributes); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_hasAttributes)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::hasAttributes() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8506 "LibXML.xs"
	RETVAL = xmlTextReaderHasAttributes(reader);
#line 13796 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_hasValue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_hasValue)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::hasValue() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8514 "LibXML.xs"
	RETVAL = xmlTextReaderHasValue(reader);
#line 13823 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_getAttributeHash); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_getAttributeHash)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8522 "LibXML.xs"
	HV* hv;
	SV* sv;
	const xmlChar* name;
	PREINIT_SAVED_ERROR
#line 13843 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::getAttributeHash() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8527 "LibXML.xs"
	INIT_ERROR_HANDLER;
	hv=newHV();
	if (xmlTextReaderHasAttributes(reader) && xmlTextReaderMoveToFirstAttribute(reader)==1) {
	  do {
	    name = xmlTextReaderConstName(reader);
	    sv=C2Sv((xmlTextReaderConstValue(reader)),NULL);
	    if (sv && hv_store(hv, (const char*) name, xmlStrlen(name), sv, 0)==NULL) {
	      SvREFCNT_dec(sv);  /* free if not needed by hv_stores */
	    }
	  } while (xmlTextReaderMoveToNextAttribute(reader)==1);
	  xmlTextReaderMoveToElement(reader);
	}
        RETVAL=newRV_noinc((SV*)hv);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 13869 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_isDefault); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_isDefault)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::isDefault() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8549 "LibXML.xs"
	RETVAL = xmlTextReaderIsDefault(reader);
#line 13897 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_isEmptyElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_isEmptyElement)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::isEmptyElement() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8557 "LibXML.xs"
	RETVAL = xmlTextReaderIsEmptyElement(reader);
#line 13924 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_isNamespaceDecl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_isNamespaceDecl)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::isNamespaceDecl() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8565 "LibXML.xs"
	RETVAL = xmlTextReaderIsNamespaceDecl(reader);
#line 13951 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_isValid); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_isValid)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::isValid() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8573 "LibXML.xs"
	RETVAL = xmlTextReaderIsValid(reader);
#line 13978 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_lookupNamespace); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_lookupNamespace)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, prefix");
    {
	xmlTextReaderPtr	reader;
	char *	prefix = SvOK(ST(1)) ? SvPV_nolen(ST(1)) : NULL;
#line 8582 "LibXML.xs"
	xmlChar *result = NULL;
#line 13996 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::lookupNamespace() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8584 "LibXML.xs"
	result = xmlTextReaderLookupNamespace(reader, (xmlChar*) prefix);
	RETVAL = C2Sv(result, NULL);
        xmlFree(result);
#line 14010 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToAttribute)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, name");
    {
	xmlTextReaderPtr	reader;
	char *	name = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToAttribute() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8596 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToAttribute(reader, (xmlChar*) name);
#line 14040 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToAttributeNo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToAttributeNo)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, no");
    {
	xmlTextReaderPtr	reader;
	int	no = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToAttributeNo() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8605 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToAttributeNo(reader, no);
#line 14069 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToAttributeNs); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToAttributeNs)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "reader, localName, namespaceURI");
    {
	xmlTextReaderPtr	reader;
	char *	localName = (char *)SvPV_nolen(ST(1))
;
	char *	namespaceURI = SvOK(ST(2)) ? SvPV_nolen(ST(2)) : NULL;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToAttributeNs() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8615 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToAttributeNs(reader,
						(xmlChar*) localName, (xmlChar*) namespaceURI);
#line 14100 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToElement)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToElement() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8624 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToElement(reader);
#line 14127 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToFirstAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToFirstAttribute)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToFirstAttribute() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8632 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToFirstAttribute(reader);
#line 14154 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_moveToNextAttribute); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_moveToNextAttribute)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::moveToNextAttribute() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8640 "LibXML.xs"
	RETVAL = xmlTextReaderMoveToNextAttribute(reader);
#line 14181 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_next); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_next)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8648 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14198 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::next() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8650 "LibXML.xs"
	INIT_ERROR_HANDLER;
	RETVAL = xmlTextReaderNext(reader);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14214 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#define LIBXML_READER_NEXT_SIBLING(ret,reader)	\
	ret = xmlTextReaderNextSibling(reader); \
        if (ret == -1)                          \
        {			                \
	  int depth;				\
          depth = xmlTextReaderDepth(reader);	\
	  ret = xmlTextReaderRead(reader);			   \
	  while (ret == 1 && xmlTextReaderDepth(reader) > depth) { \
	    ret = xmlTextReaderNext(reader);			   \
	  }							   \
	  if (ret == 1) {					   \
	    if (xmlTextReaderDepth(reader) != depth) {		   \
	      ret = 0;							\
	    } else if (xmlTextReaderNodeType(reader) == XML_READER_TYPE_END_ELEMENT) { \
	      ret = xmlTextReaderRead(reader);				\
	    }								\
	  }								\
        }

XS_EUPXS(XS_XML__LibXML__Reader_nextSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_nextSibling)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8680 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14249 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::nextSibling() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8682 "LibXML.xs"
	INIT_ERROR_HANDLER;
	LIBXML_READER_NEXT_SIBLING(RETVAL,reader)
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14265 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_nextSiblingElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_nextSiblingElement)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "reader, name = NULL, nsURI = NULL");
    {
	xmlTextReaderPtr	reader;
	const char *	name;
	const char *	nsURI;
#line 8695 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14284 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::nextSiblingElement() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    name = NULL;
	else {
	    name = (const char *)SvPV_nolen(ST(1))
;
	}

	if (items < 3)
	    nsURI = NULL;
	else {
	    nsURI = (const char *)SvPV_nolen(ST(2))
;
	}
#line 8697 "LibXML.xs"
	INIT_ERROR_HANDLER;
	do {
	  LIBXML_READER_NEXT_SIBLING(RETVAL,reader)
	  if (LIBXML_READER_TEST_ELEMENT(reader,name,nsURI)) {
	    break;
	  }
	} while (RETVAL == 1);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14319 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_nextElement); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_nextElement)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "reader, name = NULL, nsURI = NULL");
    {
	xmlTextReaderPtr	reader;
	const char *	name;
	const char *	nsURI;
#line 8715 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14338 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::nextElement() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    name = NULL;
	else {
	    name = (const char *)SvPV_nolen(ST(1))
;
	}

	if (items < 3)
	    nsURI = NULL;
	else {
	    nsURI = (const char *)SvPV_nolen(ST(2))
;
	}
#line 8717 "LibXML.xs"
	INIT_ERROR_HANDLER;
	do {
	  RETVAL = xmlTextReaderRead(reader);
	  if (LIBXML_READER_TEST_ELEMENT(reader,name,nsURI)) {
	    break;
	  }
	} while (RETVAL == 1);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14373 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_nextPatternMatch); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_nextPatternMatch)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, compiled");
    {
	xmlTextReaderPtr	reader;
	xmlPatternPtr	compiled;
#line 8734 "LibXML.xs"
	PREINIT_SAVED_ERROR
	xmlNodePtr node = NULL;
#line 14392 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::nextPatternMatch() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) && sv_isa(ST(1),"XML::LibXML::Pattern"))
            compiled = INT2PTR(xmlPatternPtr,SvIV((SV*)SvRV( ST(1) )));
    else{
            warn( "XML::LibXML::Reader::nextPatternMatch() -- compiled is not a XML::LibXML::Pattern" );
            XSRETURN_UNDEF;
    }
;
#line 8737 "LibXML.xs"
        if ( compiled == NULL )
	   croak("Usage: $reader->nextPatternMatch( a-XML::LibXML::Pattern-object )");
	do {
	  RETVAL = xmlTextReaderRead(reader);
          node = xmlTextReaderCurrentNode(reader);
	  if (node && xmlPatternMatch(compiled, node)) {
	    break;
	  }
	} while (RETVAL == 1);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14423 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_skipSiblings); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_skipSiblings)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8755 "LibXML.xs"
        int depth;
#line 14440 "LibXML.c"
#line 8757 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14443 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::skipSiblings() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8759 "LibXML.xs"
	INIT_ERROR_HANDLER;
        depth = xmlTextReaderDepth(reader);
        RETVAL = -1;
        if (depth > 0) {
          do {
   	     RETVAL = xmlTextReaderNext(reader);
	  } while (RETVAL == 1 && xmlTextReaderDepth(reader) >= depth);
	  if (xmlTextReaderNodeType(reader) != XML_READER_TYPE_END_ELEMENT) {
	    RETVAL = -1;
	  }
        }
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14468 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_nodeType); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_nodeType)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::nodeType() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8779 "LibXML.xs"
	RETVAL = xmlTextReaderNodeType(reader);
#line 14495 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_quoteChar); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_quoteChar)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8787 "LibXML.xs"
        int ret;
#line 14512 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::quoteChar() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8789 "LibXML.xs"
	ret = xmlTextReaderQuoteChar(reader);
        if (ret == -1) XSRETURN_UNDEF;
        RETVAL = newSVpvf("%c",ret);
#line 14526 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_read)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8799 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14544 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::read() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8801 "LibXML.xs"
	INIT_ERROR_HANDLER;
	RETVAL = xmlTextReaderRead(reader);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14560 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_readAttributeValue); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_readAttributeValue)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8812 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14577 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::readAttributeValue() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8814 "LibXML.xs"
	INIT_ERROR_HANDLER;
	RETVAL = xmlTextReaderReadAttributeValue(reader);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14593 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_readInnerXml); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_readInnerXml)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8826 "LibXML.xs"
	xmlChar *result = NULL;
#line 14610 "LibXML.c"
#line 8828 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14613 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::readInnerXml() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8830 "LibXML.xs"
	INIT_ERROR_HANDLER;
	result = xmlTextReaderReadInnerXml(reader);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
        if (!result) XSRETURN_UNDEF;
	RETVAL = C2Sv(result, NULL);
        xmlFree(result);
#line 14631 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_readOuterXml); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_readOuterXml)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8844 "LibXML.xs"
	xmlChar *result = NULL;
#line 14649 "LibXML.c"
#line 8846 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14652 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::readOuterXml() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8848 "LibXML.xs"
	INIT_ERROR_HANDLER;
	result = xmlTextReaderReadOuterXml(reader);
	CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
        if (result) {
	  RETVAL = C2Sv(result, NULL);
	  xmlFree(result);
	} else {
           XSRETURN_UNDEF;
	}
#line 14673 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_readState); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_readState)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::readState() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8865 "LibXML.xs"
	RETVAL = xmlTextReaderReadState(reader);
#line 14701 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__setParserProp); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__setParserProp)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "reader, prop, value");
    {
	xmlTextReaderPtr	reader;
	int	prop = (int)SvIV(ST(1))
;
	int	value = (int)SvIV(ST(2))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_setParserProp() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8875 "LibXML.xs"
	RETVAL = xmlTextReaderSetParserProp(reader, prop, value);
#line 14732 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_standalone); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_standalone)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::standalone() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8883 "LibXML.xs"
	RETVAL = xmlTextReaderStandalone(reader);
#line 14759 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__nodePath); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__nodePath)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8891 "LibXML.xs"
	xmlNodePtr node = NULL;
        xmlChar * path = NULL;
#line 14777 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_nodePath() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8894 "LibXML.xs"
        node = xmlTextReaderCurrentNode(reader);
        if ( node ==NULL ) {
          XSRETURN_UNDEF;
	}
	path = xmlGetNodePath( node );
        if ( path == NULL ) {
          XSRETURN_UNDEF;
        }
        RETVAL = C2Sv(path,NULL);
	xmlFree(path);
#line 14798 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef LIBXML_PATTERN_ENABLED
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_XML__LibXML__Reader_matchesPattern); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_matchesPattern)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, compiled");
    {
	xmlTextReaderPtr	reader;
	xmlPatternPtr	compiled;
#line 8914 "LibXML.xs"
	xmlNodePtr node = NULL;
#line 14820 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::matchesPattern() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) && sv_isa(ST(1),"XML::LibXML::Pattern"))
            compiled = INT2PTR(xmlPatternPtr,SvIV((SV*)SvRV( ST(1) )));
    else{
            warn( "XML::LibXML::Reader::matchesPattern() -- compiled is not a XML::LibXML::Pattern" );
            XSRETURN_UNDEF;
    }
;
#line 8916 "LibXML.xs"
        if ( compiled == NULL )
	   XSRETURN_UNDEF;
        node = xmlTextReaderCurrentNode(reader);
        if ( node ==NULL ) {
          XSRETURN_UNDEF;
	}
	RETVAL = xmlPatternMatch(compiled, node);
#line 14847 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif /* LIBXML_PATTERN_ENABLED */

XS_EUPXS(XS_XML__LibXML__Reader_copyCurrentNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_copyCurrentNode)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "reader, expand = 0");
    {
	xmlTextReaderPtr	reader;
	int	expand;
#line 8933 "LibXML.xs"
	xmlNodePtr node = NULL;
	xmlNodePtr copy;
        xmlDocPtr  doc = NULL;
        ProxyNodePtr proxy;
#line 14869 "LibXML.c"
#line 8938 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 14872 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::copyCurrentNode() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 2)
	    expand = 0;
	else {
	    expand = (int)SvIV(ST(1))
;
	}
#line 8940 "LibXML.xs"
	INIT_ERROR_HANDLER;
	if (expand) {
	  node = xmlTextReaderExpand(reader);
        }
	else {
	  node = xmlTextReaderCurrentNode(reader);
	}
        if (node) {
	  doc = xmlTextReaderCurrentDoc(reader);
        }
        if (!doc) {
          CLEANUP_ERROR_HANDLER;
	  REPORT_ERROR(0);
          XSRETURN_UNDEF;
	}
        if (xmlTextReaderGetParserProp(reader,XML_PARSER_VALIDATE))
            PmmInvalidatePSVI(doc); /* the document may have psvi info */

        copy = PmmCloneNode( node, expand );
        if ( copy == NULL ) {
            CLEANUP_ERROR_HANDLER;
	    REPORT_ERROR(0);
            XSRETURN_UNDEF;
        }
        if ( copy->type  == XML_DTD_NODE ) {
            RETVAL = PmmNodeToSv(copy, NULL);
        }
        else {
	    ProxyNodePtr docfrag = NULL;

            if ( doc != NULL ) {
                xmlSetTreeDoc(copy, doc);
            }
            proxy = PmmNewNode((xmlNodePtr)doc);
            if (PmmREFCNT(proxy) == 0) {
                PmmREFCNT_inc(proxy);
            }
            LibXML_set_reader_preserve_flag(reader);

            docfrag = PmmNewFragment( doc );
            xmlAddChild( PmmNODE(docfrag), copy );
            RETVAL = PmmNodeToSv(copy, docfrag);
        }
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
#line 14935 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_document); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_document)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 8992 "LibXML.xs"
	xmlDocPtr doc = NULL;
#line 14953 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::document() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 8994 "LibXML.xs"
	doc = xmlTextReaderCurrentDoc(reader);
        if (!doc) XSRETURN_UNDEF;
        RETVAL = PmmNodeToSv((xmlNodePtr)doc, NULL);
        /* FIXME: taint the document with PmmInvalidatePSVI if the reader did validation */
        if ( PmmREFCNT(SvPROXYNODE(RETVAL))==1 ) {
	  /* will be decremented in Reader destructor */
	  PmmREFCNT_inc(SvPROXYNODE(RETVAL));
	}
        if (xmlTextReaderGetParserProp(reader,XML_PARSER_VALIDATE))
            PmmInvalidatePSVI(doc); /* the document may have psvi info */

        LibXML_set_reader_preserve_flag(reader);

#line 14977 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__preservePattern); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__preservePattern)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "reader, pattern, ns_map=NULL");
    {
	xmlTextReaderPtr	reader;
	char *	pattern = (char *)SvPV_nolen(ST(1))
;
	AV *	ns_map;
#line 9016 "LibXML.xs"
        xmlChar** namespaces = NULL;
	SV** aux;
        int last,i;
#line 15000 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_preservePattern() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

	if (items < 3)
	    ns_map = NULL;
	else {
	    STMT_START {
		    SV* const xsub_tmp_sv = ST(2);
		    SvGETMAGIC(xsub_tmp_sv);
		    if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
			ns_map = (AV*)SvRV(xsub_tmp_sv);
		    }
		    else{
			Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				    "XML::LibXML::Reader::_preservePattern",
				    "ns_map");
		    }
	    } STMT_END
;
	}
#line 9020 "LibXML.xs"
        if (ns_map) {
          last = av_len(ns_map);
          New(0,namespaces, last+2, xmlChar*);
          for( i = 0; i <= last ; i++ ) {
              aux = av_fetch(ns_map,i,0);
	      namespaces[i]=(xmlChar*) SvPV_nolen(*aux);
          }
	  namespaces[i]=0;
	}
	RETVAL = xmlTextReaderPreservePattern(reader,(const xmlChar*) pattern,
					      (const xmlChar**)namespaces);
        Safefree(namespaces);
#line 15042 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_preserveNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_preserveNode)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 9039 "LibXML.xs"
        xmlNodePtr node;
        xmlDocPtr doc;
        ProxyNodePtr proxy;
	PREINIT_SAVED_ERROR
#line 15062 "LibXML.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::preserveNode() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9044 "LibXML.xs"
	INIT_ERROR_HANDLER;
	doc = xmlTextReaderCurrentDoc(reader);
        if (!doc) {
	  CLEANUP_ERROR_HANDLER;
	  REPORT_ERROR(0);
	  XSRETURN_UNDEF;
	}
    proxy = PmmNewNode((xmlNodePtr)doc);
    if ( PmmREFCNT(proxy) == 0 ) {
	  /* new proxy node */
	  PmmREFCNT_inc(proxy);
	}
        LibXML_set_reader_preserve_flag(reader);

	node = xmlTextReaderPreserve(reader);
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
        if (node) {
           RETVAL = PmmNodeToSv(node, proxy);
	} else {
	    XSRETURN_UNDEF;
	}
#line 15095 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader_finish); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader_finish)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 9073 "LibXML.xs"
	PREINIT_SAVED_ERROR
#line 15113 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::finish() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9075 "LibXML.xs"
	INIT_ERROR_HANDLER;
	while (1) {
	  RETVAL = xmlTextReaderRead(reader);
	  if (RETVAL!=1) break;
	}
        CLEANUP_ERROR_HANDLER;
	REPORT_ERROR(0);
        RETVAL++; /* we want 0 - fail, 1- success */
#line 15133 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef HAVE_SCHEMAS
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_XML__LibXML__Reader__setRelaxNGFile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__setRelaxNGFile)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, rng");
    {
	xmlTextReaderPtr	reader;
	char*	rng = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_setRelaxNGFile() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9093 "LibXML.xs"
	RETVAL = xmlTextReaderRelaxNGValidate(reader,rng);
#line 15165 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__setRelaxNG); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__setRelaxNG)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, rng_doc");
    {
	xmlTextReaderPtr	reader;
	xmlRelaxNGPtr	rng_doc;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_setRelaxNG() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) )
            rng_doc = INT2PTR(xmlRelaxNGPtr,SvIV((SV*)SvRV( ST(1) )));
    else{
            warn( "XML::LibXML::Reader::_setRelaxNG() -- rng_doc is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9102 "LibXML.xs"
	RETVAL = xmlTextReaderRelaxNGSetSchema(reader,rng_doc);
#line 15201 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__setXSDFile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__setXSDFile)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, xsd");
    {
	xmlTextReaderPtr	reader;
	char*	xsd = (char *)SvPV_nolen(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_setXSDFile() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9111 "LibXML.xs"
	RETVAL = xmlTextReaderSchemaValidate(reader,xsd);
#line 15230 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Reader__setXSD); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__setXSD)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "reader, xsd_doc");
    {
	xmlTextReaderPtr	reader;
	xmlSchemaPtr	xsd_doc;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_setXSD() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) )
            xsd_doc = INT2PTR(xmlSchemaPtr,SvIV((SV*)SvRV( ST(1) )));
    else{
            warn( "XML::LibXML::Reader::_setXSD() -- xsd_doc is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9120 "LibXML.xs"
	RETVAL =  xmlTextReaderSetSchema(reader,xsd_doc);
#line 15266 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#endif /* HAVE_SCHEMAS */

XS_EUPXS(XS_XML__LibXML__Reader__DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Reader__DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "reader");
    {
	xmlTextReaderPtr	reader;
#line 9130 "LibXML.xs"
        xmlDocPtr doc;
        ProxyNodePtr proxy;
	/* SV * error_sv = NULL;
           xmlTextReaderErrorFunc f = NULL; */
#line 15287 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            reader = INT2PTR(xmlTextReaderPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Reader::_DESTROY() -- reader is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9136 "LibXML.xs"
    if ( LibXML_get_reader_preserve_flag(reader) ) {
        doc = xmlTextReaderCurrentDoc(reader);
        if (doc) {
            proxy = PmmNewNode((xmlNodePtr)doc);
            if ( PmmREFCNT(proxy) == 0 ) {
                PmmREFCNT_inc(proxy);
            }
            PmmREFCNT_dec(proxy);
        }
    }
        if (xmlTextReaderReadState(reader) != XML_TEXTREADER_MODE_CLOSED) {
	  xmlTextReaderClose(reader);
	}
        /* xmlTextReaderGetErrorHandler(reader, &f, (void **) &error_sv);
        if (error_sv) {
           sv_2mortal(error_sv);
	} */
	xmlFreeTextReader(reader);
#line 15315 "LibXML.c"
    }
    XSRETURN_EMPTY;
}

#endif /* HAVE_READER_SUPPORT */
#ifdef WITH_SERRORS
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_XML__LibXML__LibError_domain); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_domain)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::domain() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9165 "LibXML.xs"
        RETVAL = self->domain;
#line 15345 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_code); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_code)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::code() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9173 "LibXML.xs"
        RETVAL = self->code;
#line 15372 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_line); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_line)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::line() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9181 "LibXML.xs"
        RETVAL = self->line;
#line 15399 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_num1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_num1)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::num1() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9191 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = self->int1;
#line 15428 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_num2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_num2)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::num2() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9202 "LibXML.xs"
        PERL_UNUSED_VAR(ix);
        RETVAL = self->int2;
#line 15457 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_level); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_level)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::level() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9211 "LibXML.xs"
        RETVAL = (int)self->level;
#line 15484 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_message); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_message)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::message() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9219 "LibXML.xs"
        RETVAL = self->message;
#line 15511 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_file); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_file)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::file() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9227 "LibXML.xs"
        RETVAL = (char*)self->file;
#line 15538 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_str1); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_str1)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::str1() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9235 "LibXML.xs"
        RETVAL = (char*)self->str1;
#line 15565 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_str2); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_str2)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::str2() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9243 "LibXML.xs"
        RETVAL = (char*)self->str2;
#line 15592 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_str3); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_str3)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlErrorPtr	self;
	char *	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::str3() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9251 "LibXML.xs"
        RETVAL = (char*)self->str3;
#line 15619 "LibXML.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__LibError_context_and_column); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__LibError_context_and_column)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	xmlErrorPtr	self;
#line 9259 "LibXML.xs"
        xmlParserInputPtr input;
	const xmlChar *cur, *base, *col_cur;
	unsigned int n, col;	/* GCC warns if signed, because compared with sizeof() */
	xmlChar  content[81]; /* space for 80 chars + line terminator */
	xmlChar *ctnt;
	int domain;
        xmlParserCtxtPtr ctxt = NULL;
#line 15644 "LibXML.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            self = INT2PTR(xmlErrorPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::LibError::context_and_column() -- self is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9267 "LibXML.xs"
	domain = self->domain;
	if ((domain == XML_FROM_PARSER) || (domain == XML_FROM_HTML) ||
	    (domain == XML_FROM_DTD) || (domain == XML_FROM_NAMESPACE) ||
	    (domain == XML_FROM_IO) || (domain == XML_FROM_VALID)) {
	  ctxt = (xmlParserCtxtPtr) self->ctxt;
	}
       if (ctxt == NULL) XSRETURN_EMPTY;
       input = ctxt->input;
       if ((input != NULL) && (input->filename == NULL) &&
            (ctxt->inputNr > 1)) {
            input = ctxt->inputTab[ctxt->inputNr - 2];
        }
        if (input == NULL) XSRETURN_EMPTY;
	cur = input->cur;
	base = input->base;
	/* skip backwards over any end-of-lines */
	while ((cur > base) && ((*(cur) == '\n') || (*(cur) == '\r'))) {
	  cur--;
	}
        n = 0;
        /* search backwards for beginning-of-line (to max buff size) */
        while ((n++ < (sizeof(content)-1)) && (cur > base) &&
	       (*(cur) != '\n') && (*(cur) != '\r'))
	  cur--;
	/* search backwards for beginning-of-line for calculating the
	 * column. */
	col_cur = cur;
	while ((col_cur > base) && (*(col_cur) != '\n') && (*(col_cur) != '\r'))
	  col_cur--;
	if ((*(cur) == '\n') || (*(cur) == '\r')) cur++;
	if ((*(col_cur) == '\n') || (*(col_cur) == '\r')) col_cur++;
	/* calculate the error position in terms of the current position */
	col = input->cur - col_cur;
	/* search forward for end-of-line (to max buff size) */
	n = 0;
	ctnt = content;
	/* copy selected text to our buffer */
	while ((*cur != 0) && (*(cur) != '\n') &&
	       (*(cur) != '\r') && (n < sizeof(content)-1)) {
	  *ctnt++ = *cur++;
	  n++;
	}
	*ctnt = 0;
        EXTEND(SP,2);
        PUSHs(sv_2mortal(C2Sv(content, NULL)));
        PUSHs(sv_2mortal(newSViv(col)));
#line 15700 "LibXML.c"
	PUTBACK;
	return;
    }
}

#endif /* WITH_SERRORS */
#ifdef LIBXML_PATTERN_ENABLED
#define XSubPPtmpAAAF 1


XS_EUPXS(XS_XML__LibXML__Pattern__compilePattern); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Pattern__compilePattern)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "CLASS, ppattern, pattern_type, ns_map=NULL");
    {
	SV *	ppattern = ST(1)
;
	AV *	ns_map;
	int	pattern_type = (int)SvIV(ST(2))
;
#line 9327 "LibXML.xs"
        xmlChar * pattern = Sv2C(ppattern, NULL);
        xmlChar** namespaces = NULL;
	SV** aux;
        int last,i;
	PREINIT_SAVED_ERROR
#line 15729 "LibXML.c"
	xmlPatternPtr	RETVAL;

	if (items < 4)
	    ns_map = NULL;
	else {
	    STMT_START {
		    SV* const xsub_tmp_sv = ST(3);
		    SvGETMAGIC(xsub_tmp_sv);
		    if (SvROK(xsub_tmp_sv) && SvTYPE(SvRV(xsub_tmp_sv)) == SVt_PVAV){
			ns_map = (AV*)SvRV(xsub_tmp_sv);
		    }
		    else{
			Perl_croak_nocontext("%s: %s is not an ARRAY reference",
				    "XML::LibXML::Pattern::_compilePattern",
				    "ns_map");
		    }
	    } STMT_END
;
	}
#line 9333 "LibXML.xs"
        if ( pattern == NULL )
	   XSRETURN_UNDEF;
        if (ns_map) {
          last = av_len(ns_map);
          New(0,namespaces, last+2, xmlChar*);
          for( i = 0; i <= last ; i++ ) {
              aux = av_fetch(ns_map,i,0);
	      namespaces[i]=(xmlChar*) SvPV_nolen(*aux);
          }
	  namespaces[i]=0;
	}
	INIT_ERROR_HANDLER;
	RETVAL = xmlPatterncompile(pattern, NULL, pattern_type, (const xmlChar **) namespaces);
        Safefree(namespaces);
        xmlFree( pattern );
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if ( RETVAL == NULL ) {
	  croak("Compilation of pattern failed");
	}
#line 15770 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)"XML::LibXML::Pattern", (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Pattern_matchesNode); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Pattern_matchesNode)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, node");
    {
	xmlPatternPtr	self;
	xmlNodePtr	node;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::Pattern"))
            self = INT2PTR(xmlPatternPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Pattern::matchesNode() -- self is not a XML::LibXML::Pattern" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(1)) && (SvTYPE(SvRV(ST(1))) == SVt_PVMG) ) {
            node = INT2PTR(xmlNodePtr,PmmSvNode(ST(1)));
            if ( node == NULL ) {
               croak( "XML::LibXML::Pattern::matchesNode() -- node contains no data" );
               XSRETURN_UNDEF;
            }
    }
    else {
            croak( "XML::LibXML::Pattern::matchesNode() -- node is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 9361 "LibXML.xs"
        if ( node ==NULL ) {
          XSRETURN_UNDEF;
	}
	RETVAL = xmlPatternMatch(self, node);
#line 15819 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Pattern_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Pattern_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlPatternPtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::Pattern"))
            self = INT2PTR(xmlPatternPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::Pattern::DESTROY() -- self is not a XML::LibXML::Pattern" );
            XSRETURN_UNDEF;
    }
;
#line 9372 "LibXML.xs"
        xs_warn( "DESTROY PATTERN OBJECT" );
   	xmlFreePattern(self);
#line 15845 "LibXML.c"
    }
    XSRETURN_EMPTY;
}

#endif /* LIBXML_PATTERN_ENABLED */
#ifdef LIBXML_REGEXP_ENABLED
#define XSubPPtmpAAAG 1


XS_EUPXS(XS_XML__LibXML__RegExp__compile); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RegExp__compile)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, pregexp");
    {
	SV *	pregexp = ST(1)
;
#line 9385 "LibXML.xs"
        xmlChar * regexp = Sv2C(pregexp, NULL);
	PREINIT_SAVED_ERROR
#line 15867 "LibXML.c"
	xmlRegexpPtr	RETVAL;
#line 9388 "LibXML.xs"
        if ( regexp == NULL )
	   XSRETURN_UNDEF;
	INIT_ERROR_HANDLER;
	RETVAL = xmlRegexpCompile(regexp);
        xmlFree( regexp );
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if ( RETVAL == NULL ) {
	  croak("Compilation of regexp failed");
	}
#line 15880 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)"XML::LibXML::RegExp", (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RegExp_matches); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RegExp_matches)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, pvalue");
    {
	xmlRegexpPtr	self;
	SV*	pvalue = ST(1)
;
#line 9406 "LibXML.xs"
        xmlChar * value = Sv2C(pvalue, NULL);
#line 15904 "LibXML.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::RegExp"))
            self = INT2PTR(xmlRegexpPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::RegExp::matches() -- self is not a XML::LibXML::RegExp" );
            XSRETURN_UNDEF;
    }
;
#line 9408 "LibXML.xs"
        if ( value == NULL )
	   XSRETURN_UNDEF;
	RETVAL = xmlRegexpExec(self,value);
        xmlFree( value );
#line 15920 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RegExp_isDeterministic); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RegExp_isDeterministic)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlRegexpPtr	self;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::RegExp"))
            self = INT2PTR(xmlRegexpPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::RegExp::isDeterministic() -- self is not a XML::LibXML::RegExp" );
            XSRETURN_UNDEF;
    }
;
#line 9419 "LibXML.xs"
	RETVAL = xmlRegexpIsDeterminist(self);
#line 15947 "LibXML.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__RegExp_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__RegExp_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlRegexpPtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::RegExp"))
            self = INT2PTR(xmlRegexpPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::RegExp::DESTROY() -- self is not a XML::LibXML::RegExp" );
            XSRETURN_UNDEF;
    }
;
#line 9427 "LibXML.xs"
        xs_warn( "DESTROY REGEXP OBJECT" );
   	xmlRegFreeRegexp(self);
#line 15973 "LibXML.c"
    }
    XSRETURN_EMPTY;
}

#endif /* LIBXML_REGEXP_ENABLED */

XS_EUPXS(XS_XML__LibXML__XPathExpression_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathExpression_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, pxpath");
    {
	SV *	pxpath = ST(1)
;
#line 9439 "LibXML.xs"
        xmlChar * xpath = Sv2C(pxpath, NULL);
        PREINIT_SAVED_ERROR
#line 15992 "LibXML.c"
	xmlXPathCompExprPtr	RETVAL;
#line 9442 "LibXML.xs"
        if ( pxpath == NULL )
	   XSRETURN_UNDEF;
	INIT_ERROR_HANDLER;
	RETVAL = xmlXPathCompile( xpath );
        xmlFree( xpath );
        CLEANUP_ERROR_HANDLER;
        REPORT_ERROR(0);
        if ( RETVAL == NULL ) {
	  croak("Compilation of XPath expression failed!");
	}
#line 16005 "LibXML.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv( RETVALSV, (char *)"XML::LibXML::XPathExpression", (void*)RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__XPathExpression_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__XPathExpression_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	xmlXPathCompExprPtr	self;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) && sv_isa(ST(0),"XML::LibXML::XPathExpression"))
            self = INT2PTR(xmlXPathCompExprPtr,SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "XML::LibXML::XPathExpression::DESTROY() -- self is not a XML::LibXML::XPathExpression" );
            XSRETURN_UNDEF;
    }
;
#line 9459 "LibXML.xs"
        xs_warn( "DESTROY COMPILED XPATH OBJECT" );
        xmlXPathFreeCompExpr(self);
#line 16036 "LibXML.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_XML__LibXML__Common_encodeToUTF8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Common_encodeToUTF8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "encoding, string");
    {
	const char *	encoding = (const char *)SvPV_nolen(ST(0))
;
	SV *	string = ST(1)
;
#line 9471 "LibXML.xs"
        xmlChar * realstring = NULL;
        xmlChar * tstr = NULL;
        xmlCharEncoding enc = 0;
        STRLEN len = 0;
        xmlBufferPtr in = NULL, out = NULL;
        xmlCharEncodingHandlerPtr coder = NULL;
	PREINIT_SAVED_ERROR
#line 16061 "LibXML.c"
	SV *	RETVAL;
#line 9479 "LibXML.xs"
        if (!SvOK(string)) {
            XSRETURN_UNDEF;
        } else if (!SvCUR(string)) {
            XSRETURN_PV("");
        }
        realstring = (xmlChar*) SvPV(string, len);
        if ( realstring != NULL ) {
            /* warn("encode %s", realstring ); */
#ifdef HAVE_UTF8
            if ( !DO_UTF8(string) && encoding != NULL ) {
#else
            if ( encoding != NULL ) {
#endif
                enc = xmlParseCharEncoding( encoding );

                if ( enc == 0 ) {
                    /* this happens if the encoding is "" or NULL */
                    enc = XML_CHAR_ENCODING_UTF8;
                }

                if ( enc == XML_CHAR_ENCODING_UTF8 ) {
                    /* copy the string */
                    /* warn( "simply copy the string" ); */
                    tstr = xmlStrndup( realstring, len );
                }
                else {
                    INIT_ERROR_HANDLER;
                    if ( enc > 1 ) {
                        coder= xmlGetCharEncodingHandler( enc );
                    }
                    else if ( enc == XML_CHAR_ENCODING_ERROR ){
                        coder =xmlFindCharEncodingHandler( encoding );
                    }
                    else {
                        croak("no encoder found\n");
                    }
                    if ( coder == NULL ) {
                        croak( "cannot encode string" );
                    }
                    in    = xmlBufferCreateStatic((void*)realstring, len );
                    out   = xmlBufferCreate();
                    if ( xmlCharEncInFunc( coder, out, in ) >= 0 ) {
                        tstr = xmlStrdup( out->content );
                    }

                    xmlBufferFree( in );
                    xmlBufferFree( out );
                    xmlCharEncCloseFunc( coder );

                    CLEANUP_ERROR_HANDLER;
                    REPORT_ERROR(0);
                }
            }
            else {
                tstr = xmlStrndup( realstring, len );
            }

            if ( !tstr ) {
                croak( "return value missing!" );
            }

            len = xmlStrlen( tstr );
            RETVAL = newSVpvn( (const char *)tstr, len );
#ifdef HAVE_UTF8
            SvUTF8_on(RETVAL);
#endif
            xmlFree(tstr);
        }
        else {
            XSRETURN_UNDEF;
        }
#line 16135 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_XML__LibXML__Common_decodeFromUTF8); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_XML__LibXML__Common_decodeFromUTF8)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "encoding, string");
    {
	const char *	encoding = (const char *)SvPV_nolen(ST(0))
;
	SV*	string = ST(1)
;
#line 9558 "LibXML.xs"
        xmlChar * tstr = NULL;
        xmlChar * realstring = NULL;
        xmlCharEncoding enc = 0;
        STRLEN len = 0;
        xmlBufferPtr in = NULL, out = NULL;
        xmlCharEncodingHandlerPtr coder = NULL;
	PREINIT_SAVED_ERROR
#line 16162 "LibXML.c"
	SV *	RETVAL;
#line 9566 "LibXML.xs"
#ifdef HAVE_UTF8
        if ( !SvOK(string) ) {
            XSRETURN_UNDEF;
        } else if (!SvCUR(string)) {
            XSRETURN_PV("");
        } else if ( !SvUTF8(string) ) {
            croak("string is not utf8!!");
        } else {
#endif
            realstring = (xmlChar*) SvPV(string, len);
            if ( realstring != NULL ) {
                /* warn("decode %s", realstring ); */
                enc = xmlParseCharEncoding( encoding );
                if ( enc == 0 ) {
                    /* this happens if the encoding is "" or NULL */
                    enc = XML_CHAR_ENCODING_UTF8;
                }

                if ( enc == XML_CHAR_ENCODING_UTF8 ) {
                    /* copy the string */
                    /* warn( "simply copy the string" ); */
                    tstr = xmlStrdup( realstring );
                    len = xmlStrlen( tstr );
                }
                else {
                    INIT_ERROR_HANDLER;
                    if ( enc > 1 ) {
                        coder= xmlGetCharEncodingHandler( enc );
                    }
                    else if ( enc == XML_CHAR_ENCODING_ERROR ){
                        coder = xmlFindCharEncodingHandler( encoding );
                    }
                    else {
                        croak("no encoder found\n");
                    }

                    if ( coder == NULL ) {
                        croak( "cannot encode string" );
                    }

                    in    = xmlBufferCreate();
                    out   = xmlBufferCreate();
                    xmlBufferCCat( in, (char*) realstring );
                    if ( xmlCharEncOutFunc( coder, out, in ) >= 0 ) {
                        len  = xmlBufferLength( out );
                        tstr = xmlCharStrndup( (char*) xmlBufferContent( out ), len );
                    }

                    xmlBufferFree( in );
                    xmlBufferFree( out );
                    xmlCharEncCloseFunc( coder );
                    CLEANUP_ERROR_HANDLER;
                    REPORT_ERROR(0);
                    if ( !tstr ) {
                        croak( "return value missing!" );
                    }
                }

                RETVAL = newSVpvn( (const char *)tstr, len );
                xmlFree( tstr );
#ifdef HAVE_UTF8
                if ( enc == XML_CHAR_ENCODING_UTF8 ) {
                    SvUTF8_on(RETVAL);
                }
#endif
            }
            else {
                XSRETURN_UNDEF;
            }
#ifdef HAVE_UTF8
        }
#endif
#line 16237 "LibXML.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_XML__LibXML); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_XML__LibXML)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("XML::LibXML::_CLONE", XS_XML__LibXML__CLONE);
        newXS_deffile("XML::LibXML::_leaked_nodes", XS_XML__LibXML__leaked_nodes);
        newXS_deffile("XML::LibXML::_dump_registry", XS_XML__LibXML__dump_registry);
        newXS_deffile("XML::LibXML::LIBXML_DOTTED_VERSION", XS_XML__LibXML_LIBXML_DOTTED_VERSION);
        newXS_deffile("XML::LibXML::LIBXML_VERSION", XS_XML__LibXML_LIBXML_VERSION);
        newXS_deffile("XML::LibXML::HAVE_STRUCT_ERRORS", XS_XML__LibXML_HAVE_STRUCT_ERRORS);
        newXS_deffile("XML::LibXML::HAVE_SCHEMAS", XS_XML__LibXML_HAVE_SCHEMAS);
        newXS_deffile("XML::LibXML::HAVE_READER", XS_XML__LibXML_HAVE_READER);
        newXS_deffile("XML::LibXML::HAVE_THREAD_SUPPORT", XS_XML__LibXML_HAVE_THREAD_SUPPORT);
        newXS_deffile("XML::LibXML::LIBXML_RUNTIME_VERSION", XS_XML__LibXML_LIBXML_RUNTIME_VERSION);
        newXS_deffile("XML::LibXML::END", XS_XML__LibXML_END);
        newXS_deffile("XML::LibXML::INIT_THREAD_SUPPORT", XS_XML__LibXML_INIT_THREAD_SUPPORT);
        newXS_deffile("XML::LibXML::DISABLE_THREAD_SUPPORT", XS_XML__LibXML_DISABLE_THREAD_SUPPORT);
        newXS_deffile("XML::LibXML::_parse_string", XS_XML__LibXML__parse_string);
        newXS_deffile("XML::LibXML::_parse_sax_string", XS_XML__LibXML__parse_sax_string);
        newXS_deffile("XML::LibXML::_parse_fh", XS_XML__LibXML__parse_fh);
        newXS_deffile("XML::LibXML::_parse_sax_fh", XS_XML__LibXML__parse_sax_fh);
        newXS_deffile("XML::LibXML::_parse_file", XS_XML__LibXML__parse_file);
        newXS_deffile("XML::LibXML::_parse_sax_file", XS_XML__LibXML__parse_sax_file);
        newXS_deffile("XML::LibXML::_parse_html_string", XS_XML__LibXML__parse_html_string);
        newXS_deffile("XML::LibXML::_parse_html_file", XS_XML__LibXML__parse_html_file);
        newXS_deffile("XML::LibXML::_parse_html_fh", XS_XML__LibXML__parse_html_fh);
        newXS_deffile("XML::LibXML::_parse_xml_chunk", XS_XML__LibXML__parse_xml_chunk);
        newXS_deffile("XML::LibXML::_parse_sax_xml_chunk", XS_XML__LibXML__parse_sax_xml_chunk);
        newXS_deffile("XML::LibXML::_processXIncludes", XS_XML__LibXML__processXIncludes);
        newXS_deffile("XML::LibXML::_start_push", XS_XML__LibXML__start_push);
        newXS_deffile("XML::LibXML::_push", XS_XML__LibXML__push);
        newXS_deffile("XML::LibXML::_end_push", XS_XML__LibXML__end_push);
        newXS_deffile("XML::LibXML::_end_sax_push", XS_XML__LibXML__end_sax_push);
        newXS_deffile("XML::LibXML::import_GDOME", XS_XML__LibXML_import_GDOME);
        newXS_deffile("XML::LibXML::export_GDOME", XS_XML__LibXML_export_GDOME);
        newXS_deffile("XML::LibXML::load_catalog", XS_XML__LibXML_load_catalog);
        newXS_deffile("XML::LibXML::_default_catalog", XS_XML__LibXML__default_catalog);
        newXS_deffile("XML::LibXML::_externalEntityLoader", XS_XML__LibXML__externalEntityLoader);
        newXS_deffile("XML::LibXML::HashTable::new", XS_XML__LibXML__HashTable_new);
        newXS_deffile("XML::LibXML::HashTable::DESTROY", XS_XML__LibXML__HashTable_DESTROY);
        newXS_deffile("XML::LibXML::ParserContext::DESTROY", XS_XML__LibXML__ParserContext_DESTROY);
        newXS_deffile("XML::LibXML::Document::_toString", XS_XML__LibXML__Document__toString);
        newXS_deffile("XML::LibXML::Document::toFH", XS_XML__LibXML__Document_toFH);
        newXS_deffile("XML::LibXML::Document::toFile", XS_XML__LibXML__Document_toFile);
        cv = newXS_deffile("XML::LibXML::Document::serialize_html", XS_XML__LibXML__Document_toStringHTML);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Document::toStringHTML", XS_XML__LibXML__Document_toStringHTML);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::URI", XS_XML__LibXML__Document_URI);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::documentURI", XS_XML__LibXML__Document_URI);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Document::setURI", XS_XML__LibXML__Document_setURI);
        cv = newXS_deffile("XML::LibXML::Document::createDocument", XS_XML__LibXML__Document_createDocument);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::new", XS_XML__LibXML__Document_createDocument);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Document::createInternalSubset", XS_XML__LibXML__Document_createInternalSubset);
        newXS_deffile("XML::LibXML::Document::createExternalSubset", XS_XML__LibXML__Document_createExternalSubset);
        newXS_deffile("XML::LibXML::Document::createDTD", XS_XML__LibXML__Document_createDTD);
        newXS_deffile("XML::LibXML::Document::createDocumentFragment", XS_XML__LibXML__Document_createDocumentFragment);
        newXS_deffile("XML::LibXML::Document::createElement", XS_XML__LibXML__Document_createElement);
        newXS_deffile("XML::LibXML::Document::createRawElement", XS_XML__LibXML__Document_createRawElement);
        newXS_deffile("XML::LibXML::Document::createElementNS", XS_XML__LibXML__Document_createElementNS);
        newXS_deffile("XML::LibXML::Document::createRawElementNS", XS_XML__LibXML__Document_createRawElementNS);
        newXS_deffile("XML::LibXML::Document::createTextNode", XS_XML__LibXML__Document_createTextNode);
        newXS_deffile("XML::LibXML::Document::createComment", XS_XML__LibXML__Document_createComment);
        newXS_deffile("XML::LibXML::Document::createCDATASection", XS_XML__LibXML__Document_createCDATASection);
        newXS_deffile("XML::LibXML::Document::createEntityReference", XS_XML__LibXML__Document_createEntityReference);
        newXS_deffile("XML::LibXML::Document::createAttribute", XS_XML__LibXML__Document_createAttribute);
        newXS_deffile("XML::LibXML::Document::createAttributeNS", XS_XML__LibXML__Document_createAttributeNS);
        cv = newXS_deffile("XML::LibXML::Document::createPI", XS_XML__LibXML__Document_createProcessingInstruction);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Document::createProcessingInstruction", XS_XML__LibXML__Document_createProcessingInstruction);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Document::_setDocumentElement", XS_XML__LibXML__Document__setDocumentElement);
        cv = newXS_deffile("XML::LibXML::Document::documentElement", XS_XML__LibXML__Document_documentElement);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::getDocumentElement", XS_XML__LibXML__Document_documentElement);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Document::externalSubset", XS_XML__LibXML__Document_externalSubset);
        newXS_deffile("XML::LibXML::Document::internalSubset", XS_XML__LibXML__Document_internalSubset);
        newXS_deffile("XML::LibXML::Document::setExternalSubset", XS_XML__LibXML__Document_setExternalSubset);
        newXS_deffile("XML::LibXML::Document::setInternalSubset", XS_XML__LibXML__Document_setInternalSubset);
        newXS_deffile("XML::LibXML::Document::removeInternalSubset", XS_XML__LibXML__Document_removeInternalSubset);
        newXS_deffile("XML::LibXML::Document::removeExternalSubset", XS_XML__LibXML__Document_removeExternalSubset);
        newXS_deffile("XML::LibXML::Document::importNode", XS_XML__LibXML__Document_importNode);
        newXS_deffile("XML::LibXML::Document::adoptNode", XS_XML__LibXML__Document_adoptNode);
        cv = newXS_deffile("XML::LibXML::Document::encoding", XS_XML__LibXML__Document_encoding);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::getEncoding", XS_XML__LibXML__Document_encoding);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Document::xmlEncoding", XS_XML__LibXML__Document_encoding);
        XSANY.any_i32 = 2;
        newXS_deffile("XML::LibXML::Document::setEncoding", XS_XML__LibXML__Document_setEncoding);
        cv = newXS_deffile("XML::LibXML::Document::standalone", XS_XML__LibXML__Document_standalone);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::xmlStandalone", XS_XML__LibXML__Document_standalone);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Document::setStandalone", XS_XML__LibXML__Document_setStandalone);
        cv = newXS_deffile("XML::LibXML::Document::getVersion", XS_XML__LibXML__Document_version);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Document::version", XS_XML__LibXML__Document_version);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::xmlVersion", XS_XML__LibXML__Document_version);
        XSANY.any_i32 = 2;
        newXS_deffile("XML::LibXML::Document::setVersion", XS_XML__LibXML__Document_setVersion);
        newXS_deffile("XML::LibXML::Document::compression", XS_XML__LibXML__Document_compression);
        newXS_deffile("XML::LibXML::Document::setCompression", XS_XML__LibXML__Document_setCompression);
        newXS_deffile("XML::LibXML::Document::is_valid", XS_XML__LibXML__Document_is_valid);
        newXS_deffile("XML::LibXML::Document::validate", XS_XML__LibXML__Document_validate);
        newXS_deffile("XML::LibXML::Document::cloneNode", XS_XML__LibXML__Document_cloneNode);
        cv = newXS_deffile("XML::LibXML::Document::getElementById", XS_XML__LibXML__Document_getElementById);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Document::getElementsById", XS_XML__LibXML__Document_getElementById);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Document::indexElements", XS_XML__LibXML__Document_indexElements);
        newXS_deffile("XML::LibXML::Node::DESTROY", XS_XML__LibXML__Node_DESTROY);
        cv = newXS_deffile("XML::LibXML::Element::tagName", XS_XML__LibXML__Node_nodeName);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::getName", XS_XML__LibXML__Node_nodeName);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::nodeName", XS_XML__LibXML__Node_nodeName);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Attr::name", XS_XML__LibXML__Node_localname);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::getLocalName", XS_XML__LibXML__Node_localname);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::localName", XS_XML__LibXML__Node_localname);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Node::localname", XS_XML__LibXML__Node_localname);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getPrefix", XS_XML__LibXML__Node_prefix);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::prefix", XS_XML__LibXML__Node_prefix);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getNamespaceURI", XS_XML__LibXML__Node_namespaceURI);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::namespaceURI", XS_XML__LibXML__Node_namespaceURI);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::lookupNamespaceURI", XS_XML__LibXML__Node_lookupNamespaceURI);
        newXS_deffile("XML::LibXML::Node::lookupNamespacePrefix", XS_XML__LibXML__Node_lookupNamespacePrefix);
        cv = newXS_deffile("XML::LibXML::Node::setName", XS_XML__LibXML__Node_setNodeName);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::setNodeName", XS_XML__LibXML__Node_setNodeName);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::setRawName", XS_XML__LibXML__Node_setRawName);
        cv = newXS_deffile("XML::LibXML::Attr::getValue", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Attr::value", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::getData", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("XML::LibXML::Node::getValue", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("XML::LibXML::Node::nodeValue", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Text::data", XS_XML__LibXML__Node_nodeValue);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Node::getType", XS_XML__LibXML__Node_nodeType);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::nodeType", XS_XML__LibXML__Node_nodeType);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Attr::getOwnerElement", XS_XML__LibXML__Node_parentNode);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Attr::ownerElement", XS_XML__LibXML__Node_parentNode);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::getParentNode", XS_XML__LibXML__Node_parentNode);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::parentNode", XS_XML__LibXML__Node_parentNode);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getNextSibling", XS_XML__LibXML__Node_nextSibling);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::nextSibling", XS_XML__LibXML__Node_nextSibling);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::nextNonBlankSibling", XS_XML__LibXML__Node_nextNonBlankSibling);
        cv = newXS_deffile("XML::LibXML::Node::getPreviousSibling", XS_XML__LibXML__Node_previousSibling);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::previousSibling", XS_XML__LibXML__Node_previousSibling);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::previousNonBlankSibling", XS_XML__LibXML__Node_previousNonBlankSibling);
        cv = newXS_deffile("XML::LibXML::Node::_childNodes", XS_XML__LibXML__Node__childNodes);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getChildnodes", XS_XML__LibXML__Node__childNodes);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Node::_getChildrenByTagNameNS", XS_XML__LibXML__Node__getChildrenByTagNameNS);
        cv = newXS_deffile("XML::LibXML::Node::firstChild", XS_XML__LibXML__Node_firstChild);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getFirstChild", XS_XML__LibXML__Node_firstChild);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Node::firstNonBlankChild", XS_XML__LibXML__Node_firstNonBlankChild);
        cv = newXS_deffile("XML::LibXML::Node::getLastChild", XS_XML__LibXML__Node_lastChild);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::lastChild", XS_XML__LibXML__Node_lastChild);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::_attributes", XS_XML__LibXML__Node__attributes);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getAttributes", XS_XML__LibXML__Node__attributes);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Node::hasChildNodes", XS_XML__LibXML__Node_hasChildNodes);
        newXS_deffile("XML::LibXML::Node::hasAttributes", XS_XML__LibXML__Node_hasAttributes);
        cv = newXS_deffile("XML::LibXML::Node::getOwnerDocument", XS_XML__LibXML__Node_ownerDocument);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::ownerDocument", XS_XML__LibXML__Node_ownerDocument);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::getOwner", XS_XML__LibXML__Node_ownerNode);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::getOwnerElement", XS_XML__LibXML__Node_ownerNode);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::ownerNode", XS_XML__LibXML__Node_ownerNode);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::normalize", XS_XML__LibXML__Node_normalize);
        newXS_deffile("XML::LibXML::Node::insertBefore", XS_XML__LibXML__Node_insertBefore);
        newXS_deffile("XML::LibXML::Node::insertAfter", XS_XML__LibXML__Node_insertAfter);
        newXS_deffile("XML::LibXML::Node::replaceChild", XS_XML__LibXML__Node_replaceChild);
        newXS_deffile("XML::LibXML::Node::replaceNode", XS_XML__LibXML__Node_replaceNode);
        newXS_deffile("XML::LibXML::Node::removeChild", XS_XML__LibXML__Node_removeChild);
        newXS_deffile("XML::LibXML::Node::removeChildNodes", XS_XML__LibXML__Node_removeChildNodes);
        cv = newXS_deffile("XML::LibXML::Node::unbindNode", XS_XML__LibXML__Node_unbindNode);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::unlink", XS_XML__LibXML__Node_unbindNode);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::unlinkNode", XS_XML__LibXML__Node_unbindNode);
        XSANY.any_i32 = 2;
        newXS_deffile("XML::LibXML::Node::appendChild", XS_XML__LibXML__Node_appendChild);
        newXS_deffile("XML::LibXML::Node::addChild", XS_XML__LibXML__Node_addChild);
        newXS_deffile("XML::LibXML::Node::addSibling", XS_XML__LibXML__Node_addSibling);
        newXS_deffile("XML::LibXML::Node::cloneNode", XS_XML__LibXML__Node_cloneNode);
        cv = newXS_deffile("XML::LibXML::Node::isEqual", XS_XML__LibXML__Node_isSameNode);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::isSameNode", XS_XML__LibXML__Node_isSameNode);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::unique_key", XS_XML__LibXML__Node_unique_key);
        newXS_deffile("XML::LibXML::Node::baseURI", XS_XML__LibXML__Node_baseURI);
        newXS_deffile("XML::LibXML::Node::setBaseURI", XS_XML__LibXML__Node_setBaseURI);
        cv = newXS_deffile("XML::LibXML::Node::serialize", XS_XML__LibXML__Node_toString);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::toString", XS_XML__LibXML__Node_toString);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Node::_toStringC14N", XS_XML__LibXML__Node__toStringC14N);
        cv = newXS_deffile("XML::LibXML::Node::string_value", XS_XML__LibXML__Node_string_value);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::textContent", XS_XML__LibXML__Node_string_value);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::to_literal", XS_XML__LibXML__Node_string_value);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Node::to_number", XS_XML__LibXML__Node_to_number);
        newXS_deffile("XML::LibXML::Node::_find", XS_XML__LibXML__Node__find);
        newXS_deffile("XML::LibXML::Node::_findnodes", XS_XML__LibXML__Node__findnodes);
        cv = newXS_deffile("XML::LibXML::Node::getNamespaces", XS_XML__LibXML__Node_getNamespaces);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::namespaces", XS_XML__LibXML__Node_getNamespaces);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Node::getNamespace", XS_XML__LibXML__Node_getNamespace);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Node::localNS", XS_XML__LibXML__Node_getNamespace);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Node::localNamespace", XS_XML__LibXML__Node_getNamespace);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Node::nodePath", XS_XML__LibXML__Node_nodePath);
        newXS_deffile("XML::LibXML::Node::line_number", XS_XML__LibXML__Node_line_number);
        newXS_deffile("XML::LibXML::Element::new", XS_XML__LibXML__Element_new);
        newXS_deffile("XML::LibXML::Element::_setNamespace", XS_XML__LibXML__Element__setNamespace);
        newXS_deffile("XML::LibXML::Element::setNamespaceDeclURI", XS_XML__LibXML__Element_setNamespaceDeclURI);
        newXS_deffile("XML::LibXML::Element::setNamespaceDeclPrefix", XS_XML__LibXML__Element_setNamespaceDeclPrefix);
        newXS_deffile("XML::LibXML::Element::_getNamespaceDeclURI", XS_XML__LibXML__Element__getNamespaceDeclURI);
        newXS_deffile("XML::LibXML::Element::hasAttribute", XS_XML__LibXML__Element_hasAttribute);
        newXS_deffile("XML::LibXML::Element::hasAttributeNS", XS_XML__LibXML__Element_hasAttributeNS);
        newXS_deffile("XML::LibXML::Element::_getAttribute", XS_XML__LibXML__Element__getAttribute);
        newXS_deffile("XML::LibXML::Element::_setAttribute", XS_XML__LibXML__Element__setAttribute);
        newXS_deffile("XML::LibXML::Element::removeAttribute", XS_XML__LibXML__Element_removeAttribute);
        newXS_deffile("XML::LibXML::Element::getAttributeNode", XS_XML__LibXML__Element_getAttributeNode);
        newXS_deffile("XML::LibXML::Element::setAttributeNode", XS_XML__LibXML__Element_setAttributeNode);
        newXS_deffile("XML::LibXML::Element::_getAttributeNS", XS_XML__LibXML__Element__getAttributeNS);
        newXS_deffile("XML::LibXML::Element::_setAttributeNS", XS_XML__LibXML__Element__setAttributeNS);
        newXS_deffile("XML::LibXML::Element::removeAttributeNS", XS_XML__LibXML__Element_removeAttributeNS);
        newXS_deffile("XML::LibXML::Element::getAttributeNodeNS", XS_XML__LibXML__Element_getAttributeNodeNS);
        newXS_deffile("XML::LibXML::Element::setAttributeNodeNS", XS_XML__LibXML__Element_setAttributeNodeNS);
        newXS_deffile("XML::LibXML::Element::removeAttributeNode", XS_XML__LibXML__Element_removeAttributeNode);
        cv = newXS_deffile("XML::LibXML::DocumentFragment::appendText", XS_XML__LibXML__Element_appendText);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::DocumentFragment::appendTextNode", XS_XML__LibXML__Element_appendText);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Element::appendText", XS_XML__LibXML__Element_appendText);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Element::appendTextNode", XS_XML__LibXML__Element_appendText);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Element::appendTextChild", XS_XML__LibXML__Element_appendTextChild);
        cv = newXS_deffile("XML::LibXML::DocumentFragment::addNewChild", XS_XML__LibXML__Element_addNewChild);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Element::addNewChild", XS_XML__LibXML__Element_addNewChild);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Text::new", XS_XML__LibXML__Text_new);
        newXS_deffile("XML::LibXML::Text::substringData", XS_XML__LibXML__Text_substringData);
        cv = newXS_deffile("XML::LibXML::Attr::setValue", XS_XML__LibXML__Text_setData);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::PI::_setData", XS_XML__LibXML__Text_setData);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Text::setData", XS_XML__LibXML__Text_setData);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Text::appendData", XS_XML__LibXML__Text_appendData);
        newXS_deffile("XML::LibXML::Text::insertData", XS_XML__LibXML__Text_insertData);
        newXS_deffile("XML::LibXML::Text::deleteData", XS_XML__LibXML__Text_deleteData);
        newXS_deffile("XML::LibXML::Text::replaceData", XS_XML__LibXML__Text_replaceData);
        newXS_deffile("XML::LibXML::Comment::new", XS_XML__LibXML__Comment_new);
        newXS_deffile("XML::LibXML::CDATASection::new", XS_XML__LibXML__CDATASection_new);
        newXS_deffile("XML::LibXML::DocumentFragment::new", XS_XML__LibXML__DocumentFragment_new);
        newXS_deffile("XML::LibXML::Attr::new", XS_XML__LibXML__Attr_new);
        cv = newXS_deffile("XML::LibXML::Attr::getNextSibling", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Attr::getParentNode", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Attr::getPreviousSibling", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Attr::nextSibling", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("XML::LibXML::Attr::parentElement", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Attr::previousSibling", XS_XML__LibXML__Attr_parentElement);
        XSANY.any_i32 = 5;
        newXS_deffile("XML::LibXML::Attr::serializeContent", XS_XML__LibXML__Attr_serializeContent);
        cv = newXS_deffile("XML::LibXML::Attr::serialize", XS_XML__LibXML__Attr_toString);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Attr::toString", XS_XML__LibXML__Attr_toString);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Attr::_setNamespace", XS_XML__LibXML__Attr__setNamespace);
        newXS_deffile("XML::LibXML::Attr::isId", XS_XML__LibXML__Attr_isId);
        newXS_deffile("XML::LibXML::Namespace::new", XS_XML__LibXML__Namespace_new);
        newXS_deffile("XML::LibXML::Namespace::DESTROY", XS_XML__LibXML__Namespace_DESTROY);
        cv = newXS_deffile("XML::LibXML::Namespace::getType", XS_XML__LibXML__Namespace_nodeType);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Namespace::nodeType", XS_XML__LibXML__Namespace_nodeType);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Namespace::declaredURI", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Namespace::getData", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 3;
        cv = newXS_deffile("XML::LibXML::Namespace::getValue", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 4;
        cv = newXS_deffile("XML::LibXML::Namespace::href", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 6;
        cv = newXS_deffile("XML::LibXML::Namespace::nodeValue", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Namespace::value", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Namespace::value2", XS_XML__LibXML__Namespace_declaredURI);
        XSANY.any_i32 = 5;
        cv = newXS_deffile("XML::LibXML::Namespace::declaredPrefix", XS_XML__LibXML__Namespace_declaredPrefix);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Namespace::getLocalName", XS_XML__LibXML__Namespace_declaredPrefix);
        XSANY.any_i32 = 2;
        cv = newXS_deffile("XML::LibXML::Namespace::localname", XS_XML__LibXML__Namespace_declaredPrefix);
        XSANY.any_i32 = 1;
        newXS_deffile("XML::LibXML::Namespace::unique_key", XS_XML__LibXML__Namespace_unique_key);
        newXS_deffile("XML::LibXML::Namespace::_isEqual", XS_XML__LibXML__Namespace__isEqual);
        cv = newXS_deffile("XML::LibXML::Dtd::new", XS_XML__LibXML__Dtd_new);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Dtd::parse_uri", XS_XML__LibXML__Dtd_new);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Dtd::getSystemId", XS_XML__LibXML__Dtd_systemId);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Dtd::systemId", XS_XML__LibXML__Dtd_systemId);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::Dtd::getPublicId", XS_XML__LibXML__Dtd_publicId);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::Dtd::publicId", XS_XML__LibXML__Dtd_publicId);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::Dtd::parse_string", XS_XML__LibXML__Dtd_parse_string);
#if XSubPPtmpAAAA
        newXS_deffile("XML::LibXML::RelaxNG::DESTROY", XS_XML__LibXML__RelaxNG_DESTROY);
        newXS_deffile("XML::LibXML::RelaxNG::parse_location", XS_XML__LibXML__RelaxNG_parse_location);
        newXS_deffile("XML::LibXML::RelaxNG::parse_buffer", XS_XML__LibXML__RelaxNG_parse_buffer);
        newXS_deffile("XML::LibXML::RelaxNG::parse_document", XS_XML__LibXML__RelaxNG_parse_document);
        newXS_deffile("XML::LibXML::RelaxNG::validate", XS_XML__LibXML__RelaxNG_validate);
        newXS_deffile("XML::LibXML::Schema::DESTROY", XS_XML__LibXML__Schema_DESTROY);
        newXS_deffile("XML::LibXML::Schema::parse_location", XS_XML__LibXML__Schema_parse_location);
        newXS_deffile("XML::LibXML::Schema::parse_buffer", XS_XML__LibXML__Schema_parse_buffer);
        newXS_deffile("XML::LibXML::Schema::validate", XS_XML__LibXML__Schema_validate);
#endif
        newXS_deffile("XML::LibXML::XPathContext::new", XS_XML__LibXML__XPathContext_new);
        newXS_deffile("XML::LibXML::XPathContext::DESTROY", XS_XML__LibXML__XPathContext_DESTROY);
        newXS_deffile("XML::LibXML::XPathContext::getContextNode", XS_XML__LibXML__XPathContext_getContextNode);
        newXS_deffile("XML::LibXML::XPathContext::getContextPosition", XS_XML__LibXML__XPathContext_getContextPosition);
        newXS_deffile("XML::LibXML::XPathContext::getContextSize", XS_XML__LibXML__XPathContext_getContextSize);
        newXS_deffile("XML::LibXML::XPathContext::setContextNode", XS_XML__LibXML__XPathContext_setContextNode);
        newXS_deffile("XML::LibXML::XPathContext::setContextPosition", XS_XML__LibXML__XPathContext_setContextPosition);
        newXS_deffile("XML::LibXML::XPathContext::setContextSize", XS_XML__LibXML__XPathContext_setContextSize);
        newXS_deffile("XML::LibXML::XPathContext::registerNs", XS_XML__LibXML__XPathContext_registerNs);
        newXS_deffile("XML::LibXML::XPathContext::lookupNs", XS_XML__LibXML__XPathContext_lookupNs);
        newXS_deffile("XML::LibXML::XPathContext::getVarLookupData", XS_XML__LibXML__XPathContext_getVarLookupData);
        newXS_deffile("XML::LibXML::XPathContext::getVarLookupFunc", XS_XML__LibXML__XPathContext_getVarLookupFunc);
        newXS_deffile("XML::LibXML::XPathContext::registerVarLookupFunc", XS_XML__LibXML__XPathContext_registerVarLookupFunc);
        newXS_deffile("XML::LibXML::XPathContext::registerFunctionNS", XS_XML__LibXML__XPathContext_registerFunctionNS);
        newXS_deffile("XML::LibXML::XPathContext::_free_node_pool", XS_XML__LibXML__XPathContext__free_node_pool);
        newXS_deffile("XML::LibXML::XPathContext::_findnodes", XS_XML__LibXML__XPathContext__findnodes);
        newXS_deffile("XML::LibXML::XPathContext::_find", XS_XML__LibXML__XPathContext__find);
        newXS_deffile("XML::LibXML::InputCallback::lib_cleanup_callbacks", XS_XML__LibXML__InputCallback_lib_cleanup_callbacks);
        newXS_deffile("XML::LibXML::InputCallback::lib_init_callbacks", XS_XML__LibXML__InputCallback_lib_init_callbacks);
#if XSubPPtmpAAAB
        newXS_deffile("XML::LibXML::Reader::_newForFile", XS_XML__LibXML__Reader__newForFile);
        newXS_deffile("XML::LibXML::Reader::_newForIO", XS_XML__LibXML__Reader__newForIO);
        newXS_deffile("XML::LibXML::Reader::_newForString", XS_XML__LibXML__Reader__newForString);
        newXS_deffile("XML::LibXML::Reader::_newForFd", XS_XML__LibXML__Reader__newForFd);
        newXS_deffile("XML::LibXML::Reader::_newForDOM", XS_XML__LibXML__Reader__newForDOM);
        newXS_deffile("XML::LibXML::Reader::attributeCount", XS_XML__LibXML__Reader_attributeCount);
        newXS_deffile("XML::LibXML::Reader::baseURI", XS_XML__LibXML__Reader_baseURI);
        newXS_deffile("XML::LibXML::Reader::byteConsumed", XS_XML__LibXML__Reader_byteConsumed);
        newXS_deffile("XML::LibXML::Reader::_close", XS_XML__LibXML__Reader__close);
        newXS_deffile("XML::LibXML::Reader::encoding", XS_XML__LibXML__Reader_encoding);
        newXS_deffile("XML::LibXML::Reader::localName", XS_XML__LibXML__Reader_localName);
        newXS_deffile("XML::LibXML::Reader::name", XS_XML__LibXML__Reader_name);
        newXS_deffile("XML::LibXML::Reader::namespaceURI", XS_XML__LibXML__Reader_namespaceURI);
        newXS_deffile("XML::LibXML::Reader::prefix", XS_XML__LibXML__Reader_prefix);
        newXS_deffile("XML::LibXML::Reader::value", XS_XML__LibXML__Reader_value);
        newXS_deffile("XML::LibXML::Reader::xmlLang", XS_XML__LibXML__Reader_xmlLang);
        newXS_deffile("XML::LibXML::Reader::xmlVersion", XS_XML__LibXML__Reader_xmlVersion);
        newXS_deffile("XML::LibXML::Reader::depth", XS_XML__LibXML__Reader_depth);
        newXS_deffile("XML::LibXML::Reader::getAttribute", XS_XML__LibXML__Reader_getAttribute);
        newXS_deffile("XML::LibXML::Reader::getAttributeNo", XS_XML__LibXML__Reader_getAttributeNo);
        newXS_deffile("XML::LibXML::Reader::getAttributeNs", XS_XML__LibXML__Reader_getAttributeNs);
        newXS_deffile("XML::LibXML::Reader::columnNumber", XS_XML__LibXML__Reader_columnNumber);
        newXS_deffile("XML::LibXML::Reader::lineNumber", XS_XML__LibXML__Reader_lineNumber);
        newXS_deffile("XML::LibXML::Reader::_getParserProp", XS_XML__LibXML__Reader__getParserProp);
        newXS_deffile("XML::LibXML::Reader::hasAttributes", XS_XML__LibXML__Reader_hasAttributes);
        newXS_deffile("XML::LibXML::Reader::hasValue", XS_XML__LibXML__Reader_hasValue);
        newXS_deffile("XML::LibXML::Reader::getAttributeHash", XS_XML__LibXML__Reader_getAttributeHash);
        newXS_deffile("XML::LibXML::Reader::isDefault", XS_XML__LibXML__Reader_isDefault);
        newXS_deffile("XML::LibXML::Reader::isEmptyElement", XS_XML__LibXML__Reader_isEmptyElement);
        newXS_deffile("XML::LibXML::Reader::isNamespaceDecl", XS_XML__LibXML__Reader_isNamespaceDecl);
        newXS_deffile("XML::LibXML::Reader::isValid", XS_XML__LibXML__Reader_isValid);
        newXS_deffile("XML::LibXML::Reader::lookupNamespace", XS_XML__LibXML__Reader_lookupNamespace);
        newXS_deffile("XML::LibXML::Reader::moveToAttribute", XS_XML__LibXML__Reader_moveToAttribute);
        newXS_deffile("XML::LibXML::Reader::moveToAttributeNo", XS_XML__LibXML__Reader_moveToAttributeNo);
        newXS_deffile("XML::LibXML::Reader::moveToAttributeNs", XS_XML__LibXML__Reader_moveToAttributeNs);
        newXS_deffile("XML::LibXML::Reader::moveToElement", XS_XML__LibXML__Reader_moveToElement);
        newXS_deffile("XML::LibXML::Reader::moveToFirstAttribute", XS_XML__LibXML__Reader_moveToFirstAttribute);
        newXS_deffile("XML::LibXML::Reader::moveToNextAttribute", XS_XML__LibXML__Reader_moveToNextAttribute);
        newXS_deffile("XML::LibXML::Reader::next", XS_XML__LibXML__Reader_next);
        newXS_deffile("XML::LibXML::Reader::nextSibling", XS_XML__LibXML__Reader_nextSibling);
        newXS_deffile("XML::LibXML::Reader::nextSiblingElement", XS_XML__LibXML__Reader_nextSiblingElement);
        newXS_deffile("XML::LibXML::Reader::nextElement", XS_XML__LibXML__Reader_nextElement);
        newXS_deffile("XML::LibXML::Reader::nextPatternMatch", XS_XML__LibXML__Reader_nextPatternMatch);
        newXS_deffile("XML::LibXML::Reader::skipSiblings", XS_XML__LibXML__Reader_skipSiblings);
        newXS_deffile("XML::LibXML::Reader::nodeType", XS_XML__LibXML__Reader_nodeType);
        newXS_deffile("XML::LibXML::Reader::quoteChar", XS_XML__LibXML__Reader_quoteChar);
        newXS_deffile("XML::LibXML::Reader::read", XS_XML__LibXML__Reader_read);
        newXS_deffile("XML::LibXML::Reader::readAttributeValue", XS_XML__LibXML__Reader_readAttributeValue);
        newXS_deffile("XML::LibXML::Reader::readInnerXml", XS_XML__LibXML__Reader_readInnerXml);
        newXS_deffile("XML::LibXML::Reader::readOuterXml", XS_XML__LibXML__Reader_readOuterXml);
        newXS_deffile("XML::LibXML::Reader::readState", XS_XML__LibXML__Reader_readState);
        newXS_deffile("XML::LibXML::Reader::_setParserProp", XS_XML__LibXML__Reader__setParserProp);
        newXS_deffile("XML::LibXML::Reader::standalone", XS_XML__LibXML__Reader_standalone);
        newXS_deffile("XML::LibXML::Reader::_nodePath", XS_XML__LibXML__Reader__nodePath);
#if XSubPPtmpAAAC
        newXS_deffile("XML::LibXML::Reader::matchesPattern", XS_XML__LibXML__Reader_matchesPattern);
#endif
        newXS_deffile("XML::LibXML::Reader::copyCurrentNode", XS_XML__LibXML__Reader_copyCurrentNode);
        newXS_deffile("XML::LibXML::Reader::document", XS_XML__LibXML__Reader_document);
        newXS_deffile("XML::LibXML::Reader::_preservePattern", XS_XML__LibXML__Reader__preservePattern);
        newXS_deffile("XML::LibXML::Reader::preserveNode", XS_XML__LibXML__Reader_preserveNode);
        newXS_deffile("XML::LibXML::Reader::finish", XS_XML__LibXML__Reader_finish);
#if XSubPPtmpAAAD
        newXS_deffile("XML::LibXML::Reader::_setRelaxNGFile", XS_XML__LibXML__Reader__setRelaxNGFile);
        newXS_deffile("XML::LibXML::Reader::_setRelaxNG", XS_XML__LibXML__Reader__setRelaxNG);
        newXS_deffile("XML::LibXML::Reader::_setXSDFile", XS_XML__LibXML__Reader__setXSDFile);
        newXS_deffile("XML::LibXML::Reader::_setXSD", XS_XML__LibXML__Reader__setXSD);
#endif
        newXS_deffile("XML::LibXML::Reader::_DESTROY", XS_XML__LibXML__Reader__DESTROY);
#endif
#if XSubPPtmpAAAE
        newXS_deffile("XML::LibXML::LibError::domain", XS_XML__LibXML__LibError_domain);
        newXS_deffile("XML::LibXML::LibError::code", XS_XML__LibXML__LibError_code);
        newXS_deffile("XML::LibXML::LibError::line", XS_XML__LibXML__LibError_line);
        cv = newXS_deffile("XML::LibXML::LibError::int1", XS_XML__LibXML__LibError_num1);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::LibError::num1", XS_XML__LibXML__LibError_num1);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("XML::LibXML::LibError::int2", XS_XML__LibXML__LibError_num2);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("XML::LibXML::LibError::num2", XS_XML__LibXML__LibError_num2);
        XSANY.any_i32 = 0;
        newXS_deffile("XML::LibXML::LibError::level", XS_XML__LibXML__LibError_level);
        newXS_deffile("XML::LibXML::LibError::message", XS_XML__LibXML__LibError_message);
        newXS_deffile("XML::LibXML::LibError::file", XS_XML__LibXML__LibError_file);
        newXS_deffile("XML::LibXML::LibError::str1", XS_XML__LibXML__LibError_str1);
        newXS_deffile("XML::LibXML::LibError::str2", XS_XML__LibXML__LibError_str2);
        newXS_deffile("XML::LibXML::LibError::str3", XS_XML__LibXML__LibError_str3);
        newXS_deffile("XML::LibXML::LibError::context_and_column", XS_XML__LibXML__LibError_context_and_column);
#endif
#if XSubPPtmpAAAF
        newXS_deffile("XML::LibXML::Pattern::_compilePattern", XS_XML__LibXML__Pattern__compilePattern);
        newXS_deffile("XML::LibXML::Pattern::matchesNode", XS_XML__LibXML__Pattern_matchesNode);
        newXS_deffile("XML::LibXML::Pattern::DESTROY", XS_XML__LibXML__Pattern_DESTROY);
#endif
#if XSubPPtmpAAAG
        newXS_deffile("XML::LibXML::RegExp::_compile", XS_XML__LibXML__RegExp__compile);
        newXS_deffile("XML::LibXML::RegExp::matches", XS_XML__LibXML__RegExp_matches);
        newXS_deffile("XML::LibXML::RegExp::isDeterministic", XS_XML__LibXML__RegExp_isDeterministic);
        newXS_deffile("XML::LibXML::RegExp::DESTROY", XS_XML__LibXML__RegExp_DESTROY);
#endif
        newXS_deffile("XML::LibXML::XPathExpression::new", XS_XML__LibXML__XPathExpression_new);
        newXS_deffile("XML::LibXML::XPathExpression::DESTROY", XS_XML__LibXML__XPathExpression_DESTROY);
        newXS_deffile("XML::LibXML::Common::encodeToUTF8", XS_XML__LibXML__Common_encodeToUTF8);
        newXS_deffile("XML::LibXML::Common::decodeFromUTF8", XS_XML__LibXML__Common_decodeFromUTF8);

    /* Initialisation Section */

#line 1541 "LibXML.xs"
    /* Load Devel first, so debug_memory can
       be called before any allocation. */

    /* The ++ is a bit hacky, but boot_blahblah_Devel, being an
     * XSUB body, will try to pop once more the mark we have just
     * (implicitly) popped, this boot sector also being an XSUB body */
    PL_markstack_ptr++;
    boot_XML__LibXML__Devel(aTHX_ cv);
    LIBXML_TEST_VERSION
    xmlInitParser();
    PmmSAXInitialize(aTHX);
#ifndef WITH_SERRORS
    xmlGetWarningsDefaultValue = 0;
#endif
#ifdef LIBXML_CATALOG_ENABLED
    /* xmlCatalogSetDebug(10); */
    xmlInitializeCatalog(); /* use catalog data */
#endif

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#endif
#if XSubPPtmpAAAE
#endif
#if XSubPPtmpAAAF
#endif
#if XSubPPtmpAAAG
#endif
#line 16809 "LibXML.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

