/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.24 from the
 * contents of DSA.xs. Do not edit this file, edit DSA.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "DSA.xs"
/* $Id: */


#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <openssl/bn.h>
#include <openssl/err.h>
#include <openssl/pem.h>
#include <openssl/dsa.h>
#include <openssl/ssl.h>

#ifdef __cplusplus
}
#endif

#line 31 "DSA.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(pTHX_ const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
            Perl_croak(aTHX_ "Usage: %s::%s(%s)", hvname, gvname, params);
        else
            Perl_croak(aTHX_ "Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
        Perl_croak(aTHX_ "Usage: CODE(0x%"UVxf")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#ifdef PERL_IMPLICIT_CONTEXT
#define croak_xs_usage(a,b)    S_croak_xs_usage(aTHX_ a,b)
#else
#define croak_xs_usage        S_croak_xs_usage
#endif

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#line 173 "DSA.c"

XS_EUPXS(XS_Crypt__OpenSSL__DSA_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	DSA *	RETVAL;
#line 32 "DSA.xs"
        RETVAL = DSA_new();
#line 187 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::DESTROY() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 40 "DSA.xs"
        DSA_free(dsa);
#line 213 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_parameters); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_parameters)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, bits, seed = NULL");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	int	bits = (int)SvIV(ST(1))
;
	SV *	seed;
#line 48 "DSA.xs"
        DSA * dsa;
        int seed_len = 0;
        char * seedpv = NULL;
#line 235 "DSA.c"
	DSA *	RETVAL;

	if (items < 3)
	    seed = NULL;
	else {
	    seed = ST(2)
;
	}
#line 52 "DSA.xs"
        if (seed) {
          seedpv = SvPV(seed, seed_len);
        }
        dsa = DSA_generate_parameters(bits, seedpv, seed_len, NULL, NULL, NULL, NULL);
        if (!dsa)
          croak("%s", ERR_reason_error_string(ERR_get_error()));
        RETVAL = dsa;
#line 252 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_generate_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::generate_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 66 "DSA.xs"
        RETVAL = DSA_generate_key(dsa);
#line 280 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_sign)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, dgst");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
#line 75 "DSA.xs"
        DSA_SIG * sig;
        char * CLASS = "Crypt::OpenSSL::DSA::Signature";
        char * dgst_pv = NULL;
        int dgst_len = 0;
#line 302 "DSA.c"
	DSA_SIG *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_sign() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 80 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        if (!(sig = DSA_do_sign((const unsigned char *) dgst_pv, dgst_len, dsa))) {
          croak("Error in dsa_sign: %s",ERR_error_string(ERR_get_error(), NULL));
        }
        RETVAL = sig;
#line 318 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_sign); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_sign)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, dgst");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
#line 93 "DSA.xs"
        unsigned char *sigret;
        unsigned int siglen;
        char * dgst_pv = NULL;
        int dgst_len = 0;
#line 341 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::sign() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 98 "DSA.xs"
        siglen = DSA_size(dsa);
        sigret = malloc(siglen);

        dgst_pv = SvPV(dgst, dgst_len);
        /* warn("Length of sign [%s] is %d\n", dgst_pv, dgst_len); */

        if (!(DSA_sign(0, (const unsigned char *) dgst_pv, dgst_len, sigret, &siglen, dsa))) {
          croak("Error in DSA_sign: %s",ERR_error_string(ERR_get_error(), NULL));
        }
        RETVAL = newSVpvn(sigret, siglen);
        free(sigret);
#line 363 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_verify)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dsa, dgst, sigbuf");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
	SV *	sigbuf = ST(2)
;
#line 118 "DSA.xs"
        char * dgst_pv = NULL;
        int dgst_len = 0;
        char * sig_pv = NULL;
        int sig_len = 0;
#line 388 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::verify() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 123 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        sig_pv = SvPV(sigbuf, sig_len);
        RETVAL = DSA_verify(0, dgst_pv, dgst_len, sig_pv, sig_len, dsa);
        if (RETVAL == -1)
          croak("Error in DSA_verify: %s",ERR_error_string(ERR_get_error(), NULL));
#line 405 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_verify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_do_verify)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "dsa, dgst, sig");
    {
	DSA *	dsa;
	SV *	dgst = ST(1)
;
	DSA_SIG *	sig;
#line 137 "DSA.xs"
        char * dgst_pv = NULL;
        int dgst_len = 0;
#line 426 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_verify() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;

    if( sv_isobject(ST(2)) && (SvTYPE(SvRV(ST(2))) == SVt_PVMG) )
            sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(2) )));
    else{
            warn( "Crypt::OpenSSL::DSA::do_verify() -- sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 140 "DSA.xs"
        dgst_pv = SvPV(dgst, dgst_len);
        RETVAL = DSA_do_verify(dgst_pv, dgst_len, sig, dsa);
	if (RETVAL == -1)
	  croak("Error in DSA_do_verify: %s",ERR_error_string(ERR_get_error(), NULL));
#line 450 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_params); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_params)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 152 "DSA.xs"
        FILE *f;
#line 470 "DSA.c"
	DSA *	RETVAL;
#line 154 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSAparams(f, NULL, NULL, NULL);
        fclose(f);
#line 477 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_params); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_params)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 166 "DSA.xs"
        FILE *f;
#line 497 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_params() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 168 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSAparams(f, dsa);
        fclose(f);
#line 513 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__load_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__load_key)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "CLASS, private_flag_SV, key_string_SV");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	SV *	private_flag_SV = ST(1)
;
	SV *	key_string_SV = ST(2)
;
#line 181 "DSA.xs"
        int key_string_length;  /* Needed to pass to SvPV */
        char *key_string;
        char private_flag;
        BIO *stringBIO;
#line 538 "DSA.c"
	DSA *	RETVAL;
#line 186 "DSA.xs"
        private_flag = SvTRUE( private_flag_SV );
        key_string = SvPV( key_string_SV, key_string_length );
        if( (stringBIO = BIO_new_mem_buf(key_string, key_string_length)) == NULL )
            croak( "Failed to create memory BIO %s", ERR_error_string(ERR_get_error(), NULL));
        RETVAL = private_flag
            ? PEM_read_bio_DSAPrivateKey( stringBIO, NULL, NULL, NULL )
            : PEM_read_bio_DSA_PUBKEY( stringBIO, NULL, NULL, NULL );
        BIO_set_close(stringBIO, BIO_CLOSE);
        BIO_free( stringBIO );
        if ( RETVAL == NULL )
            croak( "Failed to read key %s", ERR_error_string(ERR_get_error(), NULL));
#line 552 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 205 "DSA.xs"
        FILE *f;
#line 573 "DSA.c"
	DSA *	RETVAL;
#line 207 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSA_PUBKEY(f, NULL, NULL, NULL);
        fclose(f);
#line 580 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 219 "DSA.xs"
        FILE *f;
#line 600 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 221 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSA_PUBKEY(f, dsa);
        fclose(f);
#line 616 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_read_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "CLASS, filename");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 233 "DSA.xs"
        FILE *f;
#line 636 "DSA.c"
	DSA *	RETVAL;
#line 235 "DSA.xs"
        if(!(f = fopen(filename, "r")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_read_DSAPrivateKey(f, NULL, NULL, NULL);
        fclose(f);
#line 643 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_write_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, filename");
    {
	DSA *	dsa;
	char *	filename = (char *)SvPV_nolen(ST(1))
;
#line 247 "DSA.xs"
        FILE *f;
#line 663 "DSA.c"
	int	RETVAL;
	dXSTARG;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::write_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 249 "DSA.xs"
        if(!(f = fopen(filename, "w")))
          croak("Can't open file %s", filename);
        RETVAL = PEM_write_DSAPrivateKey(f, dsa, NULL, NULL, 0, NULL, NULL);
        fclose(f);
#line 679 "DSA.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_p); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_p)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 260 "DSA.xs"
        char *to;
        int len;
#line 697 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_p() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 263 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa->p, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 712 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_q); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_q)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 274 "DSA.xs"
        char *to;
        int len;
#line 731 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_q() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 277 "DSA.xs"
        to = malloc(sizeof(char) * 20);
        len = BN_bn2bin(dsa->q, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 746 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_g); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_g)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 288 "DSA.xs"
        char *to;
        int len;
#line 765 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_g() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 291 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa->g, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 780 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_pub_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 302 "DSA.xs"
        char *to;
        int len;
#line 799 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 305 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa->pub_key, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 814 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_get_priv_key)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa");
    {
	DSA *	dsa;
#line 316 "DSA.xs"
        char *to;
        int len;
#line 833 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::get_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 319 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa->priv_key, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 848 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_p); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_p)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, p_SV");
    {
	DSA *	dsa;
	SV *	p_SV = ST(1)
;
#line 331 "DSA.xs"
        int len;
#line 868 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_p() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 333 "DSA.xs"
        len = SvCUR(p_SV);
        dsa->p = BN_bin2bn(SvPV(p_SV, len), len, NULL);
#line 880 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_q); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_q)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, q_SV");
    {
	DSA *	dsa;
	SV *	q_SV = ST(1)
;
#line 341 "DSA.xs"
        int len;
#line 898 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_q() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 343 "DSA.xs"
        len = SvCUR(q_SV);
        dsa->q = BN_bin2bn(SvPV(q_SV, len), len, NULL);
#line 910 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_g); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_g)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, g_SV");
    {
	DSA *	dsa;
	SV *	g_SV = ST(1)
;
#line 351 "DSA.xs"
        int len;
#line 928 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_g() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 353 "DSA.xs"
        len = SvCUR(g_SV);
        dsa->g = BN_bin2bn(SvPV(g_SV, len), len, NULL);
#line 940 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_pub_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_pub_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, pub_key_SV");
    {
	DSA *	dsa;
	SV *	pub_key_SV = ST(1)
;
#line 361 "DSA.xs"
        int len;
#line 958 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_pub_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 363 "DSA.xs"
        len = SvCUR(pub_key_SV);
        dsa->pub_key = BN_bin2bn(SvPV(pub_key_SV, len), len, NULL);
#line 970 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_priv_key); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA_set_priv_key)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa, priv_key_SV");
    {
	DSA *	dsa;
	SV *	priv_key_SV = ST(1)
;
#line 371 "DSA.xs"
        int len;
#line 988 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa = INT2PTR(DSA *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::set_priv_key() -- dsa is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 373 "DSA.xs"
        len = SvCUR(priv_key_SV);
        dsa->priv_key = BN_bin2bn(SvPV(priv_key_SV, len), len, NULL);
#line 1000 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	DSA_SIG *	RETVAL;
#line 382 "DSA.xs"
        RETVAL = DSA_SIG_new();
#line 1018 "DSA.c"
	ST(0) = sv_newmortal();
        sv_setref_pv( ST(0), (char *)CLASS, (void*)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::DESTROY() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 390 "DSA.xs"
        DSA_SIG_free(dsa_sig);
#line 1044 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_r)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;
#line 396 "DSA.xs"
        char *to;
        int len;
#line 1061 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::get_r() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 399 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa_sig->r, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 1076 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_s); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_get_s)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "dsa_sig");
    {
	DSA_SIG *	dsa_sig;
#line 410 "DSA.xs"
        char *to;
        int len;
#line 1095 "DSA.c"
	SV *	RETVAL;

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::get_s() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 413 "DSA.xs"
        to = malloc(sizeof(char) * 128);
        len = BN_bn2bin(dsa_sig->s, to);
        RETVAL = newSVpvn(to, len);
        free(to);
#line 1110 "DSA.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_r); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_r)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa_sig, r_SV");
    {
	DSA_SIG *	dsa_sig;
	SV *	r_SV = ST(1)
;
#line 425 "DSA.xs"
        int len;
#line 1130 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::set_r() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 427 "DSA.xs"
        len = SvCUR(r_SV);
        dsa_sig->r = BN_bin2bn(SvPV(r_SV, len), len, NULL);
#line 1142 "DSA.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_s); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Crypt__OpenSSL__DSA__Signature_set_s)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "dsa_sig, s_SV");
    {
	DSA_SIG *	dsa_sig;
	SV *	s_SV = ST(1)
;
#line 435 "DSA.xs"
        int len;
#line 1160 "DSA.c"

    if( sv_isobject(ST(0)) && (SvTYPE(SvRV(ST(0))) == SVt_PVMG) )
            dsa_sig = INT2PTR(DSA_SIG *, SvIV((SV*)SvRV( ST(0) )));
    else{
            warn( "Crypt::OpenSSL::DSA::Signature::set_s() -- dsa_sig is not a blessed SV reference" );
            XSRETURN_UNDEF;
    }
;
#line 437 "DSA.xs"
        len = SvCUR(s_SV);
        dsa_sig->s = BN_bin2bn(SvPV(s_SV, len), len, NULL);
#line 1172 "DSA.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Crypt__OpenSSL__DSA); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Crypt__OpenSSL__DSA)
{
    dVAR; dXSARGS;
#if (PERL_REVISION == 5 && PERL_VERSION < 9)
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#endif
    XS_VERSION_BOOTCHECK;

        newXS("Crypt::OpenSSL::DSA::new", XS_Crypt__OpenSSL__DSA_new, file);
        newXS("Crypt::OpenSSL::DSA::DESTROY", XS_Crypt__OpenSSL__DSA_DESTROY, file);
        newXS("Crypt::OpenSSL::DSA::generate_parameters", XS_Crypt__OpenSSL__DSA_generate_parameters, file);
        newXS("Crypt::OpenSSL::DSA::generate_key", XS_Crypt__OpenSSL__DSA_generate_key, file);
        newXS("Crypt::OpenSSL::DSA::do_sign", XS_Crypt__OpenSSL__DSA_do_sign, file);
        newXS("Crypt::OpenSSL::DSA::sign", XS_Crypt__OpenSSL__DSA_sign, file);
        newXS("Crypt::OpenSSL::DSA::verify", XS_Crypt__OpenSSL__DSA_verify, file);
        newXS("Crypt::OpenSSL::DSA::do_verify", XS_Crypt__OpenSSL__DSA_do_verify, file);
        newXS("Crypt::OpenSSL::DSA::read_params", XS_Crypt__OpenSSL__DSA_read_params, file);
        newXS("Crypt::OpenSSL::DSA::write_params", XS_Crypt__OpenSSL__DSA_write_params, file);
        newXS("Crypt::OpenSSL::DSA::_load_key", XS_Crypt__OpenSSL__DSA__load_key, file);
        newXS("Crypt::OpenSSL::DSA::read_pub_key", XS_Crypt__OpenSSL__DSA_read_pub_key, file);
        newXS("Crypt::OpenSSL::DSA::write_pub_key", XS_Crypt__OpenSSL__DSA_write_pub_key, file);
        newXS("Crypt::OpenSSL::DSA::read_priv_key", XS_Crypt__OpenSSL__DSA_read_priv_key, file);
        newXS("Crypt::OpenSSL::DSA::write_priv_key", XS_Crypt__OpenSSL__DSA_write_priv_key, file);
        newXS("Crypt::OpenSSL::DSA::get_p", XS_Crypt__OpenSSL__DSA_get_p, file);
        newXS("Crypt::OpenSSL::DSA::get_q", XS_Crypt__OpenSSL__DSA_get_q, file);
        newXS("Crypt::OpenSSL::DSA::get_g", XS_Crypt__OpenSSL__DSA_get_g, file);
        newXS("Crypt::OpenSSL::DSA::get_pub_key", XS_Crypt__OpenSSL__DSA_get_pub_key, file);
        newXS("Crypt::OpenSSL::DSA::get_priv_key", XS_Crypt__OpenSSL__DSA_get_priv_key, file);
        newXS("Crypt::OpenSSL::DSA::set_p", XS_Crypt__OpenSSL__DSA_set_p, file);
        newXS("Crypt::OpenSSL::DSA::set_q", XS_Crypt__OpenSSL__DSA_set_q, file);
        newXS("Crypt::OpenSSL::DSA::set_g", XS_Crypt__OpenSSL__DSA_set_g, file);
        newXS("Crypt::OpenSSL::DSA::set_pub_key", XS_Crypt__OpenSSL__DSA_set_pub_key, file);
        newXS("Crypt::OpenSSL::DSA::set_priv_key", XS_Crypt__OpenSSL__DSA_set_priv_key, file);
        newXS("Crypt::OpenSSL::DSA::Signature::new", XS_Crypt__OpenSSL__DSA__Signature_new, file);
        newXS("Crypt::OpenSSL::DSA::Signature::DESTROY", XS_Crypt__OpenSSL__DSA__Signature_DESTROY, file);
        newXS("Crypt::OpenSSL::DSA::Signature::get_r", XS_Crypt__OpenSSL__DSA__Signature_get_r, file);
        newXS("Crypt::OpenSSL::DSA::Signature::get_s", XS_Crypt__OpenSSL__DSA__Signature_get_s, file);
        newXS("Crypt::OpenSSL::DSA::Signature::set_r", XS_Crypt__OpenSSL__DSA__Signature_set_r, file);
        newXS("Crypt::OpenSSL::DSA::Signature::set_s", XS_Crypt__OpenSSL__DSA__Signature_set_s, file);

    /* Initialisation Section */

#line 26 "DSA.xs"
    ERR_load_crypto_strings();

#line 1234 "DSA.c"

    /* End of Initialisation Section */

#if (PERL_REVISION == 5 && PERL_VERSION >= 9)
  if (PL_unitcheckav)
       call_list(PL_scopestack_ix, PL_unitcheckav);
#endif
    XSRETURN_YES;
}

