.TH WHATNOW %manext1% "April 4, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
whatnow \- prompting front-end for sending messages
.SH SYNOPSIS
.HP 5
.na
.B whatnow
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-editor
.IR editor ]
.RB [ \-noedit ]
.RB [ \-prompt
.IR string ]
.RI [ file ]
.RB [ \-version ]
.RB [ \-help ]
.RB [ \-attach
.IR header-field-name ]
.RB [ \-noattach ]
.ad
.SH DESCRIPTION
.B Whatnow
is the default program that queries the user about
the disposition of a composed draft.  It is normally automatically
invoked by one of the
.B nmh
commands
.BR comp ,
.BR dist ,
.BR forw ,
or
.B repl
after the initial edit.
.PP
When started, the editor is started on the draft (unless
.B \-noedit
is given, in which case the initial edit is suppressed).  Then,
.B whatnow
repetitively prompts the user with \*(lqWhat now?\*(rq
and awaits a response.  The valid responses are:
.PP
.RS 5
.TP \w'refilezzzzfolderz'u
.B edit
re\-edit using the same editor that was used on the
preceding round unless a profile entry
\*(lq<lasteditor>\-next: <editor>\*(rq names an alternate editor
.TP \w'refilezzzzfolderz'u
.B edit <editor>
invoke <editor> for further editing
.TP \w'refilezzzzfolderz'u
.B refile +folder
refile the draft into the given folder
.TP \w'refilezzzzfolderz'u
.B mime
process the draft as MIME composition file using
the
.I buildmimeproc
command
.RB ( mhbuild
by default)
.TP \w'refilezzzzfolderz'u
.B display
list the message being distributed/replied\-to
on the terminal
.TP \w'refilezzzzfolderz'u
.B list
list the draft on the terminal
.TP \w'refilezzzzfolderz'u
.B send
send the message
.TP \w'refilezzzzfolderz'u
.B send \-watch
send the message and monitor the delivery process
.TP \w'refilezzzzfolderz'u
.B push
send the message in the background
.TP \w'refilezzzzfolderz'u
.B whom
list the addresses that the message will go to
.TP \w'refilezzzzfolderz'u
.B whom \-check
list the addresses and verify that they are
acceptable to the transport service
.TP \w'refilezzzzfolderz'u
.B quit
preserve the draft and exit
.TP \w'refilezzzzfolderz'u
.B quit \-delete
delete the draft and exit
.TP \w'refilezzzzfolderz'u
.B delete
delete the draft and exit
.TP \w'refilezzzzfolderz'u
.B cd directory
use the directory when interpreting attachment file names
.TP \w'refilezzzzfolderz'u
.B pwd
print the working directory for attachment files
.TP \w'refilezzzzfolderz'u
.B ls [ls-options]
list files in the attachment working directory using the ls command
.TP \w'refilezzzzfolderz'u
.B attach files
add the named files to the draft as MIME attachments
.TP \w'refilezzzzfolderz'u
.B alist [-ln]
list the MIME attachments, either short, long [-l] or numbered [-n]
.TP \w'refilezzzzfolderz'u
.B detach [-n] files-or-numbers
remove MIME attachments, either by file name or by number with -n
.RE
.PP
When entering your response, you need only type enough characters
to uniquely identify the response.
.PP
For the
.B edit
response, any valid switch to the editor is valid.
.PP
For the
.B send
and
.B push
responses, any valid switch to
.IR send (1)
is valid (as
.B push
merely invokes
.B send
with the
.B \-push
option).
.PP
For the
.B whom
response, any valid switch to
.IR whom (1)
is valid.
.PP
For the
.B refile
response, any valid switch to the
.I fileproc
is valid.
.PP
For the
.B display
and
.B list
responses, any valid argument to
the
.I lproc
is valid.  If any non\-switch arguments are present, then
the pathname of the draft will be excluded from the argument list given
to the
.I lproc
(this is useful for listing another
.B nmh
message).
.PP
See
.IR mh\-profile (5)
for further information about how editors
are used by
.BR nmh .
It also discusses how environment variables can be
used to direct
.BR whatnow 's
actions in complex ways.
.PP
The
.B \-prompt
.I string
switch sets the prompting string for
.BR whatnow .
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke
the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the
.IR mh-draft (5)
man page for more
information.
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^<mh\-dir>/draft~^The draft file
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Draft\-Folder:~^To find the default draft\-folder
^Editor:~^To override the default editor
^<lasteditor>\-next:~^To name an editor to be used after exit
^~^from <lasteditor>
^automimeproc:~^If value is 1, and the draft is a MIME
^~^composition file, then automatically call
^~^buildmimeproc prior to sending.
^buildmimeproc:~^Program to translate MIME composition files
^fileproc:~^Program to refile the message
^lproc:~^Program to list the contents of a message
^sendproc:~^Program to use to send the message
^whomproc:~^Program to determine who a message would go to
.fi
.SH "SEE ALSO"
.IR send (1),
.IR whom (1)
.SH DEFAULTS
.nf
.RB ` \-prompt "' defaults to \*(lqWhat\ Now?\ \*(rq"
.RB ` \-attach "' defaults to \*(lqNmh-Attachment\*(rq"
.fi
.SH BUGS
The argument to the
.B \-prompt
switch must be interpreted as a single
token by the shell that invokes
.BR whatnow .
Therefore, one must
usually place the argument to this switch inside quotes.
.PP
If the initial edit fails,
.B whatnow
deletes your draft (by renaming
it with a site-dependent prefix (usually a comma);
failure of a later edit preserves the draft.
.PP
If the
.I buildmimeproc
fails (returns a nonzero status),
.B whatnow
simply prints a \*(lqWhat now?\*(rq prompt.
.B whatnow
depends on the
.I buildmimeproc
to tell the user that something went wrong.
.PP
If
.I whatnowproc
is
.BR whatnow ,
then
.BR comp ,
.BR dist ,
.BR forw ,
and
.B repl
use a built\-in
.BR whatnow ,
and do not actually run the
.B whatnow
program.  Hence, if you define your own
.IR whatnowproc ,
don't call it
.B whatnow
since it won't be run.
.PP
If
.I sendproc
is
.BR send ,
then
.B whatnow
uses a built\-in
.BR send ,
it does not actually run the
.B send
program.  Hence, if
you define your own
.IR sendproc ,
don't call it
.B send
since
.B whatnow
won't run it.
