.TH MHPATH %manext1% "February 18, 2012" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
mhpath \- print full pathnames of nmh messages and folders
.SH SYNOPSIS
.HP 5
.na
.B mhpath
.RI [ +folder ]
.RI [ msgs ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
.B mhpath
expands and sorts the message list `msgs' and writes the full
pathnames of the messages to the standard output separated by newlines.
If no `msgs' are specified,
.B mhpath
outputs the current mail folder's pathname
instead.  If the only argument is `+', your
.B nmh
\*(lqPath\*(rq is output; this can be useful in shell scripts.
.PP
Contrasted with other
.B nmh
commands, a message argument to
.B mhpath
may often be intended for writing.  Because of this:
.PP
.IP 1) 4
the name \*(lqnew\*(rq has been added to
.BR mhpath 's
list of
reserved message names (the others are \*(lqfirst\*(rq, \*(lqlast\*(rq,
\*(lqprev\*(rq, \*(lqnext\*(rq, \*(lqcur\*(rq, and \*(lqall\*(rq).
The new message is equivalent to the message after the last message
in a folder (and equivalent to 1 in a folder without messages).
The \*(lqnew\*(rq message may not be used as part of a message range.
.IP 2) 4
Within a message list, the following designations may refer to messages
that do not exist: a single numeric message name, the single message name
\*(lqcur\*(rq, and (obviously) the single message name \*(lqnew\*(rq.
All other message designations must refer to at least one existing
message, if the folder contains messages.
.IP 3) 4
An empty folder is not in itself an error.
.PP
A message number less than that of the smallest existing message in a
folder is treated as if the message already exists.  A message number
greater than that of the highest existing message in a folder causes
an \*(lqout of range\*(rq error message to be displayed.
.PP
As part of a range designation that contains messages that do exist,
message numbers less than the smallest, or greater than the highest,
existing message in a folder are ignored.
.PP
Examples: The current folder foo contains messages 3 5 6.
Cur is 4.
.PP
.RS 5
.nf
% mhpath
/r/phyl/Mail/foo

% mhpath all
/r/phyl/Mail/foo/3
/r/phyl/Mail/foo/5
/r/phyl/Mail/foo/6

% mhpath 2001
mhpath: message 2001 out of range 1-6

% mhpath 1\-2001
/r/phyl/Mail/foo/3
/r/phyl/Mail/foo/5
/r/phyl/Mail/foo/6

% mhpath new
/r/phyl/Mail/foo/7

% mhpath last new
/r/phyl/Mail/foo/6
/r/phyl/Mail/foo/7

% mhpath last\-new
mhpath: bad message list last\-new

% mhpath cur
/r/phyl/Mail/foo/4

% mhpath 1\-2
mhpath: no messages in range 1\-2

% mhpath first:2
/r/phyl/Mail/foo/3
/r/phyl/Mail/foo/5

% mhpath 1 2
/r/phyl/Mail/foo/1
/r/phyl/Mail/foo/2
.fi
.RE
.PP
.B mhpath
is also useful in back\-quoted operations:
.PP
.RS 5
.nf
% cd `mhpath +inbox`

% echo `mhpath +`
/r/phyl/Mail
.fi
.RE
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
.fi
.SH "SEE ALSO"
.IR folder (1)
.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msgs "' defaults to none"
.fi
.SH CONTEXT
None
.SH BUGS
Like all
.B nmh
commands,
.B mhpath
expands and sorts
.RI [ msgs ].
So don't
expect
.PP
.RS 5
.nf
mv `mhpath 501 500`
.fi
.RE
.PP
to move 501 to 500.
Quite the reverse.  But
.PP
.RS 5
.nf
mv `mhpath 501` `mhpath 500`
.fi
.RE
.PP
will do the trick.
.PP
Out of range message 0 is treated far more severely than large out of
range message numbers.
