.TH FOLDER %manext1% "January 1, 2001" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
folder, folders \- set/list current folder/message
.SH SYNOPSIS
.HP 5
.na
.B folder
.RI [ +folder ]
.RI [ msg ]
.RB [ \-all " | " \-noall ]
.RB [ \-create " | " \-nocreate ]
.RB [ \-fast " | " \-nofast ]
.RB [ \-header " | " \-noheader ]
.RB [ \-recurse " | " \-norecurse ]
.RB [ \-total " | " \-nototal ]
.RB [ \-list " | " \-nolist ]
.RB [ \-push " | " \-pop ]
.RB [ \-pack " | " \-nopack ]
.RB [ \-print ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-version ]
.RB [ \-help ]
.PP
.HP 5
.B folders
is equivalent to
.B folder
.B \-all
.ad
.SH DESCRIPTION
Since the
.B nmh
environment is the shell, it is easy to lose track
of the current folder from day to day.  When
.B folder
is given the
.B \-print
switch (the default),
.B folder
will list the current folder,
the number of messages in it, the range of the messages (low\-high),
and the current message within the folder, and will flag extra files if
they exist.  An example of this summary is:
.PP
.RS 5
.nf
.ta \w'/rnd/phyl/Mail/EP 'u +\w'has ddd messages 'u +\w'(ddd\-ddd); 'u
inbox+	has \016 messages	(\0\03\-\022);	cur=\0\05.
.fi
.RE
.PP
If a
.I +folder
and/or
.I msg
are specified, they will become the current
folder and/or message.  By comparison, when a
.I +folder
argument is given, this corresponds to a \*(lqcd\*(rq operation
in the shell; when no
.I +folder
argument is given, this corresponds roughly to a \*(lqpwd\*(rq
operation in the shell.
.PP
If the specified (or default) folder doesn't exist, the default action
is to query the user as to whether the folder should be created; when
standard input is not a tty, the answer to the query is assumed to be
\*(lqyes\*(rq.
.PP
Specifying
.B \-create
will cause
.B folder
to create new folders
without any query.  (This is the easy way to create an empty folder for
use later.)  Specifying
.B \-nocreate
will cause
.B folder
to exit
without creating a non-existant folder.
.\"
.\" note - this doesn't work at present
.\" If `\-noprint' is specified, 
.\" a `+folder' and/or `msg' may still be specified
.\" to set the current folder and/or message,
.\" but the folder summary will not be printed..SS "Multiple Folders"
Specifying
.B \-all
will produce a summary line for each top-level folder
in the user's nmh directory, sorted alphabetically.  (If
.B folder
is invoked by a name ending with \*(lqs\*(rq (e.g.
.BR folders ),
.B \-all
is assumed).  Specifying
.B \-recurse
with
.B \-all
will also
produce a line for all sub-folders.  These folders are all preceded by
the read\-only folders, which occur as
.RI \*(lq atr\-cur\- \*(rq
entries in the user's
.B nmh
context.  For example:
.PP
.RS 5
.nf
.ta \w'/rnd/phyl/Mail/EP 'u +\w'has ddd messages 'u +\w'(ddd\-ddd); 'u
FOLDER	\0\0\0\0\0\0# MESSAGES	RANGE	CUR     (OTHERS)
/var/work/folder	has \035 messages	(\01\-\035);	cur=23.
/usr/bugs/Mail	has \082 messages	(\01\-108);	cur=82.
ff	has \0no messages.
inbox+	has \016 messages	(\03\-\022);	cur=\05.
mh	has \076 messages	(15\-\076);	cur=70.
notes	has \0\02 messages	(\01\-\0\02);	cur=\01.
ucom	has 124 messages	(\01\-124);	cur=\06; (others).
.ta \w'/rnd/phyl/Mail/EP has 'u
TOTAL = 339 messages in 7 folders
.fi
.RE
.PP
The \*(lq+\*(rq after
.I inbox
indicates that it is the current folder.
The \*(lq(others)\*(rq indicates that the folder
.I ucom
has files which
aren't messages.  These files may either be sub\-folders, or files that
don't belong under the nmh file naming scheme.
.PP
The header is output if either a
.B \-all
or a
.B \-header
switch is specified.  It is suppressed by
.BR \-noheader .
.PP
The folder and message totals are output if either a
.B \-all
or a
.B \-total
switch is specified.  It is suppressed by
.BR \-nototal .
.PP
If
.B \-fast
is given, only the folder name (or names in the case of
.BR \-all )
will be listed.  (This is faster because the folders need not
be read.)
.PP
If a
.I +folder
is given along with the
.B \-all
switch,
.B folder
will, in addition to setting the current folder, list the top\-level subfolders
for the current folder (with
.BR \-norecurse )
or list all sub-folders under the current folder recursively (with
.BR \-recurse ).
.PP
If
.I msg
is supplied, together with
.IR +folder
or without
.BR \-all ,
it will become the current message of
.IR +folder
(if it had been supplied)
or the current folder.
.PP
The
.B \-recurse
switch lists each folder recursively, so use of this
option effectively defeats the speed enhancement of the
.B \-fast
option,
since each folder must be searched for subfolders.  Nevertheless, the
combination of these options is useful.
.PP
.SS "Compacting a Folder"
The
.B \-pack
switch will compress the message names in the designated
folders, removing holes in message numbering.  The
.B \-verbose
switch directs
.B folder
to tell the user the general actions that it is
taking to compress the folder.
.PP
.SS "The Folder Stack"
The
.B \-push
switch directs
.B folder
to push the current folder
onto the
.IR folder\-stack ,
and make the
.I +folder
argument the current folder.  If
.I +folder
is not given, the current folder and the
top of the
.I folder\-stack
are exchanged.  This corresponds to the
\*(lqpushd\*(rq operation in the shell.
.PP
The
.B \-pop
switch directs
.B folder
to discard the top of the
.IR folder\-stack ,
after setting the current folder to that value.
No
.I +folder
argument is allowed.  This corresponds to the \*(lqpopd\*(rq
operation in the shell.  The
.B \-push
switch and the
.B \-pop
switch
are mutually exclusive: the last occurrence of either one overrides
any previous occurrence of the other.  Both of these switches also set
.B \-list
by default.
.PP
The
.B \-list
switch directs
.B folder
to list the contents of
the
.IR folder\-stack .
No
.I +folder
argument is allowed.  After a successful
.B \-push
or
.BR \-pop ,
the
.B \-list
action is taken, unless a
.B \-nolist
switch follows them on the command line.  This corresponds
to the \*(lqdirs\*(rq operation in the shell.  The
.BR \-push ,
.BR \-pop ,
and
.B \-list
switches turn off
.BR \-print .
.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^Folder\-Protect:~^To set mode when creating a new folder
^Folder\-Stack:~^To determine the folder stack
.\" ^lsproc:~^Program to list the contents of a folder
.fi
.SH "SEE ALSO"
.IR mhpath (1),
.IR refile (1)
.SH DEFAULTS
.nf
.RB ` +folder "' defaults to the current folder"
.RB ` msg "' defaults to none"
.RB ` \-nofast '
.RB ` \-noheader '
.RB ` \-nototal '
.RB ` \-nopack '
.RB ` \-norecurse '
.RB ` \-noverbose '
.RB ` \-print "' is the default if no " \-list ", " \-push ", or " \-pop " is specified"
.RB ` \-list "' is the default if " \-push ", or " \-pop " is specified"
.fi
.SH CONTEXT
If
.I +folder
and/or
.I msg
are given, they will become the current folder and/or message.
.SH BUGS
There is no way to restore the default behavior 
(to ask the user whether to create a non-existant folder)
after
.B \-create
or
.B \-nocreate
is given.
