#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

#|
=============================================
The Logiweb Compiler
=============================================
Clisp make file
=============================================
Usage:
clisp make lgc:     compile Logiweb compiler
clisp make all:     equivalent to clisp make lgc
clisp make:         equivalent to clisp make all
clisp make clean:   clean up after clisp make all
|#

(in-package "COMMON-LISP-USER")
(load     "../common/test")
(testload "../common/def"   :prompt nil :test nil)
(testload "../common/maker" :prompt nil :test nil)

#|
=============================================
clisp make all
=============================================
|#

(deff make-all ()
 (make-lgc)
 (make-submit)
 (make-create))

#|
=============================================
clisp make lgc-only
=============================================
|#

(deff make-lgc-only ()
 (make-lgc))

#|
=============================================
clisp make lgc
=============================================
Compile Logiweb compiler
|#

(deff make-lgc ()
 (:let lisp-files (dir* "*.lisp" "../*.lisp" "../common/*.lisp"))
 (when (needs-update "lgc" "../common/logiweb.c" lisp-files)
  (testload "source" :prompt nil :test nil)
  (setq *conf* (option "varconf"))
  (dump "lgc" 'main)))

#|
=============================================
clisp make submit
=============================================
CGI-program for submitting to a Logiwiki
|#

(deff make-submit ()
 (mk-option-load)
 (:let files (list "../logiweb.conf" (option "conf") "make.lisp"))
 (:unless (needs-update "submit" files) nil)
 (write-file s "submit" (format s "#!/bin/bash
echo Content-type: text/html
echo 
echo '<html>'
echo '<head>'
echo '<title>Logiwiki Response</title>'
echo '<link rel=\"icon\" href=\"../doc/logiweb.ico\"'
echo 'type=\"image/x-icon\" />'
echo '<link rel=\"shortcut icon\" href=\"../doc/logiweb.ico\"'
echo 'type=\"image/x-icon\" />'
echo '</head>'
echo '<body bgcolor=yellow>'
echo '<img alt=\"Logiweb\", height=\"62\", width=\"46\", align=\"right\",'
echo 'hspace=\"30\", src=\"../doc/logiweb.png\"/>'
echo '<h2>Logiwiki Response</h2>'
echo '<p>'
echo '<a href=\"../tutorial/index.html\">Up</a>.'
echo '<a href=\"../tutorial/submit.html\">Submission form</a>.'
echo '<a href=\"../tutorial/help.html\">Help</a>.'
echo '</p>'
echo '<pre>'
read l
/usr/local/bin/lgc destsubmit='$PAGE$/$DATE$' desttemp='$PAGE$/undated' cache=~a url=~a post=$l 2>&1
echo '</pre>'
echo '<address>'
echo '<a href=\"http://www.diku.dk/~~grue/index.html\">Klaus Grue</a>,'
echo '<a href=\"../doc/misc/time.html\">GRD-2006-12-18</a></address>'
echo '</address>'
echo '</body>'
echo '</html>'
echo 
" (cat (slash (option "varhome")) "cache") (option "wikisubmit")))
 (run-chmod "755" "submit"))

#|
=============================================
clisp make submit
=============================================
CGI-program for creating a Logiwiki article
|#

(deff make-create ()
 (mk-option-load)
 (:let files (list "../logiweb.conf" (option "conf") "make.lisp"))
 (:unless (needs-update "create" files) nil)
 (write-file s "create" (format s "#!/bin/bash
echo Content-type: text/html
echo 
echo '<html>'
echo '<head>'
echo '<title>Logiwiki Submission</title>'
echo '<link rel=\"icon\" href=\"../doc/logiweb.ico\"'
echo 'type=\"image/x-icon\" />'
echo '<link rel=\"shortcut icon\" href=\"../doc/logiweb.ico\"'
echo 'type=\"image/x-icon\" />'
echo '</head>'
echo '<body bgcolor=yellow>'
echo '<img alt=\"Logiweb\", height=\"62\", width=\"46\", align=\"right\",'
echo 'hspace=\"30\", src=\"../doc/logiweb.png\"/>'
echo '<h2>Logiwiki Submission</h2>'
echo '<p>'
echo '<a href=\"../index.html\">Home</a>.'
echo '<a href=\"../tutorial/index.html\">Tutorial</a>.'
echo '<a href=\"../tutorial/help.html\">Help</a>.'
echo '</p>'
echo ''
echo '<form action=\"../server/submit\" method=post>'
echo ''
echo '<input type=\"submit\" value=\"Submit\">'
echo ''
echo '&nbsp;org=<input type=\"text\" name=\"org\" size=10>'
echo ''
echo '&nbsp;name=<input type=\"text\" name=\"name\" size=10>'
echo ''
echo '&nbsp;level=<select name=\"level\">'
echo '<option> parse'
echo '<option> compile'
echo '<option> diagnose'
echo '<option selected> body'
echo '<option> codex'
echo '<option> all'
echo '<option> submit'
echo '</select>'
echo ''
echo '&nbsp;test=<select name=\"test\">'
echo '<option> yes'
echo '<option> no'
echo '</select>'
echo ''
echo '&nbsp;verbose=<select name=\"verbose\">'
echo '<option> 0'
echo '<option> 1'
echo '<option> 2'
echo '</select>'
echo ''
echo '&nbsp;header=<select name=\"header\">'
echo '<option> warn'
echo '<option> nowarn'
echo '<option> suggest'
echo '</select>'
echo ''
echo '<pre>'
read l
/usr/local/bin/lgc destsubmit='$PAGE$/$DATE$' desttemp='$PAGE$/undated' cache=~a url=~a header=html org=dummy name=dummy verbose=-1 post=$l 2>&1
echo '</pre>'
echo '</form>'
echo '<address>'
echo '<a href=\"http://www.diku.dk/~~grue/index.html\">Klaus Grue</a>,'
echo '<a href=\"../doc/misc/time.html\">GRD-2007-07-10</a></address>'
echo '</address>'
echo '</body>'
echo '</html>'
echo 
" (cat (slash (option "varhome")) "cache") (option "wikisubmit")))
 (run-chmod "755" "create"))

#|
=============================================
clisp make clean
=============================================
|#

(deff make-clean ()
 (ext:shell "rm -f *.lgo")
 (ext:shell "rm -f try")
 (delete-links "index.html")
 (delete-patterns
  "*.fas" "*.lib" "*.lgw" "*.stackdump" "*%"
  "lgc" "lgc2" "lgwmachine" "submit" "create"
  "hello" "echo" "eecho" "test1" "fix" "lgciotest"
  "lgwdir.html" "testdir/" "translate"
  "build/src/lgwam" "build/src/lgc" "build/src/pages.c" "build/src/pages"
  "build/src/logiweb.eps" "build/src/logiweb.ico" "build/src/logiweb.png"
  "build/src/base.lgs" "build/src/lgc.lgs" "build/src/version"
  "build/src/testsuite/pages/check.lgs"
  "build/src/testsuite/pages/combinations.lgs"
  "build/src/testsuite/pages/multzero.lgs"
  "build/src/testsuite/pages/Peano.lgs"
  "build/src/testsuite/pages/test.lgs"
  "build/src/testsuite/pages/testmachine.lgs"
  "build/CHANGELOG" "build/COPYING"
  "build/self/" "build/.self/"
  "build/logiweb/" "build/name/"
  "build/src/boot/" "build/src/boot1/")
 (ext:shell "rm -f build/logiweb/*"))

#|
=============================================
Make this a make file
=============================================
(exec-make) turns a shell command like "clisp make clean" into an
invokation of (make-clean) inside clisp
|#

(exec-make)
