#|  Logiweb, a system for electronic distribution of mathematics
    Copyright (C) 2004-2010 Klaus Grue

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact: Klaus Grue, DIKU, Universitetsparken 1, DK2100 Copenhagen,
    Denmark, grue@diku.dk, http://logiweb.eu/, http://www.diku.dk/~grue/

    Logiweb is a system for distribution of mathematical definitions,
    lemmas, and proofs. For more on Logiweb, consult http://logiweb.eu/.
|#

#|
=============================================
The Logiweb Compiler
=============================================
Logiweb reference conversion functions
=============================================

|#

(in-package "COMMON-LISP-USER")

#|
=============================================
Kana
=============================================
|#

(defc kana-consonants (ct2ct "ntsk"))

(defc kana-vovels (ct2ct "aiue"))

(deff card2consonant (n)
 (nth (mod n 4) kana-consonants))

(deff card2vovel (n)
 (nth (mod n 4) kana-vovels))

(deff card2sylable (n)
 (cons (card2consonant (floor n 4)) (card2vovel n)))

(deff card2kana (n)
 (cons (card2sylable (floor n 16)) (card2sylable n)))

(etst (ct2string (card2kana  0)) "nana")
(etst (ct2string (card2kana  1)) "nani")
(etst (ct2string (card2kana  4)) "nata")
(etst (ct2string (card2kana 16)) "nina")
(etst (ct2string (card2kana 64)) "tana")

(deff consonant2card (card)
 (position card kana-consonants))

(deff vovel2card (card)
 (position card kana-vovels))

(etst (consonant2card (ct2ct #\t)) 1)
(ntst (consonant2card (ct2ct #\i)))
(ntst (vovel2card (ct2ct #\t)))
(etst (vovel2card (ct2ct #\i)) 1)

(deff card*2kana (card* sep3 fct)
 (:when (null card*) nil)
 (:let (card . card*) card*)
 (:when (null card*) (funcall fct card))
 (list* (funcall fct card) sep3 (card*2kana card* sep3 fct)))

(deff ref2short-kana (length ref)
 (:let card* (card2ref ref))
 (:let card* (safe-subseq card* 0 length))
 (card*2kana card* #\Space #'card2kana))

(etst
 (ct2string
  (ref2short-kana 5
   (ref2card '(1  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0  0))))
 "nani nane nana nana nana")

(deff ref2kana (ref)
 (ref2kana0 ref #\Newline "  " #\Space #'card2kana))

(deff ref2kana0 (ref sep1 sep2 sep3 fct)
 (:let ref (card2ref ref))
 (:let split (+ 1 (position 128 ref :test '>)))
 (list
  (ref2kana1 (subseq ref 0 split) sep1 sep2 sep3 fct)
  sep1
  (ref2kana1 (subseq ref split) sep1 sep2 sep3 fct)))

(deff ref2kana1 (ref sep1 sep2 sep3 fct)
 (:let ref1 (safe-subseq ref 0 5))
 (:let ref2 (safe-subseq ref 5))
 (:when (null ref2) (card*2kana ref1 sep3 fct))
 (list (card*2kana ref1 sep3 fct) sep2 (ref2kana2 ref2 sep1 sep2 sep3 fct)))

(deff ref2kana2 (ref sep1 sep2 sep3 fct)
 (:let ref1 (safe-subseq ref 0 5))
 (:let ref2 (safe-subseq ref 5))
 (:when (null ref2) (card*2kana ref1 sep3 fct))
 (list (card*2kana ref1 sep3 fct) sep1 (ref2kana1 ref2 sep1 sep2 sep3 fct)))

(etst
 (ct2string
  (ref2kana
   (ref2card '(1  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0  0))))
"nani
nane nana nana nana nana  nana nana nana nana nana
nane nana nana nana nana  nana nana nana nana nana
nane nana nana nana nana  nana")

(etst
 (ct2string
  (ref2kana
   (ref2card
    '(128 127  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0  0 0 0 0 0  3 0 0 0 0))))
"sana teke
nane nana nana nana nana  nana nana nana nana nana
nane nana nana nana nana  nana nana nana nana nana
nane nana nana nana nana")

#|
=============================================
Print reference
=============================================
|#

(deff print-kana-ref (ref)
 (format t "~a~%" (ct2string (ref2kana ref))))

