/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Assembly Matcher Source Fragment                                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_ASSEMBLER_HEADER
#undef GET_ASSEMBLER_HEADER
  // This should be included into the middle of the declaration of
  // your subclasses implementation of MCTargetAsmParser.
  uint64_t ComputeAvailableFeatures(const FeatureBitset& FB) const;
  void convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                       const OperandVector &Operands);
  void convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) override;
  bool mnemonicIsValid(StringRef Mnemonic, unsigned VariantID) override;
  unsigned MatchInstructionImpl(const OperandVector &Operands,
                                MCInst &Inst,
                                uint64_t &ErrorInfo, bool matchingInlineAsm,
                                unsigned VariantID = 0);
#endif // GET_ASSEMBLER_HEADER_INFO


#ifdef GET_OPERAND_DIAGNOSTIC_TYPES
#undef GET_OPERAND_DIAGNOSTIC_TYPES

#endif // GET_OPERAND_DIAGNOSTIC_TYPES


#ifdef GET_REGISTER_MATCHER
#undef GET_REGISTER_MATCHER

// Flags for subtarget features that participate in instruction matching.
enum SubtargetFeatureFlag : uint16_t {
  Feature_HasAVX512 = (1ULL << 0),
  Feature_HasCDI = (1ULL << 2),
  Feature_HasPFI = (1ULL << 5),
  Feature_HasERI = (1ULL << 4),
  Feature_HasDQI = (1ULL << 3),
  Feature_HasBWI = (1ULL << 1),
  Feature_HasVLX = (1ULL << 6),
  Feature_Not64BitMode = (1ULL << 11),
  Feature_In64BitMode = (1ULL << 9),
  Feature_In16BitMode = (1ULL << 7),
  Feature_Not16BitMode = (1ULL << 10),
  Feature_In32BitMode = (1ULL << 8),
  Feature_None = 0
};

static unsigned MatchRegisterName(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 2:	 // 33 strings to match.
    switch (Name[0]) {
    default: break;
    case 'a':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 1;	 // "ah"
      case 'l':	 // 1 string to match.
        return 2;	 // "al"
      case 'x':	 // 1 string to match.
        return 3;	 // "ax"
      }
      break;
    case 'b':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 4;	 // "bh"
      case 'l':	 // 1 string to match.
        return 5;	 // "bl"
      case 'p':	 // 1 string to match.
        return 6;	 // "bp"
      case 'x':	 // 1 string to match.
        return 8;	 // "bx"
      }
      break;
    case 'c':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 9;	 // "ch"
      case 'l':	 // 1 string to match.
        return 10;	 // "cl"
      case 's':	 // 1 string to match.
        return 11;	 // "cs"
      case 'x':	 // 1 string to match.
        return 12;	 // "cx"
      }
      break;
    case 'd':	 // 5 strings to match.
      switch (Name[1]) {
      default: break;
      case 'h':	 // 1 string to match.
        return 13;	 // "dh"
      case 'i':	 // 1 string to match.
        return 14;	 // "di"
      case 'l':	 // 1 string to match.
        return 16;	 // "dl"
      case 's':	 // 1 string to match.
        return 17;	 // "ds"
      case 'x':	 // 1 string to match.
        return 18;	 // "dx"
      }
      break;
    case 'e':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 28;	 // "es"
    case 'f':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 32;	 // "fs"
    case 'g':	 // 1 string to match.
      if (Name[1] != 's')
        break;
      return 33;	 // "gs"
    case 'i':	 // 1 string to match.
      if (Name[1] != 'p')
        break;
      return 34;	 // "ip"
    case 'k':	 // 8 strings to match.
      switch (Name[1]) {
      default: break;
      case '0':	 // 1 string to match.
        return 94;	 // "k0"
      case '1':	 // 1 string to match.
        return 95;	 // "k1"
      case '2':	 // 1 string to match.
        return 96;	 // "k2"
      case '3':	 // 1 string to match.
        return 97;	 // "k3"
      case '4':	 // 1 string to match.
        return 98;	 // "k4"
      case '5':	 // 1 string to match.
        return 99;	 // "k5"
      case '6':	 // 1 string to match.
        return 100;	 // "k6"
      case '7':	 // 1 string to match.
        return 101;	 // "k7"
      }
      break;
    case 'r':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case '8':	 // 1 string to match.
        return 110;	 // "r8"
      case '9':	 // 1 string to match.
        return 111;	 // "r9"
      }
      break;
    case 's':	 // 3 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        return 45;	 // "si"
      case 'p':	 // 1 string to match.
        return 47;	 // "sp"
      case 's':	 // 1 string to match.
        return 49;	 // "ss"
      }
      break;
    }
    break;
  case 3:	 // 72 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 1 string to match.
      if (memcmp(Name.data()+1, "pl", 2))
        break;
      return 7;	 // "bpl"
    case 'c':	 // 10 strings to match.
      if (Name[1] != 'r')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 54;	 // "cr0"
      case '1':	 // 1 string to match.
        return 55;	 // "cr1"
      case '2':	 // 1 string to match.
        return 56;	 // "cr2"
      case '3':	 // 1 string to match.
        return 57;	 // "cr3"
      case '4':	 // 1 string to match.
        return 58;	 // "cr4"
      case '5':	 // 1 string to match.
        return 59;	 // "cr5"
      case '6':	 // 1 string to match.
        return 60;	 // "cr6"
      case '7':	 // 1 string to match.
        return 61;	 // "cr7"
      case '8':	 // 1 string to match.
        return 62;	 // "cr8"
      case '9':	 // 1 string to match.
        return 63;	 // "cr9"
      }
      break;
    case 'd':	 // 11 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 15;	 // "dil"
      case 'r':	 // 10 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 70;	 // "dr0"
        case '1':	 // 1 string to match.
          return 71;	 // "dr1"
        case '2':	 // 1 string to match.
          return 72;	 // "dr2"
        case '3':	 // 1 string to match.
          return 73;	 // "dr3"
        case '4':	 // 1 string to match.
          return 74;	 // "dr4"
        case '5':	 // 1 string to match.
          return 75;	 // "dr5"
        case '6':	 // 1 string to match.
          return 76;	 // "dr6"
        case '7':	 // 1 string to match.
          return 77;	 // "dr7"
        case '8':	 // 1 string to match.
          return 78;	 // "dr8"
        case '9':	 // 1 string to match.
          return 79;	 // "dr9"
        }
        break;
      }
      break;
    case 'e':	 // 10 strings to match.
      switch (Name[1]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 19;	 // "eax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 20;	 // "ebp"
        case 'x':	 // 1 string to match.
          return 21;	 // "ebx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 22;	 // "ecx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 23;	 // "edi"
        case 'x':	 // 1 string to match.
          return 24;	 // "edx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 26;	 // "eip"
        case 'z':	 // 1 string to match.
          return 27;	 // "eiz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 29;	 // "esi"
        case 'p':	 // 1 string to match.
          return 30;	 // "esp"
        }
        break;
      }
      break;
    case 'f':	 // 8 strings to match.
      if (Name[1] != 'p')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 86;	 // "fp0"
      case '1':	 // 1 string to match.
        return 87;	 // "fp1"
      case '2':	 // 1 string to match.
        return 88;	 // "fp2"
      case '3':	 // 1 string to match.
        return 89;	 // "fp3"
      case '4':	 // 1 string to match.
        return 90;	 // "fp4"
      case '5':	 // 1 string to match.
        return 91;	 // "fp5"
      case '6':	 // 1 string to match.
        return 92;	 // "fp6"
      case '7':	 // 1 string to match.
        return 93;	 // "fp7"
      }
      break;
    case 'm':	 // 8 strings to match.
      if (Name[1] != 'm')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 1 string to match.
        return 102;	 // "mm0"
      case '1':	 // 1 string to match.
        return 103;	 // "mm1"
      case '2':	 // 1 string to match.
        return 104;	 // "mm2"
      case '3':	 // 1 string to match.
        return 105;	 // "mm3"
      case '4':	 // 1 string to match.
        return 106;	 // "mm4"
      case '5':	 // 1 string to match.
        return 107;	 // "mm5"
      case '6':	 // 1 string to match.
        return 108;	 // "mm6"
      case '7':	 // 1 string to match.
        return 109;	 // "mm7"
      }
      break;
    case 'r':	 // 22 strings to match.
      switch (Name[1]) {
      default: break;
      case '1':	 // 6 strings to match.
        switch (Name[2]) {
        default: break;
        case '0':	 // 1 string to match.
          return 112;	 // "r10"
        case '1':	 // 1 string to match.
          return 113;	 // "r11"
        case '2':	 // 1 string to match.
          return 114;	 // "r12"
        case '3':	 // 1 string to match.
          return 115;	 // "r13"
        case '4':	 // 1 string to match.
          return 116;	 // "r14"
        case '5':	 // 1 string to match.
          return 117;	 // "r15"
        }
        break;
      case '8':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 222;	 // "r8b"
        case 'd':	 // 1 string to match.
          return 230;	 // "r8d"
        case 'w':	 // 1 string to match.
          return 238;	 // "r8w"
        }
        break;
      case '9':	 // 3 strings to match.
        switch (Name[2]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 223;	 // "r9b"
        case 'd':	 // 1 string to match.
          return 231;	 // "r9d"
        case 'w':	 // 1 string to match.
          return 239;	 // "r9w"
        }
        break;
      case 'a':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 35;	 // "rax"
      case 'b':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 36;	 // "rbp"
        case 'x':	 // 1 string to match.
          return 37;	 // "rbx"
        }
        break;
      case 'c':	 // 1 string to match.
        if (Name[2] != 'x')
          break;
        return 38;	 // "rcx"
      case 'd':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 39;	 // "rdi"
        case 'x':	 // 1 string to match.
          return 40;	 // "rdx"
        }
        break;
      case 'i':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'p':	 // 1 string to match.
          return 41;	 // "rip"
        case 'z':	 // 1 string to match.
          return 42;	 // "riz"
        }
        break;
      case 's':	 // 2 strings to match.
        switch (Name[2]) {
        default: break;
        case 'i':	 // 1 string to match.
          return 43;	 // "rsi"
        case 'p':	 // 1 string to match.
          return 44;	 // "rsp"
        }
        break;
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'i':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 46;	 // "sil"
      case 'p':	 // 1 string to match.
        if (Name[2] != 'l')
          break;
        return 48;	 // "spl"
      }
      break;
    }
    break;
  case 4:	 // 65 strings to match.
    switch (Name[0]) {
    default: break;
    case 'b':	 // 4 strings to match.
      if (memcmp(Name.data()+1, "nd", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 50;	 // "bnd0"
      case '1':	 // 1 string to match.
        return 51;	 // "bnd1"
      case '2':	 // 1 string to match.
        return 52;	 // "bnd2"
      case '3':	 // 1 string to match.
        return 53;	 // "bnd3"
      }
      break;
    case 'c':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 64;	 // "cr10"
      case '1':	 // 1 string to match.
        return 65;	 // "cr11"
      case '2':	 // 1 string to match.
        return 66;	 // "cr12"
      case '3':	 // 1 string to match.
        return 67;	 // "cr13"
      case '4':	 // 1 string to match.
        return 68;	 // "cr14"
      case '5':	 // 1 string to match.
        return 69;	 // "cr15"
      }
      break;
    case 'd':	 // 6 strings to match.
      if (memcmp(Name.data()+1, "r1", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 80;	 // "dr10"
      case '1':	 // 1 string to match.
        return 81;	 // "dr11"
      case '2':	 // 1 string to match.
        return 82;	 // "dr12"
      case '3':	 // 1 string to match.
        return 83;	 // "dr13"
      case '4':	 // 1 string to match.
        return 84;	 // "dr14"
      case '5':	 // 1 string to match.
        return 85;	 // "dr15"
      }
      break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "psw", 3))
        break;
      return 31;	 // "fpsw"
    case 'r':	 // 18 strings to match.
      if (Name[1] != '1')
        break;
      switch (Name[2]) {
      default: break;
      case '0':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 224;	 // "r10b"
        case 'd':	 // 1 string to match.
          return 232;	 // "r10d"
        case 'w':	 // 1 string to match.
          return 240;	 // "r10w"
        }
        break;
      case '1':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 225;	 // "r11b"
        case 'd':	 // 1 string to match.
          return 233;	 // "r11d"
        case 'w':	 // 1 string to match.
          return 241;	 // "r11w"
        }
        break;
      case '2':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 226;	 // "r12b"
        case 'd':	 // 1 string to match.
          return 234;	 // "r12d"
        case 'w':	 // 1 string to match.
          return 242;	 // "r12w"
        }
        break;
      case '3':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 227;	 // "r13b"
        case 'd':	 // 1 string to match.
          return 235;	 // "r13d"
        case 'w':	 // 1 string to match.
          return 243;	 // "r13w"
        }
        break;
      case '4':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 228;	 // "r14b"
        case 'd':	 // 1 string to match.
          return 236;	 // "r14d"
        case 'w':	 // 1 string to match.
          return 244;	 // "r14w"
        }
        break;
      case '5':	 // 3 strings to match.
        switch (Name[3]) {
        default: break;
        case 'b':	 // 1 string to match.
          return 229;	 // "r15b"
        case 'd':	 // 1 string to match.
          return 237;	 // "r15d"
        case 'w':	 // 1 string to match.
          return 245;	 // "r15w"
        }
        break;
      }
      break;
    case 'x':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 126;	 // "xmm0"
      case '1':	 // 1 string to match.
        return 127;	 // "xmm1"
      case '2':	 // 1 string to match.
        return 128;	 // "xmm2"
      case '3':	 // 1 string to match.
        return 129;	 // "xmm3"
      case '4':	 // 1 string to match.
        return 130;	 // "xmm4"
      case '5':	 // 1 string to match.
        return 131;	 // "xmm5"
      case '6':	 // 1 string to match.
        return 132;	 // "xmm6"
      case '7':	 // 1 string to match.
        return 133;	 // "xmm7"
      case '8':	 // 1 string to match.
        return 134;	 // "xmm8"
      case '9':	 // 1 string to match.
        return 135;	 // "xmm9"
      }
      break;
    case 'y':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 158;	 // "ymm0"
      case '1':	 // 1 string to match.
        return 159;	 // "ymm1"
      case '2':	 // 1 string to match.
        return 160;	 // "ymm2"
      case '3':	 // 1 string to match.
        return 161;	 // "ymm3"
      case '4':	 // 1 string to match.
        return 162;	 // "ymm4"
      case '5':	 // 1 string to match.
        return 163;	 // "ymm5"
      case '6':	 // 1 string to match.
        return 164;	 // "ymm6"
      case '7':	 // 1 string to match.
        return 165;	 // "ymm7"
      case '8':	 // 1 string to match.
        return 166;	 // "ymm8"
      case '9':	 // 1 string to match.
        return 167;	 // "ymm9"
      }
      break;
    case 'z':	 // 10 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        return 190;	 // "zmm0"
      case '1':	 // 1 string to match.
        return 191;	 // "zmm1"
      case '2':	 // 1 string to match.
        return 192;	 // "zmm2"
      case '3':	 // 1 string to match.
        return 193;	 // "zmm3"
      case '4':	 // 1 string to match.
        return 194;	 // "zmm4"
      case '5':	 // 1 string to match.
        return 195;	 // "zmm5"
      case '6':	 // 1 string to match.
        return 196;	 // "zmm6"
      case '7':	 // 1 string to match.
        return 197;	 // "zmm7"
      case '8':	 // 1 string to match.
        return 198;	 // "zmm8"
      case '9':	 // 1 string to match.
        return 199;	 // "zmm9"
      }
      break;
    }
    break;
  case 5:	 // 75 strings to match.
    switch (Name[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Name.data()+1, "lags", 4))
        break;
      return 25;	 // "flags"
    case 's':	 // 8 strings to match.
      if (memcmp(Name.data()+1, "t(", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '0':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 118;	 // "st(0)"
      case '1':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 119;	 // "st(1)"
      case '2':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 120;	 // "st(2)"
      case '3':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 121;	 // "st(3)"
      case '4':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 122;	 // "st(4)"
      case '5':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 123;	 // "st(5)"
      case '6':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 124;	 // "st(6)"
      case '7':	 // 1 string to match.
        if (Name[4] != ')')
          break;
        return 125;	 // "st(7)"
      }
      break;
    case 'x':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 136;	 // "xmm10"
        case '1':	 // 1 string to match.
          return 137;	 // "xmm11"
        case '2':	 // 1 string to match.
          return 138;	 // "xmm12"
        case '3':	 // 1 string to match.
          return 139;	 // "xmm13"
        case '4':	 // 1 string to match.
          return 140;	 // "xmm14"
        case '5':	 // 1 string to match.
          return 141;	 // "xmm15"
        case '6':	 // 1 string to match.
          return 142;	 // "xmm16"
        case '7':	 // 1 string to match.
          return 143;	 // "xmm17"
        case '8':	 // 1 string to match.
          return 144;	 // "xmm18"
        case '9':	 // 1 string to match.
          return 145;	 // "xmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 146;	 // "xmm20"
        case '1':	 // 1 string to match.
          return 147;	 // "xmm21"
        case '2':	 // 1 string to match.
          return 148;	 // "xmm22"
        case '3':	 // 1 string to match.
          return 149;	 // "xmm23"
        case '4':	 // 1 string to match.
          return 150;	 // "xmm24"
        case '5':	 // 1 string to match.
          return 151;	 // "xmm25"
        case '6':	 // 1 string to match.
          return 152;	 // "xmm26"
        case '7':	 // 1 string to match.
          return 153;	 // "xmm27"
        case '8':	 // 1 string to match.
          return 154;	 // "xmm28"
        case '9':	 // 1 string to match.
          return 155;	 // "xmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 156;	 // "xmm30"
        case '1':	 // 1 string to match.
          return 157;	 // "xmm31"
        }
        break;
      }
      break;
    case 'y':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 168;	 // "ymm10"
        case '1':	 // 1 string to match.
          return 169;	 // "ymm11"
        case '2':	 // 1 string to match.
          return 170;	 // "ymm12"
        case '3':	 // 1 string to match.
          return 171;	 // "ymm13"
        case '4':	 // 1 string to match.
          return 172;	 // "ymm14"
        case '5':	 // 1 string to match.
          return 173;	 // "ymm15"
        case '6':	 // 1 string to match.
          return 174;	 // "ymm16"
        case '7':	 // 1 string to match.
          return 175;	 // "ymm17"
        case '8':	 // 1 string to match.
          return 176;	 // "ymm18"
        case '9':	 // 1 string to match.
          return 177;	 // "ymm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 178;	 // "ymm20"
        case '1':	 // 1 string to match.
          return 179;	 // "ymm21"
        case '2':	 // 1 string to match.
          return 180;	 // "ymm22"
        case '3':	 // 1 string to match.
          return 181;	 // "ymm23"
        case '4':	 // 1 string to match.
          return 182;	 // "ymm24"
        case '5':	 // 1 string to match.
          return 183;	 // "ymm25"
        case '6':	 // 1 string to match.
          return 184;	 // "ymm26"
        case '7':	 // 1 string to match.
          return 185;	 // "ymm27"
        case '8':	 // 1 string to match.
          return 186;	 // "ymm28"
        case '9':	 // 1 string to match.
          return 187;	 // "ymm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 188;	 // "ymm30"
        case '1':	 // 1 string to match.
          return 189;	 // "ymm31"
        }
        break;
      }
      break;
    case 'z':	 // 22 strings to match.
      if (memcmp(Name.data()+1, "mm", 2))
        break;
      switch (Name[3]) {
      default: break;
      case '1':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 200;	 // "zmm10"
        case '1':	 // 1 string to match.
          return 201;	 // "zmm11"
        case '2':	 // 1 string to match.
          return 202;	 // "zmm12"
        case '3':	 // 1 string to match.
          return 203;	 // "zmm13"
        case '4':	 // 1 string to match.
          return 204;	 // "zmm14"
        case '5':	 // 1 string to match.
          return 205;	 // "zmm15"
        case '6':	 // 1 string to match.
          return 206;	 // "zmm16"
        case '7':	 // 1 string to match.
          return 207;	 // "zmm17"
        case '8':	 // 1 string to match.
          return 208;	 // "zmm18"
        case '9':	 // 1 string to match.
          return 209;	 // "zmm19"
        }
        break;
      case '2':	 // 10 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 210;	 // "zmm20"
        case '1':	 // 1 string to match.
          return 211;	 // "zmm21"
        case '2':	 // 1 string to match.
          return 212;	 // "zmm22"
        case '3':	 // 1 string to match.
          return 213;	 // "zmm23"
        case '4':	 // 1 string to match.
          return 214;	 // "zmm24"
        case '5':	 // 1 string to match.
          return 215;	 // "zmm25"
        case '6':	 // 1 string to match.
          return 216;	 // "zmm26"
        case '7':	 // 1 string to match.
          return 217;	 // "zmm27"
        case '8':	 // 1 string to match.
          return 218;	 // "zmm28"
        case '9':	 // 1 string to match.
          return 219;	 // "zmm29"
        }
        break;
      case '3':	 // 2 strings to match.
        switch (Name[4]) {
        default: break;
        case '0':	 // 1 string to match.
          return 220;	 // "zmm30"
        case '1':	 // 1 string to match.
          return 221;	 // "zmm31"
        }
        break;
      }
      break;
    }
    break;
  }
  return 0;
}

#endif // GET_REGISTER_MATCHER


#ifdef GET_SUBTARGET_FEATURE_NAME
#undef GET_SUBTARGET_FEATURE_NAME

// User-level names for subtarget features that participate in
// instruction matching.
static const char *getSubtargetFeatureName(uint64_t Val) {
  switch(Val) {
  case Feature_HasAVX512: return "AVX-512 ISA";
  case Feature_HasCDI: return "AVX-512 CD ISA";
  case Feature_HasPFI: return "AVX-512 PF ISA";
  case Feature_HasERI: return "AVX-512 ER ISA";
  case Feature_HasDQI: return "AVX-512 DQ ISA";
  case Feature_HasBWI: return "AVX-512 BW ISA";
  case Feature_HasVLX: return "AVX-512 VL ISA";
  case Feature_Not64BitMode: return "Not 64-bit mode";
  case Feature_In64BitMode: return "64-bit mode";
  case Feature_In16BitMode: return "16-bit mode";
  case Feature_Not16BitMode: return "Not 16-bit mode";
  case Feature_In32BitMode: return "32-bit mode";
  default: return "(unknown)";
  }
}

#endif // GET_SUBTARGET_FEATURE_NAME


#ifdef GET_MATCHER_IMPLEMENTATION
#undef GET_MATCHER_IMPLEMENTATION

static void applyMnemonicAliases(StringRef &Mnemonic, uint64_t Features, unsigned VariantID) {
  switch (VariantID) {
    case 0:
      switch (Mnemonic.size()) {
      default: break;
      case 3:	 // 6 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 4 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'b':	 // 1 string to match.
            if (Mnemonic[2] != 'w')
              break;
            Mnemonic = "cbtw";	 // "cbw"
            return;
          case 'd':	 // 1 string to match.
            if (Mnemonic[2] != 'q')
              break;
            Mnemonic = "cltd";	 // "cdq"
            return;
          case 'q':	 // 1 string to match.
            if (Mnemonic[2] != 'o')
              break;
            Mnemonic = "cqto";	 // "cqo"
            return;
          case 'w':	 // 1 string to match.
            if (Mnemonic[2] != 'd')
              break;
            Mnemonic = "cwtd";	 // "cwd"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "op", 2))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pop"
            Mnemonic = "popw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "popl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "popq";
          return;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "et", 2))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "ret"
            Mnemonic = "retw";
          else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
            Mnemonic = "retl";
          else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
            Mnemonic = "retq";
          return;
        }
        break;
      case 4:	 // 19 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "ll", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "call"
              Mnemonic = "callw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "calll";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "callq";
            return;
          case 'd':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "qe", 2))
              break;
            Mnemonic = "cltq";	 // "cdqe"
            return;
          case 'w':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "de", 2))
              break;
            Mnemonic = "cwtl";	 // "cwde"
            return;
          }
          break;
        case 'i':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ret", 3))
            break;
          if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "iret"
            Mnemonic = "iretw";
          else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
            Mnemonic = "iretl";
          return;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lgdt"
              Mnemonic = "lgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lidt"
              Mnemonic = "lidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "lidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "lidtq";
            return;
          case 'r':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "et", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "lret"
              Mnemonic = "lretw";
            else if ((Features & Feature_Not16BitMode) == Feature_Not16BitMode)
              Mnemonic = "lretl";
            return;
          }
          break;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 2 strings to match.
            if (Mnemonic[2] != 'p')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
                Mnemonic = "popaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popf"
                Mnemonic = "popfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "popfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "popfq";
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "push"
              Mnemonic = "pushw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "pushl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "pushq";
            return;
          }
          break;
        case 'r':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "ep", 2))
            break;
          switch (Mnemonic[3]) {
          default: break;
          case 'e':	 // 1 string to match.
            Mnemonic = "rep";	 // "repe"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "rep";	 // "repz"
            return;
          }
          break;
        case 's':	 // 6 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'a':	 // 4 strings to match.
            if (Mnemonic[2] != 'l')
              break;
            switch (Mnemonic[3]) {
            default: break;
            case 'b':	 // 1 string to match.
              Mnemonic = "shlb";	 // "salb"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "shll";	 // "sall"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "shlq";	 // "salq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "shlw";	 // "salw"
              return;
            }
            break;
          case 'g':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sgdt"
              Mnemonic = "sgdtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sgdtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sgdtq";
            return;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dt", 2))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "sidt"
              Mnemonic = "sidtw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "sidtl";
            else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
              Mnemonic = "sidtq";
            return;
          }
          break;
        case 'u':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "d2a", 3))
            break;
          Mnemonic = "ud2";	 // "ud2a"
          return;
        }
        break;
      case 5:	 // 11 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'f':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ildq", 4))
            break;
          Mnemonic = "fildll";	 // "fildq"
          return;
        case 'l':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "oopz", 4))
            break;
          Mnemonic = "loope";	 // "loopz"
          return;
        case 'p':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pfd", 3))
              break;
            Mnemonic = "popfl";	 // "popfd"
            return;
          case 'u':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "sh", 2))
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'a':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
                Mnemonic = "pushaw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushal";
              return;
            case 'f':	 // 1 string to match.
              if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pushf"
                Mnemonic = "pushfw";
              else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
                Mnemonic = "pushfl";
              else if ((Features & Feature_In64BitMode) == Feature_In64BitMode)
                Mnemonic = "pushfq";
              return;
            }
            break;
          }
          break;
        case 'r':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "epnz", 4))
            break;
          Mnemonic = "repne";	 // "repnz"
          return;
        case 's':	 // 4 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'b':	 // 1 string to match.
            Mnemonic = "movsb";	 // "smovb"
            return;
          case 'l':	 // 1 string to match.
            Mnemonic = "movsl";	 // "smovl"
            return;
          case 'q':	 // 1 string to match.
            Mnemonic = "movsq";	 // "smovq"
            return;
          case 'w':	 // 1 string to match.
            Mnemonic = "movsw";	 // "smovw"
            return;
          }
          break;
        case 'v':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "errw", 4))
            break;
          Mnemonic = "verr";	 // "verrw"
          return;
        }
        break;
      case 6:	 // 17 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 6 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovcl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovcq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovcw"
              return;
            }
            break;
          case 'z':	 // 3 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovel";	 // "cmovzl"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmoveq";	 // "cmovzq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovew";	 // "cmovzw"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 5 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 3 strings to match.
            switch (Mnemonic[2]) {
            default: break;
            case 'm':	 // 2 strings to match.
              if (memcmp(Mnemonic.data()+3, "ov", 2))
                break;
              switch (Mnemonic[5]) {
              default: break;
              case 'a':	 // 1 string to match.
                Mnemonic = "fcmovnbe";	 // "fcmova"
                return;
              case 'z':	 // 1 string to match.
                Mnemonic = "fcmove";	 // "fcmovz"
                return;
              }
              break;
            case 'o':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+3, "mip", 3))
                break;
              Mnemonic = "fcompi";	 // "fcomip"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "stpq", 4))
              break;
            Mnemonic = "fistpll";	 // "fistpq"
            return;
          case 'l':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "dcww", 4))
              break;
            Mnemonic = "fldcw";	 // "fldcww"
            return;
          }
          break;
        case 'l':	 // 3 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'e':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "ave", 3))
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'l':	 // 1 string to match.
              if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "leavel"
                Mnemonic = "leave";
              return;
            case 'q':	 // 1 string to match.
              if ((Features & Feature_In64BitMode) == Feature_In64BitMode)	 // "leaveq"
                Mnemonic = "leave";
              return;
            }
            break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "opnz", 4))
              break;
            Mnemonic = "loopne";	 // "loopnz"
            return;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushfd", 5))
            break;
          Mnemonic = "pushfl";	 // "pushfd"
          return;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysret", 5))
            break;
          Mnemonic = "sysretl";	 // "sysret"
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "saveq", 5))
            break;
          Mnemonic = "xsave64";	 // "xsaveq"
          return;
        }
        break;
      case 7:	 // 33 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 24 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 18 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovbel";	 // "cmovnal"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovbeq";	 // "cmovnaq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovbew";	 // "cmovnaw"
                return;
              }
              break;
            case 'b':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovnbl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovnbq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovnbw"
                return;
              }
              break;
            case 'c':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovael";	 // "cmovncl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovaeq";	 // "cmovncq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovaew";	 // "cmovncw"
                return;
              }
              break;
            case 'g':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovlel";	 // "cmovngl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovleq";	 // "cmovngq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovlew";	 // "cmovngw"
                return;
              }
              break;
            case 'l':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovgel";	 // "cmovnll"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovgeq";	 // "cmovnlq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovgew";	 // "cmovnlw"
                return;
              }
              break;
            case 'z':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnel";	 // "cmovnzl"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovneq";	 // "cmovnzq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnew";	 // "cmovnzw"
                return;
              }
              break;
            }
            break;
          case 'p':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovpl";	 // "cmovpel"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovpq";	 // "cmovpeq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovpw";	 // "cmovpew"
                return;
              }
              break;
            case 'o':	 // 3 strings to match.
              switch (Mnemonic[6]) {
              default: break;
              case 'l':	 // 1 string to match.
                Mnemonic = "cmovnpl";	 // "cmovpol"
                return;
              case 'q':	 // 1 string to match.
                Mnemonic = "cmovnpq";	 // "cmovpoq"
                return;
              case 'w':	 // 1 string to match.
                Mnemonic = "cmovnpw";	 // "cmovpow"
                return;
              }
              break;
            }
            break;
          }
          break;
        case 'f':	 // 7 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "mov", 3))
              break;
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              if (Mnemonic[6] != 'e')
                break;
              Mnemonic = "fcmovnb";	 // "fcmovae"
              return;
            case 'n':	 // 1 string to match.
              if (Mnemonic[6] != 'a')
                break;
              Mnemonic = "fcmovbe";	 // "fcmovna"
              return;
            }
            break;
          case 'i':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sttpq", 5))
              break;
            Mnemonic = "fisttpll";	 // "fisttpq"
            return;
          case 'n':	 // 2 strings to match.
            if (memcmp(Mnemonic.data()+2, "st", 2))
              break;
            switch (Mnemonic[4]) {
            default: break;
            case 'c':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2))
                break;
              Mnemonic = "fnstcw";	 // "fnstcww"
              return;
            case 's':	 // 1 string to match.
              if (memcmp(Mnemonic.data()+5, "ww", 2))
                break;
              Mnemonic = "fnstsw";	 // "fnstsww"
              return;
            }
            break;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "comip", 5))
              break;
            Mnemonic = "fucompi";	 // "fucomip"
            return;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "saveq", 5))
              break;
            Mnemonic = "fxsave64";	 // "fxsaveq"
            return;
          }
          break;
        case 's':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ysexit", 6))
            break;
          Mnemonic = "sysexitl";	 // "sysexit"
          return;
        case 'x':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "rstorq", 6))
            break;
          Mnemonic = "xrstor64";	 // "xrstorq"
          return;
        }
        break;
      case 8:	 // 14 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 12 strings to match.
          if (memcmp(Mnemonic.data()+1, "movn", 4))
            break;
          switch (Mnemonic[5]) {
          default: break;
          case 'a':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovbl";	 // "cmovnael"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovbq";	 // "cmovnaeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovbw";	 // "cmovnaew"
              return;
            }
            break;
          case 'b':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmoval";	 // "cmovnbel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovaq";	 // "cmovnbeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovaw";	 // "cmovnbew"
              return;
            }
            break;
          case 'g':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovll";	 // "cmovngel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovlq";	 // "cmovngeq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovlw";	 // "cmovngew"
              return;
            }
            break;
          case 'l':	 // 3 strings to match.
            if (Mnemonic[6] != 'e')
              break;
            switch (Mnemonic[7]) {
            default: break;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovgl";	 // "cmovnlel"
              return;
            case 'q':	 // 1 string to match.
              Mnemonic = "cmovgq";	 // "cmovnleq"
              return;
            case 'w':	 // 1 string to match.
              Mnemonic = "cmovgw";	 // "cmovnlew"
              return;
            }
            break;
          }
          break;
        case 'f':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'c':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "movnae", 6))
              break;
            Mnemonic = "fcmovb";	 // "fcmovnae"
            return;
          case 'x':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "rstorq", 6))
              break;
            Mnemonic = "fxrstor64";	 // "fxrstorq"
            return;
          }
          break;
        }
        break;
      case 9:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "xsaveoptq", 9))
          break;
        Mnemonic = "xsaveopt64";	 // "xsaveoptq"
        return;
      }
    break;
    case 1:
      switch (Mnemonic.size()) {
      default: break;
      case 4:	 // 1 string to match.
        if (memcmp(Mnemonic.data()+0, "popa", 4))
          break;
        if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "popa"
          Mnemonic = "popaw";
        else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
          Mnemonic = "popal";
        return;
      case 5:	 // 4 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 2 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'c':	 // 1 string to match.
            Mnemonic = "cmovb";	 // "cmovc"
            return;
          case 'z':	 // 1 string to match.
            Mnemonic = "cmove";	 // "cmovz"
            return;
          }
          break;
        case 'p':	 // 2 strings to match.
          switch (Mnemonic[1]) {
          default: break;
          case 'o':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "pad", 3))
              break;
            if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "popad"
              Mnemonic = "popal";
            return;
          case 'u':	 // 1 string to match.
            if (memcmp(Mnemonic.data()+2, "sha", 3))
              break;
            if ((Features & Feature_In16BitMode) == Feature_In16BitMode)	 // "pusha"
              Mnemonic = "pushaw";
            else if ((Features & Feature_In32BitMode) == Feature_In32BitMode)
              Mnemonic = "pushal";
            return;
          }
          break;
        }
        break;
      case 6:	 // 9 strings to match.
        switch (Mnemonic[0]) {
        default: break;
        case 'c':	 // 8 strings to match.
          if (memcmp(Mnemonic.data()+1, "mov", 3))
            break;
          switch (Mnemonic[4]) {
          default: break;
          case 'n':	 // 6 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'a':	 // 1 string to match.
              Mnemonic = "cmovbe";	 // "cmovna"
              return;
            case 'b':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnb"
              return;
            case 'c':	 // 1 string to match.
              Mnemonic = "cmovae";	 // "cmovnc"
              return;
            case 'g':	 // 1 string to match.
              Mnemonic = "cmovle";	 // "cmovng"
              return;
            case 'l':	 // 1 string to match.
              Mnemonic = "cmovge";	 // "cmovnl"
              return;
            case 'z':	 // 1 string to match.
              Mnemonic = "cmovne";	 // "cmovnz"
              return;
            }
            break;
          case 'p':	 // 2 strings to match.
            switch (Mnemonic[5]) {
            default: break;
            case 'e':	 // 1 string to match.
              Mnemonic = "cmovp";	 // "cmovpe"
              return;
            case 'o':	 // 1 string to match.
              Mnemonic = "cmovnp";	 // "cmovpo"
              return;
            }
            break;
          }
          break;
        case 'p':	 // 1 string to match.
          if (memcmp(Mnemonic.data()+1, "ushad", 5))
            break;
          if ((Features & Feature_Not64BitMode) == Feature_Not64BitMode)	 // "pushad"
            Mnemonic = "pushal";
          return;
        }
        break;
      case 7:	 // 4 strings to match.
        if (memcmp(Mnemonic.data()+0, "cmovn", 5))
          break;
        switch (Mnemonic[5]) {
        default: break;
        case 'a':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovb";	 // "cmovnae"
          return;
        case 'b':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmova";	 // "cmovnbe"
          return;
        case 'g':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovl";	 // "cmovnge"
          return;
        case 'l':	 // 1 string to match.
          if (Mnemonic[6] != 'e')
            break;
          Mnemonic = "cmovg";	 // "cmovnle"
          return;
        }
        break;
      }
    break;
  }
  switch (Mnemonic.size()) {
  default: break;
  case 2:	 // 2 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'c':	 // 1 string to match.
      Mnemonic = "jb";	 // "jc"
      return;
    case 'z':	 // 1 string to match.
      Mnemonic = "je";	 // "jz"
      return;
    }
    break;
  case 3:	 // 8 strings to match.
    if (Mnemonic[0] != 'j')
      break;
    switch (Mnemonic[1]) {
    default: break;
    case 'n':	 // 6 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        Mnemonic = "jbe";	 // "jna"
        return;
      case 'b':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnb"
        return;
      case 'c':	 // 1 string to match.
        Mnemonic = "jae";	 // "jnc"
        return;
      case 'g':	 // 1 string to match.
        Mnemonic = "jle";	 // "jng"
        return;
      case 'l':	 // 1 string to match.
        Mnemonic = "jge";	 // "jnl"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "jne";	 // "jnz"
        return;
      }
      break;
    case 'p':	 // 2 strings to match.
      switch (Mnemonic[2]) {
      default: break;
      case 'e':	 // 1 string to match.
        Mnemonic = "jp";	 // "jpe"
        return;
      case 'o':	 // 1 string to match.
        Mnemonic = "jnp";	 // "jpo"
        return;
      }
      break;
    }
    break;
  case 4:	 // 6 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'j':	 // 4 strings to match.
      if (Mnemonic[1] != 'n')
        break;
      switch (Mnemonic[2]) {
      default: break;
      case 'a':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jb";	 // "jnae"
        return;
      case 'b':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "ja";	 // "jnbe"
        return;
      case 'g':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jl";	 // "jnge"
        return;
      case 'l':	 // 1 string to match.
        if (Mnemonic[3] != 'e')
          break;
        Mnemonic = "jg";	 // "jnle"
        return;
      }
      break;
    case 's':	 // 2 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2))
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'c':	 // 1 string to match.
        Mnemonic = "setb";	 // "setc"
        return;
      case 'z':	 // 1 string to match.
        Mnemonic = "sete";	 // "setz"
        return;
      }
      break;
    }
    break;
  case 5:	 // 9 strings to match.
    switch (Mnemonic[0]) {
    default: break;
    case 'f':	 // 1 string to match.
      if (memcmp(Mnemonic.data()+1, "wait", 4))
        break;
      Mnemonic = "wait";	 // "fwait"
      return;
    case 's':	 // 8 strings to match.
      if (memcmp(Mnemonic.data()+1, "et", 2))
        break;
      switch (Mnemonic[3]) {
      default: break;
      case 'n':	 // 6 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'a':	 // 1 string to match.
          Mnemonic = "setbe";	 // "setna"
          return;
        case 'b':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnb"
          return;
        case 'c':	 // 1 string to match.
          Mnemonic = "setae";	 // "setnc"
          return;
        case 'g':	 // 1 string to match.
          Mnemonic = "setle";	 // "setng"
          return;
        case 'l':	 // 1 string to match.
          Mnemonic = "setge";	 // "setnl"
          return;
        case 'z':	 // 1 string to match.
          Mnemonic = "setne";	 // "setnz"
          return;
        }
        break;
      case 'p':	 // 2 strings to match.
        switch (Mnemonic[4]) {
        default: break;
        case 'e':	 // 1 string to match.
          Mnemonic = "setp";	 // "setpe"
          return;
        case 'o':	 // 1 string to match.
          Mnemonic = "setnp";	 // "setpo"
          return;
        }
        break;
      }
      break;
    }
    break;
  case 6:	 // 4 strings to match.
    if (memcmp(Mnemonic.data()+0, "setn", 4))
      break;
    switch (Mnemonic[4]) {
    default: break;
    case 'a':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setb";	 // "setnae"
      return;
    case 'b':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "seta";	 // "setnbe"
      return;
    case 'g':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setl";	 // "setnge"
      return;
    case 'l':	 // 1 string to match.
      if (Mnemonic[5] != 'e')
        break;
      Mnemonic = "setg";	 // "setnle"
      return;
    }
    break;
  }
}

namespace {
enum OperatorConversionKind {
  CVT_Done,
  CVT_Reg,
  CVT_Tied,
  CVT_imm_95_10,
  CVT_95_addImmOperands,
  CVT_95_Reg,
  CVT_95_addMemOperands,
  CVT_95_addAbsMemOperands,
  CVT_95_addDstIdxOperands,
  CVT_95_addSrcIdxOperands,
  CVT_95_addGR32orGR64Operands,
  CVT_regST0,
  CVT_regST1,
  CVT_95_addMemOffsOperands,
  CVT_imm_95_17,
  CVT_imm_95_1,
  CVT_imm_95_16,
  CVT_imm_95_0,
  CVT_95_addAVX512RCOperands,
  CVT_NUM_CONVERTERS
};

enum InstructionConversionKind {
  Convert_NoOperands,
  Convert__imm_95_10,
  Convert__Imm1_0,
  Convert__Imm1_1,
  Convert__Reg1_0__Tie0__Reg1_1,
  Convert__Reg1_0__Tie0__Imm1_1,
  Convert__Reg1_0__Tie0__Mem85_1,
  Convert__Reg1_0__Tie0__ImmSExti16i81_1,
  Convert__Reg1_0__Tie0__Mem165_1,
  Convert__Reg1_0__Tie0__ImmSExti32i81_1,
  Convert__Reg1_0__Tie0__Mem325_1,
  Convert__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0__ImmSExti64i81_1,
  Convert__Reg1_0__Tie0__ImmSExti64i321_1,
  Convert__Reg1_0__Tie0__Mem645_1,
  Convert__Mem165_0__Reg1_1,
  Convert__Mem165_0__ImmSExti16i81_1,
  Convert__Mem165_0__Imm1_1,
  Convert__Mem325_0__Reg1_1,
  Convert__Mem325_0__ImmSExti32i81_1,
  Convert__Mem325_0__Imm1_1,
  Convert__Mem645_0__Reg1_1,
  Convert__Mem645_0__ImmSExti64i81_1,
  Convert__Mem645_0__ImmSExti64i321_1,
  Convert__Mem85_0__Reg1_1,
  Convert__Mem85_0__Imm1_1,
  Convert__Reg1_1__Tie0__Reg1_0,
  Convert__Mem85_1__Reg1_0,
  Convert__Reg1_1__Tie0__Imm1_0,
  Convert__Mem85_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem85_0,
  Convert__Mem325_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti32i81_0,
  Convert__Mem325_1__ImmSExti32i81_0,
  Convert__Mem325_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem325_0,
  Convert__Mem645_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti64i81_0,
  Convert__Mem645_1__ImmSExti64i81_0,
  Convert__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0__ImmSExti64i321_0,
  Convert__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_1__Tie0__Mem645_0,
  Convert__Mem165_1__Reg1_0,
  Convert__Reg1_1__Tie0__ImmSExti16i81_0,
  Convert__Mem165_1__ImmSExti16i81_0,
  Convert__Mem165_1__Imm1_0,
  Convert__Reg1_1__Tie0__Mem165_0,
  Convert__Reg1_0__Tie0__Mem1285_1,
  Convert__Reg1_1__Tie0__Mem1285_0,
  Convert__Reg1_0__Reg1_1,
  Convert__Reg1_0__Mem325_1,
  Convert__Reg1_0__Mem645_1,
  Convert__Reg1_1__Reg1_0,
  Convert__Reg1_1__Mem325_0,
  Convert__Reg1_1__Mem645_0,
  Convert__Reg1_0__Mem1285_1,
  Convert__Reg1_1__Mem1285_0,
  Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Reg1_1__Mem325_2,
  Convert__Reg1_0__Reg1_1__Mem645_2,
  Convert__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Imm1_2,
  Convert__Reg1_0__Mem325_1__Reg1_2,
  Convert__Reg1_0__Mem325_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i321_2,
  Convert__Reg1_0__Mem645_1__Reg1_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i321_2,
  Convert__Reg1_2__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_2__Mem325_1__Imm1_0,
  Convert__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0__Mem1285_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0__Reg1_1,
  Convert__Reg1_2__Tie0__Mem1285_1,
  Convert__Mem1285_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1,
  Convert__Reg1_0__Mem165_1,
  Convert__Reg1_1__Mem165_0,
  Convert__Reg1_0__Tie0,
  Convert__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_0,
  Convert__AbsMem1_0,
  Convert__Mem165_0,
  Convert__Mem325_0,
  Convert__Mem645_0,
  Convert__Mem165_1,
  Convert__Mem325_1,
  Convert__Mem645_1,
  Convert__Imm1_1__Imm1_0,
  Convert__Reg1_1,
  Convert__Mem85_0,
  Convert__Reg1_0__Tie0__Reg1_0,
  Convert__Reg1_0__Imm1_1,
  Convert__Reg1_0__Mem85_1,
  Convert__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_3__Tie0__Reg1_2__Imm1_0,
  Convert__Reg1_2__Tie0__Reg1_3__Imm1_0,
  Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0,
  Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0,
  Convert__Reg1_2__Tie0__Mem645_3__Imm1_0,
  Convert__Reg1_3__Tie0__Mem645_2__Imm1_0,
  Convert__Reg1_2__Tie0__Mem325_3__Imm1_0,
  Convert__Reg1_3__Tie0__Mem325_2__Imm1_0,
  Convert__Reg1_1__Imm1_0,
  Convert__Reg1_1__Mem85_0,
  Convert__Reg1_1__ImmSExti64i321_0,
  Convert__DstIdx81_0__SrcIdx82_1,
  Convert__DstIdx81_1__SrcIdx82_0,
  Convert__DstIdx321_1__SrcIdx322_0,
  Convert__Reg1_0__Tie0__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0,
  Convert__DstIdx321_0__SrcIdx322_1,
  Convert__DstIdx641_0__SrcIdx642_1,
  Convert__DstIdx641_1__SrcIdx642_0,
  Convert__Reg1_0__Tie0__Mem325_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0,
  Convert__DstIdx161_0__SrcIdx162_1,
  Convert__DstIdx161_1__SrcIdx162_0,
  Convert__Mem1285_0,
  Convert__Mem85_1,
  Convert__Imm1_0__Imm1_1,
  Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0,
  Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0__ImmUnsignedi81_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__regST0,
  Convert__regST1,
  Convert__Mem805_0,
  Convert__Mem5_0,
  Convert__Reg1_0__Reg1_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__ImmSExti16i81_2,
  Convert__Reg1_0__Mem165_1__Imm1_2,
  Convert__Reg1_0__Reg1_1__ImmSExti32i81_2,
  Convert__Reg1_0__Mem325_1__ImmSExti32i81_2,
  Convert__Reg1_0__Reg1_1__ImmSExti64i81_2,
  Convert__Reg1_0__Mem645_1__ImmSExti64i81_2,
  Convert__Reg1_0__Reg1_0__ImmSExti32i81_1,
  Convert__Reg1_0__Reg1_0__Imm1_1,
  Convert__Reg1_1__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_1__Reg1_1__Imm1_0,
  Convert__Reg1_2__Reg1_1__ImmSExti32i81_0,
  Convert__Reg1_2__Mem325_1__ImmSExti32i81_0,
  Convert__Reg1_0__Reg1_0__ImmSExti64i81_1,
  Convert__Reg1_0__Reg1_0__ImmSExti64i321_1,
  Convert__Reg1_1__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_1__Reg1_1__ImmSExti64i321_0,
  Convert__Reg1_2__Reg1_1__ImmSExti64i81_0,
  Convert__Reg1_2__Mem645_1__ImmSExti64i81_0,
  Convert__Reg1_0__Reg1_0__ImmSExti16i81_1,
  Convert__Reg1_1__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Reg1_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__ImmSExti16i81_0,
  Convert__Reg1_2__Mem165_1__Imm1_0,
  Convert__DstIdx81_1,
  Convert__DstIdx81_0,
  Convert__DstIdx321_0,
  Convert__Reg1_0__Tie0__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Tie0__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0,
  Convert__DstIdx321_1,
  Convert__DstIdx161_1,
  Convert__DstIdx161_0,
  Convert__Mem5_1,
  Convert__Reg1_0__Mem5_1,
  Convert__Reg1_1__Mem5_0,
  Convert__SrcIdx82_1,
  Convert__SrcIdx162_1,
  Convert__SrcIdx322_1,
  Convert__SrcIdx642_1,
  Convert__SrcIdx162_0,
  Convert__SrcIdx322_0,
  Convert__SrcIdx642_0,
  Convert__SrcIdx82_0,
  Convert__MemOffs16_82_1,
  Convert__MemOffs32_82_1,
  Convert__MemOffs16_162_1,
  Convert__MemOffs32_162_1,
  Convert__MemOffs16_322_1,
  Convert__MemOffs32_322_1,
  Convert__MemOffs32_642_1,
  Convert__MemOffs16_82_0,
  Convert__MemOffs32_82_0,
  Convert__MemOffs16_162_0,
  Convert__MemOffs16_322_0,
  Convert__MemOffs32_162_0,
  Convert__MemOffs32_322_0,
  Convert__MemOffs32_642_0,
  Convert__MemOffs64_82_1,
  Convert__MemOffs64_162_1,
  Convert__MemOffs64_322_1,
  Convert__MemOffs64_642_1,
  Convert__MemOffs64_162_0,
  Convert__MemOffs64_322_0,
  Convert__MemOffs64_642_0,
  Convert__MemOffs64_82_0,
  Convert__GR32orGR641_1__Reg1_0,
  Convert__GR32orGR641_0__Reg1_1,
  Convert__Reg1_1__Tie0__Reg1_0__imm_95_17,
  Convert__Reg1_0__Tie0__Reg1_1__imm_95_17,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_95_17,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_95_17,
  Convert__Reg1_1__Tie0__Reg1_0__imm_95_1,
  Convert__Reg1_0__Tie0__Reg1_1__imm_95_1,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_95_1,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_95_1,
  Convert__Reg1_1__Tie0__Reg1_0__imm_95_16,
  Convert__Reg1_0__Tie0__Reg1_1__imm_95_16,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_95_16,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_95_16,
  Convert__Reg1_1__Tie0__Reg1_0__imm_95_0,
  Convert__Reg1_0__Tie0__Reg1_1__imm_95_0,
  Convert__Reg1_0__Tie0__Mem1285_1__imm_95_0,
  Convert__Reg1_1__Tie0__Mem1285_0__imm_95_0,
  Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0__GR32orGR641_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Tie0__Mem85_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Mem165_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Tie0__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__ImmUnsignedi81_1,
  Convert__Reg1_1__Tie0__ImmUnsignedi81_0,
  Convert__ImmSExti64i81_0,
  Convert__ImmSExti16i81_0,
  Convert__ImmSExti32i81_0,
  Convert__Mem645_0__Imm1_1,
  Convert__Reg1_1__Tie0,
  Convert__Mem645_1__Imm1_0,
  Convert__Reg1_0__Mem645_1__Imm1_2,
  Convert__Reg1_2__Mem645_1__Imm1_0,
  Convert__DstIdx641_1,
  Convert__DstIdx641_0,
  Convert__Reg1_0__Tie0__Reg1_1__Imm1_2,
  Convert__Mem165_0__Reg1_1__Imm1_2,
  Convert__Mem325_0__Reg1_1__Imm1_2,
  Convert__Mem645_0__Reg1_1__Imm1_2,
  Convert__Mem325_2__Reg1_1,
  Convert__Reg1_2__Tie0__Reg1_1__Imm1_0,
  Convert__Mem325_2__Reg1_1__Imm1_0,
  Convert__Mem645_2__Reg1_1,
  Convert__Mem645_2__Reg1_1__Imm1_0,
  Convert__Mem165_2__Reg1_1,
  Convert__Mem165_2__Reg1_1__Imm1_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0,
  Convert__Reg1_3__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5,
  Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0,
  Convert__Reg1_0__Reg1_2__Mem1285_4,
  Convert__Reg1_1__Reg1_3__Mem1285_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5,
  Convert__Reg1_0__Mem2565_1,
  Convert__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_4,
  Convert__Reg1_1__Reg1_3__Mem2565_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5,
  Convert__Reg1_1__Tie0__Reg1_3__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Tie0__Reg1_2__Mem645_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem645_0,
  Convert__Reg1_1__Reg1_3__Reg1_0,
  Convert__Reg1_0__Reg1_2__Reg1_5,
  Convert__Reg1_0__Reg1_2__Mem645_5,
  Convert__Reg1_1__Reg1_3__Mem645_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem325_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem325_0,
  Convert__Reg1_0__Reg1_2__Mem325_5,
  Convert__Reg1_1__Reg1_3__Mem325_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0,
  Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0,
  Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0,
  Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0,
  Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Reg1_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem1285_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem2565_7__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem5125_7__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0,
  Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem645_7__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0,
  Convert__Reg1_2__Reg1_4__Reg1_6__Mem325_7__Imm1_0,
  Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Mem2565_1__Reg1_0,
  Convert__Mem5125_1__Reg1_0,
  Convert__Mem2565_0__Reg1_1,
  Convert__Mem5125_0__Reg1_1,
  Convert__Mem1285_1__Reg1_3__Reg1_0,
  Convert__Mem2565_1__Reg1_3__Reg1_0,
  Convert__Mem5125_1__Reg1_3__Reg1_0,
  Convert__Mem1285_0__Reg1_2__Reg1_4,
  Convert__Mem2565_0__Reg1_2__Reg1_4,
  Convert__Mem5125_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Mem1285_0,
  Convert__Reg1_2__Mem2565_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem1285_4,
  Convert__Reg1_0__Tie0__Reg1_2__Mem2565_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0,
  Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0,
  Convert__Reg1_2__Reg1_4__Mem1285_0,
  Convert__Reg1_2__Reg1_4__Mem2565_0,
  Convert__Reg1_0__Mem5125_1,
  Convert__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Reg1_1__AVX512RC1_2,
  Convert__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Mem5125_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Mem5125_5,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__AVX512RC1_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0,
  Convert__Reg1_1__Reg1_3__Mem5125_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0,
  Convert__Reg1_2__Reg1_4__Mem5125_0,
  Convert__Reg1_2__Reg1_1,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1,
  Convert__Reg1_2__Reg1_4__Reg1_1,
  Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0,
  Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2,
  Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6,
  Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7,
  Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0__Reg1_1__Reg1_0,
  Convert__Reg1_0__Tie0__Reg1_1__Reg1_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem1285_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem2565_2,
  Convert__Reg1_0__Tie0__Reg1_1__Mem5125_2,
  Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0,
  Convert__Reg1_0__Tie0__Reg1_1__Mem645_2,
  Convert__Reg1_0__Tie0__Reg1_1__Reg1_2__AVX512RC1_3,
  Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0,
  Convert__Reg1_3__Tie0__Reg1_2__Mem645_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem1285_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem2565_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem5125_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem645_6,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7,
  Convert__Reg1_0__Tie0__Reg1_1__Mem325_2,
  Convert__Reg1_3__Tie0__Reg1_2__Mem325_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem325_6,
  Convert__Reg1_2__Tie0__Reg1_1__Mem645_0,
  Convert__Reg1_2__Tie0__Reg1_1__Mem325_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3,
  Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3,
  Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3,
  Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0,
  Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVX645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVX32X5_4,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY32X5_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVX32X5_0,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY32X5_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVX325_1__Tie1,
  Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVY325_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ325_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0,
  Convert__Reg1_1__MemVY325_3,
  Convert__Reg1_2__MemVY325_0,
  Convert__Reg1_1__MemVZ325_3,
  Convert__Reg1_2__MemVZ325_0,
  Convert__Reg1_1__MemVZ645_3,
  Convert__Reg1_2__MemVZ645_0,
  Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__MemVY645_1__Tie1,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVX64X5_4,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY64X5_4,
  Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ645_4,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVX64X5_0,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY64X5_0,
  Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0,
  Convert__Mem1285_2__Reg1_1__Reg1_0,
  Convert__Mem2565_2__Reg1_1__Reg1_0,
  Convert__Mem1285_0__Reg1_1__Reg1_2,
  Convert__Mem2565_0__Reg1_1__Reg1_2,
  Convert__Reg1_3__Reg1_2__Reg1_1,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1,
  Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1,
  Convert__Mem645_1__Reg1_3__Reg1_0,
  Convert__Mem645_0__Reg1_2__Reg1_4,
  Convert__Mem325_1__Reg1_3__Reg1_0,
  Convert__Mem325_0__Reg1_2__Reg1_4,
  Convert__Reg1_2__Mem325_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem325_0,
  Convert__Reg1_2__Reg1_4__Mem325_0,
  Convert__Reg1_2__Mem645_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem645_0,
  Convert__Reg1_2__Reg1_4__Mem645_0,
  Convert__Reg1_0__Reg1_2__Reg1_4,
  Convert__Reg1_0__Reg1_2__Mem325_4,
  Convert__Reg1_0__Reg1_2__Mem645_4,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16,
  Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0,
  Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0,
  Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0,
  Convert__Reg1_0__Reg1_1__Reg1_2__Imm1_3,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Imm1_3,
  Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_0__Tie0__Reg1_1__Mem165_2,
  Convert__Reg1_3__Tie0__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem165_5,
  Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem165_0,
  Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem165_6,
  Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__Imm1_4,
  Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__Imm1_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0,
  Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2,
  Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2,
  Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem2565_4__ImmUnsignedi81_5,
  Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Tie0__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0__Reg1_2__Mem645_4__ImmUnsignedi81_6,
  Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6,
  Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3,
  Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3,
  Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem165_4,
  Convert__Reg1_1__Tie0__Reg1_3__Mem165_0,
  Convert__Reg1_0__Reg1_2__Mem165_5,
  Convert__Reg1_1__Reg1_3__Mem165_0,
  Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3,
  Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Tie0__Reg1_2__Mem1285_4__ImmUnsignedi81_5,
  Convert__Reg1_2__Tie0__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6,
  Convert__Reg1_0__Tie0__Reg1_2__Mem325_4__ImmUnsignedi81_6,
  Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0,
  Convert__Reg1_3__Tie0__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7,
  Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0,
  Convert__Reg1_2__Mem1285_1__Reg1_0,
  Convert__Reg1_0__Mem1285_1__Reg1_2,
  Convert__Reg1_0__Mem1285_1__Imm1_2,
  Convert__Reg1_2__Mem1285_1__Imm1_0,
  Convert__Reg1_3__MemVX32X5_1__Tie0__Reg1_0,
  Convert__Reg1_3__MemVY32X5_1__Tie0__Reg1_0,
  Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0,
  Convert__Reg1_2__MemVX32X5_0__Tie0__Reg1_4,
  Convert__Reg1_2__MemVY32X5_0__Tie0__Reg1_4,
  Convert__Reg1_2__MemVZ325_0__Tie0__Reg1_4,
  Convert__Reg1_3__MemVX64X5_1__Tie0__Reg1_0,
  Convert__Reg1_3__MemVY64X5_1__Tie0__Reg1_0,
  Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0,
  Convert__Reg1_2__MemVX64X5_0__Tie0__Reg1_4,
  Convert__Reg1_2__MemVY64X5_0__Tie0__Reg1_4,
  Convert__Reg1_2__MemVZ645_0__Tie0__Reg1_4,
  Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_1,
  Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_1,
  Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_1,
  Convert__AbsMem161_0,
  CVT_NUM_SIGNATURES
};

} // end anonymous namespace

static const uint8_t ConversionTable[CVT_NUM_SIGNATURES][13] = {
  // Convert_NoOperands
  { CVT_Done },
  // Convert__imm_95_10
  { CVT_imm_95_10, 0, CVT_Done },
  // Convert__Imm1_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Imm1_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Imm1_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem85_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem165_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__ImmSExti64i321_1
  { CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem645_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem165_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_0__ImmSExti16i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem165_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem325_0__ImmSExti32i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem325_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i81_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem645_0__ImmSExti64i321_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Mem85_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem85_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Imm1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem85_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__ImmSExti32i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i321_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_1__ImmSExti64i321_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__ImmSExti16i81_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem325_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem645_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_1__Mem325_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem645_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i321_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i321_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_1
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem1285_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_0__Mem165_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem165_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_Done },
  // Convert__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0
  { CVT_95_Reg, 1, CVT_Done },
  // Convert__AbsMem1_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
  // Convert__Mem165_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem325_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem645_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem165_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem325_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Mem645_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Imm1_1__Imm1_0
  { CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1
  { CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem85_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem85_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem1285_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem645_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem645_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_3__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Mem325_2__Imm1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Mem85_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx81_0__SrcIdx82_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx81_1__SrcIdx82_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_1__SrcIdx322_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_0__SrcIdx322_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0__SrcIdx642_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_1__SrcIdx642_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem325_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx161_0__SrcIdx162_1
  { CVT_95_addDstIdxOperands, 1, CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1__SrcIdx162_0
  { CVT_95_addDstIdxOperands, 2, CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__Mem1285_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem85_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Imm1_0__Imm1_1
  { CVT_95_addImmOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addGR32orGR64Operands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmUnsignedi81_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__regST0
  { CVT_regST0, 0, CVT_Done },
  // Convert__regST1
  { CVT_regST1, 0, CVT_Done },
  // Convert__Mem805_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem5_0
  { CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__ImmSExti16i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem165_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmSExti32i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmSExti64i81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti32i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__Imm1_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__Imm1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem325_1__ImmSExti32i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti64i321_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti64i321_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmSExti64i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_0__ImmSExti16i81_1
  { CVT_95_Reg, 1, CVT_95_Reg, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 2, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__ImmSExti16i81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem165_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx81_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx81_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__DstIdx321_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__ImmUnsignedi81_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx321_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx161_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Mem5_1
  { CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_0__Mem5_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__SrcIdx82_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx322_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx642_1
  { CVT_95_addSrcIdxOperands, 2, CVT_Done },
  // Convert__SrcIdx162_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx322_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx642_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__SrcIdx82_0
  { CVT_95_addSrcIdxOperands, 1, CVT_Done },
  // Convert__MemOffs16_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs32_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs16_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs16_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs32_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_322_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_642_1
  { CVT_95_addMemOffsOperands, 2, CVT_Done },
  // Convert__MemOffs64_162_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_322_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_642_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__MemOffs64_82_0
  { CVT_95_addMemOffsOperands, 1, CVT_Done },
  // Convert__GR32orGR641_1__Reg1_0
  { CVT_95_addGR32orGR64Operands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__GR32orGR641_0__Reg1_1
  { CVT_95_addGR32orGR64Operands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_95_17
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_95_17
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_95_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_95_1
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_95_16
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_95_16
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem1285_1__imm_95_0
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_1__Tie0__Mem1285_0__imm_95_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem85_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__GR32orGR641_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem85_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Mem165_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__ImmUnsignedi81_1
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0__ImmUnsignedi81_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti64i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti16i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__ImmSExti32i81_0
  { CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_0__Imm1_1
  { CVT_95_addMemOperands, 1, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_1__Tie0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_Done },
  // Convert__Mem645_1__Imm1_0
  { CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem645_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__DstIdx641_1
  { CVT_95_addDstIdxOperands, 2, CVT_Done },
  // Convert__DstIdx641_0
  { CVT_95_addDstIdxOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Imm1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem165_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem645_0__Reg1_1__Imm1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem325_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Imm1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem325_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem645_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem165_2__Reg1_1
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem165_2__Reg1_1__Imm1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem5125_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem1285_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem2565_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem5125_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, 0, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, 0, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Mem2565_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Reg1_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Reg1_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_Reg, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem1285_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem2565_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem5125_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem645_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_3__Mem325_4__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Reg1_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem1285_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem2565_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem5125_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem645_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_6__Mem325_7__Imm1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_addMemOperands, 8, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0
  { CVT_95_Reg, 6, CVT_95_Reg, 8, CVT_95_Reg, 5, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__ImmUnsignedi81_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem5125_0__Reg1_1
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem5125_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem2565_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem5125_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem1285_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem2565_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem1285_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem2565_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem5125_1
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_Done },
  // Convert__Reg1_1__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__AVX512RC1_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addAVX512RCOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem5125_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__AVX512RC1_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addAVX512RCOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__ImmUnsignedi81_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_3__AVX512RC1_2
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addAVX512RCOperands, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_95_addAVX512RCOperands, 2, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Reg1_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_Reg, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0
  { CVT_95_Reg, 5, CVT_Tied, 0, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Reg1_6__ImmUnsignedi81_8
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addImmOperands, 9, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem645_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem645_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem325_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_5__Mem325_6__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Reg1_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Reg1_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem1285_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem2565_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem5125_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem645_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Reg1_2__AVX512RC1_3
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addAVX512RCOperands, 4, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addAVX512RCOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Mem645_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem1285_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem2565_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem5125_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem645_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Reg1_6__AVX512RC1_7
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_Reg, 7, CVT_95_addAVX512RCOperands, 8, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem325_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Mem325_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem325_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_1__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem645_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem645_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem325_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem325_2__Reg1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVX645_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVX645_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVX32X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY32X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVX32X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY32X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVX325_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVX325_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVY325_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVY325_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ325_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ325_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVY325_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVY325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVZ325_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVZ325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__MemVZ645_3
  { CVT_95_Reg, 2, CVT_95_addMemOperands, 4, CVT_Done },
  // Convert__Reg1_2__MemVZ645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_0__Tie0__MemVY645_1__Tie1
  { CVT_95_Reg, 3, CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__MemVY645_1__Tie1
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_addMemOperands, 2, CVT_Tied, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVX64X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVY64X5_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Tie0__Tie1__MemVZ645_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVX64X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVY64X5_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Tie0__Tie1__MemVZ645_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_Tied, 0, CVT_Tied, 1, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Mem1285_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem2565_2__Reg1_1__Reg1_0
  { CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem1285_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Mem2565_0__Reg1_1__Reg1_2
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_Done },
  // Convert__Mem645_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem645_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Mem325_1__Reg1_3__Reg1_0
  { CVT_95_addMemOperands, 2, CVT_95_Reg, 4, CVT_95_Reg, 1, CVT_Done },
  // Convert__Mem325_0__Reg1_2__Reg1_4
  { CVT_95_addMemOperands, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__Mem325_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem325_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem645_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem645_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Reg1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_4
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_17
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_17
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_17, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_1
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_1
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_1, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_16
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_16
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_16, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Reg1_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_Reg, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__imm_95_0
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_2__Reg1_1__Mem1285_0__imm_95_0
  { CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addMemOperands, 1, CVT_imm_95_0, 0, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Imm1_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_1__Mem165_2
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_4__Mem165_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem165_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Reg1_5__Mem165_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_Reg, 6, CVT_95_addMemOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem1285_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem1285_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Reg1_2__Mem2565_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_Reg, 3, CVT_95_addMemOperands, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem2565_2__Reg1_3__Imm1_4
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_Reg, 4, CVT_95_addImmOperands, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem1285_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Mem2565_2__Reg1_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_addMemOperands, 3, CVT_95_Reg, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__Mem2565_1__Imm1_0
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem2565_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_0__Mem5125_1__ImmUnsignedi81_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem645_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem2565_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem5125_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem2565_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem645_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem5125_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem2565_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem5125_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem645_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem645_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__GR32orGR641_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addGR32orGR64Operands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem85_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__GR32orGR641_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addGR32orGR64Operands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem85_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_1__Mem165_2__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_Reg, 2, CVT_95_addMemOperands, 3, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Reg1_2__Mem165_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem165_4
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_Done },
  // Convert__Reg1_1__Tie0__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_Tied, 0, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem165_5
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_Done },
  // Convert__Reg1_1__Reg1_3__Mem165_0
  { CVT_95_Reg, 2, CVT_95_Reg, 4, CVT_95_addMemOperands, 1, CVT_Done },
  // Convert__Reg1_0__Mem325_1__ImmUnsignedi81_3
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 4, CVT_Done },
  // Convert__Reg1_3__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem1285_4__ImmUnsignedi81_5
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 6, CVT_Done },
  // Convert__Reg1_2__Tie0__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_Tied, 0, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem1285_5__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_0__Tie0__Reg1_2__Mem325_4__ImmUnsignedi81_6
  { CVT_95_Reg, 1, CVT_Tied, 0, CVT_95_Reg, 3, CVT_95_addMemOperands, 5, CVT_95_addImmOperands, 7, CVT_Done },
  // Convert__Reg1_2__Reg1_4__Mem1285_1__ImmUnsignedi81_0
  { CVT_95_Reg, 3, CVT_95_Reg, 5, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__Tie0__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_Tied, 0, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_0__Reg1_2__Mem325_5__ImmUnsignedi81_7
  { CVT_95_Reg, 1, CVT_95_Reg, 3, CVT_95_addMemOperands, 6, CVT_95_addImmOperands, 8, CVT_Done },
  // Convert__Reg1_3__Reg1_5__Mem325_1__ImmUnsignedi81_0
  { CVT_95_Reg, 4, CVT_95_Reg, 6, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Reg1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Reg1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_Reg, 3, CVT_Done },
  // Convert__Reg1_0__Mem1285_1__Imm1_2
  { CVT_95_Reg, 1, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 3, CVT_Done },
  // Convert__Reg1_2__Mem1285_1__Imm1_0
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 2, CVT_95_addImmOperands, 1, CVT_Done },
  // Convert__Reg1_3__MemVX32X5_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__MemVY32X5_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__MemVZ325_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__MemVX32X5_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__MemVY32X5_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__MemVZ325_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_3__MemVX64X5_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__MemVY64X5_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_3__MemVZ645_1__Tie0__Reg1_0
  { CVT_95_Reg, 4, CVT_95_addMemOperands, 2, CVT_Tied, 0, CVT_95_Reg, 1, CVT_Done },
  // Convert__Reg1_2__MemVX64X5_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__MemVY64X5_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_2__MemVZ645_0__Tie0__Reg1_4
  { CVT_95_Reg, 3, CVT_95_addMemOperands, 1, CVT_Tied, 0, CVT_95_Reg, 5, CVT_Done },
  // Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_1
  { CVT_95_Reg, 5, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_1
  { CVT_95_Reg, 5, CVT_Tied, 0, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_1
  { CVT_95_Reg, 5, CVT_95_Reg, 7, CVT_95_Reg, 4, CVT_95_Reg, 3, CVT_95_addImmOperands, 2, CVT_Done },
  // Convert__AbsMem161_0
  { CVT_95_addAbsMemOperands, 1, CVT_Done },
};

void X86AsmParser::
convertToMCInst(unsigned Kind, MCInst &Inst, unsigned Opcode,
                const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  const uint8_t *Converter = ConversionTable[Kind];
  Inst.setOpcode(Opcode);
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addRegOperands(Inst, 1);
      break;
    case CVT_Tied:
      Inst.addOperand(Inst.getOperand(*(p + 1)));
      break;
    case CVT_imm_95_10:
      Inst.addOperand(MCOperand::createImm(10));
      break;
    case CVT_95_addImmOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addImmOperands(Inst, 1);
      break;
    case CVT_95_Reg:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addRegOperands(Inst, 1);
      break;
    case CVT_95_addMemOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addMemOperands(Inst, 5);
      break;
    case CVT_95_addAbsMemOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addAbsMemOperands(Inst, 1);
      break;
    case CVT_95_addDstIdxOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addDstIdxOperands(Inst, 1);
      break;
    case CVT_95_addSrcIdxOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addSrcIdxOperands(Inst, 2);
      break;
    case CVT_95_addGR32orGR64Operands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addGR32orGR64Operands(Inst, 1);
      break;
    case CVT_regST0:
      Inst.addOperand(MCOperand::createReg(X86::ST0));
      break;
    case CVT_regST1:
      Inst.addOperand(MCOperand::createReg(X86::ST1));
      break;
    case CVT_95_addMemOffsOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addMemOffsOperands(Inst, 2);
      break;
    case CVT_imm_95_17:
      Inst.addOperand(MCOperand::createImm(17));
      break;
    case CVT_imm_95_1:
      Inst.addOperand(MCOperand::createImm(1));
      break;
    case CVT_imm_95_16:
      Inst.addOperand(MCOperand::createImm(16));
      break;
    case CVT_imm_95_0:
      Inst.addOperand(MCOperand::createImm(0));
      break;
    case CVT_95_addAVX512RCOperands:
      static_cast<X86Operand&>(*Operands[*(p + 1)]).addAVX512RCOperands(Inst, 1);
      break;
    }
  }
}

void X86AsmParser::
convertToMapAndConstraints(unsigned Kind,
                           const OperandVector &Operands) {
  assert(Kind < CVT_NUM_SIGNATURES && "Invalid signature!");
  unsigned NumMCOperands = 0;
  const uint8_t *Converter = ConversionTable[Kind];
  for (const uint8_t *p = Converter; *p; p+= 2) {
    switch (*p) {
    default: llvm_unreachable("invalid conversion entry!");
    case CVT_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      ++NumMCOperands;
      break;
    case CVT_Tied:
      ++NumMCOperands;
      break;
    case CVT_imm_95_10:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addImmOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_Reg:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("r");
      NumMCOperands += 1;
      break;
    case CVT_95_addMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 5;
      break;
    case CVT_95_addAbsMemOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addDstIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_95_addSrcIdxOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_95_addGR32orGR64Operands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    case CVT_regST0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_regST1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      ++NumMCOperands;
      break;
    case CVT_95_addMemOffsOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 2;
      break;
    case CVT_imm_95_17:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_1:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_16:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_imm_95_0:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("");
      ++NumMCOperands;
      break;
    case CVT_95_addAVX512RCOperands:
      Operands[*(p + 1)]->setMCOperandNum(NumMCOperands);
      Operands[*(p + 1)]->setConstraint("m");
      NumMCOperands += 1;
      break;
    }
  }
}

namespace {

/// MatchClassKind - The kinds of classes which participate in
/// instruction matching.
enum MatchClassKind {
  InvalidMatchClass = 0,
  MCK__STAR_, // '*'
  MCK_b, // 'b'
  MCK_d, // 'd'
  MCK_pd, // 'pd'
  MCK_ps, // 'ps'
  MCK_q, // 'q'
  MCK_sd, // 'sd'
  MCK_ss, // 'ss'
  MCK_ub, // 'ub'
  MCK_ud, // 'ud'
  MCK_uq, // 'uq'
  MCK_uw, // 'uw'
  MCK_w, // 'w'
  MCK__123_, // '{'
  MCK__123_1to16_125_, // '{1to16}'
  MCK__123_1to2_125_, // '{1to2}'
  MCK__123_1to32_125_, // '{1to32}'
  MCK__123_1to4_125_, // '{1to4}'
  MCK__123_1to8_125_, // '{1to8}'
  MCK__123_sae_125_, // '{sae}'
  MCK__123_z_125_, // '{z}'
  MCK__125_, // '}'
  MCK_AL, // register class 'AL'
  MCK_CL, // register class 'CL'
  MCK_GR8_ABCD_L, // register class 'GR8_ABCD_L'
  MCK_GR8_ABCD_H, // register class 'GR8_ABCD_H'
  MCK_GR8_NOREX, // register class 'GR8_NOREX'
  MCK_GR8, // register class 'GR8'
  MCK_AX, // register class 'AX'
  MCK_DX, // register class 'DX'
  MCK_GR16_ABCD, // register class 'GR16_ABCD'
  MCK_GR16_NOREX, // register class 'GR16_NOREX'
  MCK_GR16, // register class 'GR16'
  MCK_EAX, // register class 'EAX'
  MCK_EDX, // register class 'EDX'
  MCK_GR32_AD, // register class 'GR32_AD'
  MCK_ECX, // register class 'ECX'
  MCK_Reg20, // derived register class
  MCK_Reg21, // derived register class
  MCK_Reg22, // derived register class
  MCK_Reg23, // derived register class
  MCK_Reg25, // derived register class
  MCK_GR32_NOAX, // register class 'GR32_NOAX'
  MCK_GR32_TC, // register class 'GR32_TC'
  MCK_GR32_ABCD, // register class 'GR32_ABCD'
  MCK_GR32_NOREX_NOSP, // register class 'GR32_NOREX_NOSP'
  MCK_GR32_NOREX, // register class 'GR32_NOREX'
  MCK_GR32_NOSP, // register class 'GR32_NOSP'
  MCK_GR32, // register class 'GR32'
  MCK_RAX, // register class 'RAX'
  MCK_RDX, // register class 'RDX'
  MCK_Reg28, // derived register class
  MCK_RCX, // register class 'RCX'
  MCK_Reg43, // derived register class
  MCK_Reg29, // derived register class
  MCK_Reg37, // derived register class
  MCK_Reg38, // derived register class
  MCK_Reg40, // derived register class
  MCK_Reg44, // derived register class
  MCK_Reg49, // derived register class
  MCK_Reg45, // derived register class
  MCK_Reg46, // derived register class
  MCK_Reg51, // derived register class
  MCK_Reg50, // derived register class
  MCK_Reg48, // derived register class
  MCK_Reg47, // derived register class
  MCK_GR64_ABCD, // register class 'GR64_ABCD'
  MCK_GR64_NOREX_NOSP, // register class 'GR64_NOREX_NOSP'
  MCK_Reg32, // derived register class
  MCK_GR64_TCW64, // register class 'GR64_TCW64'
  MCK_GR64_NOSP, // register class 'GR64_NOSP'
  MCK_Reg33, // derived register class
  MCK_GR64_NOREX, // register class 'GR64_NOREX'
  MCK_GR64_TC, // register class 'GR64_TC'
  MCK_GR64, // register class 'GR64'
  MCK_VR64, // register class 'VR64'
  MCK_RFP32, // register class 'RFP32,RFP64,RFP80'
  MCK_XMM0, // register class 'XMM0'
  MCK_FR32, // register class 'FR32,FR64,VR128'
  MCK_FR32X, // register class 'FR32X,FR64X,VR128X'
  MCK_VR256, // register class 'VR256'
  MCK_VR256X, // register class 'VR256X'
  MCK_Reg60, // derived register class
  MCK_VR512, // register class 'VR512'
  MCK_VK1WM, // register class 'VK1WM,VK2WM,VK4WM,VK8WM,VK16WM,VK32WM,VK64WM'
  MCK_VK1, // register class 'VK1,VK2,VK4,VK8,VK16,VK32,VK64'
  MCK_ST0, // register class 'ST0'
  MCK_RST, // register class 'RST'
  MCK_FPCCR, // register class 'FPCCR'
  MCK_CCR, // register class 'CCR'
  MCK_CS, // register class 'CS'
  MCK_DS, // register class 'DS'
  MCK_SS, // register class 'SS'
  MCK_ES, // register class 'ES'
  MCK_FS, // register class 'FS'
  MCK_GS, // register class 'GS'
  MCK_SEGMENT_REG, // register class 'SEGMENT_REG'
  MCK_DEBUG_REG, // register class 'DEBUG_REG'
  MCK_CONTROL_REG, // register class 'CONTROL_REG'
  MCK_BNDR, // register class 'BNDR'
  MCK_AVX512RC, // user defined class 'AVX512RCOperand'
  MCK_ImmSExti64i8, // user defined class 'ImmSExti64i8AsmOperand'
  MCK_ImmSExti16i8, // user defined class 'ImmSExti16i8AsmOperand'
  MCK_ImmSExti32i8, // user defined class 'ImmSExti32i8AsmOperand'
  MCK_ImmSExti64i32, // user defined class 'ImmSExti64i32AsmOperand'
  MCK_Imm, // user defined class 'ImmAsmOperand'
  MCK_ImmUnsignedi8, // user defined class 'ImmUnsignedi8AsmOperand'
  MCK_AbsMem16, // user defined class 'X86AbsMem16AsmOperand'
  MCK_AbsMem, // user defined class 'X86AbsMemAsmOperand'
  MCK_DstIdx16, // user defined class 'X86DstIdx16Operand'
  MCK_DstIdx32, // user defined class 'X86DstIdx32Operand'
  MCK_DstIdx64, // user defined class 'X86DstIdx64Operand'
  MCK_DstIdx8, // user defined class 'X86DstIdx8Operand'
  MCK_GR32orGR64, // user defined class 'X86GR32orGR64AsmOperand'
  MCK_Mem128, // user defined class 'X86Mem128AsmOperand'
  MCK_Mem16, // user defined class 'X86Mem16AsmOperand'
  MCK_Mem256, // user defined class 'X86Mem256AsmOperand'
  MCK_Mem32, // user defined class 'X86Mem32AsmOperand'
  MCK_Mem512, // user defined class 'X86Mem512AsmOperand'
  MCK_Mem64, // user defined class 'X86Mem64AsmOperand'
  MCK_Mem80, // user defined class 'X86Mem80AsmOperand'
  MCK_Mem8, // user defined class 'X86Mem8AsmOperand'
  MCK_Mem, // user defined class 'X86MemAsmOperand'
  MCK_MemOffs16_16, // user defined class 'X86MemOffs16_16AsmOperand'
  MCK_MemOffs16_32, // user defined class 'X86MemOffs16_32AsmOperand'
  MCK_MemOffs16_8, // user defined class 'X86MemOffs16_8AsmOperand'
  MCK_MemOffs32_16, // user defined class 'X86MemOffs32_16AsmOperand'
  MCK_MemOffs32_32, // user defined class 'X86MemOffs32_32AsmOperand'
  MCK_MemOffs32_64, // user defined class 'X86MemOffs32_64AsmOperand'
  MCK_MemOffs32_8, // user defined class 'X86MemOffs32_8AsmOperand'
  MCK_MemOffs64_16, // user defined class 'X86MemOffs64_16AsmOperand'
  MCK_MemOffs64_32, // user defined class 'X86MemOffs64_32AsmOperand'
  MCK_MemOffs64_64, // user defined class 'X86MemOffs64_64AsmOperand'
  MCK_MemOffs64_8, // user defined class 'X86MemOffs64_8AsmOperand'
  MCK_MemVX32, // user defined class 'X86MemVX32Operand'
  MCK_MemVX32X, // user defined class 'X86MemVX32XOperand'
  MCK_MemVX64, // user defined class 'X86MemVX64Operand'
  MCK_MemVX64X, // user defined class 'X86MemVX64XOperand'
  MCK_MemVY32, // user defined class 'X86MemVY32Operand'
  MCK_MemVY32X, // user defined class 'X86MemVY32XOperand'
  MCK_MemVY64, // user defined class 'X86MemVY64Operand'
  MCK_MemVY64X, // user defined class 'X86MemVY64XOperand'
  MCK_MemVZ32, // user defined class 'X86MemVZ32Operand'
  MCK_MemVZ64, // user defined class 'X86MemVZ64Operand'
  MCK_SrcIdx16, // user defined class 'X86SrcIdx16Operand'
  MCK_SrcIdx32, // user defined class 'X86SrcIdx32Operand'
  MCK_SrcIdx64, // user defined class 'X86SrcIdx64Operand'
  MCK_SrcIdx8, // user defined class 'X86SrcIdx8Operand'
  NumMatchClassKinds
};

}

static MatchClassKind matchTokenString(StringRef Name) {
  switch (Name.size()) {
  default: break;
  case 1:	 // 7 strings to match.
    switch (Name[0]) {
    default: break;
    case '*':	 // 1 string to match.
      return MCK__STAR_;	 // "*"
    case 'b':	 // 1 string to match.
      return MCK_b;	 // "b"
    case 'd':	 // 1 string to match.
      return MCK_d;	 // "d"
    case 'q':	 // 1 string to match.
      return MCK_q;	 // "q"
    case 'w':	 // 1 string to match.
      return MCK_w;	 // "w"
    case '{':	 // 1 string to match.
      return MCK__123_;	 // "{"
    case '}':	 // 1 string to match.
      return MCK__125_;	 // "}"
    }
    break;
  case 2:	 // 8 strings to match.
    switch (Name[0]) {
    default: break;
    case 'p':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_pd;	 // "pd"
      case 's':	 // 1 string to match.
        return MCK_ps;	 // "ps"
      }
      break;
    case 's':	 // 2 strings to match.
      switch (Name[1]) {
      default: break;
      case 'd':	 // 1 string to match.
        return MCK_sd;	 // "sd"
      case 's':	 // 1 string to match.
        return MCK_ss;	 // "ss"
      }
      break;
    case 'u':	 // 4 strings to match.
      switch (Name[1]) {
      default: break;
      case 'b':	 // 1 string to match.
        return MCK_ub;	 // "ub"
      case 'd':	 // 1 string to match.
        return MCK_ud;	 // "ud"
      case 'q':	 // 1 string to match.
        return MCK_uq;	 // "uq"
      case 'w':	 // 1 string to match.
        return MCK_uw;	 // "uw"
      }
      break;
    }
    break;
  case 3:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{z}", 3))
      break;
    return MCK__123_z_125_;	 // "{z}"
  case 5:	 // 1 string to match.
    if (memcmp(Name.data()+0, "{sae}", 5))
      break;
    return MCK__123_sae_125_;	 // "{sae}"
  case 6:	 // 3 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4))
      break;
    switch (Name[4]) {
    default: break;
    case '2':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to2_125_;	 // "{1to2}"
    case '4':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to4_125_;	 // "{1to4}"
    case '8':	 // 1 string to match.
      if (Name[5] != '}')
        break;
      return MCK__123_1to8_125_;	 // "{1to8}"
    }
    break;
  case 7:	 // 2 strings to match.
    if (memcmp(Name.data()+0, "{1to", 4))
      break;
    switch (Name[4]) {
    default: break;
    case '1':	 // 1 string to match.
      if (memcmp(Name.data()+5, "6}", 2))
        break;
      return MCK__123_1to16_125_;	 // "{1to16}"
    case '3':	 // 1 string to match.
      if (memcmp(Name.data()+5, "2}", 2))
        break;
      return MCK__123_1to32_125_;	 // "{1to32}"
    }
    break;
  }
  return InvalidMatchClass;
}

/// isSubclass - Compute whether \p A is a subclass of \p B.
static bool isSubclass(MatchClassKind A, MatchClassKind B) {
  if (A == B)
    return true;

  switch (A) {
  default:
    return false;

  case MCK_AL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_CL:
    switch (B) {
    default: return false;
    case MCK_GR8_ABCD_L: return true;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_L:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_ABCD_H:
    switch (B) {
    default: return false;
    case MCK_GR8_NOREX: return true;
    case MCK_GR8: return true;
    }

  case MCK_GR8_NOREX:
    return B == MCK_GR8;

  case MCK_AX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_DX:
    switch (B) {
    default: return false;
    case MCK_GR16_ABCD: return true;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR16_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR16_NOREX: return true;
    case MCK_GR16: return true;
    }

  case MCK_GR16_NOREX:
    return B == MCK_GR16;

  case MCK_EAX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_EDX:
    switch (B) {
    default: return false;
    case MCK_GR32_AD: return true;
    case MCK_Reg20: return true;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_AD:
    switch (B) {
    default: return false;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_ECX:
    switch (B) {
    default: return false;
    case MCK_Reg20: return true;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg20:
    switch (B) {
    default: return false;
    case MCK_Reg21: return true;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_TC: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg21:
    switch (B) {
    default: return false;
    case MCK_Reg22: return true;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg22:
    switch (B) {
    default: return false;
    case MCK_Reg23: return true;
    case MCK_Reg25: return true;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg23:
    switch (B) {
    default: return false;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32: return true;
    }

  case MCK_Reg25:
    switch (B) {
    default: return false;
    case MCK_GR32_NOAX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOAX:
    return B == MCK_GR32;

  case MCK_GR32_TC:
    switch (B) {
    default: return false;
    case MCK_GR32_ABCD: return true;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX_NOSP: return true;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_GR32_NOREX: return true;
    case MCK_GR32_NOSP: return true;
    case MCK_GR32: return true;
    }

  case MCK_GR32_NOREX:
    return B == MCK_GR32;

  case MCK_GR32_NOSP:
    return B == MCK_GR32;

  case MCK_RAX:
    switch (B) {
    default: return false;
    case MCK_Reg28: return true;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_RDX:
    switch (B) {
    default: return false;
    case MCK_Reg28: return true;
    case MCK_Reg43: return true;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg49: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_Reg51: return true;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg28:
    switch (B) {
    default: return false;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_RCX:
    switch (B) {
    default: return false;
    case MCK_Reg43: return true;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg49: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_Reg51: return true;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg43:
    switch (B) {
    default: return false;
    case MCK_Reg29: return true;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg44: return true;
    case MCK_Reg49: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_Reg51: return true;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg29:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg37:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg38:
    switch (B) {
    default: return false;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg40:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg44:
    switch (B) {
    default: return false;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_ABCD: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg49:
    switch (B) {
    default: return false;
    case MCK_Reg37: return true;
    case MCK_Reg38: return true;
    case MCK_Reg40: return true;
    case MCK_Reg45: return true;
    case MCK_Reg46: return true;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg45:
    switch (B) {
    default: return false;
    case MCK_Reg46: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg46:
    switch (B) {
    default: return false;
    case MCK_Reg47: return true;
    case MCK_Reg32: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg51:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg50: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_TCW64: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg50:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_Reg48: return true;
    case MCK_Reg47: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg48:
    switch (B) {
    default: return false;
    case MCK_Reg47: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg47:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_ABCD:
    switch (B) {
    default: return false;
    case MCK_GR64_NOREX_NOSP: return true;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_NOREX_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg32: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg32:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64_NOREX: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_TCW64:
    switch (B) {
    default: return false;
    case MCK_Reg38: return true;
    case MCK_GR64_NOSP: return true;
    case MCK_Reg33: return true;
    case MCK_GR64_TC: return true;
    case MCK_GR64: return true;
    }

  case MCK_GR64_NOSP:
    switch (B) {
    default: return false;
    case MCK_Reg33: return true;
    case MCK_GR64: return true;
    }

  case MCK_Reg33:
    return B == MCK_GR64;

  case MCK_GR64_NOREX:
    return B == MCK_GR64;

  case MCK_GR64_TC:
    return B == MCK_GR64;

  case MCK_XMM0:
    switch (B) {
    default: return false;
    case MCK_FR32: return true;
    case MCK_FR32X: return true;
    }

  case MCK_FR32:
    return B == MCK_FR32X;

  case MCK_VR256:
    return B == MCK_VR256X;

  case MCK_Reg60:
    return B == MCK_VR512;

  case MCK_VK1WM:
    return B == MCK_VK1;

  case MCK_ST0:
    return B == MCK_RST;

  case MCK_CS:
    return B == MCK_SEGMENT_REG;

  case MCK_DS:
    return B == MCK_SEGMENT_REG;

  case MCK_SS:
    return B == MCK_SEGMENT_REG;

  case MCK_ES:
    return B == MCK_SEGMENT_REG;

  case MCK_FS:
    return B == MCK_SEGMENT_REG;

  case MCK_GS:
    return B == MCK_SEGMENT_REG;

  case MCK_ImmSExti64i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti16i8: return true;
    case MCK_ImmSExti32i8: return true;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti16i8:
    switch (B) {
    default: return false;
    case MCK_ImmSExti64i32: return true;
    case MCK_Imm: return true;
    }

  case MCK_ImmSExti32i8:
    return B == MCK_Imm;

  case MCK_ImmSExti64i32:
    return B == MCK_Imm;

  case MCK_AbsMem16:
    switch (B) {
    default: return false;
    case MCK_AbsMem: return true;
    case MCK_Mem: return true;
    }

  case MCK_AbsMem:
    return B == MCK_Mem;

  case MCK_DstIdx16:
    return B == MCK_Mem16;

  case MCK_DstIdx32:
    return B == MCK_Mem32;

  case MCK_DstIdx64:
    return B == MCK_Mem64;

  case MCK_DstIdx8:
    return B == MCK_Mem8;

  case MCK_MemOffs16_16:
    return B == MCK_Mem16;

  case MCK_MemOffs16_32:
    return B == MCK_Mem32;

  case MCK_MemOffs16_8:
    return B == MCK_Mem8;

  case MCK_MemOffs32_16:
    return B == MCK_Mem16;

  case MCK_MemOffs32_32:
    return B == MCK_Mem32;

  case MCK_MemOffs32_64:
    return B == MCK_Mem64;

  case MCK_MemOffs32_8:
    return B == MCK_Mem8;

  case MCK_MemOffs64_16:
    return B == MCK_Mem16;

  case MCK_MemOffs64_32:
    return B == MCK_Mem32;

  case MCK_MemOffs64_64:
    return B == MCK_Mem64;

  case MCK_MemOffs64_8:
    return B == MCK_Mem8;

  case MCK_SrcIdx16:
    return B == MCK_Mem16;

  case MCK_SrcIdx32:
    return B == MCK_Mem32;

  case MCK_SrcIdx64:
    return B == MCK_Mem64;

  case MCK_SrcIdx8:
    return B == MCK_Mem8;
  }
}

static unsigned validateOperandClass(MCParsedAsmOperand &GOp, MatchClassKind Kind) {
  X86Operand &Operand = (X86Operand&)GOp;
  if (Kind == InvalidMatchClass)
    return MCTargetAsmParser::Match_InvalidOperand;

  if (Operand.isToken())
    return isSubclass(matchTokenString(Operand.getToken()), Kind) ?
             MCTargetAsmParser::Match_Success :
             MCTargetAsmParser::Match_InvalidOperand;

  // 'AVX512RC' class
  if (Kind == MCK_AVX512RC) {
    if (Operand.isAVX512RC())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti64i8' class
  if (Kind == MCK_ImmSExti64i8) {
    if (Operand.isImmSExti64i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti16i8' class
  if (Kind == MCK_ImmSExti16i8) {
    if (Operand.isImmSExti16i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti32i8' class
  if (Kind == MCK_ImmSExti32i8) {
    if (Operand.isImmSExti32i8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmSExti64i32' class
  if (Kind == MCK_ImmSExti64i32) {
    if (Operand.isImmSExti64i32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Imm' class
  if (Kind == MCK_Imm) {
    if (Operand.isImm())
      return MCTargetAsmParser::Match_Success;
  }

  // 'ImmUnsignedi8' class
  if (Kind == MCK_ImmUnsignedi8) {
    if (Operand.isImmUnsignedi8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'AbsMem16' class
  if (Kind == MCK_AbsMem16) {
    if (Operand.isAbsMem16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'AbsMem' class
  if (Kind == MCK_AbsMem) {
    if (Operand.isAbsMem())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx16' class
  if (Kind == MCK_DstIdx16) {
    if (Operand.isDstIdx16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx32' class
  if (Kind == MCK_DstIdx32) {
    if (Operand.isDstIdx32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx64' class
  if (Kind == MCK_DstIdx64) {
    if (Operand.isDstIdx64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'DstIdx8' class
  if (Kind == MCK_DstIdx8) {
    if (Operand.isDstIdx8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'GR32orGR64' class
  if (Kind == MCK_GR32orGR64) {
    if (Operand.isGR32orGR64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem128' class
  if (Kind == MCK_Mem128) {
    if (Operand.isMem128())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem16' class
  if (Kind == MCK_Mem16) {
    if (Operand.isMem16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem256' class
  if (Kind == MCK_Mem256) {
    if (Operand.isMem256())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem32' class
  if (Kind == MCK_Mem32) {
    if (Operand.isMem32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem512' class
  if (Kind == MCK_Mem512) {
    if (Operand.isMem512())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem64' class
  if (Kind == MCK_Mem64) {
    if (Operand.isMem64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem80' class
  if (Kind == MCK_Mem80) {
    if (Operand.isMem80())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem8' class
  if (Kind == MCK_Mem8) {
    if (Operand.isMem8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'Mem' class
  if (Kind == MCK_Mem) {
    if (Operand.isMem())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs16_16' class
  if (Kind == MCK_MemOffs16_16) {
    if (Operand.isMemOffs16_16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs16_32' class
  if (Kind == MCK_MemOffs16_32) {
    if (Operand.isMemOffs16_32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs16_8' class
  if (Kind == MCK_MemOffs16_8) {
    if (Operand.isMemOffs16_8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs32_16' class
  if (Kind == MCK_MemOffs32_16) {
    if (Operand.isMemOffs32_16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs32_32' class
  if (Kind == MCK_MemOffs32_32) {
    if (Operand.isMemOffs32_32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs32_64' class
  if (Kind == MCK_MemOffs32_64) {
    if (Operand.isMemOffs32_64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs32_8' class
  if (Kind == MCK_MemOffs32_8) {
    if (Operand.isMemOffs32_8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs64_16' class
  if (Kind == MCK_MemOffs64_16) {
    if (Operand.isMemOffs64_16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs64_32' class
  if (Kind == MCK_MemOffs64_32) {
    if (Operand.isMemOffs64_32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs64_64' class
  if (Kind == MCK_MemOffs64_64) {
    if (Operand.isMemOffs64_64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemOffs64_8' class
  if (Kind == MCK_MemOffs64_8) {
    if (Operand.isMemOffs64_8())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX32' class
  if (Kind == MCK_MemVX32) {
    if (Operand.isMemVX32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX32X' class
  if (Kind == MCK_MemVX32X) {
    if (Operand.isMemVX32X())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX64' class
  if (Kind == MCK_MemVX64) {
    if (Operand.isMemVX64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVX64X' class
  if (Kind == MCK_MemVX64X) {
    if (Operand.isMemVX64X())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY32' class
  if (Kind == MCK_MemVY32) {
    if (Operand.isMemVY32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY32X' class
  if (Kind == MCK_MemVY32X) {
    if (Operand.isMemVY32X())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY64' class
  if (Kind == MCK_MemVY64) {
    if (Operand.isMemVY64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVY64X' class
  if (Kind == MCK_MemVY64X) {
    if (Operand.isMemVY64X())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVZ32' class
  if (Kind == MCK_MemVZ32) {
    if (Operand.isMemVZ32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'MemVZ64' class
  if (Kind == MCK_MemVZ64) {
    if (Operand.isMemVZ64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx16' class
  if (Kind == MCK_SrcIdx16) {
    if (Operand.isSrcIdx16())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx32' class
  if (Kind == MCK_SrcIdx32) {
    if (Operand.isSrcIdx32())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx64' class
  if (Kind == MCK_SrcIdx64) {
    if (Operand.isSrcIdx64())
      return MCTargetAsmParser::Match_Success;
  }

  // 'SrcIdx8' class
  if (Kind == MCK_SrcIdx8) {
    if (Operand.isSrcIdx8())
      return MCTargetAsmParser::Match_Success;
  }

  if (Operand.isReg()) {
    MatchClassKind OpKind;
    switch (Operand.getReg()) {
    default: OpKind = InvalidMatchClass; break;
    case X86::AL: OpKind = MCK_AL; break;
    case X86::DL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::CL: OpKind = MCK_CL; break;
    case X86::BL: OpKind = MCK_GR8_ABCD_L; break;
    case X86::AH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::DH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::CH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::BH: OpKind = MCK_GR8_ABCD_H; break;
    case X86::SIL: OpKind = MCK_GR8; break;
    case X86::DIL: OpKind = MCK_GR8; break;
    case X86::BPL: OpKind = MCK_GR8; break;
    case X86::SPL: OpKind = MCK_GR8; break;
    case X86::R8B: OpKind = MCK_GR8; break;
    case X86::R9B: OpKind = MCK_GR8; break;
    case X86::R10B: OpKind = MCK_GR8; break;
    case X86::R11B: OpKind = MCK_GR8; break;
    case X86::R12B: OpKind = MCK_GR8; break;
    case X86::R13B: OpKind = MCK_GR8; break;
    case X86::R14B: OpKind = MCK_GR8; break;
    case X86::R15B: OpKind = MCK_GR8; break;
    case X86::AX: OpKind = MCK_AX; break;
    case X86::DX: OpKind = MCK_DX; break;
    case X86::CX: OpKind = MCK_GR16_ABCD; break;
    case X86::BX: OpKind = MCK_GR16_ABCD; break;
    case X86::SI: OpKind = MCK_GR16_NOREX; break;
    case X86::DI: OpKind = MCK_GR16_NOREX; break;
    case X86::BP: OpKind = MCK_GR16_NOREX; break;
    case X86::SP: OpKind = MCK_GR16_NOREX; break;
    case X86::R8W: OpKind = MCK_GR16; break;
    case X86::R9W: OpKind = MCK_GR16; break;
    case X86::R10W: OpKind = MCK_GR16; break;
    case X86::R11W: OpKind = MCK_GR16; break;
    case X86::R12W: OpKind = MCK_GR16; break;
    case X86::R13W: OpKind = MCK_GR16; break;
    case X86::R14W: OpKind = MCK_GR16; break;
    case X86::R15W: OpKind = MCK_GR16; break;
    case X86::EAX: OpKind = MCK_EAX; break;
    case X86::EDX: OpKind = MCK_EDX; break;
    case X86::ECX: OpKind = MCK_ECX; break;
    case X86::EBX: OpKind = MCK_Reg21; break;
    case X86::ESI: OpKind = MCK_Reg22; break;
    case X86::EDI: OpKind = MCK_Reg22; break;
    case X86::EBP: OpKind = MCK_Reg22; break;
    case X86::ESP: OpKind = MCK_Reg23; break;
    case X86::R8D: OpKind = MCK_Reg25; break;
    case X86::R9D: OpKind = MCK_Reg25; break;
    case X86::R10D: OpKind = MCK_Reg25; break;
    case X86::R11D: OpKind = MCK_Reg25; break;
    case X86::R12D: OpKind = MCK_Reg25; break;
    case X86::R13D: OpKind = MCK_Reg25; break;
    case X86::R14D: OpKind = MCK_Reg25; break;
    case X86::R15D: OpKind = MCK_Reg25; break;
    case X86::RAX: OpKind = MCK_RAX; break;
    case X86::RDX: OpKind = MCK_RDX; break;
    case X86::RCX: OpKind = MCK_RCX; break;
    case X86::RBX: OpKind = MCK_Reg44; break;
    case X86::RSI: OpKind = MCK_Reg49; break;
    case X86::RDI: OpKind = MCK_Reg49; break;
    case X86::RBP: OpKind = MCK_Reg45; break;
    case X86::RSP: OpKind = MCK_Reg46; break;
    case X86::R8: OpKind = MCK_Reg51; break;
    case X86::R9: OpKind = MCK_Reg51; break;
    case X86::R10: OpKind = MCK_Reg48; break;
    case X86::R11: OpKind = MCK_Reg51; break;
    case X86::R12: OpKind = MCK_Reg48; break;
    case X86::R13: OpKind = MCK_Reg48; break;
    case X86::R14: OpKind = MCK_Reg48; break;
    case X86::R15: OpKind = MCK_Reg48; break;
    case X86::RIP: OpKind = MCK_Reg40; break;
    case X86::MM0: OpKind = MCK_VR64; break;
    case X86::MM1: OpKind = MCK_VR64; break;
    case X86::MM2: OpKind = MCK_VR64; break;
    case X86::MM3: OpKind = MCK_VR64; break;
    case X86::MM4: OpKind = MCK_VR64; break;
    case X86::MM5: OpKind = MCK_VR64; break;
    case X86::MM6: OpKind = MCK_VR64; break;
    case X86::MM7: OpKind = MCK_VR64; break;
    case X86::FP0: OpKind = MCK_RFP32; break;
    case X86::FP1: OpKind = MCK_RFP32; break;
    case X86::FP2: OpKind = MCK_RFP32; break;
    case X86::FP3: OpKind = MCK_RFP32; break;
    case X86::FP4: OpKind = MCK_RFP32; break;
    case X86::FP5: OpKind = MCK_RFP32; break;
    case X86::FP6: OpKind = MCK_RFP32; break;
    case X86::XMM0: OpKind = MCK_XMM0; break;
    case X86::XMM1: OpKind = MCK_FR32; break;
    case X86::XMM2: OpKind = MCK_FR32; break;
    case X86::XMM3: OpKind = MCK_FR32; break;
    case X86::XMM4: OpKind = MCK_FR32; break;
    case X86::XMM5: OpKind = MCK_FR32; break;
    case X86::XMM6: OpKind = MCK_FR32; break;
    case X86::XMM7: OpKind = MCK_FR32; break;
    case X86::XMM8: OpKind = MCK_FR32; break;
    case X86::XMM9: OpKind = MCK_FR32; break;
    case X86::XMM10: OpKind = MCK_FR32; break;
    case X86::XMM11: OpKind = MCK_FR32; break;
    case X86::XMM12: OpKind = MCK_FR32; break;
    case X86::XMM13: OpKind = MCK_FR32; break;
    case X86::XMM14: OpKind = MCK_FR32; break;
    case X86::XMM15: OpKind = MCK_FR32; break;
    case X86::XMM16: OpKind = MCK_FR32X; break;
    case X86::XMM17: OpKind = MCK_FR32X; break;
    case X86::XMM18: OpKind = MCK_FR32X; break;
    case X86::XMM19: OpKind = MCK_FR32X; break;
    case X86::XMM20: OpKind = MCK_FR32X; break;
    case X86::XMM21: OpKind = MCK_FR32X; break;
    case X86::XMM22: OpKind = MCK_FR32X; break;
    case X86::XMM23: OpKind = MCK_FR32X; break;
    case X86::XMM24: OpKind = MCK_FR32X; break;
    case X86::XMM25: OpKind = MCK_FR32X; break;
    case X86::XMM26: OpKind = MCK_FR32X; break;
    case X86::XMM27: OpKind = MCK_FR32X; break;
    case X86::XMM28: OpKind = MCK_FR32X; break;
    case X86::XMM29: OpKind = MCK_FR32X; break;
    case X86::XMM30: OpKind = MCK_FR32X; break;
    case X86::XMM31: OpKind = MCK_FR32X; break;
    case X86::YMM0: OpKind = MCK_VR256; break;
    case X86::YMM1: OpKind = MCK_VR256; break;
    case X86::YMM2: OpKind = MCK_VR256; break;
    case X86::YMM3: OpKind = MCK_VR256; break;
    case X86::YMM4: OpKind = MCK_VR256; break;
    case X86::YMM5: OpKind = MCK_VR256; break;
    case X86::YMM6: OpKind = MCK_VR256; break;
    case X86::YMM7: OpKind = MCK_VR256; break;
    case X86::YMM8: OpKind = MCK_VR256; break;
    case X86::YMM9: OpKind = MCK_VR256; break;
    case X86::YMM10: OpKind = MCK_VR256; break;
    case X86::YMM11: OpKind = MCK_VR256; break;
    case X86::YMM12: OpKind = MCK_VR256; break;
    case X86::YMM13: OpKind = MCK_VR256; break;
    case X86::YMM14: OpKind = MCK_VR256; break;
    case X86::YMM15: OpKind = MCK_VR256; break;
    case X86::YMM16: OpKind = MCK_VR256X; break;
    case X86::YMM17: OpKind = MCK_VR256X; break;
    case X86::YMM18: OpKind = MCK_VR256X; break;
    case X86::YMM19: OpKind = MCK_VR256X; break;
    case X86::YMM20: OpKind = MCK_VR256X; break;
    case X86::YMM21: OpKind = MCK_VR256X; break;
    case X86::YMM22: OpKind = MCK_VR256X; break;
    case X86::YMM23: OpKind = MCK_VR256X; break;
    case X86::YMM24: OpKind = MCK_VR256X; break;
    case X86::YMM25: OpKind = MCK_VR256X; break;
    case X86::YMM26: OpKind = MCK_VR256X; break;
    case X86::YMM27: OpKind = MCK_VR256X; break;
    case X86::YMM28: OpKind = MCK_VR256X; break;
    case X86::YMM29: OpKind = MCK_VR256X; break;
    case X86::YMM30: OpKind = MCK_VR256X; break;
    case X86::YMM31: OpKind = MCK_VR256X; break;
    case X86::ZMM0: OpKind = MCK_Reg60; break;
    case X86::ZMM1: OpKind = MCK_Reg60; break;
    case X86::ZMM2: OpKind = MCK_Reg60; break;
    case X86::ZMM3: OpKind = MCK_Reg60; break;
    case X86::ZMM4: OpKind = MCK_Reg60; break;
    case X86::ZMM5: OpKind = MCK_Reg60; break;
    case X86::ZMM6: OpKind = MCK_Reg60; break;
    case X86::ZMM7: OpKind = MCK_Reg60; break;
    case X86::ZMM8: OpKind = MCK_Reg60; break;
    case X86::ZMM9: OpKind = MCK_Reg60; break;
    case X86::ZMM10: OpKind = MCK_Reg60; break;
    case X86::ZMM11: OpKind = MCK_Reg60; break;
    case X86::ZMM12: OpKind = MCK_Reg60; break;
    case X86::ZMM13: OpKind = MCK_Reg60; break;
    case X86::ZMM14: OpKind = MCK_Reg60; break;
    case X86::ZMM15: OpKind = MCK_Reg60; break;
    case X86::ZMM16: OpKind = MCK_VR512; break;
    case X86::ZMM17: OpKind = MCK_VR512; break;
    case X86::ZMM18: OpKind = MCK_VR512; break;
    case X86::ZMM19: OpKind = MCK_VR512; break;
    case X86::ZMM20: OpKind = MCK_VR512; break;
    case X86::ZMM21: OpKind = MCK_VR512; break;
    case X86::ZMM22: OpKind = MCK_VR512; break;
    case X86::ZMM23: OpKind = MCK_VR512; break;
    case X86::ZMM24: OpKind = MCK_VR512; break;
    case X86::ZMM25: OpKind = MCK_VR512; break;
    case X86::ZMM26: OpKind = MCK_VR512; break;
    case X86::ZMM27: OpKind = MCK_VR512; break;
    case X86::ZMM28: OpKind = MCK_VR512; break;
    case X86::ZMM29: OpKind = MCK_VR512; break;
    case X86::ZMM30: OpKind = MCK_VR512; break;
    case X86::ZMM31: OpKind = MCK_VR512; break;
    case X86::K0: OpKind = MCK_VK1; break;
    case X86::K1: OpKind = MCK_VK1WM; break;
    case X86::K2: OpKind = MCK_VK1WM; break;
    case X86::K3: OpKind = MCK_VK1WM; break;
    case X86::K4: OpKind = MCK_VK1WM; break;
    case X86::K5: OpKind = MCK_VK1WM; break;
    case X86::K6: OpKind = MCK_VK1WM; break;
    case X86::K7: OpKind = MCK_VK1WM; break;
    case X86::ST0: OpKind = MCK_ST0; break;
    case X86::ST1: OpKind = MCK_RST; break;
    case X86::ST2: OpKind = MCK_RST; break;
    case X86::ST3: OpKind = MCK_RST; break;
    case X86::ST4: OpKind = MCK_RST; break;
    case X86::ST5: OpKind = MCK_RST; break;
    case X86::ST6: OpKind = MCK_RST; break;
    case X86::ST7: OpKind = MCK_RST; break;
    case X86::FPSW: OpKind = MCK_FPCCR; break;
    case X86::EFLAGS: OpKind = MCK_CCR; break;
    case X86::CS: OpKind = MCK_CS; break;
    case X86::DS: OpKind = MCK_DS; break;
    case X86::SS: OpKind = MCK_SS; break;
    case X86::ES: OpKind = MCK_ES; break;
    case X86::FS: OpKind = MCK_FS; break;
    case X86::GS: OpKind = MCK_GS; break;
    case X86::DR0: OpKind = MCK_DEBUG_REG; break;
    case X86::DR1: OpKind = MCK_DEBUG_REG; break;
    case X86::DR2: OpKind = MCK_DEBUG_REG; break;
    case X86::DR3: OpKind = MCK_DEBUG_REG; break;
    case X86::DR4: OpKind = MCK_DEBUG_REG; break;
    case X86::DR5: OpKind = MCK_DEBUG_REG; break;
    case X86::DR6: OpKind = MCK_DEBUG_REG; break;
    case X86::DR7: OpKind = MCK_DEBUG_REG; break;
    case X86::CR0: OpKind = MCK_CONTROL_REG; break;
    case X86::CR1: OpKind = MCK_CONTROL_REG; break;
    case X86::CR2: OpKind = MCK_CONTROL_REG; break;
    case X86::CR3: OpKind = MCK_CONTROL_REG; break;
    case X86::CR4: OpKind = MCK_CONTROL_REG; break;
    case X86::CR5: OpKind = MCK_CONTROL_REG; break;
    case X86::CR6: OpKind = MCK_CONTROL_REG; break;
    case X86::CR7: OpKind = MCK_CONTROL_REG; break;
    case X86::CR8: OpKind = MCK_CONTROL_REG; break;
    case X86::CR9: OpKind = MCK_CONTROL_REG; break;
    case X86::CR10: OpKind = MCK_CONTROL_REG; break;
    case X86::CR11: OpKind = MCK_CONTROL_REG; break;
    case X86::CR12: OpKind = MCK_CONTROL_REG; break;
    case X86::CR13: OpKind = MCK_CONTROL_REG; break;
    case X86::CR14: OpKind = MCK_CONTROL_REG; break;
    case X86::CR15: OpKind = MCK_CONTROL_REG; break;
    case X86::BND0: OpKind = MCK_BNDR; break;
    case X86::BND1: OpKind = MCK_BNDR; break;
    case X86::BND2: OpKind = MCK_BNDR; break;
    case X86::BND3: OpKind = MCK_BNDR; break;
    }
    return isSubclass(OpKind, Kind) ? MCTargetAsmParser::Match_Success :
                                      MCTargetAsmParser::Match_InvalidOperand;
  }

  return MCTargetAsmParser::Match_InvalidOperand;
}

uint64_t X86AsmParser::
ComputeAvailableFeatures(const FeatureBitset& FB) const {
  uint64_t Features = 0;
  if ((FB[X86::FeatureAVX512]))
    Features |= Feature_HasAVX512;
  if ((FB[X86::FeatureCDI]))
    Features |= Feature_HasCDI;
  if ((FB[X86::FeaturePFI]))
    Features |= Feature_HasPFI;
  if ((FB[X86::FeatureERI]))
    Features |= Feature_HasERI;
  if ((FB[X86::FeatureDQI]))
    Features |= Feature_HasDQI;
  if ((FB[X86::FeatureBWI]))
    Features |= Feature_HasBWI;
  if ((FB[X86::FeatureVLX]))
    Features |= Feature_HasVLX;
  if ((!FB[X86::Mode64Bit]))
    Features |= Feature_Not64BitMode;
  if ((FB[X86::Mode64Bit]))
    Features |= Feature_In64BitMode;
  if ((FB[X86::Mode16Bit]))
    Features |= Feature_In16BitMode;
  if ((!FB[X86::Mode16Bit]))
    Features |= Feature_Not16BitMode;
  if ((FB[X86::Mode32Bit]))
    Features |= Feature_In32BitMode;
  return Features;
}

static const char *const MnemonicTable =
    "\003aaa\003aad\003aam\003aas\003adc\004adcb\004adcl\004adcq\004adcw\004"
    "adcx\005adcxl\005adcxq\003add\004addb\004addl\005addpd\005addps\004addq"
    "\005addsd\005addss\010addsubpd\010addsubps\004addw\004adox\005adoxl\005"
    "adoxq\006aesdec\naesdeclast\006aesenc\naesenclast\006aesimc\017aeskeyge"
    "nassist\003and\004andb\004andl\004andn\005andnl\006andnpd\006andnps\005"
    "andnq\005andpd\005andps\004andq\004andw\004arpl\005bextr\006bextrl\006b"
    "extrq\007blcfill\004blci\005blcic\006blcmsk\004blcs\007blendpd\007blend"
    "ps\010blendvpd\010blendvps\007blsfill\004blsi\005blsic\005blsil\005blsi"
    "q\006blsmsk\007blsmskl\007blsmskq\004blsr\005blsrl\005blsrq\005bndcl\005"
    "bndcn\005bndcu\006bndldx\005bndmk\006bndmov\006bndstx\005bound\003bsf\004"
    "bsfl\004bsfq\004bsfw\003bsr\004bsrl\004bsrq\004bsrw\005bswap\006bswapl\006"
    "bswapq\002bt\003btc\004btcl\004btcq\004btcw\003btl\003btq\003btr\004btr"
    "l\004btrq\004btrw\003bts\004btsl\004btsq\004btsw\003btw\004bzhi\005bzhi"
    "l\005bzhiq\004call\005calll\005callq\005callw\004cbtw\003cbw\003cdq\004"
    "cdqe\004clac\003clc\003cld\007clflush\nclflushopt\004clgi\003cli\004clr"
    "b\004clrl\004clrq\004clrw\004cltd\004cltq\004clts\004clwb\003cmc\005cmo"
    "va\006cmovae\007cmovael\007cmovaeq\007cmovaew\006cmoval\006cmovaq\006cm"
    "ovaw\005cmovb\006cmovbe\007cmovbel\007cmovbeq\007cmovbew\006cmovbl\006c"
    "movbq\006cmovbw\005cmove\006cmovel\006cmoveq\006cmovew\005cmovg\006cmov"
    "ge\007cmovgel\007cmovgeq\007cmovgew\006cmovgl\006cmovgq\006cmovgw\005cm"
    "ovl\006cmovle\007cmovlel\007cmovleq\007cmovlew\006cmovll\006cmovlq\006c"
    "movlw\006cmovne\007cmovnel\007cmovneq\007cmovnew\006cmovno\007cmovnol\007"
    "cmovnoq\007cmovnow\006cmovnp\007cmovnpl\007cmovnpq\007cmovnpw\006cmovns"
    "\007cmovnsl\007cmovnsq\007cmovnsw\005cmovo\006cmovol\006cmovoq\006cmovo"
    "w\005cmovp\006cmovpl\006cmovpq\006cmovpw\005cmovs\006cmovsl\006cmovsq\006"
    "cmovsw\003cmp\004cmpb\004cmpl\005cmppd\005cmpps\004cmpq\005cmpsb\005cmp"
    "sd\005cmpsl\005cmpsq\005cmpss\005cmpsw\004cmpw\007cmpxchg\ncmpxchg16b\t"
    "cmpxchg8b\010cmpxchgb\010cmpxchgl\010cmpxchgq\010cmpxchgw\006comisd\006"
    "comiss\005cpuid\003cqo\004cqto\005crc32\006crc32b\006crc32l\006crc32q\006"
    "crc32w\002cs\010cvtdq2pd\010cvtdq2ps\010cvtpd2dq\010cvtpd2pi\010cvtpd2p"
    "s\010cvtpi2pd\010cvtpi2ps\010cvtps2dq\010cvtps2pd\010cvtps2pi\010cvtsd2"
    "si\tcvtsd2sil\tcvtsd2siq\010cvtsd2ss\010cvtsi2sd\tcvtsi2sdl\tcvtsi2sdq\010"
    "cvtsi2ss\tcvtsi2ssl\tcvtsi2ssq\010cvtss2sd\010cvtss2si\tcvtss2sil\tcvts"
    "s2siq\tcvttpd2dq\tcvttpd2pi\tcvttps2dq\tcvttps2pi\tcvttsd2si\ncvttsd2si"
    "l\ncvttsd2siq\tcvttss2si\ncvttss2sil\ncvttss2siq\003cwd\004cwde\004cwtd"
    "\004cwtl\003daa\003das\006data16\003dec\004decb\004decl\004decq\004decw"
    "\003div\004divb\004divl\005divpd\005divps\004divq\005divsd\005divss\004"
    "divw\004dppd\004dpps\002ds\004emms\005encls\005enclu\005enter\002es\tex"
    "tractps\005extrq\005f2xm1\004fabs\004fadd\005faddl\005faddp\005fadds\004"
    "fbld\005fbstp\004fchs\006fcmovb\007fcmovbe\006fcmove\007fcmovnb\010fcmo"
    "vnbe\007fcmovne\007fcmovnu\006fcmovu\004fcom\005fcomi\005fcoml\005fcomp"
    "\006fcompi\006fcompl\006fcompp\006fcomps\005fcoms\004fcos\007fdecstp\004"
    "fdiv\005fdivl\005fdivp\005fdivr\006fdivrl\006fdivrp\006fdivrs\005fdivs\005"
    "femms\005ffree\005fiadd\006fiaddl\006fiadds\005ficom\006ficoml\006ficom"
    "p\007ficompl\007ficomps\006ficoms\005fidiv\006fidivl\006fidivr\007fidiv"
    "rl\007fidivrs\006fidivs\004fild\005fildl\006fildll\005filds\005fimul\006"
    "fimull\006fimuls\007fincstp\004fist\005fistl\005fistp\006fistpl\007fist"
    "pll\006fistps\005fists\006fisttp\007fisttpl\010fisttpll\007fisttps\005f"
    "isub\006fisubl\006fisubr\007fisubrl\007fisubrs\006fisubs\003fld\004fld1"
    "\005fldcw\006fldenv\004fldl\006fldl2e\006fldl2t\006fldlg2\006fldln2\005"
    "fldpi\004flds\004fldt\004fldz\004fmul\005fmull\005fmulp\005fmuls\006fnc"
    "lex\006fninit\004fnop\006fnsave\006fnstcw\007fnstenv\006fnstsw\006fpata"
    "n\005fprem\006fprem1\005fptan\007frndint\006frstor\002fs\006fscale\004f"
    "sin\007fsincos\005fsqrt\003fst\004fstl\004fstp\005fstpl\005fstps\005fst"
    "pt\004fsts\004fsub\005fsubl\005fsubp\005fsubr\006fsubrl\006fsubrp\006fs"
    "ubrs\005fsubs\004ftst\005fucom\006fucomi\006fucomp\007fucompi\007fucomp"
    "p\004fxam\004fxch\007fxrstor\tfxrstor64\006fxsave\010fxsave64\007fxtrac"
    "t\005fyl2x\007fyl2xp1\006getsec\002gs\006haddpd\006haddps\003hlt\006hsu"
    "bpd\006hsubps\004idiv\005idivb\005idivl\005idivq\005idivw\004imul\005im"
    "ulb\005imull\005imulq\005imulw\002in\003inb\003inc\004incb\004incl\004i"
    "ncq\004incw\003inl\004insb\004insd\010insertps\007insertq\004insl\004in"
    "sw\003int\004int3\004into\004invd\006invept\006invlpg\007invlpga\007inv"
    "pcid\007invvpid\003inw\004iret\005iretd\005iretl\005iretq\005iretw\002j"
    "a\003jae\002jb\003jbe\004jcxz\002je\005jecxz\002jg\003jge\002jl\003jle\003"
    "jmp\004jmpl\004jmpq\004jmpw\003jne\003jno\003jnp\003jns\002jo\002jp\005"
    "jrcxz\002js\005kandb\005kandd\006kandnb\006kandnd\006kandnq\006kandnw\005"
    "kandq\005kandw\005kmovb\005kmovd\005kmovq\005kmovw\005knotb\005knotd\005"
    "knotq\005knotw\004korb\004kord\004korq\010kortestb\010kortestd\010korte"
    "stq\010kortestw\004korw\010kshiftlb\010kshiftld\010kshiftlq\010kshiftlw"
    "\010kshiftrb\010kshiftrd\010kshiftrq\010kshiftrw\010kunpckbw\006kxnorb\006"
    "kxnord\006kxnorq\006kxnorw\005kxorb\005kxord\005kxorq\005kxorw\004lahf\003"
    "lar\004larl\004larq\004larw\005lcall\006lcalll\006lcallq\006lcallw\005l"
    "ddqu\007ldmxcsr\003lds\004ldsl\004ldsw\003lea\004leal\004leaq\005leave\004"
    "leaw\003les\004lesl\004lesw\006lfence\003lfs\004lfsl\004lfsq\004lfsw\004"
    "lgdt\005lgdtl\005lgdtq\005lgdtw\003lgs\004lgsl\004lgsq\004lgsw\004lidt\005"
    "lidtl\005lidtq\005lidtw\004ljmp\005ljmpl\005ljmpq\005ljmpw\004lldt\005l"
    "ldtw\004lmsw\005lmsww\004lock\004lods\005lodsb\005lodsd\005lodsl\005lod"
    "sq\005lodsw\004loop\005loope\006loopne\005lretl\005lretq\005lretw\003ls"
    "l\004lsll\004lslq\004lslw\003lss\004lssl\004lssq\004lssw\003ltr\004ltrw"
    "\005lzcnt\006lzcntl\006lzcntq\006lzcntw\nmaskmovdqu\010maskmovq\005maxp"
    "d\005maxps\005maxsd\005maxss\006mfence\005minpd\005minps\005minsd\005mi"
    "nss\007monitor\007montmul\003mov\006movabs\007movabsb\007movabsl\007mov"
    "absq\007movabsw\006movapd\006movaps\004movb\005movbe\006movbel\006movbe"
    "q\006movbew\004movd\007movddup\007movdq2q\006movdqa\006movdqu\007movhlp"
    "s\006movhpd\006movhps\004movl\007movlhps\006movlpd\006movlps\010movmskp"
    "d\010movmskps\007movntdq\010movntdqa\006movnti\007movntil\007movntiq\007"
    "movntpd\007movntps\006movntq\007movntsd\007movntss\004movq\007movq2dq\005"
    "movsb\006movsbl\006movsbq\006movsbw\005movsd\010movshdup\005movsl\010mo"
    "vsldup\006movslq\005movsq\005movss\005movsw\006movswl\006movswq\005movs"
    "x\006movsxd\006movupd\006movups\004movw\006movzbl\006movzbq\006movzbw\006"
    "movzwl\006movzwq\005movzx\007mpsadbw\003mul\004mulb\004mull\005mulpd\005"
    "mulps\004mulq\005mulsd\005mulss\004mulw\004mulx\005mulxl\005mulxq\005mw"
    "ait\003neg\004negb\004negl\004negq\004negw\003nop\004nopl\004nopw\003no"
    "t\004notb\004notl\004notq\004notw\002or\003orb\003orl\004orpd\004orps\003"
    "orq\003orw\003out\004outb\004outl\005outsb\005outsd\005outsl\005outsw\004"
    "outw\005pabsb\005pabsd\005pabsw\010packssdw\010packsswb\010packusdw\010"
    "packuswb\005paddb\005paddd\005paddq\006paddsb\006paddsw\007paddusb\007p"
    "addusw\005paddw\007palignr\004pand\005pandn\005pause\005pavgb\007pavgus"
    "b\005pavgw\010pblendvb\007pblendw\014pclmulhqhqdq\014pclmulhqlqdq\014pc"
    "lmullqhqdq\014pclmullqlqdq\tpclmulqdq\007pcmpeqb\007pcmpeqd\007pcmpeqq\007"
    "pcmpeqw\tpcmpestri\tpcmpestrm\007pcmpgtb\007pcmpgtd\007pcmpgtq\007pcmpg"
    "tw\tpcmpistri\tpcmpistrm\007pcommit\004pdep\005pdepl\005pdepq\004pext\005"
    "pextl\005pextq\006pextrb\006pextrd\006pextrq\006pextrw\005pf2id\005pf2i"
    "w\005pfacc\005pfadd\007pfcmpeq\007pfcmpge\007pfcmpgt\005pfmax\005pfmin\005"
    "pfmul\006pfnacc\007pfpnacc\005pfrcp\010pfrcpit1\010pfrcpit2\010pfrsqit1"
    "\007pfrsqrt\005pfsub\006pfsubr\006phaddd\007phaddsw\006phaddw\nphminpos"
    "uw\006phsubd\007phsubsw\006phsubw\005pi2fd\005pi2fw\006pinsrb\006pinsrd"
    "\006pinsrq\006pinsrw\tpmaddubsw\007pmaddwd\006pmaxsb\006pmaxsd\006pmaxs"
    "w\006pmaxub\006pmaxud\006pmaxuw\006pminsb\006pminsd\006pminsw\006pminub"
    "\006pminud\006pminuw\010pmovmskb\010pmovsxbd\010pmovsxbq\010pmovsxbw\010"
    "pmovsxdq\010pmovsxwd\010pmovsxwq\010pmovzxbd\010pmovzxbq\010pmovzxbw\010"
    "pmovzxdq\010pmovzxwd\010pmovzxwq\006pmuldq\010pmulhrsw\007pmulhrw\007pm"
    "ulhuw\006pmulhw\006pmulld\006pmullw\007pmuludq\003pop\005popal\005popaw"
    "\006popcnt\007popcntl\007popcntq\007popcntw\004popf\005popfd\005popfl\005"
    "popfq\005popfw\004popl\004popq\004popw\003por\010prefetch\013prefetchnt"
    "a\nprefetcht0\nprefetcht1\nprefetcht2\tprefetchw\006psadbw\006pshufb\006"
    "pshufd\007pshufhw\007pshuflw\006pshufw\006psignb\006psignd\006psignw\005"
    "pslld\006pslldq\005psllq\005psllw\005psrad\005psraw\005psrld\006psrldq\005"
    "psrlq\005psrlw\005psubb\005psubd\005psubq\006psubsb\006psubsw\007psubus"
    "b\007psubusw\005psubw\006pswapd\005ptest\tpunpckhbw\tpunpckhdq\npunpckh"
    "qdq\tpunpckhwd\tpunpcklbw\tpunpckldq\npunpcklqdq\tpunpcklwd\004push\006"
    "pushal\006pushaw\005pushf\006pushfd\006pushfl\006pushfq\006pushfw\005pu"
    "shl\005pushq\005pushw\004pxor\003rcl\004rclb\004rcll\004rclq\004rclw\005"
    "rcpps\005rcpss\003rcr\004rcrb\004rcrl\004rcrq\004rcrw\010rdfsbase\trdfs"
    "basel\trdfsbaseq\010rdgsbase\trdgsbasel\trdgsbaseq\005rdmsr\005rdpmc\006"
    "rdrand\007rdrandl\007rdrandq\007rdrandw\006rdseed\007rdseedl\007rdseedq"
    "\007rdseedw\005rdtsc\006rdtscp\003rep\005repne\003ret\004retf\005retfq\004"
    "retl\004retq\004retw\005rex64\003rol\004rolb\004roll\004rolq\004rolw\003"
    "ror\004rorb\004rorl\004rorq\004rorw\004rorx\005rorxl\005rorxq\007roundp"
    "d\007roundps\007roundsd\007roundss\003rsm\007rsqrtps\007rsqrtss\004sahf"
    "\003sar\004sarb\004sarl\004sarq\004sarw\004sarx\005sarxl\005sarxq\003sb"
    "b\004sbbb\004sbbl\004sbbq\004sbbw\004scas\005scasb\005scasd\005scasl\005"
    "scasq\005scasw\004seta\005setae\004setb\005setbe\004sete\004setg\005set"
    "ge\004setl\005setle\005setne\005setno\005setnp\005setns\004seto\004setp"
    "\004sets\006sfence\004sgdt\005sgdtl\005sgdtq\005sgdtw\010sha1msg1\010sh"
    "a1msg2\tsha1nexte\tsha1rnds4\nsha256msg1\nsha256msg2\013sha256rnds2\003"
    "shl\004shlb\004shld\005shldl\005shldq\005shldw\004shll\004shlq\004shlw\004"
    "shlx\005shlxl\005shlxq\003shr\004shrb\004shrd\005shrdl\005shrdq\005shrd"
    "w\004shrl\004shrq\004shrw\004shrx\005shrxl\005shrxq\006shufpd\006shufps"
    "\004sidt\005sidtl\005sidtq\005sidtw\006skinit\004sldt\005sldtl\005sldtq"
    "\005sldtw\004smsw\005smswl\005smswq\005smsww\006sqrtpd\006sqrtps\006sqr"
    "tsd\006sqrtss\002ss\004stac\003stc\003std\004stgi\003sti\007stmxcsr\004"
    "stos\005stosb\005stosd\005stosl\005stosq\005stosw\003str\004strl\004str"
    "q\004strw\003sub\004subb\004subl\005subpd\005subps\004subq\005subsd\005"
    "subss\004subw\006swapgs\007syscall\010sysenter\007sysexit\010sysexitl\010"
    "sysexitq\006sysret\007sysretl\007sysretq\006t1mskc\004test\005testb\005"
    "testl\005testq\005testw\005tzcnt\006tzcntl\006tzcntq\006tzcntw\005tzmsk"
    "\007ucomisd\007ucomiss\003ud2\004ud2b\010unpckhpd\010unpckhps\010unpckl"
    "pd\010unpcklps\006vaddpd\006vaddps\006vaddsd\006vaddss\tvaddsubpd\tvadd"
    "subps\007vaesdec\013vaesdeclast\007vaesenc\013vaesenclast\007vaesimc\020"
    "vaeskeygenassist\007valignd\007valignq\007vandnpd\007vandnps\006vandpd\006"
    "vandps\tvblendmpd\tvblendmps\010vblendpd\010vblendps\tvblendvpd\tvblend"
    "vps\016vbroadcastf128\017vbroadcastf32x4\017vbroadcastf32x8\017vbroadca"
    "stf64x2\017vbroadcastf64x4\016vbroadcasti128\017vbroadcasti32x4\017vbro"
    "adcasti32x8\017vbroadcasti64x2\017vbroadcasti64x4\014vbroadcastsd\014vb"
    "roadcastss\004vcmp\006vcmppd\006vcmpps\006vcmpsd\006vcmpss\007vcomisd\007"
    "vcomiss\013vcompresspd\013vcompressps\tvcvtdq2pd\tvcvtdq2ps\tvcvtpd2dq\n"
    "vcvtpd2dqx\nvcvtpd2dqy\tvcvtpd2ps\nvcvtpd2psx\nvcvtpd2psy\tvcvtpd2qq\nv"
    "cvtpd2udq\013vcvtpd2udqx\013vcvtpd2udqy\nvcvtpd2uqq\tvcvtph2ps\tvcvtps2"
    "dq\tvcvtps2pd\tvcvtps2ph\tvcvtps2qq\nvcvtps2udq\nvcvtps2uqq\tvcvtqq2pd\t"
    "vcvtqq2ps\nvcvtqq2psx\nvcvtqq2psy\tvcvtsd2si\nvcvtsd2sil\nvcvtsd2siq\tv"
    "cvtsd2ss\nvcvtsd2usi\tvcvtsi2sd\nvcvtsi2sdl\nvcvtsi2sdq\tvcvtsi2ss\nvcv"
    "tsi2ssl\nvcvtsi2ssq\tvcvtss2sd\tvcvtss2si\nvcvtss2sil\nvcvtss2siq\nvcvt"
    "ss2usi\nvcvttpd2dq\013vcvttpd2dqx\013vcvttpd2dqy\nvcvttpd2qq\013vcvttpd"
    "2udq\014vcvttpd2udqx\014vcvttpd2udqy\013vcvttpd2uqq\nvcvttps2dq\nvcvttp"
    "s2qq\013vcvttps2udq\013vcvttps2uqq\nvcvttsd2si\013vcvttsd2sil\013vcvtts"
    "d2siq\013vcvttsd2usi\nvcvttss2si\013vcvttss2sil\013vcvttss2siq\013vcvtt"
    "ss2usi\nvcvtudq2pd\nvcvtudq2ps\nvcvtuqq2pd\nvcvtuqq2ps\013vcvtuqq2psx\013"
    "vcvtuqq2psy\nvcvtusi2sd\013vcvtusi2sdl\013vcvtusi2sdq\nvcvtusi2ss\013vc"
    "vtusi2ssl\013vcvtusi2ssq\006vdivpd\006vdivps\006vdivsd\006vdivss\005vdp"
    "pd\005vdpps\004verr\004verw\007vexp2pd\007vexp2ps\tvexpandpd\tvexpandps"
    "\014vextractf128\015vextractf32x4\015vextractf64x4\014vextracti128\015v"
    "extracti32x4\015vextracti64x4\nvextractps\013vfixupimmpd\013vfixupimmps"
    "\013vfixupimmsd\013vfixupimmss\013vfmadd132pd\013vfmadd132ps\013vfmadd1"
    "32sd\013vfmadd132ss\013vfmadd213pd\013vfmadd213ps\013vfmadd213sd\013vfm"
    "add213ss\013vfmadd231pd\013vfmadd231ps\013vfmadd231sd\013vfmadd231ss\010"
    "vfmaddpd\010vfmaddps\010vfmaddsd\010vfmaddss\016vfmaddsub132pd\016vfmad"
    "dsub132ps\016vfmaddsub213pd\016vfmaddsub213ps\016vfmaddsub231pd\016vfma"
    "ddsub231ps\013vfmaddsubpd\013vfmaddsubps\013vfmsub132pd\013vfmsub132ps\013"
    "vfmsub132sd\013vfmsub132ss\013vfmsub213pd\013vfmsub213ps\013vfmsub213sd"
    "\013vfmsub213ss\013vfmsub231pd\013vfmsub231ps\013vfmsub231sd\013vfmsub2"
    "31ss\016vfmsubadd132pd\016vfmsubadd132ps\016vfmsubadd213pd\016vfmsubadd"
    "213ps\016vfmsubadd231pd\016vfmsubadd231ps\013vfmsubaddpd\013vfmsubaddps"
    "\010vfmsubpd\010vfmsubps\010vfmsubsd\010vfmsubss\014vfnmadd132pd\014vfn"
    "madd132ps\014vfnmadd132sd\014vfnmadd132ss\014vfnmadd213pd\014vfnmadd213"
    "ps\014vfnmadd213sd\014vfnmadd213ss\014vfnmadd231pd\014vfnmadd231ps\014v"
    "fnmadd231sd\014vfnmadd231ss\tvfnmaddpd\tvfnmaddps\tvfnmaddsd\tvfnmaddss"
    "\014vfnmsub132pd\014vfnmsub132ps\014vfnmsub132sd\014vfnmsub132ss\014vfn"
    "msub213pd\014vfnmsub213ps\014vfnmsub213sd\014vfnmsub213ss\014vfnmsub231"
    "pd\014vfnmsub231ps\014vfnmsub231sd\014vfnmsub231ss\tvfnmsubpd\tvfnmsubp"
    "s\tvfnmsubsd\tvfnmsubss\007vfrczpd\007vfrczps\007vfrczsd\007vfrczss\nvg"
    "atherdpd\nvgatherdps\015vgatherpf0dpd\015vgatherpf0dps\015vgatherpf0qpd"
    "\015vgatherpf0qps\015vgatherpf1dpd\015vgatherpf1dps\015vgatherpf1qpd\015"
    "vgatherpf1qps\nvgatherqpd\nvgatherqps\tvgetexppd\tvgetexpps\007vhaddpd\007"
    "vhaddps\007vhsubpd\007vhsubps\013vinsertf128\014vinsertf32x4\014vinsert"
    "f32x8\014vinsertf64x2\014vinsertf64x4\013vinserti128\014vinserti32x4\014"
    "vinserti32x8\014vinserti64x2\014vinserti64x4\tvinsertps\006vlddqu\010vl"
    "dmxcsr\013vmaskmovdqu\nvmaskmovpd\nvmaskmovps\006vmaxpd\006vmaxps\006vm"
    "axsd\006vmaxss\006vmcall\007vmclear\006vmfunc\006vminpd\006vminps\006vm"
    "insd\006vminss\010vmlaunch\006vmload\007vmmcall\007vmovapd\007vmovaps\005"
    "vmovd\010vmovddup\007vmovdqa\tvmovdqa32\tvmovdqa64\007vmovdqu\tvmovdqu1"
    "6\tvmovdqu32\tvmovdqu64\010vmovdqu8\010vmovhlps\007vmovhpd\007vmovhps\010"
    "vmovlhps\007vmovlpd\007vmovlps\tvmovmskpd\tvmovmskps\010vmovntdq\tvmovn"
    "tdqa\010vmovntpd\010vmovntps\005vmovq\006vmovsd\tvmovshdup\tvmovsldup\006"
    "vmovss\007vmovupd\007vmovups\010vmpsadbw\007vmptrld\007vmptrst\006vmrea"
    "d\007vmreadl\007vmreadq\010vmresume\005vmrun\006vmsave\006vmulpd\006vmu"
    "lps\006vmulsd\006vmulss\007vmwrite\010vmwritel\010vmwriteq\006vmxoff\005"
    "vmxon\005vorpd\005vorps\006vpabsb\006vpabsd\006vpabsq\006vpabsw\tvpacks"
    "sdw\tvpacksswb\tvpackusdw\tvpackuswb\006vpaddb\006vpaddd\006vpaddq\007v"
    "paddsb\007vpaddsw\010vpaddusb\010vpaddusw\006vpaddw\010vpalignr\005vpan"
    "d\006vpandd\006vpandn\007vpandnd\007vpandnq\006vpandq\006vpavgb\006vpav"
    "gw\010vpblendd\tvpblendmb\tvpblendmd\tvpblendmq\tvpblendmw\tvpblendvb\010"
    "vpblendw\014vpbroadcastb\014vpbroadcastd\017vpbroadcastmb2q\017vpbroadc"
    "astmw2d\014vpbroadcastq\014vpbroadcastw\015vpclmulhqhqdq\015vpclmulhqlq"
    "dq\015vpclmullqhqdq\015vpclmullqlqdq\nvpclmulqdq\006vpcmov\005vpcmp\006"
    "vpcmpb\006vpcmpd\010vpcmpeqb\010vpcmpeqd\010vpcmpeqq\010vpcmpeqw\nvpcmp"
    "estri\nvpcmpestrm\010vpcmpgtb\010vpcmpgtd\010vpcmpgtq\010vpcmpgtw\nvpcm"
    "pistri\nvpcmpistrm\006vpcmpq\007vpcmpub\007vpcmpud\007vpcmpuq\007vpcmpu"
    "w\006vpcmpw\005vpcom\006vpcomb\006vpcomd\013vpcompressd\013vpcompressq\006"
    "vpcomq\007vpcomub\007vpcomud\007vpcomuq\007vpcomuw\006vpcomw\013vpconfl"
    "ictd\013vpconflictq\nvperm2f128\nvperm2i128\006vpermd\010vpermi2d\tvper"
    "mi2pd\tvpermi2ps\010vpermi2q\010vpermi2w\nvpermil2pd\nvpermil2ps\tvperm"
    "ilpd\tvpermilps\007vpermpd\007vpermps\006vpermq\010vpermt2d\tvpermt2pd\t"
    "vpermt2ps\010vpermt2q\010vpermt2w\006vpermw\tvpexpandd\tvpexpandq\007vp"
    "extrb\007vpextrd\007vpextrq\007vpextrw\nvpgatherdd\nvpgatherdq\nvpgathe"
    "rqd\nvpgatherqq\010vphaddbd\010vphaddbq\010vphaddbw\007vphaddd\010vphad"
    "ddq\010vphaddsw\tvphaddubd\tvphaddubq\tvphaddubw\tvphaddudq\tvphadduwd\t"
    "vphadduwq\007vphaddw\010vphaddwd\010vphaddwq\013vphminposuw\010vphsubbw"
    "\007vphsubd\010vphsubdq\010vphsubsw\007vphsubw\010vphsubwd\007vpinsrb\007"
    "vpinsrd\007vpinsrq\007vpinsrw\010vplzcntd\010vplzcntq\010vpmacsdd\tvpma"
    "csdqh\tvpmacsdql\tvpmacssdd\nvpmacssdqh\nvpmacssdql\tvpmacsswd\tvpmacss"
    "ww\010vpmacswd\010vpmacsww\nvpmadcsswd\tvpmadcswd\nvpmaddubsw\010vpmadd"
    "wd\nvpmaskmovd\nvpmaskmovq\007vpmaxsb\007vpmaxsd\007vpmaxsq\007vpmaxsw\007"
    "vpmaxub\007vpmaxud\007vpmaxuq\007vpmaxuw\007vpminsb\007vpminsd\007vpmin"
    "sq\007vpminsw\007vpminub\007vpminud\007vpminuq\007vpminuw\010vpmovb2m\010"
    "vpmovd2m\007vpmovdb\007vpmovdw\010vpmovm2b\010vpmovm2d\010vpmovm2q\010v"
    "pmovm2w\tvpmovmskb\010vpmovq2m\007vpmovqb\007vpmovqd\007vpmovqw\010vpmo"
    "vsdb\010vpmovsdw\010vpmovsqb\010vpmovsqd\010vpmovsqw\tvpmovsxbd\tvpmovs"
    "xbq\tvpmovsxbw\tvpmovsxdq\tvpmovsxwd\tvpmovsxwq\tvpmovusdb\tvpmovusdw\t"
    "vpmovusqb\tvpmovusqd\tvpmovusqw\010vpmovw2m\tvpmovzxbd\tvpmovzxbq\tvpmo"
    "vzxbw\tvpmovzxdq\tvpmovzxwd\tvpmovzxwq\007vpmuldq\tvpmulhrsw\010vpmulhu"
    "w\007vpmulhw\007vpmulld\007vpmullq\007vpmullw\010vpmuludq\004vpor\005vp"
    "ord\005vporq\006vpperm\006vprold\006vprolq\007vprolvd\007vprolvq\006vpr"
    "ord\006vprorq\007vprorvd\007vprorvq\006vprotb\006vprotd\006vprotq\006vp"
    "rotw\007vpsadbw\013vpscatterdd\013vpscatterdq\013vpscatterqd\013vpscatt"
    "erqq\006vpshab\006vpshad\006vpshaq\006vpshaw\006vpshlb\006vpshld\006vps"
    "hlq\006vpshlw\007vpshufb\007vpshufd\010vpshufhw\010vpshuflw\007vpsignb\007"
    "vpsignd\007vpsignw\006vpslld\007vpslldq\006vpsllq\007vpsllvd\007vpsllvq"
    "\007vpsllvw\006vpsllw\006vpsrad\006vpsraq\007vpsravd\007vpsravq\007vpsr"
    "avw\006vpsraw\006vpsrld\007vpsrldq\006vpsrlq\007vpsrlvd\007vpsrlvq\007v"
    "psrlvw\006vpsrlw\006vpsubb\006vpsubd\006vpsubq\007vpsubsb\007vpsubsw\010"
    "vpsubusb\010vpsubusw\006vpsubw\006vptest\010vptestmb\010vptestmd\010vpt"
    "estmq\010vptestmw\tvptestnmb\tvptestnmd\tvptestnmq\tvptestnmw\nvpunpckh"
    "bw\nvpunpckhdq\013vpunpckhqdq\nvpunpckhwd\nvpunpcklbw\nvpunpckldq\013vp"
    "unpcklqdq\nvpunpcklwd\005vpxor\006vpxord\006vpxorq\010vrangepd\010vrang"
    "eps\010vrangesd\010vrangess\010vrcp14pd\010vrcp14ps\010vrcp14sd\010vrcp"
    "14ss\010vrcp28pd\010vrcp28ps\010vrcp28sd\010vrcp28ss\006vrcpps\006vrcps"
    "s\013vrndscalepd\013vrndscaleps\013vrndscalesd\013vrndscaless\010vround"
    "pd\010vroundps\010vroundsd\010vroundss\nvrsqrt14pd\nvrsqrt14ps\nvrsqrt1"
    "4sd\nvrsqrt14ss\nvrsqrt28pd\nvrsqrt28ps\nvrsqrt28sd\nvrsqrt28ss\010vrsq"
    "rtps\010vrsqrtss\tvscalefpd\tvscalefps\013vscatterdpd\013vscatterdps\016"
    "vscatterpf0dpd\016vscatterpf0dps\016vscatterpf0qpd\016vscatterpf0qps\016"
    "vscatterpf1dpd\016vscatterpf1dps\016vscatterpf1qpd\016vscatterpf1qps\013"
    "vscatterqpd\013vscatterqps\nvshuff32x4\nvshuff64x2\nvshufi32x4\nvshufi6"
    "4x2\007vshufpd\007vshufps\007vsqrtpd\007vsqrtps\007vsqrtsd\007vsqrtss\010"
    "vstmxcsr\006vsubpd\006vsubps\006vsubsd\006vsubss\007vtestpd\007vtestps\010"
    "vucomisd\010vucomiss\tvunpckhpd\tvunpckhps\tvunpcklpd\tvunpcklps\006vxo"
    "rpd\006vxorps\010vzeroall\nvzeroupper\004wait\006wbinvd\010wrfsbase\twr"
    "fsbasel\twrfsbaseq\010wrgsbase\twrgsbasel\twrgsbaseq\005wrmsr\006xabort"
    "\010xacquire\004xadd\005xaddb\005xaddl\005xaddq\005xaddw\006xbegin\004x"
    "chg\005xchgb\005xchgl\005xchgq\005xchgw\txcryptcbc\txcryptcfb\txcryptct"
    "r\txcryptecb\txcryptofb\004xend\006xgetbv\005xlatb\003xor\004xorb\004xo"
    "rl\005xorpd\005xorps\004xorq\004xorw\010xrelease\006xrstor\010xrstor64\007"
    "xrstors\txrstors64\005xsave\007xsave64\006xsavec\010xsavec64\010xsaveop"
    "t\nxsaveopt64\006xsaves\010xsaves64\006xsetbv\005xsha1\007xsha256\006xs"
    "tore\txstorerng\005xtest";

namespace {
  struct MatchEntry {
    uint16_t Mnemonic;
    uint16_t Opcode;
    uint16_t ConvertFn;
    uint16_t RequiredFeatures;
    uint8_t Classes[9];
    StringRef getMnemonic() const {
      return StringRef(MnemonicTable + Mnemonic + 1,
                       MnemonicTable[Mnemonic]);
    }
  };

  // Predicate for searching for an opcode.
  struct LessOpcode {
    bool operator()(const MatchEntry &LHS, StringRef RHS) {
      return LHS.getMnemonic() < RHS;
    }
    bool operator()(StringRef LHS, const MatchEntry &RHS) {
      return LHS < RHS.getMnemonic();
    }
    bool operator()(const MatchEntry &LHS, const MatchEntry &RHS) {
      return LHS.getMnemonic() < RHS.getMnemonic();
    }
  };
} // end anonymous namespace.

static const MatchEntry MatchTable0[] = {
  { 0 /* aaa */, X86::AAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__imm_95_10, 0, {  }, },
  { 4 /* aad */, X86::AAD8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 8 /* aam */, X86::AAM8i8, Convert__imm_95_10, 0, {  }, },
  { 8 /* aam */, X86::AAM8i8, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 12 /* aas */, X86::AAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 20 /* adcb */, X86::ADC8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 20 /* adcb */, X86::ADC8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 20 /* adcb */, X86::ADC8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 20 /* adcb */, X86::ADC8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 25 /* adcl */, X86::ADC32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 25 /* adcl */, X86::ADC32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 25 /* adcl */, X86::ADC32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 25 /* adcl */, X86::ADC32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 30 /* adcq */, X86::ADC64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 30 /* adcq */, X86::ADC64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 30 /* adcq */, X86::ADC64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 30 /* adcq */, X86::ADC64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 35 /* adcw */, X86::ADC16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 35 /* adcw */, X86::ADC16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 35 /* adcw */, X86::ADC16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 35 /* adcw */, X86::ADC16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 45 /* adcxl */, X86::ADCX32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 45 /* adcxl */, X86::ADCX32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 51 /* adcxq */, X86::ADCX64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 51 /* adcxq */, X86::ADCX64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 61 /* addb */, X86::ADD8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 61 /* addb */, X86::ADD8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 61 /* addb */, X86::ADD8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 61 /* addb */, X86::ADD8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 66 /* addl */, X86::ADD32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 66 /* addl */, X86::ADD32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 66 /* addl */, X86::ADD32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 66 /* addl */, X86::ADD32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 71 /* addpd */, X86::ADDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 71 /* addpd */, X86::ADDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 77 /* addps */, X86::ADDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 83 /* addq */, X86::ADD64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 83 /* addq */, X86::ADD64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 83 /* addq */, X86::ADD64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 83 /* addq */, X86::ADD64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 88 /* addsd */, X86::ADDSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 88 /* addsd */, X86::ADDSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 94 /* addss */, X86::ADDSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 100 /* addsubpd */, X86::ADDSUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 109 /* addsubps */, X86::ADDSUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 118 /* addw */, X86::ADD16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 118 /* addw */, X86::ADD16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 118 /* addw */, X86::ADD16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 118 /* addw */, X86::ADD16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 128 /* adoxl */, X86::ADOX32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 128 /* adoxl */, X86::ADOX32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 134 /* adoxq */, X86::ADOX64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 134 /* adoxq */, X86::ADOX64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 140 /* aesdec */, X86::AESDECrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 140 /* aesdec */, X86::AESDECrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 147 /* aesdeclast */, X86::AESDECLASTrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 158 /* aesenc */, X86::AESENCrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 165 /* aesenclast */, X86::AESENCLASTrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 176 /* aesimc */, X86::AESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 183 /* aeskeygenassist */, X86::AESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 203 /* andb */, X86::AND8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 203 /* andb */, X86::AND8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 203 /* andb */, X86::AND8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 203 /* andb */, X86::AND8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 208 /* andl */, X86::AND32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 208 /* andl */, X86::AND32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 208 /* andl */, X86::AND32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 208 /* andl */, X86::AND32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 218 /* andnl */, X86::ANDN32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 224 /* andnpd */, X86::ANDNPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 231 /* andnps */, X86::ANDNPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 238 /* andnq */, X86::ANDN64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 238 /* andnq */, X86::ANDN64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 244 /* andpd */, X86::ANDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 244 /* andpd */, X86::ANDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 250 /* andps */, X86::ANDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 256 /* andq */, X86::AND64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 256 /* andq */, X86::AND64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 256 /* andq */, X86::AND64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 256 /* andq */, X86::AND64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 261 /* andw */, X86::AND16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 261 /* andw */, X86::AND16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 261 /* andw */, X86::AND16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 261 /* andw */, X86::AND16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_GR16 }, },
  { 266 /* arpl */, X86::ARPL16mr, Convert__Mem165_1__Reg1_0, Feature_Not64BitMode, { MCK_GR16, MCK_Mem16 }, },
  { 271 /* bextr */, X86::BEXTRI64ri, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI64mi, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 271 /* bextr */, X86::BEXTRI32ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 271 /* bextr */, X86::BEXTRI32mi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTR32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 277 /* bextrl */, X86::BEXTR32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 284 /* bextrq */, X86::BEXTR64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 284 /* bextrq */, X86::BEXTR64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 291 /* blcfill */, X86::BLCFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 291 /* blcfill */, X86::BLCFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 291 /* blcfill */, X86::BLCFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 291 /* blcfill */, X86::BLCFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 299 /* blci */, X86::BLCI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 299 /* blci */, X86::BLCI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 299 /* blci */, X86::BLCI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 299 /* blci */, X86::BLCI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 304 /* blcic */, X86::BLCIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 304 /* blcic */, X86::BLCIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 304 /* blcic */, X86::BLCIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 304 /* blcic */, X86::BLCIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 310 /* blcmsk */, X86::BLCMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 310 /* blcmsk */, X86::BLCMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 317 /* blcs */, X86::BLCS32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 317 /* blcs */, X86::BLCS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 317 /* blcs */, X86::BLCS32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 317 /* blcs */, X86::BLCS64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 322 /* blendpd */, X86::BLENDPDrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 322 /* blendpd */, X86::BLENDPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 330 /* blendps */, X86::BLENDPSrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 330 /* blendps */, X86::BLENDPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 338 /* blendvpd */, X86::BLENDVPDrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 347 /* blendvps */, X86::BLENDVPSrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 356 /* blsfill */, X86::BLSFILL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 356 /* blsfill */, X86::BLSFILL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 356 /* blsfill */, X86::BLSFILL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 356 /* blsfill */, X86::BLSFILL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 369 /* blsic */, X86::BLSIC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 369 /* blsic */, X86::BLSIC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 369 /* blsic */, X86::BLSIC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 369 /* blsic */, X86::BLSIC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 375 /* blsil */, X86::BLSI32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 375 /* blsil */, X86::BLSI32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 381 /* blsiq */, X86::BLSI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 381 /* blsiq */, X86::BLSI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 394 /* blsmskl */, X86::BLSMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 394 /* blsmskl */, X86::BLSMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 402 /* blsmskq */, X86::BLSMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 402 /* blsmskq */, X86::BLSMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 415 /* blsrl */, X86::BLSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 415 /* blsrl */, X86::BLSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 421 /* blsrq */, X86::BLSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 421 /* blsrq */, X86::BLSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 427 /* bndcl */, X86::BNDCL32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 427 /* bndcl */, X86::BNDCL64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 427 /* bndcl */, X86::BNDCL32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_BNDR }, },
  { 427 /* bndcl */, X86::BNDCL64rm, Convert__Reg1_1__Mem645_0, Feature_In64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 433 /* bndcn */, X86::BNDCN32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 433 /* bndcn */, X86::BNDCN64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 433 /* bndcn */, X86::BNDCN32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_BNDR }, },
  { 433 /* bndcn */, X86::BNDCN64rm, Convert__Reg1_1__Mem645_0, Feature_In64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 439 /* bndcu */, X86::BNDCU32rr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_BNDR }, },
  { 439 /* bndcu */, X86::BNDCU64rr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_BNDR }, },
  { 439 /* bndcu */, X86::BNDCU32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_BNDR }, },
  { 439 /* bndcu */, X86::BNDCU64rm, Convert__Reg1_1__Mem645_0, Feature_In64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 445 /* bndldx */, X86::BNDLDXrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_BNDR }, },
  { 452 /* bndmk */, X86::BNDMK32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_BNDR }, },
  { 452 /* bndmk */, X86::BNDMK64rm, Convert__Reg1_1__Mem645_0, Feature_In64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 458 /* bndmov */, X86::BNDMOVMRrr, Convert__Reg1_1__Reg1_0, 0, { MCK_BNDR, MCK_BNDR }, },
  { 458 /* bndmov */, X86::BNDMOVRMrr, Convert__Reg1_1__Reg1_0, 0, { MCK_BNDR, MCK_BNDR }, },
  { 458 /* bndmov */, X86::BNDMOVMR64mr, Convert__Mem1285_1__Reg1_0, Feature_In64BitMode, { MCK_BNDR, MCK_Mem128 }, },
  { 458 /* bndmov */, X86::BNDMOVMR32mr, Convert__Mem645_1__Reg1_0, Feature_Not64BitMode, { MCK_BNDR, MCK_Mem64 }, },
  { 458 /* bndmov */, X86::BNDMOVRM64rm, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_BNDR }, },
  { 458 /* bndmov */, X86::BNDMOVRM32rm, Convert__Reg1_1__Mem645_0, Feature_Not64BitMode, { MCK_Mem64, MCK_BNDR }, },
  { 465 /* bndstx */, X86::BNDSTXmr, Convert__Mem645_1__Reg1_0, 0, { MCK_BNDR, MCK_Mem64 }, },
  { 472 /* bound */, X86::BOUNDS16rm, Convert__Reg1_1__Mem165_0, Feature_Not64BitMode, { MCK_Mem16, MCK_GR16 }, },
  { 472 /* bound */, X86::BOUNDS32rm, Convert__Reg1_1__Mem325_0, Feature_Not64BitMode, { MCK_Mem32, MCK_GR32 }, },
  { 482 /* bsfl */, X86::BSF32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 482 /* bsfl */, X86::BSF32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 487 /* bsfq */, X86::BSF64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 487 /* bsfq */, X86::BSF64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 492 /* bsfw */, X86::BSF16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 492 /* bsfw */, X86::BSF16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 501 /* bsrl */, X86::BSR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 501 /* bsrl */, X86::BSR32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 506 /* bsrq */, X86::BSR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 506 /* bsrq */, X86::BSR64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 511 /* bsrw */, X86::BSR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 511 /* bsrw */, X86::BSR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 522 /* bswapl */, X86::BSWAP32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 529 /* bswapq */, X86::BSWAP64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 536 /* bt */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 539 /* btc */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 543 /* btcl */, X86::BTC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 543 /* btcl */, X86::BTC32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 543 /* btcl */, X86::BTC32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 543 /* btcl */, X86::BTC32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 548 /* btcq */, X86::BTC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 548 /* btcq */, X86::BTC64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 548 /* btcq */, X86::BTC64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 548 /* btcq */, X86::BTC64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 553 /* btcw */, X86::BTC16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 553 /* btcw */, X86::BTC16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 553 /* btcw */, X86::BTC16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 553 /* btcw */, X86::BTC16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 558 /* btl */, X86::BT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 558 /* btl */, X86::BT32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 558 /* btl */, X86::BT32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 558 /* btl */, X86::BT32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 562 /* btq */, X86::BT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 562 /* btq */, X86::BT64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 562 /* btq */, X86::BT64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 562 /* btq */, X86::BT64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 566 /* btr */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 570 /* btrl */, X86::BTR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 570 /* btrl */, X86::BTR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 570 /* btrl */, X86::BTR32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 570 /* btrl */, X86::BTR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 575 /* btrq */, X86::BTR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 575 /* btrq */, X86::BTR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 575 /* btrq */, X86::BTR64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 575 /* btrq */, X86::BTR64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 580 /* btrw */, X86::BTR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 580 /* btrw */, X86::BTR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 580 /* btrw */, X86::BTR16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 580 /* btrw */, X86::BTR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 585 /* bts */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 589 /* btsl */, X86::BTS32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 589 /* btsl */, X86::BTS32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 589 /* btsl */, X86::BTS32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 589 /* btsl */, X86::BTS32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 594 /* btsq */, X86::BTS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 594 /* btsq */, X86::BTS64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 594 /* btsq */, X86::BTS64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 594 /* btsq */, X86::BTS64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 599 /* btsw */, X86::BTS16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 599 /* btsw */, X86::BTS16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 599 /* btsw */, X86::BTS16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 599 /* btsw */, X86::BTS16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 604 /* btw */, X86::BT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 604 /* btw */, X86::BT16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 604 /* btw */, X86::BT16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 604 /* btw */, X86::BT16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 613 /* bzhil */, X86::BZHI32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 613 /* bzhil */, X86::BZHI32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 619 /* bzhiq */, X86::BZHI64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 619 /* bzhiq */, X86::BZHI64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 625 /* call */, X86::CALL16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 625 /* call */, X86::CALL32m, Convert__Mem325_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 625 /* call */, X86::CALL64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 625 /* call */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 625 /* call */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 630 /* calll */, X86::CALLpcrel32, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 630 /* calll */, X86::CALL32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 630 /* calll */, X86::CALL32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 630 /* calll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 636 /* callq */, X86::CALL64pcrel32, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 636 /* callq */, X86::CALL64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 636 /* callq */, X86::CALL64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 642 /* callw */, X86::CALLpcrel16, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 642 /* callw */, X86::CALL16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 642 /* callw */, X86::CALL16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 642 /* callw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 648 /* cbtw */, X86::CBW, Convert_NoOperands, 0, {  }, },
  { 666 /* clac */, X86::CLAC, Convert_NoOperands, 0, {  }, },
  { 671 /* clc */, X86::CLC, Convert_NoOperands, 0, {  }, },
  { 675 /* cld */, X86::CLD, Convert_NoOperands, 0, {  }, },
  { 679 /* clflush */, X86::CLFLUSH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 687 /* clflushopt */, X86::CLFLUSHOPT, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 698 /* clgi */, X86::CLGI, Convert_NoOperands, 0, {  }, },
  { 703 /* cli */, X86::CLI, Convert_NoOperands, 0, {  }, },
  { 707 /* clrb */, X86::XOR8rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR8 }, },
  { 712 /* clrl */, X86::XOR32rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR32 }, },
  { 717 /* clrq */, X86::XOR64rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR64 }, },
  { 722 /* clrw */, X86::XOR16rr, Convert__Reg1_0__Tie0__Reg1_0, 0, { MCK_GR16 }, },
  { 727 /* cltd */, X86::CDQ, Convert_NoOperands, 0, {  }, },
  { 732 /* cltq */, X86::CDQE, Convert_NoOperands, 0, {  }, },
  { 737 /* clts */, X86::CLTS, Convert_NoOperands, 0, {  }, },
  { 742 /* clwb */, X86::CLWB, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 747 /* cmc */, X86::CMC, Convert_NoOperands, 0, {  }, },
  { 764 /* cmovael */, X86::CMOVAE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 764 /* cmovael */, X86::CMOVAE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 772 /* cmovaeq */, X86::CMOVAE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 772 /* cmovaeq */, X86::CMOVAE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 780 /* cmovaew */, X86::CMOVAE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 780 /* cmovaew */, X86::CMOVAE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 788 /* cmoval */, X86::CMOVA32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 788 /* cmoval */, X86::CMOVA32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 795 /* cmovaq */, X86::CMOVA64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 795 /* cmovaq */, X86::CMOVA64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 802 /* cmovaw */, X86::CMOVA16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 802 /* cmovaw */, X86::CMOVA16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 822 /* cmovbel */, X86::CMOVBE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 822 /* cmovbel */, X86::CMOVBE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 830 /* cmovbeq */, X86::CMOVBE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 830 /* cmovbeq */, X86::CMOVBE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 838 /* cmovbew */, X86::CMOVBE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 838 /* cmovbew */, X86::CMOVBE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 846 /* cmovbl */, X86::CMOVB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 846 /* cmovbl */, X86::CMOVB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 853 /* cmovbq */, X86::CMOVB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 853 /* cmovbq */, X86::CMOVB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 860 /* cmovbw */, X86::CMOVB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 860 /* cmovbw */, X86::CMOVB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 873 /* cmovel */, X86::CMOVE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 873 /* cmovel */, X86::CMOVE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 880 /* cmoveq */, X86::CMOVE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 880 /* cmoveq */, X86::CMOVE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 887 /* cmovew */, X86::CMOVE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 887 /* cmovew */, X86::CMOVE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 907 /* cmovgel */, X86::CMOVGE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 907 /* cmovgel */, X86::CMOVGE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 915 /* cmovgeq */, X86::CMOVGE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 915 /* cmovgeq */, X86::CMOVGE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 923 /* cmovgew */, X86::CMOVGE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 923 /* cmovgew */, X86::CMOVGE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 931 /* cmovgl */, X86::CMOVG32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 931 /* cmovgl */, X86::CMOVG32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 938 /* cmovgq */, X86::CMOVG64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 938 /* cmovgq */, X86::CMOVG64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 945 /* cmovgw */, X86::CMOVG16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 945 /* cmovgw */, X86::CMOVG16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 965 /* cmovlel */, X86::CMOVLE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 965 /* cmovlel */, X86::CMOVLE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 973 /* cmovleq */, X86::CMOVLE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 973 /* cmovleq */, X86::CMOVLE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 981 /* cmovlew */, X86::CMOVLE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 981 /* cmovlew */, X86::CMOVLE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 989 /* cmovll */, X86::CMOVL32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 989 /* cmovll */, X86::CMOVL32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 996 /* cmovlq */, X86::CMOVL64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 996 /* cmovlq */, X86::CMOVL64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1003 /* cmovlw */, X86::CMOVL16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1003 /* cmovlw */, X86::CMOVL16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1017 /* cmovnel */, X86::CMOVNE32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1017 /* cmovnel */, X86::CMOVNE32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1025 /* cmovneq */, X86::CMOVNE64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1025 /* cmovneq */, X86::CMOVNE64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1033 /* cmovnew */, X86::CMOVNE16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1033 /* cmovnew */, X86::CMOVNE16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1048 /* cmovnol */, X86::CMOVNO32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1048 /* cmovnol */, X86::CMOVNO32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1056 /* cmovnoq */, X86::CMOVNO64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1056 /* cmovnoq */, X86::CMOVNO64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1064 /* cmovnow */, X86::CMOVNO16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1064 /* cmovnow */, X86::CMOVNO16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1079 /* cmovnpl */, X86::CMOVNP32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1079 /* cmovnpl */, X86::CMOVNP32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1087 /* cmovnpq */, X86::CMOVNP64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1087 /* cmovnpq */, X86::CMOVNP64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1095 /* cmovnpw */, X86::CMOVNP16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1095 /* cmovnpw */, X86::CMOVNP16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1110 /* cmovnsl */, X86::CMOVNS32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1110 /* cmovnsl */, X86::CMOVNS32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1118 /* cmovnsq */, X86::CMOVNS64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1118 /* cmovnsq */, X86::CMOVNS64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1126 /* cmovnsw */, X86::CMOVNS16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1126 /* cmovnsw */, X86::CMOVNS16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1140 /* cmovol */, X86::CMOVO32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1140 /* cmovol */, X86::CMOVO32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1147 /* cmovoq */, X86::CMOVO64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1147 /* cmovoq */, X86::CMOVO64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1154 /* cmovow */, X86::CMOVO16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1154 /* cmovow */, X86::CMOVO16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1167 /* cmovpl */, X86::CMOVP32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1167 /* cmovpl */, X86::CMOVP32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1174 /* cmovpq */, X86::CMOVP64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1174 /* cmovpq */, X86::CMOVP64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1181 /* cmovpw */, X86::CMOVP16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1181 /* cmovpw */, X86::CMOVP16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1194 /* cmovsl */, X86::CMOVS32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1194 /* cmovsl */, X86::CMOVS32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1201 /* cmovsq */, X86::CMOVS64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1201 /* cmovsq */, X86::CMOVS64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1208 /* cmovsw */, X86::CMOVS16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1208 /* cmovsw */, X86::CMOVS16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1215 /* cmp */, X86::CMPPDrri, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPPDrmi, Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPPSrri, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPPSrmi, Convert__Reg1_3__Tie0__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPSDrr, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPSDrm, Convert__Reg1_3__Tie0__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPSSrr, Convert__Reg1_3__Tie0__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32 }, },
  { 1215 /* cmp */, X86::CMPSSrm, Convert__Reg1_3__Tie0__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32 }, },
  { 1219 /* cmpb */, X86::CMP8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1219 /* cmpb */, X86::CMP8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1219 /* cmpb */, X86::CMP8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 1219 /* cmpb */, X86::CMP8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 1219 /* cmpb */, X86::CMP8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 1219 /* cmpb */, X86::CMP8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 1224 /* cmpl */, X86::CMP32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1224 /* cmpl */, X86::CMP32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1224 /* cmpl */, X86::CMP32ri8, Convert__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 1224 /* cmpl */, X86::CMP32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 1224 /* cmpl */, X86::CMP32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 1224 /* cmpl */, X86::CMP32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 1224 /* cmpl */, X86::CMP32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 1224 /* cmpl */, X86::CMP32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1229 /* cmppd */, X86::CMPPDrri_alt, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1229 /* cmppd */, X86::CMPPDrmi_alt, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1235 /* cmpps */, X86::CMPPSrri_alt, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1235 /* cmpps */, X86::CMPPSrmi_alt, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1241 /* cmpq */, X86::CMP64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1241 /* cmpq */, X86::CMP64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1241 /* cmpq */, X86::CMP64ri8, Convert__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 1241 /* cmpq */, X86::CMP64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 1241 /* cmpq */, X86::CMP64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 1241 /* cmpq */, X86::CMP64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 1241 /* cmpq */, X86::CMP64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 1241 /* cmpq */, X86::CMP64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1246 /* cmpsb */, X86::CMPSB, Convert__DstIdx81_0__SrcIdx82_1, 0, { MCK_DstIdx8, MCK_SrcIdx8 }, },
  { 1252 /* cmpsd */, X86::CMPSDrr_alt, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1252 /* cmpsd */, X86::CMPSDrm_alt, Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 1258 /* cmpsl */, X86::CMPSL, Convert__DstIdx321_0__SrcIdx322_1, 0, { MCK_DstIdx32, MCK_SrcIdx32 }, },
  { 1264 /* cmpsq */, X86::CMPSQ, Convert__DstIdx641_0__SrcIdx642_1, 0, { MCK_DstIdx64, MCK_SrcIdx64 }, },
  { 1270 /* cmpss */, X86::CMPSSrr_alt, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1270 /* cmpss */, X86::CMPSSrm_alt, Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 1276 /* cmpsw */, X86::CMPSW, Convert__DstIdx161_0__SrcIdx162_1, 0, { MCK_DstIdx16, MCK_SrcIdx16 }, },
  { 1282 /* cmpw */, X86::CMP16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1282 /* cmpw */, X86::CMP16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1282 /* cmpw */, X86::CMP16ri8, Convert__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 1282 /* cmpw */, X86::CMP16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 1282 /* cmpw */, X86::CMP16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 1282 /* cmpw */, X86::CMP16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 1282 /* cmpw */, X86::CMP16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 1282 /* cmpw */, X86::CMP16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 1295 /* cmpxchg16b */, X86::CMPXCHG16B, Convert__Mem1285_0, 0, { MCK_Mem128 }, },
  { 1306 /* cmpxchg8b */, X86::CMPXCHG8B, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1316 /* cmpxchgb */, X86::CMPXCHG8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 1316 /* cmpxchgb */, X86::CMPXCHG8rm, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 1325 /* cmpxchgl */, X86::CMPXCHG32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1325 /* cmpxchgl */, X86::CMPXCHG32rm, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 1334 /* cmpxchgq */, X86::CMPXCHG64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1334 /* cmpxchgq */, X86::CMPXCHG64rm, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 1343 /* cmpxchgw */, X86::CMPXCHG16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 1343 /* cmpxchgw */, X86::CMPXCHG16rm, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 1352 /* comisd */, X86::COMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1352 /* comisd */, X86::COMISDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1359 /* comiss */, X86::COMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1359 /* comiss */, X86::COMISSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1366 /* cpuid */, X86::CPUID, Convert_NoOperands, 0, {  }, },
  { 1376 /* cqto */, X86::CQO, Convert_NoOperands, 0, {  }, },
  { 1387 /* crc32b */, X86::CRC32r32r8, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 1387 /* crc32b */, X86::CRC32r64r8, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 1387 /* crc32b */, X86::CRC32r32m8, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 1387 /* crc32b */, X86::CRC32r64m8, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 1394 /* crc32l */, X86::CRC32r32r32, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 1394 /* crc32l */, X86::CRC32r32m32, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1401 /* crc32q */, X86::CRC32r64r64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 1401 /* crc32q */, X86::CRC32r64m64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1408 /* crc32w */, X86::CRC32r32r16, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 1408 /* crc32w */, X86::CRC32r32m16, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 1415 /* cs */, X86::CS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1418 /* cvtdq2pd */, X86::CVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1418 /* cvtdq2pd */, X86::CVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1427 /* cvtdq2ps */, X86::CVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1427 /* cvtdq2ps */, X86::CVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1436 /* cvtpd2dq */, X86::CVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1436 /* cvtpd2dq */, X86::CVTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1445 /* cvtpd2pi */, X86::MMX_CVTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1445 /* cvtpd2pi */, X86::MMX_CVTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1454 /* cvtpd2ps */, X86::CVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1454 /* cvtpd2ps */, X86::CVTPD2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1463 /* cvtpi2pd */, X86::MMX_CVTPI2PDirr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1463 /* cvtpi2pd */, X86::MMX_CVTPI2PDirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1472 /* cvtpi2ps */, X86::MMX_CVTPI2PSirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 1472 /* cvtpi2ps */, X86::MMX_CVTPI2PSirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1481 /* cvtps2dq */, X86::CVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1481 /* cvtps2dq */, X86::CVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1490 /* cvtps2pd */, X86::CVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1490 /* cvtps2pd */, X86::CVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1499 /* cvtps2pi */, X86::MMX_CVTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1499 /* cvtps2pi */, X86::MMX_CVTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1508 /* cvtsd2si */, X86::CVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1508 /* cvtsd2si */, X86::CVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1508 /* cvtsd2si */, X86::CVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1508 /* cvtsd2si */, X86::CVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1517 /* cvtsd2sil */, X86::CVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1517 /* cvtsd2sil */, X86::CVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1527 /* cvtsd2siq */, X86::CVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1527 /* cvtsd2siq */, X86::CVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1537 /* cvtsd2ss */, X86::CVTSD2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1537 /* cvtsd2ss */, X86::CVTSD2SSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1546 /* cvtsi2sd */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1555 /* cvtsi2sdl */, X86::CVTSI2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1555 /* cvtsi2sdl */, X86::CVTSI2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1565 /* cvtsi2sdq */, X86::CVTSI2SD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1565 /* cvtsi2sdq */, X86::CVTSI2SD64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1575 /* cvtsi2ss */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1584 /* cvtsi2ssl */, X86::CVTSI2SSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 1584 /* cvtsi2ssl */, X86::CVTSI2SSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1594 /* cvtsi2ssq */, X86::CVTSI2SS64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 1594 /* cvtsi2ssq */, X86::CVTSI2SS64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1604 /* cvtss2sd */, X86::CVTSS2SDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1604 /* cvtss2sd */, X86::CVTSS2SDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1613 /* cvtss2si */, X86::CVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1613 /* cvtss2si */, X86::CVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1613 /* cvtss2si */, X86::CVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1613 /* cvtss2si */, X86::CVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1622 /* cvtss2sil */, X86::CVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1622 /* cvtss2sil */, X86::CVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1632 /* cvtss2siq */, X86::CVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1632 /* cvtss2siq */, X86::CVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1642 /* cvttpd2dq */, X86::CVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1642 /* cvttpd2dq */, X86::CVTTPD2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1652 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1652 /* cvttpd2pi */, X86::MMX_CVTTPD2PIirm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR64 }, },
  { 1662 /* cvttps2dq */, X86::CVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1662 /* cvttps2dq */, X86::CVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1672 /* cvttps2pi */, X86::MMX_CVTTPS2PIirr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 1672 /* cvttps2pi */, X86::MMX_CVTTPS2PIirm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 1682 /* cvttsd2si */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1682 /* cvttsd2si */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1682 /* cvttsd2si */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1682 /* cvttsd2si */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1692 /* cvttsd2sil */, X86::CVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1692 /* cvttsd2sil */, X86::CVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 1703 /* cvttsd2siq */, X86::CVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1703 /* cvttsd2siq */, X86::CVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 1714 /* cvttss2si */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1714 /* cvttss2si */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1714 /* cvttss2si */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1714 /* cvttss2si */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1724 /* cvttss2sil */, X86::CVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 1724 /* cvttss2sil */, X86::CVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 1735 /* cvttss2siq */, X86::CVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 1735 /* cvttss2siq */, X86::CVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 1755 /* cwtd */, X86::CWD, Convert_NoOperands, 0, {  }, },
  { 1760 /* cwtl */, X86::CWDE, Convert_NoOperands, 0, {  }, },
  { 1765 /* daa */, X86::DAA, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1769 /* das */, X86::DAS, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 1773 /* data16 */, X86::DATA16_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1784 /* decb */, X86::DEC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 1784 /* decb */, X86::DEC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1789 /* decl */, X86::DEC32r_alt, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 1789 /* decl */, X86::DEC32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 1789 /* decl */, X86::DEC32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1794 /* decq */, X86::DEC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 1794 /* decq */, X86::DEC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1799 /* decw */, X86::DEC16r_alt, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 1799 /* decw */, X86::DEC16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 1799 /* decw */, X86::DEC16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1808 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 1808 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 1808 /* divb */, X86::DIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 1808 /* divb */, X86::DIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 1813 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 1813 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1813 /* divl */, X86::DIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 1813 /* divl */, X86::DIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 1818 /* divpd */, X86::DIVPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1818 /* divpd */, X86::DIVPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1824 /* divps */, X86::DIVPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1824 /* divps */, X86::DIVPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 1830 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 1830 /* divq */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1830 /* divq */, X86::DIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 1830 /* divq */, X86::DIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 1835 /* divsd */, X86::DIVSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1835 /* divsd */, X86::DIVSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 1841 /* divss */, X86::DIVSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1841 /* divss */, X86::DIVSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 1847 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 1847 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 1847 /* divw */, X86::DIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 1847 /* divw */, X86::DIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 1852 /* dppd */, X86::DPPDrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1852 /* dppd */, X86::DPPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1857 /* dpps */, X86::DPPSrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 1857 /* dpps */, X86::DPPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 1862 /* ds */, X86::DS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1865 /* emms */, X86::MMX_EMMS, Convert_NoOperands, 0, {  }, },
  { 1870 /* encls */, X86::ENCLS, Convert_NoOperands, 0, {  }, },
  { 1876 /* enclu */, X86::ENCLU, Convert_NoOperands, 0, {  }, },
  { 1882 /* enter */, X86::ENTER, Convert__Imm1_0__Imm1_1, 0, { MCK_Imm, MCK_Imm }, },
  { 1888 /* es */, X86::ES_PREFIX, Convert_NoOperands, 0, {  }, },
  { 1891 /* extractps */, X86::EXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 1891 /* extractps */, X86::EXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 1901 /* extrq */, X86::EXTRQ, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 1901 /* extrq */, X86::EXTRQI, Convert__Reg1_2__Tie0__ImmUnsignedi81_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 1907 /* f2xm1 */, X86::F2XM1, Convert_NoOperands, 0, {  }, },
  { 1913 /* fabs */, X86::ABS_F, Convert_NoOperands, 0, {  }, },
  { 1918 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1918 /* fadd */, X86::ADD_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1918 /* fadd */, X86::ADD_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1918 /* fadd */, X86::ADD_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1923 /* faddl */, X86::ADD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 1929 /* faddp */, X86::ADD_FPrST0, Convert__regST1, 0, {  }, },
  { 1929 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 1929 /* faddp */, X86::ADD_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 1929 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 1929 /* faddp */, X86::ADD_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1935 /* fadds */, X86::ADD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1941 /* fbld */, X86::FBLDm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1946 /* fbstp */, X86::FBSTPm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 1952 /* fchs */, X86::CHS_F, Convert_NoOperands, 0, {  }, },
  { 1957 /* fcmovb */, X86::CMOVB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1964 /* fcmovbe */, X86::CMOVBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1972 /* fcmove */, X86::CMOVE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1979 /* fcmovnb */, X86::CMOVNB_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1987 /* fcmovnbe */, X86::CMOVNBE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 1996 /* fcmovne */, X86::CMOVNE_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2004 /* fcmovnu */, X86::CMOVNP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2012 /* fcmovu */, X86::CMOVP_F, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2019 /* fcom */, X86::COM_FST0r, Convert__regST1, 0, {  }, },
  { 2019 /* fcom */, X86::COM_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2024 /* fcomi */, X86::COM_FIr, Convert__regST1, 0, {  }, },
  { 2024 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2024 /* fcomi */, X86::COM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2024 /* fcomi */, X86::COM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2030 /* fcoml */, X86::FCOM64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2036 /* fcomp */, X86::COMP_FST0r, Convert__regST1, 0, {  }, },
  { 2036 /* fcomp */, X86::COMP_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2042 /* fcompi */, X86::COM_FIPr, Convert__regST1, 0, {  }, },
  { 2042 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2042 /* fcompi */, X86::COM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2042 /* fcompi */, X86::COM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2049 /* fcompl */, X86::FCOMP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2056 /* fcompp */, X86::FCOMPP, Convert_NoOperands, 0, {  }, },
  { 2063 /* fcomps */, X86::FCOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2070 /* fcoms */, X86::FCOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2076 /* fcos */, X86::COS_F, Convert_NoOperands, 0, {  }, },
  { 2081 /* fdecstp */, X86::FDECSTP, Convert_NoOperands, 0, {  }, },
  { 2089 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2089 /* fdiv */, X86::DIV_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2089 /* fdiv */, X86::DIVR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2089 /* fdiv */, X86::DIV_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2094 /* fdivl */, X86::DIV_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2100 /* fdivp */, X86::DIVR_FPrST0, Convert__regST1, 0, {  }, },
  { 2100 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2100 /* fdivp */, X86::DIVR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2100 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2100 /* fdivp */, X86::DIVR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2106 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2106 /* fdivr */, X86::DIVR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2106 /* fdivr */, X86::DIV_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2106 /* fdivr */, X86::DIVR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2112 /* fdivrl */, X86::DIVR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2119 /* fdivrp */, X86::DIV_FPrST0, Convert__regST1, 0, {  }, },
  { 2119 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2119 /* fdivrp */, X86::DIV_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2119 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2119 /* fdivrp */, X86::DIV_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2126 /* fdivrs */, X86::DIVR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2133 /* fdivs */, X86::DIV_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2139 /* femms */, X86::FEMMS, Convert_NoOperands, 0, {  }, },
  { 2145 /* ffree */, X86::FFREE, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2157 /* fiaddl */, X86::ADD_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2164 /* fiadds */, X86::ADD_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2177 /* ficoml */, X86::FICOM32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2191 /* ficompl */, X86::FICOMP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2199 /* ficomps */, X86::FICOMP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2207 /* ficoms */, X86::FICOM16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2220 /* fidivl */, X86::DIV_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2234 /* fidivrl */, X86::DIVR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2242 /* fidivrs */, X86::DIVR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2250 /* fidivs */, X86::DIV_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2262 /* fildl */, X86::ILD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2268 /* fildll */, X86::ILD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2275 /* filds */, X86::ILD_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2287 /* fimull */, X86::MUL_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2294 /* fimuls */, X86::MUL_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2301 /* fincstp */, X86::FINCSTP, Convert_NoOperands, 0, {  }, },
  { 2314 /* fistl */, X86::IST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2326 /* fistpl */, X86::IST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2333 /* fistpll */, X86::IST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2341 /* fistps */, X86::IST_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2348 /* fists */, X86::IST_F16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2361 /* fisttpl */, X86::ISTT_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2369 /* fisttpll */, X86::ISTT_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2378 /* fisttps */, X86::ISTT_FP16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2392 /* fisubl */, X86::SUB_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2406 /* fisubrl */, X86::SUBR_FI32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2414 /* fisubrs */, X86::SUBR_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2422 /* fisubs */, X86::SUB_FI16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2429 /* fld */, X86::LD_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2433 /* fld1 */, X86::LD_F1, Convert_NoOperands, 0, {  }, },
  { 2438 /* fldcw */, X86::FLDCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2444 /* fldenv */, X86::FLDENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2451 /* fldl */, X86::LD_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2456 /* fldl2e */, X86::FLDL2E, Convert_NoOperands, 0, {  }, },
  { 2463 /* fldl2t */, X86::FLDL2T, Convert_NoOperands, 0, {  }, },
  { 2470 /* fldlg2 */, X86::FLDLG2, Convert_NoOperands, 0, {  }, },
  { 2477 /* fldln2 */, X86::FLDLN2, Convert_NoOperands, 0, {  }, },
  { 2484 /* fldpi */, X86::FLDPI, Convert_NoOperands, 0, {  }, },
  { 2490 /* flds */, X86::LD_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2495 /* fldt */, X86::LD_F80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2500 /* fldz */, X86::LD_F0, Convert_NoOperands, 0, {  }, },
  { 2505 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2505 /* fmul */, X86::MUL_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2505 /* fmul */, X86::MUL_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2505 /* fmul */, X86::MUL_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2510 /* fmull */, X86::MUL_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2516 /* fmulp */, X86::MUL_FPrST0, Convert__regST1, 0, {  }, },
  { 2516 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2516 /* fmulp */, X86::MUL_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2516 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2516 /* fmulp */, X86::MUL_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2522 /* fmuls */, X86::MUL_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2528 /* fnclex */, X86::FNCLEX, Convert_NoOperands, 0, {  }, },
  { 2535 /* fninit */, X86::FNINIT, Convert_NoOperands, 0, {  }, },
  { 2542 /* fnop */, X86::FNOP, Convert_NoOperands, 0, {  }, },
  { 2547 /* fnsave */, X86::FSAVEm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2554 /* fnstcw */, X86::FNSTCW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2561 /* fnstenv */, X86::FSTENVm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2569 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, {  }, },
  { 2569 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AL }, },
  { 2569 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_AX }, },
  { 2569 /* fnstsw */, X86::FNSTSW16r, Convert_NoOperands, 0, { MCK_EAX }, },
  { 2569 /* fnstsw */, X86::FNSTSWm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2576 /* fpatan */, X86::FPATAN, Convert_NoOperands, 0, {  }, },
  { 2583 /* fprem */, X86::FPREM, Convert_NoOperands, 0, {  }, },
  { 2589 /* fprem1 */, X86::FPREM1, Convert_NoOperands, 0, {  }, },
  { 2596 /* fptan */, X86::FPTAN, Convert_NoOperands, 0, {  }, },
  { 2602 /* frndint */, X86::FRNDINT, Convert_NoOperands, 0, {  }, },
  { 2610 /* frstor */, X86::FRSTORm, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2617 /* fs */, X86::FS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2620 /* fscale */, X86::FSCALE, Convert_NoOperands, 0, {  }, },
  { 2627 /* fsin */, X86::SIN_F, Convert_NoOperands, 0, {  }, },
  { 2632 /* fsincos */, X86::FSINCOS, Convert_NoOperands, 0, {  }, },
  { 2640 /* fsqrt */, X86::SQRT_F, Convert_NoOperands, 0, {  }, },
  { 2646 /* fst */, X86::ST_Frr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2650 /* fstl */, X86::ST_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2655 /* fstp */, X86::ST_FPrr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2660 /* fstpl */, X86::ST_FP64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2666 /* fstps */, X86::ST_FP32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2672 /* fstpt */, X86::ST_FP80m, Convert__Mem805_0, 0, { MCK_Mem80 }, },
  { 2678 /* fsts */, X86::ST_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2683 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2683 /* fsub */, X86::SUB_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2683 /* fsub */, X86::SUBR_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2683 /* fsub */, X86::SUB_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2688 /* fsubl */, X86::SUB_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2694 /* fsubp */, X86::SUBR_FPrST0, Convert__regST1, 0, {  }, },
  { 2694 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2694 /* fsubp */, X86::SUBR_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2694 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2694 /* fsubp */, X86::SUBR_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2700 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2700 /* fsubr */, X86::SUBR_FST0r, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2700 /* fsubr */, X86::SUB_FrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2700 /* fsubr */, X86::SUBR_FST0r, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2706 /* fsubrl */, X86::SUBR_F64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2713 /* fsubrp */, X86::SUB_FPrST0, Convert__regST1, 0, {  }, },
  { 2713 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2713 /* fsubrp */, X86::SUB_FPrST0, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2713 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_1, 0, { MCK_ST0, MCK_RST }, },
  { 2713 /* fsubrp */, X86::SUB_FPrST0, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2720 /* fsubrs */, X86::SUBR_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2727 /* fsubs */, X86::SUB_F32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2733 /* ftst */, X86::TST_F, Convert_NoOperands, 0, {  }, },
  { 2738 /* fucom */, X86::UCOM_Fr, Convert__regST1, 0, {  }, },
  { 2738 /* fucom */, X86::UCOM_Fr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2744 /* fucomi */, X86::UCOM_FIr, Convert__regST1, 0, {  }, },
  { 2744 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2744 /* fucomi */, X86::UCOM_FIr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2744 /* fucomi */, X86::UCOM_FIr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2751 /* fucomp */, X86::UCOM_FPr, Convert__regST1, 0, {  }, },
  { 2751 /* fucomp */, X86::UCOM_FPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2758 /* fucompi */, X86::UCOM_FIPr, Convert__regST1, 0, {  }, },
  { 2758 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2758 /* fucompi */, X86::UCOM_FIPr, Convert__regST0, 0, { MCK_ST0, MCK_ST0 }, },
  { 2758 /* fucompi */, X86::UCOM_FIPr, Convert__Reg1_0, 0, { MCK_RST, MCK_ST0 }, },
  { 2766 /* fucompp */, X86::UCOM_FPPr, Convert_NoOperands, 0, {  }, },
  { 2774 /* fxam */, X86::FXAM, Convert_NoOperands, 0, {  }, },
  { 2779 /* fxch */, X86::XCH_F, Convert__regST1, 0, {  }, },
  { 2779 /* fxch */, X86::XCH_F, Convert__Reg1_0, 0, { MCK_RST }, },
  { 2784 /* fxrstor */, X86::FXRSTOR, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2792 /* fxrstor64 */, X86::FXRSTOR64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2802 /* fxsave */, X86::FXSAVE, Convert__Mem5_0, 0, { MCK_Mem }, },
  { 2809 /* fxsave64 */, X86::FXSAVE64, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 2818 /* fxtract */, X86::FXTRACT, Convert_NoOperands, 0, {  }, },
  { 2826 /* fyl2x */, X86::FYL2X, Convert_NoOperands, 0, {  }, },
  { 2832 /* fyl2xp1 */, X86::FYL2XP1, Convert_NoOperands, 0, {  }, },
  { 2840 /* getsec */, X86::GETSEC, Convert_NoOperands, 0, {  }, },
  { 2847 /* gs */, X86::GS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 2850 /* haddpd */, X86::HADDPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2850 /* haddpd */, X86::HADDPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2857 /* haddps */, X86::HADDPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2857 /* haddps */, X86::HADDPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2864 /* hlt */, X86::HLT, Convert_NoOperands, 0, {  }, },
  { 2868 /* hsubpd */, X86::HSUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2868 /* hsubpd */, X86::HSUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2875 /* hsubps */, X86::HSUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2875 /* hsubps */, X86::HSUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 2887 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2887 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2887 /* idivb */, X86::IDIV8r, Convert__Reg1_0, 0, { MCK_GR8, MCK_AL }, },
  { 2887 /* idivb */, X86::IDIV8m, Convert__Mem85_0, 0, { MCK_Mem8, MCK_AL }, },
  { 2893 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2893 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2893 /* idivl */, X86::IDIV32r, Convert__Reg1_0, 0, { MCK_GR32, MCK_EAX }, },
  { 2893 /* idivl */, X86::IDIV32m, Convert__Mem325_0, 0, { MCK_Mem32, MCK_EAX }, },
  { 2899 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2899 /* idivq */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2899 /* idivq */, X86::IDIV64r, Convert__Reg1_0, 0, { MCK_GR64, MCK_RAX }, },
  { 2899 /* idivq */, X86::IDIV64m, Convert__Mem645_0, 0, { MCK_Mem64, MCK_RAX }, },
  { 2905 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2905 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2905 /* idivw */, X86::IDIV16r, Convert__Reg1_0, 0, { MCK_GR16, MCK_AX }, },
  { 2905 /* idivw */, X86::IDIV16m, Convert__Mem165_0, 0, { MCK_Mem16, MCK_AX }, },
  { 2916 /* imulb */, X86::IMUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 2916 /* imulb */, X86::IMUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2922 /* imull */, X86::IMUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2922 /* imull */, X86::IMUL32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rri8, Convert__Reg1_1__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rri8, Convert__Reg1_2__Reg1_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rmi8, Convert__Reg1_2__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 2922 /* imull */, X86::IMUL32rmi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 2928 /* imulq */, X86::IMUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2928 /* imulq */, X86::IMUL64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rri8, Convert__Reg1_1__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rri32, Convert__Reg1_1__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rri8, Convert__Reg1_2__Reg1_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rmi8, Convert__Reg1_2__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rri32, Convert__Reg1_2__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64, MCK_GR64 }, },
  { 2928 /* imulq */, X86::IMUL64rmi32, Convert__Reg1_2__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64, MCK_GR64 }, },
  { 2934 /* imulw */, X86::IMUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2934 /* imulw */, X86::IMUL16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rri8, Convert__Reg1_1__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rri, Convert__Reg1_1__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rri8, Convert__Reg1_2__Reg1_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rmi8, Convert__Reg1_2__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 2934 /* imulw */, X86::IMUL16rmi, Convert__Reg1_2__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16, MCK_GR16 }, },
  { 2943 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2943 /* inb */, X86::IN8ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2943 /* inb */, X86::IN8rr, Convert_NoOperands, 0, { MCK_DX, MCK_AL }, },
  { 2943 /* inb */, X86::IN8ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 2951 /* incb */, X86::INC8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 2951 /* incb */, X86::INC8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 2956 /* incl */, X86::INC32r_alt, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 2956 /* incl */, X86::INC32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 2956 /* incl */, X86::INC32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 2961 /* incq */, X86::INC64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 2961 /* incq */, X86::INC64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 2966 /* incw */, X86::INC16r_alt, Convert__Reg1_0__Tie0, Feature_Not64BitMode, { MCK_GR16 }, },
  { 2966 /* incw */, X86::INC16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 2966 /* incw */, X86::INC16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 2971 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 2971 /* inl */, X86::IN32ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 2971 /* inl */, X86::IN32rr, Convert_NoOperands, 0, { MCK_DX, MCK_EAX }, },
  { 2971 /* inl */, X86::IN32ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 2975 /* insb */, X86::INSB, Convert__DstIdx81_1, 0, { MCK_DX, MCK_DstIdx8 }, },
  { 2985 /* insertps */, X86::INSERTPSrr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 2985 /* insertps */, X86::INSERTPSrm, Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 2994 /* insertq */, X86::INSERTQ, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 2994 /* insertq */, X86::INSERTQI, Convert__Reg1_3__Tie0__Reg1_2__ImmUnsignedi81_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 3002 /* insl */, X86::INSL, Convert__DstIdx321_1, 0, { MCK_DX, MCK_DstIdx32 }, },
  { 3007 /* insw */, X86::INSW, Convert__DstIdx161_1, 0, { MCK_DX, MCK_DstIdx16 }, },
  { 3012 /* int */, X86::INT, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3016 /* int3 */, X86::INT3, Convert_NoOperands, 0, {  }, },
  { 3021 /* into */, X86::INTO, Convert_NoOperands, 0, {  }, },
  { 3026 /* invd */, X86::INVD, Convert_NoOperands, 0, {  }, },
  { 3031 /* invept */, X86::INVEPT32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3031 /* invept */, X86::INVEPT64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3038 /* invlpg */, X86::INVLPG, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 3045 /* invlpga */, X86::INVLPGA32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ECX, MCK_EAX }, },
  { 3045 /* invlpga */, X86::INVLPGA64, Convert_NoOperands, Feature_In64BitMode, { MCK_ECX, MCK_RAX }, },
  { 3053 /* invpcid */, X86::INVPCID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3053 /* invpcid */, X86::INVPCID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3061 /* invvpid */, X86::INVVPID32, Convert__Reg1_1__Mem1285_0, Feature_Not64BitMode, { MCK_Mem128, MCK_GR32 }, },
  { 3061 /* invvpid */, X86::INVVPID64, Convert__Reg1_1__Mem1285_0, Feature_In64BitMode, { MCK_Mem128, MCK_GR64 }, },
  { 3069 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 3069 /* inw */, X86::IN16ri, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3069 /* inw */, X86::IN16rr, Convert_NoOperands, 0, { MCK_DX, MCK_AX }, },
  { 3069 /* inw */, X86::IN16ri, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 3084 /* iretl */, X86::IRET32, Convert_NoOperands, 0, {  }, },
  { 3090 /* iretq */, X86::IRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3096 /* iretw */, X86::IRET16, Convert_NoOperands, 0, {  }, },
  { 3102 /* ja */, X86::JA_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3105 /* jae */, X86::JAE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3109 /* jb */, X86::JB_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3112 /* jbe */, X86::JBE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3116 /* jcxz */, X86::JCXZ, Convert__AbsMem1_0, Feature_Not64BitMode, { MCK_AbsMem }, },
  { 3121 /* je */, X86::JE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3124 /* jecxz */, X86::JECXZ, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3130 /* jg */, X86::JG_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3133 /* jge */, X86::JGE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3137 /* jl */, X86::JL_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3140 /* jle */, X86::JLE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3144 /* jmp */, X86::JMP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3144 /* jmp */, X86::JMP16m, Convert__Mem165_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3144 /* jmp */, X86::JMP32m, Convert__Mem325_1, Feature_In32BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3144 /* jmp */, X86::JMP64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3144 /* jmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3144 /* jmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3148 /* jmpl */, X86::JMP32r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR32 }, },
  { 3148 /* jmpl */, X86::JMP32m, Convert__Mem325_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem32 }, },
  { 3148 /* jmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3153 /* jmpq */, X86::JMP64r, Convert__Reg1_1, Feature_In64BitMode, { MCK__STAR_, MCK_GR64 }, },
  { 3153 /* jmpq */, X86::JMP64m, Convert__Mem645_1, Feature_In64BitMode, { MCK__STAR_, MCK_Mem64 }, },
  { 3158 /* jmpw */, X86::JMP16r, Convert__Reg1_1, Feature_Not64BitMode, { MCK__STAR_, MCK_GR16 }, },
  { 3158 /* jmpw */, X86::JMP16m, Convert__Mem165_1, Feature_Not64BitMode, { MCK__STAR_, MCK_Mem16 }, },
  { 3158 /* jmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, 0, { MCK_Imm, MCK_Imm }, },
  { 3163 /* jne */, X86::JNE_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3167 /* jno */, X86::JNO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3171 /* jnp */, X86::JNP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3175 /* jns */, X86::JNS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3179 /* jo */, X86::JO_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3182 /* jp */, X86::JP_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3185 /* jrcxz */, X86::JRCXZ, Convert__AbsMem1_0, Feature_In64BitMode, { MCK_AbsMem }, },
  { 3191 /* js */, X86::JS_1, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3194 /* kandb */, X86::KANDBrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3200 /* kandd */, X86::KANDDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3206 /* kandnb */, X86::KANDNBrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3213 /* kandnd */, X86::KANDNDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3220 /* kandnq */, X86::KANDNQrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3227 /* kandnw */, X86::KANDNWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3234 /* kandq */, X86::KANDQrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3240 /* kandw */, X86::KANDWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3246 /* kmovb */, X86::KMOVBkr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_GR32, MCK_VK1 }, },
  { 3246 /* kmovb */, X86::KMOVBrk, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_GR32 }, },
  { 3246 /* kmovb */, X86::KMOVBkk, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1 }, },
  { 3246 /* kmovb */, X86::KMOVBmk, Convert__Mem85_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_Mem8 }, },
  { 3246 /* kmovb */, X86::KMOVBkm, Convert__Reg1_1__Mem85_0, Feature_HasDQI, { MCK_Mem8, MCK_VK1 }, },
  { 3252 /* kmovd */, X86::KMOVDkr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_GR32, MCK_VK1 }, },
  { 3252 /* kmovd */, X86::KMOVDrk, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_GR32 }, },
  { 3252 /* kmovd */, X86::KMOVDkk, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3252 /* kmovd */, X86::KMOVDmk, Convert__Mem325_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_Mem32 }, },
  { 3252 /* kmovd */, X86::KMOVDkm, Convert__Reg1_1__Mem325_0, Feature_HasBWI, { MCK_Mem32, MCK_VK1 }, },
  { 3258 /* kmovq */, X86::KMOVQkr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_GR64, MCK_VK1 }, },
  { 3258 /* kmovq */, X86::KMOVQrk, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_GR64 }, },
  { 3258 /* kmovq */, X86::KMOVQkk, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3258 /* kmovq */, X86::KMOVQmk, Convert__Mem645_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_Mem64 }, },
  { 3258 /* kmovq */, X86::KMOVQkm, Convert__Reg1_1__Mem645_0, Feature_HasBWI, { MCK_Mem64, MCK_VK1 }, },
  { 3264 /* kmovw */, X86::KMOVWkr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_VK1 }, },
  { 3264 /* kmovw */, X86::KMOVWrk, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_GR32 }, },
  { 3264 /* kmovw */, X86::KMOVWkk, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3264 /* kmovw */, X86::KMOVWmk, Convert__Mem165_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_Mem16 }, },
  { 3264 /* kmovw */, X86::KMOVWkm, Convert__Reg1_1__Mem165_0, Feature_HasAVX512, { MCK_Mem16, MCK_VK1 }, },
  { 3270 /* knotb */, X86::KNOTBrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1 }, },
  { 3276 /* knotd */, X86::KNOTDrr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3282 /* knotq */, X86::KNOTQrr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3288 /* knotw */, X86::KNOTWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3294 /* korb */, X86::KORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3299 /* kord */, X86::KORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3304 /* korq */, X86::KORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3309 /* kortestb */, X86::KORTESTBrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1 }, },
  { 3318 /* kortestd */, X86::KORTESTDrr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3327 /* kortestq */, X86::KORTESTQrr, Convert__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1 }, },
  { 3336 /* kortestw */, X86::KORTESTWrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1 }, },
  { 3345 /* korw */, X86::KORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3350 /* kshiftlb */, X86::KSHIFTLBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasDQI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3359 /* kshiftld */, X86::KSHIFTLDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasDQI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3368 /* kshiftlq */, X86::KSHIFTLQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasBWI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3377 /* kshiftlw */, X86::KSHIFTLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3386 /* kshiftrb */, X86::KSHIFTRBri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasDQI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3395 /* kshiftrd */, X86::KSHIFTRDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasDQI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3404 /* kshiftrq */, X86::KSHIFTRQri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasBWI, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3413 /* kshiftrw */, X86::KSHIFTRWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VK1, MCK_VK1 }, },
  { 3422 /* kunpckbw */, X86::KUNPCKBWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3431 /* kxnorb */, X86::KXNORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3438 /* kxnord */, X86::KXNORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3445 /* kxnorq */, X86::KXNORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3452 /* kxnorw */, X86::KXNORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3459 /* kxorb */, X86::KXORBrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3465 /* kxord */, X86::KXORDrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3471 /* kxorq */, X86::KXORQrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasBWI, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3477 /* kxorw */, X86::KXORWrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VK1, MCK_VK1, MCK_VK1 }, },
  { 3483 /* lahf */, X86::LAHF, Convert_NoOperands, 0, {  }, },
  { 3492 /* larl */, X86::LAR32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3492 /* larl */, X86::LAR32rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 3497 /* larq */, X86::LAR64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 3497 /* larq */, X86::LAR64rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 3502 /* larw */, X86::LAR16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3502 /* larw */, X86::LAR16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3507 /* lcall */, X86::FARCALL32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3507 /* lcall */, X86::FARCALL16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3507 /* lcall */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3507 /* lcall */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3513 /* lcalll */, X86::FARCALL32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3513 /* lcalll */, X86::FARCALL32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3520 /* lcallq */, X86::FARCALL64, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3527 /* lcallw */, X86::FARCALL16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3527 /* lcallw */, X86::FARCALL16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3534 /* lddqu */, X86::LDDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3540 /* ldmxcsr */, X86::LDMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 3552 /* ldsl */, X86::LDS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3557 /* ldsw */, X86::LDS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3566 /* leal */, X86::LEA32r, Convert__Reg1_1__Mem5_0, Feature_Not64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3566 /* leal */, X86::LEA64_32r, Convert__Reg1_1__Mem5_0, Feature_In64BitMode, { MCK_Mem, MCK_GR32 }, },
  { 3571 /* leaq */, X86::LEA64r, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3576 /* leave */, X86::LEAVE, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 3576 /* leave */, X86::LEAVE64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3582 /* leaw */, X86::LEA16r, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3591 /* lesl */, X86::LES32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3596 /* lesw */, X86::LES16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3601 /* lfence */, X86::LFENCE, Convert_NoOperands, 0, {  }, },
  { 3612 /* lfsl */, X86::LFS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3617 /* lfsq */, X86::LFS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3622 /* lfsw */, X86::LFS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3632 /* lgdtl */, X86::LGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3638 /* lgdtq */, X86::LGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3644 /* lgdtw */, X86::LGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3654 /* lgsl */, X86::LGS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3659 /* lgsq */, X86::LGS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3664 /* lgsw */, X86::LGS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3674 /* lidtl */, X86::LIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3680 /* lidtq */, X86::LIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 3686 /* lidtw */, X86::LIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 3692 /* ljmp */, X86::FARJMP32m, Convert__Mem5_1, Feature_Not16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3692 /* ljmp */, X86::FARJMP16m, Convert__Mem5_1, Feature_In16BitMode, { MCK__STAR_, MCK_Mem }, },
  { 3692 /* ljmp */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3692 /* ljmp */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_In16BitMode, { MCK_Imm, MCK_Imm }, },
  { 3697 /* ljmpl */, X86::FARJMP32m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3697 /* ljmpl */, X86::FARJMP32i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3703 /* ljmpq */, X86::FARJMP64, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3709 /* ljmpw */, X86::FARJMP16m, Convert__Mem5_1, 0, { MCK__STAR_, MCK_Mem }, },
  { 3709 /* ljmpw */, X86::FARJMP16i, Convert__Imm1_1__Imm1_0, Feature_Not64BitMode, { MCK_Imm, MCK_Imm }, },
  { 3720 /* lldtw */, X86::LLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3720 /* lldtw */, X86::LLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3731 /* lmsww */, X86::LMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3731 /* lmsww */, X86::LMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3737 /* lock */, X86::LOCK_PREFIX, Convert_NoOperands, 0, {  }, },
  { 3742 /* lods */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 3742 /* lods */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 3742 /* lods */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64, MCK_RAX }, },
  { 3742 /* lods */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 3747 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8 }, },
  { 3747 /* lodsb */, X86::LODSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_AL }, },
  { 3759 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32 }, },
  { 3759 /* lodsl */, X86::LODSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_EAX }, },
  { 3765 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, Feature_In64BitMode, { MCK_SrcIdx64 }, },
  { 3765 /* lodsq */, X86::LODSQ, Convert__SrcIdx642_0, 0, { MCK_SrcIdx64, MCK_RAX }, },
  { 3771 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16 }, },
  { 3771 /* lodsw */, X86::LODSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_AX }, },
  { 3777 /* loop */, X86::LOOP, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3782 /* loope */, X86::LOOPE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3788 /* loopne */, X86::LOOPNE, Convert__AbsMem1_0, 0, { MCK_AbsMem }, },
  { 3795 /* lretl */, X86::LRETL, Convert_NoOperands, 0, {  }, },
  { 3795 /* lretl */, X86::LRETIL, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3801 /* lretq */, X86::LRETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 3801 /* lretq */, X86::LRETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 3807 /* lretw */, X86::LRETW, Convert_NoOperands, 0, {  }, },
  { 3807 /* lretw */, X86::LRETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 3817 /* lsll */, X86::LSL32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3817 /* lsll */, X86::LSL32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3822 /* lslq */, X86::LSL64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3822 /* lslq */, X86::LSL64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3827 /* lslw */, X86::LSL16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3827 /* lslw */, X86::LSL16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3836 /* lssl */, X86::LSS32rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR32 }, },
  { 3841 /* lssq */, X86::LSS64rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR64 }, },
  { 3846 /* lssw */, X86::LSS16rm, Convert__Reg1_1__Mem5_0, 0, { MCK_Mem, MCK_GR16 }, },
  { 3855 /* ltrw */, X86::LTRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 3855 /* ltrw */, X86::LTRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 3866 /* lzcntl */, X86::LZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 3866 /* lzcntl */, X86::LZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 3873 /* lzcntq */, X86::LZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 3873 /* lzcntq */, X86::LZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 3880 /* lzcntw */, X86::LZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 3880 /* lzcntw */, X86::LZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 3887 /* maskmovdqu */, X86::MASKMOVDQU, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3887 /* maskmovdqu */, X86::MASKMOVDQU64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_FR32, MCK_FR32 }, },
  { 3898 /* maskmovq */, X86::MMX_MASKMOVQ, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3898 /* maskmovq */, X86::MMX_MASKMOVQ64, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_VR64, MCK_VR64 }, },
  { 3907 /* maxpd */, X86::MAXPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3907 /* maxpd */, X86::MAXPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3913 /* maxps */, X86::MAXPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3913 /* maxps */, X86::MAXPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3919 /* maxsd */, X86::MAXSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3919 /* maxsd */, X86::MAXSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3925 /* maxss */, X86::MAXSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3925 /* maxss */, X86::MAXSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3931 /* mfence */, X86::MFENCE, Convert_NoOperands, 0, {  }, },
  { 3938 /* minpd */, X86::MINPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3938 /* minpd */, X86::MINPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3944 /* minps */, X86::MINPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3944 /* minps */, X86::MINPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 3950 /* minsd */, X86::MINSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3950 /* minsd */, X86::MINSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 3956 /* minss */, X86::MINSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 3956 /* minss */, X86::MINSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 3962 /* monitor */, X86::MONITORrrr, Convert_NoOperands, 0, {  }, },
  { 3962 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX, MCK_EDX }, },
  { 3962 /* monitor */, X86::MONITORrrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX, MCK_RDX }, },
  { 3970 /* montmul */, X86::MONTMUL, Convert_NoOperands, 0, {  }, },
  { 3978 /* mov */, X86::MOV32ms, Convert__Mem325_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 3978 /* mov */, X86::MOV32sm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 3989 /* movabsb */, X86::MOV8o64a, Convert__MemOffs64_82_1, 0, { MCK_AL, MCK_MemOffs64_8 }, },
  { 3989 /* movabsb */, X86::MOV8ao64, Convert__MemOffs64_82_0, 0, { MCK_MemOffs64_8, MCK_AL }, },
  { 3997 /* movabsl */, X86::MOV32o64a, Convert__MemOffs64_322_1, 0, { MCK_EAX, MCK_MemOffs64_32 }, },
  { 3997 /* movabsl */, X86::MOV32ao64, Convert__MemOffs64_322_0, 0, { MCK_MemOffs64_32, MCK_EAX }, },
  { 4005 /* movabsq */, X86::MOV64o64a, Convert__MemOffs64_642_1, 0, { MCK_RAX, MCK_MemOffs64_64 }, },
  { 4005 /* movabsq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 4005 /* movabsq */, X86::MOV64ao64, Convert__MemOffs64_642_0, 0, { MCK_MemOffs64_64, MCK_RAX }, },
  { 4013 /* movabsw */, X86::MOV16o64a, Convert__MemOffs64_162_1, 0, { MCK_AX, MCK_MemOffs64_16 }, },
  { 4013 /* movabsw */, X86::MOV16ao64, Convert__MemOffs64_162_0, 0, { MCK_MemOffs64_16, MCK_AX }, },
  { 4021 /* movapd */, X86::MOVAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4021 /* movapd */, X86::MOVAPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4021 /* movapd */, X86::MOVAPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4028 /* movaps */, X86::MOVAPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4028 /* movaps */, X86::MOVAPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4028 /* movaps */, X86::MOVAPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4035 /* movb */, X86::MOV8o16a, Convert__MemOffs16_82_1, 0, { MCK_AL, MCK_MemOffs16_8 }, },
  { 4035 /* movb */, X86::MOV8o32a, Convert__MemOffs32_82_1, 0, { MCK_AL, MCK_MemOffs32_8 }, },
  { 4035 /* movb */, X86::MOV8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4035 /* movb */, X86::MOV8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 4035 /* movb */, X86::MOV8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 4035 /* movb */, X86::MOV8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 4035 /* movb */, X86::MOV8ao16, Convert__MemOffs16_82_0, 0, { MCK_MemOffs16_8, MCK_AL }, },
  { 4035 /* movb */, X86::MOV8ao32, Convert__MemOffs32_82_0, 0, { MCK_MemOffs32_8, MCK_AL }, },
  { 4035 /* movb */, X86::MOV8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 4046 /* movbel */, X86::MOVBE32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4046 /* movbel */, X86::MOVBE32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4053 /* movbeq */, X86::MOVBE64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4053 /* movbeq */, X86::MOVBE64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4060 /* movbew */, X86::MOVBE16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4060 /* movbew */, X86::MOVBE16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4067 /* movd */, X86::MMX_MOVD64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_VR64 }, },
  { 4067 /* movd */, X86::MOVDI2PDIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32 }, },
  { 4067 /* movd */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 4067 /* movd */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 4067 /* movd */, X86::MMX_MOVD64grr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR32 }, },
  { 4067 /* movd */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 4067 /* movd */, X86::MMX_MOVD64mr, Convert__Mem325_1__Reg1_0, 0, { MCK_VR64, MCK_Mem32 }, },
  { 4067 /* movd */, X86::MOVPDI2DIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 4067 /* movd */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 4067 /* movd */, X86::MOVPDI2DImr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4067 /* movd */, X86::MMX_MOVD64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR64 }, },
  { 4067 /* movd */, X86::MOVDI2PDIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4072 /* movddup */, X86::MOVDDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4072 /* movddup */, X86::MOVDDUPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4080 /* movdq2q */, X86::MMX_MOVDQ2Qrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR64 }, },
  { 4088 /* movdqa */, X86::MOVDQArr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4088 /* movdqa */, X86::MOVDQAmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4088 /* movdqa */, X86::MOVDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4095 /* movdqu */, X86::MOVDQUrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4095 /* movdqu */, X86::MOVDQUmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4095 /* movdqu */, X86::MOVDQUrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4102 /* movhlps */, X86::MOVHLPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4110 /* movhpd */, X86::MOVHPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4110 /* movhpd */, X86::MOVHPDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4117 /* movhps */, X86::MOVHPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4117 /* movhps */, X86::MOVHPSrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4124 /* movl */, X86::MOV32o16a, Convert__MemOffs16_322_1, 0, { MCK_EAX, MCK_MemOffs16_32 }, },
  { 4124 /* movl */, X86::MOV32o32a, Convert__MemOffs32_322_1, 0, { MCK_EAX, MCK_MemOffs32_32 }, },
  { 4124 /* movl */, X86::MOV32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_SEGMENT_REG }, },
  { 4124 /* movl */, X86::MOV32dr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_DEBUG_REG }, },
  { 4124 /* movl */, X86::MOV32cr, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_GR32, MCK_CONTROL_REG }, },
  { 4124 /* movl */, X86::MOV32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4124 /* movl */, X86::MOV32rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32ms, Convert__Mem325_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem32 }, },
  { 4124 /* movl */, X86::MOV32rd, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_DEBUG_REG, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32rc, Convert__Reg1_1__Reg1_0, Feature_Not64BitMode, { MCK_CONTROL_REG, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 4124 /* movl */, X86::MOV32ao16, Convert__MemOffs16_322_0, 0, { MCK_MemOffs16_32, MCK_EAX }, },
  { 4124 /* movl */, X86::MOV32ao32, Convert__MemOffs32_322_0, 0, { MCK_MemOffs32_32, MCK_EAX }, },
  { 4124 /* movl */, X86::MOV32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4124 /* movl */, X86::MOV32sm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_SEGMENT_REG }, },
  { 4129 /* movlhps */, X86::MOVLHPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4137 /* movlpd */, X86::MOVLPDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4137 /* movlpd */, X86::MOVLPDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4144 /* movlps */, X86::MOVLPSmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4144 /* movlps */, X86::MOVLPSrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4151 /* movmskpd */, X86::MOVMSKPDrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 4160 /* movmskps */, X86::MOVMSKPSrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 4169 /* movntdq */, X86::MOVNTDQmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4177 /* movntdqa */, X86::MOVNTDQArm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4193 /* movntil */, X86::MOVNTImr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4201 /* movntiq */, X86::MOVNTI_64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4209 /* movntpd */, X86::MOVNTPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4217 /* movntps */, X86::MOVNTPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4225 /* movntq */, X86::MMX_MOVNTQmr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4232 /* movntsd */, X86::MOVNTSD, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4240 /* movntss */, X86::MOVNTSS, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4248 /* movq */, X86::MOV64o32a, Convert__MemOffs32_642_1, 0, { MCK_RAX, MCK_MemOffs32_64 }, },
  { 4248 /* movq */, X86::MOV64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4248 /* movq */, X86::MMX_MOVD64to64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_VR64 }, },
  { 4248 /* movq */, X86::MOV64toPQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32 }, },
  { 4248 /* movq */, X86::MOV64sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_SEGMENT_REG }, },
  { 4248 /* movq */, X86::MOV64dr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_DEBUG_REG }, },
  { 4248 /* movq */, X86::MOV64cr, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR64, MCK_CONTROL_REG }, },
  { 4248 /* movq */, X86::MOV64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4248 /* movq */, X86::MMX_MOVD64from64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_GR64 }, },
  { 4248 /* movq */, X86::MMX_MOVQ64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4248 /* movq */, X86::MMX_MOVQ64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_VR64, MCK_Mem64 }, },
  { 4248 /* movq */, X86::MOVPQIto64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOVZPQILo2PQIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4248 /* movq */, X86::MOVPQI2QImr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4248 /* movq */, X86::MOV64rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOV64ms, Convert__Mem645_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem64 }, },
  { 4248 /* movq */, X86::MOV64rd, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_DEBUG_REG, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOV64rc, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_CONTROL_REG, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOV64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOV64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4248 /* movq */, X86::MOV64ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 4248 /* movq */, X86::MOV64ao32, Convert__MemOffs32_642_0, 0, { MCK_MemOffs32_64, MCK_RAX }, },
  { 4248 /* movq */, X86::MOV64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4248 /* movq */, X86::MMX_MOVQ64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4248 /* movq */, X86::MOVQI2PQIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4248 /* movq */, X86::MOV64sm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_SEGMENT_REG }, },
  { 4253 /* movq2dq */, X86::MMX_MOVQ2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_FR32 }, },
  { 4261 /* movsb */, X86::MOVSB, Convert__DstIdx81_1__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DstIdx8 }, },
  { 4267 /* movsbl */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4267 /* movsbl */, X86::MOVSX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4274 /* movsbq */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4274 /* movsbq */, X86::MOVSX64rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4281 /* movsbw */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4281 /* movsbw */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4288 /* movsd */, X86::MOVSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4288 /* movsd */, X86::MOVSDmr, Convert__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64 }, },
  { 4288 /* movsd */, X86::MOVSDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4294 /* movshdup */, X86::MOVSHDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4294 /* movshdup */, X86::MOVSHDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4303 /* movsl */, X86::MOVSL, Convert__DstIdx321_1__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DstIdx32 }, },
  { 4309 /* movsldup */, X86::MOVSLDUPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4309 /* movsldup */, X86::MOVSLDUPrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4318 /* movslq */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, Feature_In64BitMode, { MCK_GR32, MCK_GR64 }, },
  { 4318 /* movslq */, X86::MOVSX64rm32, Convert__Reg1_1__Mem325_0, Feature_In64BitMode, { MCK_Mem32, MCK_GR64 }, },
  { 4325 /* movsq */, X86::MOVSQ, Convert__DstIdx641_1__SrcIdx642_0, 0, { MCK_SrcIdx64, MCK_DstIdx64 }, },
  { 4331 /* movss */, X86::MOVSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4331 /* movss */, X86::MOVSSmr, Convert__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32 }, },
  { 4331 /* movss */, X86::MOVSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4337 /* movsw */, X86::MOVSW, Convert__DstIdx161_1__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DstIdx16 }, },
  { 4343 /* movswl */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4343 /* movswl */, X86::MOVSX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4350 /* movswq */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4350 /* movswq */, X86::MOVSX64rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4357 /* movsx */, X86::MOVSX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4357 /* movsx */, X86::MOVSX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4357 /* movsx */, X86::MOVSX64rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4357 /* movsx */, X86::MOVSX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4357 /* movsx */, X86::MOVSX64rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4357 /* movsx */, X86::MOVSX64rr32, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR64 }, },
  { 4357 /* movsx */, X86::MOVSX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4370 /* movupd */, X86::MOVUPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4370 /* movupd */, X86::MOVUPDmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4370 /* movupd */, X86::MOVUPDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4377 /* movups */, X86::MOVUPSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4377 /* movups */, X86::MOVUPSmr, Convert__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128 }, },
  { 4377 /* movups */, X86::MOVUPSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4384 /* movw */, X86::MOV16o16a, Convert__MemOffs16_162_1, 0, { MCK_AX, MCK_MemOffs16_16 }, },
  { 4384 /* movw */, X86::MOV16o32a, Convert__MemOffs32_162_1, 0, { MCK_AX, MCK_MemOffs32_16 }, },
  { 4384 /* movw */, X86::MOV16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4384 /* movw */, X86::MOV16sr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_SEGMENT_REG }, },
  { 4384 /* movw */, X86::MOV16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4384 /* movw */, X86::MOV16rs, Convert__Reg1_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_GR16 }, },
  { 4384 /* movw */, X86::MOV16ms, Convert__Mem165_1__Reg1_0, 0, { MCK_SEGMENT_REG, MCK_Mem16 }, },
  { 4384 /* movw */, X86::MOV16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 4384 /* movw */, X86::MOV16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 4384 /* movw */, X86::MOV16ao16, Convert__MemOffs16_162_0, 0, { MCK_MemOffs16_16, MCK_AX }, },
  { 4384 /* movw */, X86::MOV16ao32, Convert__MemOffs32_162_0, 0, { MCK_MemOffs32_16, MCK_AX }, },
  { 4384 /* movw */, X86::MOV16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4384 /* movw */, X86::MOV16sm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_SEGMENT_REG }, },
  { 4389 /* movzbl */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4389 /* movzbl */, X86::MOVZX32rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR32 }, },
  { 4396 /* movzbq */, X86::MOVZX64rr8_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4396 /* movzbq */, X86::MOVZX64rm8_Q, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR64 }, },
  { 4403 /* movzbw */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4403 /* movzbw */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4410 /* movzwl */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4410 /* movzwl */, X86::MOVZX32rm16, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR32 }, },
  { 4417 /* movzwq */, X86::MOVZX64rr16_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4417 /* movzwq */, X86::MOVZX64rm16_Q, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR64 }, },
  { 4424 /* movzx */, X86::MOVZX16rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR16 }, },
  { 4424 /* movzx */, X86::MOVZX32rr8, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR32 }, },
  { 4424 /* movzx */, X86::MOVZX64rr8_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR64 }, },
  { 4424 /* movzx */, X86::MOVZX32rr16, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR32 }, },
  { 4424 /* movzx */, X86::MOVZX64rr16_Q, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR64 }, },
  { 4424 /* movzx */, X86::MOVZX16rm8, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR16 }, },
  { 4430 /* mpsadbw */, X86::MPSADBWrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4430 /* mpsadbw */, X86::MPSADBWrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4442 /* mulb */, X86::MUL8r, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 4442 /* mulb */, X86::MUL8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4447 /* mull */, X86::MUL32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 4447 /* mull */, X86::MUL32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4452 /* mulpd */, X86::MULPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4452 /* mulpd */, X86::MULPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4458 /* mulps */, X86::MULPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4458 /* mulps */, X86::MULPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4464 /* mulq */, X86::MUL64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 4464 /* mulq */, X86::MUL64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4469 /* mulsd */, X86::MULSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4469 /* mulsd */, X86::MULSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 4475 /* mulss */, X86::MULSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4475 /* mulss */, X86::MULSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 4481 /* mulw */, X86::MUL16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 4481 /* mulw */, X86::MUL16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4491 /* mulxl */, X86::MULX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4491 /* mulxl */, X86::MULX32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4497 /* mulxq */, X86::MULX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4497 /* mulxq */, X86::MULX64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 4503 /* mwait */, X86::MWAITrr, Convert_NoOperands, 0, {  }, },
  { 4503 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_Not64BitMode, { MCK_EAX, MCK_ECX }, },
  { 4503 /* mwait */, X86::MWAITrr, Convert_NoOperands, Feature_In64BitMode, { MCK_RAX, MCK_RCX }, },
  { 4513 /* negb */, X86::NEG8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4513 /* negb */, X86::NEG8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4518 /* negl */, X86::NEG32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4518 /* negl */, X86::NEG32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4523 /* negq */, X86::NEG64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4523 /* negq */, X86::NEG64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4528 /* negw */, X86::NEG16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4528 /* negw */, X86::NEG16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4533 /* nop */, X86::NOOP, Convert_NoOperands, 0, {  }, },
  { 4537 /* nopl */, X86::NOOPL, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4542 /* nopw */, X86::NOOPW, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4551 /* notb */, X86::NOT8r, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 4551 /* notb */, X86::NOT8m, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 4556 /* notl */, X86::NOT32r, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 4556 /* notl */, X86::NOT32m, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 4561 /* notq */, X86::NOT64r, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 4561 /* notq */, X86::NOT64m, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 4566 /* notw */, X86::NOT16r, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 4566 /* notw */, X86::NOT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 4574 /* orb */, X86::OR8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 4574 /* orb */, X86::OR8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 4574 /* orb */, X86::OR8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 4574 /* orb */, X86::OR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 4574 /* orb */, X86::OR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 4574 /* orb */, X86::OR8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 4578 /* orl */, X86::OR32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 4578 /* orl */, X86::OR32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 4578 /* orl */, X86::OR32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 4578 /* orl */, X86::OR32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 4578 /* orl */, X86::OR32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 4578 /* orl */, X86::OR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 4578 /* orl */, X86::OR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 4578 /* orl */, X86::OR32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 4582 /* orpd */, X86::ORPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4582 /* orpd */, X86::ORPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4587 /* orps */, X86::ORPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4587 /* orps */, X86::ORPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4592 /* orq */, X86::OR64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 4592 /* orq */, X86::OR64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 4592 /* orq */, X86::OR64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 4592 /* orq */, X86::OR64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 4592 /* orq */, X86::OR64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 4592 /* orq */, X86::OR64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 4592 /* orq */, X86::OR64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 4592 /* orq */, X86::OR64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 4596 /* orw */, X86::OR16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 4596 /* orw */, X86::OR16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 4596 /* orw */, X86::OR16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 4596 /* orw */, X86::OR16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 4596 /* orw */, X86::OR16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 4596 /* orw */, X86::OR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 4596 /* orw */, X86::OR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 4596 /* orw */, X86::OR16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 4604 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4604 /* outb */, X86::OUT8ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4604 /* outb */, X86::OUT8rr, Convert_NoOperands, 0, { MCK_AL, MCK_DX }, },
  { 4604 /* outb */, X86::OUT8ir, Convert__Imm1_1, 0, { MCK_AL, MCK_Imm }, },
  { 4609 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4609 /* outl */, X86::OUT32ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4609 /* outl */, X86::OUT32rr, Convert_NoOperands, 0, { MCK_EAX, MCK_DX }, },
  { 4609 /* outl */, X86::OUT32ir, Convert__Imm1_1, 0, { MCK_EAX, MCK_Imm }, },
  { 4614 /* outsb */, X86::OUTSB, Convert__SrcIdx82_0, 0, { MCK_SrcIdx8, MCK_DX }, },
  { 4626 /* outsl */, X86::OUTSL, Convert__SrcIdx322_0, 0, { MCK_SrcIdx32, MCK_DX }, },
  { 4632 /* outsw */, X86::OUTSW, Convert__SrcIdx162_0, 0, { MCK_SrcIdx16, MCK_DX }, },
  { 4638 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_DX }, },
  { 4638 /* outw */, X86::OUT16ir, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 4638 /* outw */, X86::OUT16rr, Convert_NoOperands, 0, { MCK_AX, MCK_DX }, },
  { 4638 /* outw */, X86::OUT16ir, Convert__Imm1_1, 0, { MCK_AX, MCK_Imm }, },
  { 4643 /* pabsb */, X86::MMX_PABSBrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4643 /* pabsb */, X86::PABSBrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4643 /* pabsb */, X86::PABSBrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4643 /* pabsb */, X86::MMX_PABSBrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4649 /* pabsd */, X86::MMX_PABSDrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4649 /* pabsd */, X86::PABSDrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4649 /* pabsd */, X86::PABSDrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4649 /* pabsd */, X86::MMX_PABSDrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4655 /* pabsw */, X86::MMX_PABSWrr64, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4655 /* pabsw */, X86::PABSWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4655 /* pabsw */, X86::PABSWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4655 /* pabsw */, X86::MMX_PABSWrm64, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4661 /* packssdw */, X86::MMX_PACKSSDWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4661 /* packssdw */, X86::PACKSSDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4661 /* packssdw */, X86::PACKSSDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4661 /* packssdw */, X86::MMX_PACKSSDWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4670 /* packsswb */, X86::MMX_PACKSSWBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4670 /* packsswb */, X86::PACKSSWBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4670 /* packsswb */, X86::PACKSSWBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4670 /* packsswb */, X86::MMX_PACKSSWBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4679 /* packusdw */, X86::PACKUSDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4679 /* packusdw */, X86::PACKUSDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4688 /* packuswb */, X86::MMX_PACKUSWBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4688 /* packuswb */, X86::PACKUSWBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4688 /* packuswb */, X86::PACKUSWBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4688 /* packuswb */, X86::MMX_PACKUSWBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4697 /* paddb */, X86::MMX_PADDBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4697 /* paddb */, X86::PADDBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4697 /* paddb */, X86::PADDBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4697 /* paddb */, X86::MMX_PADDBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4703 /* paddd */, X86::MMX_PADDDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4703 /* paddd */, X86::PADDDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4703 /* paddd */, X86::PADDDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4703 /* paddd */, X86::MMX_PADDDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4709 /* paddq */, X86::MMX_PADDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4709 /* paddq */, X86::PADDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4709 /* paddq */, X86::PADDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4709 /* paddq */, X86::MMX_PADDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4715 /* paddsb */, X86::MMX_PADDSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4715 /* paddsb */, X86::PADDSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4715 /* paddsb */, X86::PADDSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4715 /* paddsb */, X86::MMX_PADDSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4722 /* paddsw */, X86::MMX_PADDSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4722 /* paddsw */, X86::PADDSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4722 /* paddsw */, X86::PADDSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4722 /* paddsw */, X86::MMX_PADDSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4729 /* paddusb */, X86::MMX_PADDUSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4729 /* paddusb */, X86::PADDUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4729 /* paddusb */, X86::PADDUSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4729 /* paddusb */, X86::MMX_PADDUSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4737 /* paddusw */, X86::MMX_PADDUSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4737 /* paddusw */, X86::PADDUSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4737 /* paddusw */, X86::PADDUSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4737 /* paddusw */, X86::MMX_PADDUSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4745 /* paddw */, X86::MMX_PADDWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4745 /* paddw */, X86::PADDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4745 /* paddw */, X86::PADDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4745 /* paddw */, X86::MMX_PADDWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4751 /* palignr */, X86::MMX_PALIGNR64irr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 4751 /* palignr */, X86::PALIGNR128rr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4751 /* palignr */, X86::PALIGNR128rm, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4751 /* palignr */, X86::MMX_PALIGNR64irm, Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 4759 /* pand */, X86::MMX_PANDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4759 /* pand */, X86::PANDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4759 /* pand */, X86::PANDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4759 /* pand */, X86::MMX_PANDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4764 /* pandn */, X86::MMX_PANDNirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4764 /* pandn */, X86::PANDNrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4764 /* pandn */, X86::PANDNrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4764 /* pandn */, X86::MMX_PANDNirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4770 /* pause */, X86::PAUSE, Convert_NoOperands, 0, {  }, },
  { 4776 /* pavgb */, X86::MMX_PAVGBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4776 /* pavgb */, X86::PAVGBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4776 /* pavgb */, X86::PAVGBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4776 /* pavgb */, X86::MMX_PAVGBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4782 /* pavgusb */, X86::PAVGUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4782 /* pavgusb */, X86::PAVGUSBrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4790 /* pavgw */, X86::MMX_PAVGWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4790 /* pavgw */, X86::PAVGWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4790 /* pavgw */, X86::PAVGWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4790 /* pavgw */, X86::MMX_PAVGWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4796 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4796 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4796 /* pblendvb */, X86::PBLENDVBrr0, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 4796 /* pblendvb */, X86::PBLENDVBrm0, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 4805 /* pblendw */, X86::PBLENDWrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4805 /* pblendw */, X86::PBLENDWrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4813 /* pclmulhqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_95_17, 0, { MCK_FR32, MCK_FR32 }, },
  { 4813 /* pclmulhqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_95_17, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4826 /* pclmulhqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_95_1, 0, { MCK_FR32, MCK_FR32 }, },
  { 4826 /* pclmulhqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_95_1, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4839 /* pclmullqhqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_95_16, 0, { MCK_FR32, MCK_FR32 }, },
  { 4839 /* pclmullqhqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_95_16, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4852 /* pclmullqlqdq */, X86::PCLMULQDQrr, Convert__Reg1_1__Tie0__Reg1_0__imm_95_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4852 /* pclmullqlqdq */, X86::PCLMULQDQrm, Convert__Reg1_1__Tie0__Mem1285_0__imm_95_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4865 /* pclmulqdq */, X86::PCLMULQDQrr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4865 /* pclmulqdq */, X86::PCLMULQDQrm, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4875 /* pcmpeqb */, X86::MMX_PCMPEQBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4875 /* pcmpeqb */, X86::PCMPEQBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4875 /* pcmpeqb */, X86::PCMPEQBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4875 /* pcmpeqb */, X86::MMX_PCMPEQBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4883 /* pcmpeqd */, X86::MMX_PCMPEQDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4883 /* pcmpeqd */, X86::PCMPEQDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4883 /* pcmpeqd */, X86::PCMPEQDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4883 /* pcmpeqd */, X86::MMX_PCMPEQDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4891 /* pcmpeqq */, X86::PCMPEQQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4891 /* pcmpeqq */, X86::PCMPEQQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4899 /* pcmpeqw */, X86::MMX_PCMPEQWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4899 /* pcmpeqw */, X86::PCMPEQWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4899 /* pcmpeqw */, X86::PCMPEQWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4899 /* pcmpeqw */, X86::MMX_PCMPEQWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4907 /* pcmpestri */, X86::PCMPESTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4907 /* pcmpestri */, X86::PCMPESTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4917 /* pcmpestrm */, X86::PCMPESTRM128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4917 /* pcmpestrm */, X86::PCMPESTRM128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4927 /* pcmpgtb */, X86::MMX_PCMPGTBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4927 /* pcmpgtb */, X86::PCMPGTBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4927 /* pcmpgtb */, X86::PCMPGTBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4927 /* pcmpgtb */, X86::MMX_PCMPGTBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4935 /* pcmpgtd */, X86::MMX_PCMPGTDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4935 /* pcmpgtd */, X86::PCMPGTDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4935 /* pcmpgtd */, X86::PCMPGTDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4935 /* pcmpgtd */, X86::MMX_PCMPGTDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4943 /* pcmpgtq */, X86::PCMPGTQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4943 /* pcmpgtq */, X86::PCMPGTQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4951 /* pcmpgtw */, X86::MMX_PCMPGTWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 4951 /* pcmpgtw */, X86::PCMPGTWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 4951 /* pcmpgtw */, X86::PCMPGTWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 4951 /* pcmpgtw */, X86::MMX_PCMPGTWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 4959 /* pcmpistri */, X86::PCMPISTRIrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4959 /* pcmpistri */, X86::PCMPISTRIrm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4969 /* pcmpistrm */, X86::PCMPISTRM128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 4969 /* pcmpistrm */, X86::PCMPISTRM128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 4979 /* pcommit */, X86::PCOMMIT, Convert_NoOperands, 0, {  }, },
  { 4992 /* pdepl */, X86::PDEP32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 4992 /* pdepl */, X86::PDEP32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 4998 /* pdepq */, X86::PDEP64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 4998 /* pdepq */, X86::PDEP64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5009 /* pextl */, X86::PEXT32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 5009 /* pextl */, X86::PEXT32rm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32, MCK_GR32 }, },
  { 5015 /* pextq */, X86::PEXT64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 5015 /* pextq */, X86::PEXT64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64, MCK_GR64 }, },
  { 5021 /* pextrb */, X86::PEXTRBrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 5021 /* pextrb */, X86::PEXTRBmr, Convert__Mem85_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem8 }, },
  { 5028 /* pextrd */, X86::PEXTRDrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32 }, },
  { 5028 /* pextrd */, X86::PEXTRDmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 5035 /* pextrq */, X86::PEXTRQrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR64 }, },
  { 5035 /* pextrq */, X86::PEXTRQmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem64 }, },
  { 5042 /* pextrw */, X86::MMX_PEXTRWirri, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_GR32orGR64 }, },
  { 5042 /* pextrw */, X86::PEXTRWri, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 5042 /* pextrw */, X86::PEXTRWmr, Convert__Mem165_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem16 }, },
  { 5049 /* pf2id */, X86::PF2IDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5049 /* pf2id */, X86::PF2IDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5055 /* pf2iw */, X86::PF2IWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5055 /* pf2iw */, X86::PF2IWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5061 /* pfacc */, X86::PFACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5061 /* pfacc */, X86::PFACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5067 /* pfadd */, X86::PFADDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5067 /* pfadd */, X86::PFADDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5073 /* pfcmpeq */, X86::PFCMPEQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5073 /* pfcmpeq */, X86::PFCMPEQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5081 /* pfcmpge */, X86::PFCMPGErr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5081 /* pfcmpge */, X86::PFCMPGErm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5089 /* pfcmpgt */, X86::PFCMPGTrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5089 /* pfcmpgt */, X86::PFCMPGTrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5097 /* pfmax */, X86::PFMAXrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5097 /* pfmax */, X86::PFMAXrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5103 /* pfmin */, X86::PFMINrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5103 /* pfmin */, X86::PFMINrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5109 /* pfmul */, X86::PFMULrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5109 /* pfmul */, X86::PFMULrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5115 /* pfnacc */, X86::PFNACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5115 /* pfnacc */, X86::PFNACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5122 /* pfpnacc */, X86::PFPNACCrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5122 /* pfpnacc */, X86::PFPNACCrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5130 /* pfrcp */, X86::PFRCPrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5130 /* pfrcp */, X86::PFRCPrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5136 /* pfrcpit1 */, X86::PFRCPIT1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5136 /* pfrcpit1 */, X86::PFRCPIT1rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5145 /* pfrcpit2 */, X86::PFRCPIT2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5145 /* pfrcpit2 */, X86::PFRCPIT2rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5154 /* pfrsqit1 */, X86::PFRSQIT1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5154 /* pfrsqit1 */, X86::PFRSQIT1rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5163 /* pfrsqrt */, X86::PFRSQRTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5163 /* pfrsqrt */, X86::PFRSQRTrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5171 /* pfsub */, X86::PFSUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5171 /* pfsub */, X86::PFSUBrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5177 /* pfsubr */, X86::PFSUBRrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5177 /* pfsubr */, X86::PFSUBRrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5184 /* phaddd */, X86::MMX_PHADDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5184 /* phaddd */, X86::PHADDDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5184 /* phaddd */, X86::PHADDDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5184 /* phaddd */, X86::MMX_PHADDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5191 /* phaddsw */, X86::MMX_PHADDSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5191 /* phaddsw */, X86::PHADDSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5191 /* phaddsw */, X86::PHADDSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5191 /* phaddsw */, X86::MMX_PHADDSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5199 /* phaddw */, X86::MMX_PHADDWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5199 /* phaddw */, X86::PHADDWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5199 /* phaddw */, X86::PHADDWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5199 /* phaddw */, X86::MMX_PHADDWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5206 /* phminposuw */, X86::PHMINPOSUWrr128, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5206 /* phminposuw */, X86::PHMINPOSUWrm128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5217 /* phsubd */, X86::MMX_PHSUBDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5217 /* phsubd */, X86::PHSUBDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5217 /* phsubd */, X86::PHSUBDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5217 /* phsubd */, X86::MMX_PHSUBDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5224 /* phsubsw */, X86::MMX_PHSUBSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5224 /* phsubsw */, X86::PHSUBSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5224 /* phsubsw */, X86::PHSUBSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5224 /* phsubsw */, X86::MMX_PHSUBSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5232 /* phsubw */, X86::MMX_PHSUBWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5232 /* phsubw */, X86::PHSUBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5232 /* phsubw */, X86::PHSUBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5232 /* phsubw */, X86::MMX_PHSUBWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5239 /* pi2fd */, X86::PI2FDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5239 /* pi2fd */, X86::PI2FDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5245 /* pi2fw */, X86::PI2FWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5245 /* pi2fw */, X86::PI2FWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5251 /* pinsrb */, X86::PINSRBrr, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR32 }, },
  { 5251 /* pinsrb */, X86::PINSRBrm, Convert__Reg1_2__Tie0__Mem85_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem8, MCK_FR32 }, },
  { 5258 /* pinsrd */, X86::PINSRDrr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32, MCK_FR32 }, },
  { 5258 /* pinsrd */, X86::PINSRDrm, Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 5265 /* pinsrq */, X86::PINSRQrr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR64, MCK_FR32 }, },
  { 5265 /* pinsrq */, X86::PINSRQrm, Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 5272 /* pinsrw */, X86::MMX_PINSRWirri, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_VR64 }, },
  { 5272 /* pinsrw */, X86::PINSRWrri, Convert__Reg1_2__Tie0__GR32orGR641_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_GR32orGR64, MCK_FR32 }, },
  { 5272 /* pinsrw */, X86::MMX_PINSRWirmi, Convert__Reg1_2__Tie0__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_VR64 }, },
  { 5272 /* pinsrw */, X86::PINSRWrmi, Convert__Reg1_2__Tie0__Mem165_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem16, MCK_FR32 }, },
  { 5279 /* pmaddubsw */, X86::MMX_PMADDUBSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5279 /* pmaddubsw */, X86::PMADDUBSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5279 /* pmaddubsw */, X86::PMADDUBSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5279 /* pmaddubsw */, X86::MMX_PMADDUBSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5289 /* pmaddwd */, X86::MMX_PMADDWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5289 /* pmaddwd */, X86::PMADDWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5289 /* pmaddwd */, X86::PMADDWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5289 /* pmaddwd */, X86::MMX_PMADDWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5297 /* pmaxsb */, X86::PMAXSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5297 /* pmaxsb */, X86::PMAXSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5304 /* pmaxsd */, X86::PMAXSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5304 /* pmaxsd */, X86::PMAXSDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5311 /* pmaxsw */, X86::MMX_PMAXSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5311 /* pmaxsw */, X86::PMAXSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5311 /* pmaxsw */, X86::PMAXSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5311 /* pmaxsw */, X86::MMX_PMAXSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5318 /* pmaxub */, X86::MMX_PMAXUBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5318 /* pmaxub */, X86::PMAXUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5318 /* pmaxub */, X86::PMAXUBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5318 /* pmaxub */, X86::MMX_PMAXUBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5325 /* pmaxud */, X86::PMAXUDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5325 /* pmaxud */, X86::PMAXUDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5332 /* pmaxuw */, X86::PMAXUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5332 /* pmaxuw */, X86::PMAXUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5339 /* pminsb */, X86::PMINSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5339 /* pminsb */, X86::PMINSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5346 /* pminsd */, X86::PMINSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5346 /* pminsd */, X86::PMINSDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5353 /* pminsw */, X86::MMX_PMINSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5353 /* pminsw */, X86::PMINSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5353 /* pminsw */, X86::PMINSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5353 /* pminsw */, X86::MMX_PMINSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5360 /* pminub */, X86::MMX_PMINUBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5360 /* pminub */, X86::PMINUBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5360 /* pminub */, X86::PMINUBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5360 /* pminub */, X86::MMX_PMINUBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5367 /* pminud */, X86::PMINUDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5367 /* pminud */, X86::PMINUDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5374 /* pminuw */, X86::PMINUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5374 /* pminuw */, X86::PMINUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5381 /* pmovmskb */, X86::MMX_PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_VR64, MCK_GR32orGR64 }, },
  { 5381 /* pmovmskb */, X86::PMOVMSKBrr, Convert__GR32orGR641_1__Reg1_0, 0, { MCK_FR32, MCK_GR32orGR64 }, },
  { 5390 /* pmovsxbd */, X86::PMOVSXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5390 /* pmovsxbd */, X86::PMOVSXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5399 /* pmovsxbq */, X86::PMOVSXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5399 /* pmovsxbq */, X86::PMOVSXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5408 /* pmovsxbw */, X86::PMOVSXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5408 /* pmovsxbw */, X86::PMOVSXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5417 /* pmovsxdq */, X86::PMOVSXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5417 /* pmovsxdq */, X86::PMOVSXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5426 /* pmovsxwd */, X86::PMOVSXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5426 /* pmovsxwd */, X86::PMOVSXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5435 /* pmovsxwq */, X86::PMOVSXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5435 /* pmovsxwq */, X86::PMOVSXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5444 /* pmovzxbd */, X86::PMOVZXBDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5444 /* pmovzxbd */, X86::PMOVZXBDrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5453 /* pmovzxbq */, X86::PMOVZXBQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5453 /* pmovzxbq */, X86::PMOVZXBQrm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_FR32 }, },
  { 5462 /* pmovzxbw */, X86::PMOVZXBWrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5462 /* pmovzxbw */, X86::PMOVZXBWrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5471 /* pmovzxdq */, X86::PMOVZXDQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5471 /* pmovzxdq */, X86::PMOVZXDQrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5480 /* pmovzxwd */, X86::PMOVZXWDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5480 /* pmovzxwd */, X86::PMOVZXWDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 5489 /* pmovzxwq */, X86::PMOVZXWQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5489 /* pmovzxwq */, X86::PMOVZXWQrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 5498 /* pmuldq */, X86::PMULDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5498 /* pmuldq */, X86::PMULDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5505 /* pmulhrsw */, X86::MMX_PMULHRSWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5505 /* pmulhrsw */, X86::PMULHRSWrr128, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5505 /* pmulhrsw */, X86::PMULHRSWrm128, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5505 /* pmulhrsw */, X86::MMX_PMULHRSWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5514 /* pmulhrw */, X86::PMULHRWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5514 /* pmulhrw */, X86::PMULHRWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5522 /* pmulhuw */, X86::MMX_PMULHUWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5522 /* pmulhuw */, X86::PMULHUWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5522 /* pmulhuw */, X86::PMULHUWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5522 /* pmulhuw */, X86::MMX_PMULHUWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5530 /* pmulhw */, X86::MMX_PMULHWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5530 /* pmulhw */, X86::PMULHWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5530 /* pmulhw */, X86::PMULHWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5530 /* pmulhw */, X86::MMX_PMULHWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5537 /* pmulld */, X86::PMULLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5537 /* pmulld */, X86::PMULLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5544 /* pmullw */, X86::MMX_PMULLWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5544 /* pmullw */, X86::PMULLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5544 /* pmullw */, X86::PMULLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5544 /* pmullw */, X86::MMX_PMULLWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5551 /* pmuludq */, X86::MMX_PMULUDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5551 /* pmuludq */, X86::PMULUDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5551 /* pmuludq */, X86::PMULUDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5551 /* pmuludq */, X86::MMX_PMULUDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5563 /* popal */, X86::POPA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5569 /* popaw */, X86::POPA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5582 /* popcntl */, X86::POPCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 5582 /* popcntl */, X86::POPCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 5590 /* popcntq */, X86::POPCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 5590 /* popcntq */, X86::POPCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 5598 /* popcntw */, X86::POPCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 5598 /* popcntw */, X86::POPCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 5617 /* popfl */, X86::POPF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 5623 /* popfq */, X86::POPF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 5629 /* popfw */, X86::POPF16, Convert_NoOperands, 0, {  }, },
  { 5635 /* popl */, X86::POP32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5635 /* popl */, X86::POP32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 5635 /* popl */, X86::POPDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5635 /* popl */, X86::POPSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5635 /* popl */, X86::POPES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5635 /* popl */, X86::POPFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 5635 /* popl */, X86::POPGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 5635 /* popl */, X86::POP32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 5640 /* popq */, X86::POP64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5640 /* popq */, X86::POP64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 5640 /* popq */, X86::POPFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 5640 /* popq */, X86::POPGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 5640 /* popq */, X86::POP64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 5645 /* popw */, X86::POP16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5645 /* popw */, X86::POP16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 5645 /* popw */, X86::POPDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 5645 /* popw */, X86::POPSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 5645 /* popw */, X86::POPES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 5645 /* popw */, X86::POPFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 5645 /* popw */, X86::POPGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 5645 /* popw */, X86::POP16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 5650 /* por */, X86::MMX_PORirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5650 /* por */, X86::PORrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5650 /* por */, X86::PORrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5650 /* por */, X86::MMX_PORirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5654 /* prefetch */, X86::PREFETCH, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5663 /* prefetchnta */, X86::PREFETCHNTA, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5675 /* prefetcht0 */, X86::PREFETCHT0, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5686 /* prefetcht1 */, X86::PREFETCHT1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5697 /* prefetcht2 */, X86::PREFETCHT2, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5708 /* prefetchw */, X86::PREFETCHW, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 5718 /* psadbw */, X86::MMX_PSADBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5718 /* psadbw */, X86::PSADBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5718 /* psadbw */, X86::PSADBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5718 /* psadbw */, X86::MMX_PSADBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5725 /* pshufb */, X86::MMX_PSHUFBrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5725 /* pshufb */, X86::PSHUFBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5725 /* pshufb */, X86::PSHUFBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5725 /* pshufb */, X86::MMX_PSHUFBrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5732 /* pshufd */, X86::PSHUFDri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5732 /* pshufd */, X86::PSHUFDmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5739 /* pshufhw */, X86::PSHUFHWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5739 /* pshufhw */, X86::PSHUFHWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5747 /* pshuflw */, X86::PSHUFLWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 5747 /* pshuflw */, X86::PSHUFLWmi, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 5755 /* pshufw */, X86::MMX_PSHUFWri, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64, MCK_VR64 }, },
  { 5755 /* pshufw */, X86::MMX_PSHUFWmi, Convert__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_VR64 }, },
  { 5762 /* psignb */, X86::MMX_PSIGNBrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5762 /* psignb */, X86::PSIGNBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5762 /* psignb */, X86::PSIGNBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5762 /* psignb */, X86::MMX_PSIGNBrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5769 /* psignd */, X86::MMX_PSIGNDrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5769 /* psignd */, X86::PSIGNDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5769 /* psignd */, X86::PSIGNDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5769 /* psignd */, X86::MMX_PSIGNDrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5776 /* psignw */, X86::MMX_PSIGNWrr64, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5776 /* psignw */, X86::PSIGNWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5776 /* psignw */, X86::PSIGNWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5776 /* psignw */, X86::MMX_PSIGNWrm64, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5783 /* pslld */, X86::MMX_PSLLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5783 /* pslld */, X86::PSLLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5783 /* pslld */, X86::MMX_PSLLDri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5783 /* pslld */, X86::PSLLDri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5783 /* pslld */, X86::PSLLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5783 /* pslld */, X86::MMX_PSLLDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5789 /* pslldq */, X86::PSLLDQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5796 /* psllq */, X86::MMX_PSLLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5796 /* psllq */, X86::PSLLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5796 /* psllq */, X86::MMX_PSLLQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5796 /* psllq */, X86::PSLLQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5796 /* psllq */, X86::PSLLQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5796 /* psllq */, X86::MMX_PSLLQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5802 /* psllw */, X86::MMX_PSLLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5802 /* psllw */, X86::PSLLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5802 /* psllw */, X86::MMX_PSLLWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5802 /* psllw */, X86::PSLLWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5802 /* psllw */, X86::PSLLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5802 /* psllw */, X86::MMX_PSLLWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5808 /* psrad */, X86::MMX_PSRADrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5808 /* psrad */, X86::PSRADrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5808 /* psrad */, X86::MMX_PSRADri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5808 /* psrad */, X86::PSRADri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5808 /* psrad */, X86::PSRADrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5808 /* psrad */, X86::MMX_PSRADrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5814 /* psraw */, X86::MMX_PSRAWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5814 /* psraw */, X86::PSRAWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5814 /* psraw */, X86::MMX_PSRAWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5814 /* psraw */, X86::PSRAWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5814 /* psraw */, X86::PSRAWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5814 /* psraw */, X86::MMX_PSRAWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5820 /* psrld */, X86::MMX_PSRLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5820 /* psrld */, X86::PSRLDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5820 /* psrld */, X86::MMX_PSRLDri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5820 /* psrld */, X86::PSRLDri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5820 /* psrld */, X86::PSRLDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5820 /* psrld */, X86::MMX_PSRLDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5826 /* psrldq */, X86::PSRLDQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5833 /* psrlq */, X86::MMX_PSRLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5833 /* psrlq */, X86::PSRLQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5833 /* psrlq */, X86::MMX_PSRLQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5833 /* psrlq */, X86::PSRLQri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5833 /* psrlq */, X86::PSRLQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5833 /* psrlq */, X86::MMX_PSRLQrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5839 /* psrlw */, X86::MMX_PSRLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5839 /* psrlw */, X86::PSRLWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5839 /* psrlw */, X86::MMX_PSRLWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR64 }, },
  { 5839 /* psrlw */, X86::PSRLWri, Convert__Reg1_1__Tie0__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32 }, },
  { 5839 /* psrlw */, X86::PSRLWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5839 /* psrlw */, X86::MMX_PSRLWrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5845 /* psubb */, X86::MMX_PSUBBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5845 /* psubb */, X86::PSUBBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5845 /* psubb */, X86::PSUBBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5845 /* psubb */, X86::MMX_PSUBBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5851 /* psubd */, X86::MMX_PSUBDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5851 /* psubd */, X86::PSUBDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5851 /* psubd */, X86::PSUBDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5851 /* psubd */, X86::MMX_PSUBDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5857 /* psubq */, X86::MMX_PSUBQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5857 /* psubq */, X86::PSUBQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5857 /* psubq */, X86::PSUBQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5857 /* psubq */, X86::MMX_PSUBQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5863 /* psubsb */, X86::MMX_PSUBSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5863 /* psubsb */, X86::PSUBSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5863 /* psubsb */, X86::PSUBSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5863 /* psubsb */, X86::MMX_PSUBSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5870 /* psubsw */, X86::MMX_PSUBSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5870 /* psubsw */, X86::PSUBSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5870 /* psubsw */, X86::PSUBSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5870 /* psubsw */, X86::MMX_PSUBSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5877 /* psubusb */, X86::MMX_PSUBUSBirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5877 /* psubusb */, X86::PSUBUSBrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5877 /* psubusb */, X86::PSUBUSBrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5877 /* psubusb */, X86::MMX_PSUBUSBirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5885 /* psubusw */, X86::MMX_PSUBUSWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5885 /* psubusw */, X86::PSUBUSWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5885 /* psubusw */, X86::PSUBUSWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5885 /* psubusw */, X86::MMX_PSUBUSWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5893 /* psubw */, X86::MMX_PSUBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5893 /* psubw */, X86::PSUBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5893 /* psubw */, X86::PSUBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5893 /* psubw */, X86::MMX_PSUBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5899 /* pswapd */, X86::PSWAPDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5899 /* pswapd */, X86::PSWAPDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5906 /* ptest */, X86::PTESTrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5906 /* ptest */, X86::PTESTrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5912 /* punpckhbw */, X86::MMX_PUNPCKHBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5912 /* punpckhbw */, X86::PUNPCKHBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5912 /* punpckhbw */, X86::PUNPCKHBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5912 /* punpckhbw */, X86::MMX_PUNPCKHBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5922 /* punpckhdq */, X86::MMX_PUNPCKHDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5922 /* punpckhdq */, X86::PUNPCKHDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5922 /* punpckhdq */, X86::PUNPCKHDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5922 /* punpckhdq */, X86::MMX_PUNPCKHDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5932 /* punpckhqdq */, X86::PUNPCKHQDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5932 /* punpckhqdq */, X86::PUNPCKHQDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5943 /* punpckhwd */, X86::MMX_PUNPCKHWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5943 /* punpckhwd */, X86::PUNPCKHWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5943 /* punpckhwd */, X86::PUNPCKHWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5943 /* punpckhwd */, X86::MMX_PUNPCKHWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5953 /* punpcklbw */, X86::MMX_PUNPCKLBWirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5953 /* punpcklbw */, X86::PUNPCKLBWrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5953 /* punpcklbw */, X86::PUNPCKLBWrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5953 /* punpcklbw */, X86::MMX_PUNPCKLBWirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5963 /* punpckldq */, X86::MMX_PUNPCKLDQirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5963 /* punpckldq */, X86::PUNPCKLDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5963 /* punpckldq */, X86::PUNPCKLDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5963 /* punpckldq */, X86::MMX_PUNPCKLDQirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5973 /* punpcklqdq */, X86::PUNPCKLQDQrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5973 /* punpcklqdq */, X86::PUNPCKLQDQrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5984 /* punpcklwd */, X86::MMX_PUNPCKLWDirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 5984 /* punpcklwd */, X86::PUNPCKLWDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 5984 /* punpcklwd */, X86::PUNPCKLWDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 5984 /* punpcklwd */, X86::MMX_PUNPCKLWDirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 5999 /* pushal */, X86::PUSHA32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6006 /* pushaw */, X86::PUSHA16, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6026 /* pushfl */, X86::PUSHF32, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6033 /* pushfq */, X86::PUSHF64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6040 /* pushfw */, X86::PUSHF16, Convert_NoOperands, 0, {  }, },
  { 6047 /* pushl */, X86::PUSH32r, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 6047 /* pushl */, X86::PUSH32rmr, Convert__Reg1_0, Feature_Not64BitMode, { MCK_GR32 }, },
  { 6047 /* pushl */, X86::PUSHCS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 6047 /* pushl */, X86::PUSHDS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6047 /* pushl */, X86::PUSHSS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6047 /* pushl */, X86::PUSHES32, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6047 /* pushl */, X86::PUSHFS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_FS }, },
  { 6047 /* pushl */, X86::PUSHGS32, Convert_NoOperands, Feature_Not64BitMode, { MCK_GS }, },
  { 6047 /* pushl */, X86::PUSH32i8, Convert__ImmSExti32i81_0, Feature_Not64BitMode, { MCK_ImmSExti32i8 }, },
  { 6047 /* pushl */, X86::PUSHi32, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 6047 /* pushl */, X86::PUSH32rmm, Convert__Mem325_0, Feature_Not64BitMode, { MCK_Mem32 }, },
  { 6053 /* pushq */, X86::PUSH64r, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6053 /* pushq */, X86::PUSH64rmr, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6053 /* pushq */, X86::PUSHFS64, Convert_NoOperands, Feature_In64BitMode, { MCK_FS }, },
  { 6053 /* pushq */, X86::PUSHGS64, Convert_NoOperands, Feature_In64BitMode, { MCK_GS }, },
  { 6053 /* pushq */, X86::PUSH64i8, Convert__ImmSExti64i81_0, Feature_In64BitMode, { MCK_ImmSExti64i8 }, },
  { 6053 /* pushq */, X86::PUSH64i32, Convert__ImmSExti64i321_0, Feature_In64BitMode, { MCK_ImmSExti64i32 }, },
  { 6053 /* pushq */, X86::PUSH64rmm, Convert__Mem645_0, Feature_In64BitMode, { MCK_Mem64 }, },
  { 6059 /* pushw */, X86::PUSH16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6059 /* pushw */, X86::PUSH16rmr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6059 /* pushw */, X86::PUSHCS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_CS }, },
  { 6059 /* pushw */, X86::PUSHDS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_DS }, },
  { 6059 /* pushw */, X86::PUSHSS16, Convert_NoOperands, Feature_Not64BitMode, { MCK_SS }, },
  { 6059 /* pushw */, X86::PUSHES16, Convert_NoOperands, Feature_Not64BitMode, { MCK_ES }, },
  { 6059 /* pushw */, X86::PUSHFS16, Convert_NoOperands, 0, { MCK_FS }, },
  { 6059 /* pushw */, X86::PUSHGS16, Convert_NoOperands, 0, { MCK_GS }, },
  { 6059 /* pushw */, X86::PUSH16i8, Convert__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8 }, },
  { 6059 /* pushw */, X86::PUSHi16, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 6059 /* pushw */, X86::PUSH16rmm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6065 /* pxor */, X86::MMX_PXORirr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_VR64, MCK_VR64 }, },
  { 6065 /* pxor */, X86::PXORrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6065 /* pxor */, X86::PXORrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6065 /* pxor */, X86::MMX_PXORirm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_VR64 }, },
  { 6074 /* rclb */, X86::RCL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6074 /* rclb */, X86::RCL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6074 /* rclb */, X86::RCL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6074 /* rclb */, X86::RCL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6074 /* rclb */, X86::RCL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6074 /* rclb */, X86::RCL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6079 /* rcll */, X86::RCL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6079 /* rcll */, X86::RCL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6079 /* rcll */, X86::RCL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6079 /* rcll */, X86::RCL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6079 /* rcll */, X86::RCL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6079 /* rcll */, X86::RCL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6084 /* rclq */, X86::RCL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6084 /* rclq */, X86::RCL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6084 /* rclq */, X86::RCL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6084 /* rclq */, X86::RCL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6084 /* rclq */, X86::RCL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6084 /* rclq */, X86::RCL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6089 /* rclw */, X86::RCL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6089 /* rclw */, X86::RCL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6089 /* rclw */, X86::RCL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6089 /* rclw */, X86::RCL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6089 /* rclw */, X86::RCL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6089 /* rclw */, X86::RCL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6094 /* rcpps */, X86::RCPPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6094 /* rcpps */, X86::RCPPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6100 /* rcpss */, X86::RCPSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6100 /* rcpss */, X86::RCPSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6110 /* rcrb */, X86::RCR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6110 /* rcrb */, X86::RCR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6110 /* rcrb */, X86::RCR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6110 /* rcrb */, X86::RCR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6110 /* rcrb */, X86::RCR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6110 /* rcrb */, X86::RCR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6115 /* rcrl */, X86::RCR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6115 /* rcrl */, X86::RCR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6115 /* rcrl */, X86::RCR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6115 /* rcrl */, X86::RCR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6115 /* rcrl */, X86::RCR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6115 /* rcrl */, X86::RCR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6120 /* rcrq */, X86::RCR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6120 /* rcrq */, X86::RCR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6120 /* rcrq */, X86::RCR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6120 /* rcrq */, X86::RCR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6120 /* rcrq */, X86::RCR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6120 /* rcrq */, X86::RCR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6125 /* rcrw */, X86::RCR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6125 /* rcrw */, X86::RCR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6125 /* rcrw */, X86::RCR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6125 /* rcrw */, X86::RCR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6125 /* rcrw */, X86::RCR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6125 /* rcrw */, X86::RCR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6139 /* rdfsbasel */, X86::RDFSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 6149 /* rdfsbaseq */, X86::RDFSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6168 /* rdgsbasel */, X86::RDGSBASE, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR32 }, },
  { 6178 /* rdgsbaseq */, X86::RDGSBASE64, Convert__Reg1_0, Feature_In64BitMode, { MCK_GR64 }, },
  { 6188 /* rdmsr */, X86::RDMSR, Convert_NoOperands, 0, {  }, },
  { 6194 /* rdpmc */, X86::RDPMC, Convert_NoOperands, 0, {  }, },
  { 6207 /* rdrandl */, X86::RDRAND32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6215 /* rdrandq */, X86::RDRAND64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6223 /* rdrandw */, X86::RDRAND16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6238 /* rdseedl */, X86::RDSEED32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6246 /* rdseedq */, X86::RDSEED64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6254 /* rdseedw */, X86::RDSEED16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6262 /* rdtsc */, X86::RDTSC, Convert_NoOperands, 0, {  }, },
  { 6268 /* rdtscp */, X86::RDTSCP, Convert_NoOperands, 0, {  }, },
  { 6275 /* rep */, X86::REP_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6279 /* repne */, X86::REPNE_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6300 /* retl */, X86::RETL, Convert_NoOperands, Feature_Not64BitMode, {  }, },
  { 6300 /* retl */, X86::RETIL, Convert__Imm1_0, Feature_Not64BitMode, { MCK_Imm }, },
  { 6305 /* retq */, X86::RETQ, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6305 /* retq */, X86::RETIQ, Convert__Imm1_0, Feature_In64BitMode, { MCK_Imm }, },
  { 6310 /* retw */, X86::RETW, Convert_NoOperands, 0, {  }, },
  { 6310 /* retw */, X86::RETIW, Convert__Imm1_0, 0, { MCK_Imm }, },
  { 6315 /* rex64 */, X86::REX64_PREFIX, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 6325 /* rolb */, X86::ROL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6325 /* rolb */, X86::ROL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6325 /* rolb */, X86::ROL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6325 /* rolb */, X86::ROL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6325 /* rolb */, X86::ROL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6325 /* rolb */, X86::ROL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6330 /* roll */, X86::ROL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6330 /* roll */, X86::ROL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6330 /* roll */, X86::ROL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6330 /* roll */, X86::ROL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6330 /* roll */, X86::ROL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6330 /* roll */, X86::ROL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6335 /* rolq */, X86::ROL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6335 /* rolq */, X86::ROL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6335 /* rolq */, X86::ROL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6335 /* rolq */, X86::ROL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6335 /* rolq */, X86::ROL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6335 /* rolq */, X86::ROL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6340 /* rolw */, X86::ROL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6340 /* rolw */, X86::ROL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6340 /* rolw */, X86::ROL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6340 /* rolw */, X86::ROL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6340 /* rolw */, X86::ROL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6340 /* rolw */, X86::ROL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6349 /* rorb */, X86::ROR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6349 /* rorb */, X86::ROR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6349 /* rorb */, X86::ROR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6349 /* rorb */, X86::ROR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6349 /* rorb */, X86::ROR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6349 /* rorb */, X86::ROR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6354 /* rorl */, X86::ROR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6354 /* rorl */, X86::ROR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6354 /* rorl */, X86::ROR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6354 /* rorl */, X86::ROR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6354 /* rorl */, X86::ROR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6354 /* rorl */, X86::ROR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6359 /* rorq */, X86::ROR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6359 /* rorq */, X86::ROR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6359 /* rorq */, X86::ROR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6359 /* rorq */, X86::ROR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6359 /* rorq */, X86::ROR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6359 /* rorq */, X86::ROR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6364 /* rorw */, X86::ROR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6364 /* rorw */, X86::ROR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6364 /* rorw */, X86::ROR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6364 /* rorw */, X86::ROR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6364 /* rorw */, X86::ROR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6364 /* rorw */, X86::ROR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6374 /* rorxl */, X86::RORX32ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6374 /* rorxl */, X86::RORX32mi, Convert__Reg1_2__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32, MCK_GR32 }, },
  { 6380 /* rorxq */, X86::RORX64ri, Convert__Reg1_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6380 /* rorxq */, X86::RORX64mi, Convert__Reg1_2__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64, MCK_GR64 }, },
  { 6386 /* roundpd */, X86::ROUNDPDr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6386 /* roundpd */, X86::ROUNDPDm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6394 /* roundps */, X86::ROUNDPSr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6394 /* roundps */, X86::ROUNDPSm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6402 /* roundsd */, X86::ROUNDSDr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6402 /* roundsd */, X86::ROUNDSDm, Convert__Reg1_2__Tie0__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32 }, },
  { 6410 /* roundss */, X86::ROUNDSSr, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6410 /* roundss */, X86::ROUNDSSm, Convert__Reg1_2__Tie0__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32 }, },
  { 6418 /* rsm */, X86::RSM, Convert_NoOperands, 0, {  }, },
  { 6422 /* rsqrtps */, X86::RSQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6422 /* rsqrtps */, X86::RSQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6430 /* rsqrtss */, X86::RSQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6430 /* rsqrtss */, X86::RSQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6438 /* sahf */, X86::SAHF, Convert_NoOperands, 0, {  }, },
  { 6447 /* sarb */, X86::SAR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6447 /* sarb */, X86::SAR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6447 /* sarb */, X86::SAR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6447 /* sarb */, X86::SAR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6447 /* sarb */, X86::SAR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6447 /* sarb */, X86::SAR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6452 /* sarl */, X86::SAR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6452 /* sarl */, X86::SAR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6452 /* sarl */, X86::SAR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6452 /* sarl */, X86::SAR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6452 /* sarl */, X86::SAR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6452 /* sarl */, X86::SAR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6457 /* sarq */, X86::SAR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6457 /* sarq */, X86::SAR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6457 /* sarq */, X86::SAR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6457 /* sarq */, X86::SAR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6457 /* sarq */, X86::SAR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6457 /* sarq */, X86::SAR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6462 /* sarw */, X86::SAR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6462 /* sarw */, X86::SAR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6462 /* sarw */, X86::SAR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6462 /* sarw */, X86::SAR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6462 /* sarw */, X86::SAR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6462 /* sarw */, X86::SAR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6472 /* sarxl */, X86::SARX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6472 /* sarxl */, X86::SARX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6478 /* sarxq */, X86::SARX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6478 /* sarxq */, X86::SARX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6488 /* sbbb */, X86::SBB8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 6488 /* sbbb */, X86::SBB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 6488 /* sbbb */, X86::SBB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 6488 /* sbbb */, X86::SBB8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6488 /* sbbb */, X86::SBB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6488 /* sbbb */, X86::SBB8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 6493 /* sbbl */, X86::SBB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6493 /* sbbl */, X86::SBB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6493 /* sbbl */, X86::SBB32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 6493 /* sbbl */, X86::SBB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 6493 /* sbbl */, X86::SBB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 6493 /* sbbl */, X86::SBB32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6493 /* sbbl */, X86::SBB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6493 /* sbbl */, X86::SBB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 6498 /* sbbq */, X86::SBB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6498 /* sbbq */, X86::SBB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6498 /* sbbq */, X86::SBB64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 6498 /* sbbq */, X86::SBB64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 6498 /* sbbq */, X86::SBB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 6498 /* sbbq */, X86::SBB64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 6498 /* sbbq */, X86::SBB64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 6498 /* sbbq */, X86::SBB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 6503 /* sbbw */, X86::SBB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6503 /* sbbw */, X86::SBB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6503 /* sbbw */, X86::SBB16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 6503 /* sbbw */, X86::SBB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 6503 /* sbbw */, X86::SBB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 6503 /* sbbw */, X86::SBB16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6503 /* sbbw */, X86::SBB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6503 /* sbbw */, X86::SBB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 6508 /* scas */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 6508 /* scas */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 6508 /* scas */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64, MCK_RAX }, },
  { 6508 /* scas */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 6513 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 6513 /* scasb */, X86::SCASB, Convert__DstIdx81_0, 0, { MCK_DstIdx8, MCK_AL }, },
  { 6525 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 6525 /* scasl */, X86::SCASL, Convert__DstIdx321_0, 0, { MCK_DstIdx32, MCK_EAX }, },
  { 6531 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 6531 /* scasq */, X86::SCASQ, Convert__DstIdx641_0, 0, { MCK_DstIdx64, MCK_RAX }, },
  { 6537 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 6537 /* scasw */, X86::SCASW, Convert__DstIdx161_0, 0, { MCK_DstIdx16, MCK_AX }, },
  { 6543 /* seta */, X86::SETAr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6543 /* seta */, X86::SETAm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6548 /* setae */, X86::SETAEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6548 /* setae */, X86::SETAEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6554 /* setb */, X86::SETBr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6554 /* setb */, X86::SETBm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6559 /* setbe */, X86::SETBEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6559 /* setbe */, X86::SETBEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6565 /* sete */, X86::SETEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6565 /* sete */, X86::SETEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6570 /* setg */, X86::SETGr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6570 /* setg */, X86::SETGm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6575 /* setge */, X86::SETGEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6575 /* setge */, X86::SETGEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6581 /* setl */, X86::SETLr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6581 /* setl */, X86::SETLm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6586 /* setle */, X86::SETLEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6586 /* setle */, X86::SETLEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6592 /* setne */, X86::SETNEr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6592 /* setne */, X86::SETNEm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6598 /* setno */, X86::SETNOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6598 /* setno */, X86::SETNOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6604 /* setnp */, X86::SETNPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6604 /* setnp */, X86::SETNPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6610 /* setns */, X86::SETNSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6610 /* setns */, X86::SETNSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6616 /* seto */, X86::SETOr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6616 /* seto */, X86::SETOm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6621 /* setp */, X86::SETPr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6621 /* setp */, X86::SETPm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6626 /* sets */, X86::SETSr, Convert__Reg1_0, 0, { MCK_GR8 }, },
  { 6626 /* sets */, X86::SETSm, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6631 /* sfence */, X86::SFENCE, Convert_NoOperands, 0, {  }, },
  { 6643 /* sgdtl */, X86::SGDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6649 /* sgdtq */, X86::SGDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 6655 /* sgdtw */, X86::SGDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6661 /* sha1msg1 */, X86::SHA1MSG1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6661 /* sha1msg1 */, X86::SHA1MSG1rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6670 /* sha1msg2 */, X86::SHA1MSG2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6670 /* sha1msg2 */, X86::SHA1MSG2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6679 /* sha1nexte */, X86::SHA1NEXTErr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6679 /* sha1nexte */, X86::SHA1NEXTErm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6689 /* sha1rnds4 */, X86::SHA1RNDS4rri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6689 /* sha1rnds4 */, X86::SHA1RNDS4rmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6699 /* sha256msg1 */, X86::SHA256MSG1rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6699 /* sha256msg1 */, X86::SHA256MSG1rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6710 /* sha256msg2 */, X86::SHA256MSG2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6710 /* sha256msg2 */, X86::SHA256MSG2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6721 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6721 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6721 /* sha256rnds2 */, X86::SHA256RNDS2rr, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_XMM0, MCK_FR32, MCK_FR32 }, },
  { 6721 /* sha256rnds2 */, X86::SHA256RNDS2rm, Convert__Reg1_2__Tie0__Mem1285_1, 0, { MCK_XMM0, MCK_Mem128, MCK_FR32 }, },
  { 6737 /* shlb */, X86::SHL8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6737 /* shlb */, X86::SHL8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6737 /* shlb */, X86::SHL8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6737 /* shlb */, X86::SHL8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6737 /* shlb */, X86::SHL8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6737 /* shlb */, X86::SHL8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6747 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6747 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6747 /* shldl */, X86::SHLD32rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 6747 /* shldl */, X86::SHLD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 6747 /* shldl */, X86::SHLD32rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6747 /* shldl */, X86::SHLD32mri8, Convert__Mem325_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_Mem32 }, },
  { 6753 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6753 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6753 /* shldq */, X86::SHLD64rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 6753 /* shldq */, X86::SHLD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 6753 /* shldq */, X86::SHLD64rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6753 /* shldq */, X86::SHLD64mri8, Convert__Mem645_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_Mem64 }, },
  { 6759 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6759 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6759 /* shldw */, X86::SHLD16rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 6759 /* shldw */, X86::SHLD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 6759 /* shldw */, X86::SHLD16rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 6759 /* shldw */, X86::SHLD16mri8, Convert__Mem165_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_Mem16 }, },
  { 6765 /* shll */, X86::SHL32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6765 /* shll */, X86::SHL32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6765 /* shll */, X86::SHL32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6765 /* shll */, X86::SHL32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6765 /* shll */, X86::SHL32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6765 /* shll */, X86::SHL32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6770 /* shlq */, X86::SHL64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6770 /* shlq */, X86::SHL64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6770 /* shlq */, X86::SHL64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6770 /* shlq */, X86::SHL64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6770 /* shlq */, X86::SHL64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6770 /* shlq */, X86::SHL64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6775 /* shlw */, X86::SHL16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6775 /* shlw */, X86::SHL16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6775 /* shlw */, X86::SHL16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6775 /* shlw */, X86::SHL16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6775 /* shlw */, X86::SHL16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6775 /* shlw */, X86::SHL16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6785 /* shlxl */, X86::SHLX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6785 /* shlxl */, X86::SHLX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6791 /* shlxq */, X86::SHLX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6791 /* shlxq */, X86::SHLX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6801 /* shrb */, X86::SHR8r1, Convert__Reg1_0__Tie0, 0, { MCK_GR8 }, },
  { 6801 /* shrb */, X86::SHR8m1, Convert__Mem85_0, 0, { MCK_Mem8 }, },
  { 6801 /* shrb */, X86::SHR8rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR8 }, },
  { 6801 /* shrb */, X86::SHR8mCL, Convert__Mem85_1, 0, { MCK_CL, MCK_Mem8 }, },
  { 6801 /* shrb */, X86::SHR8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 6801 /* shrb */, X86::SHR8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 6811 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 6811 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 6811 /* shrdl */, X86::SHRD32rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_GR32 }, },
  { 6811 /* shrdl */, X86::SHRD32mrCL, Convert__Mem325_2__Reg1_1, 0, { MCK_CL, MCK_GR32, MCK_Mem32 }, },
  { 6811 /* shrdl */, X86::SHRD32rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_GR32 }, },
  { 6811 /* shrdl */, X86::SHRD32mri8, Convert__Mem325_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32, MCK_Mem32 }, },
  { 6817 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 6817 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 6817 /* shrdq */, X86::SHRD64rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_GR64 }, },
  { 6817 /* shrdq */, X86::SHRD64mrCL, Convert__Mem645_2__Reg1_1, 0, { MCK_CL, MCK_GR64, MCK_Mem64 }, },
  { 6817 /* shrdq */, X86::SHRD64rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_GR64 }, },
  { 6817 /* shrdq */, X86::SHRD64mri8, Convert__Mem645_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR64, MCK_Mem64 }, },
  { 6823 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 6823 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 6823 /* shrdw */, X86::SHRD16rrCL, Convert__Reg1_2__Tie0__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_GR16 }, },
  { 6823 /* shrdw */, X86::SHRD16mrCL, Convert__Mem165_2__Reg1_1, 0, { MCK_CL, MCK_GR16, MCK_Mem16 }, },
  { 6823 /* shrdw */, X86::SHRD16rri8, Convert__Reg1_2__Tie0__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_GR16 }, },
  { 6823 /* shrdw */, X86::SHRD16mri8, Convert__Mem165_2__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16, MCK_Mem16 }, },
  { 6829 /* shrl */, X86::SHR32r1, Convert__Reg1_0__Tie0, 0, { MCK_GR32 }, },
  { 6829 /* shrl */, X86::SHR32m1, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 6829 /* shrl */, X86::SHR32rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR32 }, },
  { 6829 /* shrl */, X86::SHR32mCL, Convert__Mem325_1, 0, { MCK_CL, MCK_Mem32 }, },
  { 6829 /* shrl */, X86::SHR32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 6829 /* shrl */, X86::SHR32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 6834 /* shrq */, X86::SHR64r1, Convert__Reg1_0__Tie0, 0, { MCK_GR64 }, },
  { 6834 /* shrq */, X86::SHR64m1, Convert__Mem645_0, 0, { MCK_Mem64 }, },
  { 6834 /* shrq */, X86::SHR64rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR64 }, },
  { 6834 /* shrq */, X86::SHR64mCL, Convert__Mem645_1, 0, { MCK_CL, MCK_Mem64 }, },
  { 6834 /* shrq */, X86::SHR64ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR64 }, },
  { 6834 /* shrq */, X86::SHR64mi, Convert__Mem645_1__Imm1_0, 0, { MCK_Imm, MCK_Mem64 }, },
  { 6839 /* shrw */, X86::SHR16r1, Convert__Reg1_0__Tie0, 0, { MCK_GR16 }, },
  { 6839 /* shrw */, X86::SHR16m1, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6839 /* shrw */, X86::SHR16rCL, Convert__Reg1_1__Tie0, 0, { MCK_CL, MCK_GR16 }, },
  { 6839 /* shrw */, X86::SHR16mCL, Convert__Mem165_1, 0, { MCK_CL, MCK_Mem16 }, },
  { 6839 /* shrw */, X86::SHR16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 6839 /* shrw */, X86::SHR16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 6849 /* shrxl */, X86::SHRX32rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32, MCK_GR32 }, },
  { 6849 /* shrxl */, X86::SHRX32rm, Convert__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32, MCK_GR32 }, },
  { 6855 /* shrxq */, X86::SHRX64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64, MCK_GR64 }, },
  { 6855 /* shrxq */, X86::SHRX64rm, Convert__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64, MCK_GR64 }, },
  { 6861 /* shufpd */, X86::SHUFPDrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6861 /* shufpd */, X86::SHUFPDrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6868 /* shufps */, X86::SHUFPSrri, Convert__Reg1_2__Tie0__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 6868 /* shufps */, X86::SHUFPSrmi, Convert__Reg1_2__Tie0__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 6880 /* sidtl */, X86::SIDT32m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6886 /* sidtq */, X86::SIDT64m, Convert__Mem5_0, Feature_In64BitMode, { MCK_Mem }, },
  { 6892 /* sidtw */, X86::SIDT16m, Convert__Mem5_0, Feature_Not64BitMode, { MCK_Mem }, },
  { 6898 /* skinit */, X86::SKINIT, Convert_NoOperands, 0, { MCK_EAX }, },
  { 6905 /* sldt */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6910 /* sldtl */, X86::SLDT32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6916 /* sldtq */, X86::SLDT64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6916 /* sldtq */, X86::SLDT64m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6922 /* sldtw */, X86::SLDT16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6922 /* sldtw */, X86::SLDT16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6933 /* smswl */, X86::SMSW32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 6939 /* smswq */, X86::SMSW64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 6945 /* smsww */, X86::SMSW16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 6945 /* smsww */, X86::SMSW16m, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 6951 /* sqrtpd */, X86::SQRTPDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6951 /* sqrtpd */, X86::SQRTPDm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6958 /* sqrtps */, X86::SQRTPSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6958 /* sqrtps */, X86::SQRTPSm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 6965 /* sqrtsd */, X86::SQRTSDr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6965 /* sqrtsd */, X86::SQRTSDm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 6972 /* sqrtss */, X86::SQRTSSr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 6972 /* sqrtss */, X86::SQRTSSm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 6979 /* ss */, X86::SS_PREFIX, Convert_NoOperands, 0, {  }, },
  { 6982 /* stac */, X86::STAC, Convert_NoOperands, 0, {  }, },
  { 6987 /* stc */, X86::STC, Convert_NoOperands, 0, {  }, },
  { 6991 /* std */, X86::STD, Convert_NoOperands, 0, {  }, },
  { 6995 /* stgi */, X86::STGI, Convert_NoOperands, 0, {  }, },
  { 7000 /* sti */, X86::STI, Convert_NoOperands, 0, {  }, },
  { 7004 /* stmxcsr */, X86::STMXCSR, Convert__Mem325_0, 0, { MCK_Mem32 }, },
  { 7012 /* stos */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 7012 /* stos */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 7012 /* stos */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 7012 /* stos */, X86::STOSQ, Convert__DstIdx641_1, Feature_In64BitMode, { MCK_RAX, MCK_DstIdx64 }, },
  { 7017 /* stosb */, X86::STOSB, Convert__DstIdx81_0, 0, { MCK_DstIdx8 }, },
  { 7017 /* stosb */, X86::STOSB, Convert__DstIdx81_1, 0, { MCK_AL, MCK_DstIdx8 }, },
  { 7029 /* stosl */, X86::STOSL, Convert__DstIdx321_0, 0, { MCK_DstIdx32 }, },
  { 7029 /* stosl */, X86::STOSL, Convert__DstIdx321_1, 0, { MCK_EAX, MCK_DstIdx32 }, },
  { 7035 /* stosq */, X86::STOSQ, Convert__DstIdx641_0, Feature_In64BitMode, { MCK_DstIdx64 }, },
  { 7035 /* stosq */, X86::STOSQ, Convert__DstIdx641_1, 0, { MCK_RAX, MCK_DstIdx64 }, },
  { 7041 /* stosw */, X86::STOSW, Convert__DstIdx161_0, 0, { MCK_DstIdx16 }, },
  { 7041 /* stosw */, X86::STOSW, Convert__DstIdx161_1, 0, { MCK_AX, MCK_DstIdx16 }, },
  { 7051 /* strl */, X86::STR32r, Convert__Reg1_0, 0, { MCK_GR32 }, },
  { 7056 /* strq */, X86::STR64r, Convert__Reg1_0, 0, { MCK_GR64 }, },
  { 7061 /* strw */, X86::STR16r, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 7061 /* strw */, X86::STRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 7070 /* subb */, X86::SUB8rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 7070 /* subb */, X86::SUB8mr, Convert__Mem85_1__Reg1_0, 0, { MCK_GR8, MCK_Mem8 }, },
  { 7070 /* subb */, X86::SUB8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 7070 /* subb */, X86::SUB8ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 7070 /* subb */, X86::SUB8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 7070 /* subb */, X86::SUB8rm, Convert__Reg1_1__Tie0__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 7075 /* subl */, X86::SUB32rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7075 /* subl */, X86::SUB32mr, Convert__Mem325_1__Reg1_0, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7075 /* subl */, X86::SUB32ri8, Convert__Reg1_1__Tie0__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_GR32 }, },
  { 7075 /* subl */, X86::SUB32mi8, Convert__Mem325_1__ImmSExti32i81_0, 0, { MCK_ImmSExti32i8, MCK_Mem32 }, },
  { 7075 /* subl */, X86::SUB32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 7075 /* subl */, X86::SUB32ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 7075 /* subl */, X86::SUB32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 7075 /* subl */, X86::SUB32rm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7080 /* subpd */, X86::SUBPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7080 /* subpd */, X86::SUBPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7086 /* subps */, X86::SUBPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7086 /* subps */, X86::SUBPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7092 /* subq */, X86::SUB64rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7092 /* subq */, X86::SUB64mr, Convert__Mem645_1__Reg1_0, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7092 /* subq */, X86::SUB64ri8, Convert__Reg1_1__Tie0__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_GR64 }, },
  { 7092 /* subq */, X86::SUB64mi8, Convert__Mem645_1__ImmSExti64i81_0, 0, { MCK_ImmSExti64i8, MCK_Mem64 }, },
  { 7092 /* subq */, X86::SUB64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7092 /* subq */, X86::SUB64ri32, Convert__Reg1_1__Tie0__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7092 /* subq */, X86::SUB64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7092 /* subq */, X86::SUB64rm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7097 /* subsd */, X86::SUBSDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7097 /* subsd */, X86::SUBSDrm, Convert__Reg1_1__Tie0__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7103 /* subss */, X86::SUBSSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7103 /* subss */, X86::SUBSSrm, Convert__Reg1_1__Tie0__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7109 /* subw */, X86::SUB16rr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7109 /* subw */, X86::SUB16mr, Convert__Mem165_1__Reg1_0, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7109 /* subw */, X86::SUB16ri8, Convert__Reg1_1__Tie0__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_GR16 }, },
  { 7109 /* subw */, X86::SUB16mi8, Convert__Mem165_1__ImmSExti16i81_0, 0, { MCK_ImmSExti16i8, MCK_Mem16 }, },
  { 7109 /* subw */, X86::SUB16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 7109 /* subw */, X86::SUB16ri, Convert__Reg1_1__Tie0__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 7109 /* subw */, X86::SUB16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 7109 /* subw */, X86::SUB16rm, Convert__Reg1_1__Tie0__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7114 /* swapgs */, X86::SWAPGS, Convert_NoOperands, 0, {  }, },
  { 7121 /* syscall */, X86::SYSCALL, Convert_NoOperands, 0, {  }, },
  { 7129 /* sysenter */, X86::SYSENTER, Convert_NoOperands, 0, {  }, },
  { 7146 /* sysexitl */, X86::SYSEXIT, Convert_NoOperands, 0, {  }, },
  { 7155 /* sysexitq */, X86::SYSEXIT64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 7171 /* sysretl */, X86::SYSRET, Convert_NoOperands, 0, {  }, },
  { 7179 /* sysretq */, X86::SYSRET64, Convert_NoOperands, Feature_In64BitMode, {  }, },
  { 7187 /* t1mskc */, X86::T1MSKC32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7187 /* t1mskc */, X86::T1MSKC64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7187 /* t1mskc */, X86::T1MSKC32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7187 /* t1mskc */, X86::T1MSKC64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7199 /* testb */, X86::TEST8rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR8, MCK_GR8 }, },
  { 7199 /* testb */, X86::TEST8rm, Convert__Reg1_0__Mem85_1, 0, { MCK_GR8, MCK_Mem8 }, },
  { 7199 /* testb */, X86::TEST8i8, Convert__Imm1_0, 0, { MCK_Imm, MCK_AL }, },
  { 7199 /* testb */, X86::TEST8ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR8 }, },
  { 7199 /* testb */, X86::TEST8mi, Convert__Mem85_1__Imm1_0, 0, { MCK_Imm, MCK_Mem8 }, },
  { 7199 /* testb */, X86::TEST8rm, Convert__Reg1_1__Mem85_0, 0, { MCK_Mem8, MCK_GR8 }, },
  { 7205 /* testl */, X86::TEST32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7205 /* testl */, X86::TEST32rm, Convert__Reg1_0__Mem325_1, 0, { MCK_GR32, MCK_Mem32 }, },
  { 7205 /* testl */, X86::TEST32i32, Convert__Imm1_0, 0, { MCK_Imm, MCK_EAX }, },
  { 7205 /* testl */, X86::TEST32ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR32 }, },
  { 7205 /* testl */, X86::TEST32mi, Convert__Mem325_1__Imm1_0, 0, { MCK_Imm, MCK_Mem32 }, },
  { 7205 /* testl */, X86::TEST32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7211 /* testq */, X86::TEST64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7211 /* testq */, X86::TEST64rm, Convert__Reg1_0__Mem645_1, 0, { MCK_GR64, MCK_Mem64 }, },
  { 7211 /* testq */, X86::TEST64i32, Convert__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_RAX }, },
  { 7211 /* testq */, X86::TEST64ri32, Convert__Reg1_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_GR64 }, },
  { 7211 /* testq */, X86::TEST64mi32, Convert__Mem645_1__ImmSExti64i321_0, 0, { MCK_ImmSExti64i32, MCK_Mem64 }, },
  { 7211 /* testq */, X86::TEST64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7217 /* testw */, X86::TEST16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7217 /* testw */, X86::TEST16rm, Convert__Reg1_0__Mem165_1, 0, { MCK_GR16, MCK_Mem16 }, },
  { 7217 /* testw */, X86::TEST16i16, Convert__Imm1_0, 0, { MCK_Imm, MCK_AX }, },
  { 7217 /* testw */, X86::TEST16ri, Convert__Reg1_1__Imm1_0, 0, { MCK_Imm, MCK_GR16 }, },
  { 7217 /* testw */, X86::TEST16mi, Convert__Mem165_1__Imm1_0, 0, { MCK_Imm, MCK_Mem16 }, },
  { 7217 /* testw */, X86::TEST16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7229 /* tzcntl */, X86::TZCNT32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7229 /* tzcntl */, X86::TZCNT32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7236 /* tzcntq */, X86::TZCNT64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7236 /* tzcntq */, X86::TZCNT64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7243 /* tzcntw */, X86::TZCNT16rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR16, MCK_GR16 }, },
  { 7243 /* tzcntw */, X86::TZCNT16rm, Convert__Reg1_1__Mem165_0, 0, { MCK_Mem16, MCK_GR16 }, },
  { 7250 /* tzmsk */, X86::TZMSK32rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_GR32 }, },
  { 7250 /* tzmsk */, X86::TZMSK64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_GR64 }, },
  { 7250 /* tzmsk */, X86::TZMSK32rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 7250 /* tzmsk */, X86::TZMSK64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 7256 /* ucomisd */, X86::UCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7256 /* ucomisd */, X86::UCOMISDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7264 /* ucomiss */, X86::UCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7264 /* ucomiss */, X86::UCOMISSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7272 /* ud2 */, X86::TRAP, Convert_NoOperands, 0, {  }, },
  { 7276 /* ud2b */, X86::UD2B, Convert_NoOperands, 0, {  }, },
  { 7281 /* unpckhpd */, X86::UNPCKHPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7281 /* unpckhpd */, X86::UNPCKHPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7290 /* unpckhps */, X86::UNPCKHPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7290 /* unpckhps */, X86::UNPCKHPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7299 /* unpcklpd */, X86::UNPCKLPDrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7299 /* unpcklpd */, X86::UNPCKLPDrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7308 /* unpcklps */, X86::UNPCKLPSrr, Convert__Reg1_1__Tie0__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7308 /* unpcklps */, X86::UNPCKLPSrm, Convert__Reg1_1__Tie0__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7317 /* vaddpd */, X86::VADDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7317 /* vaddpd */, X86::VADDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7317 /* vaddpd */, X86::VADDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7317 /* vaddpd */, X86::VADDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7317 /* vaddpd */, X86::VADDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7317 /* vaddpd */, X86::VADDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7317 /* vaddpd */, X86::VADDPDZrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 7317 /* vaddpd */, X86::VADDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7317 /* vaddpd */, X86::VADDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7324 /* vaddps */, X86::VADDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7324 /* vaddps */, X86::VADDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7324 /* vaddps */, X86::VADDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7324 /* vaddps */, X86::VADDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7324 /* vaddps */, X86::VADDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7324 /* vaddps */, X86::VADDPSZrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7324 /* vaddps */, X86::VADDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7324 /* vaddps */, X86::VADDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7331 /* vaddsd */, X86::VADDSDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7331 /* vaddsd */, X86::VADDSDZrm_Int, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7331 /* vaddsd */, X86::VADDSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7331 /* vaddsd */, X86::VADDSDZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7331 /* vaddsd */, X86::VADDSDZrr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDZrm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDZrrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7331 /* vaddsd */, X86::VADDSDZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7338 /* vaddss */, X86::VADDSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7338 /* vaddss */, X86::VADDSSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7338 /* vaddss */, X86::VADDSSZrm_Int, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7338 /* vaddss */, X86::VADDSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7338 /* vaddss */, X86::VADDSSZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7338 /* vaddss */, X86::VADDSSZrr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7338 /* vaddss */, X86::VADDSSZrm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7338 /* vaddss */, X86::VADDSSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7338 /* vaddss */, X86::VADDSSZrrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7338 /* vaddss */, X86::VADDSSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7338 /* vaddss */, X86::VADDSSZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7345 /* vaddsubpd */, X86::VADDSUBPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7345 /* vaddsubpd */, X86::VADDSUBPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7345 /* vaddsubpd */, X86::VADDSUBPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7345 /* vaddsubpd */, X86::VADDSUBPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7355 /* vaddsubps */, X86::VADDSUBPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7355 /* vaddsubps */, X86::VADDSUBPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7355 /* vaddsubps */, X86::VADDSUBPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7355 /* vaddsubps */, X86::VADDSUBPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7365 /* vaesdec */, X86::VAESDECrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7365 /* vaesdec */, X86::VAESDECrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7373 /* vaesdeclast */, X86::VAESDECLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7373 /* vaesdeclast */, X86::VAESDECLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7385 /* vaesenc */, X86::VAESENCrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7385 /* vaesenc */, X86::VAESENCrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7393 /* vaesenclast */, X86::VAESENCLASTrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7393 /* vaesenclast */, X86::VAESENCLASTrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7405 /* vaesimc */, X86::VAESIMCrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7405 /* vaesimc */, X86::VAESIMCrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7413 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 7413 /* vaeskeygenassist */, X86::VAESKEYGENASSIST128rm, Convert__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32 }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7430 /* valignd */, X86::VALIGNDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7430 /* valignd */, X86::VALIGNDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7430 /* valignd */, X86::VALIGNDZrmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7430 /* valignd */, X86::VALIGNDZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7438 /* valignq */, X86::VALIGNQZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7438 /* valignq */, X86::VALIGNQZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 7438 /* valignq */, X86::VALIGNQZrmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7438 /* valignq */, X86::VALIGNQZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7446 /* vandnpd */, X86::VANDNPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7446 /* vandnpd */, X86::VANDNPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7446 /* vandnpd */, X86::VANDNPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7446 /* vandnpd */, X86::VANDNPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7454 /* vandnps */, X86::VANDNPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7454 /* vandnps */, X86::VANDNPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7454 /* vandnps */, X86::VANDNPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7454 /* vandnps */, X86::VANDNPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7454 /* vandnps */, X86::VANDNPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7454 /* vandnps */, X86::VANDNPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7454 /* vandnps */, X86::VANDNPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7462 /* vandpd */, X86::VANDPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7462 /* vandpd */, X86::VANDPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7462 /* vandpd */, X86::VANDPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7462 /* vandpd */, X86::VANDPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7462 /* vandpd */, X86::VANDPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 7462 /* vandpd */, X86::VANDPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7462 /* vandpd */, X86::VANDPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasDQI, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7469 /* vandps */, X86::VANDPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7469 /* vandps */, X86::VANDPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7469 /* vandps */, X86::VANDPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7469 /* vandps */, X86::VANDPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7469 /* vandps */, X86::VANDPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7469 /* vandps */, X86::VANDPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7469 /* vandps */, X86::VANDPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7469 /* vandps */, X86::VANDPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7469 /* vandps */, X86::VANDPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7469 /* vandps */, X86::VANDPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7469 /* vandps */, X86::VANDPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 7469 /* vandps */, X86::VANDPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 7469 /* vandps */, X86::VANDPSZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7469 /* vandps */, X86::VANDPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasDQI, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7476 /* vblendmpd */, X86::VBLENDMPDZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrrk, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrmk, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ128rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZ256rmbk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7486 /* vblendmps */, X86::VBLENDMPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7496 /* vblendpd */, X86::VBLENDPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7496 /* vblendpd */, X86::VBLENDPDYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7496 /* vblendpd */, X86::VBLENDPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7496 /* vblendpd */, X86::VBLENDPDYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7505 /* vblendps */, X86::VBLENDPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7505 /* vblendps */, X86::VBLENDPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7505 /* vblendps */, X86::VBLENDPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7505 /* vblendps */, X86::VBLENDPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7514 /* vblendvpd */, X86::VBLENDVPDrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7514 /* vblendvpd */, X86::VBLENDVPDrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7514 /* vblendvpd */, X86::VBLENDVPDYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7514 /* vblendvpd */, X86::VBLENDVPDYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7524 /* vblendvps */, X86::VBLENDVPSrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7524 /* vblendvps */, X86::VBLENDVPSrm, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7524 /* vblendvps */, X86::VBLENDVPSYrr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7524 /* vblendvps */, X86::VBLENDVPSYrm, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7534 /* vbroadcastf128 */, X86::VBROADCASTF128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7549 /* vbroadcastf32x4 */, X86::VBROADCASTF32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7565 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 7565 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7565 /* vbroadcastf32x8 */, X86::VBROADCASTF32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512 }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7581 /* vbroadcastf64x2 */, X86::VBROADCASTF64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7597 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7597 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7597 /* vbroadcastf64x4 */, X86::VBROADCASTF64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7613 /* vbroadcasti128 */, X86::VBROADCASTI128, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512 }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4Z256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7628 /* vbroadcasti32x4 */, X86::VBROADCASTI32X4rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7644 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 7644 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7644 /* vbroadcasti32x8 */, X86::VBROADCASTI32X8rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512 }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmk, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2Z128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX|Feature_HasDQI, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7660 /* vbroadcasti64x2 */, X86::VBROADCASTI64X2rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI, { MCK_Mem128, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7676 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7676 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmk, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7676 /* vbroadcasti64x4 */, X86::VBROADCASTI64X4rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256r, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDYrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_VR256 }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256m, Convert__Reg1_1__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK_VR256X }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512 }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256rk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256mk, Convert__Reg1_1__Tie0__Reg1_3__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZmk, Convert__Reg1_1__Tie0__Reg1_3__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZ256mkz, Convert__Reg1_1__Reg1_3__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7692 /* vbroadcastsd */, X86::VBROADCASTSDZmkz, Convert__Reg1_1__Reg1_3__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128r, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256r, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128m, Convert__Reg1_1__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_FR32X }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSYrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_VR256 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256m, Convert__Reg1_1__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_VR256X }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512 }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128rk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256rk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128mk, Convert__Reg1_1__Tie0__Reg1_3__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256mk, Convert__Reg1_1__Tie0__Reg1_3__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZmk, Convert__Reg1_1__Tie0__Reg1_3__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128rkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256rkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ128mkz, Convert__Reg1_1__Reg1_3__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZ256mkz, Convert__Reg1_1__Reg1_3__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7705 /* vbroadcastss */, X86::VBROADCASTSSZmkz, Convert__Reg1_1__Reg1_3__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSYrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZrri, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSrmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rmi, Convert__Reg1_4__Reg1_3__Mem1285_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSYrmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, 0, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rmi, Convert__Reg1_4__Reg1_3__Mem2565_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZrmi, Convert__Reg1_4__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPSDrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPSDZrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_sd, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPSDrm, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, 0, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPSDZrm, Convert__Reg1_4__Reg1_3__Mem645_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_sd, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPSSrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPSSZrr, Convert__Reg1_4__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ss, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPSSrm, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, 0, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7718 /* vcmp */, X86::VCMPSSZrm, Convert__Reg1_4__Reg1_3__Mem325_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ss, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZrmbi, Convert__Reg1_5__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZrrib, Convert__Reg1_5__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZrmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rmbi, Convert__Reg1_5__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1 }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZrrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZrmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZrrik, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem1285_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem2565_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZrmik, Convert__Reg1_4__Reg1_6__Reg1_3__Mem5125_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZrribk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZ128rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZ256rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPDZrmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem645_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_pd, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZrribk, Convert__Reg1_5__Reg1_7__Reg1_4__Reg1_3__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZrmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ128rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7718 /* vcmp */, X86::VCMPPSZ256rmbik, Convert__Reg1_5__Reg1_7__Reg1_4__Mem325_2__Imm1_0, Feature_HasAVX512|Feature_HasVLX, { MCK_Imm, MCK_ps, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrrib_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrmbi_alt, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1 }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrrib_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ128rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZ256rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7723 /* vcmppd */, X86::VCMPPDZrmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSYrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSrmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSYrmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rmi_alt, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrrib_alt, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rmbi_alt, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1 }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrri_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrmi_altk, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrrib_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZrmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ128rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7730 /* vcmpps */, X86::VCMPPSZ256rmbi_altk, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VK1, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7737 /* vcmpsd */, X86::VCMPSDrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7737 /* vcmpsd */, X86::VCMPSDZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7737 /* vcmpsd */, X86::VCMPSDrm_alt, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 7737 /* vcmpsd */, X86::VCMPSDZrmi_alt, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_VK1 }, },
  { 7744 /* vcmpss */, X86::VCMPSSrr_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 7744 /* vcmpss */, X86::VCMPSSZrri_alt, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_VK1 }, },
  { 7744 /* vcmpss */, X86::VCMPSSrm_alt, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 7744 /* vcmpss */, X86::VCMPSSZrmi_alt, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_VK1 }, },
  { 7751 /* vcomisd */, X86::VCOMISDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7751 /* vcomisd */, X86::VCOMISDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 7751 /* vcomisd */, X86::VCOMISDrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7751 /* vcomisd */, X86::VCOMISDZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X }, },
  { 7759 /* vcomiss */, X86::VCOMISSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7759 /* vcomiss */, X86::VCOMISSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X }, },
  { 7759 /* vcomiss */, X86::VCOMISSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7759 /* vcomiss */, X86::VCOMISSZrm, Convert__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ128mr, Convert__Mem1285_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_Mem128 }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ256mr, Convert__Mem2565_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_Mem256 }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_Mem128, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7767 /* vcompresspd */, X86::VCOMPRESSPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ128mr, Convert__Mem1285_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_Mem128 }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ256mr, Convert__Mem2565_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_Mem256 }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZmr, Convert__Mem5125_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512 }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ128mrk, Convert__Mem1285_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_Mem128, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ256mrk, Convert__Mem2565_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_Mem256, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZmrk, Convert__Mem5125_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_Mem512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7779 /* vcompressps */, X86::VCOMPRESSPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7791 /* vcvtdq2pd */, X86::VCVTDQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7801 /* vcvtdq2ps */, X86::VCVTDQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7811 /* vcvtpd2dq */, X86::VCVTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7821 /* vcvtpd2dqx */, X86::VCVTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7821 /* vcvtpd2dqx */, X86::VCVTPD2DQXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7821 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7821 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7821 /* vcvtpd2dqx */, X86::VCVTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7832 /* vcvtpd2dqy */, X86::VCVTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7832 /* vcvtpd2dqy */, X86::VCVTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 7832 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 7832 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7832 /* vcvtpd2dqy */, X86::VCVTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7843 /* vcvtpd2ps */, X86::VCVTPD2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7853 /* vcvtpd2psx */, X86::VCVTPD2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7853 /* vcvtpd2psx */, X86::VCVTPD2PSXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7853 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7853 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7853 /* vcvtpd2psx */, X86::VCVTPD2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7864 /* vcvtpd2psy */, X86::VCVTPD2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 7864 /* vcvtpd2psy */, X86::VCVTPD2PSYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 7864 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 7864 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7864 /* vcvtpd2psy */, X86::VCVTPD2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7875 /* vcvtpd2qq */, X86::VCVTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7885 /* vcvtpd2udq */, X86::VCVTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7896 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7896 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7896 /* vcvtpd2udqx */, X86::VCVTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7908 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 7908 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7908 /* vcvtpd2udqy */, X86::VCVTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7920 /* vcvtpd2uqq */, X86::VCVTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7931 /* vcvtph2ps */, X86::VCVTPH2PSrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7941 /* vcvtps2dq */, X86::VCVTPS2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_VR256 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDYrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_VR256 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrrb, Convert__Reg1_2__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7951 /* vcvtps2pd */, X86::VCVTPS2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32 }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHmr, Convert__Mem645_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem64 }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHYrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHYmr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHZrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 7961 /* vcvtps2ph */, X86::VCVTPS2PHZmr, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512 }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7971 /* vcvtps2qq */, X86::VCVTPS2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7981 /* vcvtps2udq */, X86::VCVTPS2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512 }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512 }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 7992 /* vcvtps2uqq */, X86::VCVTPS2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8003 /* vcvtqq2pd */, X86::VCVTQQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8013 /* vcvtqq2ps */, X86::VCVTQQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8023 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8023 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8023 /* vcvtqq2psx */, X86::VCVTQQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8034 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 8034 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8034 /* vcvtqq2psy */, X86::VCVTQQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 8045 /* vcvtsd2si */, X86::VCVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8055 /* vcvtsd2sil */, X86::VCVTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8055 /* vcvtsd2sil */, X86::VCVTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8066 /* vcvtsd2siq */, X86::VCVTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8066 /* vcvtsd2siq */, X86::VCVTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8077 /* vcvtsd2ss */, X86::VCVTSD2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8077 /* vcvtsd2ss */, X86::VCVTSD2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8077 /* vcvtsd2ss */, X86::VCVTSD2SSrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8077 /* vcvtsd2ss */, X86::VCVTSD2SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8087 /* vcvtsd2usi */, X86::VCVTSD2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8087 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8087 /* vcvtsd2usi */, X86::VCVTSD2USIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 8087 /* vcvtsd2usi */, X86::VCVTSD2USI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 8098 /* vcvtsi2sd */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8108 /* vcvtsi2sdl */, X86::VCVTSI2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 8108 /* vcvtsi2sdl */, X86::VCVTSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8108 /* vcvtsi2sdl */, X86::VCVTSI2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8108 /* vcvtsi2sdl */, X86::VCVTSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8108 /* vcvtsi2sdl */, X86::VCVTSI2SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8119 /* vcvtsi2sdq */, X86::VCVTSI2SD64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 8119 /* vcvtsi2sdq */, X86::VCVTSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8119 /* vcvtsi2sdq */, X86::VCVTSI2SD64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8119 /* vcvtsi2sdq */, X86::VCVTSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8119 /* vcvtsi2sdq */, X86::VCVTSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8130 /* vcvtsi2ss */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8140 /* vcvtsi2ssl */, X86::VCVTSI2SSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR32, MCK_FR32, MCK_FR32 }, },
  { 8140 /* vcvtsi2ssl */, X86::VCVTSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8140 /* vcvtsi2ssl */, X86::VCVTSI2SSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8140 /* vcvtsi2ssl */, X86::VCVTSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8140 /* vcvtsi2ssl */, X86::VCVTSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8151 /* vcvtsi2ssq */, X86::VCVTSI2SS64rr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_GR64, MCK_FR32, MCK_FR32 }, },
  { 8151 /* vcvtsi2ssq */, X86::VCVTSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8151 /* vcvtsi2ssq */, X86::VCVTSI2SS64rm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8151 /* vcvtsi2ssq */, X86::VCVTSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8151 /* vcvtsi2ssq */, X86::VCVTSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8162 /* vcvtss2sd */, X86::VCVTSS2SDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8162 /* vcvtss2sd */, X86::VCVTSS2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8162 /* vcvtss2sd */, X86::VCVTSS2SDrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8162 /* vcvtss2sd */, X86::VCVTSS2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 8172 /* vcvtss2si */, X86::VCVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8182 /* vcvtss2sil */, X86::VCVTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8182 /* vcvtss2sil */, X86::VCVTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8193 /* vcvtss2siq */, X86::VCVTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8193 /* vcvtss2siq */, X86::VCVTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8204 /* vcvtss2usi */, X86::VCVTSS2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8204 /* vcvtss2usi */, X86::VCVTSS2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8204 /* vcvtss2usi */, X86::VCVTSS2USIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 8204 /* vcvtss2usi */, X86::VCVTSS2USI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8215 /* vcvttpd2dq */, X86::VCVTTPD2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8226 /* vcvttpd2dqx */, X86::VCVTTPD2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8226 /* vcvttpd2dqx */, X86::VCVTTPD2DQXrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8226 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8226 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8226 /* vcvttpd2dqx */, X86::VCVTTPD2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8238 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_FR32 }, },
  { 8238 /* vcvttpd2dqy */, X86::VCVTTPD2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_FR32 }, },
  { 8238 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 8238 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8238 /* vcvttpd2dqy */, X86::VCVTTPD2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8250 /* vcvttpd2qq */, X86::VCVTTPD2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8261 /* vcvttpd2udq */, X86::VCVTTPD2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8273 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8273 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8273 /* vcvttpd2udqx */, X86::VCVTTPD2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8286 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 8286 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8286 /* vcvttpd2udqy */, X86::VCVTTPD2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8299 /* vcvttpd2uqq */, X86::VCVTTPD2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQYrr, Convert__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQrm, Convert__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQYrm, Convert__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8311 /* vcvttps2dq */, X86::VCVTTPS2DQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512 }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8322 /* vcvttps2qq */, X86::VCVTTPS2QQZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasAVX512, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8333 /* vcvttps2udq */, X86::VCVTTPS2UDQZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512 }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512 }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrb, Convert__Reg1_2__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512 }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasDQI, { MCK__123_sae_125_, MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8345 /* vcvttps2uqq */, X86::VCVTTPS2UQQZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 8357 /* vcvttsd2si */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8368 /* vcvttsd2sil */, X86::VCVTTSD2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8368 /* vcvttsd2sil */, X86::VCVTTSD2SIrm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR32 }, },
  { 8380 /* vcvttsd2siq */, X86::VCVTTSD2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8380 /* vcvttsd2siq */, X86::VCVTTSD2SI64rm, Convert__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_GR64 }, },
  { 8392 /* vcvttsd2usi */, X86::VCVTTSD2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8392 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8392 /* vcvttsd2usi */, X86::VCVTTSD2USIZrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR32 }, },
  { 8392 /* vcvttsd2usi */, X86::VCVTTSD2USI64Zrm, Convert__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_GR64 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 8404 /* vcvttss2si */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8415 /* vcvttss2sil */, X86::VCVTTSS2SIrr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR32 }, },
  { 8415 /* vcvttss2sil */, X86::VCVTTSS2SIrm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR32 }, },
  { 8427 /* vcvttss2siq */, X86::VCVTTSS2SI64rr, Convert__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_GR64 }, },
  { 8427 /* vcvttss2siq */, X86::VCVTTSS2SI64rm, Convert__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_GR64 }, },
  { 8439 /* vcvttss2usi */, X86::VCVTTSS2USIZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR32 }, },
  { 8439 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_GR64 }, },
  { 8439 /* vcvttss2usi */, X86::VCVTTSS2USIZrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR32 }, },
  { 8439 /* vcvttss2usi */, X86::VCVTTSS2USI64Zrm, Convert__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_GR64 }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512 }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrm, Convert__Reg1_1__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512 }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmb, Convert__Reg1_2__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR256X, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8451 /* vcvtudq2pd */, X86::VCVTUDQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasAVX512, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8462 /* vcvtudq2ps */, X86::VCVTUDQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512 }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512 }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512 }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8473 /* vcvtuqq2pd */, X86::VCVTUQQ2PDZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrr, Convert__Reg1_1__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrb, Convert__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmb, Convert__Reg1_2__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmb, Convert__Reg1_2__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmb, Convert__Reg1_2__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI|Feature_HasVLX, { MCK_VR256X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasDQI, { MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrrbkz, Convert__Reg1_2__Reg1_4__Reg1_1__AVX512RC1_0, Feature_HasDQI, { MCK_AVX512RC, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ128rmbkz, Convert__Reg1_2__Reg1_4__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK__123_1to2_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZ256rmbkz, Convert__Reg1_2__Reg1_4__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK__123_1to4_125_, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8484 /* vcvtuqq2ps */, X86::VCVTUQQ2PSZrmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasDQI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8495 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8495 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8495 /* vcvtuqq2psx */, X86::VCVTUQQ2PSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8507 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X }, },
  { 8507 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8507 /* vcvtuqq2psy */, X86::VCVTUQQ2PSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasDQI|Feature_HasVLX, { MCK_Mem256, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8530 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8530 /* vcvtusi2sdl */, X86::VCVTUSI2SDZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8542 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8542 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8542 /* vcvtusi2sdq */, X86::VCVTUSI642SDZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8565 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR32, MCK_FR32X, MCK_FR32X }, },
  { 8565 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrm, Convert__Reg1_2__Reg1_1__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8565 /* vcvtusi2ssl */, X86::VCVTUSI2SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR32, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8577 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_GR64, MCK_FR32X, MCK_FR32X }, },
  { 8577 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrm, Convert__Reg1_2__Reg1_1__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8577 /* vcvtusi2ssq */, X86::VCVTUSI642SSZrrb_Int, Convert__Reg1_3__Reg1_2__Reg1_0__AVX512RC1_1, Feature_HasAVX512, { MCK_GR64, MCK_AVX512RC, MCK_FR32X, MCK_FR32X }, },
  { 8589 /* vdivpd */, X86::VDIVPDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8589 /* vdivpd */, X86::VDIVPDYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8589 /* vdivpd */, X86::VDIVPDrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8589 /* vdivpd */, X86::VDIVPDYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrmb, Convert__Reg1_3__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8589 /* vdivpd */, X86::VDIVPDZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8596 /* vdivps */, X86::VDIVPSYrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8596 /* vdivps */, X86::VDIVPSZrr, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8596 /* vdivps */, X86::VDIVPSrm, Convert__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rm, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8596 /* vdivps */, X86::VDIVPSYrm, Convert__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rm, Convert__Reg1_2__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8596 /* vdivps */, X86::VDIVPSZrm, Convert__Reg1_2__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8596 /* vdivps */, X86::VDIVPSZrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8596 /* vdivps */, X86::VDIVPSZrmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rmb, Convert__Reg1_3__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrrkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrmkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZrmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ128rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8596 /* vdivps */, X86::VDIVPSZ256rmbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrm_Int, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8603 /* vdivsd */, X86::VDIVSDrm, Convert__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8603 /* vdivsd */, X86::VDIVSDZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSrr, Convert__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8610 /* vdivss */, X86::VDIVSSZrr_Int, Convert__Reg1_2__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8610 /* vdivss */, X86::VDIVSSZrm_Int, Convert__Reg1_2__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8610 /* vdivss */, X86::VDIVSSrm, Convert__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8610 /* vdivss */, X86::VDIVSSZrrb, Convert__Reg1_3__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8610 /* vdivss */, X86::VDIVSSZrr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSZrm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSZrr_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSZrrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSZrm_Intkz, Convert__Reg1_2__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8610 /* vdivss */, X86::VDIVSSZrrbkz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8617 /* vdppd */, X86::VDPPDrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8617 /* vdppd */, X86::VDPPDrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8623 /* vdpps */, X86::VDPPSrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8623 /* vdpps */, X86::VDPPSYrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8623 /* vdpps */, X86::VDPPSrmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8623 /* vdpps */, X86::VDPPSYrmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8629 /* verr */, X86::VERRr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 8629 /* verr */, X86::VERRm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 8634 /* verw */, X86::VERWr, Convert__Reg1_0, 0, { MCK_GR16 }, },
  { 8634 /* verw */, X86::VERWm, Convert__Mem165_0, 0, { MCK_Mem16 }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDr, Convert__Reg1_1__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512 }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDm, Convert__Reg1_1__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512 }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDrb, Convert__Reg1_2__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDmb, Convert__Reg1_2__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512 }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8639 /* vexp2pd */, X86::VEXP2PDmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to8_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSr, Convert__Reg1_1__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512 }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSm, Convert__Reg1_1__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512 }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSrb, Convert__Reg1_2__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512 }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSmb, Convert__Reg1_2__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512 }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSrbk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasERI, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSmbk, Convert__Reg1_2__Tie0__Reg1_4__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSrbkz, Convert__Reg1_2__Reg1_4__Reg1_1, Feature_HasERI, { MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8647 /* vexp2ps */, X86::VEXP2PSmbkz, Convert__Reg1_2__Reg1_4__Mem5125_0, Feature_HasERI, { MCK_Mem512, MCK__123_1to16_125_, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8655 /* vexpandpd */, X86::VEXPANDPDZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rr, Convert__Reg1_1__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrr, Convert__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512 }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rm, Convert__Reg1_1__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rm, Convert__Reg1_1__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrm, Convert__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512 }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrrk, Convert__Reg1_1__Tie0__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rmk, Convert__Reg1_1__Tie0__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrmk, Convert__Reg1_1__Tie0__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasVLX, { MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrrkz, Convert__Reg1_1__Reg1_3__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ128rmkz, Convert__Reg1_1__Reg1_3__Mem1285_0, Feature_HasVLX, { MCK_Mem128, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZ256rmkz, Convert__Reg1_1__Reg1_3__Mem2565_0, Feature_HasVLX, { MCK_Mem256, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8665 /* vexpandps */, X86::VEXPANDPSZrmkz, Convert__Reg1_1__Reg1_3__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8675 /* vextractf128 */, X86::VEXTRACTF128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 8675 /* vextractf128 */, X86::VEXTRACTF128mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 8688 /* vextractf32x4 */, X86::VEXTRACTF32x4rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 8688 /* vextractf32x4 */, X86::VEXTRACTF32x4rm, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 8688 /* vextractf32x4 */, X86::VEXTRACTF32x4rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8688 /* vextractf32x4 */, X86::VEXTRACTF32x4rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8702 /* vextractf64x4 */, X86::VEXTRACTF64x4rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 8702 /* vextractf64x4 */, X86::VEXTRACTF64x4rm, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 8702 /* vextractf64x4 */, X86::VEXTRACTF64x4rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8702 /* vextractf64x4 */, X86::VEXTRACTF64x4rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8716 /* vextracti128 */, X86::VEXTRACTI128rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_FR32 }, },
  { 8716 /* vextracti128 */, X86::VEXTRACTI128mr, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_VR256, MCK_Mem128 }, },
  { 8729 /* vextracti32x4 */, X86::VEXTRACTI32x4rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X }, },
  { 8729 /* vextracti32x4 */, X86::VEXTRACTI32x4rm, Convert__Mem1285_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem128 }, },
  { 8729 /* vextracti32x4 */, X86::VEXTRACTI32x4rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8729 /* vextracti32x4 */, X86::VEXTRACTI32x4rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8743 /* vextracti64x4 */, X86::VEXTRACTI64x4rr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X }, },
  { 8743 /* vextracti64x4 */, X86::VEXTRACTI64x4rm, Convert__Mem2565_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_Mem256 }, },
  { 8743 /* vextracti64x4 */, X86::VEXTRACTI64x4rrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8743 /* vextracti64x4 */, X86::VEXTRACTI64x4rrkz, Convert__Reg1_2__Reg1_4__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8757 /* vextractps */, X86::VEXTRACTPSrr, Convert__GR32orGR641_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_GR32orGR64 }, },
  { 8757 /* vextractps */, X86::VEXTRACTPSmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, 0, { MCK_ImmUnsignedi8, MCK_FR32, MCK_Mem32 }, },
  { 8757 /* vextractps */, X86::VEXTRACTPSzrr, Convert__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_GR32 }, },
  { 8757 /* vextractps */, X86::VEXTRACTPSzmr, Convert__Mem325_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_Mem32 }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbi, Convert__Reg1_4__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrribk, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrribkz, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8768 /* vfixupimmpd */, X86::VFIXUPIMMPDZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmi, Convert__Reg1_3__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmi, Convert__Reg1_3__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbi, Convert__Reg1_4__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrribk, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem2565_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbik, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem5125_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrribkz, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZrmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ128rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8780 /* vfixupimmps */, X86::VFIXUPIMMPSZ256rmbikz, Convert__Reg1_4__Reg1_6__Reg1_3__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512|Feature_HasVLX, { MCK_ImmUnsignedi8, MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmi_altk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rribk, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rmi_altkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem645_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem64, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8792 /* vfixupimmsd */, X86::VFIXUPIMMSDZ128rribkz, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rri, Convert__Reg1_3__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmi, Convert__Reg1_3__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmi_alt, Convert__Reg1_3__Reg1_2__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rrib, Convert__Reg1_4__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rrik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmik, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmi_altk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rribk, Convert__Reg1_4__Tie0__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rrikz, Convert__Reg1_3__Reg1_5__Reg1_2__Reg1_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmikz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem1285_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rmi_altkz, Convert__Reg1_3__Reg1_5__Reg1_2__Mem325_1__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK_Mem32, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8804 /* vfixupimmss */, X86::VFIXUPIMMSSZ128rribkz, Convert__Reg1_4__Reg1_6__Reg1_3__Reg1_2__ImmUnsignedi81_0, Feature_HasAVX512, { MCK_ImmUnsignedi8, MCK__123_sae_125_, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8816 /* vfmadd132pd */, X86::VFMADD132PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8828 /* vfmadd132ps */, X86::VFMADD132PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADDSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8840 /* vfmadd132sd */, X86::VFMADDSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8840 /* vfmadd132sd */, X86::VFMADD132SD132SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADDSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8852 /* vfmadd132ss */, X86::VFMADDSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8852 /* vfmadd132ss */, X86::VFMADD132SS132SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8864 /* vfmadd213pd */, X86::VFMADD213PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADDPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADDPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADDPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADDPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8876 /* vfmadd213ps */, X86::VFMADD213PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADDSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8888 /* vfmadd213sd */, X86::VFMADDSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8888 /* vfmadd213sd */, X86::VFMADD213SD213SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADDSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8900 /* vfmadd213ss */, X86::VFMADDSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8900 /* vfmadd213ss */, X86::VFMADD213SS213SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADDPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADDPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADDPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADDPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8912 /* vfmadd231pd */, X86::VFMADD231PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADDPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADDPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADDPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADDPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8924 /* vfmadd231ps */, X86::VFMADD231PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADDSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8936 /* vfmadd231sd */, X86::VFMADDSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8936 /* vfmadd231sd */, X86::VFMADD231SD231SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADDSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8948 /* vfmadd231ss */, X86::VFMADDSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8948 /* vfmadd231ss */, X86::VFMADD231SS231SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8960 /* vfmaddpd */, X86::VFMADDPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8969 /* vfmaddps */, X86::VFMADDPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8978 /* vfmaddsd */, X86::VFMADDSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8978 /* vfmaddsd */, X86::VFMADDSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 8978 /* vfmaddsd */, X86::VFMADDSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8987 /* vfmaddss */, X86::VFMADDSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8987 /* vfmaddss */, X86::VFMADDSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 8987 /* vfmaddss */, X86::VFMADDSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUBPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 8996 /* vfmaddsub132pd */, X86::VFMADDSUB132PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUBPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9011 /* vfmaddsub132ps */, X86::VFMADDSUB132PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUBPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9026 /* vfmaddsub213pd */, X86::VFMADDSUB213PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUBPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9041 /* vfmaddsub213ps */, X86::VFMADDSUB213PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUBPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9056 /* vfmaddsub231pd */, X86::VFMADDSUB231PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUBPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9071 /* vfmaddsub231ps */, X86::VFMADDSUB231PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9086 /* vfmaddsubpd */, X86::VFMADDSUBPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9098 /* vfmaddsubps */, X86::VFMADDSUBPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUBPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUBPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUBPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUBPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9110 /* vfmsub132pd */, X86::VFMSUB132PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUBPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUBPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUBPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUBPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9122 /* vfmsub132ps */, X86::VFMSUB132PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUBSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUBSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9134 /* vfmsub132sd */, X86::VFMSUB132SD132SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUBSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUBSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9146 /* vfmsub132ss */, X86::VFMSUB132SS132SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUBPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUBPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUBPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUBPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9158 /* vfmsub213pd */, X86::VFMSUB213PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUBPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUBPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUBPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUBPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9170 /* vfmsub213ps */, X86::VFMSUB213PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUBSDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUBSDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9182 /* vfmsub213sd */, X86::VFMSUB213SD213SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUBSSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUBSSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9194 /* vfmsub213ss */, X86::VFMSUB213SS213SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUBPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUBPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUBPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUBPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9206 /* vfmsub231pd */, X86::VFMSUB231PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUBPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUBPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUBPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUBPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9218 /* vfmsub231ps */, X86::VFMSUB231PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUBSDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUBSDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9230 /* vfmsub231sd */, X86::VFMSUB231SD231SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUBSSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUBSSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9242 /* vfmsub231ss */, X86::VFMSUB231SS231SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9254 /* vfmsubadd132pd */, X86::VFMSUBADD132PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9269 /* vfmsubadd132ps */, X86::VFMSUBADD132PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9284 /* vfmsubadd213pd */, X86::VFMSUBADD213PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADDPSr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9299 /* vfmsubadd213ps */, X86::VFMSUBADD213PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADDPDr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9314 /* vfmsubadd231pd */, X86::VFMSUBADD231PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADDPSr231mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9329 /* vfmsubadd231ps */, X86::VFMSUBADD231PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9344 /* vfmsubaddpd */, X86::VFMSUBADDPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9356 /* vfmsubaddps */, X86::VFMSUBADDPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9368 /* vfmsubpd */, X86::VFMSUBPD4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4mr, Convert__Reg1_3__Reg1_2__Mem1285_1__Reg1_0, 0, { MCK_FR32, MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4rrY, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4mrY, Convert__Reg1_3__Reg1_2__Mem2565_1__Reg1_0, 0, { MCK_VR256, MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9377 /* vfmsubps */, X86::VFMSUBPS4rmY, Convert__Reg1_3__Reg1_2__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9386 /* vfmsubsd */, X86::VFMSUBSD4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9386 /* vfmsubsd */, X86::VFMSUBSD4mr, Convert__Reg1_3__Reg1_2__Mem645_1__Reg1_0, 0, { MCK_FR32, MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9386 /* vfmsubsd */, X86::VFMSUBSD4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9395 /* vfmsubss */, X86::VFMSUBSS4rr, Convert__Reg1_3__Reg1_2__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9395 /* vfmsubss */, X86::VFMSUBSS4mr, Convert__Reg1_3__Reg1_2__Mem325_1__Reg1_0, 0, { MCK_FR32, MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9395 /* vfmsubss */, X86::VFMSUBSS4rm, Convert__Reg1_3__Reg1_2__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADDPDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADDPDr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADDPDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADDPDr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9404 /* vfnmadd132pd */, X86::VFNMADD132PDZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADDPSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADDPSr132rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADDPSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADDPSr132mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512 }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZmbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZrbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZmbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasAVX512, { MCK_Mem32, MCK__123_1to16_125_, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ128mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to4_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9417 /* vfnmadd132ps */, X86::VFNMADD132PSZ256mbkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem325_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem32, MCK__123_1to8_125_, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADDSDr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADDSDr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem645_0, 0, { MCK_Mem64, MCK_FR32, MCK_FR32 }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9430 /* vfnmadd132sd */, X86::VFNMADD132SD132SDrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADDSSr132r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSr_Int, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSm_Int, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADDSSr132m, Convert__Reg1_2__Tie0__Reg1_1__Mem325_0, 0, { MCK_Mem32, MCK_FR32, MCK_FR32 }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSrb_Int, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSr_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSm_Intk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSr_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSrb_Intk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSm_Intkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9443 /* vfnmadd132ss */, X86::VFNMADD132SS132SSrb_Intkz, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADDPDr213r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_FR32, MCK_FR32, MCK_FR32 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADDPDr213rY, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, 0, { MCK_VR256, MCK_VR256, MCK_VR256 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256r, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZr, Convert__Reg1_2__Tie0__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADDPDr213m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, 0, { MCK_Mem128, MCK_FR32, MCK_FR32 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128m, Convert__Reg1_2__Tie0__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADDPDr213mY, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, 0, { MCK_Mem256, MCK_VR256, MCK_VR256 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256m, Convert__Reg1_2__Tie0__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZm, Convert__Reg1_2__Tie0__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZrb, Convert__Reg1_3__Tie0__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256mb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to4_125_, MCK_VR256X, MCK_VR256X }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZmb, Convert__Reg1_3__Tie0__Reg1_2__Mem645_0, Feature_HasAVX512, { MCK_Mem64, MCK__123_1to8_125_, MCK_VR512, MCK_VR512 }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256rk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZrk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256mk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZmk, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_FR32X, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256rkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasVLX|Feature_HasAVX512, { MCK_VR256X, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZrkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Reg1_0, Feature_HasAVX512, { MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZrbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Reg1_1__AVX512RC1_0, Feature_HasAVX512, { MCK_AVX512RC, MCK_VR512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem1285_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem128, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ256mkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem2565_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem256, MCK_VR256X, MCK_VR256X, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZmkz, Convert__Reg1_2__Tie0__Reg1_4__Reg1_1__Mem5125_0, Feature_HasAVX512, { MCK_Mem512, MCK_VR512, MCK_VR512, MCK__123_, MCK_VK1WM, MCK__125_, MCK__123_z_125_ }, },
  { 9456 /* vfnmadd213pd */, X86::VFNMADD213PDZ128mbk, Convert__Reg1_3__Tie0__Reg1_5__Reg1_2__Mem645_0, Feature_HasVLX|Feature_HasAVX512, { MCK_Mem64, MCK__123_1to2_125_, MCK_FR32X, MCK_FR32X, MCK__123_, MCK_VK1WM, MCK__12