/* valaoptionparser.c generated by valac 0.22.1, the Vala compiler
 * generated from valaoptionparser.vala, do not modify */

/* valaoptionparser.vala
 *
 * Copyright (C) 2013  Jesse van den Kieboom
 * Copyright (C) 2006-2012  Jürg Billeter
 * Copyright (C) 1996-2002, 2004, 2005, 2006 Free Software Foundation, Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <vala.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define TYPE_PARSER_OPTIONS (parser_options_get_type ())
typedef struct _ParserOptions ParserOptions;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))

#define TYPE_OPTION_PARSER (option_parser_get_type ())
#define OPTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_OPTION_PARSER, OptionParser))
#define OPTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_OPTION_PARSER, OptionParserClass))
#define IS_OPTION_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_OPTION_PARSER))
#define IS_OPTION_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_OPTION_PARSER))
#define OPTION_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_OPTION_PARSER, OptionParserClass))

typedef struct _OptionParser OptionParser;
typedef struct _OptionParserClass OptionParserClass;
typedef struct _OptionParserPrivate OptionParserPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DIAGNOSTICS (diagnostics_get_type ())
#define DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIAGNOSTICS, Diagnostics))
#define DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIAGNOSTICS, DiagnosticsClass))
#define IS_DIAGNOSTICS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIAGNOSTICS))
#define IS_DIAGNOSTICS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIAGNOSTICS))
#define DIAGNOSTICS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIAGNOSTICS, DiagnosticsClass))

typedef struct _Diagnostics Diagnostics;
typedef struct _DiagnosticsClass DiagnosticsClass;
typedef struct _ParamSpecOptionParser ParamSpecOptionParser;

struct _ParserOptions {
	ValaCodeContext* context;
	gboolean fatal_warnings;
};

struct _OptionParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	OptionParserPrivate * priv;
};

struct _OptionParserClass {
	GTypeClass parent_class;
	void (*finalize) (OptionParser *self);
};

struct _ParamSpecOptionParser {
	GParamSpec parent_instance;
};


static gpointer option_parser_parent_class = NULL;
static gchar* option_parser_basedir;
static gchar* option_parser_basedir = NULL;
static gchar* option_parser_directory;
static gchar* option_parser_directory = NULL;
static gboolean option_parser_version;
static gboolean option_parser_version = FALSE;
static gboolean option_parser_api_version;
static gboolean option_parser_api_version = FALSE;
static gchar** option_parser_sources;
static gchar** option_parser_sources = NULL;
static gchar** option_parser_vapi_directories;
static gchar** option_parser_vapi_directories = NULL;
static gchar** option_parser_gir_directories;
static gchar** option_parser_gir_directories = NULL;
static gchar** option_parser_metadata_directories;
static gchar** option_parser_metadata_directories = NULL;
static gchar* option_parser_vapi_filename;
static gchar* option_parser_vapi_filename = NULL;
static gchar* option_parser_library;
static gchar* option_parser_library = NULL;
static gchar* option_parser_gir;
static gchar* option_parser_gir = NULL;
static gchar** option_parser_packages;
static gchar** option_parser_packages = NULL;
static gchar** option_parser_fast_vapis;
static gchar** option_parser_fast_vapis = NULL;
static gchar* option_parser_target_glib;
static gchar* option_parser_target_glib = NULL;
static gchar** option_parser_gresources;
static gchar** option_parser_gresources = NULL;
static gboolean option_parser_ccode_only;
static gboolean option_parser_ccode_only = FALSE;
static gchar* option_parser_header_filename;
static gchar* option_parser_header_filename = NULL;
static gboolean option_parser_use_header;
static gboolean option_parser_use_header = FALSE;
static gchar* option_parser_internal_header_filename;
static gchar* option_parser_internal_header_filename = NULL;
static gchar* option_parser_internal_vapi_filename;
static gchar* option_parser_internal_vapi_filename = NULL;
static gchar* option_parser_fast_vapi_filename;
static gchar* option_parser_fast_vapi_filename = NULL;
static gchar* option_parser_symbols_filename;
static gchar* option_parser_symbols_filename = NULL;
static gchar* option_parser_includedir;
static gchar* option_parser_includedir = NULL;
static gboolean option_parser_compile_only;
static gboolean option_parser_compile_only = FALSE;
static gchar* option_parser_output;
static gchar* option_parser_output = NULL;
static gboolean option_parser_debug;
static gboolean option_parser_debug = FALSE;
static gboolean option_parser_thread;
static gboolean option_parser_thread = FALSE;
static gboolean option_parser_mem_profiler;
static gboolean option_parser_mem_profiler = FALSE;
static gboolean option_parser_disable_assert;
static gboolean option_parser_disable_assert = FALSE;
static gboolean option_parser_enable_checking;
static gboolean option_parser_enable_checking = FALSE;
static gboolean option_parser_deprecated;
static gboolean option_parser_deprecated = FALSE;
static gboolean option_parser_experimental;
static gboolean option_parser_experimental = FALSE;
static gboolean option_parser_experimental_non_null;
static gboolean option_parser_experimental_non_null = FALSE;
static gboolean option_parser_gobject_tracing;
static gboolean option_parser_gobject_tracing = FALSE;
static gboolean option_parser_disable_warnings;
static gboolean option_parser_disable_warnings = FALSE;
static gchar* option_parser_cc_command;
static gchar* option_parser_cc_command = NULL;
static gchar** option_parser_cc_options;
static gchar** option_parser_cc_options = NULL;
static gchar* option_parser_dump_tree;
static gchar* option_parser_dump_tree = NULL;
static gboolean option_parser_save_temps;
static gboolean option_parser_save_temps = FALSE;
static gchar** option_parser_defines;
static gchar** option_parser_defines = NULL;
static gboolean option_parser_quiet_mode;
static gboolean option_parser_quiet_mode = FALSE;
static gboolean option_parser_verbose_mode;
static gboolean option_parser_verbose_mode = FALSE;
static gchar* option_parser_profile;
static gchar* option_parser_profile = NULL;
static gboolean option_parser_nostdpkg;
static gboolean option_parser_nostdpkg = FALSE;
static gboolean option_parser_enable_version_header;
static gboolean option_parser_enable_version_header = FALSE;
static gboolean option_parser_disable_version_header;
static gboolean option_parser_disable_version_header = FALSE;
static gboolean option_parser_fatal_warnings;
static gboolean option_parser_fatal_warnings = FALSE;
static gchar* option_parser_dependencies;
static gchar* option_parser_dependencies = NULL;
static gchar* option_parser_entry_point;
static gchar* option_parser_entry_point = NULL;
static gboolean option_parser_run_output;
static gboolean option_parser_run_output = FALSE;

GType parser_options_get_type (void) G_GNUC_CONST;
ParserOptions* parser_options_dup (const ParserOptions* self);
void parser_options_free (ParserOptions* self);
void parser_options_copy (const ParserOptions* self, ParserOptions* dest);
void parser_options_destroy (ParserOptions* self);
gpointer option_parser_ref (gpointer instance);
void option_parser_unref (gpointer instance);
GParamSpec* param_spec_option_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_option_parser (GValue* value, gpointer v_object);
void value_take_option_parser (GValue* value, gpointer v_object);
gpointer value_get_option_parser (const GValue* value);
GType option_parser_get_type (void) G_GNUC_CONST;
enum  {
	OPTION_PARSER_DUMMY_PROPERTY
};
static void option_parser_apply (ValaCodeContext* context, gchar** args, int args_length1, const gchar* wd, ParserOptions* result);
static gchar* option_parser_realpath (const gchar* wd, const gchar* path);
static gchar** option_parser_realpaths (const gchar* wd, gchar** paths, int paths_length1, int* result_length1);
gchar** option_parser_real_sources (const gchar* wd, int* result_length1);
static void option_parser_clear (void);
gboolean option_parser_parse (gchar** args, int args_length1);
static gchar** _vala_array_dup1 (gchar** self, int length);
void option_parser_parse_and_apply (const gchar* wd, gchar** args, int args_length1, ParserOptions* result);
Diagnostics* diagnostics_new (void);
Diagnostics* diagnostics_construct (GType object_type);
GType diagnostics_get_type (void) G_GNUC_CONST;
OptionParser* option_parser_new (void);
OptionParser* option_parser_construct (GType object_type);
static void option_parser_finalize (OptionParser* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GOptionEntry OPTION_PARSER_options[50] = {{"vapidir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_parser_vapi_directories, "Look for package bindings in DIRECTORY", "DIRECTORY..."}, {"girdir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_parser_gir_directories, "Look for .gir files in DIRECTORY", "DIRECTORY..."}, {"metadatadir", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_parser_metadata_directories, "Look for GIR .metadata files in DIRECTORY", "DIRECTORY..."}, {"pkg", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &option_parser_packages, "Include binding for PACKAGE", "PACKAGE..."}, {"vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &option_parser_vapi_filename, "Output VAPI file name", "FILE"}, {"library", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_library, "Library name", "NAME"}, {"gir", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_gir, "GObject-Introspection repository file name", "NAME-VERSION.gir"}, {"basedir", 'b', 0, G_OPTION_ARG_FILENAME, &option_parser_basedir, "Base source directory", "DIRECTORY"}, {"directory", 'd', 0, G_OPTION_ARG_FILENAME, &option_parser_directory, "Output directory", "DIRECTORY"}, {"version", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_version, "Display version number", NULL}, {"api-version", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_api_version, "Display API version number", NULL}, {"ccode", 'C', 0, G_OPTION_ARG_NONE, &option_parser_ccode_only, "Output C code", NULL}, {"header", 'H', 0, G_OPTION_ARG_FILENAME, &option_parser_header_filename, "Output C header file", "FILE"}, {"use-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_use_header, "Use C header file", NULL}, {"includedir", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &option_parser_includedir, "Directory used to include the C header file", "DIRECTORY"}, {"internal-header", 'h', 0, G_OPTION_ARG_FILENAME, &option_parser_internal_header_filename, "Output internal C header file", "FILE"}, {"internal-vapi", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &option_parser_internal_vapi_filename, "Output vapi with internal api", "FILE"}, {"fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_fast_vapi_filename, "Output vapi without performing symbol resolution", NULL}, {"use-fast-vapi", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &option_parser_fast_vapis, "Use --fast-vapi output during this compile", NULL}, {"deps", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_dependencies, "Write make-style dependency information to this file", NULL}, {"symbols", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &option_parser_symbols_filename, "Output symbols file", "FILE"}, {"compile", 'c', 0, G_OPTION_ARG_NONE, &option_parser_compile_only, "Compile but do not link", NULL}, {"output", 'o', 0, G_OPTION_ARG_FILENAME, &option_parser_output, "Place output in file FILE", "FILE"}, {"debug", 'g', 0, G_OPTION_ARG_NONE, &option_parser_debug, "Produce debug information", NULL}, {"thread", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_thread, "Enable multithreading support", NULL}, {"enable-mem-profiler", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_mem_profiler, "Enable GLib memory profiler", NULL}, {"define", 'D', 0, G_OPTION_ARG_STRING_ARRAY, &option_parser_defines, "Define SYMBOL", "SYMBOL..."}, {"main", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_entry_point, "Use SYMBOL as entry point", "SYMBOL..."}, {"nostdpkg", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_nostdpkg, "Do not include standard packages", NULL}, {"disable-assert", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_disable_assert, "Disable assertions", NULL}, {"enable-checking", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_enable_checking, "Enable additional run-time checks", NULL}, {"enable-deprecated", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_deprecated, "Enable deprecated features", NULL}, {"enable-experimental", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_experimental, "Enable experimental features", NULL}, {"disable-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_disable_warnings, "Disable warnings", NULL}, {"fatal-warnings", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_fatal_warnings, "Treat warnings as fatal", NULL}, {"enable-experimental-non-null", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_experimental_non_null, "Enable experimental enhancements for non-null types", NULL}, {"enable-gobject-tracing", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_gobject_tracing, "Enable GObject creation tracing", NULL}, {"cc", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_cc_command, "Use COMMAND as C compiler command", "COMMAND"}, {"Xcc", 'X', 0, G_OPTION_ARG_STRING_ARRAY, &option_parser_cc_options, "Pass OPTION to the C compiler", "OPTION..."}, {"dump-tree", (gchar) 0, 0, G_OPTION_ARG_FILENAME, &option_parser_dump_tree, "Write code tree to FILE", "FILE"}, {"save-temps", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_save_temps, "Keep temporary files", NULL}, {"profile", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_profile, "Use the given profile instead of the default", "PROFILE"}, {"quiet", 'q', 0, G_OPTION_ARG_NONE, &option_parser_quiet_mode, "Do not print messages to the console", NULL}, {"verbose", 'v', 0, G_OPTION_ARG_NONE, &option_parser_verbose_mode, "Print additional messages to the console", NULL}, {"target-glib", (gchar) 0, 0, G_OPTION_ARG_STRING, &option_parser_target_glib, "Target version of glib for code generation", "MAJOR.MINOR"}, {"gresources", (gchar) 0, 0, G_OPTION_ARG_STRING_ARRAY, &option_parser_gresources, "XML of gresources", "FILE..."}, {"enable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_enable_version_header, "Write vala build version in generated files", NULL}, {"disable-version-header", (gchar) 0, 0, G_OPTION_ARG_NONE, &option_parser_disable_version_header, "Do not write vala build version in generated files", NULL}, {"", (gchar) 0, 0, G_OPTION_ARG_FILENAME_ARRAY, &option_parser_sources, NULL, "FILE..."}, {NULL}};

static gpointer _vala_code_context_ref0 (gpointer self) {
	return self ? vala_code_context_ref (self) : NULL;
}


void parser_options_copy (const ParserOptions* self, ParserOptions* dest) {
	ValaCodeContext* _tmp0_ = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = (*self).context;
	_tmp1_ = _vala_code_context_ref0 (_tmp0_);
	_vala_code_context_unref0 ((*dest).context);
	(*dest).context = _tmp1_;
	_tmp2_ = (*self).fatal_warnings;
	(*dest).fatal_warnings = _tmp2_;
}


void parser_options_destroy (ParserOptions* self) {
	_vala_code_context_unref0 ((*self).context);
}


ParserOptions* parser_options_dup (const ParserOptions* self) {
	ParserOptions* dup;
	dup = g_new0 (ParserOptions, 1);
	parser_options_copy (self, dup);
	return dup;
}


void parser_options_free (ParserOptions* self) {
	parser_options_destroy (self);
	g_free (self);
}


GType parser_options_get_type (void) {
	static volatile gsize parser_options_type_id__volatile = 0;
	if (g_once_init_enter (&parser_options_type_id__volatile)) {
		GType parser_options_type_id;
		parser_options_type_id = g_boxed_type_register_static ("ParserOptions", (GBoxedCopyFunc) parser_options_dup, (GBoxedFreeFunc) parser_options_free);
		g_once_init_leave (&parser_options_type_id__volatile, parser_options_type_id);
	}
	return parser_options_type_id__volatile;
}


static void option_parser_apply (ValaCodeContext* context, gchar** args, int args_length1, const gchar* wd, ParserOptions* result) {
	ValaCodeContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	ValaCodeContext* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	ValaCodeContext* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	ValaCodeContext* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	ValaCodeContext* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	ValaCodeContext* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	ValaCodeContext* _tmp12_ = NULL;
	ValaReport* _tmp13_ = NULL;
	ValaReport* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	ValaCodeContext* _tmp16_ = NULL;
	ValaReport* _tmp17_ = NULL;
	ValaReport* _tmp18_ = NULL;
	gboolean _tmp19_ = FALSE;
	ValaCodeContext* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	ValaCodeContext* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	ValaCodeContext* _tmp24_ = NULL;
	gboolean _tmp25_ = FALSE;
	ValaCodeContext* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	ValaCodeContext* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	const gchar* _tmp31_ = NULL;
	gboolean _tmp33_ = FALSE;
	ValaCodeContext* _tmp34_ = NULL;
	gboolean _tmp35_ = FALSE;
	ValaCodeContext* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	ValaCodeContext* _tmp38_ = NULL;
	const gchar* _tmp39_ = NULL;
	ValaCodeContext* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	ValaCodeContext* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	const gchar* _tmp52_ = NULL;
	ValaCodeContext* _tmp62_ = NULL;
	const gchar* _tmp63_ = NULL;
	gchar** _tmp64_ = NULL;
	gint _tmp64__length1 = 0;
	gint _tmp65_ = 0;
	gchar** _tmp66_ = NULL;
	ValaCodeContext* _tmp67_ = NULL;
	const gchar* _tmp68_ = NULL;
	gchar** _tmp69_ = NULL;
	gint _tmp69__length1 = 0;
	gint _tmp70_ = 0;
	gchar** _tmp71_ = NULL;
	ValaCodeContext* _tmp72_ = NULL;
	const gchar* _tmp73_ = NULL;
	gchar** _tmp74_ = NULL;
	gint _tmp74__length1 = 0;
	gint _tmp75_ = 0;
	gchar** _tmp76_ = NULL;
	ValaCodeContext* _tmp77_ = NULL;
	gboolean _tmp78_ = FALSE;
	ValaCodeContext* _tmp79_ = NULL;
	gboolean _tmp80_ = FALSE;
	ValaCodeContext* _tmp81_ = NULL;
	gboolean _tmp82_ = FALSE;
	ValaCodeContext* _tmp83_ = NULL;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	gboolean _tmp86_ = FALSE;
	const gchar* _tmp87_ = NULL;
	gboolean _tmp89_ = FALSE;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp97_ = FALSE;
	const gchar* _tmp98_ = NULL;
	ValaCodeContext* _tmp99_ = NULL;
	gboolean _tmp100_ = FALSE;
	ValaCodeContext* _tmp101_ = NULL;
	const gchar* _tmp102_ = NULL;
	ValaCodeContext* _tmp103_ = NULL;
	gboolean _tmp104_ = FALSE;
	gchar** _tmp105_ = NULL;
	gint _tmp105__length1 = 0;
	gint glib_major = 0;
	gint glib_minor = 0;
	gboolean _tmp118_ = FALSE;
	const gchar* _tmp119_ = NULL;
	gboolean _tmp122_ = FALSE;
	ValaCodeContext* _tmp123_ = NULL;
	gint _tmp124_ = 0;
	ValaCodeContext* _tmp125_ = NULL;
	gint _tmp126_ = 0;
	ValaCodeContext* _tmp127_ = NULL;
	gint _tmp128_ = 0;
	gint _tmp129_ = 0;
	gboolean _tmp139_ = FALSE;
	gchar** _tmp142_ = NULL;
	gint _tmp142__length1 = 0;
	gchar** _tmp147_ = NULL;
	gint _tmp147__length1 = 0;
	gboolean _tmp159_ = FALSE;
	ValaCodeContext* _tmp160_ = NULL;
	ValaCodeContext* _tmp161_ = NULL;
	ParserOptions _tmp162_ = {0};
	g_return_if_fail (context != NULL);
	g_return_if_fail (wd != NULL);
	_tmp0_ = context;
	_tmp1_ = option_parser_disable_assert;
	vala_code_context_set_assert (_tmp0_, !_tmp1_);
	_tmp2_ = context;
	_tmp3_ = option_parser_enable_checking;
	vala_code_context_set_checking (_tmp2_, _tmp3_);
	_tmp4_ = context;
	_tmp5_ = option_parser_deprecated;
	vala_code_context_set_deprecated (_tmp4_, _tmp5_);
	_tmp6_ = context;
	_tmp7_ = option_parser_experimental;
	vala_code_context_set_experimental (_tmp6_, _tmp7_);
	_tmp8_ = context;
	_tmp9_ = option_parser_experimental_non_null;
	vala_code_context_set_experimental_non_null (_tmp8_, _tmp9_);
	_tmp10_ = context;
	_tmp11_ = option_parser_gobject_tracing;
	vala_code_context_set_gobject_tracing (_tmp10_, _tmp11_);
	_tmp12_ = context;
	_tmp13_ = vala_code_context_get_report (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = option_parser_disable_warnings;
	vala_report_set_enable_warnings (_tmp14_, !_tmp15_);
	_tmp16_ = context;
	_tmp17_ = vala_code_context_get_report (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = option_parser_quiet_mode;
	vala_report_set_verbose_errors (_tmp18_, !_tmp19_);
	_tmp20_ = context;
	_tmp21_ = option_parser_verbose_mode;
	vala_code_context_set_verbose_mode (_tmp20_, _tmp21_);
	_tmp22_ = context;
	_tmp23_ = option_parser_disable_version_header;
	vala_code_context_set_version_header (_tmp22_, !_tmp23_);
	_tmp24_ = context;
	_tmp25_ = option_parser_ccode_only;
	vala_code_context_set_ccode_only (_tmp24_, _tmp25_);
	_tmp26_ = context;
	_tmp27_ = option_parser_compile_only;
	vala_code_context_set_compile_only (_tmp26_, _tmp27_);
	_tmp28_ = context;
	_tmp29_ = option_parser_header_filename;
	vala_code_context_set_header_filename (_tmp28_, _tmp29_);
	_tmp31_ = option_parser_header_filename;
	if (_tmp31_ == NULL) {
		gboolean _tmp32_ = FALSE;
		_tmp32_ = option_parser_use_header;
		_tmp30_ = _tmp32_;
	} else {
		_tmp30_ = FALSE;
	}
	_tmp33_ = _tmp30_;
	if (_tmp33_) {
		vala_report_error (NULL, "--use-header may only be used in combination with --header");
	}
	_tmp34_ = context;
	_tmp35_ = option_parser_use_header;
	vala_code_context_set_use_header (_tmp34_, _tmp35_);
	_tmp36_ = context;
	_tmp37_ = option_parser_internal_header_filename;
	vala_code_context_set_internal_header_filename (_tmp36_, _tmp37_);
	_tmp38_ = context;
	_tmp39_ = option_parser_symbols_filename;
	vala_code_context_set_symbols_filename (_tmp38_, _tmp39_);
	_tmp40_ = context;
	_tmp41_ = option_parser_includedir;
	vala_code_context_set_includedir (_tmp40_, _tmp41_);
	_tmp42_ = context;
	_tmp43_ = option_parser_output;
	vala_code_context_set_output (_tmp42_, _tmp43_);
	_tmp44_ = option_parser_basedir;
	if (_tmp44_ == NULL) {
		ValaCodeContext* _tmp45_ = NULL;
		const gchar* _tmp46_ = NULL;
		_tmp45_ = context;
		_tmp46_ = wd;
		vala_code_context_set_basedir (_tmp45_, _tmp46_);
	} else {
		ValaCodeContext* _tmp47_ = NULL;
		const gchar* _tmp48_ = NULL;
		const gchar* _tmp49_ = NULL;
		gchar* _tmp50_ = NULL;
		gchar* _tmp51_ = NULL;
		_tmp47_ = context;
		_tmp48_ = wd;
		_tmp49_ = option_parser_basedir;
		_tmp50_ = option_parser_realpath (_tmp48_, _tmp49_);
		_tmp51_ = _tmp50_;
		vala_code_context_set_basedir (_tmp47_, _tmp51_);
		_g_free0 (_tmp51_);
	}
	_tmp52_ = option_parser_directory;
	if (_tmp52_ != NULL) {
		ValaCodeContext* _tmp53_ = NULL;
		const gchar* _tmp54_ = NULL;
		const gchar* _tmp55_ = NULL;
		gchar* _tmp56_ = NULL;
		gchar* _tmp57_ = NULL;
		_tmp53_ = context;
		_tmp54_ = wd;
		_tmp55_ = option_parser_directory;
		_tmp56_ = option_parser_realpath (_tmp54_, _tmp55_);
		_tmp57_ = _tmp56_;
		vala_code_context_set_directory (_tmp53_, _tmp57_);
		_g_free0 (_tmp57_);
	} else {
		ValaCodeContext* _tmp58_ = NULL;
		ValaCodeContext* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		const gchar* _tmp61_ = NULL;
		_tmp58_ = context;
		_tmp59_ = context;
		_tmp60_ = vala_code_context_get_basedir (_tmp59_);
		_tmp61_ = _tmp60_;
		vala_code_context_set_directory (_tmp58_, _tmp61_);
	}
	_tmp62_ = context;
	_tmp63_ = wd;
	_tmp64_ = option_parser_vapi_directories;
	_tmp64__length1 = _vala_array_length (option_parser_vapi_directories);
	_tmp66_ = option_parser_realpaths (_tmp63_, _tmp64_, _tmp64__length1, &_tmp65_);
	_tmp62_->vapi_directories = (_vala_array_free (_tmp62_->vapi_directories, _tmp62_->vapi_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp62_->vapi_directories = _tmp66_;
	_tmp62_->vapi_directories_length1 = _tmp65_;
	_tmp67_ = context;
	_tmp68_ = wd;
	_tmp69_ = option_parser_gir_directories;
	_tmp69__length1 = _vala_array_length (option_parser_gir_directories);
	_tmp71_ = option_parser_realpaths (_tmp68_, _tmp69_, _tmp69__length1, &_tmp70_);
	_tmp67_->gir_directories = (_vala_array_free (_tmp67_->gir_directories, _tmp67_->gir_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp67_->gir_directories = _tmp71_;
	_tmp67_->gir_directories_length1 = _tmp70_;
	_tmp72_ = context;
	_tmp73_ = wd;
	_tmp74_ = option_parser_metadata_directories;
	_tmp74__length1 = _vala_array_length (option_parser_metadata_directories);
	_tmp76_ = option_parser_realpaths (_tmp73_, _tmp74_, _tmp74__length1, &_tmp75_);
	_tmp72_->metadata_directories = (_vala_array_free (_tmp72_->metadata_directories, _tmp72_->metadata_directories_length1, (GDestroyNotify) g_free), NULL);
	_tmp72_->metadata_directories = _tmp76_;
	_tmp72_->metadata_directories_length1 = _tmp75_;
	_tmp77_ = context;
	_tmp78_ = option_parser_debug;
	vala_code_context_set_debug (_tmp77_, _tmp78_);
	_tmp79_ = context;
	_tmp80_ = option_parser_thread;
	vala_code_context_set_thread (_tmp79_, _tmp80_);
	_tmp81_ = context;
	_tmp82_ = option_parser_mem_profiler;
	vala_code_context_set_mem_profiler (_tmp81_, _tmp82_);
	_tmp83_ = context;
	_tmp84_ = option_parser_save_temps;
	vala_code_context_set_save_temps (_tmp83_, _tmp84_);
	_tmp87_ = option_parser_profile;
	if (g_strcmp0 (_tmp87_, "gobject-2.0") == 0) {
		_tmp86_ = TRUE;
	} else {
		const gchar* _tmp88_ = NULL;
		_tmp88_ = option_parser_profile;
		_tmp86_ = g_strcmp0 (_tmp88_, "gobject") == 0;
	}
	_tmp89_ = _tmp86_;
	if (_tmp89_) {
		_tmp85_ = TRUE;
	} else {
		const gchar* _tmp90_ = NULL;
		_tmp90_ = option_parser_profile;
		_tmp85_ = _tmp90_ == NULL;
	}
	_tmp91_ = _tmp85_;
	if (_tmp91_) {
		ValaCodeContext* _tmp92_ = NULL;
		ValaCodeContext* _tmp93_ = NULL;
		_tmp92_ = context;
		vala_code_context_set_profile (_tmp92_, VALA_PROFILE_GOBJECT);
		_tmp93_ = context;
		vala_code_context_add_define (_tmp93_, "GOBJECT");
	} else {
		const gchar* _tmp94_ = NULL;
		gchar* _tmp95_ = NULL;
		gchar* _tmp96_ = NULL;
		_tmp94_ = option_parser_profile;
		_tmp95_ = g_strdup_printf ("Unknown profile %s", _tmp94_);
		_tmp96_ = _tmp95_;
		vala_report_error (NULL, _tmp96_);
		_g_free0 (_tmp96_);
	}
	_tmp97_ = option_parser_nostdpkg;
	_tmp98_ = option_parser_fast_vapi_filename;
	option_parser_nostdpkg = _tmp97_ | (_tmp98_ != NULL);
	_tmp99_ = context;
	_tmp100_ = option_parser_nostdpkg;
	vala_code_context_set_nostdpkg (_tmp99_, _tmp100_);
	_tmp101_ = context;
	_tmp102_ = option_parser_entry_point;
	vala_code_context_set_entry_point_name (_tmp101_, _tmp102_);
	_tmp103_ = context;
	_tmp104_ = option_parser_run_output;
	vala_code_context_set_run_output (_tmp103_, _tmp104_);
	_tmp105_ = option_parser_defines;
	_tmp105__length1 = _vala_array_length (option_parser_defines);
	if (_tmp105_ != NULL) {
		gchar** _tmp106_ = NULL;
		gint _tmp106__length1 = 0;
		_tmp106_ = option_parser_defines;
		_tmp106__length1 = _vala_array_length (option_parser_defines);
		{
			gchar** define_collection = NULL;
			gint define_collection_length1 = 0;
			gint _define_collection_size_ = 0;
			gint define_it = 0;
			define_collection = _tmp106_;
			define_collection_length1 = _tmp106__length1;
			for (define_it = 0; define_it < _tmp106__length1; define_it = define_it + 1) {
				gchar* _tmp107_ = NULL;
				gchar* define = NULL;
				_tmp107_ = g_strdup (define_collection[define_it]);
				define = _tmp107_;
				{
					ValaCodeContext* _tmp108_ = NULL;
					const gchar* _tmp109_ = NULL;
					_tmp108_ = context;
					_tmp109_ = define;
					vala_code_context_add_define (_tmp108_, _tmp109_);
					_g_free0 (define);
				}
			}
		}
	}
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp110_ = FALSE;
			_tmp110_ = TRUE;
			while (TRUE) {
				gboolean _tmp111_ = FALSE;
				gint _tmp113_ = 0;
				ValaCodeContext* _tmp114_ = NULL;
				gint _tmp115_ = 0;
				gchar* _tmp116_ = NULL;
				gchar* _tmp117_ = NULL;
				_tmp111_ = _tmp110_;
				if (!_tmp111_) {
					gint _tmp112_ = 0;
					_tmp112_ = i;
					i = _tmp112_ + 2;
				}
				_tmp110_ = FALSE;
				_tmp113_ = i;
				if (!(_tmp113_ <= 24)) {
					break;
				}
				_tmp114_ = context;
				_tmp115_ = i;
				_tmp116_ = g_strdup_printf ("VALA_0_%d", _tmp115_);
				_tmp117_ = _tmp116_;
				vala_code_context_add_define (_tmp114_, _tmp117_);
				_g_free0 (_tmp117_);
			}
		}
	}
	glib_major = 2;
	glib_minor = 18;
	_tmp119_ = option_parser_target_glib;
	if (_tmp119_ != NULL) {
		const gchar* _tmp120_ = NULL;
		gint _tmp121_ = 0;
		_tmp120_ = option_parser_target_glib;
		_tmp121_ = sscanf (_tmp120_, "%d.%d", &glib_major, &glib_minor);
		_tmp118_ = _tmp121_ != 2;
	} else {
		_tmp118_ = FALSE;
	}
	_tmp122_ = _tmp118_;
	if (_tmp122_) {
		vala_report_error (NULL, "Invalid format for --target-glib");
	}
	_tmp123_ = context;
	_tmp124_ = glib_major;
	vala_code_context_set_target_glib_major (_tmp123_, _tmp124_);
	_tmp125_ = context;
	_tmp126_ = glib_minor;
	vala_code_context_set_target_glib_minor (_tmp125_, _tmp126_);
	_tmp127_ = context;
	_tmp128_ = vala_code_context_get_target_glib_major (_tmp127_);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != 2) {
		vala_report_error (NULL, "This version of valac only supports GLib 2");
	}
	{
		gint i = 0;
		i = 16;
		{
			gboolean _tmp130_ = FALSE;
			_tmp130_ = TRUE;
			while (TRUE) {
				gboolean _tmp131_ = FALSE;
				gint _tmp133_ = 0;
				gint _tmp134_ = 0;
				ValaCodeContext* _tmp135_ = NULL;
				gint _tmp136_ = 0;
				gchar* _tmp137_ = NULL;
				gchar* _tmp138_ = NULL;
				_tmp131_ = _tmp130_;
				if (!_tmp131_) {
					gint _tmp132_ = 0;
					_tmp132_ = i;
					i = _tmp132_ + 2;
				}
				_tmp130_ = FALSE;
				_tmp133_ = i;
				_tmp134_ = glib_minor;
				if (!(_tmp133_ <= _tmp134_)) {
					break;
				}
				_tmp135_ = context;
				_tmp136_ = i;
				_tmp137_ = g_strdup_printf ("GLIB_2_%d", _tmp136_);
				_tmp138_ = _tmp137_;
				vala_code_context_add_define (_tmp135_, _tmp138_);
				_g_free0 (_tmp138_);
			}
		}
	}
	_tmp139_ = option_parser_nostdpkg;
	if (!_tmp139_) {
		ValaCodeContext* _tmp140_ = NULL;
		ValaCodeContext* _tmp141_ = NULL;
		_tmp140_ = context;
		vala_code_context_add_external_package (_tmp140_, "glib-2.0");
		_tmp141_ = context;
		vala_code_context_add_external_package (_tmp141_, "gobject-2.0");
	}
	_tmp142_ = option_parser_packages;
	_tmp142__length1 = _vala_array_length (option_parser_packages);
	if (_tmp142_ != NULL) {
		gchar** _tmp143_ = NULL;
		gint _tmp143__length1 = 0;
		_tmp143_ = option_parser_packages;
		_tmp143__length1 = _vala_array_length (option_parser_packages);
		{
			gchar** package_collection = NULL;
			gint package_collection_length1 = 0;
			gint _package_collection_size_ = 0;
			gint package_it = 0;
			package_collection = _tmp143_;
			package_collection_length1 = _tmp143__length1;
			for (package_it = 0; package_it < _tmp143__length1; package_it = package_it + 1) {
				gchar* _tmp144_ = NULL;
				gchar* package = NULL;
				_tmp144_ = g_strdup (package_collection[package_it]);
				package = _tmp144_;
				{
					ValaCodeContext* _tmp145_ = NULL;
					const gchar* _tmp146_ = NULL;
					_tmp145_ = context;
					_tmp146_ = package;
					vala_code_context_add_external_package (_tmp145_, _tmp146_);
					_g_free0 (package);
				}
			}
		}
		option_parser_packages = (_vala_array_free (option_parser_packages, _vala_array_length (option_parser_packages), (GDestroyNotify) g_free), NULL);
		option_parser_packages = NULL;
	}
	_tmp147_ = option_parser_fast_vapis;
	_tmp147__length1 = _vala_array_length (option_parser_fast_vapis);
	if (_tmp147_ != NULL) {
		gchar** _tmp148_ = NULL;
		gint _tmp148__length1 = 0;
		ValaCodeContext* _tmp158_ = NULL;
		_tmp148_ = option_parser_fast_vapis;
		_tmp148__length1 = _vala_array_length (option_parser_fast_vapis);
		{
			gchar** vapi_collection = NULL;
			gint vapi_collection_length1 = 0;
			gint _vapi_collection_size_ = 0;
			gint vapi_it = 0;
			vapi_collection = _tmp148_;
			vapi_collection_length1 = _tmp148__length1;
			for (vapi_it = 0; vapi_it < _tmp148__length1; vapi_it = vapi_it + 1) {
				gchar* _tmp149_ = NULL;
				gchar* vapi = NULL;
				_tmp149_ = g_strdup (vapi_collection[vapi_it]);
				vapi = _tmp149_;
				{
					gchar* rpath = NULL;
					const gchar* _tmp150_ = NULL;
					const gchar* _tmp151_ = NULL;
					gchar* _tmp152_ = NULL;
					ValaSourceFile* source_file = NULL;
					ValaCodeContext* _tmp153_ = NULL;
					const gchar* _tmp154_ = NULL;
					ValaSourceFile* _tmp155_ = NULL;
					ValaCodeContext* _tmp156_ = NULL;
					ValaSourceFile* _tmp157_ = NULL;
					_tmp150_ = wd;
					_tmp151_ = vapi;
					_tmp152_ = option_parser_realpath (_tmp150_, _tmp151_);
					rpath = _tmp152_;
					_tmp153_ = context;
					_tmp154_ = rpath;
					_tmp155_ = vala_source_file_new (_tmp153_, VALA_SOURCE_FILE_TYPE_FAST, _tmp154_, NULL, FALSE);
					source_file = _tmp155_;
					_tmp156_ = context;
					_tmp157_ = source_file;
					vala_code_context_add_source_file (_tmp156_, _tmp157_);
					_vala_source_file_unref0 (source_file);
					_g_free0 (rpath);
					_g_free0 (vapi);
				}
			}
		}
		_tmp158_ = context;
		vala_code_context_set_use_fast_vapi (_tmp158_, TRUE);
	}
	_tmp159_ = option_parser_fatal_warnings;
	_tmp160_ = context;
	_tmp161_ = _vala_code_context_ref0 (_tmp160_);
	memset (&_tmp162_, 0, sizeof (ParserOptions));
	_tmp162_.fatal_warnings = _tmp159_;
	_vala_code_context_unref0 (_tmp162_.context);
	_tmp162_.context = _tmp161_;
	*result = _tmp162_;
	return;
}


gchar** option_parser_real_sources (const gchar* wd, int* result_length1) {
	gchar** result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (wd != NULL, NULL);
	_tmp0_ = wd;
	_tmp1_ = option_parser_sources;
	_tmp1__length1 = _vala_array_length (option_parser_sources);
	_tmp3_ = option_parser_realpaths (_tmp0_, _tmp1_, _tmp1__length1, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static gchar** option_parser_realpaths (const gchar* wd, gchar** paths, int paths_length1, int* result_length1) {
	gchar** result = NULL;
	gchar** ret = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	gchar** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	g_return_val_if_fail (wd != NULL, NULL);
	_tmp0_ = paths;
	_tmp0__length1 = paths_length1;
	_tmp1_ = g_new0 (gchar*, _tmp0__length1 + 1);
	ret = _tmp1_;
	ret_length1 = _tmp0__length1;
	_ret_size_ = ret_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				const gchar* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				gint _tmp11_ = 0;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = paths;
				_tmp6__length1 = paths_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = ret;
				_tmp7__length1 = ret_length1;
				_tmp8_ = i;
				_tmp9_ = wd;
				_tmp10_ = paths;
				_tmp10__length1 = paths_length1;
				_tmp11_ = i;
				_tmp12_ = _tmp10_[_tmp11_];
				_tmp13_ = option_parser_realpath (_tmp9_, _tmp12_);
				_g_free0 (_tmp7_[_tmp8_]);
				_tmp7_[_tmp8_] = _tmp13_;
				_tmp14_ = _tmp7_[_tmp8_];
			}
		}
	}
	_tmp15_ = ret;
	_tmp15__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp15__length1;
	}
	result = _tmp15_;
	return result;
}


static gchar* option_parser_realpath (const gchar* wd, const gchar* path) {
	gchar* result = NULL;
	gchar* rpath = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp7_ = NULL;
	GFile* _tmp8_ = NULL;
	GFile* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	g_return_val_if_fail (wd != NULL, NULL);
	g_return_val_if_fail (path != NULL, NULL);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	rpath = _tmp1_;
	_tmp2_ = path;
	_tmp3_ = g_path_is_absolute (_tmp2_);
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp4_ = wd;
		_tmp5_ = rpath;
		_tmp6_ = g_build_filename (_tmp4_, _tmp5_, NULL);
		_g_free0 (rpath);
		rpath = _tmp6_;
	}
	_tmp7_ = rpath;
	_tmp8_ = g_file_new_for_path (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	result = _tmp11_;
	_g_free0 (rpath);
	return result;
}


static void option_parser_clear (void) {
	_g_free0 (option_parser_basedir);
	option_parser_basedir = NULL;
	_g_free0 (option_parser_directory);
	option_parser_directory = NULL;
	option_parser_version = FALSE;
	option_parser_api_version = FALSE;
	option_parser_sources = (_vala_array_free (option_parser_sources, _vala_array_length (option_parser_sources), (GDestroyNotify) g_free), NULL);
	option_parser_sources = NULL;
	option_parser_vapi_directories = (_vala_array_free (option_parser_vapi_directories, _vala_array_length (option_parser_vapi_directories), (GDestroyNotify) g_free), NULL);
	option_parser_vapi_directories = NULL;
	option_parser_gir_directories = (_vala_array_free (option_parser_gir_directories, _vala_array_length (option_parser_gir_directories), (GDestroyNotify) g_free), NULL);
	option_parser_gir_directories = NULL;
	option_parser_metadata_directories = (_vala_array_free (option_parser_metadata_directories, _vala_array_length (option_parser_metadata_directories), (GDestroyNotify) g_free), NULL);
	option_parser_metadata_directories = NULL;
	_g_free0 (option_parser_vapi_filename);
	option_parser_vapi_filename = NULL;
	_g_free0 (option_parser_library);
	option_parser_library = NULL;
	_g_free0 (option_parser_gir);
	option_parser_gir = NULL;
	option_parser_packages = (_vala_array_free (option_parser_packages, _vala_array_length (option_parser_packages), (GDestroyNotify) g_free), NULL);
	option_parser_packages = NULL;
	option_parser_fast_vapis = (_vala_array_free (option_parser_fast_vapis, _vala_array_length (option_parser_fast_vapis), (GDestroyNotify) g_free), NULL);
	option_parser_fast_vapis = NULL;
	_g_free0 (option_parser_target_glib);
	option_parser_target_glib = NULL;
	option_parser_gresources = (_vala_array_free (option_parser_gresources, _vala_array_length (option_parser_gresources), (GDestroyNotify) g_free), NULL);
	option_parser_gresources = NULL;
	option_parser_ccode_only = FALSE;
	_g_free0 (option_parser_header_filename);
	option_parser_header_filename = NULL;
	option_parser_use_header = FALSE;
	_g_free0 (option_parser_internal_header_filename);
	option_parser_internal_header_filename = NULL;
	_g_free0 (option_parser_internal_vapi_filename);
	option_parser_internal_vapi_filename = NULL;
	_g_free0 (option_parser_fast_vapi_filename);
	option_parser_fast_vapi_filename = NULL;
	_g_free0 (option_parser_symbols_filename);
	option_parser_symbols_filename = NULL;
	_g_free0 (option_parser_includedir);
	option_parser_includedir = NULL;
	option_parser_compile_only = FALSE;
	_g_free0 (option_parser_output);
	option_parser_output = NULL;
	option_parser_debug = FALSE;
	option_parser_thread = FALSE;
	option_parser_mem_profiler = FALSE;
	option_parser_disable_assert = FALSE;
	option_parser_enable_checking = FALSE;
	option_parser_deprecated = FALSE;
	option_parser_experimental = FALSE;
	option_parser_experimental_non_null = FALSE;
	option_parser_gobject_tracing = FALSE;
	option_parser_disable_warnings = FALSE;
	_g_free0 (option_parser_cc_command);
	option_parser_cc_command = NULL;
	option_parser_cc_options = (_vala_array_free (option_parser_cc_options, _vala_array_length (option_parser_cc_options), (GDestroyNotify) g_free), NULL);
	option_parser_cc_options = NULL;
	_g_free0 (option_parser_dump_tree);
	option_parser_dump_tree = NULL;
	option_parser_save_temps = FALSE;
	option_parser_defines = (_vala_array_free (option_parser_defines, _vala_array_length (option_parser_defines), (GDestroyNotify) g_free), NULL);
	option_parser_defines = NULL;
	option_parser_quiet_mode = FALSE;
	option_parser_verbose_mode = FALSE;
	_g_free0 (option_parser_profile);
	option_parser_profile = NULL;
	option_parser_nostdpkg = FALSE;
	option_parser_enable_version_header = FALSE;
	option_parser_disable_version_header = FALSE;
	option_parser_fatal_warnings = FALSE;
	_g_free0 (option_parser_dependencies);
	option_parser_dependencies = NULL;
	_g_free0 (option_parser_entry_point);
	option_parser_entry_point = NULL;
	option_parser_run_output = FALSE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


gboolean option_parser_parse (gchar** args, int args_length1) {
	gboolean result = FALSE;
	gchar** myargs = NULL;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	gint myargs_length1 = 0;
	gint _myargs_size_ = 0;
	GError * _inner_error_ = NULL;
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
	_tmp1__length1 = _tmp0__length1;
	myargs = _tmp1_;
	myargs_length1 = _tmp1__length1;
	_myargs_size_ = myargs_length1;
	{
		gchar** unargs = NULL;
		gchar** _tmp2_ = NULL;
		gint _tmp2__length1 = 0;
		gint unargs_length1 = 0;
		gint _unargs_size_ = 0;
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp3_ = NULL;
		GOptionContext* _tmp4_ = NULL;
		GOptionContext* _tmp5_ = NULL;
		GOptionContext* _tmp6_ = NULL;
		GOptionContext* _tmp7_ = NULL;
		_tmp2_ = myargs;
		_tmp2__length1 = myargs_length1;
		unargs = _tmp2_;
		unargs_length1 = _tmp2__length1;
		_unargs_size_ = unargs_length1;
		option_parser_clear ();
		_tmp3_ = g_option_context_new ("- Vala Compiler");
		opt_context = _tmp3_;
		_tmp4_ = opt_context;
		g_option_context_set_help_enabled (_tmp4_, FALSE);
		_tmp5_ = opt_context;
		g_option_context_add_main_entries (_tmp5_, OPTION_PARSER_options, NULL);
		_tmp6_ = opt_context;
		g_option_context_set_ignore_unknown_options (_tmp6_, TRUE);
		_tmp7_ = opt_context;
		g_option_context_parse (_tmp7_, &unargs_length1, &unargs, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_option_context_free0 (opt_context);
			goto __catch0_g_error;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar** _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = args;
		_tmp8__length1 = args_length1;
		_tmp9_ = g_strjoinv (", ", _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_log ("GcaVala", G_LOG_LEVEL_WARNING, "valaoptionparser.vala:359: Failed to parse flags `%s': %s", _tmp10_, _tmp12_);
		_g_free0 (_tmp10_);
		option_parser_clear ();
		result = FALSE;
		_g_error_free0 (e);
		myargs = (_vala_array_free (myargs, myargs_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		myargs = (_vala_array_free (myargs, myargs_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	myargs = (_vala_array_free (myargs, myargs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


void option_parser_parse_and_apply (const gchar* wd, gchar** args, int args_length1, ParserOptions* result) {
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	ValaCodeContext* context = NULL;
	ValaCodeContext* _tmp1_ = NULL;
	Diagnostics* _tmp2_ = NULL;
	Diagnostics* _tmp3_ = NULL;
	ParserOptions ret = {0};
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	ParserOptions _tmp6_ = {0};
	g_return_if_fail (wd != NULL);
	_tmp0_ = args;
	_tmp0__length1 = args_length1;
	option_parser_parse (_tmp0_, _tmp0__length1);
	_tmp1_ = vala_code_context_new ();
	context = _tmp1_;
	_tmp2_ = diagnostics_new ();
	_tmp3_ = _tmp2_;
	vala_code_context_set_report (context, (ValaReport*) _tmp3_);
	_g_object_unref0 (_tmp3_);
	vala_code_context_push (context);
	_tmp4_ = args;
	_tmp4__length1 = args_length1;
	_tmp5_ = wd;
	option_parser_apply (context, _tmp4_, _tmp4__length1, _tmp5_, &_tmp6_);
	ret = _tmp6_;
	vala_code_context_pop ();
	*result = ret;
	_vala_code_context_unref0 (context);
	return;
}


OptionParser* option_parser_construct (GType object_type) {
	OptionParser* self = NULL;
	self = (OptionParser*) g_type_create_instance (object_type);
	return self;
}


OptionParser* option_parser_new (void) {
	return option_parser_construct (TYPE_OPTION_PARSER);
}


static void value_option_parser_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_option_parser_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		option_parser_unref (value->data[0].v_pointer);
	}
}


static void value_option_parser_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = option_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_option_parser_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_option_parser_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		OptionParser* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = option_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_option_parser_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	OptionParser** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = option_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_option_parser (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecOptionParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_OPTION_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_option_parser (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPTION_PARSER), NULL);
	return value->data[0].v_pointer;
}


void value_set_option_parser (GValue* value, gpointer v_object) {
	OptionParser* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPTION_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OPTION_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		option_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		option_parser_unref (old);
	}
}


void value_take_option_parser (GValue* value, gpointer v_object) {
	OptionParser* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_OPTION_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_OPTION_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		option_parser_unref (old);
	}
}


static void option_parser_class_init (OptionParserClass * klass) {
	option_parser_parent_class = g_type_class_peek_parent (klass);
	OPTION_PARSER_CLASS (klass)->finalize = option_parser_finalize;
}


static void option_parser_instance_init (OptionParser * self) {
	self->ref_count = 1;
}


static void option_parser_finalize (OptionParser* obj) {
	OptionParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_OPTION_PARSER, OptionParser);
}


GType option_parser_get_type (void) {
	static volatile gsize option_parser_type_id__volatile = 0;
	if (g_once_init_enter (&option_parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_option_parser_init, value_option_parser_free_value, value_option_parser_copy_value, value_option_parser_peek_pointer, "p", value_option_parser_collect_value, "p", value_option_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (OptionParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) option_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (OptionParser), 0, (GInstanceInitFunc) option_parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType option_parser_type_id;
		option_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "OptionParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&option_parser_type_id__volatile, option_parser_type_id);
	}
	return option_parser_type_id__volatile;
}


gpointer option_parser_ref (gpointer instance) {
	OptionParser* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void option_parser_unref (gpointer instance) {
	OptionParser* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		OPTION_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



