/* service.c generated by valac 0.22.1, the Vala compiler
 * generated from service.vala, do not modify */

/*
 * This file is part of gnome-code-assistance.
 *
 * Copyright (C) 2013 - Melissa Wen <melissa.srw@gmail.com>
 * Copyright (C) 2013 - Jesse van den Kieboom <jessevdk@gnome.org>
 *
 * gnome-code-assistance is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * gnome-code-assistance is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gnome-code-assistance.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "backends/vala/libvalashared.h"
#include <gio/gunixinputstream.h>
#include <gio/gunixoutputstream.h>
#include "config.h"
#include <gee.h>
#include <gobject/gvaluecollector.h>


#define TYPE_SERVICE (service_get_type ())
#define SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERVICE, Service))
#define SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERVICE, ServiceClass))
#define IS_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERVICE))
#define IS_SERVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERVICE))
#define SERVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERVICE, ServiceClass))

typedef struct _Service Service;
typedef struct _ServiceClass ServiceClass;
typedef struct _ServicePrivate ServicePrivate;

#define TYPE_MAKEFILE_INTEGRATION (makefile_integration_get_type ())
#define MAKEFILE_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAKEFILE_INTEGRATION, MakefileIntegration))
#define MAKEFILE_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAKEFILE_INTEGRATION, MakefileIntegrationClass))
#define IS_MAKEFILE_INTEGRATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAKEFILE_INTEGRATION))
#define IS_MAKEFILE_INTEGRATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAKEFILE_INTEGRATION))
#define MAKEFILE_INTEGRATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAKEFILE_INTEGRATION, MakefileIntegrationClass))

typedef struct _MakefileIntegration MakefileIntegration;
typedef struct _MakefileIntegrationClass MakefileIntegrationClass;
#define _makefile_integration_unref0(var) ((var == NULL) ? NULL : (var = (makefile_integration_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _service_unref0(var) ((var == NULL) ? NULL : (var = (service_unref (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block1Data Block1Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _ServiceSpawnHelperData ServiceSpawnHelperData;
#define _document_unref0(var) ((var == NULL) ? NULL : (var = (document_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _ServiceParseImplData ServiceParseImplData;
typedef struct _ServiceParseData ServiceParseData;
typedef struct _ServiceParseAllData ServiceParseAllData;
typedef struct _ParamSpecService ParamSpecService;

struct _Service {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ServicePrivate * priv;
};

struct _ServiceClass {
	GTypeClass parent_class;
	void (*finalize) (Service *self);
};

struct _ServicePrivate {
	MakefileIntegration* d_makefile;
};

struct _Block1Data {
	int _ref_count_;
	Service * self;
	GSourceFunc cb;
	gpointer cb_target;
	GDestroyNotify cb_target_destroy_notify;
	GUnixInputStream* outstr;
	GUnixOutputStream* instr;
	guint8* retb;
	gint retb_length1;
	gint _retb_size_;
	Document** documents;
	gint documents_length1;
	gchar** flags;
	gint flags_length1;
	gpointer _async_data_;
};

struct _ServiceSpawnHelperData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Service* self;
	Document** documents;
	gint documents_length1;
	gchar* wd;
	gchar** flags;
	gint flags_length1;
	RpcReply result;
	Block1Data* _data1_;
	Document** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** argv;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint argv_length1;
	gint _argv_size_;
	GPid pid;
	gint inp;
	gint outp;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GPid _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GError* e;
	GError* _tmp9_;
	const gchar* _tmp10_;
	RpcReply _tmp11_;
	gint _tmp12_;
	GUnixInputStream* _tmp13_;
	gint _tmp14_;
	GUnixOutputStream* _tmp15_;
	guint8* _tmp16_;
	GThread* reader;
	GThread* writer;
	GThread* _tmp17_;
	GThread* _tmp18_;
	GError* _vala1_e;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GUnixInputStream* _tmp21_;
	GThread* _tmp22_;
	GThread* _tmp23_;
	GError* _vala2_e;
	GError* _tmp24_;
	const gchar* _tmp25_;
	GUnixOutputStream* _tmp26_;
	GPid _tmp27_;
	GThread* _tmp28_;
	GThread* _tmp29_;
	GThread* _tmp30_;
	GThread* _tmp31_;
	GUnixInputStream* _tmp32_;
	GUnixOutputStream* _tmp33_;
	RpcReply r;
	GVariant* dummy;
	RpcReply _tmp34_;
	GVariant* _tmp57_;
	GVariant* reply;
	GVariant* _tmp58_;
	const GVariantType* _tmp59_;
	guint8* _tmp60_;
	gint _tmp60__length1;
	GVariant* _tmp61_;
	GVariant* _tmp62_;
	RpcReply _tmp63_;
	GError * _inner_error_;
};

struct _ServiceParseImplData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Service* self;
	Document* doc;
	Document** documents;
	gint documents_length1;
	GHashTable* options;
	Document** result;
	gint result_length1;
	GFile* f;
	Document* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	gchar* wd;
	gchar** flags;
	MakefileIntegration* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_;
	gint _tmp7_;
	gchar** _tmp8_;
	gint flags_length1;
	gint _flags_size_;
	RpcReply reply;
	Document** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	RpcReply _tmp12_;
	GeeHashMap* odocs;
	GeeHashMap* _tmp13_;
	Document** _tmp14_;
	gint _tmp14__length1;
	Document** d_collection;
	gint d_collection_length1;
	gint _d_collection_size_;
	gint d_it;
	Document* _tmp15_;
	Document* d;
	GeeHashMap* _tmp16_;
	Document* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	Document* _tmp20_;
	Document** retdocs;
	RpcReply _tmp21_;
	RpcDocument* _tmp22_;
	gint _tmp22__length1;
	Document** _tmp23_;
	gint retdocs_length1;
	gint _retdocs_size_;
	gint _tmp24_;
	RpcReply _tmp25_;
	RpcDocument* _tmp26_;
	gint _tmp26__length1;
	RpcDocument* _vala1_d_collection;
	gint _vala1_d_collection_length1;
	gint __vala1_d_collection_size_;
	gint _vala1_d_it;
	RpcDocument _tmp27_;
	RpcDocument _vala1_d;
	Document* odoc;
	GeeHashMap* _tmp28_;
	RpcDocument _tmp29_;
	const gchar* _tmp30_;
	gpointer _tmp31_;
	Document* _tmp32_;
	Document* _tmp33_;
	RpcDocument _tmp34_;
	Diagnostic* _tmp35_;
	gint _tmp35__length1;
	Document** _tmp36_;
	gint _tmp36__length1;
	Document* _tmp37_;
	Document* _tmp38_;
	Document** _tmp39_;
	gint _tmp39__length1;
};

struct _ServiceParseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Service* self;
	Document* doc;
	GHashTable* options;
	Document* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	Document** _tmp3_;
	Document** _tmp4_;
	gint _tmp4__length1;
	GHashTable* _tmp5_;
	gint _tmp6_;
	Document** _tmp7_;
	Document** _tmp8_;
	gint _tmp8__length1;
};

struct _ServiceParseAllData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	Service* self;
	Document* doc;
	Document** documents;
	gint documents_length1;
	GHashTable* options;
	Document** result;
	gint result_length1;
	Document* _tmp0_;
	Document** _tmp1_;
	gint _tmp1__length1;
	GHashTable* _tmp2_;
	gint _tmp3_;
	Document** _tmp4_;
	Document** _tmp5_;
	gint _tmp5__length1;
};

struct _ParamSpecService {
	GParamSpec parent_instance;
};


static gpointer service_parent_class = NULL;

gpointer service_ref (gpointer instance);
void service_unref (gpointer instance);
GParamSpec* param_spec_service (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_service (GValue* value, gpointer v_object);
void value_take_service (GValue* value, gpointer v_object);
gpointer value_get_service (const GValue* value);
GType service_get_type (void) G_GNUC_CONST;
gpointer makefile_integration_ref (gpointer instance);
void makefile_integration_unref (gpointer instance);
GParamSpec* param_spec_makefile_integration (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_makefile_integration (GValue* value, gpointer v_object);
void value_take_makefile_integration (GValue* value, gpointer v_object);
gpointer value_get_makefile_integration (const GValue* value);
GType makefile_integration_get_type (void) G_GNUC_CONST;
#define SERVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERVICE, ServicePrivate))
enum  {
	SERVICE_DUMMY_PROPERTY
};
Service* service_new (void);
Service* service_construct (GType object_type);
MakefileIntegration* makefile_integration_new (void);
MakefileIntegration* makefile_integration_construct (GType object_type);
static guint8* service_read_all (Service* self, GInputStream* f, int* result_length1);
static void _vala_array_add1 (guint8** array, int* length, int* size, guint8 value);
static void service_spawn_helper_data_free (gpointer _data);
gpointer document_ref (gpointer instance);
void document_unref (gpointer instance);
GParamSpec* param_spec_document (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_document (GValue* value, gpointer v_object);
void value_take_document (GValue* value, gpointer v_object);
gpointer value_get_document (const GValue* value);
GType document_get_type (void) G_GNUC_CONST;
static void service_spawn_helper (Service* self, Document** documents, int documents_length1, const gchar* wd, gchar** flags, int flags_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void service_spawn_helper_finish (Service* self, GAsyncResult* _res_, RpcReply* result);
static gboolean service_spawn_helper_co (ServiceSpawnHelperData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean _service_spawn_helper_co_gsource_func (gpointer self);
static void* ___lambda3_ (Block1Data* _data1_);
static gpointer ____lambda3__gthread_func (gpointer self);
static void* ___lambda4_ (Block1Data* _data1_);
const gchar* document_get_path (Document* self);
const gchar* document_get_data_path (Document* self);
static gchar** _vala_array_dup3 (gchar** self, int length);
static OpenDocument* _vala_array_dup4 (OpenDocument* self, int length);
static void _vala_OpenDocument_array_free (OpenDocument* array, gint array_length);
static GVariant* _variant_new1 (RpcParse value);
static gpointer ____lambda4__gthread_func (gpointer self);
static void __lambda5_ (Block1Data* _data1_, GPid p, gint st);
static void ___lambda5__gchild_watch_func (GPid pid, gint status, gpointer self);
static GVariant* _variant_new2 (RpcReply value);
static void _variant_get3 (GVariant* value, RpcReply* result);
static void service_parse_impl_data_free (gpointer _data);
static void service_parse_impl (Service* self, Document* doc, Document** documents, int documents_length1, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
static Document** service_parse_impl_finish (Service* self, GAsyncResult* _res_, int* result_length1);
static gboolean service_parse_impl_co (ServiceParseImplData* _data_);
gchar** makefile_integration_flags_for_file (MakefileIntegration* self, GFile* f, gchar** wd, int* result_length1);
static void service_parse_impl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void document_set_diagnostics (Document* self, Diagnostic* value, int value_length1);
static void _vala_array_add2 (Document*** array, int* length, int* size, Document* value);
static void service_parse_data_free (gpointer _data);
void service_parse (Service* self, Document* doc, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
void service_parse_finish (Service* self, GAsyncResult* _res_);
static gboolean service_parse_co (ServiceParseData* _data_);
static void service_parse_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void service_parse_all_data_free (gpointer _data);
void service_parse_all (Service* self, Document* doc, Document** documents, int documents_length1, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_);
Document** service_parse_all_finish (Service* self, GAsyncResult* _res_, int* result_length1);
static gboolean service_parse_all_co (ServiceParseAllData* _data_);
static void service_parse_all_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void service_dispose (Service* self, Document* document);
void makefile_integration_dispose (MakefileIntegration* self, GFile* f);
static void service_finalize (Service* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


Service* service_construct (GType object_type) {
	Service* self = NULL;
	MakefileIntegration* _tmp0_ = NULL;
	self = (Service*) g_type_create_instance (object_type);
	_tmp0_ = makefile_integration_new ();
	_makefile_integration_unref0 (self->priv->d_makefile);
	self->priv->d_makefile = _tmp0_;
	return self;
}


Service* service_new (void) {
	return service_construct (TYPE_SERVICE);
}


static void _vala_array_add1 (guint8** array, int* length, int* size, guint8 value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint8, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static guint8* service_read_all (Service* self, GInputStream* f, int* result_length1) {
	guint8* result = NULL;
	guint8* buffer = NULL;
	guint8* _tmp0_ = NULL;
	gint buffer_length1 = 0;
	gint _buffer_size_ = 0;
	guint8* ret = NULL;
	guint8* _tmp1_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (f != NULL, NULL);
	_tmp0_ = g_new0 (guint8, 4096);
	buffer = _tmp0_;
	buffer_length1 = 4096;
	_buffer_size_ = buffer_length1;
	_tmp1_ = g_new0 (guint8, 4096);
	ret = _tmp1_;
	ret_length1 = 4096;
	_ret_size_ = ret_length1;
	ret_length1 = 0;
	_tmp2_ = ret_length1;
	while (TRUE) {
		gssize n = 0L;
		gssize _tmp7_ = 0L;
		{
			gssize _tmp3_ = 0L;
			GInputStream* _tmp4_ = NULL;
			guint8* _tmp5_ = NULL;
			gint _tmp5__length1 = 0;
			gssize _tmp6_ = 0L;
			_tmp4_ = f;
			_tmp5_ = buffer;
			_tmp5__length1 = buffer_length1;
			_tmp6_ = g_input_stream_read (_tmp4_, _tmp5_, (gsize) _tmp5__length1, NULL, &_inner_error_);
			_tmp3_ = _tmp6_;
			if (_inner_error_ != NULL) {
				goto __catch8_g_error;
			}
			n = _tmp3_;
		}
		goto __finally8;
		__catch8_g_error:
		{
			g_clear_error (&_inner_error_);
			_inner_error_ = NULL;
			break;
		}
		__finally8:
		if (_inner_error_ != NULL) {
			ret = (g_free (ret), NULL);
			buffer = (g_free (buffer), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = n;
		if (_tmp7_ <= ((gssize) 0)) {
			break;
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp8_ = FALSE;
				_tmp8_ = TRUE;
				while (TRUE) {
					gboolean _tmp9_ = FALSE;
					gint _tmp11_ = 0;
					gssize _tmp12_ = 0L;
					guint8* _tmp13_ = NULL;
					gint _tmp13__length1 = 0;
					guint8* _tmp14_ = NULL;
					gint _tmp14__length1 = 0;
					gint _tmp15_ = 0;
					guint8 _tmp16_ = 0U;
					_tmp9_ = _tmp8_;
					if (!_tmp9_) {
						gint _tmp10_ = 0;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp8_ = FALSE;
					_tmp11_ = i;
					_tmp12_ = n;
					if (!(((gssize) _tmp11_) < _tmp12_)) {
						break;
					}
					_tmp13_ = ret;
					_tmp13__length1 = ret_length1;
					_tmp14_ = buffer;
					_tmp14__length1 = buffer_length1;
					_tmp15_ = i;
					_tmp16_ = _tmp14_[_tmp15_];
					_vala_array_add1 (&ret, &ret_length1, &_ret_size_, _tmp16_);
				}
			}
		}
	}
	_tmp17_ = ret;
	_tmp17__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp17__length1;
	}
	result = _tmp17_;
	buffer = (g_free (buffer), NULL);
	return result;
}


static void service_spawn_helper_data_free (gpointer _data) {
	ServiceSpawnHelperData* _data_;
	_data_ = _data;
	_g_free0 (_data_->wd);
	rpc_reply_destroy (&_data_->result);
	_service_unref0 (_data_->self);
	g_slice_free (ServiceSpawnHelperData, _data_);
}


static gpointer _service_ref0 (gpointer self) {
	return self ? service_ref (self) : NULL;
}


static void service_spawn_helper (Service* self, Document** documents, int documents_length1, const gchar* wd, gchar** flags, int flags_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ServiceSpawnHelperData* _data_;
	Service* _tmp0_ = NULL;
	Document** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	_data_ = g_slice_new0 (ServiceSpawnHelperData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, service_spawn_helper);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, service_spawn_helper_data_free);
	_tmp0_ = _service_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = documents;
	_tmp1__length1 = documents_length1;
	_data_->documents = _tmp1_;
	_data_->documents_length1 = _tmp1__length1;
	_tmp2_ = wd;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_data_->wd);
	_data_->wd = _tmp3_;
	_tmp4_ = flags;
	_tmp4__length1 = flags_length1;
	_data_->flags = _tmp4_;
	_data_->flags_length1 = _tmp4__length1;
	service_spawn_helper_co (_data_);
}


static void service_spawn_helper_finish (Service* self, GAsyncResult* _res_, RpcReply* result) {
	ServiceSpawnHelperData* _data_;
	RpcReply _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	rpc_reply_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		Service * self;
		self = _data1_->self;
		_data1_->retb = (g_free (_data1_->retb), NULL);
		_g_object_unref0 (_data1_->instr);
		_g_object_unref0 (_data1_->outstr);
		(_data1_->cb_target_destroy_notify == NULL) ? NULL : (_data1_->cb_target_destroy_notify (_data1_->cb_target), NULL);
		_data1_->cb = NULL;
		_data1_->cb_target = NULL;
		_data1_->cb_target_destroy_notify = NULL;
		_service_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean _service_spawn_helper_co_gsource_func (gpointer self) {
	gboolean result;
	result = service_spawn_helper_co (self);
	return result;
}


static void* ___lambda3_ (Block1Data* _data1_) {
	Service * self;
	void* result = NULL;
	GUnixInputStream* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	guint8* _tmp2_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->outstr;
	_tmp2_ = service_read_all (self, (GInputStream*) _tmp0_, &_tmp1_);
	_data1_->retb = (g_free (_data1_->retb), NULL);
	_data1_->retb = _tmp2_;
	_data1_->retb_length1 = _tmp1_;
	_data1_->_retb_size_ = _data1_->retb_length1;
	result = NULL;
	return result;
}


static gpointer ____lambda3__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda3_ (self);
	block1_data_unref (self);
	return result;
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_ = NULL;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static OpenDocument* _vala_array_dup4 (OpenDocument* self, int length) {
	OpenDocument* result;
	int i;
	result = g_new0 (OpenDocument, length);
	for (i = 0; i < length; i++) {
		OpenDocument _tmp0_ = {0};
		open_document_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void _vala_OpenDocument_array_free (OpenDocument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			open_document_destroy (&array[i]);
		}
	}
	g_free (array);
}


static GVariant* _variant_new1 (RpcParse value) {
	GVariantBuilder _tmp29_;
	gchar** _tmp30_;
	GVariantBuilder _tmp31_;
	int _tmp32_;
	OpenDocument* _tmp33_;
	GVariantBuilder _tmp34_;
	int _tmp35_;
	g_variant_builder_init (&_tmp29_, G_VARIANT_TYPE_TUPLE);
	_tmp30_ = value.args;
	g_variant_builder_init (&_tmp31_, G_VARIANT_TYPE ("as"));
	for (_tmp32_ = 0; _tmp32_ < value.args_length1; _tmp32_++) {
		g_variant_builder_add_value (&_tmp31_, g_variant_new_string (*_tmp30_));
		_tmp30_++;
	}
	g_variant_builder_add_value (&_tmp29_, g_variant_builder_end (&_tmp31_));
	_tmp33_ = value.documents;
	g_variant_builder_init (&_tmp34_, G_VARIANT_TYPE ("a(ss)"));
	for (_tmp35_ = 0; _tmp35_ < value.documents_length1; _tmp35_++) {
		GVariantBuilder _tmp36_;
		g_variant_builder_init (&_tmp36_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp36_, g_variant_new_string ((*_tmp33_).path));
		g_variant_builder_add_value (&_tmp36_, g_variant_new_string ((*_tmp33_).data_path));
		g_variant_builder_add_value (&_tmp34_, g_variant_builder_end (&_tmp36_));
		_tmp33_++;
	}
	g_variant_builder_add_value (&_tmp29_, g_variant_builder_end (&_tmp34_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp29_));
}


static void* ___lambda4_ (Block1Data* _data1_) {
	Service * self;
	void* result = NULL;
	OpenDocument* odocs = NULL;
	Document** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	OpenDocument* _tmp1_ = NULL;
	gint odocs_length1 = 0;
	gint _odocs_size_ = 0;
	RpcParse cmd = {0};
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar** _tmp24_ = NULL;
	gint _tmp24__length1 = 0;
	OpenDocument* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	OpenDocument* _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	RpcParse _tmp27_ = {0};
	GVariant* vv = NULL;
	RpcParse _tmp28_ = {0};
	GVariant* _tmp37_ = NULL;
	guint8* data = NULL;
	gsize _tmp38_ = 0UL;
	guint8* _tmp39_ = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	GError * _inner_error_ = NULL;
	self = _data1_->self;
	_tmp0_ = _data1_->documents;
	_tmp0__length1 = _data1_->documents_length1;
	_tmp1_ = g_new0 (OpenDocument, _tmp0__length1);
	odocs = _tmp1_;
	odocs_length1 = _tmp0__length1;
	_odocs_size_ = odocs_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gboolean _tmp3_ = FALSE;
				gint _tmp5_ = 0;
				Document** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				OpenDocument* _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				gint _tmp8_ = 0;
				Document** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				gint _tmp10_ = 0;
				Document* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				const gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				OpenDocument* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				Document** _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				Document* _tmp19_ = NULL;
				const gchar* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				_tmp3_ = _tmp2_;
				if (!_tmp3_) {
					gint _tmp4_ = 0;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = _data1_->documents;
				_tmp6__length1 = _data1_->documents_length1;
				if (!(_tmp5_ < _tmp6__length1)) {
					break;
				}
				_tmp7_ = odocs;
				_tmp7__length1 = odocs_length1;
				_tmp8_ = i;
				_tmp9_ = _data1_->documents;
				_tmp9__length1 = _data1_->documents_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = document_get_path (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (_tmp7_[_tmp8_].path);
				_tmp7_[_tmp8_].path = _tmp14_;
				_tmp15_ = odocs;
				_tmp15__length1 = odocs_length1;
				_tmp16_ = i;
				_tmp17_ = _data1_->documents;
				_tmp17__length1 = _data1_->documents_length1;
				_tmp18_ = i;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = document_get_data_path (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup (_tmp21_);
				_g_free0 (_tmp15_[_tmp16_].data_path);
				_tmp15_[_tmp16_].data_path = _tmp22_;
			}
		}
	}
	_tmp23_ = _data1_->flags;
	_tmp23__length1 = _data1_->flags_length1;
	_tmp24_ = (_tmp23_ != NULL) ? _vala_array_dup3 (_tmp23_, _tmp23__length1) : ((gpointer) _tmp23_);
	_tmp24__length1 = _tmp23__length1;
	_tmp25_ = odocs;
	_tmp25__length1 = odocs_length1;
	_tmp26_ = (_tmp25_ != NULL) ? _vala_array_dup4 (_tmp25_, _tmp25__length1) : ((gpointer) _tmp25_);
	_tmp26__length1 = _tmp25__length1;
	memset (&_tmp27_, 0, sizeof (RpcParse));
	_tmp27_.args = (_vala_array_free (_tmp27_.args, _tmp27_.args_length1, (GDestroyNotify) g_free), NULL);
	_tmp27_.args = _tmp24_;
	_tmp27_.args_length1 = _tmp24__length1;
	_tmp27_.documents = (_vala_OpenDocument_array_free (_tmp27_.documents, _tmp27_.documents_length1), NULL);
	_tmp27_.documents = _tmp26_;
	_tmp27_.documents_length1 = _tmp26__length1;
	cmd = _tmp27_;
	_tmp28_ = cmd;
	_tmp37_ = _variant_new1 (_tmp28_);
	vv = _tmp37_;
	_tmp38_ = g_variant_get_size (vv);
	_tmp39_ = g_new0 (guint8, (gint) _tmp38_);
	data = _tmp39_;
	data_length1 = (gint) _tmp38_;
	_data_size_ = data_length1;
	g_variant_store (vv, (void*) data);
	{
		gsize n = 0UL;
		GUnixOutputStream* _tmp40_ = NULL;
		gsize _tmp41_ = 0UL;
		_tmp40_ = _data1_->instr;
		g_output_stream_write_all ((GOutputStream*) _tmp40_, data, (gsize) data_length1, &_tmp41_, NULL, &_inner_error_);
		n = _tmp41_;
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally13:
	if (_inner_error_ != NULL) {
		data = (g_free (data), NULL);
		_g_variant_unref0 (vv);
		rpc_parse_destroy (&cmd);
		odocs = (_vala_OpenDocument_array_free (odocs, odocs_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	{
		GUnixOutputStream* _tmp42_ = NULL;
		_tmp42_ = _data1_->instr;
		g_output_stream_close ((GOutputStream*) _tmp42_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
	}
	goto __finally14;
	__catch14_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
	}
	__finally14:
	if (_inner_error_ != NULL) {
		data = (g_free (data), NULL);
		_g_variant_unref0 (vv);
		rpc_parse_destroy (&cmd);
		odocs = (_vala_OpenDocument_array_free (odocs, odocs_length1), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = NULL;
	data = (g_free (data), NULL);
	_g_variant_unref0 (vv);
	rpc_parse_destroy (&cmd);
	odocs = (_vala_OpenDocument_array_free (odocs, odocs_length1), NULL);
	return result;
}


static gpointer ____lambda4__gthread_func (gpointer self) {
	gpointer result;
	result = ___lambda4_ (self);
	block1_data_unref (self);
	return result;
}


static void __lambda5_ (Block1Data* _data1_, GPid p, gint st) {
	Service * self;
	GPid _tmp0_ = 0;
	GSourceFunc _tmp1_ = NULL;
	void* _tmp1__target = NULL;
	self = _data1_->self;
	_tmp0_ = p;
	g_spawn_close_pid (_tmp0_);
	_tmp1_ = _data1_->cb;
	_tmp1__target = _data1_->cb_target;
	_tmp1_ (_tmp1__target);
}


static void ___lambda5__gchild_watch_func (GPid pid, gint status, gpointer self) {
	__lambda5_ (self, pid, status);
}


static GVariant* _variant_new2 (RpcReply value) {
	GVariantBuilder _tmp35_;
	RpcDocument* _tmp36_;
	GVariantBuilder _tmp37_;
	int _tmp38_;
	g_variant_builder_init (&_tmp35_, G_VARIANT_TYPE_TUPLE);
	_tmp36_ = value.documents;
	g_variant_builder_init (&_tmp37_, G_VARIANT_TYPE ("a(sa(ua((x(xx)(xx))s)a(x(xx)(xx))s))"));
	for (_tmp38_ = 0; _tmp38_ < value.documents_length1; _tmp38_++) {
		GVariantBuilder _tmp39_;
		Diagnostic* _tmp40_;
		GVariantBuilder _tmp41_;
		int _tmp42_;
		g_variant_builder_init (&_tmp39_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp39_, g_variant_new_string ((*_tmp36_).path));
		_tmp40_ = (*_tmp36_).diagnostics;
		g_variant_builder_init (&_tmp41_, G_VARIANT_TYPE ("a(ua((x(xx)(xx))s)a(x(xx)(xx))s)"));
		for (_tmp42_ = 0; _tmp42_ < (*_tmp36_).diagnostics_length1; _tmp42_++) {
			GVariantBuilder _tmp43_;
			Fixit* _tmp44_;
			GVariantBuilder _tmp45_;
			int _tmp46_;
			SourceRange* _tmp51_;
			GVariantBuilder _tmp52_;
			int _tmp53_;
			g_variant_builder_init (&_tmp43_, G_VARIANT_TYPE_TUPLE);
			g_variant_builder_add_value (&_tmp43_, g_variant_new_uint32 ((*_tmp40_).severity));
			_tmp44_ = (*_tmp40_).fixits;
			g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("a((x(xx)(xx))s)"));
			for (_tmp46_ = 0; _tmp46_ < (*_tmp40_).fixits_length1; _tmp46_++) {
				GVariantBuilder _tmp47_;
				GVariantBuilder _tmp48_;
				GVariantBuilder _tmp49_;
				GVariantBuilder _tmp50_;
				g_variant_builder_init (&_tmp47_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_init (&_tmp48_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp48_, g_variant_new_int64 ((*_tmp44_).location.file));
				g_variant_builder_init (&_tmp49_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp49_, g_variant_new_int64 ((*_tmp44_).location.start.line));
				g_variant_builder_add_value (&_tmp49_, g_variant_new_int64 ((*_tmp44_).location.start.column));
				g_variant_builder_add_value (&_tmp48_, g_variant_builder_end (&_tmp49_));
				g_variant_builder_init (&_tmp50_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp50_, g_variant_new_int64 ((*_tmp44_).location.end.line));
				g_variant_builder_add_value (&_tmp50_, g_variant_new_int64 ((*_tmp44_).location.end.column));
				g_variant_builder_add_value (&_tmp48_, g_variant_builder_end (&_tmp50_));
				g_variant_builder_add_value (&_tmp47_, g_variant_builder_end (&_tmp48_));
				g_variant_builder_add_value (&_tmp47_, g_variant_new_string ((*_tmp44_).replacement));
				g_variant_builder_add_value (&_tmp45_, g_variant_builder_end (&_tmp47_));
				_tmp44_++;
			}
			g_variant_builder_add_value (&_tmp43_, g_variant_builder_end (&_tmp45_));
			_tmp51_ = (*_tmp40_).locations;
			g_variant_builder_init (&_tmp52_, G_VARIANT_TYPE ("a(x(xx)(xx))"));
			for (_tmp53_ = 0; _tmp53_ < (*_tmp40_).locations_length1; _tmp53_++) {
				GVariantBuilder _tmp54_;
				GVariantBuilder _tmp55_;
				GVariantBuilder _tmp56_;
				g_variant_builder_init (&_tmp54_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp54_, g_variant_new_int64 ((*_tmp51_).file));
				g_variant_builder_init (&_tmp55_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp55_, g_variant_new_int64 ((*_tmp51_).start.line));
				g_variant_builder_add_value (&_tmp55_, g_variant_new_int64 ((*_tmp51_).start.column));
				g_variant_builder_add_value (&_tmp54_, g_variant_builder_end (&_tmp55_));
				g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE_TUPLE);
				g_variant_builder_add_value (&_tmp56_, g_variant_new_int64 ((*_tmp51_).end.line));
				g_variant_builder_add_value (&_tmp56_, g_variant_new_int64 ((*_tmp51_).end.column));
				g_variant_builder_add_value (&_tmp54_, g_variant_builder_end (&_tmp56_));
				g_variant_builder_add_value (&_tmp52_, g_variant_builder_end (&_tmp54_));
				_tmp51_++;
			}
			g_variant_builder_add_value (&_tmp43_, g_variant_builder_end (&_tmp52_));
			g_variant_builder_add_value (&_tmp43_, g_variant_new_string ((*_tmp40_).message));
			g_variant_builder_add_value (&_tmp41_, g_variant_builder_end (&_tmp43_));
			_tmp40_++;
		}
		g_variant_builder_add_value (&_tmp39_, g_variant_builder_end (&_tmp41_));
		g_variant_builder_add_value (&_tmp37_, g_variant_builder_end (&_tmp39_));
		_tmp36_++;
	}
	g_variant_builder_add_value (&_tmp35_, g_variant_builder_end (&_tmp37_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp35_));
}


static void _variant_get3 (GVariant* value, RpcReply* result) {
	RpcReply _tmp64_;
	GVariantIter _tmp65_;
	GVariant* _tmp66_;
	RpcDocument* _tmp67_;
	int _tmp67__length;
	int _tmp67__size;
	int _tmp67__length1;
	GVariantIter _tmp68_;
	GVariant* _tmp69_;
	g_variant_iter_init (&_tmp65_, value);
	_tmp66_ = g_variant_iter_next_value (&_tmp65_);
	_tmp67_ = g_new (RpcDocument, 5);
	_tmp67__length = 0;
	_tmp67__size = 4;
	_tmp67__length1 = 0;
	g_variant_iter_init (&_tmp68_, _tmp66_);
	for (; (_tmp69_ = g_variant_iter_next_value (&_tmp68_)) != NULL; _tmp67__length1++) {
		RpcDocument _tmp70_;
		GVariantIter _tmp71_;
		GVariant* _tmp72_;
		GVariant* _tmp73_;
		Diagnostic* _tmp74_;
		int _tmp74__length;
		int _tmp74__size;
		int _tmp74__length1;
		GVariantIter _tmp75_;
		GVariant* _tmp76_;
		if (_tmp67__size == _tmp67__length) {
			_tmp67__size = 2 * _tmp67__size;
			_tmp67_ = g_renew (RpcDocument, _tmp67_, _tmp67__size + 1);
		}
		g_variant_iter_init (&_tmp71_, _tmp69_);
		_tmp72_ = g_variant_iter_next_value (&_tmp71_);
		_tmp70_.path = g_variant_dup_string (_tmp72_, NULL);
		g_variant_unref (_tmp72_);
		_tmp73_ = g_variant_iter_next_value (&_tmp71_);
		_tmp74_ = g_new (Diagnostic, 5);
		_tmp74__length = 0;
		_tmp74__size = 4;
		_tmp74__length1 = 0;
		g_variant_iter_init (&_tmp75_, _tmp73_);
		for (; (_tmp76_ = g_variant_iter_next_value (&_tmp75_)) != NULL; _tmp74__length1++) {
			Diagnostic _tmp77_;
			GVariantIter _tmp78_;
			GVariant* _tmp79_;
			GVariant* _tmp80_;
			Fixit* _tmp81_;
			int _tmp81__length;
			int _tmp81__size;
			int _tmp81__length1;
			GVariantIter _tmp82_;
			GVariant* _tmp83_;
			GVariant* _tmp101_;
			SourceRange* _tmp102_;
			int _tmp102__length;
			int _tmp102__size;
			int _tmp102__length1;
			GVariantIter _tmp103_;
			GVariant* _tmp104_;
			GVariant* _tmp118_;
			if (_tmp74__size == _tmp74__length) {
				_tmp74__size = 2 * _tmp74__size;
				_tmp74_ = g_renew (Diagnostic, _tmp74_, _tmp74__size + 1);
			}
			g_variant_iter_init (&_tmp78_, _tmp76_);
			_tmp79_ = g_variant_iter_next_value (&_tmp78_);
			_tmp77_.severity = g_variant_get_uint32 (_tmp79_);
			g_variant_unref (_tmp79_);
			_tmp80_ = g_variant_iter_next_value (&_tmp78_);
			_tmp81_ = g_new (Fixit, 5);
			_tmp81__length = 0;
			_tmp81__size = 4;
			_tmp81__length1 = 0;
			g_variant_iter_init (&_tmp82_, _tmp80_);
			for (; (_tmp83_ = g_variant_iter_next_value (&_tmp82_)) != NULL; _tmp81__length1++) {
				Fixit _tmp84_;
				GVariantIter _tmp85_;
				GVariant* _tmp86_;
				SourceRange _tmp87_;
				GVariantIter _tmp88_;
				GVariant* _tmp89_;
				GVariant* _tmp90_;
				SourceLocation _tmp91_;
				GVariantIter _tmp92_;
				GVariant* _tmp93_;
				GVariant* _tmp94_;
				GVariant* _tmp95_;
				SourceLocation _tmp96_;
				GVariantIter _tmp97_;
				GVariant* _tmp98_;
				GVariant* _tmp99_;
				GVariant* _tmp100_;
				if (_tmp81__size == _tmp81__length) {
					_tmp81__size = 2 * _tmp81__size;
					_tmp81_ = g_renew (Fixit, _tmp81_, _tmp81__size + 1);
				}
				g_variant_iter_init (&_tmp85_, _tmp83_);
				_tmp86_ = g_variant_iter_next_value (&_tmp85_);
				g_variant_iter_init (&_tmp88_, _tmp86_);
				_tmp89_ = g_variant_iter_next_value (&_tmp88_);
				_tmp87_.file = g_variant_get_int64 (_tmp89_);
				g_variant_unref (_tmp89_);
				_tmp90_ = g_variant_iter_next_value (&_tmp88_);
				g_variant_iter_init (&_tmp92_, _tmp90_);
				_tmp93_ = g_variant_iter_next_value (&_tmp92_);
				_tmp91_.line = g_variant_get_int64 (_tmp93_);
				g_variant_unref (_tmp93_);
				_tmp94_ = g_variant_iter_next_value (&_tmp92_);
				_tmp91_.column = g_variant_get_int64 (_tmp94_);
				g_variant_unref (_tmp94_);
				_tmp87_.start = _tmp91_;
				g_variant_unref (_tmp90_);
				_tmp95_ = g_variant_iter_next_value (&_tmp88_);
				g_variant_iter_init (&_tmp97_, _tmp95_);
				_tmp98_ = g_variant_iter_next_value (&_tmp97_);
				_tmp96_.line = g_variant_get_int64 (_tmp98_);
				g_variant_unref (_tmp98_);
				_tmp99_ = g_variant_iter_next_value (&_tmp97_);
				_tmp96_.column = g_variant_get_int64 (_tmp99_);
				g_variant_unref (_tmp99_);
				_tmp87_.end = _tmp96_;
				g_variant_unref (_tmp95_);
				_tmp84_.location = _tmp87_;
				g_variant_unref (_tmp86_);
				_tmp100_ = g_variant_iter_next_value (&_tmp85_);
				_tmp84_.replacement = g_variant_dup_string (_tmp100_, NULL);
				g_variant_unref (_tmp100_);
				_tmp81_[_tmp81__length++] = _tmp84_;
				g_variant_unref (_tmp83_);
			}
			_tmp77_.fixits_length1 = _tmp81__length1;
			_tmp77_.fixits = _tmp81_;
			g_variant_unref (_tmp80_);
			_tmp101_ = g_variant_iter_next_value (&_tmp78_);
			_tmp102_ = g_new (SourceRange, 5);
			_tmp102__length = 0;
			_tmp102__size = 4;
			_tmp102__length1 = 0;
			g_variant_iter_init (&_tmp103_, _tmp101_);
			for (; (_tmp104_ = g_variant_iter_next_value (&_tmp103_)) != NULL; _tmp102__length1++) {
				SourceRange _tmp105_;
				GVariantIter _tmp106_;
				GVariant* _tmp107_;
				GVariant* _tmp108_;
				SourceLocation _tmp109_;
				GVariantIter _tmp110_;
				GVariant* _tmp111_;
				GVariant* _tmp112_;
				GVariant* _tmp113_;
				SourceLocation _tmp114_;
				GVariantIter _tmp115_;
				GVariant* _tmp116_;
				GVariant* _tmp117_;
				if (_tmp102__size == _tmp102__length) {
					_tmp102__size = 2 * _tmp102__size;
					_tmp102_ = g_renew (SourceRange, _tmp102_, _tmp102__size + 1);
				}
				g_variant_iter_init (&_tmp106_, _tmp104_);
				_tmp107_ = g_variant_iter_next_value (&_tmp106_);
				_tmp105_.file = g_variant_get_int64 (_tmp107_);
				g_variant_unref (_tmp107_);
				_tmp108_ = g_variant_iter_next_value (&_tmp106_);
				g_variant_iter_init (&_tmp110_, _tmp108_);
				_tmp111_ = g_variant_iter_next_value (&_tmp110_);
				_tmp109_.line = g_variant_get_int64 (_tmp111_);
				g_variant_unref (_tmp111_);
				_tmp112_ = g_variant_iter_next_value (&_tmp110_);
				_tmp109_.column = g_variant_get_int64 (_tmp112_);
				g_variant_unref (_tmp112_);
				_tmp105_.start = _tmp109_;
				g_variant_unref (_tmp108_);
				_tmp113_ = g_variant_iter_next_value (&_tmp106_);
				g_variant_iter_init (&_tmp115_, _tmp113_);
				_tmp116_ = g_variant_iter_next_value (&_tmp115_);
				_tmp114_.line = g_variant_get_int64 (_tmp116_);
				g_variant_unref (_tmp116_);
				_tmp117_ = g_variant_iter_next_value (&_tmp115_);
				_tmp114_.column = g_variant_get_int64 (_tmp117_);
				g_variant_unref (_tmp117_);
				_tmp105_.end = _tmp114_;
				g_variant_unref (_tmp113_);
				_tmp102_[_tmp102__length++] = _tmp105_;
				g_variant_unref (_tmp104_);
			}
			_tmp77_.locations_length1 = _tmp102__length1;
			_tmp77_.locations = _tmp102_;
			g_variant_unref (_tmp101_);
			_tmp118_ = g_variant_iter_next_value (&_tmp78_);
			_tmp77_.message = g_variant_dup_string (_tmp118_, NULL);
			g_variant_unref (_tmp118_);
			_tmp74_[_tmp74__length++] = _tmp77_;
			g_variant_unref (_tmp76_);
		}
		_tmp70_.diagnostics_length1 = _tmp74__length1;
		_tmp70_.diagnostics = _tmp74_;
		g_variant_unref (_tmp73_);
		_tmp67_[_tmp67__length++] = _tmp70_;
		g_variant_unref (_tmp69_);
	}
	_tmp64_.documents_length1 = _tmp67__length1;
	_tmp64_.documents = _tmp67_;
	g_variant_unref (_tmp66_);
	*result = _tmp64_;
}


static gboolean service_spawn_helper_co (ServiceSpawnHelperData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = service_ref (_data_->self);
	_data_->_tmp0_ = NULL;
	_data_->_tmp0__length1 = 0;
	_data_->_tmp0_ = _data_->documents;
	_data_->_tmp0__length1 = _data_->documents_length1;
	_data_->_data1_->documents = _data_->_tmp0_;
	_data_->_data1_->documents_length1 = _data_->_tmp0__length1;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1__length1 = 0;
	_data_->_tmp1_ = _data_->flags;
	_data_->_tmp1__length1 = _data_->flags_length1;
	_data_->_data1_->flags = _data_->_tmp1_;
	_data_->_data1_->flags_length1 = _data_->_tmp1__length1;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_data1_->cb = _service_spawn_helper_co_gsource_func;
	_data_->_data1_->cb_target = _data_;
	_data_->_data1_->cb_target_destroy_notify = NULL;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_build_filename (BACKENDEXECDIR, "valahelper", NULL);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_new0 (gchar*, 1 + 1);
	_data_->_tmp3_[0] = _data_->_tmp2_;
	_data_->argv_length1 = 0;
	_data_->_argv_size_ = 0;
	_data_->argv = _data_->_tmp3_;
	_data_->argv_length1 = 1;
	_data_->_argv_size_ = _data_->argv_length1;
	{
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->wd;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5__length1 = 0;
		_data_->_tmp5_ = _data_->argv;
		_data_->_tmp5__length1 = _data_->argv_length1;
		_data_->_tmp6_ = 0;
		_data_->_tmp7_ = 0;
		_data_->_tmp8_ = 0;
		g_spawn_async_with_pipes (_data_->_tmp4_, _data_->_tmp5_, NULL, G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, &_data_->_tmp6_, &_data_->_tmp7_, &_data_->_tmp8_, NULL, &_data_->_inner_error_);
		_data_->pid = _data_->_tmp6_;
		_data_->inp = _data_->_tmp7_;
		_data_->outp = _data_->_tmp8_;
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch9_g_spawn_error;
			}
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	goto __finally9;
	__catch9_g_spawn_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->e;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->_tmp9_->message;
		g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "service.vala:87: Failed to spawn helper: %s", _data_->_tmp10_);
		memset (&_data_->_tmp11_, 0, sizeof (RpcReply));
		memset (&_data_->_tmp11_, 0, sizeof (RpcReply));
		_data_->result = _data_->_tmp11_;
		_g_error_free0 (_data_->e);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally9:
	if (_data_->_inner_error_ != NULL) {
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = 0;
	_data_->_tmp12_ = _data_->outp;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = (GUnixInputStream*) g_unix_input_stream_new (_data_->_tmp12_, TRUE);
	_data_->_data1_->outstr = _data_->_tmp13_;
	_data_->_tmp14_ = 0;
	_data_->_tmp14_ = _data_->inp;
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = (GUnixOutputStream*) g_unix_output_stream_new (_data_->_tmp14_, TRUE);
	_data_->_data1_->instr = _data_->_tmp15_;
	_data_->_tmp16_ = NULL;
	_data_->_tmp16_ = g_new0 (guint8, 0);
	_data_->_data1_->retb = _data_->_tmp16_;
	_data_->_data1_->retb_length1 = 0;
	_data_->_data1_->_retb_size_ = _data_->_data1_->retb_length1;
	_data_->reader = NULL;
	_data_->writer = NULL;
	{
		_data_->_tmp18_ = NULL;
		_data_->_tmp18_ = g_thread_try_new ("reader", ____lambda3__gthread_func, block1_data_ref (_data_->_data1_), &_data_->_inner_error_);
		_data_->_tmp17_ = _data_->_tmp18_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
		_g_thread_unref0 (_data_->reader);
		_data_->reader = _data_->_tmp17_;
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp19_ = NULL;
		_data_->_tmp19_ = _data_->_vala1_e;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->_tmp19_->message;
		g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "service.vala:108: Failed to create reader thread: %s", _data_->_tmp20_);
		{
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->_data1_->outstr;
			g_input_stream_close ((GInputStream*) _data_->_tmp21_, NULL, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch11_g_error;
			}
		}
		goto __finally11;
		__catch11_g_error:
		{
			g_clear_error (&_data_->_inner_error_);
			_data_->_inner_error_ = NULL;
		}
		__finally11:
		if (_data_->_inner_error_ != NULL) {
			_g_error_free0 (_data_->_vala1_e);
			_g_error_free0 (_data_->_vala1_e);
			_g_thread_unref0 (_data_->writer);
			_g_thread_unref0 (_data_->reader);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		_g_thread_unref0 (_data_->writer);
		_g_thread_unref0 (_data_->reader);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp23_ = NULL;
		_data_->_tmp23_ = g_thread_try_new ("writer", ____lambda4__gthread_func, block1_data_ref (_data_->_data1_), &_data_->_inner_error_);
		_data_->_tmp22_ = _data_->_tmp23_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
		_g_thread_unref0 (_data_->writer);
		_data_->writer = _data_->_tmp22_;
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _data_->_vala2_e;
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->_tmp24_->message;
		g_log ("GcaVala", G_LOG_LEVEL_DEBUG, "service.vala:153: Failed to create writer thread: %s", _data_->_tmp25_);
		{
			_data_->_tmp26_ = NULL;
			_data_->_tmp26_ = _data_->_data1_->instr;
			g_output_stream_close ((GOutputStream*) _data_->_tmp26_, NULL, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch15_g_error;
			}
		}
		goto __finally15;
		__catch15_g_error:
		{
			g_clear_error (&_data_->_inner_error_);
			_data_->_inner_error_ = NULL;
		}
		__finally15:
		if (_data_->_inner_error_ != NULL) {
			_g_error_free0 (_data_->_vala2_e);
			_g_error_free0 (_data_->_vala2_e);
			_g_thread_unref0 (_data_->writer);
			_g_thread_unref0 (_data_->reader);
			_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
			block1_data_unref (_data_->_data1_);
			_data_->_data1_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_g_error_free0 (_data_->_vala2_e);
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		_g_thread_unref0 (_data_->writer);
		_g_thread_unref0 (_data_->reader);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp27_ = 0;
	_data_->_tmp27_ = _data_->pid;
	g_child_watch_add_full (G_PRIORITY_DEFAULT_IDLE, _data_->_tmp27_, ___lambda5__gchild_watch_func, block1_data_ref (_data_->_data1_), block1_data_unref);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->writer;
	if (_data_->_tmp28_ != NULL) {
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->writer;
		g_thread_join (_data_->_tmp29_);
	}
	_data_->_tmp30_ = NULL;
	_data_->_tmp30_ = _data_->reader;
	if (_data_->_tmp30_ != NULL) {
		_data_->_tmp31_ = NULL;
		_data_->_tmp31_ = _data_->reader;
		g_thread_join (_data_->_tmp31_);
	}
	{
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->_data1_->outstr;
		g_input_stream_close ((GInputStream*) _data_->_tmp32_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_data_->_tmp33_ = NULL;
		_data_->_tmp33_ = _data_->_data1_->instr;
		g_output_stream_close ((GOutputStream*) _data_->_tmp33_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		g_clear_error (&_data_->_inner_error_);
		_data_->_inner_error_ = NULL;
	}
	__finally16:
	if (_data_->_inner_error_ != NULL) {
		_g_thread_unref0 (_data_->writer);
		_g_thread_unref0 (_data_->reader);
		_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
		block1_data_unref (_data_->_data1_);
		_data_->_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	memset (&_data_->r, 0, sizeof (RpcReply));
	memset (&_data_->_tmp34_, 0, sizeof (RpcReply));
	_data_->_tmp34_ = _data_->r;
	_data_->_tmp57_ = NULL;
	_data_->_tmp57_ = _variant_new2 (_data_->_tmp34_);
	_data_->dummy = _data_->_tmp57_;
	_data_->_tmp58_ = NULL;
	_data_->_tmp58_ = _data_->dummy;
	_data_->_tmp59_ = NULL;
	_data_->_tmp59_ = g_variant_get_type (_data_->_tmp58_);
	_data_->_tmp60_ = NULL;
	_data_->_tmp60__length1 = 0;
	_data_->_tmp60_ = _data_->_data1_->retb;
	_data_->_tmp60__length1 = _data_->_data1_->retb_length1;
	_data_->_tmp61_ = NULL;
	_data_->_tmp61_ = g_variant_new_from_data (_data_->_tmp59_, (guchar*) _data_->_tmp60_, (_data_->_tmp60__length1 * sizeof (guint8)) / sizeof (guchar), TRUE, NULL, NULL);
	g_variant_ref_sink (_data_->_tmp61_);
	_data_->reply = _data_->_tmp61_;
	_data_->_tmp62_ = NULL;
	_data_->_tmp62_ = _data_->reply;
	memset (&_data_->_tmp63_, 0, sizeof (RpcReply));
	_variant_get3 (_data_->_tmp62_, &_data_->_tmp63_);
	_data_->result = _data_->_tmp63_;
	_g_variant_unref0 (_data_->reply);
	_g_variant_unref0 (_data_->dummy);
	rpc_reply_destroy (&_data_->r);
	_g_thread_unref0 (_data_->writer);
	_g_thread_unref0 (_data_->reader);
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_variant_unref0 (_data_->reply);
	_g_variant_unref0 (_data_->dummy);
	rpc_reply_destroy (&_data_->r);
	_g_thread_unref0 (_data_->writer);
	_g_thread_unref0 (_data_->reader);
	_data_->argv = (_vala_array_free (_data_->argv, _data_->argv_length1, (GDestroyNotify) g_free), NULL);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void service_parse_impl_data_free (gpointer _data) {
	ServiceParseImplData* _data_;
	_data_ = _data;
	_document_unref0 (_data_->doc);
	_g_hash_table_unref0 (_data_->options);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) document_unref), NULL);
	_service_unref0 (_data_->self);
	g_slice_free (ServiceParseImplData, _data_);
}


static gpointer _document_ref0 (gpointer self) {
	return self ? document_ref (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void service_parse_impl (Service* self, Document* doc, Document** documents, int documents_length1, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ServiceParseImplData* _data_;
	Service* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	Document** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	_data_ = g_slice_new0 (ServiceParseImplData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, service_parse_impl);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, service_parse_impl_data_free);
	_tmp0_ = _service_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = doc;
	_tmp2_ = _document_ref0 (_tmp1_);
	_document_unref0 (_data_->doc);
	_data_->doc = _tmp2_;
	_tmp3_ = documents;
	_tmp3__length1 = documents_length1;
	_data_->documents = _tmp3_;
	_data_->documents_length1 = _tmp3__length1;
	_tmp4_ = options;
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp5_;
	service_parse_impl_co (_data_);
}


static Document** service_parse_impl_finish (Service* self, GAsyncResult* _res_, int* result_length1) {
	Document** result;
	ServiceParseImplData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void service_parse_impl_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ServiceParseImplData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	service_parse_impl_co (_data_);
}


static void _vala_array_add2 (Document*** array, int* length, int* size, Document* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (Document*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gboolean service_parse_impl_co (ServiceParseImplData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->doc;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = document_get_path (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
	_data_->f = _data_->_tmp3_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->self->priv->d_makefile;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->f;
	_data_->_tmp6_ = NULL;
	_data_->_tmp7_ = 0;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = makefile_integration_flags_for_file (_data_->_tmp4_, _data_->_tmp5_, &_data_->_tmp6_, &_data_->_tmp7_);
	_g_free0 (_data_->wd);
	_data_->wd = _data_->_tmp6_;
	_data_->flags_length1 = 0;
	_data_->_flags_size_ = 0;
	_data_->flags = _data_->_tmp8_;
	_data_->flags_length1 = _data_->_tmp7_;
	_data_->_flags_size_ = _data_->flags_length1;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9__length1 = 0;
	_data_->_tmp9_ = _data_->documents;
	_data_->_tmp9__length1 = _data_->documents_length1;
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = _data_->wd;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11__length1 = 0;
	_data_->_tmp11_ = _data_->flags;
	_data_->_tmp11__length1 = _data_->flags_length1;
	memset (&_data_->_tmp12_, 0, sizeof (RpcReply));
	_data_->_state_ = 1;
	service_spawn_helper (_data_->self, _data_->_tmp9_, _data_->_tmp9__length1, _data_->_tmp10_, _data_->_tmp11_, _data_->_tmp11__length1, service_parse_impl_ready, _data_);
	return FALSE;
	_state_1:
	service_spawn_helper_finish (_data_->self, _data_->_res_, &_data_->_tmp12_);
	_data_->reply = _data_->_tmp12_;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_DOCUMENT, (GBoxedCopyFunc) document_ref, document_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->odocs = _data_->_tmp13_;
	_data_->_tmp14_ = NULL;
	_data_->_tmp14__length1 = 0;
	_data_->_tmp14_ = _data_->documents;
	_data_->_tmp14__length1 = _data_->documents_length1;
	{
		_data_->d_collection_length1 = 0;
		_data_->_d_collection_size_ = 0;
		_data_->d_collection = _data_->_tmp14_;
		_data_->d_collection_length1 = _data_->_tmp14__length1;
		for (_data_->d_it = 0; _data_->d_it < _data_->_tmp14__length1; _data_->d_it = _data_->d_it + 1) {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _document_ref0 (_data_->d_collection[_data_->d_it]);
			_data_->d = _data_->_tmp15_;
			{
				_data_->_tmp16_ = NULL;
				_data_->_tmp16_ = _data_->odocs;
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->d;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = document_get_path (_data_->_tmp17_);
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = _data_->_tmp18_;
				_data_->_tmp20_ = NULL;
				_data_->_tmp20_ = _data_->doc;
				gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp16_, _data_->_tmp19_, _data_->_tmp20_);
				_document_unref0 (_data_->d);
			}
		}
	}
	memset (&_data_->_tmp21_, 0, sizeof (RpcReply));
	_data_->_tmp21_ = _data_->reply;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22__length1 = 0;
	_data_->_tmp22_ = _data_->_tmp21_.documents;
	_data_->_tmp22__length1 = _data_->_tmp21_.documents_length1;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = g_new0 (Document*, _data_->_tmp22__length1 + 1);
	_data_->retdocs_length1 = 0;
	_data_->_retdocs_size_ = 0;
	_data_->retdocs = _data_->_tmp23_;
	_data_->retdocs_length1 = _data_->_tmp22__length1;
	_data_->_retdocs_size_ = _data_->retdocs_length1;
	_data_->retdocs_length1 = 0;
	_data_->_tmp24_ = 0;
	_data_->_tmp24_ = _data_->retdocs_length1;
	memset (&_data_->_tmp25_, 0, sizeof (RpcReply));
	_data_->_tmp25_ = _data_->reply;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26__length1 = 0;
	_data_->_tmp26_ = _data_->_tmp25_.documents;
	_data_->_tmp26__length1 = _data_->_tmp25_.documents_length1;
	{
		_data_->_vala1_d_collection_length1 = 0;
		_data_->__vala1_d_collection_size_ = 0;
		_data_->_vala1_d_collection = _data_->_tmp26_;
		_data_->_vala1_d_collection_length1 = _data_->_tmp26__length1;
		for (_data_->_vala1_d_it = 0; _data_->_vala1_d_it < _data_->_tmp26__length1; _data_->_vala1_d_it = _data_->_vala1_d_it + 1) {
			memset (&_data_->_tmp27_, 0, sizeof (RpcDocument));
			rpc_document_copy (&_data_->_vala1_d_collection[_data_->_vala1_d_it], &_data_->_tmp27_);
			_data_->_vala1_d = _data_->_tmp27_;
			{
				_data_->_tmp28_ = NULL;
				_data_->_tmp28_ = _data_->odocs;
				memset (&_data_->_tmp29_, 0, sizeof (RpcDocument));
				_data_->_tmp29_ = _data_->_vala1_d;
				_data_->_tmp30_ = NULL;
				_data_->_tmp30_ = _data_->_tmp29_.path;
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp28_, _data_->_tmp30_);
				_data_->odoc = (Document*) _data_->_tmp31_;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->odoc;
				if (_data_->_tmp32_ != NULL) {
					_data_->_tmp33_ = NULL;
					_data_->_tmp33_ = _data_->odoc;
					memset (&_data_->_tmp34_, 0, sizeof (RpcDocument));
					_data_->_tmp34_ = _data_->_vala1_d;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35__length1 = 0;
					_data_->_tmp35_ = _data_->_tmp34_.diagnostics;
					_data_->_tmp35__length1 = _data_->_tmp34_.diagnostics_length1;
					document_set_diagnostics (_data_->_tmp33_, _data_->_tmp35_, _data_->_tmp35__length1);
					_data_->_tmp36_ = NULL;
					_data_->_tmp36__length1 = 0;
					_data_->_tmp36_ = _data_->retdocs;
					_data_->_tmp36__length1 = _data_->retdocs_length1;
					_data_->_tmp37_ = NULL;
					_data_->_tmp37_ = _data_->odoc;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = _document_ref0 (_data_->_tmp37_);
					_vala_array_add2 (&_data_->retdocs, &_data_->retdocs_length1, &_data_->_retdocs_size_, _data_->_tmp38_);
				}
				_document_unref0 (_data_->odoc);
				rpc_document_destroy (&_data_->_vala1_d);
			}
		}
	}
	_data_->_tmp39_ = NULL;
	_data_->_tmp39__length1 = 0;
	_data_->_tmp39_ = _data_->retdocs;
	_data_->_tmp39__length1 = _data_->retdocs_length1;
	_data_->result_length1 = _data_->_tmp39__length1;
	_data_->result = _data_->_tmp39_;
	_g_object_unref0 (_data_->odocs);
	rpc_reply_destroy (&_data_->reply);
	_data_->flags = (_vala_array_free (_data_->flags, _data_->flags_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->wd);
	_g_object_unref0 (_data_->f);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->retdocs = (_vala_array_free (_data_->retdocs, _data_->retdocs_length1, (GDestroyNotify) document_unref), NULL);
	_g_object_unref0 (_data_->odocs);
	rpc_reply_destroy (&_data_->reply);
	_data_->flags = (_vala_array_free (_data_->flags, _data_->flags_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->wd);
	_g_object_unref0 (_data_->f);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void service_parse_data_free (gpointer _data) {
	ServiceParseData* _data_;
	_data_ = _data;
	_document_unref0 (_data_->doc);
	_g_hash_table_unref0 (_data_->options);
	_service_unref0 (_data_->self);
	g_slice_free (ServiceParseData, _data_);
}


void service_parse (Service* self, Document* doc, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ServiceParseData* _data_;
	Service* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	GHashTable* _tmp3_ = NULL;
	GHashTable* _tmp4_ = NULL;
	_data_ = g_slice_new0 (ServiceParseData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, service_parse);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, service_parse_data_free);
	_tmp0_ = _service_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = doc;
	_tmp2_ = _document_ref0 (_tmp1_);
	_document_unref0 (_data_->doc);
	_data_->doc = _tmp2_;
	_tmp3_ = options;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp4_;
	service_parse_co (_data_);
}


void service_parse_finish (Service* self, GAsyncResult* _res_) {
	ServiceParseData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void service_parse_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ServiceParseData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	service_parse_co (_data_);
}


static gboolean service_parse_co (ServiceParseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->doc;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->doc;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _document_ref0 (_data_->_tmp1_);
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_new0 (Document*, 1 + 1);
	_data_->_tmp3_[0] = _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4__length1 = 0;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp4__length1 = 1;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->options;
	_data_->_tmp6_ = 0;
	_data_->_state_ = 1;
	service_parse_impl (_data_->self, _data_->_tmp0_, _data_->_tmp4_, 1, _data_->_tmp5_, service_parse_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = service_parse_impl_finish (_data_->self, _data_->_res_, &_data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8__length1 = 0;
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp8__length1 = _data_->_tmp6_;
	_data_->_tmp8_ = (_vala_array_free (_data_->_tmp8_, _data_->_tmp8__length1, (GDestroyNotify) document_unref), NULL);
	_data_->_tmp4_ = (_vala_array_free (_data_->_tmp4_, _data_->_tmp4__length1, (GDestroyNotify) document_unref), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void service_parse_all_data_free (gpointer _data) {
	ServiceParseAllData* _data_;
	_data_ = _data;
	_document_unref0 (_data_->doc);
	_g_hash_table_unref0 (_data_->options);
	_data_->result = (_vala_array_free (_data_->result, _data_->result_length1, (GDestroyNotify) document_unref), NULL);
	_service_unref0 (_data_->self);
	g_slice_free (ServiceParseAllData, _data_);
}


void service_parse_all (Service* self, Document* doc, Document** documents, int documents_length1, GHashTable* options, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	ServiceParseAllData* _data_;
	Service* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	Document* _tmp2_ = NULL;
	Document** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	GHashTable* _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	_data_ = g_slice_new0 (ServiceParseAllData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, service_parse_all);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, service_parse_all_data_free);
	_tmp0_ = _service_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = doc;
	_tmp2_ = _document_ref0 (_tmp1_);
	_document_unref0 (_data_->doc);
	_data_->doc = _tmp2_;
	_tmp3_ = documents;
	_tmp3__length1 = documents_length1;
	_data_->documents = _tmp3_;
	_data_->documents_length1 = _tmp3__length1;
	_tmp4_ = options;
	_tmp5_ = _g_hash_table_ref0 (_tmp4_);
	_g_hash_table_unref0 (_data_->options);
	_data_->options = _tmp5_;
	service_parse_all_co (_data_);
}


Document** service_parse_all_finish (Service* self, GAsyncResult* _res_, int* result_length1) {
	Document** result;
	ServiceParseAllData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void service_parse_all_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	ServiceParseAllData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	service_parse_all_co (_data_);
}


static gboolean service_parse_all_co (ServiceParseAllData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->doc;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1__length1 = 0;
	_data_->_tmp1_ = _data_->documents;
	_data_->_tmp1__length1 = _data_->documents_length1;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->options;
	_data_->_tmp3_ = 0;
	_data_->_state_ = 1;
	service_parse_impl (_data_->self, _data_->_tmp0_, _data_->_tmp1_, _data_->_tmp1__length1, _data_->_tmp2_, service_parse_all_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = service_parse_impl_finish (_data_->self, _data_->_res_, &_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5__length1 = 0;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp5__length1 = _data_->_tmp3_;
	_data_->result_length1 = _data_->_tmp5__length1;
	_data_->result = _data_->_tmp5_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void service_dispose (Service* self, Document* document) {
	GFile* f = NULL;
	Document* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	MakefileIntegration* _tmp4_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (document != NULL);
	_tmp0_ = document;
	_tmp1_ = document_get_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	f = _tmp3_;
	_tmp4_ = self->priv->d_makefile;
	makefile_integration_dispose (_tmp4_, f);
	_g_object_unref0 (f);
}


static void value_service_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_service_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		service_unref (value->data[0].v_pointer);
	}
}


static void value_service_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = service_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_service_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_service_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Service* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = service_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_service_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Service** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = service_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_service (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecService* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_SERVICE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_service (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SERVICE), NULL);
	return value->data[0].v_pointer;
}


void value_set_service (GValue* value, gpointer v_object) {
	Service* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SERVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SERVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		service_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		service_unref (old);
	}
}


void value_take_service (GValue* value, gpointer v_object) {
	Service* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_SERVICE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_SERVICE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		service_unref (old);
	}
}


static void service_class_init (ServiceClass * klass) {
	service_parent_class = g_type_class_peek_parent (klass);
	SERVICE_CLASS (klass)->finalize = service_finalize;
	g_type_class_add_private (klass, sizeof (ServicePrivate));
}


static void service_instance_init (Service * self) {
	self->priv = SERVICE_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void service_finalize (Service* obj) {
	Service * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERVICE, Service);
	_makefile_integration_unref0 (self->priv->d_makefile);
}


GType service_get_type (void) {
	static volatile gsize service_type_id__volatile = 0;
	if (g_once_init_enter (&service_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_service_init, value_service_free_value, value_service_copy_value, value_service_peek_pointer, "p", value_service_collect_value, "p", value_service_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ServiceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) service_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Service), 0, (GInstanceInitFunc) service_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType service_type_id;
		service_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Service", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&service_type_id__volatile, service_type_id);
	}
	return service_type_id__volatile;
}


gpointer service_ref (gpointer instance) {
	Service* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void service_unref (gpointer instance) {
	Service* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SERVICE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



