/* TweetListEntry.c generated by valac 0.30.0, the Vala compiler
 * generated from TweetListEntry.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>


#define TYPE_ITWITTER_ITEM (itwitter_item_get_type ())
#define ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ITWITTER_ITEM, ITwitterItem))
#define IS_ITWITTER_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ITWITTER_ITEM))
#define ITWITTER_ITEM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ITWITTER_ITEM, ITwitterItemIface))

typedef struct _ITwitterItem ITwitterItem;
typedef struct _ITwitterItemIface ITwitterItemIface;

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
typedef struct _TweetListEntryPrivate TweetListEntryPrivate;

#define TYPE_TWEET (tweet_get_type ())
#define TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET, Tweet))
#define TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET, TweetClass))
#define IS_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET))
#define IS_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET))
#define TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET, TweetClass))

typedef struct _Tweet Tweet;
typedef struct _TweetClass TweetClass;

#define TYPE_TEXT_BUTTON (text_button_get_type ())
#define TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEXT_BUTTON, TextButton))
#define TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEXT_BUTTON, TextButtonClass))
#define IS_TEXT_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEXT_BUTTON))
#define IS_TEXT_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEXT_BUTTON))
#define TEXT_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEXT_BUTTON, TextButtonClass))

typedef struct _TextButton TextButton;
typedef struct _TextButtonClass TextButtonClass;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_DOUBLE_TAP_BUTTON (double_tap_button_get_type ())
#define DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButton))
#define DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))
#define IS_DOUBLE_TAP_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOUBLE_TAP_BUTTON))
#define IS_DOUBLE_TAP_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOUBLE_TAP_BUTTON))
#define DOUBLE_TAP_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOUBLE_TAP_BUTTON, DoubleTapButtonClass))

typedef struct _DoubleTapButton DoubleTapButton;
typedef struct _DoubleTapButtonClass DoubleTapButtonClass;

#define TYPE_MULTI_MEDIA_WIDGET (multi_media_widget_get_type ())
#define MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidget))
#define MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))
#define IS_MULTI_MEDIA_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MULTI_MEDIA_WIDGET))
#define IS_MULTI_MEDIA_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MULTI_MEDIA_WIDGET))
#define MULTI_MEDIA_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MULTI_MEDIA_WIDGET, MultiMediaWidgetClass))

typedef struct _MultiMediaWidget MultiMediaWidget;
typedef struct _MultiMediaWidgetClass MultiMediaWidgetClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _TweetPrivate TweetPrivate;

#define TYPE_MINI_TWEET (mini_tweet_get_type ())
#define MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINI_TWEET, MiniTweet))
#define MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINI_TWEET, MiniTweetClass))
#define IS_MINI_TWEET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINI_TWEET))
#define IS_MINI_TWEET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINI_TWEET))
#define MINI_TWEET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINI_TWEET, MiniTweetClass))

typedef struct _MiniTweet MiniTweet;
typedef struct _MiniTweetClass MiniTweetClass;
typedef struct _MiniTweetPrivate MiniTweetPrivate;

#define TYPE_USER_IDENTITY (user_identity_get_type ())
typedef struct _UserIdentity UserIdentity;

#define TYPE_TEXT_ENTITY (text_entity_get_type ())
typedef struct _TextEntity TextEntity;

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;

#define TYPE_TRANSFORM_FLAGS (transform_flags_get_type ())
typedef struct _MultiMediaWidgetPrivate MultiMediaWidgetPrivate;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
typedef struct _Block65Data Block65Data;

#define TYPE_FILTER (filter_get_type ())
#define FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILTER, Filter))
#define FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILTER, FilterClass))
#define IS_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILTER))
#define IS_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILTER))
#define FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILTER, FilterClass))

typedef struct _Filter Filter;
typedef struct _FilterClass FilterClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block66Data Block66Data;
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ITwitterItemIface {
	GTypeInterface parent_iface;
	gint (*update_time_delta) (ITwitterItem* self, GDateTime* now);
	gint64 (*get_sort_factor) (ITwitterItem* self);
};

struct _TweetListEntry {
	GtkListBoxRow parent_instance;
	TweetListEntryPrivate * priv;
	Tweet* tweet;
};

struct _TweetListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _TweetListEntryPrivate {
	GtkLabel* screen_name_label;
	TextButton* name_button;
	GtkLabel* time_delta_label;
	AvatarWidget* avatar_image;
	GtkLabel* text_label;
	GtkLabel* rt_label;
	GtkImage* rt_image;
	GtkImage* conversation_image;
	GtkImage* rt_status_image;
	GtkImage* fav_status_image;
	DoubleTapButton* retweet_button;
	GtkToggleButton* favorite_button;
	GtkGrid* grid;
	MultiMediaWidget* mm_widget;
	GtkStack* stack;
	GtkBox* action_box;
	GtkLabel* quote_label;
	TextButton* quote_name;
	GtkLabel* quote_screen_name;
	GtkGrid* quote_grid;
	gboolean _read_only;
	Account* account;
	MainWindow* main_window;
	gboolean values_set;
	gboolean delete_first_activated;
	gint64 start_time;
	gint64 end_time;
};

struct _Tweet {
	GObject parent_instance;
	TweetPrivate * priv;
	guint hidden_flags;
	gint64 id;
	MiniTweet* source_tweet;
	MiniTweet* retweeted_tweet;
	MiniTweet* quoted_tweet;
	gchar* avatar_url;
	gboolean verified;
	gint64 my_retweet;
	gboolean protected;
	gchar* notification_id;
	gint64 reply_id;
	gint retweet_count;
	gint favorite_count;
};

struct _TweetClass {
	GObjectClass parent_class;
};

struct _UserIdentity {
	gint64 id;
	gchar* screen_name;
	gchar* user_name;
};

struct _TextEntity {
	guint from;
	guint to;
	gchar* display_text;
	gchar* tooltip_text;
	gchar* target;
	guint info;
};

struct _MiniTweet {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MiniTweetPrivate * priv;
	gint64 id;
	gint64 created_at;
	UserIdentity author;
	gchar* text;
	TextEntity* entities;
	gint entities_length1;
	Media** medias;
	gint medias_length1;
};

struct _MiniTweetClass {
	GTypeClass parent_class;
	void (*finalize) (MiniTweet *self);
};

typedef enum  {
	TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS = 1 << 0,
	TRANSFORM_FLAGS_REMOVE_TRAILING_HASHTAGS = 1 << 1,
	TRANSFORM_FLAGS_EXPAND_LINKS = 1 << 2
} TransformFlags;

struct _MultiMediaWidget {
	GtkBox parent_instance;
	MultiMediaWidgetPrivate * priv;
	GtkWindow* window;
};

struct _MultiMediaWidgetClass {
	GtkBoxClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _Block65Data {
	int _ref_count_;
	TweetListEntry* self;
	gchar* link_text;
};

struct _Block66Data {
	int _ref_count_;
	TweetListEntry* self;
	gulong realize_id;
};


static gpointer tweet_list_entry_parent_class = NULL;
static ITwitterItemIface* tweet_list_entry_itwitter_item_parent_iface = NULL;

GType itwitter_item_get_type (void) G_GNUC_CONST;
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
GType tweet_get_type (void) G_GNUC_CONST;
GType text_button_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType double_tap_button_get_type (void) G_GNUC_CONST;
GType multi_media_widget_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
#define TWEET_LIST_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TWEET_LIST_ENTRY, TweetListEntryPrivate))
enum  {
	TWEET_LIST_ENTRY_DUMMY_PROPERTY,
	TWEET_LIST_ENTRY_READ_ONLY,
	TWEET_LIST_ENTRY_VISIBLE,
	TWEET_LIST_ENTRY_SORT_FACTOR,
	TWEET_LIST_ENTRY_SHOWS_ACTIONS
};
GSettings* settings_get (void);
static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void tweet_list_entry_quote_activated (TweetListEntry* self);
static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void tweet_list_entry_delete_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
#define TWEET_LIST_ENTRY_TRANSITION_DURATION ((gint64) 300)
TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* main_window, Account* account);
TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* main_window, Account* account);
void text_button_set_markup (TextButton* self, const gchar* text);
const gchar* tweet_get_user_name (Tweet* self);
const gchar* tweet_get_screen_name (Tweet* self);
cairo_surface_t* tweet_get_avatar (Tweet* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
gpointer mini_tweet_ref (gpointer instance);
void mini_tweet_unref (gpointer instance);
GParamSpec* param_spec_mini_tweet (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_mini_tweet (GValue* value, gpointer v_object);
void value_take_mini_tweet (GValue* value, gpointer v_object);
gpointer value_get_mini_tweet (const GValue* value);
GType mini_tweet_get_type (void) G_GNUC_CONST;
void avatar_widget_set_verified (AvatarWidget* self, gboolean value);
gchar* tweet_get_trimmed_text (Tweet* self);
gint itwitter_item_update_time_delta (ITwitterItem* self, GDateTime* now);
GType user_identity_get_type (void) G_GNUC_CONST;
UserIdentity* user_identity_dup (const UserIdentity* self);
void user_identity_free (UserIdentity* self);
void user_identity_copy (const UserIdentity* self, UserIdentity* dest);
void user_identity_destroy (UserIdentity* self);
GType text_entity_get_type (void) G_GNUC_CONST;
TextEntity* text_entity_dup (const TextEntity* self);
void text_entity_free (TextEntity* self);
void text_entity_copy (const TextEntity* self, TextEntity* dest);
void text_entity_destroy (TextEntity* self);
GType media_get_type (void) G_GNUC_CONST;
GType transform_flags_get_type (void) G_GNUC_CONST;
gchar* text_transform_transform_tweet (MiniTweet* tweet, TransformFlags flags, gint64 quote_id);
TransformFlags settings_get_text_transform_flags (void);
gboolean tweet_get_retweeted (Tweet* self);
gint64 tweet_get_user_id (Tweet* self);
gint64 account_get_id (Account* self);
static void tweet_list_entry_retweeted_cb (TweetListEntry* self);
static void _tweet_list_entry_retweeted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean tweet_get_favorited (Tweet* self);
static void tweet_list_entry_favorited_cb (TweetListEntry* self);
static void _tweet_list_entry_favorited_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tweet_list_entry_hidden_flags_changed_cb (TweetListEntry* self);
static void _tweet_list_entry_hidden_flags_changed_cb_tweet_hidden_flags_changed (Tweet* _sender, gpointer self);
static void tweet_list_entry_tweet_deleted_cb (TweetListEntry* self);
static void _tweet_list_entry_tweet_deleted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void tweet_list_entry_avatar_changed (TweetListEntry* self);
static void _tweet_list_entry_avatar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
gboolean tweet_get_has_inline_media (Tweet* self);
void multi_media_widget_set_all_media (MultiMediaWidget* self, Media** medias, int medias_length1);
Media** tweet_get_medias (Tweet* self, int* result_length1);
static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, Media* m, gint index);
static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self);
static void tweet_list_entry_media_invalid_cb (TweetListEntry* self);
static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self);
static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self);
static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self);
static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda216_ (TweetListEntry* self);
static void ___lambda216__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self);
static void __lambda217_ (TweetListEntry* self);
void double_tap_button_tap (DoubleTapButton* self);
static void ___lambda217__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self);
void tweet_utils_handle_media_click (Tweet* t, MainWindow* window, gint index);
void tweet_utils_delete_tweet (Account* account, Tweet* tweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_delete_tweet_finish (GAsyncResult* _res_);
static void ___lambda215_ (TweetListEntry* self);
static void ____lambda215__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt);
void double_tap_button_reset (DoubleTapButton* self);
static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt);
static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self);
void tweet_utils_toggle_retweet_tweet (Account* account, Tweet* tweet, gboolean unretweet, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_retweet_tweet_finish (GAsyncResult* _res_);
static void __lambda218_ (TweetListEntry* self);
static void ___lambda218__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self);
void tweet_list_entry_toggle_mode (TweetListEntry* self);
static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self);
void tweet_utils_toggle_favorite_tweet (Account* account, Tweet* tweet, gboolean unfavorite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tweet_utils_toggle_favorite_tweet_finish (GAsyncResult* _res_);
static void __lambda219_ (TweetListEntry* self);
static void ___lambda219__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self);
GType bundle_get_type (void) G_GNUC_CONST;
Bundle* bundle_new (void);
Bundle* bundle_construct (GType object_type);
void bundle_put_int64 (Bundle* self, const gchar* key, gint64 value);
void bundle_put_string (Bundle* self, const gchar* key, const gchar* value);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, Bundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self);
static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self);
GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, GtkWindow* parent, Account* acc, Tweet* reply_to, ComposeTweetWindowMode mode);
static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri);
gboolean tweet_utils_activate_link (const gchar* uri, MainWindow* window);
static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self);
static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static void ___lambda220_ (Block65Data* _data65_);
GType filter_get_type (void) G_GNUC_CONST;
Filter* utils_create_persistent_filter (const gchar* content, Account* account);
void main_window_rerun_filters (MainWindow* self);
static void ____lambda220__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self);
gboolean tweet_get_is_hidden (Tweet* self);
gboolean tweet_get_deleted (Tweet* self);
static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now);
gchar* utils_get_time_delta (GDateTime* time, GDateTime* now);
static gdouble tweet_list_entry_ease_out_cubic (TweetListEntry* self, gdouble t);
static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock);
void tweet_list_entry_fade_in (TweetListEntry* self);
static Block66Data* block66_data_ref (Block66Data* _data66_);
static void block66_data_unref (void * _userdata_);
static void __lambda49_ (Block66Data* _data66_);
static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void ___lambda49__gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void tweet_list_entry_real_show (GtkWidget* base);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
void text_button_set_read_only (TextButton* self, gboolean value);
gboolean tweet_list_entry_get_visible (TweetListEntry* self);
void tweet_list_entry_set_visible (TweetListEntry* self, gboolean value);
static void tweet_list_entry_finalize (GObject* obj);
gint64 itwitter_item_get_sort_factor (ITwitterItem* self);
static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const GActionEntry TWEET_LIST_ENTRY_action_entries[2] = {{"quote", _tweet_list_entry_quote_activated_gsimple_action_activate_callback}, {"delete", _tweet_list_entry_delete_activated_gsimple_action_activate_callback}};

static void _tweet_list_entry_transform_flags_changed_cb_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	tweet_list_entry_transform_flags_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_quote_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_quote_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_activated_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
	tweet_list_entry_delete_activated ((TweetListEntry*) self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _tweet_list_entry_retweeted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_retweeted_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_favorited_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_favorited_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_hidden_flags_changed_cb_tweet_hidden_flags_changed (Tweet* _sender, gpointer self) {
	tweet_list_entry_hidden_flags_changed_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_tweet_deleted_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_tweet_deleted_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_avatar_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	tweet_list_entry_avatar_changed ((TweetListEntry*) self);
}


static void _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked (MultiMediaWidget* _sender, Media* m, gint index, gpointer self) {
	tweet_list_entry_media_clicked_cb ((TweetListEntry*) self, m, index);
}


static void _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid (MultiMediaWidget* _sender, gpointer self) {
	tweet_list_entry_media_invalid_cb ((TweetListEntry*) self);
}


static void _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_reply_tweet_activated ((TweetListEntry*) self);
}


static void _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet (TweetListEntry* _sender, gpointer self) {
	tweet_list_entry_delete_tweet_activated ((TweetListEntry*) self);
}


static void __lambda216_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	GtkContainer* _tmp1_ = NULL;
	GtkContainer* _tmp2_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = gtk_widget_get_parent (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GtkToggleButton* _tmp3_ = NULL;
		GtkToggleButton* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp3_ = self->priv->favorite_button;
		_tmp4_ = self->priv->favorite_button;
		_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
		_tmp6_ = _tmp5_;
		gtk_toggle_button_set_active (_tmp3_, !_tmp6_);
	}
}


static void ___lambda216__tweet_list_entry_favorite_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda216_ ((TweetListEntry*) self);
}


static void __lambda217_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_tap (_tmp0_);
}


static void ___lambda217__tweet_list_entry_retweet_tweet (TweetListEntry* _sender, gpointer self) {
	__lambda217_ ((TweetListEntry*) self);
}


TweetListEntry* tweet_list_entry_construct (GType object_type, Tweet* tweet, MainWindow* main_window, Account* account) {
	TweetListEntry * self = NULL;
	Account* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MainWindow* _tmp3_ = NULL;
	TextButton* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	Tweet* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	AvatarWidget* _tmp14_ = NULL;
	Tweet* _tmp15_ = NULL;
	cairo_surface_t* _tmp16_ = NULL;
	cairo_surface_t* _tmp17_ = NULL;
	AvatarWidget* _tmp18_ = NULL;
	Tweet* _tmp19_ = NULL;
	gboolean _tmp20_ = FALSE;
	GtkLabel* _tmp21_ = NULL;
	Tweet* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_ = NULL;
	Tweet* _tmp25_ = NULL;
	MiniTweet* _tmp26_ = NULL;
	Tweet* _tmp69_ = NULL;
	MiniTweet* _tmp70_ = NULL;
	DoubleTapButton* _tmp91_ = NULL;
	Tweet* _tmp92_ = NULL;
	gboolean _tmp93_ = FALSE;
	gboolean _tmp94_ = FALSE;
	gboolean _tmp95_ = FALSE;
	Tweet* _tmp96_ = NULL;
	gint64 _tmp97_ = 0LL;
	gint64 _tmp98_ = 0LL;
	Account* _tmp99_ = NULL;
	gint64 _tmp100_ = 0LL;
	gint64 _tmp101_ = 0LL;
	DoubleTapButton* _tmp104_ = NULL;
	Tweet* _tmp105_ = NULL;
	GtkToggleButton* _tmp106_ = NULL;
	Tweet* _tmp107_ = NULL;
	gboolean _tmp108_ = FALSE;
	gboolean _tmp109_ = FALSE;
	Tweet* _tmp110_ = NULL;
	Tweet* _tmp111_ = NULL;
	Tweet* _tmp112_ = NULL;
	Tweet* _tmp113_ = NULL;
	gint64 _tmp114_ = 0LL;
	Tweet* _tmp117_ = NULL;
	Tweet* _tmp118_ = NULL;
	gboolean _tmp119_ = FALSE;
	gboolean _tmp120_ = FALSE;
	GSimpleActionGroup* actions = NULL;
	GSimpleActionGroup* _tmp131_ = NULL;
	GSimpleActionGroup* _tmp132_ = NULL;
	GSimpleActionGroup* _tmp133_ = NULL;
	Tweet* _tmp134_ = NULL;
	gint64 _tmp135_ = 0LL;
	gint64 _tmp136_ = 0LL;
	Account* _tmp137_ = NULL;
	gint64 _tmp138_ = 0LL;
	gint64 _tmp139_ = 0LL;
	gboolean _tmp142_ = FALSE;
	Tweet* _tmp143_ = NULL;
	gint64 _tmp144_ = 0LL;
	gint64 _tmp145_ = 0LL;
	Account* _tmp146_ = NULL;
	gint64 _tmp147_ = 0LL;
	gint64 _tmp148_ = 0LL;
	Tweet* _tmp153_ = NULL;
	gboolean _tmp154_ = FALSE;
	gboolean _tmp155_ = FALSE;
	Tweet* _tmp157_ = NULL;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_ = FALSE;
	GSettings* _tmp161_ = NULL;
	GSettings* _tmp162_ = NULL;
	g_return_val_if_fail (IS_TWEET (tweet), NULL);
	g_return_val_if_fail ((main_window == NULL) || IS_MAIN_WINDOW (main_window), NULL);
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	self = (TweetListEntry*) g_object_new (object_type, NULL);
	_tmp0_ = account;
	self->priv->account = _tmp0_;
	_tmp1_ = tweet;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->tweet);
	self->tweet = _tmp2_;
	_tmp3_ = main_window;
	self->priv->main_window = _tmp3_;
	_tmp4_ = self->priv->name_button;
	_tmp5_ = tweet;
	_tmp6_ = tweet_get_user_name (_tmp5_);
	_tmp7_ = _tmp6_;
	text_button_set_markup (_tmp4_, _tmp7_);
	_tmp8_ = self->priv->screen_name_label;
	_tmp9_ = tweet;
	_tmp10_ = tweet_get_screen_name (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat ("@", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	gtk_label_set_label (_tmp8_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = self->priv->avatar_image;
	_tmp15_ = tweet;
	_tmp16_ = tweet_get_avatar (_tmp15_);
	_tmp17_ = _tmp16_;
	avatar_widget_set_surface (_tmp14_, _tmp17_);
	_tmp18_ = self->priv->avatar_image;
	_tmp19_ = tweet;
	_tmp20_ = _tmp19_->verified;
	avatar_widget_set_verified (_tmp18_, _tmp20_);
	_tmp21_ = self->priv->text_label;
	_tmp22_ = tweet;
	_tmp23_ = tweet_get_trimmed_text (_tmp22_);
	_tmp24_ = _tmp23_;
	gtk_label_set_label (_tmp21_, _tmp24_);
	_g_free0 (_tmp24_);
	itwitter_item_update_time_delta (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem), NULL);
	_tmp25_ = tweet;
	_tmp26_ = _tmp25_->retweeted_tweet;
	if (_tmp26_ != NULL) {
		GtkLabel* _tmp27_ = NULL;
		GtkImage* _tmp28_ = NULL;
		GtkLabel* _tmp29_ = NULL;
		Tweet* _tmp30_ = NULL;
		MiniTweet* _tmp31_ = NULL;
		UserIdentity _tmp32_ = {0};
		gint64 _tmp33_ = 0LL;
		gchar* _tmp34_ = NULL;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
		Tweet* _tmp38_ = NULL;
		MiniTweet* _tmp39_ = NULL;
		UserIdentity _tmp40_ = {0};
		const gchar* _tmp41_ = NULL;
		const gchar* _tmp42_ = NULL;
		gchar* _tmp43_ = NULL;
		gchar* _tmp44_ = NULL;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_ = NULL;
		Tweet* _tmp47_ = NULL;
		MiniTweet* _tmp48_ = NULL;
		UserIdentity _tmp49_ = {0};
		const gchar* _tmp50_ = NULL;
		const gchar* _tmp51_ = NULL;
		gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
		Tweet* _tmp56_ = NULL;
		MiniTweet* _tmp57_ = NULL;
		UserIdentity _tmp58_ = {0};
		const gchar* _tmp59_ = NULL;
		const gchar* _tmp60_ = NULL;
		gchar* _tmp61_ = NULL;
		gchar* _tmp62_ = NULL;
		gchar* _tmp63_ = NULL;
		gchar* _tmp64_ = NULL;
		_tmp27_ = self->priv->rt_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
		_tmp28_ = self->priv->rt_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, gtk_widget_get_type (), GtkWidget));
		_tmp29_ = self->priv->rt_label;
		_tmp30_ = tweet;
		_tmp31_ = _tmp30_->source_tweet;
		_tmp32_ = _tmp31_->author;
		_tmp33_ = _tmp32_.id;
		_tmp34_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat ("<span underline='none'><a href=\"@", _tmp35_, "/", NULL);
		_tmp37_ = _tmp36_;
		_tmp38_ = tweet;
		_tmp39_ = _tmp38_->source_tweet;
		_tmp40_ = _tmp39_->author;
		_tmp41_ = _tmp40_.screen_name;
		_tmp42_ = string_to_string (_tmp41_);
		_tmp43_ = g_strconcat ("@", _tmp42_, "\"", NULL);
		_tmp44_ = _tmp43_;
		_tmp45_ = g_strconcat (_tmp37_, _tmp44_, NULL);
		_tmp46_ = _tmp45_;
		_tmp47_ = tweet;
		_tmp48_ = _tmp47_->source_tweet;
		_tmp49_ = _tmp48_->author;
		_tmp50_ = _tmp49_.screen_name;
		_tmp51_ = string_to_string (_tmp50_);
		_tmp52_ = g_strconcat ("title=\"@", _tmp51_, "\">", NULL);
		_tmp53_ = _tmp52_;
		_tmp54_ = g_strconcat (_tmp46_, _tmp53_, NULL);
		_tmp55_ = _tmp54_;
		_tmp56_ = tweet;
		_tmp57_ = _tmp56_->source_tweet;
		_tmp58_ = _tmp57_->author;
		_tmp59_ = _tmp58_.user_name;
		_tmp60_ = string_to_string (_tmp59_);
		_tmp61_ = g_strconcat (_tmp60_, "</a></span>", NULL);
		_tmp62_ = _tmp61_;
		_tmp63_ = g_strconcat (_tmp55_, _tmp62_, NULL);
		_tmp64_ = _tmp63_;
		gtk_label_set_label (_tmp29_, _tmp64_);
		_g_free0 (_tmp64_);
		_g_free0 (_tmp62_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp53_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp37_);
		_g_free0 (_tmp35_);
	} else {
		GtkGrid* _tmp65_ = NULL;
		GtkImage* _tmp66_ = NULL;
		GtkGrid* _tmp67_ = NULL;
		GtkLabel* _tmp68_ = NULL;
		_tmp65_ = self->priv->grid;
		_tmp66_ = self->priv->rt_image;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, gtk_widget_get_type (), GtkWidget));
		_tmp67_ = self->priv->grid;
		_tmp68_ = self->priv->rt_label;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp69_ = tweet;
	_tmp70_ = _tmp69_->quoted_tweet;
	if (_tmp70_ != NULL) {
		GtkLabel* _tmp71_ = NULL;
		Tweet* _tmp72_ = NULL;
		MiniTweet* _tmp73_ = NULL;
		TransformFlags _tmp74_ = 0;
		gchar* _tmp75_ = NULL;
		gchar* _tmp76_ = NULL;
		TextButton* _tmp77_ = NULL;
		Tweet* _tmp78_ = NULL;
		MiniTweet* _tmp79_ = NULL;
		UserIdentity _tmp80_ = {0};
		const gchar* _tmp81_ = NULL;
		GtkLabel* _tmp82_ = NULL;
		Tweet* _tmp83_ = NULL;
		MiniTweet* _tmp84_ = NULL;
		UserIdentity _tmp85_ = {0};
		const gchar* _tmp86_ = NULL;
		gchar* _tmp87_ = NULL;
		gchar* _tmp88_ = NULL;
		GtkGrid* _tmp89_ = NULL;
		GtkGrid* _tmp90_ = NULL;
		_tmp71_ = self->priv->quote_label;
		_tmp72_ = tweet;
		_tmp73_ = _tmp72_->quoted_tweet;
		_tmp74_ = settings_get_text_transform_flags ();
		_tmp75_ = text_transform_transform_tweet (_tmp73_, _tmp74_, (gint64) -1);
		_tmp76_ = _tmp75_;
		gtk_label_set_label (_tmp71_, _tmp76_);
		_g_free0 (_tmp76_);
		_tmp77_ = self->priv->quote_name;
		_tmp78_ = tweet;
		_tmp79_ = _tmp78_->quoted_tweet;
		_tmp80_ = _tmp79_->author;
		_tmp81_ = _tmp80_.user_name;
		text_button_set_markup (_tmp77_, _tmp81_);
		_tmp82_ = self->priv->quote_screen_name;
		_tmp83_ = tweet;
		_tmp84_ = _tmp83_->quoted_tweet;
		_tmp85_ = _tmp84_->author;
		_tmp86_ = _tmp85_.screen_name;
		_tmp87_ = g_strconcat ("@", _tmp86_, NULL);
		_tmp88_ = _tmp87_;
		gtk_label_set_label (_tmp82_, _tmp88_);
		_g_free0 (_tmp88_);
		_tmp89_ = self->priv->quote_grid;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, gtk_widget_get_type (), GtkWidget));
		_tmp90_ = self->priv->quote_grid;
		gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp91_ = self->priv->retweet_button;
	_tmp92_ = tweet;
	_tmp93_ = tweet_get_retweeted (_tmp92_);
	_tmp94_ = _tmp93_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp94_);
	_tmp96_ = tweet;
	_tmp97_ = tweet_get_user_id (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = account;
	_tmp100_ = account_get_id (_tmp99_);
	_tmp101_ = _tmp100_;
	if (_tmp98_ != _tmp101_) {
		Tweet* _tmp102_ = NULL;
		gboolean _tmp103_ = FALSE;
		_tmp102_ = tweet;
		_tmp103_ = _tmp102_->protected;
		_tmp95_ = !_tmp103_;
	} else {
		_tmp95_ = FALSE;
	}
	_tmp104_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp104_, gtk_widget_get_type (), GtkWidget), _tmp95_);
	_tmp105_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, G_TYPE_OBJECT, GObject), "notify::retweeted", (GCallback) _tweet_list_entry_retweeted_cb_g_object_notify, self, 0);
	_tmp106_ = self->priv->favorite_button;
	_tmp107_ = tweet;
	_tmp108_ = tweet_get_favorited (_tmp107_);
	_tmp109_ = _tmp108_;
	gtk_toggle_button_set_active (_tmp106_, _tmp109_);
	_tmp110_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, G_TYPE_OBJECT, GObject), "notify::favorited", (GCallback) _tweet_list_entry_favorited_cb_g_object_notify, self, 0);
	_tmp111_ = tweet;
	g_signal_connect_object (_tmp111_, "hidden-flags-changed", (GCallback) _tweet_list_entry_hidden_flags_changed_cb_tweet_hidden_flags_changed, self, 0);
	_tmp112_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, G_TYPE_OBJECT, GObject), "notify::deleted", (GCallback) _tweet_list_entry_tweet_deleted_cb_g_object_notify, self, 0);
	_tmp113_ = tweet;
	_tmp114_ = _tmp113_->reply_id;
	if (_tmp114_ == ((gint64) 0)) {
		GtkImage* _tmp115_ = NULL;
		_tmp115_ = self->priv->conversation_image;
		gtk_widget_unparent (G_TYPE_CHECK_INSTANCE_CAST (_tmp115_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkImage* _tmp116_ = NULL;
		_tmp116_ = self->priv->conversation_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp116_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp117_ = tweet;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp117_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) _tweet_list_entry_avatar_changed_g_object_notify, self, 0);
	_tmp118_ = tweet;
	_tmp119_ = tweet_get_has_inline_media (_tmp118_);
	_tmp120_ = _tmp119_;
	if (_tmp120_) {
		MultiMediaWidget* _tmp121_ = NULL;
		Tweet* _tmp122_ = NULL;
		Media** _tmp123_ = NULL;
		gint _tmp123__length1 = 0;
		Media** _tmp124_ = NULL;
		gint _tmp124__length1 = 0;
		MultiMediaWidget* _tmp125_ = NULL;
		MultiMediaWidget* _tmp126_ = NULL;
		MultiMediaWidget* _tmp127_ = NULL;
		MainWindow* _tmp128_ = NULL;
		_tmp121_ = self->priv->mm_widget;
		_tmp122_ = tweet;
		_tmp123_ = tweet_get_medias (_tmp122_, &_tmp123__length1);
		_tmp124_ = _tmp123_;
		_tmp124__length1 = _tmp123__length1;
		multi_media_widget_set_all_media (_tmp121_, _tmp124_, _tmp124__length1);
		_tmp125_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp125_, "media-clicked", (GCallback) _tweet_list_entry_media_clicked_cb_multi_media_widget_media_clicked, self, 0);
		_tmp126_ = self->priv->mm_widget;
		g_signal_connect_object (_tmp126_, "media-invalid", (GCallback) _tweet_list_entry_media_invalid_cb_multi_media_widget_media_invalid, self, 0);
		_tmp127_ = self->priv->mm_widget;
		_tmp128_ = main_window;
		_tmp127_->window = G_TYPE_CHECK_INSTANCE_CAST (_tmp128_, gtk_window_get_type (), GtkWindow);
	} else {
		GtkGrid* _tmp129_ = NULL;
		MultiMediaWidget* _tmp130_ = NULL;
		_tmp129_ = self->priv->grid;
		_tmp130_ = self->priv->mm_widget;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp129_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp130_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp131_ = g_simple_action_group_new ();
	actions = _tmp131_;
	_tmp132_ = actions;
	g_action_map_add_action_entries (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, g_action_map_get_type (), GActionMap), TWEET_LIST_ENTRY_action_entries, G_N_ELEMENTS (TWEET_LIST_ENTRY_action_entries), self);
	_tmp133_ = actions;
	gtk_widget_insert_action_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "tweet", G_TYPE_CHECK_INSTANCE_CAST (_tmp133_, g_action_group_get_type (), GActionGroup));
	_tmp134_ = tweet;
	_tmp135_ = tweet_get_user_id (_tmp134_);
	_tmp136_ = _tmp135_;
	_tmp137_ = account;
	_tmp138_ = account_get_id (_tmp137_);
	_tmp139_ = _tmp138_;
	if (_tmp136_ != _tmp139_) {
		GSimpleActionGroup* _tmp140_ = NULL;
		GAction* _tmp141_ = NULL;
		_tmp140_ = actions;
		_tmp141_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp140_, g_action_map_get_type (), GActionMap), "delete");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp141_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_tmp143_ = tweet;
	_tmp144_ = tweet_get_user_id (_tmp143_);
	_tmp145_ = _tmp144_;
	_tmp146_ = account;
	_tmp147_ = account_get_id (_tmp146_);
	_tmp148_ = _tmp147_;
	if (_tmp145_ == _tmp148_) {
		_tmp142_ = TRUE;
	} else {
		Tweet* _tmp149_ = NULL;
		gboolean _tmp150_ = FALSE;
		_tmp149_ = tweet;
		_tmp150_ = _tmp149_->protected;
		_tmp142_ = _tmp150_;
	}
	if (_tmp142_) {
		GSimpleActionGroup* _tmp151_ = NULL;
		GAction* _tmp152_ = NULL;
		_tmp151_ = actions;
		_tmp152_ = g_action_map_lookup_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp151_, g_action_map_get_type (), GActionMap), "quote");
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp152_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	g_signal_connect_object (self, "reply-tweet", (GCallback) _tweet_list_entry_reply_tweet_activated_tweet_list_entry_reply_tweet, self, 0);
	g_signal_connect_object (self, "delete-tweet", (GCallback) _tweet_list_entry_delete_tweet_activated_tweet_list_entry_delete_tweet, self, 0);
	g_signal_connect_object (self, "favorite-tweet", (GCallback) ___lambda216__tweet_list_entry_favorite_tweet, self, 0);
	g_signal_connect_object (self, "retweet-tweet", (GCallback) ___lambda217__tweet_list_entry_retweet_tweet, self, 0);
	_tmp153_ = tweet;
	_tmp154_ = tweet_get_favorited (_tmp153_);
	_tmp155_ = _tmp154_;
	if (_tmp155_) {
		GtkImage* _tmp156_ = NULL;
		_tmp156_ = self->priv->fav_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp156_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp157_ = tweet;
	_tmp158_ = tweet_get_retweeted (_tmp157_);
	_tmp159_ = _tmp158_;
	if (_tmp159_) {
		GtkImage* _tmp160_ = NULL;
		_tmp160_ = self->priv->rt_status_image;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, gtk_widget_get_type (), GtkWidget));
	}
	self->priv->values_set = TRUE;
	_tmp161_ = settings_get ();
	_tmp162_ = _tmp161_;
	g_signal_connect_object (_tmp162_, "changed::text-transform-flags", (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self, 0);
	_g_object_unref0 (_tmp162_);
	_g_object_unref0 (actions);
	_g_object_unref0 (tweet);
	return self;
}


TweetListEntry* tweet_list_entry_new (Tweet* tweet, MainWindow* main_window, Account* account) {
	return tweet_list_entry_construct (TYPE_TWEET_LIST_ENTRY, tweet, main_window, account);
}


static void tweet_list_entry_transform_flags_changed_cb (TweetListEntry* self) {
	GtkLabel* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Tweet* _tmp4_ = NULL;
	MiniTweet* _tmp5_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->text_label;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_trimmed_text (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_label_set_label (_tmp0_, _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = self->tweet;
	_tmp5_ = _tmp4_->quoted_tweet;
	if (_tmp5_ != NULL) {
		GtkLabel* _tmp6_ = NULL;
		Tweet* _tmp7_ = NULL;
		MiniTweet* _tmp8_ = NULL;
		TransformFlags _tmp9_ = 0;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		_tmp6_ = self->priv->quote_label;
		_tmp7_ = self->tweet;
		_tmp8_ = _tmp7_->quoted_tweet;
		_tmp9_ = settings_get_text_transform_flags ();
		_tmp10_ = text_transform_transform_tweet (_tmp8_, _tmp9_, (gint64) -1);
		_tmp11_ = _tmp10_;
		gtk_label_set_label (_tmp6_, _tmp11_);
		_g_free0 (_tmp11_);
	}
}


static void tweet_list_entry_favorited_cb (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkImage* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->favorite_button;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_favorited (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (_tmp0_, _tmp3_);
	_tmp4_ = self->priv->fav_status_image;
	_tmp5_ = self->tweet;
	_tmp6_ = tweet_get_favorited (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp7_);
	self->priv->values_set = TRUE;
}


static void tweet_list_entry_retweeted_cb (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GtkImage* _tmp4_ = NULL;
	Tweet* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->values_set = FALSE;
	_tmp0_ = self->priv->retweet_button;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_retweeted (_tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_toggle_button_get_type (), GtkToggleButton), _tmp3_);
	_tmp4_ = self->priv->rt_status_image;
	_tmp5_ = self->tweet;
	_tmp6_ = tweet_get_retweeted (_tmp5_);
	_tmp7_ = _tmp6_;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp7_);
	self->priv->values_set = TRUE;
}


static void tweet_list_entry_media_clicked_cb (TweetListEntry* self, Media* m, gint index) {
	Tweet* _tmp0_ = NULL;
	MainWindow* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (IS_MEDIA (m));
	_tmp0_ = self->tweet;
	_tmp1_ = self->priv->main_window;
	_tmp2_ = index;
	tweet_utils_handle_media_click (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda215_ (TweetListEntry* self) {
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
}


static void ____lambda215__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda215_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_delete_tweet_activated (TweetListEntry* self) {
	Tweet* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	Account* _tmp3_ = NULL;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = tweet_get_user_id (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->account;
	_tmp4_ = account_get_id (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp2_ != _tmp5_) {
		return;
	}
	_tmp6_ = self->priv->delete_first_activated;
	if (_tmp6_) {
		Account* _tmp7_ = NULL;
		Tweet* _tmp8_ = NULL;
		_tmp7_ = self->priv->account;
		_tmp8_ = self->tweet;
		tweet_utils_delete_tweet (_tmp7_, _tmp8_, ____lambda215__gasync_ready_callback, g_object_ref (self));
	} else {
		self->priv->delete_first_activated = TRUE;
	}
}


static void tweet_list_entry_avatar_changed (TweetListEntry* self) {
	AvatarWidget* _tmp0_ = NULL;
	Tweet* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->tweet;
	_tmp2_ = tweet_get_avatar (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static gboolean tweet_list_entry_focus_out_cb (TweetListEntry* self, GdkEventFocus* evt) {
	gboolean result = FALSE;
	DoubleTapButton* _tmp0_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	self->priv->delete_first_activated = FALSE;
	_tmp0_ = self->priv->retweet_button;
	double_tap_button_reset (_tmp0_);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_focus_out_cb ((TweetListEntry*) self, event);
	return result;
}


static gboolean tweet_list_entry_key_released_cb (TweetListEntry* self, GdkEventKey* evt) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (evt != NULL, FALSE);
	result = FALSE;
	return result;
}


static gboolean _tweet_list_entry_key_released_cb_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = tweet_list_entry_key_released_cb ((TweetListEntry*) self, event);
	return result;
}


/**
   * Retweets or un-retweets the tweet.
   */
static void __lambda218_ (TweetListEntry* self) {
	DoubleTapButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda218__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda218_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_retweet_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	Account* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	Tweet* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	DoubleTapButton* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	Tweet* _tmp11_ = NULL;
	DoubleTapButton* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->tweet;
	_tmp5_ = tweet_get_user_id (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3_ == _tmp6_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		_tmp7_ = self->priv->values_set;
		_tmp0_ = !_tmp7_;
	}
	if (_tmp0_) {
		DoubleTapButton* _tmp8_ = NULL;
		_tmp8_ = self->priv->retweet_button;
		gtk_toggle_button_set_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_toggle_button_get_type (), GtkToggleButton), FALSE);
		return;
	}
	_tmp9_ = self->priv->retweet_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp10_ = self->priv->account;
	_tmp11_ = self->tweet;
	_tmp12_ = self->priv->retweet_button;
	_tmp13_ = gtk_toggle_button_get_active (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_toggle_button_get_type (), GtkToggleButton));
	_tmp14_ = _tmp13_;
	tweet_utils_toggle_retweet_tweet (_tmp10_, _tmp11_, !_tmp14_, ___lambda218__gasync_ready_callback, g_object_ref (self));
	_tmp15_ = tweet_list_entry_get_shows_actions (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_retweet_button_toggled_cb ((TweetListEntry*) self);
}


static void __lambda219_ (TweetListEntry* self) {
	GtkToggleButton* _tmp0_ = NULL;
	_tmp0_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static void ___lambda219__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda219_ ((TweetListEntry*) self);
	g_object_unref (self);
}


static void tweet_list_entry_favorite_button_toggled_cb (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkToggleButton* _tmp1_ = NULL;
	Account* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	GtkToggleButton* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->values_set;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->favorite_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp2_ = self->priv->account;
	_tmp3_ = self->tweet;
	_tmp4_ = self->priv->favorite_button;
	_tmp5_ = gtk_toggle_button_get_active (_tmp4_);
	_tmp6_ = _tmp5_;
	tweet_utils_toggle_favorite_tweet (_tmp2_, _tmp3_, !_tmp6_, ___lambda219__gasync_ready_callback, g_object_ref (self));
	_tmp7_ = tweet_list_entry_get_shows_actions (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_) {
		tweet_list_entry_toggle_mode (self);
	}
}


static void _tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	tweet_list_entry_favorite_button_toggled_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_name_button_clicked_cb (TweetListEntry* self) {
	gint64 user_id = 0LL;
	gchar* screen_name = NULL;
	Tweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp20_ = NULL;
	gint64 _tmp21_ = 0LL;
	const gchar* _tmp22_ = NULL;
	MainWindow* _tmp23_ = NULL;
	MainWidget* _tmp24_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->retweeted_tweet;
	if (_tmp1_ != NULL) {
		Tweet* _tmp2_ = NULL;
		MiniTweet* _tmp3_ = NULL;
		UserIdentity _tmp4_ = {0};
		gint64 _tmp5_ = 0LL;
		Tweet* _tmp6_ = NULL;
		MiniTweet* _tmp7_ = NULL;
		UserIdentity _tmp8_ = {0};
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		_tmp2_ = self->tweet;
		_tmp3_ = _tmp2_->retweeted_tweet;
		_tmp4_ = _tmp3_->author;
		_tmp5_ = _tmp4_.id;
		user_id = _tmp5_;
		_tmp6_ = self->tweet;
		_tmp7_ = _tmp6_->retweeted_tweet;
		_tmp8_ = _tmp7_->author;
		_tmp9_ = _tmp8_.screen_name;
		_tmp10_ = g_strdup (_tmp9_);
		_g_free0 (screen_name);
		screen_name = _tmp10_;
	} else {
		Tweet* _tmp11_ = NULL;
		MiniTweet* _tmp12_ = NULL;
		UserIdentity _tmp13_ = {0};
		gint64 _tmp14_ = 0LL;
		Tweet* _tmp15_ = NULL;
		MiniTweet* _tmp16_ = NULL;
		UserIdentity _tmp17_ = {0};
		const gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
		_tmp11_ = self->tweet;
		_tmp12_ = _tmp11_->source_tweet;
		_tmp13_ = _tmp12_->author;
		_tmp14_ = _tmp13_.id;
		user_id = _tmp14_;
		_tmp15_ = self->tweet;
		_tmp16_ = _tmp15_->source_tweet;
		_tmp17_ = _tmp16_->author;
		_tmp18_ = _tmp17_.screen_name;
		_tmp19_ = g_strdup (_tmp18_);
		_g_free0 (screen_name);
		screen_name = _tmp19_;
	}
	_tmp20_ = bundle_new ();
	bundle = _tmp20_;
	_tmp21_ = user_id;
	bundle_put_int64 (bundle, "user_id", _tmp21_);
	_tmp22_ = screen_name;
	bundle_put_string (bundle, "screen_name", _tmp22_);
	_tmp23_ = self->priv->main_window;
	_tmp24_ = _tmp23_->main_widget;
	main_widget_switch_page (_tmp24_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
	_g_free0 (screen_name);
}


static void _tweet_list_entry_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_name_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_quote_name_button_clicked_cb (TweetListEntry* self) {
	Tweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	Bundle* bundle = NULL;
	Bundle* _tmp2_ = NULL;
	Tweet* _tmp3_ = NULL;
	MiniTweet* _tmp4_ = NULL;
	UserIdentity _tmp5_ = {0};
	gint64 _tmp6_ = 0LL;
	Tweet* _tmp7_ = NULL;
	MiniTweet* _tmp8_ = NULL;
	UserIdentity _tmp9_ = {0};
	const gchar* _tmp10_ = NULL;
	MainWindow* _tmp11_ = NULL;
	MainWidget* _tmp12_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->quoted_tweet;
	_vala_assert (_tmp1_ != NULL, "tweet.quoted_tweet != null");
	_tmp2_ = bundle_new ();
	bundle = _tmp2_;
	_tmp3_ = self->tweet;
	_tmp4_ = _tmp3_->quoted_tweet;
	_tmp5_ = _tmp4_->author;
	_tmp6_ = _tmp5_.id;
	bundle_put_int64 (bundle, "user_id", _tmp6_);
	_tmp7_ = self->tweet;
	_tmp8_ = _tmp7_->quoted_tweet;
	_tmp9_ = _tmp8_->author;
	_tmp10_ = _tmp9_.screen_name;
	bundle_put_string (bundle, "screen_name", _tmp10_);
	_tmp11_ = self->priv->main_window;
	_tmp12_ = _tmp11_->main_widget;
	main_widget_switch_page (_tmp12_, (gint) PAGE_PROFILE, bundle);
	_g_object_unref0 (bundle);
}


static void _tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_quote_name_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_reply_button_clicked_cb (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	ComposeTweetWindow* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	_tmp4_ = ctw;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
	_tmp5_ = tweet_list_entry_get_shows_actions (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		tweet_list_entry_toggle_mode (self);
	}
	_g_object_unref0 (ctw);
}


static void _tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	tweet_list_entry_reply_button_clicked_cb ((TweetListEntry*) self);
}


static void tweet_list_entry_quote_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_QUOTE);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	tweet_list_entry_toggle_mode (self);
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_reply_tweet_activated (TweetListEntry* self) {
	ComposeTweetWindow* ctw = NULL;
	MainWindow* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	ComposeTweetWindow* _tmp3_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->main_window;
	_tmp1_ = self->priv->account;
	_tmp2_ = self->tweet;
	_tmp3_ = compose_tweet_window_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp1_, _tmp2_, COMPOSE_TWEET_WINDOW_MODE_REPLY);
	g_object_ref_sink (_tmp3_);
	ctw = _tmp3_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (ctw, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (ctw);
}


static void tweet_list_entry_delete_activated (TweetListEntry* self) {
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	self->priv->delete_first_activated = TRUE;
	g_signal_emit_by_name (self, "delete-tweet");
	tweet_list_entry_toggle_mode (self);
}


static gboolean tweet_list_entry_link_activated_cb (TweetListEntry* self, const gchar* uri) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	MainWindow* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = uri;
	_tmp2_ = self->priv->main_window;
	_tmp3_ = tweet_utils_activate_link (_tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static gboolean _tweet_list_entry_link_activated_cb_gtk_label_activate_link (GtkLabel* _sender, const gchar* uri, gpointer self) {
	gboolean result;
	result = tweet_list_entry_link_activated_cb ((TweetListEntry*) self, uri);
	return result;
}


static Block65Data* block65_data_ref (Block65Data* _data65_) {
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}


static void block65_data_unref (void * _userdata_) {
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		TweetListEntry* self;
		self = _data65_->self;
		_g_free0 (_data65_->link_text);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}


static void ___lambda220_ (Block65Data* _data65_) {
	TweetListEntry* self;
	const gchar* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	Filter* _tmp2_ = NULL;
	Filter* _tmp3_ = NULL;
	MainWindow* _tmp4_ = NULL;
	self = _data65_->self;
	_tmp0_ = _data65_->link_text;
	_tmp1_ = self->priv->account;
	_tmp2_ = utils_create_persistent_filter (_tmp0_, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->main_window;
	main_window_rerun_filters (_tmp4_);
}


static void ____lambda220__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	___lambda220_ (self);
}


static void tweet_list_entry_populate_popup_cb (TweetListEntry* self, GtkLabel* source, GtkMenu* menu) {
	Block65Data* _data65_;
	GtkLabel* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	g_return_if_fail (GTK_IS_LABEL (source));
	g_return_if_fail (GTK_IS_MENU (menu));
	_data65_ = g_slice_new0 (Block65Data);
	_data65_->_ref_count_ = 1;
	_data65_->self = g_object_ref (self);
	_tmp0_ = source;
	_tmp1_ = gtk_label_get_current_uri (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	_data65_->link_text = _tmp2_;
	_tmp3_ = _data65_->link_text;
	_tmp4_ = g_str_has_prefix (_tmp3_, "#");
	if (_tmp4_) {
		GtkMenuItem* item = NULL;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GtkMenuItem* _tmp9_ = NULL;
		GtkMenuItem* _tmp10_ = NULL;
		GtkMenuItem* _tmp11_ = NULL;
		GtkMenuItem* _tmp12_ = NULL;
		GtkMenu* _tmp13_ = NULL;
		GtkMenuItem* _tmp14_ = NULL;
		_tmp5_ = _ ("Block %s");
		_tmp6_ = _data65_->link_text;
		_tmp7_ = g_strdup_printf (_tmp5_, _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp8_);
		g_object_ref_sink (_tmp9_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		item = _tmp10_;
		_tmp11_ = item;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = item;
		g_signal_connect_data (_tmp12_, "activate", (GCallback) ____lambda220__gtk_menu_item_activate, block65_data_ref (_data65_), (GClosureNotify) block65_data_unref, 0);
		_tmp13_ = menu;
		_tmp14_ = item;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_g_object_unref0 (item);
	}
	block65_data_unref (_data65_);
	_data65_ = NULL;
}


static void _tweet_list_entry_populate_popup_cb_gtk_label_populate_popup (GtkLabel* _sender, GtkMenu* menu, gpointer self) {
	tweet_list_entry_populate_popup_cb ((TweetListEntry*) self, _sender, menu);
}


static void tweet_list_entry_media_invalid_cb (TweetListEntry* self) {
	TransformFlags flags = 0;
	TransformFlags _tmp0_ = 0;
	MiniTweet* _tmp1_ = NULL;
	Tweet* _tmp2_ = NULL;
	MiniTweet* _tmp3_ = NULL;
	gchar* new_text = NULL;
	TransformFlags _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	GtkLabel* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	Tweet* _tmp10_ = NULL;
	MiniTweet* _tmp11_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = settings_get_text_transform_flags ();
	flags = _tmp0_ & (~TRANSFORM_FLAGS_REMOVE_MEDIA_LINKS);
	_tmp2_ = self->tweet;
	_tmp3_ = _tmp2_->retweeted_tweet;
	_tmp1_ = _tmp3_;
	if (_tmp1_ == NULL) {
		Tweet* _tmp4_ = NULL;
		MiniTweet* _tmp5_ = NULL;
		_tmp4_ = self->tweet;
		_tmp5_ = _tmp4_->source_tweet;
		_tmp1_ = _tmp5_;
	}
	_tmp6_ = flags;
	_tmp7_ = text_transform_transform_tweet (_tmp1_, _tmp6_, (gint64) -1);
	new_text = _tmp7_;
	_tmp8_ = self->priv->text_label;
	_tmp9_ = new_text;
	gtk_label_set_label (_tmp8_, _tmp9_);
	_tmp10_ = self->tweet;
	_tmp11_ = _tmp10_->quoted_tweet;
	if (_tmp11_ != NULL) {
		gchar* new_quote_text = NULL;
		Tweet* _tmp12_ = NULL;
		MiniTweet* _tmp13_ = NULL;
		TransformFlags _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		GtkLabel* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp12_ = self->tweet;
		_tmp13_ = _tmp12_->quoted_tweet;
		_tmp14_ = flags;
		_tmp15_ = text_transform_transform_tweet (_tmp13_, _tmp14_, (gint64) -1);
		new_quote_text = _tmp15_;
		_tmp16_ = self->priv->quote_label;
		_tmp17_ = new_quote_text;
		gtk_label_set_label (_tmp16_, _tmp17_);
		_g_free0 (new_quote_text);
	}
	_g_free0 (new_text);
}


static void tweet_list_entry_hidden_flags_changed_cb (TweetListEntry* self) {
	Tweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = tweet_get_is_hidden (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	} else {
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void tweet_list_entry_tweet_deleted_cb (TweetListEntry* self) {
	Tweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkStack* _tmp3_ = NULL;
	GtkGrid* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->tweet;
	_tmp1_ = tweet_get_deleted (_tmp0_);
	_tmp2_ = _tmp1_;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), !_tmp2_);
	_tmp3_ = self->priv->stack;
	_tmp4_ = self->priv->grid;
	gtk_stack_set_visible_child (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
}


/**
   * Updates the time delta label in the upper right
   *
   * @return The seconds between the current time and
   *         the time the tweet was created
   */
static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static gint tweet_list_entry_real_update_time_delta (ITwitterItem* base, GDateTime* now) {
	TweetListEntry * self;
	gint result = 0;
	GDateTime* cur_time = NULL;
	GDateTime* _tmp0_ = NULL;
	gint64 _tmp4_ = 0LL;
	Tweet* _tmp5_ = NULL;
	MiniTweet* _tmp6_ = NULL;
	GDateTime* then = NULL;
	GDateTime* _tmp13_ = NULL;
	GtkLabel* _tmp14_ = NULL;
	GDateTime* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	GDateTime* _tmp18_ = NULL;
	GTimeSpan _tmp19_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = now;
	if (_tmp0_ == NULL) {
		GDateTime* _tmp1_ = NULL;
		_tmp1_ = g_date_time_new_now_local ();
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp1_;
	} else {
		GDateTime* _tmp2_ = NULL;
		GDateTime* _tmp3_ = NULL;
		_tmp2_ = now;
		_tmp3_ = _g_date_time_ref0 (_tmp2_);
		_g_date_time_unref0 (cur_time);
		cur_time = _tmp3_;
	}
	_tmp5_ = self->tweet;
	_tmp6_ = _tmp5_->retweeted_tweet;
	if (_tmp6_ != NULL) {
		Tweet* _tmp7_ = NULL;
		MiniTweet* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		_tmp7_ = self->tweet;
		_tmp8_ = _tmp7_->retweeted_tweet;
		_tmp9_ = _tmp8_->created_at;
		_tmp4_ = _tmp9_;
	} else {
		Tweet* _tmp10_ = NULL;
		MiniTweet* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		_tmp10_ = self->tweet;
		_tmp11_ = _tmp10_->source_tweet;
		_tmp12_ = _tmp11_->created_at;
		_tmp4_ = _tmp12_;
	}
	_tmp13_ = g_date_time_new_from_unix_local (_tmp4_);
	then = _tmp13_;
	_tmp14_ = self->priv->time_delta_label;
	_tmp15_ = cur_time;
	_tmp16_ = utils_get_time_delta (then, _tmp15_);
	_tmp17_ = _tmp16_;
	gtk_label_set_label (_tmp14_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp18_ = cur_time;
	_tmp19_ = g_date_time_difference (_tmp18_, then);
	result = (gint) ((_tmp19_ / 1000.0) / 1000.0);
	_g_date_time_unref0 (then);
	_g_date_time_unref0 (cur_time);
	return result;
}


void tweet_list_entry_toggle_mode (TweetListEntry* self) {
	gboolean _tmp0_ = FALSE;
	GtkStack* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkBox* _tmp4_ = NULL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->_read_only;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->stack;
	_tmp2_ = gtk_stack_get_visible_child (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = self->priv->action_box;
	if (_tmp3_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget)) {
		GtkStack* _tmp5_ = NULL;
		GtkGrid* _tmp6_ = NULL;
		_tmp5_ = self->priv->stack;
		_tmp6_ = self->priv->grid;
		gtk_stack_set_visible_child (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), TRUE);
	} else {
		GtkStack* _tmp7_ = NULL;
		GtkBox* _tmp8_ = NULL;
		_tmp7_ = self->priv->stack;
		_tmp8_ = self->priv->action_box;
		gtk_stack_set_visible_child (_tmp7_, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_widget_get_type (), GtkWidget));
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
	}
}


static gdouble tweet_list_entry_ease_out_cubic (TweetListEntry* self, gdouble t) {
	gdouble result = 0.0;
	gdouble p = 0.0;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), 0.0);
	_tmp0_ = t;
	p = _tmp0_ - 1;
	result = ((p * p) * p) + 1;
	return result;
}


static gboolean tweet_list_entry_anim_tick (TweetListEntry* self, GtkWidget* widget, GdkFrameClock* frame_clock) {
	gboolean result = FALSE;
	gint64 now = 0LL;
	GdkFrameClock* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gdouble t = 0.0;
	gint64 _tmp4_ = 0LL;
	gint64 _tmp5_ = 0LL;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gdouble _tmp8_ = 0.0;
	gdouble _tmp9_ = 0.0;
	gdouble _tmp10_ = 0.0;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	g_return_val_if_fail (GTK_IS_WIDGET (widget), FALSE);
	g_return_val_if_fail (GDK_IS_FRAME_CLOCK (frame_clock), FALSE);
	_tmp0_ = frame_clock;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = self->priv->end_time;
	if (_tmp2_ > _tmp3_) {
		gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), 1.0);
		result = FALSE;
		return result;
	}
	_tmp4_ = now;
	_tmp5_ = self->priv->start_time;
	_tmp6_ = self->priv->end_time;
	_tmp7_ = self->priv->start_time;
	t = (_tmp4_ - _tmp5_) / ((gdouble) (_tmp6_ - _tmp7_));
	_tmp8_ = t;
	_tmp9_ = tweet_list_entry_ease_out_cubic (self, _tmp8_);
	t = _tmp9_;
	_tmp10_ = t;
	gtk_widget_set_opacity (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tmp10_);
	result = TRUE;
	return result;
}


static Block66Data* block66_data_ref (Block66Data* _data66_) {
	g_atomic_int_inc (&_data66_->_ref_count_);
	return _data66_;
}


static void block66_data_unref (void * _userdata_) {
	Block66Data* _data66_;
	_data66_ = (Block66Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data66_->_ref_count_)) {
		TweetListEntry* self;
		self = _data66_->self;
		_g_object_unref0 (self);
		g_slice_free (Block66Data, _data66_);
	}
}


static gboolean _tweet_list_entry_anim_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = tweet_list_entry_anim_tick ((TweetListEntry*) self, widget, frame_clock);
	return result;
}


static void __lambda49_ (Block66Data* _data66_) {
	TweetListEntry* self;
	GdkFrameClock* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gint64 _tmp2_ = 0LL;
	gulong _tmp3_ = 0UL;
	self = _data66_->self;
	_tmp0_ = gtk_widget_get_frame_clock (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	self->priv->start_time = _tmp1_;
	_tmp2_ = self->priv->start_time;
	self->priv->end_time = _tmp2_ + (TWEET_LIST_ENTRY_TRANSITION_DURATION * 1000);
	gtk_widget_add_tick_callback (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), _tweet_list_entry_anim_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
	_tmp3_ = _data66_->realize_id;
	g_signal_handler_disconnect (G_TYPE_CHECK_INSTANCE_CAST (self, G_TYPE_OBJECT, GObject), _tmp3_);
}


static void ___lambda49__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	__lambda49_ (self);
}


void tweet_list_entry_fade_in (TweetListEntry* self) {
	Block66Data* _data66_;
	gboolean _tmp0_ = FALSE;
	gulong _tmp1_ = 0UL;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_data66_ = g_slice_new0 (Block66Data);
	_data66_->_ref_count_ = 1;
	_data66_->self = g_object_ref (self);
	_tmp0_ = gtk_widget_get_realized (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	if (_tmp0_) {
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
		block66_data_unref (_data66_);
		_data66_ = NULL;
		return;
	}
	_data66_->realize_id = (gulong) 0;
	_tmp1_ = g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), "realize", (GCallback) ___lambda49__gtk_widget_realize, block66_data_ref (_data66_), (GClosureNotify) block66_data_unref, 0);
	_data66_->realize_id = _tmp1_;
	gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	block66_data_unref (_data66_);
	_data66_ = NULL;
}


static void tweet_list_entry_real_show (GtkWidget* base) {
	TweetListEntry * self;
	Tweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = tweet_get_is_hidden (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		return;
	}
	GTK_WIDGET_CLASS (tweet_list_entry_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow), gtk_widget_get_type (), GtkWidget));
}


void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value) {
	MultiMediaWidget* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	TextButton* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = self->priv->mm_widget;
	_tmp1_ = value;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget), !_tmp1_);
	_tmp2_ = self->priv->name_button;
	_tmp3_ = value;
	text_button_set_read_only (_tmp2_, _tmp3_);
	_tmp4_ = value;
	self->priv->_read_only = _tmp4_;
	g_object_notify ((GObject *) self, "read-only");
}


gboolean tweet_list_entry_get_visible (TweetListEntry* self) {
	gboolean result;
	Tweet* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->tweet;
	_tmp1_ = tweet_get_is_hidden (_tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}


void tweet_list_entry_set_visible (TweetListEntry* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_TWEET_LIST_ENTRY (self));
	_tmp0_ = value;
	g_object_notify ((GObject *) self, "visible");
}


static gint64 tweet_list_entry_real_get_sort_factor (ITwitterItem* base) {
	gint64 result;
	TweetListEntry* self;
	Tweet* _tmp0_ = NULL;
	MiniTweet* _tmp1_ = NULL;
	gint64 _tmp2_ = 0LL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = self->tweet;
	_tmp1_ = _tmp0_->source_tweet;
	_tmp2_ = _tmp1_->id;
	result = _tmp2_;
	return result;
}


gboolean tweet_list_entry_get_shows_actions (TweetListEntry* self) {
	gboolean result;
	GtkStack* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	g_return_val_if_fail (IS_TWEET_LIST_ENTRY (self), FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->action_box;
	result = _tmp2_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget);
	return result;
}


static void tweet_list_entry_class_init (TweetListEntryClass * klass) {
	gint TweetListEntry_private_offset;
	GtkBindingSet* binding_set = NULL;
	GTypeClass* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	GtkBindingSet* _tmp2_ = NULL;
	GtkBindingSet* _tmp3_ = NULL;
	GtkBindingSet* _tmp4_ = NULL;
	GtkBindingSet* _tmp5_ = NULL;
	GtkBindingSet* _tmp6_ = NULL;
	GtkBindingSet* _tmp7_ = NULL;
	tweet_list_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TweetListEntryPrivate));
	((GtkWidgetClass *) klass)->show = tweet_list_entry_real_show;
	G_OBJECT_CLASS (klass)->get_property = _vala_tweet_list_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tweet_list_entry_set_property;
	G_OBJECT_CLASS (klass)->finalize = tweet_list_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_READ_ONLY, g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_VISIBLE, g_param_spec_boolean ("visible", "visible", "visible", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SORT_FACTOR, g_param_spec_int64 ("sort-factor", "sort-factor", "sort-factor", G_MININT64, G_MAXINT64, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TWEET_LIST_ENTRY_SHOWS_ACTIONS, g_param_spec_boolean ("shows-actions", "shows-actions", "shows-actions", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	TweetListEntry_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/tweet-list-entry.ui");
	g_signal_new ("reply_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("favorite_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("retweet_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("delete_tweet", TYPE_TWEET_LIST_ENTRY, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "screen_name_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, screen_name_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "name_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, name_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "time_delta_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, time_delta_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, text_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "conversation_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, conversation_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "rt_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, rt_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fav_status_image", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, fav_status_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "retweet_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, retweet_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "favorite_button", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, favorite_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mm_widget", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, mm_widget));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "action_box", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, action_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quote_label", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, quote_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quote_name", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, quote_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quote_screen_name", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, quote_screen_name));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "quote_grid", FALSE, TweetListEntry_private_offset + G_STRUCT_OFFSET (TweetListEntryPrivate, quote_grid));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "focus_out_cb", G_CALLBACK(_tweet_list_entry_focus_out_cb_gtk_widget_focus_out_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "key_released_cb", G_CALLBACK(_tweet_list_entry_key_released_cb_gtk_widget_key_release_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "retweet_button_toggled_cb", G_CALLBACK(_tweet_list_entry_retweet_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "favorite_button_toggled_cb", G_CALLBACK(_tweet_list_entry_favorite_button_toggled_cb_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "name_button_clicked_cb", G_CALLBACK(_tweet_list_entry_name_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "quote_name_button_clicked_cb", G_CALLBACK(_tweet_list_entry_quote_name_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "reply_button_clicked_cb", G_CALLBACK(_tweet_list_entry_reply_button_clicked_cb_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "link_activated_cb", G_CALLBACK(_tweet_list_entry_link_activated_cb_gtk_label_activate_link));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "populate_popup_cb", G_CALLBACK(_tweet_list_entry_populate_popup_cb_gtk_label_populate_popup));
	_tmp0_ = g_type_class_ref (TYPE_TWEET_LIST_ENTRY);
	_tmp1_ = (GObjectClass*) _tmp0_;
	_tmp2_ = gtk_binding_set_by_class (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_type_class_unref0 (_tmp1_);
	binding_set = _tmp3_;
	_tmp4_ = binding_set;
	gtk_binding_entry_add_signal (_tmp4_, (guint) GDK_KEY_r, 0, "reply-tweet", (guint) 0, NULL, NULL);
	_tmp5_ = binding_set;
	gtk_binding_entry_add_signal (_tmp5_, (guint) GDK_KEY_d, 0, "delete-tweet", (guint) 0, NULL, NULL);
	_tmp6_ = binding_set;
	gtk_binding_entry_add_signal (_tmp6_, (guint) GDK_KEY_t, 0, "retweet-tweet", (guint) 0, NULL, NULL);
	_tmp7_ = binding_set;
	gtk_binding_entry_add_signal (_tmp7_, (guint) GDK_KEY_f, 0, "favorite-tweet", (guint) 0, NULL, NULL);
}


static void tweet_list_entry_itwitter_item_interface_init (ITwitterItemIface * iface) {
	tweet_list_entry_itwitter_item_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_time_delta = (gint (*)(ITwitterItem*, GDateTime*)) tweet_list_entry_real_update_time_delta;
	iface->get_sort_factor = tweet_list_entry_real_get_sort_factor;
}


static void tweet_list_entry_instance_init (TweetListEntry * self) {
	self->priv = TWEET_LIST_ENTRY_GET_PRIVATE (self);
	self->priv->_read_only = FALSE;
	self->priv->values_set = FALSE;
	self->priv->delete_first_activated = FALSE;
	g_type_ensure (TYPE_MULTI_MEDIA_WIDGET);
	g_type_ensure (TYPE_TEXT_BUTTON);
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_DOUBLE_TAP_BUTTON);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void tweet_list_entry_finalize (GObject* obj) {
	TweetListEntry * self;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GQuark _tmp3_ = 0U;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	_tmp0_ = settings_get ();
	_tmp1_ = _tmp0_;
	g_signal_parse_name ("changed::text-transform-flags", G_TYPE_SETTINGS, &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _tweet_list_entry_transform_flags_changed_cb_g_settings_changed, self);
	_g_object_unref0 (_tmp1_);
	_g_object_unref0 (self->priv->screen_name_label);
	_g_object_unref0 (self->priv->name_button);
	_g_object_unref0 (self->priv->time_delta_label);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->text_label);
	_g_object_unref0 (self->priv->rt_label);
	_g_object_unref0 (self->priv->rt_image);
	_g_object_unref0 (self->priv->conversation_image);
	_g_object_unref0 (self->priv->rt_status_image);
	_g_object_unref0 (self->priv->fav_status_image);
	_g_object_unref0 (self->priv->retweet_button);
	_g_object_unref0 (self->priv->favorite_button);
	_g_object_unref0 (self->priv->grid);
	_g_object_unref0 (self->priv->mm_widget);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->action_box);
	_g_object_unref0 (self->priv->quote_label);
	_g_object_unref0 (self->priv->quote_name);
	_g_object_unref0 (self->priv->quote_screen_name);
	_g_object_unref0 (self->priv->quote_grid);
	_g_object_unref0 (self->tweet);
	G_OBJECT_CLASS (tweet_list_entry_parent_class)->finalize (obj);
}


GType tweet_list_entry_get_type (void) {
	static volatile gsize tweet_list_entry_type_id__volatile = 0;
	if (g_once_init_enter (&tweet_list_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TweetListEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tweet_list_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TweetListEntry), 0, (GInstanceInitFunc) tweet_list_entry_instance_init, NULL };
		static const GInterfaceInfo itwitter_item_info = { (GInterfaceInitFunc) tweet_list_entry_itwitter_item_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType tweet_list_entry_type_id;
		tweet_list_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "TweetListEntry", &g_define_type_info, 0);
		g_type_add_interface_static (tweet_list_entry_type_id, TYPE_ITWITTER_ITEM, &itwitter_item_info);
		g_once_init_leave (&tweet_list_entry_type_id__volatile, tweet_list_entry_type_id);
	}
	return tweet_list_entry_type_id__volatile;
}


static void _vala_tweet_list_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_VISIBLE:
		g_value_set_boolean (value, tweet_list_entry_get_visible (self));
		break;
		case TWEET_LIST_ENTRY_SORT_FACTOR:
		g_value_set_int64 (value, itwitter_item_get_sort_factor (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ITWITTER_ITEM, ITwitterItem)));
		break;
		case TWEET_LIST_ENTRY_SHOWS_ACTIONS:
		g_value_set_boolean (value, tweet_list_entry_get_shows_actions (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tweet_list_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TweetListEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_TWEET_LIST_ENTRY, TweetListEntry);
	switch (property_id) {
		case TWEET_LIST_ENTRY_READ_ONLY:
		tweet_list_entry_set_read_only (self, g_value_get_boolean (value));
		break;
		case TWEET_LIST_ENTRY_VISIBLE:
		tweet_list_entry_set_visible (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



