/* Media.c generated by valac 0.30.0, the Vala compiler
 * generated from Media.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <float.h>
#include <math.h>


#define TYPE_MEDIA_TYPE (media_type_get_type ())

#define TYPE_MEDIA (media_get_type ())
#define MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA, Media))
#define MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA, MediaClass))
#define IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA))
#define IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA))
#define MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA, MediaClass))

typedef struct _Media Media;
typedef struct _MediaClass MediaClass;
typedef struct _MediaPrivate MediaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))

typedef enum  {
	MEDIA_TYPE_IMAGE,
	MEDIA_TYPE_VINE,
	MEDIA_TYPE_GIF,
	MEDIA_TYPE_ANIMATED_GIF,
	MEDIA_TYPE_TWITTER_VIDEO,
	MEDIA_TYPE_UNKNOWN
} MediaType;

struct _Media {
	GObject parent_instance;
	MediaPrivate * priv;
	gint64 id;
	gchar* path;
	gchar* thumb_path;
	gchar* url;
	MediaType type;
	cairo_surface_t* thumbnail;
	gboolean loaded;
	gboolean invalid;
};

struct _MediaClass {
	GObjectClass parent_class;
};

struct _MediaPrivate {
	gchar* _thumb_url;
	gchar* _target_url;
	gint64 _length;
	gdouble _percent_loaded;
};


static gpointer media_parent_class = NULL;

GType media_type_get_type (void) G_GNUC_CONST;
GType media_get_type (void) G_GNUC_CONST;
#define MEDIA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MEDIA, MediaPrivate))
enum  {
	MEDIA_DUMMY_PROPERTY,
	MEDIA_THUMB_URL,
	MEDIA_TARGET_URL,
	MEDIA_LENGTH,
	MEDIA_PERCENT_LOADED
};
MediaType media_type_from_string (const gchar* s);
MediaType media_type_from_url (const gchar* url);
Media* media_new (void);
Media* media_construct (GType object_type);
const gchar* media_get_thumb_url (Media* self);
void media_set_thumb_url (Media* self, const gchar* value);
const gchar* media_get_target_url (Media* self);
void media_set_target_url (Media* self, const gchar* value);
gint64 media_get_length (Media* self);
void media_set_length (Media* self, gint64 value);
gdouble media_get_percent_loaded (Media* self);
void media_set_percent_loaded (Media* self, gdouble value);
static void media_finalize (GObject* obj);
static void _vala_media_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_media_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType media_type_get_type (void) {
	static volatile gsize media_type_type_id__volatile = 0;
	if (g_once_init_enter (&media_type_type_id__volatile)) {
		static const GEnumValue values[] = {{MEDIA_TYPE_IMAGE, "MEDIA_TYPE_IMAGE", "image"}, {MEDIA_TYPE_VINE, "MEDIA_TYPE_VINE", "vine"}, {MEDIA_TYPE_GIF, "MEDIA_TYPE_GIF", "gif"}, {MEDIA_TYPE_ANIMATED_GIF, "MEDIA_TYPE_ANIMATED_GIF", "animated-gif"}, {MEDIA_TYPE_TWITTER_VIDEO, "MEDIA_TYPE_TWITTER_VIDEO", "twitter-video"}, {MEDIA_TYPE_UNKNOWN, "MEDIA_TYPE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		GType media_type_type_id;
		media_type_type_id = g_enum_register_static ("MediaType", values);
		g_once_init_leave (&media_type_type_id__volatile, media_type_type_id);
	}
	return media_type_type_id__volatile;
}


MediaType media_type_from_string (const gchar* s) {
	MediaType result = 0;
	const gchar* _tmp0_ = NULL;
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = s;
	if (g_strcmp0 (_tmp0_, "photo") == 0) {
		result = MEDIA_TYPE_IMAGE;
		return result;
	}
	result = MEDIA_TYPE_UNKNOWN;
	return result;
}


/**
   * Returns the type of a media based on its URL.
   * Do not call this unless you used InlineMediaDownloader.is_media_candidate
   * before.
   *
   * @param url The url to check
   *
   * @return The media type
   */
MediaType media_type_from_url (const gchar* url) {
	MediaType result = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	g_return_val_if_fail (url != NULL, 0);
	_tmp0_ = url;
	_tmp1_ = g_str_has_prefix (_tmp0_, "https://vine.co/v/");
	if (_tmp1_) {
		result = MEDIA_TYPE_VINE;
		return result;
	}
	_tmp2_ = url;
	_tmp3_ = g_str_has_suffix (_tmp2_, "/photo/1");
	if (_tmp3_) {
		result = MEDIA_TYPE_ANIMATED_GIF;
		return result;
	}
	_tmp4_ = url;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_str_has_suffix (_tmp6_, ".gif");
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	if (_tmp8_) {
		result = MEDIA_TYPE_GIF;
		return result;
	}
	result = MEDIA_TYPE_IMAGE;
	return result;
}


Media* media_construct (GType object_type) {
	Media * self = NULL;
	self = (Media*) g_object_new (object_type, NULL);
	return self;
}


Media* media_new (void) {
	return media_construct (TYPE_MEDIA);
}


const gchar* media_get_thumb_url (Media* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (IS_MEDIA (self), NULL);
	_tmp1_ = self->priv->_thumb_url;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->url;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


void media_set_thumb_url (Media* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_MEDIA (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_thumb_url);
	self->priv->_thumb_url = _tmp1_;
	g_object_notify ((GObject *) self, "thumb-url");
}


const gchar* media_get_target_url (Media* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_val_if_fail (IS_MEDIA (self), NULL);
	_tmp1_ = self->priv->_target_url;
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = self->url;
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}


void media_set_target_url (Media* self, const gchar* value) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (IS_MEDIA (self));
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_target_url);
	self->priv->_target_url = _tmp1_;
	g_object_notify ((GObject *) self, "target-url");
}


gint64 media_get_length (Media* self) {
	gint64 result;
	gint64 _tmp0_ = 0LL;
	g_return_val_if_fail (IS_MEDIA (self), 0LL);
	_tmp0_ = self->priv->_length;
	result = _tmp0_;
	return result;
}


void media_set_length (Media* self, gint64 value) {
	gint64 _tmp0_ = 0LL;
	g_return_if_fail (IS_MEDIA (self));
	_tmp0_ = value;
	self->priv->_length = _tmp0_;
	g_object_notify ((GObject *) self, "length");
}


gdouble media_get_percent_loaded (Media* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_MEDIA (self), 0.0);
	_tmp0_ = self->priv->_percent_loaded;
	result = _tmp0_;
	return result;
}


void media_set_percent_loaded (Media* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (IS_MEDIA (self));
	_tmp0_ = value;
	self->priv->_percent_loaded = _tmp0_;
	g_object_notify ((GObject *) self, "percent-loaded");
}


static void media_class_init (MediaClass * klass) {
	media_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MediaPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_media_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_media_set_property;
	G_OBJECT_CLASS (klass)->finalize = media_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_THUMB_URL, g_param_spec_string ("thumb-url", "thumb-url", "thumb-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_TARGET_URL, g_param_spec_string ("target-url", "target-url", "target-url", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_LENGTH, g_param_spec_int64 ("length", "length", "length", G_MININT64, G_MAXINT64, (gint64) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MEDIA_PERCENT_LOADED, g_param_spec_double ("percent-loaded", "percent-loaded", "percent-loaded", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("finished_loading", TYPE_MEDIA, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void media_instance_init (Media * self) {
	self->priv = MEDIA_GET_PRIVATE (self);
	self->priv->_thumb_url = NULL;
	self->priv->_length = (gint64) 0;
	self->priv->_percent_loaded = (gdouble) 0;
	self->thumbnail = NULL;
	self->loaded = FALSE;
	self->invalid = FALSE;
}


static void media_finalize (GObject* obj) {
	Media * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MEDIA, Media);
	_g_free0 (self->path);
	_g_free0 (self->thumb_path);
	_g_free0 (self->url);
	_g_free0 (self->priv->_thumb_url);
	_g_free0 (self->priv->_target_url);
	_cairo_surface_destroy0 (self->thumbnail);
	G_OBJECT_CLASS (media_parent_class)->finalize (obj);
}


GType media_get_type (void) {
	static volatile gsize media_type_id__volatile = 0;
	if (g_once_init_enter (&media_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MediaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) media_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Media), 0, (GInstanceInitFunc) media_instance_init, NULL };
		GType media_type_id;
		media_type_id = g_type_register_static (G_TYPE_OBJECT, "Media", &g_define_type_info, 0);
		g_once_init_leave (&media_type_id__volatile, media_type_id);
	}
	return media_type_id__volatile;
}


static void _vala_media_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Media * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA, Media);
	switch (property_id) {
		case MEDIA_THUMB_URL:
		g_value_set_string (value, media_get_thumb_url (self));
		break;
		case MEDIA_TARGET_URL:
		g_value_set_string (value, media_get_target_url (self));
		break;
		case MEDIA_LENGTH:
		g_value_set_int64 (value, media_get_length (self));
		break;
		case MEDIA_PERCENT_LOADED:
		g_value_set_double (value, media_get_percent_loaded (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_media_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Media * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MEDIA, Media);
	switch (property_id) {
		case MEDIA_THUMB_URL:
		media_set_thumb_url (self, g_value_get_string (value));
		break;
		case MEDIA_TARGET_URL:
		media_set_target_url (self, g_value_get_string (value));
		break;
		case MEDIA_LENGTH:
		media_set_length (self, g_value_get_int64 (value));
		break;
		case MEDIA_PERCENT_LOADED:
		media_set_percent_loaded (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



